/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Linear1DSet
extends Gridded1DSet
implements LinearSet {
    private double First;
    private double Last;
    private double Step;
    private double Invstep;

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int n = nArray.length;
        float[][] fArray = new float[1][n];
        int n2 = 0;
        while (n2 < n) {
            fArray[0][n2] = nArray[n2] >= 0 && nArray[n2] < this.Length ? (float)(this.First + (double)nArray[n2] * this.Step) : Float.NaN;
            ++n2;
        }
        return fArray;
    }

    public double[][] indexToDouble(int[] nArray) throws VisADException {
        int n = nArray.length;
        double[][] dArray = new double[1][n];
        int n2 = 0;
        while (n2 < n) {
            dArray[0][n2] = nArray[n2] >= 0 && nArray[n2] < this.Length ? this.First + (double)nArray[n2] * this.Step : Double.NaN;
            ++n2;
        }
        return dArray;
    }

    public int[] doubleToIndex(double[][] dArray) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Linear1DSet.doubleToIndex: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = dArray[0].length;
        int[] nArray = new int[n];
        double d = -0.5;
        double d2 = (double)this.Length - 0.5;
        int n2 = 0;
        while (n2 < n) {
            double d3 = 0.5 + (dArray[0][n2] - this.First) * this.Invstep;
            nArray[n2] = 0.0 < d3 && d3 < (double)this.Length ? (int)d3 : -1;
            ++n2;
        }
        return nArray;
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        if (fArray.length != 1) {
            throw new SetException("Linear1DSet.gridToValue: grid dimension should be 1, not " + fArray.length);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Linear1DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[1][n];
        float[] fArray3 = fArray2[0];
        float[] fArray4 = fArray[0];
        float f = -0.5f;
        float f2 = (float)this.Length - 0.5f;
        int n2 = 0;
        while (n2 < n) {
            float f3 = fArray4[n2];
            fArray3[n2] = (float)(f < f3 && f3 < f2 ? this.First + (double)f3 * this.Step : Double.NaN);
            ++n2;
        }
        return fArray2;
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        if (fArray.length != 1) {
            throw new SetException("Linear1DSet.valueToGrid: value dimension should be 1, not " + fArray.length);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Linear1DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[1][n];
        float[] fArray3 = fArray2[0];
        float[] fArray4 = fArray[0];
        float f = (float)(this.First + ((double)this.Length - 0.5) * this.Step);
        float f2 = (float)(this.First - 0.5 * this.Step);
        if (f < f2) {
            float f3 = f2;
            f2 = f;
            f = f3;
        }
        int n2 = 0;
        while (n2 < n) {
            float f4 = fArray4[n2];
            fArray3[n2] = (float)(f2 < f4 && f4 < f ? ((double)f4 - this.First) * this.Invstep : Double.NaN);
            ++n2;
        }
        return fArray2;
    }

    public double getFirst() {
        return this.First;
    }

    public double getLast() {
        return this.Last;
    }

    public double getStep() {
        return this.Step;
    }

    public double getInvstep() {
        return this.Invstep;
    }

    public boolean isMissing() {
        return false;
    }

    public double[][] getDoubles(boolean bl) throws VisADException {
        int n = this.getLength();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return this.indexToDouble(nArray);
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        int n = this.getLength();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return this.indexToValue(nArray);
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof Linear1DSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        try {
            bl = this.First == ((Linear1DSet)object).getFirst() && this.Last == ((Linear1DSet)object).getLast() && this.Length == ((Linear1DSet)object).getLength();
        }
        catch (VisADException visADException) {
            return false;
        }
        return bl;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ new Double(this.First).hashCode() ^ new Double(this.Last).hashCode() ^ this.Length;
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Linear1DSet getLinear1DComponent(int n) {
        if (n == 0) {
            return this;
        }
        throw new ArrayIndexOutOfBoundsException("Invalid component index " + n);
    }

    public Object clone() {
        try {
            return new Linear1DSet(this.Type, this.First, this.Last, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("Linear1DSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new Linear1DSet(mathType, this.First, this.Last, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String string) throws VisADException {
        return string + "Linear1DSet: Length = " + this.Length + " Range = " + this.First + " to " + this.Last + "\n";
    }

    public Linear1DSet(double d, double d2, int n) throws VisADException {
        this((MathType)RealType.Generic, d, d2, n, null, null, null);
    }

    public Linear1DSet(MathType mathType, double d, double d2, int n) throws VisADException {
        this(mathType, d, d2, n, null, null, null);
    }

    public Linear1DSet(MathType mathType, double d, double d2, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, null, n, coordinateSystem, unitArray, errorEstimateArray);
        if (this.DomainDimension != 1) {
            throw new SetException("Linear1DSet: DomainDimension must be 1, not " + this.DomainDimension);
        }
        this.First = d;
        this.Last = d2;
        this.Length = n;
        if (this.Length < 1) {
            throw new SetException("Linear1DSet: number of samples (" + this.Length + " must be greater than 1");
        }
        this.Step = this.Length < 2 ? 1.0 : (this.Last - this.First) / (double)(this.Length - 1);
        this.Invstep = 1.0 / this.Step;
        this.LowX = (float)Math.min(this.First, this.First + this.Step * (double)(this.Length - 1));
        this.HiX = (float)Math.max(this.First, this.First + this.Step * (double)(this.Length - 1));
        this.Low[0] = this.LowX;
        this.Hi[0] = this.HiX;
        if (this.SetErrors[0] != null) {
            this.SetErrors[0] = new ErrorEstimate(this.SetErrors[0].getErrorValue(), (double)(this.Low[0] + this.Hi[0]) / 2.0, this.Length, this.SetErrors[0].getUnit());
        }
    }
}

