/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.Delaunay;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.IrregularSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADLineArray;
import visad.VisADTriangleStripArray;

public class Irregular3DSet
extends IrregularSet {
    static final float EPS_0 = 1.0E-5f;
    static final int[] NTAB = new int[]{0, 1, 2, 1, 2, 0, 2, 0, 1, 0, 1, 3, 2, 1, 2, 0, 3, 2, 3, 1, 0, 3, 0, 2, 1, 0, 1, 4, 2, 3, 1, 2, 0, 3, 4, 2, 3, 1, 4, 0, 3, 4, 2, 0, 1, 4, 0, 3, 1, 2, 0, 1, 5, 2, 4, 3, 1, 2, 0, 3, 5, 4, 2, 3, 1, 4, 0, 5, 3, 4, 2, 5, 1, 0, 4, 5, 3, 0, 2, 1, 5, 0, 4, 1, 3, 2};
    static final int[] ITAB = new int[]{0, 2, 1, 1, 0, 2, 2, 1, 0, 0, 3, 1, 2, 1, 0, 2, 3, 2, 1, 3, 0, 3, 2, 0, 1, 0, 4, 1, 3, 2, 1, 0, 2, 4, 3, 2, 1, 3, 0, 4, 3, 2, 4, 1, 0, 4, 3, 0, 2, 1, 0, 5, 1, 4, 2, 3, 1, 0, 2, 5, 3, 4, 2, 1, 3, 0, 4, 5, 3, 2, 4, 1, 5, 0, 4, 3, 5, 2, 0, 1, 5, 4, 0, 3, 1, 2};
    static final int[] STAB = new int[]{0, 9, 25, 50};
    private float LowX;
    private float HiX;
    private float LowY;
    private float HiY;
    private float LowZ;
    private float HiZ;

    public Set makeSpatial(SetType setType, float[][] fArray) throws VisADException {
        if (fArray.length == 3) {
            if (this.ManifoldDimension == 1) {
                return new Irregular3DSet((MathType)setType, fArray, this.newToOld, this.oldToNew, null, null, null, false);
            }
            if (this.Delan.Tri == null || this.Delan.Tri.length == 0) {
                return null;
            }
            return new Irregular3DSet((MathType)setType, fArray, null, null, null, this.Delan, false);
        }
        throw new SetException("Irregular3DSet.makeSpatial: bad samples length");
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        float[][] fArray = new float[3][nArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0 && nArray[n] < this.Length) {
                fArray[0][n] = this.Samples[0][nArray[n]];
                fArray[1][n] = this.Samples[1][nArray[n]];
                fArray[2][n] = this.Samples[2][nArray[n]];
            } else {
                fArray[2][n] = Float.NaN;
                fArray[1][n] = Float.NaN;
                fArray[0][n] = Float.NaN;
            }
            ++n;
        }
        return fArray;
    }

    public int[] valueToTri(float[][] fArray) throws VisADException {
        if (this.ManifoldDimension != 3) {
            throw new SetException("Irregular3DSet.valueToTri: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        int n = fArray[0].length;
        if (n != fArray[1].length || n != fArray[2].length) {
            throw new SetException("Irregular3DSet.valueToTri: lengths don't match");
        }
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        float[] fArray4 = new float[3];
        float[] fArray5 = new float[3];
        float[] fArray6 = new float[3];
        float[] fArray7 = new float[3];
        float[] fArray8 = new float[3];
        float[] fArray9 = new float[3];
        boolean[] blArray = new boolean[this.Delan.Tri.length];
        int n2 = 0;
        while (n2 < blArray.length) {
            blArray[n2] = false;
            ++n2;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            int n5;
            boolean bl = false;
            nArray[n4] = -1;
            boolean bl2 = false;
            if (n3 < 0) {
                n3 = 0;
            }
            int n6 = 0;
            while (n6 < this.Delan.Tri.length && !bl2) {
                int n7;
                int n8;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                boolean bl6;
                n5 = this.Delan.Tri[n3][0];
                int n9 = this.Delan.Tri[n3][1];
                int n10 = this.Delan.Tri[n3][2];
                int n11 = this.Delan.Tri[n3][3];
                float f = this.Samples[0][n5];
                float f2 = this.Samples[1][n5];
                float f3 = this.Samples[2][n5];
                float f4 = this.Samples[0][n9];
                float f5 = this.Samples[1][n9];
                float f6 = this.Samples[2][n9];
                float f7 = this.Samples[0][n10];
                float f8 = this.Samples[1][n10];
                float f9 = this.Samples[2][n10];
                float f10 = this.Samples[0][n11];
                float f11 = this.Samples[1][n11];
                float f12 = this.Samples[2][n11];
                float f13 = fArray[0][n4];
                float f14 = fArray[1][n4];
                float f15 = fArray[2][n4];
                fArray2[0] = f13 - f;
                fArray2[1] = f14 - f2;
                fArray2[2] = f15 - f3;
                fArray3[0] = f13 - f4;
                fArray3[1] = f14 - f5;
                fArray3[2] = f15 - f6;
                fArray4[0] = f13 - f7;
                fArray4[1] = f14 - f8;
                fArray4[2] = f15 - f9;
                fArray5[0] = f13 - f10;
                fArray5[1] = f14 - f11;
                fArray5[2] = f15 - f12;
                fArray6[0] = (f5 - f2) * (f9 - f6) - (f6 - f3) * (f8 - f5);
                fArray6[1] = (f6 - f3) * (f7 - f4) - (f4 - f) * (f9 - f6);
                fArray6[2] = (f4 - f) * (f8 - f5) - (f5 - f2) * (f7 - f4);
                float f16 = fArray6[0] + fArray6[1] + fArray6[2];
                fArray7[0] = (f8 - f5) * (f12 - f9) - (f9 - f6) * (f11 - f8);
                fArray7[1] = (f9 - f6) * (f10 - f7) - (f7 - f4) * (f12 - f9);
                fArray7[2] = (f7 - f4) * (f11 - f8) - (f8 - f5) * (f10 - f7);
                float f17 = fArray7[0] + fArray7[1] + fArray7[2];
                fArray8[0] = (f11 - f8) * (f3 - f12) - (f12 - f9) * (f2 - f11);
                fArray8[1] = (f12 - f9) * (f - f10) - (f10 - f7) * (f3 - f12);
                fArray8[2] = (f10 - f7) * (f2 - f11) - (f11 - f8) * (f - f10);
                float f18 = fArray8[0] + fArray8[1] + fArray8[2];
                fArray9[0] = (f2 - f11) * (f6 - f3) - (f3 - f12) * (f5 - f2);
                fArray9[1] = (f3 - f12) * (f4 - f) - (f - f10) * (f6 - f3);
                fArray9[2] = (f - f10) * (f5 - f2) - (f2 - f11) * (f4 - f);
                float f19 = fArray9[0] + fArray9[1] + fArray9[2];
                float f20 = fArray6[0] * fArray2[0] + fArray6[1] * fArray2[1] + fArray6[2] * fArray2[2];
                float f21 = fArray7[0] * fArray3[0] + fArray7[1] * fArray3[1] + fArray7[2] * fArray3[2];
                float f22 = fArray8[0] * fArray4[0] + fArray8[1] * fArray4[1] + fArray8[2] * fArray4[2];
                float f23 = fArray9[0] * fArray5[0] + fArray9[1] * fArray5[1] + fArray9[2] * fArray5[2];
                boolean bl7 = f20 != 0.0f && f20 > 0.0f != fArray6[0] * (f10 - f) + fArray6[1] * (f11 - f2) + fArray6[2] * (f12 - f3) > 0.0f || f16 == 0.0f ? false : (bl6 = true);
                boolean bl8 = f21 != 0.0f && f21 > 0.0f != fArray7[0] * (f - f4) + fArray7[1] * (f2 - f5) + fArray7[2] * (f3 - f6) > 0.0f || f17 == 0.0f ? false : (bl5 = true);
                boolean bl9 = f22 != 0.0f && f22 > 0.0f != fArray8[0] * (f4 - f7) + fArray8[1] * (f5 - f8) + fArray8[2] * (f6 - f9) > 0.0f || f18 == 0.0f ? false : (bl4 = true);
                boolean bl10 = f23 != 0.0f && f23 > 0.0f != fArray9[0] * (f7 - f10) + fArray9[1] * (f8 - f11) + fArray9[2] * (f9 - f12) > 0.0f || f19 == 0.0f ? false : (bl3 = true);
                if (!bl6) {
                    blArray[n3] = true;
                    n8 = this.Delan.Walk[n3][0];
                    if (n8 != -1) {
                        if (blArray[n8]) {
                            bl = true;
                            n7 = 0;
                            while (n7 < blArray.length) {
                                if (!blArray[n7]) {
                                    n3 = n7;
                                    break;
                                }
                                ++n7;
                            }
                        } else {
                            n3 = n8;
                        }
                    } else if (!bl) {
                        n3 = n8;
                    } else {
                        n7 = 0;
                        while (n7 < blArray.length) {
                            if (!blArray[n7]) {
                                n3 = n7;
                                break;
                            }
                            ++n7;
                        }
                    }
                } else if (!bl5) {
                    blArray[n3] = true;
                    n8 = this.Delan.Walk[n3][1];
                    if (n8 != -1) {
                        if (blArray[n8]) {
                            bl = true;
                            n7 = 0;
                            while (n7 < blArray.length) {
                                if (!blArray[n7]) {
                                    n3 = n7;
                                    break;
                                }
                                ++n7;
                            }
                        } else {
                            n3 = n8;
                        }
                    } else if (!bl) {
                        n3 = n8;
                    } else {
                        n7 = 0;
                        while (n7 < blArray.length) {
                            if (!blArray[n7]) {
                                n3 = n7;
                                break;
                            }
                            ++n7;
                        }
                    }
                } else if (!bl4) {
                    blArray[n3] = true;
                    n8 = this.Delan.Walk[n3][2];
                    if (n8 != -1) {
                        if (blArray[n8]) {
                            bl = true;
                            n7 = 0;
                            while (n7 < blArray.length) {
                                if (!blArray[n7]) {
                                    n3 = n7;
                                    break;
                                }
                                ++n7;
                            }
                        } else {
                            n3 = n8;
                        }
                    } else if (!bl) {
                        n3 = n8;
                    } else {
                        n7 = 0;
                        while (n7 < blArray.length) {
                            if (!blArray[n7]) {
                                n3 = n7;
                                break;
                            }
                            ++n7;
                        }
                    }
                } else if (!bl3) {
                    blArray[n3] = true;
                    n8 = this.Delan.Walk[n3][3];
                    if (n8 != -1) {
                        if (blArray[n8]) {
                            bl = true;
                            n7 = 0;
                            while (n7 < blArray.length) {
                                if (!blArray[n7]) {
                                    n3 = n7;
                                    break;
                                }
                                ++n7;
                            }
                        } else {
                            n3 = n8;
                        }
                    } else if (!bl) {
                        n3 = n8;
                    } else {
                        n7 = 0;
                        while (n7 < blArray.length) {
                            if (!blArray[n7]) {
                                n3 = n7;
                                break;
                            }
                            ++n7;
                        }
                    }
                } else {
                    bl2 = true;
                }
                if (n3 < 0) {
                    bl2 = true;
                }
                if (bl2) {
                    nArray[n4] = n3;
                }
                ++n6;
            }
            if (bl) {
                n5 = 0;
                while (n5 < blArray.length) {
                    blArray[n5] = false;
                    ++n5;
                }
            }
            ++n4;
        }
        return nArray;
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        if (fArray.length < this.DomainDimension) {
            throw new SetException("Irregular3DSet.valueToIndex: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int[] nArray = this.valueToTri(fArray);
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0) {
                nArray2[n] = -1;
            } else {
                float f = fArray[0][n];
                float f2 = fArray[1][n];
                float f3 = fArray[2][n];
                int n2 = nArray[n];
                int n3 = this.Delan.Tri[n2][0];
                int n4 = this.Delan.Tri[n2][1];
                int n5 = this.Delan.Tri[n2][2];
                int n6 = this.Delan.Tri[n2][3];
                float f4 = this.Samples[0][n3] - f;
                float f5 = this.Samples[1][n3] - f2;
                float f6 = this.Samples[2][n3] - f3;
                float f7 = this.Samples[0][n4] - f;
                float f8 = this.Samples[1][n4] - f2;
                float f9 = this.Samples[2][n4] - f3;
                float f10 = this.Samples[0][n5] - f;
                float f11 = this.Samples[1][n5] - f2;
                float f12 = this.Samples[2][n5] - f3;
                float f13 = this.Samples[0][n6] - f;
                float f14 = this.Samples[1][n6] - f2;
                float f15 = this.Samples[2][n6] - f3;
                float f16 = f4 * f4 + f5 * f5 + f6 * f6;
                float f17 = f7 * f7 + f8 * f8 + f9 * f9;
                float f18 = f10 * f10 + f11 * f11 + f12 * f12;
                float f19 = f13 * f13 + f14 * f14 + f15 * f15;
                float f20 = Math.min(f16, f17);
                f20 = Math.min(f20, f18);
                nArray2[n] = (f20 = Math.min(f20, f19)) == f16 ? n3 : (f20 == f17 ? n4 : (f20 == f18 ? n5 : n6));
            }
            ++n;
        }
        return nArray2;
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        if (fArray.length < this.DomainDimension) {
            throw new SetException("Irregular3DSet.valueToInterp: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = fArray[0].length;
        if (nArray.length < n || fArray2.length < n) {
            throw new SetException("Irregular3DSet.valueToInterp: lengths don't match");
        }
        int[] nArray2 = this.valueToTri(fArray);
        int n2 = 0;
        while (n2 < nArray2.length) {
            if (nArray2[n2] < 0) {
                nArray[n2] = null;
                fArray2[n2] = null;
            } else {
                int[] nArray3 = new int[4];
                float[] fArray3 = new float[4];
                float f = fArray[0][n2];
                float f2 = fArray[1][n2];
                float f3 = fArray[2][n2];
                int n3 = nArray2[n2];
                int n4 = this.Delan.Tri[n3][0];
                int n5 = this.Delan.Tri[n3][1];
                int n6 = this.Delan.Tri[n3][2];
                int n7 = this.Delan.Tri[n3][3];
                nArray3[0] = n4;
                nArray3[1] = n5;
                nArray3[2] = n6;
                nArray3[3] = n7;
                float f4 = this.Samples[0][n4];
                float f5 = this.Samples[1][n4];
                float f6 = this.Samples[2][n4];
                float f7 = this.Samples[0][n5];
                float f8 = this.Samples[1][n5];
                float f9 = this.Samples[2][n5];
                float f10 = this.Samples[0][n6];
                float f11 = this.Samples[1][n6];
                float f12 = this.Samples[2][n6];
                float f13 = this.Samples[0][n7];
                float f14 = this.Samples[1][n7];
                float f15 = this.Samples[2][n7];
                float f16 = (f14 - f8) * (f12 - f9) - (f15 - f9) * (f11 - f8);
                float f17 = (f15 - f9) * (f10 - f7) - (f13 - f7) * (f12 - f9);
                float f18 = (f13 - f7) * (f11 - f8) - (f14 - f8) * (f10 - f7);
                float f19 = (f14 - f5) * (f12 - f6) - (f15 - f6) * (f11 - f5);
                float f20 = (f15 - f6) * (f10 - f4) - (f13 - f4) * (f12 - f6);
                float f21 = (f13 - f4) * (f11 - f5) - (f14 - f5) * (f10 - f4);
                float f22 = (f14 - f5) * (f9 - f6) - (f15 - f6) * (f8 - f5);
                float f23 = (f15 - f6) * (f7 - f4) - (f13 - f4) * (f9 - f6);
                float f24 = (f13 - f4) * (f8 - f5) - (f14 - f5) * (f7 - f4);
                float f25 = (f11 - f5) * (f9 - f6) - (f12 - f6) * (f8 - f5);
                float f26 = (f12 - f6) * (f7 - f4) - (f10 - f4) * (f9 - f6);
                float f27 = (f10 - f4) * (f8 - f5) - (f11 - f5) * (f7 - f4);
                fArray3[0] = ((f - f7) * f16 + (f2 - f8) * f17 + (f3 - f9) * f18) / ((f4 - f7) * f16 + (f5 - f8) * f17 + (f6 - f9) * f18);
                fArray3[1] = ((f - f4) * f19 + (f2 - f5) * f20 + (f3 - f6) * f21) / ((f7 - f4) * f19 + (f8 - f5) * f20 + (f9 - f6) * f21);
                fArray3[2] = ((f - f4) * f22 + (f2 - f5) * f23 + (f3 - f6) * f24) / ((f10 - f4) * f22 + (f11 - f5) * f23 + (f12 - f6) * f24);
                fArray3[3] = ((f - f4) * f25 + (f2 - f5) * f26 + (f3 - f6) * f27) / ((f13 - f4) * f25 + (f14 - f5) * f26 + (f15 - f6) * f27);
                nArray[n2] = nArray3;
                fArray2[n2] = fArray3;
            }
            ++n2;
        }
    }

    public VisADGeometryArray[] makeIsoLines(float[] fArray, float f, float f2, float f3, float[] fArray2, byte[][] byArray, boolean[] blArray, boolean bl) throws VisADException {
        if (this.ManifoldDimension != 2) {
            throw new DisplayException("Irregular3DSet.makeIsoLines: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        if (fArray == null) {
            return null;
        }
        int[][] nArray = this.Delan.Tri;
        float[][] fArray3 = this.getSamples(false);
        int n = nArray.length;
        int n2 = this.Delan.Vertices.length;
        if (n < 1 || n2 < 3) {
            return null;
        }
        int n3 = 4 * this.Length;
        int n4 = byArray != null ? byArray.length : 0;
        byte[][] byArray2 = null;
        if (n4 > 0) {
            if (n4 > 3) {
                n4 = 3;
            }
            byArray2 = new byte[n4][n3];
        }
        float[] fArray4 = new float[n3];
        float[] fArray5 = new float[n3];
        float[] fArray6 = new float[n3];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            float f4;
            float f5;
            int n7 = nArray[n6][0];
            int n8 = nArray[n6][1];
            int n9 = nArray[n6][2];
            float f6 = fArray2[n7];
            if (f6 == f6 && (f5 = fArray2[n8]) == f5 && (f4 = fArray2[n9]) == f4) {
                byte[] byArray3 = null;
                byte[] byArray4 = null;
                byte[] byArray5 = null;
                if (n4 > 0) {
                    byArray3 = new byte[n4];
                    byArray4 = new byte[n4];
                    byArray5 = new byte[n4];
                    int n10 = 0;
                    while (n10 < n4) {
                        byArray3[n10] = byArray[n10][n7];
                        byArray4[n10] = byArray[n10][n8];
                        byArray5[n10] = byArray[n10][n9];
                        ++n10;
                    }
                }
                float f7 = f6 < f5 ? f6 : f5;
                f7 = f4 < f7 ? f4 : f7;
                float f8 = f6 > f5 ? f6 : f5;
                f8 = f4 > f8 ? f4 : f8;
                int n11 = 0;
                while (n11 < fArray.length) {
                    float f9 = fArray[n11];
                    if (n5 + 8 >= n3) {
                        n3 = 2 * n3;
                        byte[][] byArray6 = byArray2;
                        byArray2 = new byte[n4][n3];
                        int n12 = 0;
                        while (n12 < n4) {
                            System.arraycopy(byArray6[n12], 0, byArray2[n12], 0, n5);
                            ++n12;
                        }
                        float[] fArray7 = fArray4;
                        float[] fArray8 = fArray5;
                        float[] fArray9 = fArray6;
                        fArray4 = new float[n3];
                        fArray5 = new float[n3];
                        fArray6 = new float[n3];
                        System.arraycopy(fArray7, 0, fArray4, 0, n5);
                        System.arraycopy(fArray8, 0, fArray5, 0, n5);
                        System.arraycopy(fArray9, 0, fArray6, 0, n5);
                    }
                    if (!(f9 < f7)) {
                        if (f9 > f8) break;
                        if (!(f9 < f)) {
                            if (f9 > f2) break;
                            int n13 = 0;
                            if (f9 > f6) {
                                n13 = 1;
                            }
                            if (f9 > f5) {
                                n13 += 2;
                            }
                            if (f9 > f4) {
                                n13 += 4;
                            }
                            if (n13 > 3) {
                                n13 = 7 - n13;
                            }
                            if (n13 > 0) {
                                switch (n13) {
                                    case 1: {
                                        int n14;
                                        int n15;
                                        float f10 = f5 - f6;
                                        float f11 = f4 - f6;
                                        float f12 = (f9 - f6) / f10;
                                        float f13 = (f9 - f6) / f11;
                                        if (n4 > 0) {
                                            n15 = 0;
                                            while (n15 < n4) {
                                                n14 = (int)((1.0f - f12) * (byArray3[n15] < 0 ? (float)byArray3[n15] + 256.0f : (float)byArray3[n15]) + f12 * (byArray4[n15] < 0 ? (float)byArray4[n15] + 256.0f : (float)byArray4[n15]));
                                                byArray2[n15][n5] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                                                n14 = (int)((1.0f - f13) * (byArray3[n15] < 0 ? (float)byArray3[n15] + 256.0f : (float)byArray3[n15]) + f13 * (byArray5[n15] < 0 ? (float)byArray5[n15] + 256.0f : (float)byArray5[n15]));
                                                byArray2[n15][n5 + 1] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                                                ++n15;
                                            }
                                        }
                                        fArray4[n5] = fArray3[0][n7] + (fArray3[0][n8] - fArray3[0][n7]) * f12;
                                        fArray5[n5] = fArray3[1][n7] + (fArray3[1][n8] - fArray3[1][n7]) * f12;
                                        fArray6[n5] = fArray3[2][n7] + (fArray3[2][n8] - fArray3[2][n7]) * f12;
                                        fArray4[++n5] = fArray3[0][n7] + (fArray3[0][n9] - fArray3[0][n7]) * f13;
                                        fArray5[n5] = fArray3[1][n7] + (fArray3[1][n9] - fArray3[1][n7]) * f13;
                                        fArray6[n5] = fArray3[2][n7] + (fArray3[2][n9] - fArray3[2][n7]) * f13;
                                        ++n5;
                                        break;
                                    }
                                    case 2: {
                                        int n14;
                                        int n15;
                                        float f14 = f5 - f6;
                                        float f15 = f4 - f5;
                                        float f16 = (f9 - f6) / f14;
                                        float f17 = (f9 - f5) / f15;
                                        if (n4 > 0) {
                                            n15 = 0;
                                            while (n15 < n4) {
                                                n14 = (int)((1.0f - f16) * (byArray3[n15] < 0 ? (float)byArray3[n15] + 256.0f : (float)byArray3[n15]) + f16 * (byArray4[n15] < 0 ? (float)byArray4[n15] + 256.0f : (float)byArray4[n15]));
                                                byArray2[n15][n5] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                                                n14 = (int)((1.0f - f17) * (byArray4[n15] < 0 ? (float)byArray4[n15] + 256.0f : (float)byArray4[n15]) + f17 * (byArray5[n15] < 0 ? (float)byArray5[n15] + 256.0f : (float)byArray5[n15]));
                                                byArray2[n15][n5 + 1] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                                                ++n15;
                                            }
                                        }
                                        fArray4[n5] = fArray3[0][n7] + (fArray3[0][n8] - fArray3[0][n7]) * f16;
                                        fArray5[n5] = fArray3[1][n7] + (fArray3[1][n8] - fArray3[1][n7]) * f16;
                                        fArray6[n5] = fArray3[2][n7] + (fArray3[2][n8] - fArray3[2][n7]) * f16;
                                        fArray4[++n5] = fArray3[0][n8] + (fArray3[0][n9] - fArray3[0][n8]) * f17;
                                        fArray5[n5] = fArray3[1][n8] + (fArray3[1][n9] - fArray3[1][n8]) * f17;
                                        fArray6[n5] = fArray3[2][n8] + (fArray3[2][n9] - fArray3[2][n8]) * f17;
                                        ++n5;
                                        break;
                                    }
                                    case 3: {
                                        int n14;
                                        int n15;
                                        float f18 = f4 - f6;
                                        float f19 = f4 - f5;
                                        float f13 = (f9 - f6) / f18;
                                        float f17 = (f9 - f5) / f19;
                                        if (n4 > 0) {
                                            n15 = 0;
                                            while (n15 < n4) {
                                                n14 = (int)((1.0f - f13) * (byArray3[n15] < 0 ? (float)byArray3[n15] + 256.0f : (float)byArray3[n15]) + f13 * (byArray5[n15] < 0 ? (float)byArray5[n15] + 256.0f : (float)byArray5[n15]));
                                                byArray2[n15][n5] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                                                n14 = (int)((1.0f - f17) * (byArray4[n15] < 0 ? (float)byArray4[n15] + 256.0f : (float)byArray4[n15]) + f17 * (byArray5[n15] < 0 ? (float)byArray5[n15] + 256.0f : (float)byArray5[n15]));
                                                byArray2[n15][n5 + 1] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                                                ++n15;
                                            }
                                        }
                                        fArray4[n5] = fArray3[0][n7] + (fArray3[0][n9] - fArray3[0][n7]) * f13;
                                        fArray5[n5] = fArray3[1][n7] + (fArray3[1][n9] - fArray3[1][n7]) * f13;
                                        fArray6[n5] = fArray3[2][n7] + (fArray3[2][n9] - fArray3[2][n7]) * f13;
                                        fArray4[++n5] = fArray3[0][n8] + (fArray3[0][n9] - fArray3[0][n8]) * f17;
                                        fArray5[n5] = fArray3[1][n8] + (fArray3[1][n9] - fArray3[1][n8]) * f17;
                                        fArray6[n5] = fArray3[2][n8] + (fArray3[2][n9] - fArray3[2][n8]) * f17;
                                        ++n5;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    ++n11;
                }
            }
            ++n6;
        }
        VisADGeometryArray[] visADGeometryArrayArray = new VisADLineArray[3];
        visADGeometryArrayArray[0] = new VisADLineArray();
        float[][] fArray10 = new float[3][n5];
        System.arraycopy(fArray4, 0, fArray10[0], 0, n5);
        System.arraycopy(fArray5, 0, fArray10[1], 0, n5);
        System.arraycopy(fArray6, 0, fArray10[2], 0, n5);
        fArray4 = null;
        fArray5 = null;
        fArray6 = null;
        byte[][] byArray7 = null;
        if (n4 > 0) {
            byArray7 = new byte[3][n5];
            System.arraycopy(byArray2[0], 0, byArray7[0], 0, n5);
            System.arraycopy(byArray2[1], 0, byArray7[1], 0, n5);
            System.arraycopy(byArray2[2], 0, byArray7[2], 0, n5);
            byArray2 = null;
        }
        SampledSet.setGeometryArray(visADGeometryArrayArray[0], fArray10, 3, byArray7);
        visADGeometryArrayArray[1] = null;
        visADGeometryArrayArray[2] = null;
        return visADGeometryArrayArray;
    }

    public VisADGeometryArray makeIsoSurface(float f, float[] fArray, byte[][] byArray, boolean bl) throws VisADException {
        if (this.ManifoldDimension != 3) {
            throw new DisplayException("Irregular3DSet.main_isosurf: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        float[][] fArray2 = new float[3][];
        byte[][] byArray2 = null;
        if (byArray != null) {
            byArray2 = new byte[byArray.length][];
        }
        int[][][] nArray = new int[1][][];
        int[][][] nArray2 = new int[1][][];
        this.makeIsosurface(f, fArray, byArray, fArray2, byArray2, nArray, nArray2);
        int n = nArray2[0].length;
        int n2 = nArray[0].length;
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        float[] fArray5 = new float[n];
        if (n == 0 || n2 == 0) {
            return null;
        }
        float[] fArray6 = new float[n2];
        float[] fArray7 = new float[n2];
        float[] fArray8 = new float[n2];
        float[] fArray9 = new float[n2];
        float[] fArray10 = new float[n2];
        float[] fArray11 = new float[n2];
        float[] fArray12 = new float[n2];
        float[] fArray13 = new float[n2];
        float[] fArray14 = new float[n2];
        Irregular3DSet.make_normals(fArray2[0], fArray2[1], fArray2[2], fArray3, fArray4, fArray5, n, n2, fArray12, fArray13, fArray14, fArray6, fArray7, fArray8, fArray9, fArray10, fArray11, nArray2[0], nArray[0]);
        fArray14 = null;
        fArray13 = null;
        fArray12 = null;
        fArray11 = null;
        fArray10 = null;
        fArray9 = null;
        fArray8 = null;
        fArray7 = null;
        fArray6 = null;
        float[] fArray15 = new float[3 * n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            fArray15[n3++] = fArray3[n4];
            fArray15[n3++] = fArray4[n4];
            fArray15[n3++] = fArray5[n4];
            ++n4;
        }
        fArray5 = null;
        fArray4 = null;
        fArray3 = null;
        int[] nArray3 = new int[6 * n2];
        int n5 = Irregular3DSet.poly_triangle_stripe(nArray3, n, n2, nArray2[0], nArray[0]);
        nArray2 = null;
        nArray = null;
        if (bl) {
            VisADIndexedTriangleStripArray visADIndexedTriangleStripArray = new VisADIndexedTriangleStripArray();
            visADIndexedTriangleStripArray.indexCount = n5;
            visADIndexedTriangleStripArray.indices = new int[n5];
            System.arraycopy(nArray3, 0, visADIndexedTriangleStripArray.indices, 0, n5);
            visADIndexedTriangleStripArray.stripVertexCounts = new int[1];
            visADIndexedTriangleStripArray.stripVertexCounts[0] = n5;
            nArray3 = null;
            SampledSet.setGeometryArray(visADIndexedTriangleStripArray, fArray2, 4, byArray2);
            fArray2 = null;
            byArray2 = null;
            visADIndexedTriangleStripArray.normals = fArray15;
            return visADIndexedTriangleStripArray;
        }
        VisADTriangleStripArray visADTriangleStripArray = new VisADTriangleStripArray();
        visADTriangleStripArray.stripVertexCounts = new int[]{n5};
        visADTriangleStripArray.vertexCount = n5;
        visADTriangleStripArray.normals = new float[3 * n5];
        int n6 = 0;
        int n7 = 0;
        while (n7 < 3 * n5) {
            n3 = 3 * nArray3[n6];
            visADTriangleStripArray.normals[n7] = fArray15[n3];
            visADTriangleStripArray.normals[n7 + 1] = fArray15[n3 + 1];
            visADTriangleStripArray.normals[n7 + 2] = fArray15[n3 + 2];
            ++n6;
            n7 += 3;
        }
        fArray15 = null;
        visADTriangleStripArray.coordinates = new float[3 * n5];
        n6 = 0;
        n7 = 0;
        while (n7 < 3 * n5) {
            n3 = nArray3[n6];
            visADTriangleStripArray.coordinates[n7] = fArray2[0][n3];
            visADTriangleStripArray.coordinates[n7 + 1] = fArray2[1][n3];
            visADTriangleStripArray.coordinates[n7 + 2] = fArray2[2][n3];
            ++n6;
            n7 += 3;
        }
        fArray2 = null;
        if (byArray2 != null) {
            n7 = byArray2.length;
            visADTriangleStripArray.colors = new byte[n7 * n5];
            n6 = 0;
            if (n7 == 4) {
                int n8 = 0;
                while (n8 < n7 * n5) {
                    n3 = nArray3[n6];
                    visADTriangleStripArray.colors[n8] = byArray2[0][n3];
                    visADTriangleStripArray.colors[n8 + 1] = byArray2[1][n3];
                    visADTriangleStripArray.colors[n8 + 2] = byArray2[2][n3];
                    visADTriangleStripArray.colors[n8 + 3] = byArray2[3][n3];
                    ++n6;
                    n8 += n7;
                }
            } else {
                int n9 = 0;
                while (n9 < n7 * n5) {
                    n3 = nArray3[n6];
                    visADTriangleStripArray.colors[n9] = byArray2[0][n3];
                    visADTriangleStripArray.colors[n9 + 1] = byArray2[1][n3];
                    visADTriangleStripArray.colors[n9 + 2] = byArray2[2][n3];
                    ++n6;
                    n9 += n7;
                }
            }
        }
        byArray2 = null;
        nArray3 = null;
        return visADTriangleStripArray;
    }

    private void makeIsosurface(float f, float[] fArray, byte[][] byArray, float[][] fArray2, byte[][] byArray2, int[][][] nArray, int[][][] nArray2) throws VisADException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl = false;
        if (this.ManifoldDimension != 3) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        if (fArray.length != this.Length) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: fieldValues length does't match");
        }
        if (Double.isNaN(f)) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: isolevel cannot be missing");
        }
        if (fArray2.length != 3 || nArray.length != 1 || nArray2.length != 1) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: return value arrays not correctly initialized " + fArray2.length + " " + nArray.length + " " + nArray2.length);
        }
        int n7 = n6 = byArray != null ? byArray.length : 0;
        if (n6 > 0) {
            if (byArray2 == null || byArray2.length != n6) {
                throw new DisplayException("Irregular3DSet.makeIsosurface: auxLevels length doesn't match");
            }
            n5 = 0;
            while (n5 < n6) {
                if (byArray[n5].length != this.Length) {
                    throw new DisplayException("Irregular3DSet.makeIsosurface: auxValues lengths don't match");
                }
                ++n5;
            }
        } else if (byArray2 != null) {
            throw new DisplayException("Irregular3DSet.makeIsosurface: auxValues null but auxLevels not null");
        }
        if (bl) {
            System.out.println("isolevel = " + f + "\n");
            System.out.println("fieldValues " + fArray.length);
            n5 = 0;
            while (n5 < fArray.length) {
                System.out.println("  " + n5 + " -> " + fArray[n5]);
                ++n5;
            }
            System.out.println(this.Delan.sampleString(this.Samples));
        }
        n5 = this.Delan.Tri.length;
        int[][] nArray3 = new int[n5][4];
        int[] nArray4 = new int[this.Delan.NumEdges];
        int n8 = 0;
        while (n8 < this.Delan.NumEdges) {
            nArray4[n8] = -1;
            ++n8;
        }
        float[][] fArray3 = new float[this.DomainDimension][this.Delan.NumEdges];
        int n9 = 0;
        while (n9 < this.Delan.NumEdges) {
            fArray3[0][n9] = Float.NaN;
            ++n9;
        }
        byte[][] byArray3 = n6 > 0 ? new byte[n6][this.Delan.NumEdges] : null;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n5) {
            n4 = this.Delan.Tri[n12][0];
            n3 = this.Delan.Tri[n12][1];
            n2 = this.Delan.Tri[n12][2];
            n = this.Delan.Tri[n12][3];
            float f2 = fArray[n4];
            float f3 = fArray[n3];
            float f4 = fArray[n2];
            float f5 = fArray[n];
            float f6 = this.Samples[0][n] - this.Samples[0][n4];
            float f7 = this.Samples[1][n] - this.Samples[1][n4];
            float f8 = this.Samples[2][n] - this.Samples[2][n4];
            float f9 = this.Samples[0][n2] - this.Samples[0][n4];
            float f10 = this.Samples[1][n2] - this.Samples[1][n4];
            float f11 = this.Samples[2][n2] - this.Samples[2][n4];
            float f12 = this.Samples[0][n3] - this.Samples[0][n4];
            float f13 = this.Samples[1][n3] - this.Samples[1][n4];
            float f14 = this.Samples[2][n3] - this.Samples[2][n4];
            float f15 = f10 * f14 - f11 * f13;
            float f16 = f11 * f12 - f9 * f14;
            float f17 = f9 * f13 - f10 * f12;
            float f18 = f6 * f15 + f7 * f16 + f8 * f17;
            int n13 = (f2 > f ? 1 : 0) + (f3 > f ? 2 : 0) + (f4 > f ? 4 : 0) + (f5 > f ? 8 : 0);
            if (f18 < 0.0f) {
                n13 = 15 - n13;
            }
            switch (n13) {
                case 0: 
                case 15: {
                    break;
                }
                case 1: 
                case 14: {
                    int n14;
                    int n15;
                    float f19;
                    int n16 = this.Delan.Edges[n12][0];
                    int n17 = this.Delan.Edges[n12][1];
                    int n18 = this.Delan.Edges[n12][2];
                    if (fArray3[0][n16] != fArray3[0][n16]) {
                        f19 = (f - f3) / (f2 - f3);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n16] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n3];
                        fArray3[1][n16] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n3];
                        fArray3[2][n16] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n3];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]));
                            byArray3[n15][n16] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n16] = n10++;
                    }
                    if (fArray3[0][n17] != fArray3[0][n17]) {
                        f19 = (f - f4) / (f2 - f4);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n17] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n2];
                        fArray3[1][n17] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n2];
                        fArray3[2][n17] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n2];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]));
                            byArray3[n15][n17] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n17] = n10++;
                    }
                    if (fArray3[0][n18] != fArray3[0][n18]) {
                        f19 = (f - f5) / (f2 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n18] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n18] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n18] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n18] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n18] = n10++;
                    }
                    nArray3[n11][0] = n16;
                    if (n13 == 1) {
                        nArray3[n11][1] = n17;
                        nArray3[n11][2] = n18;
                    } else {
                        nArray3[n11][1] = n18;
                        nArray3[n11][2] = n17;
                    }
                    nArray3[n11][3] = -1;
                    ++n11;
                    break;
                }
                case 2: 
                case 13: {
                    int n14;
                    int n15;
                    float f19;
                    int n16 = this.Delan.Edges[n12][0];
                    int n19 = this.Delan.Edges[n12][3];
                    int n20 = this.Delan.Edges[n12][4];
                    if (fArray3[0][n16] != fArray3[0][n16]) {
                        f19 = (f - f3) / (f2 - f3);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n16] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n3];
                        fArray3[1][n16] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n3];
                        fArray3[2][n16] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n3];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]));
                            byArray3[n15][n16] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n16] = n10++;
                    }
                    if (fArray3[0][n19] != fArray3[0][n19]) {
                        f19 = (f - f4) / (f3 - f4);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n19] = f19 * this.Samples[0][n3] + (1.0f - f19) * this.Samples[0][n2];
                        fArray3[1][n19] = f19 * this.Samples[1][n3] + (1.0f - f19) * this.Samples[1][n2];
                        fArray3[2][n19] = f19 * this.Samples[2][n3] + (1.0f - f19) * this.Samples[2][n2];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]) + (1.0f - f19) * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]));
                            byArray3[n15][n19] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n19] = n10++;
                    }
                    if (fArray3[0][n20] != fArray3[0][n20]) {
                        f19 = (f - f5) / (f3 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n20] = f19 * this.Samples[0][n3] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n20] = f19 * this.Samples[1][n3] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n20] = f19 * this.Samples[2][n3] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n20] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n20] = n10++;
                    }
                    nArray3[n11][0] = n16;
                    if (n13 == 2) {
                        nArray3[n11][1] = n20;
                        nArray3[n11][2] = n19;
                    } else {
                        nArray3[n11][1] = n19;
                        nArray3[n11][2] = n20;
                    }
                    nArray3[n11][3] = -1;
                    ++n11;
                    break;
                }
                case 3: 
                case 12: {
                    int n14;
                    int n15;
                    float f19;
                    int n17 = this.Delan.Edges[n12][1];
                    int n18 = this.Delan.Edges[n12][2];
                    int n19 = this.Delan.Edges[n12][3];
                    int n20 = this.Delan.Edges[n12][4];
                    if (fArray3[0][n17] != fArray3[0][n17]) {
                        f19 = (f - f4) / (f2 - f4);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n17] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n2];
                        fArray3[1][n17] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n2];
                        fArray3[2][n17] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n2];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]));
                            byArray3[n15][n17] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n17] = n10++;
                    }
                    if (fArray3[0][n18] != fArray3[0][n18]) {
                        f19 = (f - f5) / (f2 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n18] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n18] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n18] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n18] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n18] = n10++;
                    }
                    if (fArray3[0][n20] != fArray3[0][n20]) {
                        f19 = (f - f5) / (f3 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n20] = f19 * this.Samples[0][n3] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n20] = f19 * this.Samples[1][n3] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n20] = f19 * this.Samples[2][n3] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n20] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n20] = n10++;
                    }
                    if (fArray3[0][n19] != fArray3[0][n19]) {
                        f19 = (f - f4) / (f3 - f4);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n19] = f19 * this.Samples[0][n3] + (1.0f - f19) * this.Samples[0][n2];
                        fArray3[1][n19] = f19 * this.Samples[1][n3] + (1.0f - f19) * this.Samples[1][n2];
                        fArray3[2][n19] = f19 * this.Samples[2][n3] + (1.0f - f19) * this.Samples[2][n2];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]) + (1.0f - f19) * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]));
                            byArray3[n15][n19] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n19] = n10++;
                    }
                    nArray3[n11][0] = n17;
                    if (n13 == 3) {
                        nArray3[n11][1] = n18;
                        nArray3[n11][2] = n20;
                        nArray3[n11][3] = n19;
                    } else {
                        nArray3[n11][1] = n19;
                        nArray3[n11][2] = n20;
                        nArray3[n11][3] = n18;
                    }
                    ++n11;
                    break;
                }
                case 4: 
                case 11: {
                    int n14;
                    int n15;
                    float f19;
                    int n17 = this.Delan.Edges[n12][1];
                    int n19 = this.Delan.Edges[n12][3];
                    int n21 = this.Delan.Edges[n12][5];
                    if (fArray3[0][n17] != fArray3[0][n17]) {
                        f19 = (f - f4) / (f2 - f4);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n17] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n2];
                        fArray3[1][n17] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n2];
                        fArray3[2][n17] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n2];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]));
                            byArray3[n15][n17] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n17] = n10++;
                    }
                    if (fArray3[0][n19] != fArray3[0][n19]) {
                        f19 = (f - f4) / (f3 - f4);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n19] = f19 * this.Samples[0][n3] + (1.0f - f19) * this.Samples[0][n2];
                        fArray3[1][n19] = f19 * this.Samples[1][n3] + (1.0f - f19) * this.Samples[1][n2];
                        fArray3[2][n19] = f19 * this.Samples[2][n3] + (1.0f - f19) * this.Samples[2][n2];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]) + (1.0f - f19) * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]));
                            byArray3[n15][n19] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n19] = n10++;
                    }
                    if (fArray3[0][n21] != fArray3[0][n21]) {
                        f19 = (f - f5) / (f4 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n21] = f19 * this.Samples[0][n2] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n21] = f19 * this.Samples[1][n2] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n21] = f19 * this.Samples[2][n2] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n21] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n21] = n10++;
                    }
                    nArray3[n11][0] = n17;
                    if (n13 == 4) {
                        nArray3[n11][1] = n19;
                        nArray3[n11][2] = n21;
                    } else {
                        nArray3[n11][1] = n21;
                        nArray3[n11][2] = n19;
                    }
                    nArray3[n11][3] = -1;
                    ++n11;
                    break;
                }
                case 5: 
                case 10: {
                    int n14;
                    int n15;
                    float f19;
                    int n16 = this.Delan.Edges[n12][0];
                    int n18 = this.Delan.Edges[n12][2];
                    int n19 = this.Delan.Edges[n12][3];
                    int n21 = this.Delan.Edges[n12][5];
                    if (fArray3[0][n16] != fArray3[0][n16]) {
                        f19 = (f - f3) / (f2 - f3);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n16] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n3];
                        fArray3[1][n16] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n3];
                        fArray3[2][n16] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n3];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]));
                            byArray3[n15][n16] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n16] = n10++;
                    }
                    if (fArray3[0][n18] != fArray3[0][n18]) {
                        f19 = (f - f5) / (f2 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n18] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n18] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n18] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n18] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n18] = n10++;
                    }
                    if (fArray3[0][n21] != fArray3[0][n21]) {
                        f19 = (f - f5) / (f4 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n21] = f19 * this.Samples[0][n2] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n21] = f19 * this.Samples[1][n2] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n21] = f19 * this.Samples[2][n2] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n21] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n21] = n10++;
                    }
                    if (fArray3[0][n19] != fArray3[0][n19]) {
                        f19 = (f - f4) / (f3 - f4);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n19] = f19 * this.Samples[0][n3] + (1.0f - f19) * this.Samples[0][n2];
                        fArray3[1][n19] = f19 * this.Samples[1][n3] + (1.0f - f19) * this.Samples[1][n2];
                        fArray3[2][n19] = f19 * this.Samples[2][n3] + (1.0f - f19) * this.Samples[2][n2];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]) + (1.0f - f19) * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]));
                            byArray3[n15][n19] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n19] = n10++;
                    }
                    nArray3[n11][0] = n16;
                    if (n13 == 5) {
                        nArray3[n11][1] = n19;
                        nArray3[n11][2] = n21;
                        nArray3[n11][3] = n18;
                    } else {
                        nArray3[n11][1] = n18;
                        nArray3[n11][2] = n21;
                        nArray3[n11][3] = n19;
                    }
                    ++n11;
                    break;
                }
                case 6: 
                case 9: {
                    int n14;
                    int n15;
                    float f19;
                    int n16 = this.Delan.Edges[n12][0];
                    int n17 = this.Delan.Edges[n12][1];
                    int n20 = this.Delan.Edges[n12][4];
                    int n21 = this.Delan.Edges[n12][5];
                    if (fArray3[0][n16] != fArray3[0][n16]) {
                        f19 = (f - f3) / (f2 - f3);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n16] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n3];
                        fArray3[1][n16] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n3];
                        fArray3[2][n16] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n3];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]));
                            byArray3[n15][n16] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n16] = n10++;
                    }
                    if (fArray3[0][n17] != fArray3[0][n17]) {
                        f19 = (f - f4) / (f2 - f4);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n17] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n2];
                        fArray3[1][n17] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n2];
                        fArray3[2][n17] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n2];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]));
                            byArray3[n15][n17] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n17] = n10++;
                    }
                    if (fArray3[0][n21] != fArray3[0][n21]) {
                        f19 = (f - f5) / (f4 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n21] = f19 * this.Samples[0][n2] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n21] = f19 * this.Samples[1][n2] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n21] = f19 * this.Samples[2][n2] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n21] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n21] = n10++;
                    }
                    if (fArray3[0][n20] != fArray3[0][n20]) {
                        f19 = (f - f5) / (f3 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n20] = f19 * this.Samples[0][n3] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n20] = f19 * this.Samples[1][n3] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n20] = f19 * this.Samples[2][n3] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n20] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n20] = n10++;
                    }
                    nArray3[n11][0] = n16;
                    if (n13 == 6) {
                        nArray3[n11][1] = n20;
                        nArray3[n11][2] = n21;
                        nArray3[n11][3] = n17;
                    } else {
                        nArray3[n11][1] = n17;
                        nArray3[n11][2] = n21;
                        nArray3[n11][3] = n20;
                    }
                    ++n11;
                    break;
                }
                case 7: 
                case 8: {
                    int n14;
                    int n15;
                    float f19;
                    int n18 = this.Delan.Edges[n12][2];
                    int n20 = this.Delan.Edges[n12][4];
                    int n21 = this.Delan.Edges[n12][5];
                    if (fArray3[0][n18] != fArray3[0][n18]) {
                        f19 = (f - f5) / (f2 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n18] = f19 * this.Samples[0][n4] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n18] = f19 * this.Samples[1][n4] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n18] = f19 * this.Samples[2][n4] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n4] < 0 ? (float)byArray[n15][n4] + 256.0f : (float)byArray[n15][n4]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n18] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n18] = n10++;
                    }
                    if (fArray3[0][n20] != fArray3[0][n20]) {
                        f19 = (f - f5) / (f3 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n20] = f19 * this.Samples[0][n3] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n20] = f19 * this.Samples[1][n3] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n20] = f19 * this.Samples[2][n3] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n3] < 0 ? (float)byArray[n15][n3] + 256.0f : (float)byArray[n15][n3]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n20] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n20] = n10++;
                    }
                    if (fArray3[0][n21] != fArray3[0][n21]) {
                        f19 = (f - f5) / (f4 - f5);
                        if (f19 < 0.0f) {
                            f19 = -f19;
                        }
                        fArray3[0][n21] = f19 * this.Samples[0][n2] + (1.0f - f19) * this.Samples[0][n];
                        fArray3[1][n21] = f19 * this.Samples[1][n2] + (1.0f - f19) * this.Samples[1][n];
                        fArray3[2][n21] = f19 * this.Samples[2][n2] + (1.0f - f19) * this.Samples[2][n];
                        n15 = 0;
                        while (n15 < n6) {
                            n14 = (int)(f19 * (byArray[n15][n2] < 0 ? (float)byArray[n15][n2] + 256.0f : (float)byArray[n15][n2]) + (1.0f - f19) * (byArray[n15][n] < 0 ? (float)byArray[n15][n] + 256.0f : (float)byArray[n15][n]));
                            byArray3[n15][n21] = (byte)(n14 < 0 ? 0 : (n14 > 255 ? -1 : (n14 < 128 ? n14 : n14 - 256)));
                            ++n15;
                        }
                        nArray4[n21] = n10++;
                    }
                    nArray3[n11][0] = n18;
                    if (n13 == 7) {
                        nArray3[n11][1] = n20;
                        nArray3[n11][2] = n21;
                    } else {
                        nArray3[n11][1] = n21;
                        nArray3[n11][2] = n20;
                    }
                    nArray3[n11][3] = -1;
                    ++n11;
                    break;
                }
            }
            ++n12;
        }
        if (bl) {
            System.out.println("\npolys (polys -> global edges) " + n11 + "\n");
            n12 = 0;
            while (n12 < n11) {
                String string = "  " + n12 + " -> ";
                n3 = 0;
                while (n3 < 4) {
                    string = string + " " + nArray3[n12][n3];
                    ++n3;
                }
                System.out.println(string + "\n");
                ++n12;
            }
        }
        nArray[0] = new int[n11][];
        n12 = 0;
        while (n12 < n11) {
            n4 = nArray3[n12][3] < 0 ? 3 : 4;
            nArray[0][n12] = new int[n4];
            n3 = 0;
            while (n3 < n4) {
                nArray[0][n12][n3] = nArray4[nArray3[n12][n3]];
                ++n3;
            }
            ++n12;
        }
        if (bl) {
            System.out.println("\npolyToVert (polys -> vertices) " + n11 + "\n");
            n12 = 0;
            while (n12 < n11) {
                String string = "  " + n12 + " -> ";
                n3 = 0;
                while (n3 < nArray[0][n12].length) {
                    string = string + " " + nArray[0][n12][n3];
                    ++n3;
                }
                System.out.println(string + "\n");
                ++n12;
            }
        }
        int[] nArray5 = new int[n10];
        int n22 = 0;
        while (n22 < n10) {
            nArray5[n22] = 0;
            ++n22;
        }
        n22 = 0;
        while (n22 < n11) {
            int n23 = nArray[0][n22][0];
            nArray5[n23] = nArray5[n23] + 1;
            int n24 = nArray[0][n22][1];
            nArray5[n24] = nArray5[n24] + 1;
            int n25 = nArray[0][n22][2];
            nArray5[n25] = nArray5[n25] + 1;
            if (nArray[0][n22].length > 3) {
                int n26 = nArray[0][n22][3];
                nArray5[n26] = nArray5[n26] + 1;
            }
            ++n22;
        }
        nArray2[0] = new int[n10][];
        n22 = 0;
        while (n22 < n10) {
            nArray2[0][n22] = new int[nArray5[n22]];
            ++n22;
        }
        n22 = 0;
        while (n22 < n10) {
            nArray5[n22] = 0;
            ++n22;
        }
        n22 = 0;
        while (n22 < n11) {
            int n27;
            n3 = nArray[0][n22][0];
            n2 = nArray[0][n22][1];
            n = nArray[0][n22][2];
            int n28 = n3;
            int n29 = nArray5[n28];
            nArray5[n28] = n29 + 1;
            nArray2[0][n3][n29] = n22;
            int n30 = n2;
            int n31 = nArray5[n30];
            nArray5[n30] = n31 + 1;
            nArray2[0][n2][n31] = n22;
            int n32 = n;
            int n33 = nArray5[n32];
            nArray5[n32] = n33 + 1;
            nArray2[0][n][n33] = n22;
            if (nArray[0][n22].length > 3 && (n27 = nArray[0][n22][3]) != -1) {
                int n34 = n27;
                int n35 = nArray5[n34];
                nArray5[n34] = n35 + 1;
                nArray2[0][n27][n35] = n22;
            }
            ++n22;
        }
        if (bl) {
            System.out.println("\nvertToPoly (vertices -> polys) " + n10 + "\n");
            n22 = 0;
            while (n22 < n10) {
                String string = "  " + n22 + " -> ";
                n2 = 0;
                while (n2 < nArray2[0][n22].length) {
                    string = string + " " + nArray2[0][n22][n2];
                    ++n2;
                }
                System.out.println(string + "\n");
                ++n22;
            }
        }
        fArray2[0] = new float[n10];
        fArray2[1] = new float[n10];
        fArray2[2] = new float[n10];
        n22 = 0;
        while (n22 < n6) {
            byArray2[n22] = new byte[n10];
            ++n22;
        }
        n22 = 0;
        while (n22 < this.Delan.NumEdges) {
            int n36 = nArray4[n22];
            if (n36 >= 0) {
                fArray2[0][n36] = fArray3[0][n22];
                fArray2[1][n36] = fArray3[1][n22];
                fArray2[2][n36] = fArray3[2][n22];
                n2 = 0;
                while (n2 < n6) {
                    byArray2[n2][n36] = byArray3[n2][n22];
                    ++n2;
                }
            }
            ++n22;
        }
        if (bl) {
            System.out.println("\nfieldVertices " + n10 + "\n");
            n22 = 0;
            while (n22 < n10) {
                String string = "  " + n22 + " -> ";
                n2 = 0;
                while (n2 < 3) {
                    string = string + " " + fArray2[n2][n22];
                    ++n2;
                }
                System.out.println(string + "\n");
                ++n22;
            }
        }
    }

    private static void make_normals(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6, int n, int n2, float[] fArray7, float[] fArray8, float[] fArray9, float[] fArray10, float[] fArray11, float[] fArray12, float[] fArray13, float[] fArray14, float[] fArray15, int[][] nArray, int[][] nArray2) throws VisADException {
        int n3;
        int n4;
        int[] nArray3 = new int[3];
        if (n <= 0) {
            return;
        }
        int n5 = 0;
        while (n5 < n) {
            fArray4[n5] = 0.0f;
            fArray5[n5] = 0.0f;
            fArray6[n5] = 0.0f;
            ++n5;
        }
        float f = Float.MIN_VALUE;
        int n6 = 0;
        while (true) {
            n5 = n6 + 1;
            while (n5 < n2) {
                if (nArray2[n5].length > nArray2[n6].length) break;
                ++n5;
            }
            if (n5 >= n2) break;
            n6 = n5;
        }
        int n7 = nArray2[n6].length;
        n5 = 0;
        while (n5 < n2) {
            if (nArray2[n5].length > 0) {
                n4 = nArray2[n5][1];
                n3 = nArray2[n5][0];
                fArray10[n5] = fArray[n4] - fArray[n3];
                fArray12[n5] = fArray2[n4] - fArray2[n3];
                fArray14[n5] = fArray3[n4] - fArray3[n3];
            }
            ++n5;
        }
        boolean bl = false;
        n6 = 2;
        while (n6 < n7) {
            if (!bl) {
                n5 = 0;
                while (n5 < n2) {
                    if (n6 < nArray2[n5].length) {
                        n4 = nArray2[n5][n6];
                        n3 = nArray2[n5][0];
                        fArray11[n5] = fArray[n4] - fArray[n3];
                        fArray13[n5] = fArray2[n4] - fArray2[n3];
                        fArray15[n5] = fArray3[n4] - fArray3[n3];
                        fArray7[n5] = fArray12[n5] * fArray15[n5] - fArray14[n5] * fArray13[n5];
                        fArray8[n5] = fArray14[n5] * fArray11[n5] - fArray10[n5] * fArray15[n5];
                        fArray9[n5] = fArray10[n5] * fArray13[n5] - fArray12[n5] * fArray11[n5];
                        fArray10[n5] = fArray7[n5] * fArray7[n5] + fArray8[n5] * fArray8[n5] + fArray9[n5] * fArray9[n5];
                        if (fArray10[n5] > f) {
                            int n8 = n5;
                            fArray7[n8] = fArray7[n8] / fArray10[n5];
                            int n9 = n5;
                            fArray8[n9] = fArray8[n9] / fArray10[n5];
                            int n10 = n5;
                            fArray9[n10] = fArray9[n10] / fArray10[n5];
                        }
                    }
                    ++n5;
                }
            } else {
                n5 = 0;
                while (n5 < n2) {
                    if (n6 < nArray2[n5].length) {
                        n4 = nArray2[n5][n6];
                        n3 = nArray2[n5][0];
                        fArray10[n5] = fArray[n4] - fArray[n3];
                        fArray12[n5] = fArray2[n4] - fArray2[n3];
                        fArray14[n5] = fArray3[n4] - fArray3[n3];
                        fArray7[n5] = fArray13[n5] * fArray14[n5] - fArray15[n5] * fArray12[n5];
                        fArray8[n5] = fArray15[n5] * fArray10[n5] - fArray11[n5] * fArray14[n5];
                        fArray9[n5] = fArray11[n5] * fArray12[n5] - fArray13[n5] * fArray10[n5];
                        fArray11[n5] = fArray7[n5] * fArray7[n5] + fArray8[n5] * fArray8[n5] + fArray9[n5] * fArray9[n5];
                        if (fArray11[n5] > f) {
                            int n11 = n5;
                            fArray7[n11] = fArray7[n11] / fArray11[n5];
                            int n12 = n5;
                            fArray8[n12] = fArray8[n12] / fArray11[n5];
                            int n13 = n5;
                            fArray9[n13] = fArray9[n13] / fArray11[n5];
                        }
                    }
                    ++n5;
                }
            }
            n5 = 0;
            while (n5 < n2) {
                if (n6 < nArray2[n5].length) {
                    nArray3[0] = nArray2[n5][0];
                    nArray3[1] = nArray2[n5][n6 - 1];
                    nArray3[2] = nArray2[n5][n6];
                    float f2 = fArray7[n5];
                    float f3 = fArray8[n5];
                    float f4 = fArray9[n5];
                    int n14 = nArray3[0];
                    fArray4[n14] = fArray4[n14] + f2;
                    int n15 = nArray3[0];
                    fArray5[n15] = fArray5[n15] + f3;
                    int n16 = nArray3[0];
                    fArray6[n16] = fArray6[n16] + f4;
                    int n17 = nArray3[1];
                    fArray4[n17] = fArray4[n17] + f2;
                    int n18 = nArray3[1];
                    fArray5[n18] = fArray5[n18] + f3;
                    int n19 = nArray3[1];
                    fArray6[n19] = fArray6[n19] + f4;
                    int n20 = nArray3[2];
                    fArray4[n20] = fArray4[n20] + f2;
                    int n21 = nArray3[2];
                    fArray5[n21] = fArray5[n21] + f3;
                    int n22 = nArray3[2];
                    fArray6[n22] = fArray6[n22] + f4;
                }
                ++n5;
            }
            bl = !bl;
            ++n6;
        }
        n5 = 0;
        while (n5 < n) {
            float f5 = (float)Math.sqrt(fArray4[n5] * fArray4[n5] + fArray5[n5] * fArray5[n5] + fArray6[n5] * fArray6[n5]);
            if (f5 > 1.0E-5f) {
                int n23 = n5;
                fArray4[n23] = fArray4[n23] / f5;
                int n24 = n5;
                fArray5[n24] = fArray5[n24] / f5;
                int n25 = n5;
                fArray6[n25] = fArray6[n25] / f5;
            }
            ++n5;
        }
    }

    static int poly_triangle_stripe(int[] nArray, int n, int n2, int[][] nArray2, int[][] nArray3) throws VisADException {
        boolean bl = false;
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n2) {
            blArray[n7] = true;
            ++n7;
        }
        block1: while (true) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14 = n3;
            while (n14 < n2) {
                if (blArray[n14]) break;
                ++n14;
            }
            if (n14 == n2) {
                n14 = -1;
            } else {
                n3 = n14;
            }
            if (n14 < 0) break;
            blArray[n14] = false;
            int n15 = nArray3[n14].length;
            int n16 = 0;
            while (n16 < n15) {
                n6 = n16 + 1 == n15 ? 0 : n16 + 1;
                n4 = -1;
                if (n16 < nArray3[n14].length && n6 < nArray3[n14].length) {
                    n7 = nArray3[n14][n16];
                    n13 = nArray2[n7].length;
                    n12 = 0;
                    int n17 = nArray3[n14][n6];
                    n11 = nArray2[n17].length;
                    n10 = 0;
                    while (n7 > 0 && n12 < n13 && n17 > 0 && n10 < n11) {
                        if (nArray2[n7][n12] == nArray2[n17][n10] && blArray[nArray2[n7][n12]]) {
                            n4 = nArray2[n7][n12];
                            break;
                        }
                        if (nArray2[n7][n12] < nArray2[n17][n10]) {
                            ++n12;
                            continue;
                        }
                        ++n10;
                    }
                }
                if (n4 >= 0) break;
                ++n16;
            }
            if (n4 < 0) {
                n9 = STAB[n15 - 3];
                if (n5 > 0) {
                    nArray[n5] = nArray[n5 - 1];
                    int n18 = ++n5;
                    ++n5;
                    nArray[n18] = nArray3[n14][NTAB[n9]];
                } else {
                    bl = true;
                }
                n8 = 0;
                while (true) {
                    if (n8 >= (n15 < 6 ? n15 : 6)) continue block1;
                    nArray[n5++] = nArray3[n14][NTAB[n9++]];
                    ++n8;
                }
            }
            if (n6 != 0 && n16 == n6 - 1 || n6 == 0 && n16 == n15 - 1) {
                n9 = STAB[n15 - 3] + (n6 + 1) * n15;
                if (bl) {
                    nArray[n5] = nArray[n5 - 1];
                    int n19 = ++n5;
                    ++n5;
                    nArray[n19] = nArray3[n14][ITAB[n9 - 1]];
                    bl = false;
                }
                n8 = 0;
                while (n8 < (n15 < 6 ? n15 : 6)) {
                    nArray[n5++] = nArray3[n14][ITAB[--n9]];
                    ++n8;
                }
            } else {
                n9 = STAB[n15 - 3] + (n6 + 1) * n15;
                if (bl) {
                    nArray[n5] = nArray[n5 - 1];
                    int n20 = ++n5;
                    ++n5;
                    nArray[n20] = nArray3[n14][NTAB[n9 - 1]];
                    bl = false;
                }
                n8 = 0;
                while (n8 < (n15 < 6 ? n15 : 6)) {
                    nArray[n5++] = nArray3[n14][NTAB[--n9]];
                    ++n8;
                }
            }
            int n21 = nArray[n5 - 1];
            int n22 = nArray[n5 - 2];
            n14 = n4;
            while (true) {
                n15 = nArray3[n14].length;
                blArray[n14] = false;
                n16 = 0;
                while (n16 < n15 && nArray3[n14][n16] != n22) {
                    ++n16;
                }
                n6 = 0;
                while (n6 < n15 && nArray3[n14][n6] != n21) {
                    ++n6;
                }
                if (n6 != 0 && n16 == n6 - 1 || n6 == 0 && n16 == n15 - 1) {
                    n9 = STAB[n15 - 3] + n16 * n15 + 2;
                    n8 = 2;
                    while (n8 < (n15 < 6 ? n15 : 6)) {
                        nArray[n5++] = nArray3[n14][NTAB[n9++]];
                        ++n8;
                    }
                } else {
                    n9 = STAB[n15 - 3] + n16 * n15 + 2;
                    n8 = 2;
                    while (n8 < (n15 < 6 ? n15 : 6)) {
                        nArray[n5++] = nArray3[n14][ITAB[n9++]];
                        ++n8;
                    }
                }
                n21 = nArray[n5 - 1];
                n22 = nArray[n5 - 2];
                n14 = -1;
                if (n22 >= 0 && n21 >= 0) {
                    n13 = nArray2[n22].length;
                    n12 = 0;
                    n11 = nArray2[n21].length;
                    n10 = 0;
                    while (n22 > 0 && n12 < n13 && n21 > 0 && n10 < n11) {
                        if (nArray2[n22][n12] == nArray2[n21][n10] && blArray[nArray2[n22][n12]]) {
                            n14 = nArray2[n22][n12];
                            break;
                        }
                        if (nArray2[n22][n12] < nArray2[n21][n10]) {
                            ++n12;
                            continue;
                        }
                        ++n10;
                    }
                }
                if (n14 >= 0) continue;
                n22 = nArray[n5 - 3];
                n14 = -1;
                if (n22 >= 0 && n21 >= 0) {
                    n13 = nArray2[n22].length;
                    n12 = 0;
                    n11 = nArray2[n21].length;
                    n10 = 0;
                    while (n22 > 0 && n12 < n13 && n21 > 0 && n10 < n11) {
                        if (nArray2[n22][n12] == nArray2[n21][n10] && blArray[nArray2[n22][n12]]) {
                            n14 = nArray2[n22][n12];
                            break;
                        }
                        if (nArray2[n22][n12] < nArray2[n21][n10]) {
                            ++n12;
                            continue;
                        }
                        ++n10;
                    }
                }
                if (n14 < 0) {
                    bl = true;
                    continue block1;
                }
                nArray[n5++] = n22;
                n7 = n22;
                n22 = n21;
                n21 = n7;
            }
            break;
        }
        return n5;
    }

    public VisADGeometryArray make2DGeometry(byte[][] byArray, boolean bl) throws VisADException {
        if (this.DomainDimension != 3) {
            throw new SetException("Irregular3DSet.make2DGeometry: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (this.ManifoldDimension != 2) {
            throw new SetException("Irregular3DSet.make2DGeometry: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int n = this.Delan.Tri.length;
        int n2 = this.Delan.Vertices.length;
        if (n < 1 || n2 < 3) {
            return null;
        }
        int[][] nArray = this.Delan.Tri;
        int[][] nArray2 = this.Delan.Walk;
        int n3 = nArray[0].length - 1;
        int[][] nArray3 = new int[n][];
        int[] nArray4 = new int[n];
        int[] nArray5 = new int[n];
        int n4 = 0;
        while (n4 < n) {
            if (nArray3[n4] == null) {
                nArray3[n4] = new int[3];
                nArray3[n4][0] = nArray[n4][0];
                nArray3[n4][1] = nArray[n4][1];
                nArray3[n4][2] = nArray[n4][2];
                int n5 = 0;
                nArray5[n5] = 0;
                nArray4[n5] = n4;
                do {
                    int n6;
                    int n7;
                    int n8;
                    if ((n8 = nArray2[n7 = nArray4[n5]][n6 = nArray5[n5]]) >= 0 && nArray3[n8] == null) {
                        int n9 = nArray[n7][n6];
                        int n10 = nArray[n7][(n6 + 1) % 3];
                        int n11 = -1;
                        int n12 = -1;
                        int n13 = -1;
                        int n14 = -1;
                        int n15 = 0;
                        while (n15 < 3) {
                            if (nArray3[n7][n15] == n9) {
                                n11 = n15;
                            }
                            if (nArray3[n7][n15] == n10) {
                                n12 = n15;
                            }
                            if (nArray[n8][n15] == n9) {
                                n13 = n15;
                            }
                            if (nArray[n8][n15] == n10) {
                                n14 = n15;
                            }
                            ++n15;
                        }
                        nArray3[n8] = new int[3];
                        nArray3[n8][0] = nArray[n8][0];
                        if ((n11 + 1) % 3 == n12 && (n13 + 1) % 3 == n14 || (n12 + 1) % 3 == n11 && (n14 + 1) % 3 == n13) {
                            nArray3[n8][1] = nArray[n8][2];
                            nArray3[n8][2] = nArray[n8][1];
                        } else {
                            nArray3[n8][1] = nArray[n8][1];
                            nArray3[n8][2] = nArray[n8][2];
                        }
                        nArray5[++n5] = 0;
                        nArray4[n5] = n8;
                        continue;
                    }
                    do {
                        int n16 = n5;
                        nArray5[n16] = nArray5[n16] + 1;
                    } while (nArray5[n5] >= 3 && --n5 >= 0);
                } while (n5 >= 0);
            }
            ++n4;
        }
        float[][] fArray = this.getSamples(false);
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        float[] fArray5 = new float[n];
        float[] fArray6 = new float[n];
        float[] fArray7 = new float[n];
        float[] fArray8 = new float[n];
        float[] fArray9 = new float[n];
        float[] fArray10 = new float[n];
        float[] fArray11 = new float[n2];
        float[] fArray12 = new float[n2];
        float[] fArray13 = new float[n2];
        Irregular3DSet.make_normals(fArray[0], fArray[1], fArray[2], fArray11, fArray12, fArray13, n2, n, fArray8, fArray9, fArray10, fArray2, fArray3, fArray4, fArray5, fArray6, fArray7, this.Delan.Vertices, nArray3);
        fArray10 = null;
        fArray9 = null;
        fArray8 = null;
        fArray7 = null;
        fArray6 = null;
        fArray5 = null;
        fArray4 = null;
        fArray3 = null;
        fArray2 = null;
        float[] fArray14 = new float[3 * n2];
        int n17 = 0;
        int n18 = 0;
        while (n18 < n2) {
            fArray14[n17++] = fArray11[n18];
            fArray14[n17++] = fArray12[n18];
            fArray14[n17++] = fArray13[n18];
            ++n18;
        }
        fArray13 = null;
        fArray12 = null;
        fArray11 = null;
        int[] nArray6 = new int[6 * n];
        int n19 = Irregular3DSet.poly_triangle_stripe(nArray6, n2, n, this.Delan.Vertices, this.Delan.Tri);
        if (bl) {
            VisADIndexedTriangleStripArray visADIndexedTriangleStripArray = new VisADIndexedTriangleStripArray();
            visADIndexedTriangleStripArray.normals = fArray14;
            fArray14 = null;
            visADIndexedTriangleStripArray.indexCount = n19;
            visADIndexedTriangleStripArray.indices = new int[n19];
            System.arraycopy(nArray6, 0, visADIndexedTriangleStripArray.indices, 0, n19);
            visADIndexedTriangleStripArray.stripVertexCounts = new int[1];
            visADIndexedTriangleStripArray.stripVertexCounts[0] = n19;
            nArray6 = null;
            SampledSet.setGeometryArray(visADIndexedTriangleStripArray, fArray, 4, byArray);
            fArray = null;
            return visADIndexedTriangleStripArray;
        }
        VisADTriangleStripArray visADTriangleStripArray = new VisADTriangleStripArray();
        visADTriangleStripArray.stripVertexCounts = new int[]{n19};
        visADTriangleStripArray.vertexCount = n19;
        visADTriangleStripArray.normals = new float[3 * n19];
        int n20 = 0;
        int n21 = 0;
        while (n21 < 3 * n19) {
            n17 = 3 * nArray6[n20];
            visADTriangleStripArray.normals[n21] = fArray14[n17];
            visADTriangleStripArray.normals[n21 + 1] = fArray14[n17 + 1];
            visADTriangleStripArray.normals[n21 + 2] = fArray14[n17 + 2];
            ++n20;
            n21 += 3;
        }
        fArray14 = null;
        visADTriangleStripArray.coordinates = new float[3 * n19];
        n20 = 0;
        n21 = 0;
        while (n21 < 3 * n19) {
            n17 = nArray6[n20];
            visADTriangleStripArray.coordinates[n21] = fArray[0][n17];
            visADTriangleStripArray.coordinates[n21 + 1] = fArray[1][n17];
            visADTriangleStripArray.coordinates[n21 + 2] = fArray[2][n17];
            ++n20;
            n21 += 3;
        }
        fArray = null;
        if (byArray != null) {
            n21 = byArray.length;
            visADTriangleStripArray.colors = new byte[n21 * n19];
            n20 = 0;
            if (n21 == 4) {
                int n22 = 0;
                while (n22 < n21 * n19) {
                    n17 = nArray6[n20];
                    visADTriangleStripArray.colors[n22] = byArray[0][n17];
                    visADTriangleStripArray.colors[n22 + 1] = byArray[1][n17];
                    visADTriangleStripArray.colors[n22 + 2] = byArray[2][n17];
                    visADTriangleStripArray.colors[n22 + 3] = byArray[3][n17];
                    ++n20;
                    n22 += n21;
                }
            } else {
                int n23 = 0;
                while (n23 < n21 * n19) {
                    n17 = nArray6[n20];
                    visADTriangleStripArray.colors[n23] = byArray[0][n17];
                    visADTriangleStripArray.colors[n23 + 1] = byArray[1][n17];
                    visADTriangleStripArray.colors[n23 + 2] = byArray[2][n17];
                    ++n20;
                    n23 += n21;
                }
            }
        }
        byArray = null;
        nArray6 = null;
        return visADTriangleStripArray;
    }

    public Object clone() {
        try {
            if (this.ManifoldDimension == 1) {
                return new Irregular3DSet(this.Type, this.Samples, this.newToOld, this.oldToNew, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
            }
            return new Irregular3DSet(this.Type, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.Delan);
        }
        catch (VisADException visADException) {
            throw new VisADError("Irregular3DSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        if (this.ManifoldDimension == 1) {
            return new Irregular3DSet(mathType, this.Samples, this.newToOld, this.oldToNew, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Irregular3DSet(mathType, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.Delan);
    }

    public static void main(String[] stringArray) throws VisADException {
        int n;
        float[][] fArray = new float[][]{{179.0f, 232.0f, 183.0f, 244.0f, 106.0f, 344.0f, 166.0f, 304.0f, 286.0f}, {86.0f, 231.0f, 152.0f, 123.0f, 183.0f, 153.0f, 308.0f, 325.0f, 89.0f}, {121.0f, 301.0f, 346.0f, 352.0f, 123.0f, 125.0f, 187.0f, 101.0f, 142.0f}};
        RealType realType = new RealType("x", null, null);
        RealType realType2 = new RealType("y", null, null);
        RealType realType3 = new RealType("z", null, null);
        RealType[] realTypeArray = new RealType[]{realType, realType2, realType3};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        Irregular3DSet irregular3DSet = new Irregular3DSet((MathType)realTupleType, fArray);
        System.out.println("Samples:");
        int n2 = 0;
        while (n2 < irregular3DSet.Samples[0].length) {
            System.out.println("#" + n2 + ":\t" + irregular3DSet.Samples[0][n2] + ", " + irregular3DSet.Samples[1][n2] + ", " + irregular3DSet.Samples[2][n2]);
            ++n2;
        }
        System.out.println(irregular3DSet.Delan.Tri.length + " tetrahedrons in tetrahedralization.");
        System.out.println("\nvalueToIndex test:");
        float[][] fArray2 = new float[][]{{189.0f, 221.0f, 319.0f, 215.0f, 196.0f}, {166.0f, 161.0f, 158.0f, 139.0f, 285.0f}, {207.0f, 300.0f, 127.0f, 287.0f, 194.0f}};
        int[] nArray = irregular3DSet.valueToIndex(fArray2);
        int n3 = 0;
        while (n3 < nArray.length) {
            System.out.println(fArray2[0][n3] + ", " + fArray2[1][n3] + ", " + fArray2[2][n3] + "\t--> #" + nArray[n3]);
            ++n3;
        }
        System.out.println("\nvalueToInterp test:");
        int[][] nArray2 = new int[fArray2[0].length][];
        float[][] fArray3 = new float[fArray2[0].length][];
        irregular3DSet.valueToInterp(fArray2, nArray2, fArray3);
        int n4 = 0;
        while (n4 < fArray2[0].length) {
            System.out.println(fArray2[0][n4] + ", " + fArray2[1][n4] + ", " + fArray2[2][n4] + "\t--> [" + nArray2[n4][0] + ", " + nArray2[n4][1] + ", " + nArray2[n4][2] + ", " + nArray2[n4][3] + "]\tweight total: " + (fArray3[n4][0] + fArray3[n4][1] + fArray3[n4][2] + fArray3[n4][3]));
            ++n4;
        }
        System.out.println("\nmakeIsosurface test:");
        float[] fArray4 = new float[]{100.0f, 300.0f, 320.0f, 250.0f, 80.0f, 70.0f, 135.0f, 110.0f, 105.0f};
        float[][] fArray5 = new float[3][];
        int[][][] nArray3 = new int[1][][];
        int[][][] nArray4 = new int[1][][];
        irregular3DSet.makeIsosurface(288.0f, fArray4, null, fArray5, null, nArray3, nArray4);
        int n5 = 0;
        while (n5 < fArray5[0].length) {
            n = 0;
            while (n < 3) {
                fArray5[n][n5] = (float)Math.round(1000.0f * fArray5[n][n5]) / 1000.0f;
                ++n;
            }
            ++n5;
        }
        System.out.println("polygons:");
        n5 = 0;
        while (n5 < nArray3[0].length) {
            System.out.print("#" + n5 + ":");
            n = 0;
            while (n < nArray3[0][n5].length) {
                if (n == 1) {
                    if (nArray3[0][n5].length == 3) {
                        System.out.print("(tri)");
                    } else {
                        System.out.print("(quad)");
                    }
                }
                System.out.println("\t" + fArray5[0][nArray3[0][n5][n]] + ", " + fArray5[1][nArray3[0][n5][n]] + ", " + fArray5[2][nArray3[0][n5][n]]);
                ++n;
            }
            ++n5;
        }
        System.out.println();
        n5 = 0;
        while (n5 < nArray3[0].length) {
            n = nArray3[0][n5][0];
            int n6 = nArray3[0][n5][1];
            int n7 = nArray3[0][n5][2];
            int n8 = nArray3[0][n5].length == 4 ? nArray3[0][n5][3] : -1;
            boolean bl = false;
            int n9 = 0;
            while (n9 < nArray4[0][n].length) {
                if (nArray4[0][n][n9] == n5) {
                    bl = true;
                }
                ++n9;
            }
            if (!bl) {
                System.out.println("vertToPoly array corrupted at triangle #" + n5 + " vertex #0!");
            }
            bl = false;
            n9 = 0;
            while (n9 < nArray4[0][n6].length) {
                if (nArray4[0][n6][n9] == n5) {
                    bl = true;
                }
                ++n9;
            }
            if (!bl) {
                System.out.println("vertToPoly array corrupted at triangle #" + n5 + " vertex #1!");
            }
            bl = false;
            n9 = 0;
            while (n9 < nArray4[0][n7].length) {
                if (nArray4[0][n7][n9] == n5) {
                    bl = true;
                }
                ++n9;
            }
            if (!bl) {
                System.out.println("vertToPoly array corrupted at triangle #" + n5 + " vertex #2!");
            }
            bl = false;
            if (n8 != -1) {
                n9 = 0;
                while (n9 < nArray4[0][n8].length) {
                    if (nArray4[0][n8][n9] == n5) {
                        bl = true;
                    }
                    ++n9;
                }
                if (!bl) {
                    System.out.println("vertToPoly array corrupted at triangle #" + n5 + " vertex #3!");
                }
            }
            ++n5;
        }
    }

    public Irregular3DSet(MathType mathType, float[][] fArray) throws VisADException {
        this(mathType, fArray, null, null, null, null, true);
    }

    public Irregular3DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay) throws VisADException {
        this(mathType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay, true);
    }

    Irregular3DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, boolean bl) throws VisADException {
        super(mathType, fArray, delaunay == null ? fArray.length : delaunay.Tri[0].length - 1, coordinateSystem, unitArray, errorEstimateArray, delaunay, bl);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
        this.oldToNew = null;
        this.newToOld = null;
    }

    public Irregular3DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2) throws VisADException {
        this(mathType, fArray, nArray, nArray2, null, null, null, true);
    }

    public Irregular3DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, nArray, nArray2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    Irregular3DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, fArray, 1, coordinateSystem, unitArray, errorEstimateArray, null, bl);
        if (this.Length != nArray.length || this.Length != nArray2.length) {
            throw new SetException("Irregular3DSet: sort lengths do not match");
        }
        this.newToOld = new int[this.Length];
        this.oldToNew = new int[this.Length];
        System.arraycopy(nArray, 0, this.newToOld, 0, this.Length);
        System.arraycopy(nArray2, 0, this.oldToNew, 0, this.Length);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
        this.Delan = null;
    }
}

