/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.Delaunay;
import visad.ErrorEstimate;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Irregular2DSet
extends IrregularSet {
    private float LowX;
    private float HiX;
    private float LowY;
    private float HiY;

    public Set makeSpatial(SetType setType, float[][] fArray) throws VisADException {
        if (fArray.length == 3) {
            if (this.ManifoldDimension == 1) {
                return new Irregular3DSet((MathType)setType, fArray, this.newToOld, this.oldToNew, null, null, null, false);
            }
            if (this.Delan == null || this.Delan.Tri == null || this.Delan.Tri.length == 0) {
                return null;
            }
            return new Irregular3DSet((MathType)setType, fArray, null, null, null, this.Delan, false);
        }
        if (fArray.length == 2) {
            if (this.ManifoldDimension == 1) {
                return new Irregular2DSet((MathType)setType, fArray, this.newToOld, this.oldToNew, null, null, null, false);
            }
            if (this.Delan == null || this.Delan.Tri == null || this.Delan.Tri.length == 0) {
                return null;
            }
            return new Irregular2DSet((MathType)setType, fArray, null, null, null, this.Delan, false);
        }
        throw new SetException("Irregular2DSet.makeSpatial: bad samples length");
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        float[][] fArray = new float[2][nArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] >= 0 && nArray[n] < this.Length) {
                fArray[0][n] = this.Samples[0][nArray[n]];
                fArray[1][n] = this.Samples[1][nArray[n]];
            } else {
                fArray[1][n] = Float.NaN;
                fArray[0][n] = Float.NaN;
            }
            ++n;
        }
        return fArray;
    }

    public int[] valueToTri(float[][] fArray) throws VisADException {
        if (this.ManifoldDimension != 2) {
            throw new SetException("Irregular2DSet.valueToTri: ManifoldDimension must be 2, not " + this.ManifoldDimension);
        }
        int n = fArray[0].length;
        if (n != fArray[1].length) {
            throw new SetException("Irregular2DSet.valueToTri: lengths don't match");
        }
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = -1;
            boolean bl = false;
            if (n2 < 0) {
                n2 = 0;
            }
            int n4 = 0;
            while (n4 < this.Delan.Tri.length && !bl) {
                int n5;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                int n6 = this.Delan.Tri[n2][0];
                int n7 = this.Delan.Tri[n2][1];
                int n8 = this.Delan.Tri[n2][2];
                float f = this.Samples[0][n6];
                float f2 = this.Samples[1][n6];
                float f3 = this.Samples[0][n7];
                float f4 = this.Samples[1][n7];
                float f5 = this.Samples[0][n8];
                float f6 = this.Samples[1][n8];
                float f7 = fArray[0][n3];
                float f8 = fArray[1][n3];
                float f9 = (f3 - f) * (f8 - f2) - (f4 - f2) * (f7 - f);
                float f10 = (f5 - f3) * (f8 - f4) - (f6 - f4) * (f7 - f3);
                float f11 = (f - f5) * (f8 - f6) - (f2 - f6) * (f7 - f5);
                boolean bl5 = f9 != 0.0f && f9 > 0.0f != (f3 - f) * (f6 - f2) - (f4 - f2) * (f5 - f) > 0.0f ? false : (bl4 = true);
                boolean bl6 = f10 != 0.0f && f10 > 0.0f != (f5 - f3) * (f2 - f4) - (f6 - f4) * (f - f3) > 0.0f ? false : (bl3 = true);
                boolean bl7 = f11 != 0.0f && f11 > 0.0f != (f - f5) * (f4 - f6) - (f2 - f6) * (f3 - f5) > 0.0f ? false : (bl2 = true);
                if (!(bl4 || bl3 || bl2)) {
                    n2 = -1;
                } else if (!bl4 && !bl3) {
                    n5 = this.Delan.Walk[n2][0];
                    n2 = n5 >= 0 ? n5 : this.Delan.Walk[n2][1];
                } else if (!bl3 && !bl2) {
                    n5 = this.Delan.Walk[n2][1];
                    n2 = n5 >= 0 ? n5 : this.Delan.Walk[n2][2];
                } else if (!bl2 && !bl4) {
                    n5 = this.Delan.Walk[n2][2];
                    n2 = n5 >= 0 ? n5 : this.Delan.Walk[n2][0];
                } else if (!bl4) {
                    n2 = this.Delan.Walk[n2][0];
                } else if (!bl3) {
                    n2 = this.Delan.Walk[n2][1];
                } else if (!bl2) {
                    n2 = this.Delan.Walk[n2][2];
                } else {
                    bl = true;
                }
                if (n2 < 0) {
                    bl = true;
                }
                if (bl) {
                    nArray[n3] = n2;
                }
                ++n4;
            }
            ++n3;
        }
        return nArray;
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        if (fArray.length < this.DomainDimension) {
            throw new SetException("Irregular2DDSet.valueToIndex: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int[] nArray = this.valueToTri(fArray);
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0) {
                nArray2[n] = -1;
            } else {
                float f = fArray[0][n];
                float f2 = fArray[1][n];
                int n2 = nArray[n];
                int n3 = this.Delan.Tri[n2][0];
                int n4 = this.Delan.Tri[n2][1];
                int n5 = this.Delan.Tri[n2][2];
                float f3 = this.Samples[0][n3] - f;
                float f4 = this.Samples[1][n3] - f2;
                float f5 = this.Samples[0][n4] - f;
                float f6 = this.Samples[1][n4] - f2;
                float f7 = this.Samples[0][n5] - f;
                float f8 = this.Samples[1][n5] - f2;
                float f9 = f3 * f3 + f4 * f4;
                float f10 = f5 * f5 + f6 * f6;
                float f11 = f7 * f7 + f8 * f8;
                float f12 = Math.min(f9, f10);
                nArray2[n] = (f12 = Math.min(f12, f11)) == f9 ? n3 : (f12 == f10 ? n4 : n5);
            }
            ++n;
        }
        return nArray2;
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        if (fArray.length < this.DomainDimension) {
            throw new SetException("Irregular2DDSet.valueToInterp: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = fArray[0].length;
        if (nArray.length < n || fArray2.length < n) {
            throw new SetException("Irregular2DSet.valueToInterp: lengths don't match");
        }
        int[] nArray2 = this.valueToTri(fArray);
        int n2 = 0;
        while (n2 < nArray2.length) {
            if (nArray2[n2] < 0) {
                nArray[n2] = null;
                fArray2[n2] = null;
            } else {
                int[] nArray3 = new int[3];
                float[] fArray3 = new float[3];
                float f = fArray[0][n2];
                float f2 = fArray[1][n2];
                int n3 = nArray2[n2];
                int n4 = this.Delan.Tri[n3][0];
                int n5 = this.Delan.Tri[n3][1];
                int n6 = this.Delan.Tri[n3][2];
                nArray3[0] = n4;
                nArray3[1] = n5;
                nArray3[2] = n6;
                float f3 = this.Samples[0][n4];
                float f4 = this.Samples[1][n4];
                float f5 = this.Samples[0][n5];
                float f6 = this.Samples[1][n5];
                float f7 = this.Samples[0][n6];
                float f8 = this.Samples[1][n6];
                float f9 = f8 - f6;
                float f10 = f5 - f7;
                float f11 = f8 - f4;
                float f12 = f3 - f7;
                float f13 = f6 - f4;
                float f14 = f3 - f5;
                fArray3[0] = ((f - f5) * f9 + (f2 - f6) * f10) / ((f3 - f5) * f9 + (f4 - f6) * f10);
                fArray3[1] = ((f - f3) * f11 + (f2 - f4) * f12) / ((f5 - f3) * f11 + (f6 - f4) * f12);
                fArray3[2] = ((f - f3) * f13 + (f2 - f4) * f14) / ((f7 - f3) * f13 + (f8 - f4) * f14);
                nArray[n2] = nArray3;
                fArray2[n2] = fArray3;
            }
            ++n2;
        }
    }

    public Object clone() {
        try {
            if (this.ManifoldDimension == 1) {
                return new Irregular2DSet(this.Type, this.Samples, this.newToOld, this.oldToNew, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
            }
            return new Irregular2DSet(this.Type, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.Delan);
        }
        catch (VisADException visADException) {
            throw new VisADError("Irregular2DSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        if (this.ManifoldDimension == 1) {
            return new Irregular2DSet(mathType, this.Samples, this.newToOld, this.oldToNew, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Irregular2DSet(mathType, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.Delan);
    }

    public static void main(String[] stringArray) throws VisADException {
        float[][] fArray = new float[][]{{139.0f, 357.0f, 416.0f, 276.0f, 495.0f, 395.0f, 578.0f, 199.0f}, {102.0f, 44.0f, 306.0f, 174.0f, 108.0f, 460.0f, 333.0f, 351.0f}};
        RealType realType = new RealType("x", null, null);
        RealType realType2 = new RealType("y", null, null);
        RealType[] realTypeArray = new RealType[]{realType, realType2};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        Irregular2DSet irregular2DSet = new Irregular2DSet((MathType)realTupleType, fArray);
        System.out.println("Samples:");
        int n = 0;
        while (n < irregular2DSet.Samples[0].length) {
            System.out.println("#" + n + ":\t" + irregular2DSet.Samples[0][n] + ", " + irregular2DSet.Samples[1][n]);
            ++n;
        }
        System.out.println();
        System.out.println("valueToIndex test:");
        float[][] fArray2 = new float[][]{{164.0f, 287.0f, 311.0f, 417.0f, 522.0f, 366.0f, 445.0f}, {131.0f, 323.0f, 90.0f, 264.0f, 294.0f, 421.0f, 91.0f}};
        int[] nArray = irregular2DSet.valueToIndex(fArray2);
        int n2 = 0;
        while (n2 < nArray.length) {
            System.out.println(fArray2[0][n2] + ", " + fArray2[1][n2] + "\t--> #" + nArray[n2]);
            ++n2;
        }
        System.out.println();
        System.out.println("valueToInterp test:");
        int[][] nArray2 = new int[fArray2[0].length][];
        float[][] fArray3 = new float[fArray2[0].length][];
        irregular2DSet.valueToInterp(fArray2, nArray2, fArray3);
        int n3 = 0;
        while (n3 < fArray2[0].length) {
            System.out.println(fArray2[0][n3] + ", " + fArray2[1][n3] + "\t--> [" + nArray2[n3][0] + ", " + nArray2[n3][1] + ", " + nArray2[n3][2] + "]\tweight total: " + (fArray3[n3][0] + fArray3[n3][1] + fArray3[n3][2]));
            ++n3;
        }
        System.out.println();
    }

    public Irregular2DSet(MathType mathType, float[][] fArray) throws VisADException {
        this(mathType, fArray, null, null, null, null, true);
    }

    public Irregular2DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay) throws VisADException {
        this(mathType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay, true);
    }

    public Irregular2DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, boolean bl) throws VisADException {
        super(mathType, fArray, fArray.length, coordinateSystem, unitArray, errorEstimateArray, delaunay, bl);
        if (fArray.length != 2) {
            throw new SetException("Irregular2DSet: ManifoldDimension must be 2 for this constructor");
        }
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.oldToNew = null;
        this.newToOld = null;
    }

    public Irregular2DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2) throws VisADException {
        this(mathType, fArray, nArray, nArray2, null, null, null, true);
    }

    public Irregular2DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, nArray, nArray2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Irregular2DSet(MathType mathType, float[][] fArray, int[] nArray, int[] nArray2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, fArray, 1, coordinateSystem, unitArray, errorEstimateArray, null, bl);
        if (this.Length != nArray.length || this.Length != nArray2.length) {
            throw new SetException("Irregular2DSet: sort lengths do not match");
        }
        this.newToOld = new int[this.Length];
        this.oldToNew = new int[this.Length];
        System.arraycopy(nArray, 0, this.newToOld, 0, this.Length);
        System.arraycopy(nArray2, 0, this.oldToNew, 0, this.Length);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.Delan = null;
    }
}

