/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.QuickSort;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Irregular1DSet
extends IrregularSet {
    float LowX;
    float HiX;
    Gridded1DSet SortedSet;

    public Set makeSpatial(SetType setType, float[][] fArray) throws VisADException {
        if (fArray.length == 3) {
            return new Irregular3DSet((MathType)setType, fArray, this.newToOld, this.oldToNew, null, null, null, false);
        }
        if (fArray.length == 2) {
            return new Irregular2DSet((MathType)setType, fArray, this.newToOld, this.oldToNew, null, null, null, false);
        }
        if (fArray.length == 1) {
            return new Irregular1DSet((MathType)setType, fArray, null, null, null, false);
        }
        throw new SetException("Irregular1DSet.makeSpatial: bad samples length");
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n] >= 0 && nArray[n] < this.Length ? this.oldToNew[nArray[n]] : -1;
            ++n;
        }
        float[][] fArray = this.SortedSet.indexToValue(nArray2);
        return fArray;
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        int[] nArray = this.SortedSet.valueToIndex(fArray);
        int[] nArray2 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n] == -1 ? -1 : this.newToOld[nArray[n]];
            ++n;
        }
        return nArray2;
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        this.SortedSet.valueToInterp(fArray, nArray, fArray2);
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != null) {
                int[] nArray2 = new int[nArray[n].length];
                int n2 = 0;
                while (n2 < nArray[n].length) {
                    nArray2[n2] = this.newToOld[nArray[n][n2]];
                    ++n2;
                }
                nArray[n] = nArray2;
            }
            ++n;
        }
    }

    public float getLowX() {
        return this.LowX;
    }

    public float getHiX() {
        return this.HiX;
    }

    public Object clone() {
        try {
            return new Irregular1DSet(this.Type, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("Irregular1DSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new Irregular1DSet(mathType, this.Samples, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public static void main(String[] stringArray) throws VisADException {
        float[][] fArray = new float[][]{{130.0f, 55.0f, 37.0f, 28.0f, 61.0f, 40.0f, 104.0f, 52.0f, 65.0f, 12.0f}};
        int n = fArray[0].length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        RealType realType = new RealType("x", null, null);
        RealType[] realTypeArray = new RealType[]{realType};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        Irregular1DSet irregular1DSet = new Irregular1DSet((MathType)realTupleType, fArray);
        System.out.println("Samples (indexToValue test):");
        float[][] fArray2 = irregular1DSet.indexToValue(nArray);
        int n3 = 0;
        while (n3 < irregular1DSet.Length) {
            System.out.println("#" + n3 + ":\t" + fArray2[0][n3]);
            ++n3;
        }
        n3 = 0;
        while (n3 < irregular1DSet.Length) {
            System.out.println("#" + n3 + ":\t" + irregular1DSet.oldToNew[n3] + " " + irregular1DSet.newToOld[n3]);
            ++n3;
        }
        System.out.println("\nvalueToIndex test:");
        float[][] fArray3 = new float[][]{{10.0f, 20.0f, 30.0f, 40.0f, 50.0f, 60.0f, 70.0f, 80.0f, 90.0f, 100.0f, 110.0f, 120.0f, 130.0f}};
        int[] nArray2 = irregular1DSet.valueToIndex(fArray3);
        int n4 = 0;
        while (n4 < nArray2.length) {
            System.out.println(fArray3[0][n4] + "\t--> " + nArray2[n4]);
            ++n4;
        }
        System.out.println("\nvalueToInterp test:");
        int[][] nArray3 = new int[fArray3[0].length][];
        float[][] fArray4 = new float[fArray3[0].length][];
        irregular1DSet.valueToInterp(fArray3, nArray3, fArray4);
        int n5 = 0;
        while (n5 < fArray3[0].length) {
            System.out.print(fArray3[0][n5] + "\t--> [" + nArray3[n5][0]);
            int n6 = 1;
            while (n6 < nArray3[n5].length) {
                System.out.print(", " + nArray3[n5][n6]);
                ++n6;
            }
            System.out.print("]\tweight total: ");
            float f = 0.0f;
            int n7 = 0;
            while (n7 < fArray4[n5].length) {
                f += fArray4[n5][n7];
                ++n7;
            }
            System.out.println(f);
            ++n5;
        }
    }

    public Irregular1DSet(MathType mathType, float[][] fArray) throws VisADException {
        this(mathType, fArray, null, null, null, true);
    }

    public Irregular1DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Irregular1DSet(MathType mathType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, fArray, fArray.length, coordinateSystem, unitArray, errorEstimateArray, null, bl);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        float[][] fArray2 = new float[1][this.Length];
        int n = 0;
        while (n < this.Length) {
            fArray2[0][n] = this.Samples[0][n];
            ++n;
        }
        this.newToOld = QuickSort.sort(fArray2[0]);
        this.oldToNew = new int[this.Length];
        n = 0;
        while (n < this.Length) {
            this.oldToNew[this.newToOld[n]] = n;
            ++n;
        }
        this.SortedSet = new Gridded1DSet(mathType, fArray2, this.Length, coordinateSystem, unitArray, errorEstimateArray, false);
    }
}

