/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class InverseCoordinateSystem
extends CoordinateSystem {
    private CoordinateSystem inverse;
    private int dimension;

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem.toReference: tuples wrong dimension");
        }
        return this.inverse.fromReference(dArray);
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem.fromReference: tuples wrong dimension");
        }
        return this.inverse.toReference(dArray);
    }

    public float[][] toReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem.toReference: tuples wrong dimension");
        }
        return this.inverse.fromReference(fArray);
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem.fromReference: tuples wrong dimension");
        }
        return this.inverse.toReference(fArray);
    }

    public boolean equals(Object object) {
        return object instanceof InverseCoordinateSystem && this.inverse.equals(((InverseCoordinateSystem)object).inverse);
    }

    public InverseCoordinateSystem(RealTupleType realTupleType, CoordinateSystem coordinateSystem) throws VisADException {
        super(realTupleType, coordinateSystem.getReference().getDefaultUnits());
        this.inverse = coordinateSystem;
        this.dimension = realTupleType.getDimension();
        Unit[] unitArray = coordinateSystem.getCoordinateSystemUnits();
        Unit[] unitArray2 = realTupleType.getDefaultUnits();
        if (unitArray.length != this.dimension) {
            throw new CoordinateSystemException("InverseCoordinateSystem: dimensions don't match");
        }
        int n = 0;
        while (n < unitArray.length) {
            if (unitArray[n] == null && unitArray2[n] != null || unitArray[n] != null && !unitArray[n].equals(unitArray2[n])) {
                throw new CoordinateSystemException("InverseCoordinateSystem: Units don't match " + n + " " + unitArray[n] + " " + unitArray2[n]);
            }
            ++n;
        }
    }
}

