/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class IntegerNDSet
extends LinearNDSet
implements IntegerSet {
    public static GriddedSet create(MathType mathType, int[] nArray) throws VisADException {
        return IntegerNDSet.create(mathType, nArray, null, null, null);
    }

    public static GriddedSet create(MathType mathType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        switch (nArray.length) {
            case 1: {
                return new Integer1DSet(mathType, nArray[0], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 2: {
                return new Integer2DSet(mathType, nArray[0], nArray[1], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 3: {
                return new Integer3DSet(mathType, nArray[0], nArray[1], nArray[2], coordinateSystem, unitArray, errorEstimateArray);
            }
        }
        return new IntegerNDSet(mathType, nArray, coordinateSystem, unitArray, errorEstimateArray);
    }

    private static SetType get_generic_type(int[] nArray) throws VisADException {
        if (nArray == null || nArray.length == 0) {
            throw new SetException("IntegerNDSet: bad lengths");
        }
        int n = nArray.length;
        RealType[] realTypeArray = new RealType[n];
        int n2 = 0;
        while (n2 < n) {
            realTypeArray[n2] = RealType.Generic;
            ++n2;
        }
        return new SetType(new RealTupleType(realTypeArray));
    }

    private static double[] get_firsts(int[] nArray) {
        double[] dArray = new double[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            dArray[n] = 0.0;
            ++n;
        }
        return dArray;
    }

    private static double[] get_lasts(int[] nArray) {
        double[] dArray = new double[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            dArray[n] = nArray[n] - 1;
            ++n;
        }
        return dArray;
    }

    private static int[] get_lengths(Real[] realArray) {
        int[] nArray = new int[realArray.length];
        int n = 0;
        while (n < realArray.length) {
            nArray[n] = (int)realArray[n].getValue();
            ++n;
        }
        return nArray;
    }

    public Object clone() {
        try {
            int[] nArray = new int[this.DomainDimension];
            int n = 0;
            while (n < this.DomainDimension) {
                nArray[n] = this.L[n].getLength();
                ++n;
            }
            return new IntegerNDSet(this.Type, nArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("IntegerNDSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        int[] nArray = new int[this.DomainDimension];
        int n = 0;
        while (n < this.DomainDimension) {
            nArray[n] = this.L[n].getLength();
            ++n;
        }
        return new IntegerNDSet(mathType, nArray, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String string) throws VisADException {
        String string2 = string + "IntegerNDSet: Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
        int n = 0;
        while (n < this.DomainDimension) {
            string2 = string2 + string + "  Dimension " + n + ":" + " Linear1DSet = " + this.L[n] + "\n";
            ++n;
        }
        return string2;
    }

    public IntegerNDSet(int[] nArray) throws VisADException {
        this((MathType)IntegerNDSet.get_generic_type(nArray), nArray, null, null, null);
    }

    public IntegerNDSet(MathType mathType, int[] nArray) throws VisADException {
        this(mathType, nArray, null, null, null);
    }

    public IntegerNDSet(MathType mathType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, LinearNDSet.get_linear1d_array(mathType, IntegerNDSet.get_firsts(nArray), IntegerNDSet.get_lasts(nArray), nArray), coordinateSystem, unitArray, errorEstimateArray);
    }

    public IntegerNDSet(MathType mathType, Integer1DSet[] integer1DSetArray) throws VisADException {
        this(mathType, integer1DSetArray, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null);
    }

    public IntegerNDSet(MathType mathType, Integer1DSet[] integer1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        super(mathType, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
    }
}

