/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class HSVCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{CommonUnit.degree, null, null};

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[3][n];
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n3 = 0;
        while (n3 < n) {
            double d5 = dArray[0][n3] % 360.0;
            if (d5 < 0.0) {
                d5 += 360.0;
            }
            double d6 = Math.max(0.0, Math.min(1.0, dArray[1][n3]));
            double d7 = Math.max(0.0, Math.min(1.0, dArray[2][n3]));
            if (d6 == 0.0) {
                dArray2[0][n3] = d7;
                dArray2[1][n3] = d7;
                dArray2[2][n3] = d7;
            } else {
                n2 = (int)Math.floor(d5 /= 60.0);
                d = d5 - (double)n2;
                d2 = d7 * (1.0 - d6);
                d3 = d7 * (1.0 - d6 * d);
                d4 = d7 * (1.0 - d6 * (1.0 - d));
                switch (n2) {
                    case 0: {
                        dArray2[0][n3] = d7;
                        dArray2[1][n3] = d4;
                        dArray2[2][n3] = d2;
                        break;
                    }
                    case 1: {
                        dArray2[0][n3] = d3;
                        dArray2[1][n3] = d7;
                        dArray2[2][n3] = d2;
                        break;
                    }
                    case 2: {
                        dArray2[0][n3] = d2;
                        dArray2[1][n3] = d7;
                        dArray2[2][n3] = d4;
                        break;
                    }
                    case 3: {
                        dArray2[0][n3] = d2;
                        dArray2[1][n3] = d3;
                        dArray2[2][n3] = d7;
                        break;
                    }
                    case 4: {
                        dArray2[0][n3] = d4;
                        dArray2[1][n3] = d2;
                        dArray2[2][n3] = d7;
                        break;
                    }
                    default: {
                        dArray2[0][n3] = d7;
                        dArray2[1][n3] = d2;
                        dArray2[2][n3] = d3;
                        break;
                    }
                }
            }
            ++n3;
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[3][n];
        int n2 = 0;
        while (n2 < n) {
            double d = Math.max(0.0, Math.min(1.0, dArray[0][n2]));
            double d2 = Math.max(0.0, Math.min(1.0, dArray[1][n2]));
            double d3 = Math.max(0.0, Math.min(1.0, dArray[2][n2]));
            double d4 = Math.max(d, Math.max(d2, d3));
            double d5 = Math.min(d, Math.min(d2, d3));
            dArray2[2][n2] = d4;
            double d6 = dArray2[1][n2] = d4 != 0.0 ? (d4 - d5) / d4 : 0.0;
            if (dArray2[1][n2] == 0.0) {
                dArray2[2][n2] = 0.0;
            } else {
                double d7;
                double d8 = (d4 - d) / (d4 - d5);
                double d9 = (d4 - d2) / (d4 - d5);
                double d10 = (d4 - d3) / (d4 - d5);
                if (d == d4) {
                    d7 = d10 - d9;
                } else if (d2 == d4) {
                    d7 = 2.0 + d8 - d10;
                } else if (d3 == d4) {
                    d7 = 4.0 + d9 - d8;
                } else {
                    throw new CoordinateSystemException("HSVCoordinateSystem: bad h");
                }
                d7 = 60.0 * d7;
                if (d7 < 0.0) {
                    d7 += 360.0;
                }
                dArray2[2][n2] = d7;
            }
            ++n2;
        }
        return dArray2;
    }

    public float[][] toReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[3][n];
        int n2 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n3 = 0;
        while (n3 < n) {
            float f5 = fArray[0][n3] % 360.0f;
            if (f5 < 0.0f) {
                f5 += 360.0f;
            }
            float f6 = Math.max(0.0f, Math.min(1.0f, fArray[1][n3]));
            float f7 = Math.max(0.0f, Math.min(1.0f, fArray[2][n3]));
            if (f6 == 0.0f) {
                fArray2[0][n3] = f7;
                fArray2[1][n3] = f7;
                fArray2[2][n3] = f7;
            } else {
                n2 = (int)Math.floor(f5 /= 60.0f);
                f = f5 - (float)n2;
                f2 = f7 * (1.0f - f6);
                f3 = f7 * (1.0f - f6 * f);
                f4 = f7 * (1.0f - f6 * (1.0f - f));
                switch (n2) {
                    case 0: {
                        fArray2[0][n3] = f7;
                        fArray2[1][n3] = f4;
                        fArray2[2][n3] = f2;
                        break;
                    }
                    case 1: {
                        fArray2[0][n3] = f3;
                        fArray2[1][n3] = f7;
                        fArray2[2][n3] = f2;
                        break;
                    }
                    case 2: {
                        fArray2[0][n3] = f2;
                        fArray2[1][n3] = f7;
                        fArray2[2][n3] = f4;
                        break;
                    }
                    case 3: {
                        fArray2[0][n3] = f2;
                        fArray2[1][n3] = f3;
                        fArray2[2][n3] = f7;
                        break;
                    }
                    case 4: {
                        fArray2[0][n3] = f4;
                        fArray2[1][n3] = f2;
                        fArray2[2][n3] = f7;
                        break;
                    }
                    default: {
                        fArray2[0][n3] = f7;
                        fArray2[1][n3] = f2;
                        fArray2[2][n3] = f3;
                        break;
                    }
                }
            }
            ++n3;
        }
        return fArray2;
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("HSVCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[3][n];
        int n2 = 0;
        while (n2 < n) {
            float f = Math.max(0.0f, Math.min(1.0f, fArray[0][n2]));
            float f2 = Math.max(0.0f, Math.min(1.0f, fArray[1][n2]));
            float f3 = Math.max(0.0f, Math.min(1.0f, fArray[2][n2]));
            float f4 = Math.max(f, Math.max(f2, f3));
            float f5 = Math.min(f, Math.min(f2, f3));
            fArray2[2][n2] = f4;
            float f6 = fArray2[1][n2] = f4 != 0.0f ? (f4 - f5) / f4 : 0.0f;
            if (fArray2[1][n2] == 0.0f) {
                fArray2[2][n2] = 0.0f;
            } else {
                float f7;
                float f8 = (f4 - f) / (f4 - f5);
                float f9 = (f4 - f2) / (f4 - f5);
                float f10 = (f4 - f3) / (f4 - f5);
                if (f == f4) {
                    f7 = f10 - f9;
                } else if (f2 == f4) {
                    f7 = 2.0f + f8 - f10;
                } else if (f3 == f4) {
                    f7 = 4.0f + f9 - f8;
                } else {
                    throw new CoordinateSystemException("HSVCoordinateSystem: bad h");
                }
                f7 = 60.0f * f7;
                if (f7 < 0.0f) {
                    f7 += 360.0f;
                }
                fArray2[2][n2] = f7;
            }
            ++n2;
        }
        return fArray2;
    }

    public boolean equals(Object object) {
        return object instanceof HSVCoordinateSystem;
    }

    public HSVCoordinateSystem(RealTupleType realTupleType) throws VisADException {
        super(realTupleType, coordinate_system_units);
    }

    HSVCoordinateSystem(RealTupleType realTupleType, boolean bl) {
        super(realTupleType, coordinate_system_units, bl);
    }
}

