/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSetIface;
import visad.LinearSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class GriddedSet
extends SampledSet
implements GriddedSetIface {
    int[] Lengths;
    float EPS = 1.0E-15f;
    boolean Pos;

    private void init_lengths(int[] nArray) throws VisADException {
        this.Lengths = new int[this.ManifoldDimension];
        this.Length = 1;
        int n = 0;
        while (n < this.ManifoldDimension) {
            if (nArray[n] < 1) {
                throw new SetException("GriddedSet: each grid length must be at least 1 (length#" + n + " is " + nArray[n]);
            }
            this.Lengths[n] = nArray[n];
            this.Length *= nArray[n];
            ++n;
        }
    }

    public static GriddedSet create(MathType mathType, float[][] fArray, int[] nArray) throws VisADException {
        return GriddedSet.create(mathType, fArray, nArray, null, null, null);
    }

    public static GriddedSet create(MathType mathType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        return GriddedSet.create(mathType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, true, true);
    }

    private static GriddedSet create(MathType mathType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl, boolean bl2) throws VisADException {
        int n = nArray.length;
        int n2 = fArray.length;
        if (n > n2) {
            throw new SetException("GriddedSet.create: manifold_dimension " + n + " is greater than" + " domain_dimension " + n2);
        }
        switch (n2) {
            case 1: {
                return new Gridded1DSet(mathType, fArray, nArray[0], coordinateSystem, unitArray, errorEstimateArray, bl);
            }
            case 2: {
                if (n == 1) {
                    return new Gridded2DSet(mathType, fArray, nArray[0], coordinateSystem, unitArray, errorEstimateArray, bl);
                }
                return new Gridded2DSet(mathType, fArray, nArray[0], nArray[1], coordinateSystem, unitArray, errorEstimateArray, bl, bl2);
            }
            case 3: {
                if (n == 1) {
                    return new Gridded3DSet(mathType, fArray, nArray[0], coordinateSystem, unitArray, errorEstimateArray, bl);
                }
                if (n == 2) {
                    return new Gridded3DSet(mathType, fArray, nArray[0], nArray[1], coordinateSystem, unitArray, errorEstimateArray, bl);
                }
                return new Gridded3DSet(mathType, fArray, nArray[0], nArray[1], nArray[2], coordinateSystem, unitArray, errorEstimateArray, bl, bl2);
            }
        }
        return new GriddedSet(mathType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, bl);
    }

    public Set makeSpatial(SetType setType, float[][] fArray) throws VisADException {
        return GriddedSet.create(setType, fArray, this.Lengths, null, null, null, false, false);
    }

    public int getLength(int n) {
        return this.Lengths[n];
    }

    public int[] getLengths() {
        int[] nArray = new int[this.Lengths.length];
        int n = 0;
        while (n < this.Lengths.length) {
            nArray[n] = this.Lengths[n];
            ++n;
        }
        return nArray;
    }

    public int[] getWedge() {
        int[] nArray = new int[this.Length];
        int n = this.Lengths[0];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        int n3 = 1;
        while (n3 < this.ManifoldDimension) {
            boolean bl = true;
            int n4 = n;
            int n5 = n;
            int n6 = 1;
            while (n6 < this.Lengths[n3]) {
                if (bl) {
                    n2 = n - 1;
                    while (n2 >= 0) {
                        nArray[n5] = nArray[n2] + n4;
                        ++n5;
                        --n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < n) {
                        nArray[n5] = nArray[n2] + n4;
                        ++n5;
                        ++n2;
                    }
                }
                n4 += n;
                bl = !bl;
                ++n6;
            }
            n *= this.Lengths[n3];
            ++n3;
        }
        return nArray;
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int[] nArray2 = new int[this.ManifoldDimension];
        int n = nArray.length;
        float[][] fArray = new float[this.ManifoldDimension][n];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if (nArray[n2] >= 0 && nArray[n2] < this.Length) {
                int n4 = nArray[n2];
                n3 = 0;
                while (n3 < this.ManifoldDimension - 1) {
                    nArray2[n3] = n4 % this.Lengths[n3];
                    n4 /= this.Lengths[n3];
                    ++n3;
                }
                nArray2[this.ManifoldDimension - 1] = n4;
            } else {
                n3 = 0;
                while (n3 < this.ManifoldDimension) {
                    nArray2[n3] = -1;
                    ++n3;
                }
            }
            n3 = 0;
            while (n3 < this.ManifoldDimension) {
                fArray[n3][n2] = nArray2[n3];
                ++n3;
            }
            ++n2;
        }
        return this.gridToValue(fArray);
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        if (fArray.length != this.DomainDimension) {
            throw new SetException("GriddedSet.valueToIndex: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = fArray[0].length;
        int[] nArray = new int[n];
        float[][] fArray2 = this.valueToGrid(fArray);
        int n2 = 0;
        while (n2 < n) {
            if (Double.isNaN(fArray2[this.ManifoldDimension - 1][n2])) {
                nArray[n2] = -1;
            } else {
                int n3 = (int)((double)fArray2[this.ManifoldDimension - 1][n2] + 0.5);
                int n4 = this.ManifoldDimension - 2;
                while (n4 >= 0) {
                    if (Double.isNaN(fArray2[n4][n2])) {
                        n3 = -1;
                        break;
                    }
                    n3 = (int)((double)fArray2[n4][n2] + 0.5) + this.Lengths[n4] * n3;
                    --n4;
                }
                nArray[n2] = n3;
            }
            ++n2;
        }
        return nArray;
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        int n = 0;
        while (n < this.DomainDimension) {
            if (this.Lengths[n] < 2) {
                throw new SetException("GriddedSet.gridToValue: requires all grid dimensions to be > 1");
            }
            ++n;
        }
        throw new UnimplementedException("GriddedSet.gridToValue");
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        int n = 0;
        while (n < this.DomainDimension) {
            if (this.Lengths[n] < 2) {
                throw new SetException("GriddedSet.valueToGrid: requires all grid dimensions to be > 1");
            }
            ++n;
        }
        throw new UnimplementedException("GriddedSet.valueToGrid");
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        if (fArray.length != this.DomainDimension) {
            throw new SetException("GriddedSet.valueToInterp: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = fArray[0].length;
        if (nArray.length != n) {
            throw new SetException("GriddedSet.valueToInterp: indices length " + nArray.length + " doesn't match value[0] length " + fArray[0].length);
        }
        if (fArray2.length != n) {
            throw new SetException("GriddedSet.valueToInterp: weights length " + fArray2.length + " doesn't match value[0] length " + fArray[0].length);
        }
        float[][] fArray3 = this.valueToGrid(fArray);
        int[] nArray2 = new int[this.ManifoldDimension];
        float[] fArray4 = new float[this.ManifoldDimension];
        int[] nArray3 = new int[this.ManifoldDimension];
        nArray3[0] = 1;
        int n2 = 1;
        while (n2 < this.ManifoldDimension) {
            nArray3[n2] = nArray3[n2 - 1] * this.Lengths[n2 - 1];
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            float[] fArray5;
            int[] nArray4;
            int n4;
            int n5 = 1;
            if (Double.isNaN(fArray3[this.ManifoldDimension - 1][n3])) {
                n4 = -1;
            } else {
                nArray2[this.ManifoldDimension - 1] = (int)((double)fArray3[this.ManifoldDimension - 1][n3] + 0.5);
                if (nArray2[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n6 = this.ManifoldDimension - 1;
                    nArray2[n6] = nArray2[n6] - 1;
                }
                fArray4[this.ManifoldDimension - 1] = fArray3[this.ManifoldDimension - 1][n3] - (float)nArray2[this.ManifoldDimension - 1];
                if (!(nArray2[this.ManifoldDimension - 1] == 0 && (double)fArray4[this.ManifoldDimension - 1] <= 0.0 || nArray2[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && (double)fArray4[this.ManifoldDimension - 1] >= 0.0)) {
                    n5 *= 2;
                }
                if ((n4 = nArray2[this.ManifoldDimension - 1]) >= this.Lengths[this.ManifoldDimension - 1]) {
                    n4 = -1;
                }
            }
            n2 = this.ManifoldDimension - 2;
            while (n2 >= 0 && n4 >= 0) {
                if (Double.isNaN(fArray3[n2][n3])) {
                    n4 = -1;
                } else {
                    nArray2[n2] = (int)((double)fArray3[n2][n3] + 0.5);
                    if (nArray2[n2] == this.Lengths[n2]) {
                        int n7 = n2;
                        nArray2[n7] = nArray2[n7] - 1;
                    }
                    fArray4[n2] = fArray3[n2][n3] - (float)nArray2[n2];
                    if (!(nArray2[n2] == 0 && (double)fArray4[n2] <= 0.0 || nArray2[n2] == this.Lengths[n2] - 1 && (double)fArray4[n2] >= 0.0)) {
                        n5 *= 2;
                    }
                    n4 = nArray2[n2] + this.Lengths[n2] * n4;
                    if (nArray2[n2] < 0 || nArray2[n2] >= this.Lengths[n2]) {
                        n4 = -1;
                    }
                }
                --n2;
            }
            if (n4 < 0) {
                nArray4 = null;
                fArray5 = null;
            } else {
                nArray4 = new int[n5];
                fArray5 = new float[n5];
                nArray4[0] = n4;
                fArray5[0] = 1.0f;
                int n8 = 1;
                n2 = 0;
                while (n2 < this.ManifoldDimension) {
                    if (!(nArray2[n2] == 0 && (double)fArray4[n2] <= 0.0 || nArray2[n2] == this.Lengths[n2] - 1 && (double)fArray4[n2] >= 0.0)) {
                        float f;
                        float f2;
                        int n9;
                        if ((double)fArray4[n2] >= 0.0) {
                            n9 = nArray3[n2];
                            f2 = 1.0f - fArray4[n2];
                            f = fArray4[n2];
                        } else {
                            n9 = -nArray3[n2];
                            f2 = 1.0f + fArray4[n2];
                            f = -fArray4[n2];
                        }
                        int n10 = 0;
                        while (n10 < n8) {
                            nArray4[n10 + n8] = nArray4[n10] + n9;
                            fArray5[n10 + n8] = fArray5[n10] * f;
                            int n11 = n10++;
                            fArray5[n11] = fArray5[n11] * f2;
                        }
                        n8 *= 2;
                    }
                    ++n2;
                }
            }
            nArray[n3] = nArray4;
            fArray2[n3] = fArray5;
            ++n3;
        }
    }

    public void getNeighbors(int[][] nArray) throws VisADException {
        switch (this.ManifoldDimension) {
            case 1: {
                nArray[0] = new int[2];
                nArray[this.Length - 1] = new int[2];
                nArray[0][0] = 1;
                nArray[this.Length - 1][0] = this.Length - 2;
                int n = 1;
                while (n < this.Length - 1) {
                    nArray[n] = new int[2];
                    nArray[n][0] = n - 1;
                    nArray[n][1] = n + 1;
                    ++n;
                }
                break;
            }
            case 2: {
                int n = this.Lengths[0];
                int n2 = this.Lengths[1];
                int n3 = 0;
                nArray[n3] = new int[2];
                nArray[n3][0] = n3 + n;
                nArray[n3][1] = n3 + 1;
                n3 = this.Length - 1;
                nArray[n3] = new int[2];
                nArray[n3][0] = n3 - n;
                nArray[n3][1] = n3 - 1;
                n3 = this.Length - n;
                nArray[n3] = new int[2];
                nArray[n3][0] = n3 - n;
                nArray[n3][1] = n3 + 1;
                n3 = n - 1;
                nArray[n3] = new int[2];
                nArray[n3][0] = n3 + n;
                nArray[n3][1] = n3 - 1;
                int n4 = 1;
                while (n4 < n2 - 1) {
                    n3 = n4 * n;
                    nArray[n3] = new int[3];
                    nArray[n3][0] = n3 + n;
                    nArray[n3][1] = n3 - n;
                    nArray[n3][2] = n3 + 1;
                    n3 = n4 * n + n - 1;
                    nArray[n3] = new int[3];
                    nArray[n3][0] = n3 + n;
                    nArray[n3][1] = n3 - n;
                    nArray[n3][2] = n3 - 1;
                    ++n4;
                }
                int n5 = 1;
                while (n5 < n - 1) {
                    n3 = n5;
                    nArray[n3] = new int[3];
                    nArray[n3][0] = n3 - 1;
                    nArray[n3][1] = n3 + 1;
                    nArray[n3][2] = n3 + n;
                    n3 = (n2 - 1) * n + n5;
                    nArray[n3] = new int[3];
                    nArray[n3][0] = n3 - 1;
                    nArray[n3][1] = n3 + 1;
                    nArray[n3][2] = n3 - n;
                    ++n5;
                }
                n4 = 1;
                while (n4 < n2 - 1) {
                    n5 = 1;
                    while (n5 < n - 1) {
                        n3 = n4 * n + n5;
                        int n6 = n3 + 1;
                        int n7 = n3 - 1;
                        int n8 = n3 + n;
                        int n9 = n3 - n;
                        nArray[n3] = new int[4];
                        nArray[n3][0] = n6;
                        nArray[n3][1] = n7;
                        nArray[n3][2] = n8;
                        nArray[n3][3] = n9;
                        ++n5;
                    }
                    ++n4;
                }
                break;
            }
            case 3: {
                int n = this.Lengths[0];
                int n10 = this.Lengths[1];
                int n11 = this.Lengths[2];
                int n12 = n * n10;
                int n13 = n * n10 * n11;
                int n14 = 0;
                nArray[n14] = new int[3];
                nArray[n14][0] = n14 + n;
                nArray[n14][1] = n14 + 1;
                nArray[n14][2] = n14 + n12;
                n14 = n * n10 * (n11 - 1);
                nArray[n14] = new int[3];
                nArray[n14][0] = n14 + 1;
                nArray[n14][1] = n14 + n;
                nArray[n14][2] = n14 - n12;
                n14 = n * n10 - 1;
                nArray[n14] = new int[3];
                nArray[n14][0] = n14 - n;
                nArray[n14][1] = n14 - 1;
                nArray[n14][2] = n14 + n12;
                n14 = n * n10 * n11 - 1;
                nArray[n14] = new int[3];
                nArray[n14][0] = n14 - 1;
                nArray[n14][1] = n14 - n;
                nArray[n14][2] = n14 - n12;
                n14 = n * (n10 - 1);
                nArray[n14] = new int[3];
                nArray[n14][0] = n14 - n;
                nArray[n14][1] = n14 + 1;
                nArray[n14][2] = n14 + n12;
                n14 = n12 * (n11 - 1) + n * (n10 - 1);
                nArray[n14] = new int[3];
                nArray[n14][0] = n14 + 1;
                nArray[n14][1] = n14 - n;
                nArray[n14][2] = n14 - n12;
                n14 = n - 1;
                nArray[n14] = new int[3];
                nArray[n14][0] = n14 + n;
                nArray[n14][1] = n14 - 1;
                nArray[n14][2] = n14 + n12;
                n14 = n12 * (n11 - 1) + (n - 1);
                nArray[n14] = new int[3];
                nArray[n14][0] = n14 - 1;
                nArray[n14][1] = n14 + n;
                nArray[n14][2] = n14 - n12;
                int n15 = 1;
                while (n15 < n10 - 1) {
                    n14 = n15 * n;
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 + n;
                    nArray[n14][1] = n14 - n;
                    nArray[n14][2] = n14 + 1;
                    nArray[n14][3] = n14 + n12;
                    n14 = n15 * n + n - 1;
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 + n;
                    nArray[n14][1] = n14 - n;
                    nArray[n14][2] = n14 - 1;
                    nArray[n14][3] = n14 + n12;
                    n14 = (n11 - 1) * n12 + n15 * n10;
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 + n;
                    nArray[n14][1] = n14 - n;
                    nArray[n14][2] = n14 - 1;
                    nArray[n14][3] = n14 - n12;
                    n14 = (n11 - 1) * n12 + n15 * n + n - 1;
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 + n;
                    nArray[n14][1] = n14 - n;
                    nArray[n14][2] = n14 - 1;
                    nArray[n14][3] = n14 - n12;
                    ++n15;
                }
                int n16 = 1;
                while (n16 < n - 1) {
                    n14 = n16;
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 - 1;
                    nArray[n14][1] = n14 + 1;
                    nArray[n14][2] = n14 + n;
                    nArray[n14][3] = n14 + n12;
                    n14 = (n10 - 1) * n + n16;
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 - 1;
                    nArray[n14][1] = n14 + 1;
                    nArray[n14][2] = n14 - n;
                    nArray[n14][3] = n14 + n12;
                    n14 = (n11 - 1) * n12 + n16;
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 - 1;
                    nArray[n14][1] = n14 + 1;
                    nArray[n14][2] = n14 + n;
                    nArray[n14][3] = n14 - n12;
                    n14 = (n11 - 1) * n12 + (n10 - 1) * n + n16;
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 - 1;
                    nArray[n14][1] = n14 + 1;
                    nArray[n14][2] = n14 - n;
                    nArray[n14][3] = n14 - n12;
                    ++n16;
                }
                int n17 = 1;
                while (n17 < n11 - 1) {
                    n14 = n17 * n12;
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 + 1;
                    nArray[n14][1] = n14 + n;
                    nArray[n14][2] = n14 + n12;
                    nArray[n14][3] = n14 - n12;
                    n14 = n17 * n12 + (n - 1);
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 - 1;
                    nArray[n14][1] = n14 + n;
                    nArray[n14][2] = n14 + n12;
                    nArray[n14][3] = n14 + n12;
                    n14 = n17 * n12 + n * (n10 - 1);
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 + 1;
                    nArray[n14][1] = n14 - n;
                    nArray[n14][2] = n14 + n12;
                    nArray[n14][3] = n14 - n12;
                    n14 = n17 * n12 + (n12 - 1);
                    nArray[n14] = new int[4];
                    nArray[n14][0] = n14 - 1;
                    nArray[n14][1] = n14 - n;
                    nArray[n14][2] = n14 + n12;
                    nArray[n14][3] = n14 - n12;
                    ++n17;
                }
                n15 = 1;
                while (n15 < n10 - 1) {
                    n16 = 1;
                    while (n16 < n - 1) {
                        n14 = n15 * n + n16;
                        nArray[n14] = new int[5];
                        nArray[n14][0] = n14 + 1;
                        nArray[n14][1] = n14 - 1;
                        nArray[n14][2] = n14 + n;
                        nArray[n14][3] = n14 - n;
                        nArray[n14][4] = n14 + n12;
                        n14 = (n11 - 1) * n12 + n15 * n + n16;
                        nArray[n14] = new int[5];
                        nArray[n14][0] = n14 + 1;
                        nArray[n14][1] = n14 - 1;
                        nArray[n14][2] = n14 + n;
                        nArray[n14][3] = n14 - n;
                        nArray[n14][4] = n14 - n12;
                        ++n16;
                    }
                    ++n15;
                }
                n17 = 1;
                while (n17 < n11 - 1) {
                    n16 = 1;
                    while (n16 < n - 1) {
                        n14 = n17 * n12 + n16;
                        nArray[n14] = new int[5];
                        nArray[n14][0] = n14 + 1;
                        nArray[n14][1] = n14 - 1;
                        nArray[n14][2] = n14 + n;
                        nArray[n14][3] = n14 + n12;
                        nArray[n14][4] = n14 - n12;
                        n14 = n17 * n12 + n * (n10 - 1) + n16;
                        nArray[n14] = new int[5];
                        nArray[n14][0] = n14 + 1;
                        nArray[n14][1] = n14 - 1;
                        nArray[n14][2] = n14 - n;
                        nArray[n14][3] = n14 + n12;
                        nArray[n14][4] = n14 - n12;
                        ++n16;
                    }
                    ++n17;
                }
                n17 = 1;
                while (n17 < n11 - 1) {
                    n15 = 1;
                    while (n15 < n10 - 1) {
                        n14 = n17 * n12 + n15 * n;
                        nArray[n14] = new int[5];
                        nArray[n14][0] = n14 + 1;
                        nArray[n14][1] = n14 + n;
                        nArray[n14][2] = n14 - n;
                        nArray[n14][3] = n14 + n12;
                        nArray[n14][4] = n14 - n12;
                        n14 = n17 * n12 + n15 * n + (n - 1);
                        nArray[n14] = new int[5];
                        nArray[n14][0] = n14 - 1;
                        nArray[n14][1] = n14 + n;
                        nArray[n14][2] = n14 - n;
                        nArray[n14][3] = n14 + n12;
                        nArray[n14][4] = n14 - n12;
                        ++n15;
                    }
                    ++n17;
                }
                n17 = 1;
                while (n17 < n11 - 1) {
                    n15 = 1;
                    while (n15 < n10 - 1) {
                        n16 = 1;
                        while (n16 < n - 1) {
                            n14 = n17 * n12 + n15 * n + n16;
                            int n18 = n14 + 1;
                            int n19 = n14 - 1;
                            int n20 = n14 + n;
                            int n21 = n14 - n;
                            int n22 = n14 + n12;
                            int n23 = n14 - n12;
                            nArray[n14] = new int[6];
                            nArray[n14][0] = n18;
                            nArray[n14][1] = n19;
                            nArray[n14][2] = n20;
                            nArray[n14][3] = n21;
                            nArray[n14][4] = n22;
                            nArray[n14][5] = n23;
                            ++n16;
                        }
                        ++n15;
                    }
                    ++n17;
                }
                break;
            }
            default: {
                throw new UnimplementedException("getNeighbors(): ManifoldDimension >" + this.ManifoldDimension + " not currently implemented");
            }
        }
    }

    public int[][] getNeighbors(int n) {
        int[][] nArray = new int[this.Length][2];
        int[] nArray2 = new int[this.ManifoldDimension];
        int[][] nArray3 = new int[2][this.ManifoldDimension];
        int n2 = 0;
        while (n2 < this.Length) {
            int n3 = n2;
            int n4 = 0;
            while (n4 < this.ManifoldDimension - 1) {
                nArray2[n4] = n3 % this.Lengths[n4];
                n3 /= this.Lengths[n4];
                ++n4;
            }
            nArray2[this.ManifoldDimension - 1] = n3;
            int n5 = 0;
            while (n5 < 2) {
                n4 = 0;
                while (n4 < this.ManifoldDimension) {
                    nArray3[n5][n4] = nArray2[n4];
                    ++n4;
                }
                ++n5;
            }
            int n6 = nArray2[n] + 1;
            int n7 = nArray2[n] - 1;
            nArray3[1][n] = n6;
            nArray3[0][n] = n7;
            if (n6 >= this.Lengths[n]) {
                nArray3[1][n] = -1;
            } else if (n7 < 0) {
                nArray3[0][n] = -1;
            }
            n5 = 0;
            while (n5 < 2) {
                if (nArray3[n5][n] != -1) {
                    n3 = 0;
                    int n8 = this.ManifoldDimension - 1;
                    while (n8 >= 0) {
                        int n9 = nArray3[n5][n8];
                        int n10 = 0;
                        while (n10 < n8) {
                            n9 *= this.Lengths[n10];
                            ++n10;
                        }
                        n3 += n9;
                        --n8;
                    }
                    nArray[n2][n5] = n3;
                } else {
                    nArray[n2][n5] = -1;
                }
                ++n5;
            }
            ++n2;
        }
        return nArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GriddedSet) || object == null || object instanceof LinearSet || object instanceof Gridded1DDoubleSet) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.testNotEqualsCache((Set)object)) {
            return false;
        }
        if (this.testEqualsCache((Set)object)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        try {
            if (this.DomainDimension != ((GriddedSet)object).getDimension() || this.ManifoldDimension != ((GriddedSet)object).getManifoldDimension() || this.Length != ((GriddedSet)object).getLength()) {
                return false;
            }
            int n = 0;
            while (n < this.ManifoldDimension) {
                if (this.Lengths[n] != ((GriddedSet)object).getLength(n)) {
                    return false;
                }
                ++n;
            }
            float[][] fArray = ((GriddedSet)object).getSamples(false);
            if (this.Samples != null) {
                n = 0;
                while (n < this.DomainDimension) {
                    int n2 = 0;
                    while (n2 < this.Length) {
                        if (this.Samples[n][n2] != fArray[n][n2]) {
                            this.addNotEqualsCache((Set)object);
                            return false;
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else {
                float[][] fArray2 = this.getSamples(false);
                n = 0;
                while (n < this.DomainDimension) {
                    int n3 = 0;
                    while (n3 < this.Length) {
                        if (fArray2[n][n3] != fArray[n][n3]) {
                            this.addNotEqualsCache((Set)object);
                            return false;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            this.addEqualsCache((Set)object);
            return true;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode();
            this.hashCode ^= this.DomainDimension ^ this.ManifoldDimension ^ this.Length;
            int n = 0;
            while (n < this.ManifoldDimension) {
                this.hashCode ^= this.Lengths[n];
                ++n;
            }
            if (this.Samples != null) {
                n = 0;
                while (n < this.DomainDimension) {
                    int n2 = 0;
                    while (n2 < this.Length) {
                        this.hashCode ^= Float.floatToIntBits(this.Samples[n][n2]);
                        ++n2;
                    }
                    ++n;
                }
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object clone() {
        try {
            return new GriddedSet(this.Type, this.Samples, this.Lengths, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("GriddedSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new GriddedSet(mathType, this.Samples, this.Lengths, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public String longString(String string) throws VisADException {
        String string2;
        if (this.DomainDimension == this.ManifoldDimension) {
            string2 = string + this.getClass().getName() + ": Dimension = " + this.DomainDimension + " Length = " + this.Length + "\n";
            int n = 0;
            while (n < this.DomainDimension) {
                string2 = string2 + string + "  Dimension " + n + ":" + " Length = " + this.Lengths[n] + " Range = " + this.Low[n] + " to " + this.Hi[n] + "\n";
                ++n;
            }
        } else {
            string2 = string + this.getClass().getName() + ": DomainDimension = " + this.DomainDimension + " ManifoldDimension = " + this.ManifoldDimension + " Length = " + this.Length + "\n";
            int n = 0;
            while (n < this.ManifoldDimension) {
                string2 = string2 + string + "  ManifoldDimension " + n + ":" + " Length = " + this.Lengths[n] + "\n";
                ++n;
            }
            n = 0;
            while (n < this.DomainDimension) {
                string2 = string2 + string + "  DomainDimension " + n + ":" + " Range = " + this.Low[n] + " to " + this.Hi[n] + "\n";
                ++n;
            }
        }
        return string2;
    }

    public GriddedSet(MathType mathType, float[][] fArray, int[] nArray) throws VisADException {
        this(mathType, fArray, nArray, null, null, null, true);
    }

    public GriddedSet(MathType mathType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public GriddedSet(MathType mathType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, nArray.length, coordinateSystem, unitArray, errorEstimateArray);
        this.init_lengths(nArray);
        if (fArray == null) {
            this.Samples = null;
        } else {
            this.init_samples(fArray, bl);
        }
    }
}

