/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded3DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Gridded3DDoubleSet
extends Gridded3DSet
implements GriddedDoubleSet {
    double[] Low = new double[3];
    double[] Hi = new double[3];
    double LowX;
    double HiX;
    double LowY;
    double HiY;
    double LowZ;
    double HiZ;
    double[][] Samples;
    private int gx = -1;
    private int gy = -1;
    private int gz = -1;

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        return Set.doubleToFloat(this.Samples);
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(nArray));
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(fArray));
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        return Set.doubleToFloat(this.gridToDouble(Set.floatToDouble(fArray)));
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        return Set.doubleToFloat(this.doubleToGrid(Set.floatToDouble(fArray)));
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int n = fArray2.length;
        double[][] dArray = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = new double[fArray2[n2].length];
            ++n2;
        }
        this.doubleToInterp(Set.floatToDouble(fArray), nArray, dArray);
        n2 = 0;
        while (n2 < n) {
            System.arraycopy(dArray[n2], 0, fArray2[n2], 0, dArray.length);
            ++n2;
        }
    }

    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    public double[][] getDoubles(boolean bl) throws VisADException {
        return bl ? Set.copyDoubles(this.Samples) : this.Samples;
    }

    public double[][] indexToDouble(int[] nArray) throws VisADException {
        int n = nArray.length;
        if (this.Samples == null) {
            double[][] dArray = new double[this.ManifoldDimension][n];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                int n5;
                if (nArray[n2] >= 0 && nArray[n2] < this.Length) {
                    n5 = nArray[n2] % this.LengthX;
                    int n6 = nArray[n2] / this.LengthX;
                    n4 = n6 % this.LengthY;
                    n3 = n6 / this.LengthY;
                } else {
                    n5 = -1;
                    n4 = -1;
                    n3 = -1;
                }
                dArray[0][n2] = n5;
                dArray[1][n2] = n4;
                dArray[2][n2] = n3;
                ++n2;
            }
            return this.gridToDouble(dArray);
        }
        double[][] dArray = new double[3][n];
        int n7 = 0;
        while (n7 < n) {
            if (nArray[n7] >= 0 && nArray[n7] < this.Length) {
                dArray[0][n7] = this.Samples[0][nArray[n7]];
                dArray[1][n7] = this.Samples[1][nArray[n7]];
                dArray[2][n7] = this.Samples[2][nArray[n7]];
            } else {
                dArray[0][n7] = Double.NaN;
                dArray[1][n7] = Double.NaN;
                dArray[2][n7] = Double.NaN;
            }
            ++n7;
        }
        return dArray;
    }

    public int[] doubleToIndex(double[][] dArray) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.doubleToIndex: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = dArray[0].length;
        int[] nArray = new int[n];
        double[][] dArray2 = this.doubleToGrid(dArray);
        double[] dArray3 = dArray2[0];
        double[] dArray4 = dArray2[1];
        double[] dArray5 = dArray2[2];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray3[n2];
            double d2 = dArray4[n2];
            double d3 = dArray5[n2];
            nArray[n2] = d != d || d2 != d2 || d3 != d3 ? -1 : (int)(d + 0.5) + this.LengthX * ((int)(d2 + 0.5) + this.LengthY * (int)(d3 + 0.5));
            ++n2;
        }
        return nArray;
    }

    public double[][] gridToDouble(double[][] dArray) throws VisADException {
        if (dArray.length != this.ManifoldDimension) {
            throw new SetException("Gridded3DDoubleSet.gridToDouble: grid dimension " + dArray.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension == 3) {
            return this.gridToDouble3D(dArray);
        }
        if (this.ManifoldDimension == 2) {
            return this.gridToDouble2D(dArray);
        }
        throw new SetException("Gridded3DDoubleSet.gridToDouble: ManifoldDimension must be 2 or 3");
    }

    private double[][] gridToDouble2D(double[][] dArray) throws VisADException {
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Gridded3DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int n = Math.min(dArray[0].length, dArray[1].length);
        double[][] dArray2 = new double[3][n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[0][n2];
            double d2 = dArray[1][n2];
            if (d < -0.5 || d2 < -0.5 || d > (double)this.LengthX - 0.5 || d2 > (double)this.LengthY - 0.5) {
                dArray2[2][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
                dArray2[0][n2] = Double.NaN;
            } else {
                int n3;
                int n4 = (int)d;
                int n5 = (int)d2;
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 > this.LengthX - 2) {
                    n4 = this.LengthX - 2;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > this.LengthY - 2) {
                    n5 = this.LengthY - 2;
                }
                int[][] nArray = new int[][]{{this.LengthX * n5 + n4, this.LengthX * (n5 + 1) + n4}, {this.LengthX * n5 + n4 + 1, this.LengthX * (n5 + 1) + n4 + 1}};
                if (d + d2 - (double)n4 - (double)n5 - 1.0 <= 0.0) {
                    n3 = 0;
                    while (n3 < 3) {
                        dArray2[n3][n2] = this.Samples[n3][nArray[0][0]] + (d - (double)n4) * (this.Samples[n3][nArray[1][0]] - this.Samples[n3][nArray[0][0]]) + (d2 - (double)n5) * (this.Samples[n3][nArray[0][1]] - this.Samples[n3][nArray[0][0]]);
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < 3) {
                        dArray2[n3][n2] = this.Samples[n3][nArray[1][1]] + ((double)(1 + n4) - d) * (this.Samples[n3][nArray[0][1]] - this.Samples[n3][nArray[1][1]]) + ((double)(1 + n5) - d2) * (this.Samples[n3][nArray[1][0]] - this.Samples[n3][nArray[1][1]]);
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return dArray2;
    }

    private double[][] gridToDouble3D(double[][] dArray) throws VisADException {
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2) {
            throw new SetException("Gridded3DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int n = Math.min(dArray[0].length, dArray[1].length);
        n = Math.min(n, dArray[2].length);
        double[][] dArray2 = new double[3][n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[0][n2];
            double d2 = dArray[1][n2];
            double d3 = dArray[2][n2];
            if (d < -0.5 || d2 < -0.5 || d3 < -0.5 || d > (double)this.LengthX - 0.5 || d2 > (double)this.LengthY - 0.5 || d3 > (double)this.LengthZ - 0.5) {
                dArray2[2][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
                dArray2[0][n2] = Double.NaN;
            } else {
                int n3;
                boolean bl;
                double d4;
                double d5;
                double d6;
                boolean bl2;
                int n4 = d < 0.0 ? 0 : (d > (double)(this.LengthX - 2) ? this.LengthX - 2 : (int)d);
                int n5 = d2 < 0.0 ? 0 : (d2 > (double)(this.LengthY - 2) ? this.LengthY - 2 : (int)d2);
                int n6 = d3 < 0.0 ? 0 : (d3 > (double)(this.LengthZ - 2) ? this.LengthZ - 2 : (int)d3);
                boolean bl3 = bl2 = (n4 + n5 + n6) % 2 == 0;
                if (bl2) {
                    d6 = d - (double)n4;
                    d5 = d2 - (double)n5;
                    d4 = d3 - (double)n6;
                } else {
                    d6 = (double)(1 + n4) - d;
                    d5 = (double)(1 + n5) - d2;
                    d4 = (double)(1 + n6) - d3;
                }
                int n7 = this.LengthY * this.LengthX;
                int n8 = n6 * n7 + n5 * this.LengthX + n4;
                int n9 = n8 + n7;
                int n10 = n8 + n7 + 1;
                int n11 = n8 + n7 + this.LengthX + 1;
                int n12 = n8 + n7 + this.LengthX;
                int n13 = n8;
                int n14 = n8 + 1;
                int n15 = n8 + this.LengthX + 1;
                int n16 = n8 + this.LengthX;
                double[] dArray3 = new double[3];
                double[] dArray4 = new double[3];
                double[] dArray5 = new double[3];
                double[] dArray6 = new double[3];
                double[] dArray7 = new double[3];
                double[] dArray8 = new double[3];
                double[] dArray9 = new double[3];
                double[] dArray10 = new double[3];
                if (bl2) {
                    dArray3[0] = this.Samples[0][n9];
                    dArray3[1] = this.Samples[1][n9];
                    dArray3[2] = this.Samples[2][n9];
                    dArray4[0] = this.Samples[0][n10];
                    dArray4[1] = this.Samples[1][n10];
                    dArray4[2] = this.Samples[2][n10];
                    dArray5[0] = this.Samples[0][n11];
                    dArray5[1] = this.Samples[1][n11];
                    dArray5[2] = this.Samples[2][n11];
                    dArray6[0] = this.Samples[0][n12];
                    dArray6[1] = this.Samples[1][n12];
                    dArray6[2] = this.Samples[2][n12];
                    dArray7[0] = this.Samples[0][n13];
                    dArray7[1] = this.Samples[1][n13];
                    dArray7[2] = this.Samples[2][n13];
                    dArray8[0] = this.Samples[0][n14];
                    dArray8[1] = this.Samples[1][n14];
                    dArray8[2] = this.Samples[2][n14];
                    dArray9[0] = this.Samples[0][n15];
                    dArray9[1] = this.Samples[1][n15];
                    dArray9[2] = this.Samples[2][n15];
                    dArray10[0] = this.Samples[0][n16];
                    dArray10[1] = this.Samples[1][n16];
                    dArray10[2] = this.Samples[2][n16];
                } else {
                    dArray9[0] = this.Samples[0][n9];
                    dArray9[1] = this.Samples[1][n9];
                    dArray9[2] = this.Samples[2][n9];
                    dArray10[0] = this.Samples[0][n10];
                    dArray10[1] = this.Samples[1][n10];
                    dArray10[2] = this.Samples[2][n10];
                    dArray7[0] = this.Samples[0][n11];
                    dArray7[1] = this.Samples[1][n11];
                    dArray7[2] = this.Samples[2][n11];
                    dArray8[0] = this.Samples[0][n12];
                    dArray8[1] = this.Samples[1][n12];
                    dArray8[2] = this.Samples[2][n12];
                    dArray5[0] = this.Samples[0][n13];
                    dArray5[1] = this.Samples[1][n13];
                    dArray5[2] = this.Samples[2][n13];
                    dArray6[0] = this.Samples[0][n14];
                    dArray6[1] = this.Samples[1][n14];
                    dArray6[2] = this.Samples[2][n14];
                    dArray3[0] = this.Samples[0][n15];
                    dArray3[1] = this.Samples[1][n15];
                    dArray3[2] = this.Samples[2][n15];
                    dArray4[0] = this.Samples[0][n16];
                    dArray4[1] = this.Samples[1][n16];
                    dArray4[2] = this.Samples[2][n16];
                }
                boolean bl4 = 1.0 - d6 - d5 - d4 >= 0.0;
                boolean bl5 = d6 - d5 + d4 - 1.0 >= 0.0;
                boolean bl6 = d5 - d6 + d4 - 1.0 >= 0.0;
                boolean bl7 = bl = d6 + d5 - d4 - 1.0 >= 0.0;
                if (d < 0.0 || d > (double)(this.LengthX - 1) || d2 < 0.0 || d2 > (double)(this.LengthY - 1) || d3 < 0.0 || d3 > (double)(this.LengthZ - 1)) {
                    int n17 = 0;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = 0;
                    int n22 = 0;
                    int n23 = 0;
                    int n24 = 0;
                    n3 = 0;
                    if (n4 == 0) {
                        n3 = 1;
                    }
                    if (n5 == 0) {
                        n24 = 1;
                    }
                    if (n6 == 0) {
                        n23 = 1;
                    }
                    if (n4 == this.LengthX - 2) {
                        n19 = 1;
                    }
                    if (n5 == this.LengthY - 2) {
                        n18 = 1;
                    }
                    if (n6 == this.LengthZ - 2) {
                        n17 = 1;
                    }
                    if (n3 == 0 && n19 == 0) {
                        n22 = 1;
                    }
                    if (n24 == 0 && n18 == 0) {
                        n21 = 1;
                    }
                    if (n23 == 0 && n17 == 0) {
                        n20 = 1;
                    }
                    bl = false;
                    bl6 = false;
                    bl5 = false;
                    bl4 = false;
                    if (bl2) {
                        if (n19 == 0 && n18 == 0 && n17 == 0) {
                            bl4 = true;
                        } else if (n19 != 0 && n24 != 0 && n20 != 0 || n22 != 0 && n24 != 0 && n17 != 0 || n19 != 0 && n21 != 0 && n17 != 0 || n19 != 0 && n24 != 0 && n17 != 0 || n22 != 0 && n21 != 0 && n17 != 0 || n19 != 0 && n21 != 0 && n20 != 0) {
                            bl5 = true;
                        } else if (n3 != 0 && n18 != 0 && n20 != 0 || n3 != 0 && n21 != 0 && n17 != 0 || n22 != 0 && n18 != 0 && n17 != 0 || n3 != 0 && n18 != 0 && n17 != 0 || n22 != 0 && n18 != 0 && n20 != 0) {
                            bl6 = true;
                        } else if (n22 != 0 && n18 != 0 && n23 != 0 || n19 != 0 && n21 != 0 && n23 != 0 || n19 != 0 && n18 != 0 && n20 != 0 || n19 != 0 && n18 != 0 && n23 != 0) {
                            bl = true;
                        }
                    } else if (n3 == 0 && n24 == 0 && n23 == 0) {
                        bl4 = true;
                    } else if (n3 != 0 && n21 != 0 && n23 != 0 || n22 != 0 && n18 != 0 && n23 != 0 || n3 != 0 && n18 != 0 && n20 != 0 || n3 != 0 && n18 != 0 && n23 != 0 || n22 != 0 && n21 != 0 && n23 != 0 || n3 != 0 && n21 != 0 && n20 != 0) {
                        bl5 = true;
                    } else if (n19 != 0 && n21 != 0 && n23 != 0 || n22 != 0 && n24 != 0 && n23 != 0 || n19 != 0 && n24 != 0 && n20 != 0 || n19 != 0 && n24 != 0 && n23 != 0 || n22 != 0 && n24 != 0 && n20 != 0) {
                        bl6 = true;
                    } else if (n3 != 0 && n24 != 0 && n20 != 0 || n3 != 0 && n21 != 0 && n23 != 0 || n22 != 0 && n24 != 0 && n17 != 0 || n3 != 0 && n24 != 0 && n17 != 0) {
                        bl = true;
                    }
                }
                if (bl4) {
                    n3 = 0;
                    while (n3 < 3) {
                        dArray2[n3][n2] = dArray7[n3] + d6 * (dArray8[n3] - dArray7[n3]) + d5 * (dArray10[n3] - dArray7[n3]) + d4 * (dArray3[n3] - dArray7[n3]);
                        ++n3;
                    }
                } else if (bl5) {
                    n3 = 0;
                    while (n3 < 3) {
                        dArray2[n3][n2] = dArray4[n3] + (1.0 - d6) * (dArray3[n3] - dArray4[n3]) + d5 * (dArray5[n3] - dArray4[n3]) + (1.0 - d4) * (dArray8[n3] - dArray4[n3]);
                        ++n3;
                    }
                } else if (bl6) {
                    n3 = 0;
                    while (n3 < 3) {
                        dArray2[n3][n2] = dArray6[n3] + d6 * (dArray5[n3] - dArray6[n3]) + (1.0 - d5) * (dArray3[n3] - dArray6[n3]) + (1.0 - d4) * (dArray10[n3] - dArray6[n3]);
                        ++n3;
                    }
                } else if (bl) {
                    n3 = 0;
                    while (n3 < 3) {
                        dArray2[n3][n2] = dArray9[n3] + (1.0 - d6) * (dArray10[n3] - dArray9[n3]) + (1.0 - d5) * (dArray8[n3] - dArray9[n3]) + d4 * (dArray5[n3] - dArray9[n3]);
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < 3) {
                        dArray2[n3][n2] = (dArray10[n3] + dArray8[n3] + dArray3[n3] - dArray5[n3]) / 2.0 + d6 * (dArray5[n3] + dArray8[n3] - dArray10[n3] - dArray3[n3]) / 2.0 + d5 * (dArray5[n3] - dArray8[n3] + dArray10[n3] - dArray3[n3]) / 2.0 + d4 * (dArray5[n3] - dArray8[n3] - dArray10[n3] + dArray3[n3]) / 2.0;
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] doubleToGrid(double[][] dArray) throws VisADException {
        if (dArray.length < this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.doubleToGrid: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.ManifoldDimension < 3) {
            throw new SetException("Gridded3DDoubleSet.doubleToGrid: ManifoldDimension must be 3");
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2) {
            throw new SetException("Gridded3DDoubleSet.doubleToGrid: requires all grid dimensions to be > 1");
        }
        int n = Math.min(dArray[0].length, dArray[1].length);
        n = Math.min(n, dArray[2].length);
        double[][] dArray2 = new double[this.ManifoldDimension][n];
        if (this.gx < 0 || this.gx >= this.LengthX || this.gy < 0 || this.gy >= this.LengthY || this.gz < 0 || this.gz >= this.LengthZ) {
            this.gx = (this.LengthX - 1) / 2;
            this.gy = (this.LengthY - 1) / 2;
            this.gz = (this.LengthZ - 1) / 2;
        }
        int n2 = 0;
        while (n2 < n) {
            boolean bl = false;
            if (n2 != 0 && dArray2[0][n2 - 1] != dArray2[0][n2 - 1]) {
                this.gx = (this.LengthX - 1) / 2;
                this.gy = (this.LengthY - 1) / 2;
                this.gz = (this.LengthZ - 1) / 2;
            }
            int n3 = 5;
            dArray2[2][n2] = Double.NaN;
            dArray2[1][n2] = Double.NaN;
            dArray2[0][n2] = Double.NaN;
            int n4 = 0;
            while (n4 < 2 * (this.LengthX + this.LengthY + this.LengthZ)) {
                double d;
                double d2;
                double d3;
                double d4;
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                double d10;
                double d11;
                double d12;
                double d13;
                double d14;
                double d15;
                int n5;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                double d16;
                double d17;
                double d18;
                boolean bl5 = (this.gx + this.gy + this.gz) % 2 == 0;
                int n6 = this.LengthY * this.LengthX;
                int n7 = this.gz * n6 + this.gy * this.LengthX + this.gx;
                int n8 = n7 + n6;
                int n9 = n7 + n6 + 1;
                int n10 = n7 + n6 + this.LengthX + 1;
                int n11 = n7 + n6 + this.LengthX;
                int n12 = n7;
                int n13 = n7 + 1;
                int n14 = n7 + this.LengthX + 1;
                int n15 = n7 + this.LengthX;
                double[] dArray3 = new double[3];
                double[] dArray4 = new double[3];
                double[] dArray5 = new double[3];
                double[] dArray6 = new double[3];
                double[] dArray7 = new double[3];
                double[] dArray8 = new double[3];
                double[] dArray9 = new double[3];
                double[] dArray10 = new double[3];
                if (bl5) {
                    dArray3[0] = this.Samples[0][n8];
                    dArray3[1] = this.Samples[1][n8];
                    dArray3[2] = this.Samples[2][n8];
                    dArray4[0] = this.Samples[0][n9];
                    dArray4[1] = this.Samples[1][n9];
                    dArray4[2] = this.Samples[2][n9];
                    dArray5[0] = this.Samples[0][n10];
                    dArray5[1] = this.Samples[1][n10];
                    dArray5[2] = this.Samples[2][n10];
                    dArray6[0] = this.Samples[0][n11];
                    dArray6[1] = this.Samples[1][n11];
                    dArray6[2] = this.Samples[2][n11];
                    dArray7[0] = this.Samples[0][n12];
                    dArray7[1] = this.Samples[1][n12];
                    dArray7[2] = this.Samples[2][n12];
                    dArray8[0] = this.Samples[0][n13];
                    dArray8[1] = this.Samples[1][n13];
                    dArray8[2] = this.Samples[2][n13];
                    dArray9[0] = this.Samples[0][n14];
                    dArray9[1] = this.Samples[1][n14];
                    dArray9[2] = this.Samples[2][n14];
                    dArray10[0] = this.Samples[0][n15];
                    dArray10[1] = this.Samples[1][n15];
                    dArray10[2] = this.Samples[2][n15];
                } else {
                    dArray9[0] = this.Samples[0][n8];
                    dArray9[1] = this.Samples[1][n8];
                    dArray9[2] = this.Samples[2][n8];
                    dArray10[0] = this.Samples[0][n9];
                    dArray10[1] = this.Samples[1][n9];
                    dArray10[2] = this.Samples[2][n9];
                    dArray7[0] = this.Samples[0][n10];
                    dArray7[1] = this.Samples[1][n10];
                    dArray7[2] = this.Samples[2][n10];
                    dArray8[0] = this.Samples[0][n11];
                    dArray8[1] = this.Samples[1][n11];
                    dArray8[2] = this.Samples[2][n11];
                    dArray5[0] = this.Samples[0][n12];
                    dArray5[1] = this.Samples[1][n12];
                    dArray5[2] = this.Samples[2][n12];
                    dArray6[0] = this.Samples[0][n13];
                    dArray6[1] = this.Samples[1][n13];
                    dArray6[2] = this.Samples[2][n13];
                    dArray3[0] = this.Samples[0][n14];
                    dArray3[1] = this.Samples[1][n14];
                    dArray3[2] = this.Samples[2][n14];
                    dArray4[0] = this.Samples[0][n15];
                    dArray4[1] = this.Samples[1][n15];
                    dArray4[2] = this.Samples[2][n15];
                }
                int n16 = this.gx;
                int n17 = this.gy;
                int n18 = this.gz;
                if (n3 == 1) {
                    d18 = ((dArray7[1] - dArray3[1]) * (dArray8[2] - dArray7[2]) - (dArray7[2] - dArray3[2]) * (dArray8[1] - dArray7[1])) * (dArray[0][n2] - dArray7[0]) + ((dArray7[2] - dArray3[2]) * (dArray8[0] - dArray7[0]) - (dArray7[0] - dArray3[0]) * (dArray8[2] - dArray7[2])) * (dArray[1][n2] - dArray7[1]) + ((dArray7[0] - dArray3[0]) * (dArray8[1] - dArray7[1]) - (dArray7[1] - dArray3[1]) * (dArray8[0] - dArray7[0])) * (dArray[2][n2] - dArray7[2]);
                    d17 = ((dArray7[1] - dArray10[1]) * (dArray3[2] - dArray7[2]) - (dArray7[2] - dArray10[2]) * (dArray3[1] - dArray7[1])) * (dArray[0][n2] - dArray7[0]) + ((dArray7[2] - dArray10[2]) * (dArray3[0] - dArray7[0]) - (dArray7[0] - dArray10[0]) * (dArray3[2] - dArray7[2])) * (dArray[1][n2] - dArray7[1]) + ((dArray7[0] - dArray10[0]) * (dArray3[1] - dArray7[1]) - (dArray7[1] - dArray10[1]) * (dArray3[0] - dArray7[0])) * (dArray[2][n2] - dArray7[2]);
                    d16 = ((dArray7[1] - dArray8[1]) * (dArray10[2] - dArray7[2]) - (dArray7[2] - dArray8[2]) * (dArray10[1] - dArray7[1])) * (dArray[0][n2] - dArray7[0]) + ((dArray7[2] - dArray8[2]) * (dArray10[0] - dArray7[0]) - (dArray7[0] - dArray8[0]) * (dArray10[2] - dArray7[2])) * (dArray[1][n2] - dArray7[1]) + ((dArray7[0] - dArray8[0]) * (dArray10[1] - dArray7[1]) - (dArray7[1] - dArray8[1]) * (dArray10[0] - dArray7[0])) * (dArray[2][n2] - dArray7[2]);
                    boolean bl6 = d18 != 0.0 && !(d18 > 0.0 == !bl5 ^ this.Pos) ? false : (bl4 = true);
                    boolean bl7 = d17 != 0.0 && !(d17 > 0.0 == !bl5 ^ this.Pos) ? false : (bl3 = true);
                    bl2 = d16 == 0.0 || d16 > 0.0 == !bl5 ^ this.Pos;
                    int n19 = n5 = bl5 ? -1 : 1;
                    if (!bl4) {
                        this.gy += n5;
                    }
                    if (!bl3) {
                        this.gx += n5;
                    }
                    if (!bl2) {
                        this.gz += n5;
                    }
                    n3 = 5;
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gz < 0) {
                        this.gz = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gz > this.LengthZ - 2) {
                        this.gz = this.LengthZ - 2;
                    }
                    if (!(this.gx != n16 || this.gy != n17 || this.gz != n18 || bl4 && bl3 && bl2 || bl)) {
                        bl = true;
                    } else if (this.gx == n16 && this.gy == n17 && this.gz == n18 || bl) {
                        double d19;
                        double[] dArray11 = new double[3];
                        double[] dArray12 = new double[3];
                        double[] dArray13 = new double[3];
                        double[] dArray14 = new double[3];
                        double[] dArray15 = new double[3];
                        double[] dArray16 = new double[3];
                        int n20 = 0;
                        while (n20 < 3) {
                            dArray11[n20] = (dArray8[n20] - dArray7[n20]) * (dArray3[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]) - (dArray8[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]) * (dArray3[n20] - dArray7[n20]);
                            dArray12[n20] = (dArray10[n20] - dArray7[n20]) * (dArray3[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]) - (dArray10[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]) * (dArray3[n20] - dArray7[n20]);
                            dArray13[n20] = (dArray8[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]) * (dArray3[(n20 + 2) % 3] - dArray7[(n20 + 2) % 3]) - (dArray8[(n20 + 2) % 3] - dArray7[(n20 + 2) % 3]) * (dArray3[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]);
                            dArray14[n20] = (dArray10[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]) * (dArray3[(n20 + 2) % 3] - dArray7[(n20 + 2) % 3]) - (dArray10[(n20 + 2) % 3] - dArray7[(n20 + 2) % 3]) * (dArray3[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]);
                            dArray15[n20] = dArray[(n20 + 2) % 3][n2] * (dArray3[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]) - dArray[(n20 + 1) % 3][n2] * (dArray3[(n20 + 2) % 3] - dArray7[(n20 + 2) % 3]) + dArray7[(n20 + 1) % 3] * dArray3[(n20 + 2) % 3] - dArray7[(n20 + 2) % 3] * dArray3[(n20 + 1) % 3];
                            dArray16[n20] = dArray[n20][n2] * (dArray3[(n20 + 1) % 3] - dArray7[(n20 + 1) % 3]) - dArray[(n20 + 1) % 3][n2] * (dArray3[n20] - dArray7[n20]) + dArray7[(n20 + 1) % 3] * dArray3[n20] - dArray7[n20] * dArray3[(n20 + 1) % 3];
                            ++n20;
                        }
                        d15 = dArray11[0] * dArray14[0] - dArray12[0] * dArray13[0];
                        d14 = dArray11[1] * dArray14[1] - dArray12[1] * dArray13[1];
                        d13 = dArray11[2] * dArray14[2] - dArray12[2] * dArray13[2];
                        d12 = Math.abs(d15);
                        d11 = Math.abs(d14);
                        d10 = Math.abs(d13);
                        if (d12 > d11 && d12 > d10) {
                            d19 = (dArray12[0] * dArray15[0] + dArray14[0] * dArray16[0]) / d15;
                            d9 = -(dArray11[0] * dArray15[0] + dArray13[0] * dArray16[0]) / d15;
                        } else if (d11 > d10) {
                            d19 = (dArray12[1] * dArray15[1] + dArray14[1] * dArray16[1]) / d14;
                            d9 = -(dArray11[1] * dArray15[1] + dArray13[1] * dArray16[1]) / d14;
                        } else {
                            d19 = (dArray12[2] * dArray15[2] + dArray14[2] * dArray16[2]) / d13;
                            d9 = -(dArray11[2] * dArray15[2] + dArray13[2] * dArray16[2]) / d13;
                        }
                        d15 = dArray3[0] - dArray7[0];
                        d14 = dArray3[1] - dArray7[1];
                        d13 = dArray3[2] - dArray7[2];
                        d12 = Math.abs(d15);
                        d11 = Math.abs(d14);
                        d10 = Math.abs(d13);
                        d8 = d12 > d11 && d12 > d10 ? (dArray[0][n2] - dArray7[0] - d19 * (dArray8[0] - dArray7[0]) - d9 * (dArray10[0] - dArray7[0])) / d15 : (d11 > d10 ? (dArray[1][n2] - dArray7[1] - d19 * (dArray8[1] - dArray7[1]) - d9 * (dArray10[1] - dArray7[1])) / d14 : (dArray[2][n2] - dArray7[2] - d19 * (dArray8[2] - dArray7[2]) - d9 * (dArray10[2] - dArray7[2])) / d13);
                        if (bl5) {
                            dArray2[0][n2] = (double)this.gx + d19;
                            dArray2[1][n2] = (double)this.gy + d9;
                            dArray2[2][n2] = (double)this.gz + d8;
                            break;
                        }
                        dArray2[0][n2] = (double)(this.gx + 1) - d19;
                        dArray2[1][n2] = (double)(this.gy + 1) - d9;
                        dArray2[2][n2] = (double)(this.gz + 1) - d8;
                        break;
                    }
                } else if (n3 == 2) {
                    d18 = ((dArray4[1] - dArray5[1]) * (dArray8[2] - dArray4[2]) - (dArray4[2] - dArray5[2]) * (dArray8[1] - dArray4[1])) * (dArray[0][n2] - dArray4[0]) + ((dArray4[2] - dArray5[2]) * (dArray8[0] - dArray4[0]) - (dArray4[0] - dArray5[0]) * (dArray8[2] - dArray4[2])) * (dArray[1][n2] - dArray4[1]) + ((dArray4[0] - dArray5[0]) * (dArray8[1] - dArray4[1]) - (dArray4[1] - dArray5[1]) * (dArray8[0] - dArray4[0])) * (dArray[2][n2] - dArray4[2]);
                    d17 = ((dArray4[1] - dArray3[1]) * (dArray5[2] - dArray4[2]) - (dArray4[2] - dArray3[2]) * (dArray5[1] - dArray4[1])) * (dArray[0][n2] - dArray4[0]) + ((dArray4[2] - dArray3[2]) * (dArray5[0] - dArray4[0]) - (dArray4[0] - dArray3[0]) * (dArray5[2] - dArray4[2])) * (dArray[1][n2] - dArray4[1]) + ((dArray4[0] - dArray3[0]) * (dArray5[1] - dArray4[1]) - (dArray4[1] - dArray3[1]) * (dArray5[0] - dArray4[0])) * (dArray[2][n2] - dArray4[2]);
                    d16 = ((dArray4[1] - dArray8[1]) * (dArray3[2] - dArray4[2]) - (dArray4[2] - dArray8[2]) * (dArray3[1] - dArray4[1])) * (dArray[0][n2] - dArray4[0]) + ((dArray4[2] - dArray8[2]) * (dArray3[0] - dArray4[0]) - (dArray4[0] - dArray8[0]) * (dArray3[2] - dArray4[2])) * (dArray[1][n2] - dArray4[1]) + ((dArray4[0] - dArray8[0]) * (dArray3[1] - dArray4[1]) - (dArray4[1] - dArray8[1]) * (dArray3[0] - dArray4[0])) * (dArray[2][n2] - dArray4[2]);
                    boolean bl8 = d18 != 0.0 && !(d18 > 0.0 == !bl5 ^ this.Pos) ? false : (bl4 = true);
                    boolean bl9 = d17 != 0.0 && !(d17 > 0.0 == !bl5 ^ this.Pos) ? false : (bl3 = true);
                    boolean bl10 = d16 != 0.0 && !(d16 > 0.0 == !bl5 ^ this.Pos) ? false : (bl2 = true);
                    if (!bl4 && bl5) {
                        ++this.gx;
                    }
                    if (!bl4 && !bl5) {
                        --this.gx;
                    }
                    if (!bl3 && bl5) {
                        ++this.gz;
                    }
                    if (!bl3 && !bl5) {
                        --this.gz;
                    }
                    if (!bl2 && bl5) {
                        --this.gy;
                    }
                    if (!bl2 && !bl5) {
                        ++this.gy;
                    }
                    n3 = 5;
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gz < 0) {
                        this.gz = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gz > this.LengthZ - 2) {
                        this.gz = this.LengthZ - 2;
                    }
                    if (!(this.gx != n16 || this.gy != n17 || this.gz != n18 || bl4 && bl3 && bl2 || bl)) {
                        bl = true;
                    } else if (this.gx == n16 && this.gy == n17 && this.gz == n18 || bl) {
                        double d20;
                        double d21;
                        double[] dArray17 = new double[3];
                        double[] dArray18 = new double[3];
                        double[] dArray19 = new double[3];
                        double[] dArray20 = new double[3];
                        double[] dArray21 = new double[3];
                        double[] dArray22 = new double[3];
                        int n21 = 0;
                        while (n21 < 3) {
                            dArray17[n21] = (dArray3[n21] - dArray4[n21]) * (dArray8[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]) - (dArray3[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]) * (dArray8[n21] - dArray4[n21]);
                            dArray18[n21] = (dArray5[n21] - dArray4[n21]) * (dArray8[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]) - (dArray5[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]) * (dArray8[n21] - dArray4[n21]);
                            dArray19[n21] = (dArray3[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]) * (dArray8[(n21 + 2) % 3] - dArray4[(n21 + 2) % 3]) - (dArray3[(n21 + 2) % 3] - dArray4[(n21 + 2) % 3]) * (dArray8[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]);
                            dArray20[n21] = (dArray5[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]) * (dArray8[(n21 + 2) % 3] - dArray4[(n21 + 2) % 3]) - (dArray5[(n21 + 2) % 3] - dArray4[(n21 + 2) % 3]) * (dArray8[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]);
                            dArray21[n21] = dArray[(n21 + 2) % 3][n2] * (dArray8[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]) - dArray[(n21 + 1) % 3][n2] * (dArray8[(n21 + 2) % 3] - dArray4[(n21 + 2) % 3]) + dArray4[(n21 + 1) % 3] * dArray8[(n21 + 2) % 3] - dArray4[(n21 + 2) % 3] * dArray8[(n21 + 1) % 3];
                            dArray22[n21] = dArray[n21][n2] * (dArray8[(n21 + 1) % 3] - dArray4[(n21 + 1) % 3]) - dArray[1][n2] * (dArray8[n21] - dArray4[n21]) + dArray4[(n21 + 1) % 3] * dArray8[n21] - dArray4[n21] * dArray8[(n21 + 1) % 3];
                            ++n21;
                        }
                        d7 = dArray17[0] * dArray20[0] - dArray18[0] * dArray19[0];
                        d6 = dArray17[1] * dArray20[1] - dArray18[1] * dArray19[1];
                        d5 = dArray17[2] * dArray20[2] - dArray18[2] * dArray19[2];
                        d4 = Math.abs(d7);
                        d3 = Math.abs(d6);
                        d2 = Math.abs(d5);
                        if (d4 > d3 && d4 > d2) {
                            d21 = 1.0 - (dArray18[0] * dArray21[0] + dArray20[0] * dArray22[0]) / d7;
                            d20 = -(dArray17[0] * dArray21[0] + dArray19[0] * dArray22[0]) / d7;
                        } else if (d3 > d2) {
                            d21 = 1.0 - (dArray18[1] * dArray21[1] + dArray20[1] * dArray22[1]) / d6;
                            d20 = -(dArray17[1] * dArray21[1] + dArray19[1] * dArray22[1]) / d6;
                        } else {
                            d21 = 1.0 - (dArray18[2] * dArray21[2] + dArray20[2] * dArray22[2]) / d5;
                            d20 = -(dArray17[2] * dArray21[2] + dArray19[2] * dArray22[2]) / d5;
                        }
                        d7 = dArray8[0] - dArray4[0];
                        d6 = dArray8[1] - dArray4[1];
                        d5 = dArray8[2] - dArray4[2];
                        d4 = Math.abs(d7);
                        d3 = Math.abs(d6);
                        d2 = Math.abs(d5);
                        d = d4 > d3 && d4 > d2 ? 1.0 - (dArray[0][n2] - dArray4[0] - (1.0 - d21) * (dArray3[0] - dArray4[0]) - d20 * (dArray5[0] - dArray4[0])) / d7 : (d3 > d2 ? 1.0 - (dArray[1][n2] - dArray4[1] - (1.0 - d21) * (dArray3[1] - dArray4[1]) - d20 * (dArray5[1] - dArray4[1])) / d6 : 1.0 - (dArray[2][n2] - dArray4[2] - (1.0 - d21) * (dArray3[2] - dArray4[2]) - d20 * (dArray5[2] - dArray4[2])) / d5);
                        if (bl5) {
                            dArray2[0][n2] = (double)this.gx + d21;
                            dArray2[1][n2] = (double)this.gy + d20;
                            dArray2[2][n2] = (double)this.gz + d;
                            break;
                        }
                        dArray2[0][n2] = (double)(this.gx + 1) - d21;
                        dArray2[1][n2] = (double)(this.gy + 1) - d20;
                        dArray2[2][n2] = (double)(this.gz + 1) - d;
                        break;
                    }
                } else if (n3 == 3) {
                    d18 = ((dArray6[1] - dArray3[1]) * (dArray10[2] - dArray6[2]) - (dArray6[2] - dArray3[2]) * (dArray10[1] - dArray6[1])) * (dArray[0][n2] - dArray6[0]) + ((dArray6[2] - dArray3[2]) * (dArray10[0] - dArray6[0]) - (dArray6[0] - dArray3[0]) * (dArray10[2] - dArray6[2])) * (dArray[1][n2] - dArray6[1]) + ((dArray6[0] - dArray3[0]) * (dArray10[1] - dArray6[1]) - (dArray6[1] - dArray3[1]) * (dArray10[0] - dArray6[0])) * (dArray[2][n2] - dArray6[2]);
                    d17 = ((dArray6[1] - dArray5[1]) * (dArray3[2] - dArray6[2]) - (dArray6[2] - dArray5[2]) * (dArray3[1] - dArray6[1])) * (dArray[0][n2] - dArray6[0]) + ((dArray6[2] - dArray5[2]) * (dArray3[0] - dArray6[0]) - (dArray6[0] - dArray5[0]) * (dArray3[2] - dArray6[2])) * (dArray[1][n2] - dArray6[1]) + ((dArray6[0] - dArray5[0]) * (dArray3[1] - dArray6[1]) - (dArray6[1] - dArray5[1]) * (dArray3[0] - dArray6[0])) * (dArray[2][n2] - dArray6[2]);
                    d16 = ((dArray6[1] - dArray10[1]) * (dArray5[2] - dArray6[2]) - (dArray6[2] - dArray10[2]) * (dArray5[1] - dArray6[1])) * (dArray[0][n2] - dArray6[0]) + ((dArray6[2] - dArray10[2]) * (dArray5[0] - dArray6[0]) - (dArray6[0] - dArray10[0]) * (dArray5[2] - dArray6[2])) * (dArray[1][n2] - dArray6[1]) + ((dArray6[0] - dArray10[0]) * (dArray5[1] - dArray6[1]) - (dArray6[1] - dArray10[1]) * (dArray5[0] - dArray6[0])) * (dArray[2][n2] - dArray6[2]);
                    boolean bl11 = d18 != 0.0 && !(d18 > 0.0 == !bl5 ^ this.Pos) ? false : (bl4 = true);
                    boolean bl12 = d17 != 0.0 && !(d17 > 0.0 == !bl5 ^ this.Pos) ? false : (bl3 = true);
                    boolean bl13 = d16 != 0.0 && !(d16 > 0.0 == !bl5 ^ this.Pos) ? false : (bl2 = true);
                    if (!bl4 && bl5) {
                        --this.gx;
                    }
                    if (!bl4 && !bl5) {
                        ++this.gx;
                    }
                    if (!bl3 && bl5) {
                        ++this.gz;
                    }
                    if (!bl3 && !bl5) {
                        --this.gz;
                    }
                    if (!bl2 && bl5) {
                        ++this.gy;
                    }
                    if (!bl2 && !bl5) {
                        --this.gy;
                    }
                    n3 = 5;
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gz < 0) {
                        this.gz = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gz > this.LengthZ - 2) {
                        this.gz = this.LengthZ - 2;
                    }
                    if (!(this.gx != n16 || this.gy != n17 || this.gz != n18 || bl4 && bl3 && bl2 || bl)) {
                        bl = true;
                    } else if (this.gx == n16 && this.gy == n17 && this.gz == n18 || bl) {
                        double d22;
                        double d23;
                        double[] dArray23 = new double[3];
                        double[] dArray24 = new double[3];
                        double[] dArray25 = new double[3];
                        double[] dArray26 = new double[3];
                        double[] dArray27 = new double[3];
                        double[] dArray28 = new double[3];
                        int n22 = 0;
                        while (n22 < 3) {
                            dArray23[n22] = (dArray5[n22] - dArray6[n22]) * (dArray10[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]) - (dArray5[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]) * (dArray10[n22] - dArray6[n22]);
                            dArray24[n22] = (dArray3[n22] - dArray6[n22]) * (dArray10[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]) - (dArray3[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]) * (dArray10[n22] - dArray6[n22]);
                            dArray25[n22] = (dArray5[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]) * (dArray10[(n22 + 2) % 3] - dArray6[(n22 + 2) % 3]) - (dArray5[(n22 + 2) % 3] - dArray6[(n22 + 2) % 3]) * (dArray10[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]);
                            dArray26[n22] = (dArray3[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]) * (dArray10[(n22 + 2) % 3] - dArray6[(n22 + 2) % 3]) - (dArray3[(n22 + 2) % 3] - dArray6[(n22 + 2) % 3]) * (dArray10[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]);
                            dArray27[n22] = dArray[(n22 + 2) % 3][n2] * (dArray10[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]) - dArray[(n22 + 1) % 3][n2] * (dArray10[(n22 + 2) % 3] - dArray6[(n22 + 2) % 3]) + dArray6[(n22 + 1) % 3] * dArray10[(n22 + 2) % 3] - dArray6[(n22 + 2) % 3] * dArray10[(n22 + 1) % 3];
                            dArray28[n22] = dArray[n22][n2] * (dArray10[(n22 + 1) % 3] - dArray6[(n22 + 1) % 3]) - dArray[(n22 + 1) % 3][n2] * (dArray10[n22] - dArray6[n22]) + dArray6[(n22 + 1) % 3] * dArray10[n22] - dArray6[n22] * dArray10[(n22 + 1) % 3];
                            ++n22;
                        }
                        d7 = dArray23[0] * dArray26[0] - dArray24[0] * dArray25[0];
                        d6 = dArray23[1] * dArray26[1] - dArray24[1] * dArray25[1];
                        d5 = dArray23[2] * dArray26[2] - dArray24[2] * dArray25[2];
                        d4 = Math.abs(d7);
                        d3 = Math.abs(d6);
                        d2 = Math.abs(d5);
                        if (d4 > d3 && d4 > d2) {
                            d23 = (dArray24[0] * dArray27[0] + dArray26[0] * dArray28[0]) / d7;
                            d22 = 1.0 + (dArray23[0] * dArray27[0] + dArray25[0] * dArray28[0]) / d7;
                        } else if (d3 > d2) {
                            d23 = (dArray24[1] * dArray27[1] + dArray26[1] * dArray28[1]) / d6;
                            d22 = 1.0 + (dArray23[1] * dArray27[1] + dArray25[1] * dArray28[1]) / d6;
                        } else {
                            d23 = (dArray24[2] * dArray27[2] + dArray26[2] * dArray28[2]) / d5;
                            d22 = 1.0 + (dArray23[2] * dArray27[2] + dArray25[2] * dArray28[2]) / d5;
                        }
                        d7 = dArray10[0] - dArray6[0];
                        d6 = dArray10[1] - dArray6[1];
                        d5 = dArray10[2] - dArray6[2];
                        d4 = Math.abs(d7);
                        d3 = Math.abs(d6);
                        d2 = Math.abs(d5);
                        d = d4 > d3 && d4 > d2 ? 1.0 - (dArray[0][n2] - dArray6[0] - d23 * (dArray5[0] - dArray6[0]) - (1.0 - d22) * (dArray3[0] - dArray6[0])) / d7 : (d3 > d2 ? 1.0 - (dArray[1][n2] - dArray6[1] - d23 * (dArray5[1] - dArray6[1]) - (1.0 - d22) * (dArray3[1] - dArray6[1])) / d6 : 1.0 - (dArray[2][n2] - dArray6[2] - d23 * (dArray5[2] - dArray6[2]) - (1.0 - d22) * (dArray3[2] - dArray6[2])) / d5);
                        if (bl5) {
                            dArray2[0][n2] = (double)this.gx + d23;
                            dArray2[1][n2] = (double)this.gy + d22;
                            dArray2[2][n2] = (double)this.gz + d;
                            break;
                        }
                        dArray2[0][n2] = (double)(this.gx + 1) - d23;
                        dArray2[1][n2] = (double)(this.gy + 1) - d22;
                        dArray2[2][n2] = (double)(this.gz + 1) - d;
                        break;
                    }
                } else if (n3 == 4) {
                    d18 = ((dArray9[1] - dArray5[1]) * (dArray10[2] - dArray9[2]) - (dArray9[2] - dArray5[2]) * (dArray10[1] - dArray9[1])) * (dArray[0][n2] - dArray9[0]) + ((dArray9[2] - dArray5[2]) * (dArray10[0] - dArray9[0]) - (dArray9[0] - dArray5[0]) * (dArray10[2] - dArray9[2])) * (dArray[1][n2] - dArray9[1]) + ((dArray9[0] - dArray5[0]) * (dArray10[1] - dArray9[1]) - (dArray9[1] - dArray5[1]) * (dArray10[0] - dArray9[0])) * (dArray[2][n2] - dArray9[2]);
                    d17 = ((dArray9[1] - dArray8[1]) * (dArray5[2] - dArray9[2]) - (dArray9[2] - dArray8[2]) * (dArray5[1] - dArray9[1])) * (dArray[0][n2] - dArray9[0]) + ((dArray9[2] - dArray8[2]) * (dArray5[0] - dArray9[0]) - (dArray9[0] - dArray8[0]) * (dArray5[2] - dArray9[2])) * (dArray[1][n2] - dArray9[1]) + ((dArray9[0] - dArray8[0]) * (dArray5[1] - dArray9[1]) - (dArray9[1] - dArray8[1]) * (dArray5[0] - dArray9[0])) * (dArray[2][n2] - dArray9[2]);
                    d16 = ((dArray9[1] - dArray10[1]) * (dArray8[2] - dArray9[2]) - (dArray9[2] - dArray10[2]) * (dArray8[1] - dArray9[1])) * (dArray[0][n2] - dArray9[0]) + ((dArray9[2] - dArray10[2]) * (dArray8[0] - dArray9[0]) - (dArray9[0] - dArray10[0]) * (dArray8[2] - dArray9[2])) * (dArray[1][n2] - dArray9[1]) + ((dArray9[0] - dArray10[0]) * (dArray8[1] - dArray9[1]) - (dArray9[1] - dArray10[1]) * (dArray8[0] - dArray9[0])) * (dArray[2][n2] - dArray9[2]);
                    boolean bl14 = d18 != 0.0 && !(d18 > 0.0 == !bl5 ^ this.Pos) ? false : (bl4 = true);
                    boolean bl15 = d17 != 0.0 && !(d17 > 0.0 == !bl5 ^ this.Pos) ? false : (bl3 = true);
                    boolean bl16 = d16 != 0.0 && !(d16 > 0.0 == !bl5 ^ this.Pos) ? false : (bl2 = true);
                    if (!bl4 && bl5) {
                        ++this.gy;
                    }
                    if (!bl4 && !bl5) {
                        --this.gy;
                    }
                    if (!bl3 && bl5) {
                        ++this.gx;
                    }
                    if (!bl3 && !bl5) {
                        --this.gx;
                    }
                    if (!bl2 && bl5) {
                        --this.gz;
                    }
                    if (!bl2 && !bl5) {
                        ++this.gz;
                    }
                    n3 = 5;
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gz < 0) {
                        this.gz = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gz > this.LengthZ - 2) {
                        this.gz = this.LengthZ - 2;
                    }
                    if (!(this.gx != n16 || this.gy != n17 || this.gz != n18 || bl4 && bl3 && bl2 || bl)) {
                        bl = true;
                    } else if (this.gx == n16 && this.gy == n17 && this.gz == n18 || bl) {
                        double d24;
                        double d25;
                        double[] dArray29 = new double[3];
                        double[] dArray30 = new double[3];
                        double[] dArray31 = new double[3];
                        double[] dArray32 = new double[3];
                        double[] dArray33 = new double[3];
                        double[] dArray34 = new double[3];
                        int n23 = 0;
                        while (n23 < 3) {
                            dArray29[n23] = (dArray10[n23] - dArray9[n23]) * (dArray5[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]) - (dArray10[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]) * (dArray5[n23] - dArray9[n23]);
                            dArray30[n23] = (dArray8[n23] - dArray9[n23]) * (dArray5[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]) - (dArray8[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]) * (dArray5[n23] - dArray9[n23]);
                            dArray31[n23] = (dArray10[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]) * (dArray5[(n23 + 2) % 3] - dArray9[(n23 + 2) % 3]) - (dArray10[(n23 + 2) % 3] - dArray9[(n23 + 2) % 3]) * (dArray5[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]);
                            dArray32[n23] = (dArray8[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]) * (dArray5[(n23 + 2) % 3] - dArray9[(n23 + 2) % 3]) - (dArray8[(n23 + 2) % 3] - dArray9[(n23 + 2) % 3]) * (dArray5[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]);
                            dArray33[n23] = dArray[(n23 + 2) % 3][n2] * (dArray5[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]) - dArray[(n23 + 1) % 3][n2] * (dArray5[(n23 + 2) % 3] - dArray9[(n23 + 2) % 3]) + dArray9[(n23 + 1) % 3] * dArray5[(n23 + 2) % 3] - dArray9[(n23 + 2) % 3] * dArray5[(n23 + 1) % 3];
                            dArray34[n23] = dArray[n23][n2] * (dArray5[(n23 + 1) % 3] - dArray9[(n23 + 1) % 3]) - dArray[(n23 + 1) % 3][n2] * (dArray5[n23] - dArray9[n23]) + dArray9[(n23 + 1) % 3] * dArray5[n23] - dArray9[n23] * dArray5[(n23 + 1) % 3];
                            ++n23;
                        }
                        d7 = dArray29[0] * dArray32[0] - dArray30[0] * dArray31[0];
                        d6 = dArray29[1] * dArray32[1] - dArray30[1] * dArray31[1];
                        d5 = dArray29[2] * dArray32[2] - dArray30[2] * dArray31[2];
                        d4 = Math.abs(d7);
                        d3 = Math.abs(d6);
                        d2 = Math.abs(d5);
                        if (d4 > d3 && d4 > d2) {
                            d25 = 1.0 - (dArray30[0] * dArray33[0] + dArray32[0] * dArray34[0]) / d7;
                            d24 = 1.0 + (dArray29[0] * dArray33[0] + dArray31[0] * dArray34[0]) / d7;
                        } else if (d3 > d2) {
                            d25 = 1.0 - (dArray30[1] * dArray33[1] + dArray32[1] * dArray34[1]) / d6;
                            d24 = 1.0 + (dArray29[1] * dArray33[1] + dArray31[1] * dArray34[1]) / d6;
                        } else {
                            d25 = 1.0 - (dArray30[2] * dArray33[2] + dArray32[2] * dArray34[2]) / d5;
                            d24 = 1.0 + (dArray29[2] * dArray33[2] + dArray31[2] * dArray34[2]) / d5;
                        }
                        d7 = dArray5[0] - dArray9[0];
                        d6 = dArray5[1] - dArray9[1];
                        d5 = dArray5[2] - dArray9[2];
                        d4 = Math.abs(d7);
                        d3 = Math.abs(d6);
                        d2 = Math.abs(d5);
                        d = d4 > d3 && d4 > d2 ? (dArray[0][n2] - dArray9[0] - (1.0 - d25) * (dArray10[0] - dArray9[0]) - (1.0 - d24) * (dArray8[0] - dArray9[0])) / d7 : (d3 > d2 ? (dArray[1][n2] - dArray9[1] - (1.0 - d25) * (dArray10[1] - dArray9[1]) - (1.0 - d24) * (dArray8[1] - dArray9[1])) / d6 : (dArray[2][n2] - dArray9[2] - (1.0 - d25) * (dArray10[2] - dArray9[2]) - (1.0 - d24) * (dArray8[2] - dArray9[2])) / d5);
                        if (bl5) {
                            dArray2[0][n2] = (double)this.gx + d25;
                            dArray2[1][n2] = (double)this.gy + d24;
                            dArray2[2][n2] = (double)this.gz + d;
                            break;
                        }
                        dArray2[0][n2] = (double)(this.gx + 1) - d25;
                        dArray2[1][n2] = (double)(this.gy + 1) - d24;
                        dArray2[2][n2] = (double)(this.gz + 1) - d;
                        break;
                    }
                } else {
                    boolean bl17;
                    d18 = ((dArray8[1] - dArray10[1]) * (dArray3[2] - dArray8[2]) - (dArray8[2] - dArray10[2]) * (dArray3[1] - dArray8[1])) * (dArray[0][n2] - dArray8[0]) + ((dArray8[2] - dArray10[2]) * (dArray3[0] - dArray8[0]) - (dArray8[0] - dArray10[0]) * (dArray3[2] - dArray8[2])) * (dArray[1][n2] - dArray8[1]) + ((dArray8[0] - dArray10[0]) * (dArray3[1] - dArray8[1]) - (dArray8[1] - dArray10[1]) * (dArray3[0] - dArray8[0])) * (dArray[2][n2] - dArray8[2]);
                    d17 = ((dArray5[1] - dArray8[1]) * (dArray3[2] - dArray5[2]) - (dArray5[2] - dArray8[2]) * (dArray3[1] - dArray5[1])) * (dArray[0][n2] - dArray5[0]) + ((dArray5[2] - dArray8[2]) * (dArray3[0] - dArray5[0]) - (dArray5[0] - dArray8[0]) * (dArray3[2] - dArray5[2])) * (dArray[1][n2] - dArray5[1]) + ((dArray5[0] - dArray8[0]) * (dArray3[1] - dArray5[1]) - (dArray5[1] - dArray8[1]) * (dArray3[0] - dArray5[0])) * (dArray[2][n2] - dArray5[2]);
                    d16 = ((dArray5[1] - dArray3[1]) * (dArray10[2] - dArray5[2]) - (dArray5[2] - dArray3[2]) * (dArray10[1] - dArray5[1])) * (dArray[0][n2] - dArray5[0]) + ((dArray5[2] - dArray3[2]) * (dArray10[0] - dArray5[0]) - (dArray5[0] - dArray3[0]) * (dArray10[2] - dArray5[2])) * (dArray[1][n2] - dArray5[1]) + ((dArray5[0] - dArray3[0]) * (dArray10[1] - dArray5[1]) - (dArray5[1] - dArray3[1]) * (dArray10[0] - dArray5[0])) * (dArray[2][n2] - dArray5[2]);
                    double d26 = ((dArray8[1] - dArray5[1]) * (dArray10[2] - dArray8[2]) - (dArray8[2] - dArray5[2]) * (dArray10[1] - dArray8[1])) * (dArray[0][n2] - dArray8[0]) + ((dArray8[2] - dArray5[2]) * (dArray10[0] - dArray8[0]) - (dArray8[0] - dArray5[0]) * (dArray10[2] - dArray8[2])) * (dArray[1][n2] - dArray8[1]) + ((dArray8[0] - dArray5[0]) * (dArray10[1] - dArray8[1]) - (dArray8[1] - dArray5[1]) * (dArray10[0] - dArray8[0])) * (dArray[2][n2] - dArray8[2]);
                    boolean bl18 = d18 != 0.0 && !(d18 > 0.0 == !bl5 ^ this.Pos) ? false : (bl4 = true);
                    boolean bl19 = d17 != 0.0 && !(d17 > 0.0 == !bl5 ^ this.Pos) ? false : (bl3 = true);
                    boolean bl20 = d16 != 0.0 && !(d16 > 0.0 == !bl5 ^ this.Pos) ? false : (bl2 = true);
                    boolean bl21 = d26 != 0.0 && !(d26 > 0.0 == !bl5 ^ this.Pos) ? false : (bl17 = true);
                    if (!bl4 && bl3 && bl2 && bl17) {
                        n3 = 1;
                    }
                    if (bl4 && !bl3 && bl2 && bl17) {
                        n3 = 2;
                    }
                    if (bl4 && bl3 && !bl2 && bl17) {
                        n3 = 3;
                    }
                    if (bl4 && bl3 && bl2 && !bl17) {
                        n3 = 4;
                    }
                    if (!bl4 && !bl3 && bl5 || !bl2 && !bl17 && !bl5) {
                        --this.gy;
                    }
                    if (!bl4 && !bl2 && bl5 || !bl3 && !bl17 && !bl5) {
                        --this.gx;
                    }
                    if (!bl4 && !bl17 && bl5 || !bl3 && !bl2 && !bl5) {
                        --this.gz;
                    }
                    if (!bl3 && !bl2 && bl5 || !bl4 && !bl17 && !bl5) {
                        ++this.gz;
                    }
                    if (!bl3 && !bl17 && bl5 || !bl4 && !bl2 && !bl5) {
                        ++this.gx;
                    }
                    if (!bl2 && !bl17 && bl5 || !bl4 && !bl3 && !bl5) {
                        ++this.gy;
                    }
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gz < 0) {
                        this.gz = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gz > this.LengthZ - 2) {
                        this.gz = this.LengthZ - 2;
                    }
                    if (!((this.gx != n16 || this.gy != n17 || this.gz != n18 || bl4 && bl3 && bl2 && bl17 || n3 != 5) && !bl)) {
                        bl = true;
                        int n24 = 0;
                        int n25 = 0;
                        int n26 = 0;
                        int n27 = 0;
                        int n28 = 0;
                        int n29 = 0;
                        int n30 = 0;
                        int n31 = 0;
                        n5 = 0;
                        if (this.gx == 0) {
                            n5 = 1;
                        }
                        if (this.gy == 0) {
                            n31 = 1;
                        }
                        if (this.gz == 0) {
                            n30 = 1;
                        }
                        if (this.gx == this.LengthX - 2) {
                            n26 = 1;
                        }
                        if (this.gy == this.LengthY - 2) {
                            n25 = 1;
                        }
                        if (this.gz == this.LengthZ - 2) {
                            n24 = 1;
                        }
                        if (n5 == 0 && n26 == 0) {
                            n29 = 1;
                        }
                        if (n31 == 0 && n25 == 0) {
                            n28 = 1;
                        }
                        if (n30 == 0 && n24 == 0) {
                            n27 = 1;
                        }
                        bl17 = false;
                        bl2 = false;
                        bl3 = false;
                        bl4 = false;
                        if (bl5) {
                            if (n26 == 0 && n25 == 0 && n24 == 0) {
                                n3 = 1;
                            } else if (n26 != 0 && n31 != 0 && n27 != 0 || n29 != 0 && n31 != 0 && n24 != 0 || n26 != 0 && n28 != 0 && n24 != 0 || n26 != 0 && n31 != 0 && n24 != 0 || n29 != 0 && n28 != 0 && n24 != 0 || n26 != 0 && n28 != 0 && n27 != 0) {
                                n3 = 2;
                            } else if (n5 != 0 && n25 != 0 && n27 != 0 || n5 != 0 && n28 != 0 && n24 != 0 || n29 != 0 && n25 != 0 && n24 != 0 || n5 != 0 && n25 != 0 && n24 != 0 || n29 != 0 && n25 != 0 && n27 != 0) {
                                n3 = 3;
                            } else if (n29 != 0 && n25 != 0 && n30 != 0 || n26 != 0 && n28 != 0 && n30 != 0 || n26 != 0 && n25 != 0 && n27 != 0 || n26 != 0 && n25 != 0 && n30 != 0) {
                                n3 = 4;
                            }
                        } else if (n5 == 0 && n31 == 0 && n30 == 0) {
                            n3 = 1;
                        } else if (n5 != 0 && n28 != 0 && n30 != 0 || n29 != 0 && n25 != 0 && n30 != 0 || n5 != 0 && n25 != 0 && n27 != 0 || n5 != 0 && n25 != 0 && n30 != 0 || n29 != 0 && n28 != 0 && n30 != 0 || n5 != 0 && n28 != 0 && n27 != 0) {
                            n3 = 2;
                        } else if (n26 != 0 && n28 != 0 && n30 != 0 || n29 != 0 && n31 != 0 && n30 != 0 || n26 != 0 && n31 != 0 && n27 != 0 || n26 != 0 && n31 != 0 && n30 != 0 || n29 != 0 && n31 != 0 && n27 != 0) {
                            n3 = 3;
                        } else if (n5 != 0 && n31 != 0 && n27 != 0 || n5 != 0 && n28 != 0 && n30 != 0 || n29 != 0 && n31 != 0 && n24 != 0 || n5 != 0 && n31 != 0 && n24 != 0) {
                            n3 = 4;
                        }
                    }
                    if (this.gx == n16 && this.gy == n17 && this.gz == n18 && n3 == 5) {
                        double d27;
                        double[] dArray35 = new double[3];
                        int n32 = 0;
                        while (n32 < 3) {
                            dArray35[n32] = (dArray10[n32] + dArray8[n32] + dArray3[n32] - dArray5[n32]) / 2.0;
                            ++n32;
                        }
                        double[] dArray36 = new double[3];
                        double[] dArray37 = new double[3];
                        double[] dArray38 = new double[3];
                        double[] dArray39 = new double[3];
                        double[] dArray40 = new double[3];
                        double[] dArray41 = new double[3];
                        int n33 = 0;
                        while (n33 < 3) {
                            dArray36[n33] = (dArray8[n33] - dArray35[n33]) * (dArray3[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]) - (dArray8[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]) * (dArray3[n33] - dArray35[n33]);
                            dArray37[n33] = (dArray10[n33] - dArray35[n33]) * (dArray3[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]) - (dArray10[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]) * (dArray3[n33] - dArray35[n33]);
                            dArray38[n33] = (dArray8[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]) * (dArray3[(n33 + 2) % 3] - dArray35[(n33 + 2) % 3]) - (dArray8[(n33 + 2) % 3] - dArray35[(n33 + 2) % 3]) * (dArray3[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]);
                            dArray39[n33] = (dArray10[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]) * (dArray3[(n33 + 2) % 3] - dArray35[(n33 + 2) % 3]) - (dArray10[(n33 + 2) % 3] - dArray35[(n33 + 2) % 3]) * (dArray3[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]);
                            dArray40[n33] = dArray[(n33 + 2) % 3][n2] * (dArray3[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]) - dArray[(n33 + 1) % 3][n2] * (dArray3[(n33 + 2) % 3] - dArray35[(n33 + 2) % 3]) + dArray35[(n33 + 1) % 3] * dArray3[(n33 + 2) % 3] - dArray35[(n33 + 2) % 3] * dArray3[(n33 + 1) % 3];
                            dArray41[n33] = dArray[n33][n2] * (dArray3[(n33 + 1) % 3] - dArray35[(n33 + 1) % 3]) - dArray[(n33 + 1) % 3][n2] * (dArray3[n33] - dArray35[n33]) + dArray35[(n33 + 1) % 3] * dArray3[n33] - dArray35[n33] * dArray3[(n33 + 1) % 3];
                            ++n33;
                        }
                        d15 = dArray36[0] * dArray39[0] - dArray37[0] * dArray38[0];
                        d14 = dArray36[1] * dArray39[1] - dArray37[1] * dArray38[1];
                        d13 = dArray36[2] * dArray39[2] - dArray37[2] * dArray38[2];
                        d12 = Math.abs(d15);
                        d11 = Math.abs(d14);
                        d10 = Math.abs(d13);
                        if (d12 > d11 && d12 > d10) {
                            d27 = (dArray37[0] * dArray40[0] + dArray39[0] * dArray41[0]) / d15;
                            d9 = -(dArray36[0] * dArray40[0] + dArray38[0] * dArray41[0]) / d15;
                        } else if (d11 > d10) {
                            d27 = (dArray37[1] * dArray40[1] + dArray39[1] * dArray41[1]) / d14;
                            d9 = -(dArray36[1] * dArray40[1] + dArray38[1] * dArray41[1]) / d14;
                        } else {
                            d27 = (dArray37[2] * dArray40[2] + dArray39[2] * dArray41[2]) / d13;
                            d9 = -(dArray36[2] * dArray40[2] + dArray38[2] * dArray41[2]) / d13;
                        }
                        d15 = dArray3[0] - dArray35[0];
                        d14 = dArray3[1] - dArray35[1];
                        d13 = dArray3[2] - dArray35[2];
                        d12 = Math.abs(d15);
                        d11 = Math.abs(d14);
                        d10 = Math.abs(d13);
                        d8 = d12 > d11 && d12 > d10 ? (dArray[0][n2] - dArray35[0] - d27 * (dArray8[0] - dArray35[0]) - d9 * (dArray10[0] - dArray35[0])) / d15 : (d11 > d10 ? (dArray[1][n2] - dArray35[1] - d27 * (dArray8[1] - dArray35[1]) - d9 * (dArray10[1] - dArray35[1])) / d14 : (dArray[2][n2] - dArray35[2] - d27 * (dArray8[2] - dArray35[2]) - d9 * (dArray10[2] - dArray35[2])) / d13);
                        if (bl5) {
                            dArray2[0][n2] = (double)this.gx + d27;
                            dArray2[1][n2] = (double)this.gy + d9;
                            dArray2[2][n2] = (double)this.gz + d8;
                            break;
                        }
                        dArray2[0][n2] = (double)(this.gx + 1) - d27;
                        dArray2[1][n2] = (double)(this.gy + 1) - d9;
                        dArray2[2][n2] = (double)(this.gz + 1) - d8;
                        break;
                    }
                }
                ++n4;
            }
            if (dArray2[0][n2] < -0.5 || dArray2[0][n2] > (double)this.LengthX - 0.5 || dArray2[1][n2] < -0.5 || dArray2[1][n2] > (double)this.LengthY - 0.5 || dArray2[2][n2] < -0.5 || dArray2[2][n2] > (double)this.LengthZ - 0.5) {
                dArray2[2][n2] = Double.NaN;
                dArray2[1][n2] = Double.NaN;
                dArray2[0][n2] = Double.NaN;
            }
            ++n2;
        }
        return dArray2;
    }

    public void doubleToInterp(double[][] dArray, int[][] nArray, double[][] dArray2) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.doubleToInterp: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = dArray[0].length;
        if (nArray.length != n) {
            throw new SetException("Gridded3DDoubleSet.doubleToInterp: indices length " + nArray.length + " doesn't match value[0] length " + dArray[0].length);
        }
        if (dArray2.length != n) {
            throw new SetException("Gridded3DDoubleSet.doubleToInterp: weights length " + dArray2.length + " doesn't match value[0] length " + dArray[0].length);
        }
        double[][] dArray3 = this.doubleToGrid(dArray);
        int[] nArray2 = new int[this.ManifoldDimension];
        double[] dArray4 = new double[this.ManifoldDimension];
        int[] nArray3 = new int[this.ManifoldDimension];
        nArray3[0] = 1;
        int n2 = 1;
        while (n2 < this.ManifoldDimension) {
            nArray3[n2] = nArray3[n2 - 1] * this.Lengths[n2 - 1];
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            double[] dArray5;
            int[] nArray4;
            int n4;
            int n5 = 1;
            if (Double.isNaN(dArray3[this.ManifoldDimension - 1][n3])) {
                n4 = -1;
            } else {
                nArray2[this.ManifoldDimension - 1] = (int)(dArray3[this.ManifoldDimension - 1][n3] + 0.5);
                if (nArray2[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n6 = this.ManifoldDimension - 1;
                    nArray2[n6] = nArray2[n6] - 1;
                }
                dArray4[this.ManifoldDimension - 1] = dArray3[this.ManifoldDimension - 1][n3] - (double)nArray2[this.ManifoldDimension - 1];
                if (!(nArray2[this.ManifoldDimension - 1] == 0 && dArray4[this.ManifoldDimension - 1] <= 0.0 || nArray2[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && dArray4[this.ManifoldDimension - 1] >= 0.0)) {
                    n5 *= 2;
                }
                n4 = nArray2[this.ManifoldDimension - 1];
            }
            n2 = this.ManifoldDimension - 2;
            while (n2 >= 0 && n4 >= 0) {
                if (Double.isNaN(dArray3[n2][n3])) {
                    n4 = -1;
                } else {
                    nArray2[n2] = (int)(dArray3[n2][n3] + 0.5);
                    if (nArray2[n2] == this.Lengths[n2]) {
                        int n7 = n2;
                        nArray2[n7] = nArray2[n7] - 1;
                    }
                    dArray4[n2] = dArray3[n2][n3] - (double)nArray2[n2];
                    if (!(nArray2[n2] == 0 && dArray4[n2] <= 0.0 || nArray2[n2] == this.Lengths[n2] - 1 && dArray4[n2] >= 0.0)) {
                        n5 *= 2;
                    }
                    n4 = nArray2[n2] + this.Lengths[n2] * n4;
                }
                --n2;
            }
            if (n4 < 0) {
                nArray4 = null;
                dArray5 = null;
            } else {
                nArray4 = new int[n5];
                dArray5 = new double[n5];
                nArray4[0] = n4;
                dArray5[0] = 1.0;
                int n8 = 1;
                n2 = 0;
                while (n2 < this.ManifoldDimension) {
                    if (!(nArray2[n2] == 0 && dArray4[n2] <= 0.0 || nArray2[n2] == this.Lengths[n2] - 1 && dArray4[n2] >= 0.0)) {
                        double d;
                        double d2;
                        int n9;
                        if (dArray4[n2] >= 0.0) {
                            n9 = nArray3[n2];
                            d2 = 1.0 - dArray4[n2];
                            d = dArray4[n2];
                        } else {
                            n9 = -nArray3[n2];
                            d2 = 1.0 + dArray4[n2];
                            d = -dArray4[n2];
                        }
                        int n10 = 0;
                        while (n10 < n8) {
                            nArray4[n10 + n8] = nArray4[n10] + n9;
                            dArray5[n10 + n8] = dArray5[n10] * d;
                            int n11 = n10++;
                            dArray5[n11] = dArray5[n11] * d2;
                        }
                        n8 *= 2;
                    }
                    ++n2;
                }
            }
            nArray[n3] = nArray4;
            dArray2[n3] = dArray5;
            ++n3;
        }
    }

    void init_doubles(double[][] dArray, boolean bl) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Gridded3DDoubleSet.init_doubles: samples dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = dArray[0].length;
        } else if (this.Length != dArray[0].length) {
            throw new SetException("Gridded3DDoubleSet.init_doubles: samples[0] length " + dArray[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = bl ? new double[this.DomainDimension][this.Length] : dArray;
        int n = 0;
        while (n < this.DomainDimension) {
            if (dArray[n].length != this.Length) {
                throw new SetException("Gridded3DDoubleSet.init_doubles: samples[" + n + "] length " + dArray[0].length + " doesn't match expected length " + this.Length);
            }
            double[] dArray2 = dArray[n];
            double[] dArray3 = this.Samples[n];
            if (bl) {
                System.arraycopy(dArray2, 0, dArray3, 0, this.Length);
            }
            this.Low[n] = Double.POSITIVE_INFINITY;
            this.Hi[n] = Double.NEGATIVE_INFINITY;
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.Length) {
                if (dArray3[n2] == dArray3[n2] && !Double.isInfinite(dArray3[n2])) {
                    if (dArray3[n2] < this.Low[n]) {
                        this.Low[n] = dArray3[n2];
                    }
                    if (dArray3[n2] > this.Hi[n]) {
                        this.Hi[n] = dArray3[n2];
                    }
                } else {
                    dArray3[n2] = Double.NaN;
                }
                d += dArray3[n2];
                ++n2;
            }
            if (this.SetErrors[n] != null) {
                this.SetErrors[n] = new ErrorEstimate(this.SetErrors[n].getErrorValue(), d / (double)this.Length, this.Length, this.SetErrors[n].getUnit());
            }
            ((SampledSet)this).Low[n] = (float)this.Low[n];
            ((SampledSet)this).Hi[n] = (float)this.Hi[n];
            ++n;
        }
    }

    public void cram_missing(boolean[] blArray) {
        int n = Math.min(blArray.length, this.Samples[0].length);
        int n2 = 0;
        while (n2 < n) {
            if (!blArray[n2]) {
                this.Samples[0][n2] = Double.NaN;
            }
            ++n2;
        }
    }

    public boolean isMissing() {
        return this.Samples == null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Gridded3DDoubleSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.testNotEqualsCache((Set)object)) {
            return false;
        }
        if (this.testEqualsCache((Set)object)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        try {
            if (this.DomainDimension != ((Gridded3DDoubleSet)object).getDimension() || this.ManifoldDimension != ((Gridded3DDoubleSet)object).getManifoldDimension() || this.Length != ((Gridded3DDoubleSet)object).getLength()) {
                return false;
            }
            int n = 0;
            while (n < this.ManifoldDimension) {
                if (this.Lengths[n] != ((Gridded3DDoubleSet)object).getLength(n)) {
                    return false;
                }
                ++n;
            }
            double[][] dArray = ((Gridded3DDoubleSet)object).getDoubles(false);
            if (this.Samples != null && dArray != null) {
                n = 0;
                while (n < this.DomainDimension) {
                    int n2 = 0;
                    while (n2 < this.Length) {
                        if (this.Samples[n][n2] != dArray[n][n2]) {
                            this.addNotEqualsCache((Set)object);
                            return false;
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else {
                double[][] dArray2 = this.getDoubles(false);
                if (dArray2 == null) {
                    if (dArray != null) {
                        return false;
                    }
                } else {
                    if (dArray == null) {
                        return false;
                    }
                    n = 0;
                    while (n < this.DomainDimension) {
                        int n3 = 0;
                        while (n3 < this.Length) {
                            if (dArray2[n][n3] != dArray[n][n3]) {
                                this.addNotEqualsCache((Set)object);
                                return false;
                            }
                            ++n3;
                        }
                        ++n;
                    }
                }
            }
            this.addEqualsCache((Set)object);
            return true;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public Object clone() {
        try {
            return new Gridded3DDoubleSet(this.Type, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("Gridded3DDoubleSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new Gridded3DDoubleSet(mathType, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public Gridded3DDoubleSet(MathType mathType, float[][] fArray, int n, int n2, int n3) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, n2, n3, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType mathType, float[][] fArray, int n, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, n2, n3, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded3DDoubleSet(MathType mathType, float[][] fArray, int n, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, n2, n3, coordinateSystem, unitArray, errorEstimateArray, bl);
    }

    public Gridded3DDoubleSet(MathType mathType, float[][] fArray, int n, int n2) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, n2, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType mathType, float[][] fArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, n2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded3DDoubleSet(MathType mathType, float[][] fArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, n2, coordinateSystem, unitArray, errorEstimateArray, bl);
    }

    public Gridded3DDoubleSet(MathType mathType, float[][] fArray, int n) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded3DDoubleSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, coordinateSystem, unitArray, errorEstimateArray, bl);
    }

    public Gridded3DDoubleSet(MathType mathType, double[][] dArray, int n, int n2, int n3) throws VisADException {
        this(mathType, dArray, n, n2, n3, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType mathType, double[][] dArray, int n, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, dArray, n, n2, n3, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded3DDoubleSet(MathType mathType, double[][] dArray, int n, int n2, int n3, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, null, n, n2, n3, coordinateSystem, unitArray, errorEstimateArray, bl);
        if (dArray == null) {
            throw new SetException("Gridded3DDoubleSet: samples are null");
        }
        this.init_doubles(dArray, bl);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
        this.LengthZ = this.Lengths[2];
        if (this.Samples != null && this.Lengths[0] > 1 && this.Lengths[1] > 1 && this.Lengths[2] > 1) {
            int n4 = 0;
            while (n4 < this.Length) {
                if (this.Samples[0][n4] != this.Samples[0][n4]) {
                    throw new SetException("Gridded3DDoubleSet: samples values may not be missing");
                }
                ++n4;
            }
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[3];
            double[] dArray4 = new double[3];
            double[] dArray5 = new double[3];
            double[] dArray6 = new double[3];
            double[] dArray7 = new double[3];
            double[] dArray8 = new double[3];
            double[] dArray9 = new double[3];
            int n5 = 0;
            while (n5 < 3) {
                dArray2[n5] = this.Samples[n5][0];
                dArray3[n5] = this.Samples[n5][1];
                dArray4[n5] = this.Samples[n5][this.LengthX];
                dArray5[n5] = this.Samples[n5][this.LengthY * this.LengthX];
                dArray6[n5] = this.Samples[n5][this.LengthX + 1];
                dArray7[n5] = this.Samples[n5][this.LengthY * this.LengthX + 1];
                dArray8[n5] = this.Samples[n5][(this.LengthY + 1) * this.LengthX];
                dArray9[n5] = this.Samples[n5][(this.LengthY + 1) * this.LengthX + 1];
                ++n5;
            }
            this.Pos = ((dArray3[1] - dArray2[1]) * (dArray7[2] - dArray3[2]) - (dArray3[2] - dArray2[2]) * (dArray7[1] - dArray3[1])) * (dArray6[0] - dArray3[0]) + ((dArray3[2] - dArray2[2]) * (dArray7[0] - dArray3[0]) - (dArray3[0] - dArray2[0]) * (dArray7[2] - dArray3[2])) * (dArray6[1] - dArray3[1]) + ((dArray3[0] - dArray2[0]) * (dArray7[1] - dArray3[1]) - (dArray3[1] - dArray2[1]) * (dArray7[0] - dArray3[0])) * (dArray6[2] - dArray3[2]) > 0.0;
            n5 = 0;
            while (n5 < this.LengthZ - 1) {
                int n6 = 0;
                while (n6 < this.LengthY - 1) {
                    int n7 = 0;
                    while (n7 < this.LengthX - 1) {
                        double[] dArray10 = new double[3];
                        double[] dArray11 = new double[3];
                        double[] dArray12 = new double[3];
                        double[] dArray13 = new double[3];
                        double[] dArray14 = new double[3];
                        double[] dArray15 = new double[3];
                        double[] dArray16 = new double[3];
                        double[] dArray17 = new double[3];
                        int n8 = 0;
                        while (n8 < 3) {
                            int n9 = this.LengthY * this.LengthX;
                            int n10 = n5 * n9 + n6 * this.LengthX + n7;
                            dArray10[n8] = this.Samples[n8][n10];
                            dArray11[n8] = this.Samples[n8][n10 + 1];
                            dArray12[n8] = this.Samples[n8][n10 + this.LengthX];
                            dArray13[n8] = this.Samples[n8][n10 + n9];
                            dArray14[n8] = this.Samples[n8][n10 + this.LengthX + 1];
                            dArray15[n8] = this.Samples[n8][n10 + n9 + 1];
                            dArray16[n8] = this.Samples[n8][n10 + n9 + this.LengthX];
                            dArray17[n8] = this.Samples[n8][n10 + n9 + this.LengthX + 1];
                            ++n8;
                        }
                        if (((dArray11[1] - dArray10[1]) * (dArray15[2] - dArray11[2]) - (dArray11[2] - dArray10[2]) * (dArray15[1] - dArray11[1])) * (dArray14[0] - dArray11[0]) + ((dArray11[2] - dArray10[2]) * (dArray15[0] - dArray11[0]) - (dArray11[0] - dArray10[0]) * (dArray15[2] - dArray11[2])) * (dArray14[1] - dArray11[1]) + ((dArray11[0] - dArray10[0]) * (dArray15[1] - dArray11[1]) - (dArray11[1] - dArray10[1]) * (dArray15[0] - dArray11[0])) * (dArray14[2] - dArray11[2]) > 0.0 != this.Pos || ((dArray15[1] - dArray11[1]) * (dArray13[2] - dArray15[2]) - (dArray15[2] - dArray11[2]) * (dArray13[1] - dArray15[1])) * (dArray17[0] - dArray15[0]) + ((dArray15[2] - dArray11[2]) * (dArray13[0] - dArray15[0]) - (dArray15[0] - dArray11[0]) * (dArray13[2] - dArray15[2])) * (dArray17[1] - dArray15[1]) + ((dArray15[0] - dArray11[0]) * (dArray13[1] - dArray15[1]) - (dArray15[1] - dArray11[1]) * (dArray13[0] - dArray15[0])) * (dArray17[2] - dArray15[2]) > 0.0 != this.Pos || ((dArray13[1] - dArray15[1]) * (dArray10[2] - dArray13[2]) - (dArray13[2] - dArray15[2]) * (dArray10[1] - dArray13[1])) * (dArray16[0] - dArray13[0]) + ((dArray13[2] - dArray15[2]) * (dArray10[0] - dArray13[0]) - (dArray13[0] - dArray15[0]) * (dArray10[2] - dArray13[2])) * (dArray16[1] - dArray13[1]) + ((dArray13[0] - dArray15[0]) * (dArray10[1] - dArray13[1]) - (dArray13[1] - dArray15[1]) * (dArray10[0] - dArray13[0])) * (dArray16[2] - dArray13[2]) > 0.0 != this.Pos || ((dArray10[1] - dArray13[1]) * (dArray11[2] - dArray10[2]) - (dArray10[2] - dArray13[2]) * (dArray11[1] - dArray10[1])) * (dArray12[0] - dArray10[0]) + ((dArray10[2] - dArray13[2]) * (dArray11[0] - dArray10[0]) - (dArray10[0] - dArray13[0]) * (dArray11[2] - dArray10[2])) * (dArray12[1] - dArray10[1]) + ((dArray10[0] - dArray13[0]) * (dArray11[1] - dArray10[1]) - (dArray10[1] - dArray13[1]) * (dArray11[0] - dArray10[0])) * (dArray12[2] - dArray10[2]) > 0.0 != this.Pos || ((dArray14[1] - dArray17[1]) * (dArray12[2] - dArray14[2]) - (dArray14[2] - dArray17[2]) * (dArray12[1] - dArray14[1])) * (dArray11[0] - dArray14[0]) + ((dArray14[2] - dArray17[2]) * (dArray12[0] - dArray14[0]) - (dArray14[0] - dArray17[0]) * (dArray12[2] - dArray14[2])) * (dArray11[1] - dArray14[1]) + ((dArray14[0] - dArray17[0]) * (dArray12[1] - dArray14[1]) - (dArray14[1] - dArray17[1]) * (dArray12[0] - dArray14[0])) * (dArray11[2] - dArray14[2]) > 0.0 != this.Pos || ((dArray17[1] - dArray16[1]) * (dArray14[2] - dArray17[2]) - (dArray17[2] - dArray16[2]) * (dArray14[1] - dArray17[1])) * (dArray15[0] - dArray17[0]) + ((dArray17[2] - dArray16[2]) * (dArray14[0] - dArray17[0]) - (dArray17[0] - dArray16[0]) * (dArray14[2] - dArray17[2])) * (dArray15[1] - dArray17[1]) + ((dArray17[0] - dArray16[0]) * (dArray14[1] - dArray17[1]) - (dArray17[1] - dArray16[1]) * (dArray14[0] - dArray17[0])) * (dArray15[2] - dArray17[2]) > 0.0 != this.Pos || ((dArray16[1] - dArray12[1]) * (dArray17[2] - dArray16[2]) - (dArray16[2] - dArray12[2]) * (dArray17[1] - dArray16[1])) * (dArray13[0] - dArray16[0]) + ((dArray16[2] - dArray12[2]) * (dArray17[0] - dArray16[0]) - (dArray16[0] - dArray12[0]) * (dArray17[2] - dArray16[2])) * (dArray13[1] - dArray16[1]) + ((dArray16[0] - dArray12[0]) * (dArray17[1] - dArray16[1]) - (dArray16[1] - dArray12[1]) * (dArray17[0] - dArray16[0])) * (dArray13[2] - dArray16[2]) > 0.0 != this.Pos || ((dArray12[1] - dArray14[1]) * (dArray16[2] - dArray12[2]) - (dArray12[2] - dArray14[2]) * (dArray16[1] - dArray12[1])) * (dArray10[0] - dArray12[0]) + ((dArray12[2] - dArray14[2]) * (dArray16[0] - dArray12[0]) - (dArray12[0] - dArray14[0]) * (dArray16[2] - dArray12[2])) * (dArray10[1] - dArray12[1]) + ((dArray12[0] - dArray14[0]) * (dArray16[1] - dArray12[1]) - (dArray12[1] - dArray14[1]) * (dArray16[0] - dArray12[0])) * (dArray10[2] - dArray12[2]) > 0.0 != this.Pos) {
                            throw new SetException("Gridded3DDoubleSet: samples do not form a valid grid (" + n7 + "," + n6 + "," + n5 + ")");
                        }
                        ++n7;
                    }
                    ++n6;
                }
                ++n5;
            }
        }
    }

    public Gridded3DDoubleSet(MathType mathType, double[][] dArray, int n, int n2) throws VisADException {
        this(mathType, dArray, n, n2, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType mathType, double[][] dArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, dArray, n, n2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded3DDoubleSet(MathType mathType, double[][] dArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, null, n, n2, coordinateSystem, unitArray, errorEstimateArray, bl);
        if (dArray == null) {
            throw new SetException("Gridded3DDoubleSet: samples are null");
        }
        this.init_doubles(dArray, bl);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
    }

    public Gridded3DDoubleSet(MathType mathType, double[][] dArray, int n) throws VisADException {
        this(mathType, dArray, n, null, null, null, true);
    }

    public Gridded3DDoubleSet(MathType mathType, double[][] dArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, dArray, n, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded3DDoubleSet(MathType mathType, double[][] dArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, null, n, coordinateSystem, unitArray, errorEstimateArray, bl);
        if (dArray == null) {
            throw new SetException("Gridded3DDoubleSet: samples are null");
        }
        this.init_doubles(dArray, bl);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LowZ = this.Low[2];
        this.HiZ = this.Hi[2];
    }
}

