/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.InputStreamReader;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Gridded2DSet
extends GriddedSet {
    int LengthX;
    int LengthY;
    float LowX;
    float HiX;
    float LowY;
    float HiY;
    private int gx = -1;
    private int gy = -1;

    static int[] make_lengths(int n, int n2) {
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int n = nArray.length;
        if (this.Samples == null) {
            float[][] fArray = new float[this.ManifoldDimension][n];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                if (nArray[n2] >= 0 && nArray[n2] < this.Length) {
                    n4 = nArray[n2] % this.LengthX;
                    n3 = nArray[n2] / this.LengthX;
                } else {
                    n4 = -1;
                    n3 = -1;
                }
                fArray[0][n2] = n4;
                fArray[1][n2] = n3;
                ++n2;
            }
            return this.gridToValue(fArray);
        }
        float[][] fArray = new float[2][n];
        int n5 = 0;
        while (n5 < n) {
            if (nArray[n5] >= 0 && nArray[n5] < this.Length) {
                fArray[0][n5] = this.Samples[0][nArray[n5]];
                fArray[1][n5] = this.Samples[1][nArray[n5]];
            } else {
                fArray[0][n5] = Float.NaN;
                fArray[1][n5] = Float.NaN;
            }
            ++n5;
        }
        return fArray;
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        if (fArray.length != this.DomainDimension) {
            throw new SetException("Gridded2DSet.valueToIndex: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = fArray[0].length;
        int[] nArray = new int[n];
        float[][] fArray2 = this.valueToGrid(fArray);
        float[] fArray3 = fArray2[0];
        float[] fArray4 = fArray2[1];
        int n2 = 0;
        while (n2 < n) {
            float f = fArray3[n2];
            float f2 = fArray4[n2];
            nArray[n2] = f != f || f2 != f2 ? -1 : (int)((double)f + 0.5) + this.LengthX * (int)((double)f2 + 0.5);
            ++n2;
        }
        return nArray;
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        if (fArray.length != this.ManifoldDimension) {
            throw new SetException("Gridded2DSet.gridToValue: grid dimension " + fArray.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DSet.gridToValue: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Gridded2DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n = Math.min(fArray[0].length, fArray[1].length);
        float[][] fArray2 = new float[2][n];
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[0][n2];
            float f2 = fArray[1][n2];
            if ((double)f < -0.5 || (double)f2 < -0.5 || (double)f > (double)this.LengthX - 0.5 || (double)f2 > (double)this.LengthY - 0.5) {
                fArray2[1][n2] = Float.NaN;
                fArray2[0][n2] = Float.NaN;
            } else {
                int n3;
                int n4 = (int)f;
                int n5 = (int)f2;
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 > this.LengthX - 2) {
                    n4 = this.LengthX - 2;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > this.LengthY - 2) {
                    n5 = this.LengthY - 2;
                }
                int[][] nArray = new int[][]{{this.LengthX * n5 + n4, this.LengthX * (n5 + 1) + n4}, {this.LengthX * n5 + n4 + 1, this.LengthX * (n5 + 1) + n4 + 1}};
                if (f + f2 - (float)n4 - (float)n5 - 1.0f <= 0.0f) {
                    n3 = 0;
                    while (n3 < 2) {
                        fArray2[n3][n2] = this.Samples[n3][nArray[0][0]] + (f - (float)n4) * (this.Samples[n3][nArray[1][0]] - this.Samples[n3][nArray[0][0]]) + (f2 - (float)n5) * (this.Samples[n3][nArray[0][1]] - this.Samples[n3][nArray[0][0]]);
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < 2) {
                        fArray2[n3][n2] = this.Samples[n3][nArray[1][1]] + ((float)(1 + n4) - f) * (this.Samples[n3][nArray[0][1]] - this.Samples[n3][nArray[1][1]]) + ((float)(1 + n5) - f2) * (this.Samples[n3][nArray[1][0]] - this.Samples[n3][nArray[1][1]]);
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return fArray2;
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        if (fArray.length < this.DomainDimension) {
            throw new SetException("Gridded2DSet.valueToGrid: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DSet.valueToGrid: Manifold dimension must be 2, not " + this.ManifoldDimension);
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Gridded2DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int n = Math.min(fArray[0].length, fArray[1].length);
        float[][] fArray2 = new float[this.ManifoldDimension][n];
        if (this.gx < 0 || this.gx >= this.LengthX || this.gy < 0 || this.gy >= this.LengthY) {
            this.gx = (this.LengthX - 1) / 2;
            this.gy = (this.LengthY - 1) / 2;
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (n2 != 0 && fArray2[0][n2 - 1] != fArray2[0][n2 - 1]) {
                this.gx = (this.LengthX - 1) / 2;
                this.gy = (this.LengthY - 1) / 2;
            }
            fArray2[1][n2] = Float.NaN;
            fArray2[0][n2] = Float.NaN;
            int n3 = 0;
            while (n3 < 2 * (this.LengthX + this.LengthY)) {
                int n4;
                int n5;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                float f;
                float f2;
                float f3;
                float[] fArray3;
                float[] fArray4;
                float[] fArray5;
                float[] fArray6 = new float[]{this.Samples[0][this.gy * this.LengthX + this.gx], this.Samples[1][this.gy * this.LengthX + this.gx]};
                float[] fArray7 = new float[]{this.Samples[0][this.gy * this.LengthX + this.gx + 1], this.Samples[1][this.gy * this.LengthX + this.gx + 1]};
                float[] fArray8 = new float[]{this.Samples[0][(this.gy + 1) * this.LengthX + this.gx], this.Samples[1][(this.gy + 1) * this.LengthX + this.gx]};
                float[] fArray9 = new float[]{this.Samples[0][(this.gy + 1) * this.LengthX + this.gx + 1], this.Samples[1][(this.gy + 1) * this.LengthX + this.gx + 1]};
                float[] fArray10 = new float[]{fArray8[0] - fArray7[0], fArray8[1] - fArray7[1]};
                float[] fArray11 = new float[]{fArray[0][n2] - fArray7[0], fArray[1][n2] - fArray7[1]};
                float[] fArray12 = new float[]{fArray[0][n2] - fArray8[0], fArray[1][n2] - fArray8[1]};
                if (bl) {
                    fArray5 = new float[]{fArray7[0] - fArray6[0], fArray7[1] - fArray6[1]};
                    fArray4 = new float[]{fArray6[0] - fArray8[0], fArray6[1] - fArray8[1]};
                    fArray3 = new float[]{fArray[0][n2] - fArray6[0], fArray[1][n2] - fArray6[1]};
                    f3 = fArray5[0] * fArray3[1] - fArray5[1] * fArray3[0];
                    f2 = fArray10[0] * fArray11[1] - fArray10[1] * fArray11[0];
                    f = fArray4[0] * fArray12[1] - fArray4[1] * fArray12[0];
                    boolean bl5 = f3 != 0.0f && f3 > 0.0f != this.Pos ? false : (bl4 = true);
                    boolean bl6 = f2 != 0.0f && f2 > 0.0f != this.Pos ? false : (bl3 = true);
                    bl2 = f == 0.0f || f > 0.0f == this.Pos;
                    n5 = this.gx++;
                    n4 = this.gy--;
                    if (bl4 || bl3) {
                        if (!bl3 && !bl2) {
                            --this.gx;
                            ++this.gy;
                        } else if (!bl4 && !bl2) {
                            --this.gx;
                            --this.gy;
                        } else if (!bl4) {
                            --this.gy;
                        } else if (!bl2) {
                            --this.gx;
                        }
                    }
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gx == n5 && this.gy == n4 && bl3) {
                        fArray2[0][n2] = ((fArray[0][n2] - fArray6[0]) * (fArray8[1] - fArray6[1]) + (fArray6[1] - fArray[1][n2]) * (fArray8[0] - fArray6[0])) / ((fArray7[0] - fArray6[0]) * (fArray8[1] - fArray6[1]) + (fArray6[1] - fArray7[1]) * (fArray8[0] - fArray6[0])) + (float)this.gx;
                        fArray2[1][n2] = ((fArray[0][n2] - fArray6[0]) * (fArray7[1] - fArray6[1]) + (fArray6[1] - fArray[1][n2]) * (fArray7[0] - fArray6[0])) / ((fArray8[0] - fArray6[0]) * (fArray7[1] - fArray6[1]) + (fArray6[1] - fArray8[1]) * (fArray7[0] - fArray6[0])) + (float)this.gy;
                        break;
                    }
                    bl = false;
                } else {
                    fArray5 = new float[]{fArray9[0] - fArray7[0], fArray9[1] - fArray7[1]};
                    fArray4 = new float[]{fArray8[0] - fArray9[0], fArray8[1] - fArray9[1]};
                    fArray3 = new float[]{fArray[0][n2] - fArray9[0], fArray[1][n2] - fArray9[1]};
                    f3 = fArray5[0] * fArray11[1] - fArray5[1] * fArray11[0];
                    f2 = fArray4[0] * fArray3[1] - fArray4[1] * fArray3[0];
                    f = fArray10[0] * fArray12[1] - fArray10[1] * fArray12[0];
                    boolean bl7 = f3 != 0.0f && f3 > 0.0f != this.Pos ? false : (bl4 = true);
                    boolean bl8 = f2 != 0.0f && f2 > 0.0f != this.Pos ? false : (bl3 = true);
                    bl2 = f == 0.0f || f < 0.0f == this.Pos;
                    n5 = this.gx++;
                    n4 = this.gy--;
                    if (bl4 || bl2) {
                        if (!bl3 && !bl2) {
                            --this.gx;
                            ++this.gy;
                        } else if (!bl4 && !bl3) {
                            ++this.gx;
                            ++this.gy;
                        } else if (!bl4) {
                            ++this.gx;
                        } else if (!bl3) {
                            ++this.gy;
                        }
                    }
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gx == n5 && this.gy == n4 && bl2) {
                        fArray2[0][n2] = ((fArray9[0] - fArray[0][n2]) * (fArray7[1] - fArray9[1]) + (fArray[1][n2] - fArray9[1]) * (fArray7[0] - fArray9[0])) / ((fArray8[0] - fArray9[0]) * (fArray7[1] - fArray9[1]) - (fArray8[1] - fArray9[1]) * (fArray7[0] - fArray9[0])) + (float)this.gx + 1.0f;
                        fArray2[1][n2] = ((fArray8[1] - fArray9[1]) * (fArray9[0] - fArray[0][n2]) + (fArray8[0] - fArray9[0]) * (fArray[1][n2] - fArray9[1])) / ((fArray7[0] - fArray9[0]) * (fArray8[1] - fArray9[1]) - (fArray8[0] - fArray9[0]) * (fArray7[1] - fArray9[1])) + (float)this.gy + 1.0f;
                        break;
                    }
                    bl = true;
                }
                if ((double)fArray2[0][n2] > (double)this.LengthX - 0.5 || (double)fArray2[1][n2] > (double)this.LengthY - 0.5 || (double)fArray2[0][n2] < -0.5 || (double)fArray2[1][n2] < -0.5) {
                    fArray2[1][n2] = Float.NaN;
                    fArray2[0][n2] = Float.NaN;
                }
                ++n3;
            }
            ++n2;
        }
        return fArray2;
    }

    public Object clone() {
        try {
            if (this.ManifoldDimension == 2) {
                return new Gridded2DSet(this.Type, this.Samples, this.LengthX, this.LengthY, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
            }
            return new Gridded2DSet(this.Type, this.Samples, this.LengthX, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("Gridded2DSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        if (this.ManifoldDimension == 2) {
            return new Gridded2DSet(mathType, this.Samples, this.LengthX, this.LengthY, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        return new Gridded2DSet(mathType, this.Samples, this.LengthX, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public static void main(String[] stringArray) throws VisADException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        int[] nArray = new int[80];
        try {
            nArray[0] = inputStreamReader.read();
        }
        catch (Exception exception) {
            System.out.println("Gridded2DSet: " + exception);
        }
        int n2 = 0;
        while (nArray[n2] != 10) {
            try {
                nArray[++n2] = inputStreamReader.read();
            }
            catch (Exception exception) {
                System.out.println("Gridded2DSet: " + exception);
            }
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = (char)nArray[n3];
            ++n3;
        }
        n3 = Integer.parseInt(new String(cArray));
        if (n3 % 4 != 0) {
            System.out.println("Gridded2DSet: input coordinates must be divisible by 4 for main function testing routines.");
        }
        float[][] fArray = new float[2][n3];
        System.out.println("num_dimensions = 2, num_coords = " + n3 + "\n");
        try {
            nArray[0] = inputStreamReader.read();
        }
        catch (Exception exception) {
            System.out.println("Gridded2DSet: " + exception);
        }
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < 2) {
                n2 = 0;
                try {
                    nArray[0] = inputStreamReader.read();
                }
                catch (Exception exception) {
                    System.out.println("Gridded2DSet: " + exception);
                }
                while (nArray[n2] != 32 && nArray[n2] != 10) {
                    try {
                        nArray[++n2] = inputStreamReader.read();
                    }
                    catch (Exception exception) {
                        System.out.println("Gridded2DSet: " + exception);
                    }
                }
                cArray = new char[n2];
                int n6 = 0;
                while (n6 < n2) {
                    cArray[n6] = (char)nArray[n6];
                    ++n6;
                }
                fArray[n5][n4] = Float.valueOf(new String(cArray)).floatValue();
                ++n5;
            }
            ++n4;
        }
        try {
            inputStreamReader.close();
        }
        catch (Exception exception) {
            System.out.println("Gridded2DSet: " + exception);
        }
        RealType realType = new RealType("xcoord", null, null);
        RealType realType2 = new RealType("ycoord", null, null);
        RealType[] realTypeArray = new RealType[]{realType, realType2};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        Gridded2DSet gridded2DSet = new Gridded2DSet((MathType)realTupleType, fArray, n3 / 4, 4);
        System.out.println("Lengths = " + n3 / 4 + " 4 " + " wedge = ");
        int[] nArray2 = gridded2DSet.getWedge();
        int n7 = 0;
        while (n7 < nArray2.length) {
            System.out.println(" " + nArray2[n7]);
            ++n7;
        }
        System.out.println("Samples (" + gridded2DSet.LengthX + " x " + gridded2DSet.LengthY + "):");
        n7 = 0;
        while (n7 < gridded2DSet.LengthX * gridded2DSet.LengthY) {
            System.out.println("#" + n7 + ":\t" + gridded2DSet.Samples[0][n7] + ", " + gridded2DSet.Samples[1][n7]);
            ++n7;
        }
        System.out.println("\ngridToValue test:");
        n7 = gridded2DSet.LengthX + 1;
        int n8 = gridded2DSet.LengthY + 1;
        float[][] fArray2 = new float[2][n7 * n8];
        int n9 = 0;
        while (n9 < n8) {
            n = 0;
            while (n < n7) {
                fArray2[0][n9 * n7 + n] = (float)n - 0.5f;
                fArray2[1][n9 * n7 + n] = (float)n9 - 0.5f;
                if (fArray2[0][n9 * n7 + n] < 0.0f) {
                    float[] fArray3 = fArray2[0];
                    int n10 = n9 * n7 + n;
                    fArray3[n10] = (float)((double)fArray3[n10] + 0.1);
                }
                if (fArray2[0][n9 * n7 + n] > (float)(gridded2DSet.LengthX - 1)) {
                    float[] fArray4 = fArray2[0];
                    int n11 = n9 * n7 + n;
                    fArray4[n11] = (float)((double)fArray4[n11] - 0.1);
                }
                if (fArray2[1][n9 * n7 + n] < 0.0f) {
                    float[] fArray5 = fArray2[1];
                    int n12 = n9 * n7 + n;
                    fArray5[n12] = (float)((double)fArray5[n12] + 0.1);
                }
                if (fArray2[1][n9 * n7 + n] > (float)(gridded2DSet.LengthY - 1)) {
                    float[] fArray6 = fArray2[1];
                    int n13 = n9 * n7 + n;
                    fArray6[n13] = (float)((double)fArray6[n13] - 0.1);
                }
                ++n;
            }
            ++n9;
        }
        float[][] fArray7 = gridded2DSet.gridToValue(fArray2);
        n = 0;
        while (n < n7 * n8) {
            System.out.println("(" + (float)Math.round(1000000.0f * fArray2[0][n]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * fArray2[1][n]) / 1000000.0f + ")\t-->  " + (float)Math.round(1000000.0f * fArray7[0][n]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * fArray7[1][n]) / 1000000.0f);
            ++n;
        }
        System.out.println("\nvalueToGrid test:");
        float[][] fArray8 = gridded2DSet.valueToGrid(fArray7);
        int n14 = 0;
        while (n14 < fArray8[0].length) {
            System.out.println((float)Math.round(1000000.0f * fArray7[0][n14]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * fArray7[1][n14]) / 1000000.0f + "\t-->  (" + (float)Math.round(1000000.0f * fArray8[0][n14]) / 1000000.0f + ", " + (float)Math.round(1000000.0f * fArray8[1][n14]) / 1000000.0f + ")");
            ++n14;
        }
        System.out.println();
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n, int n2) throws VisADException {
        this(mathType, fArray, n, n2, null, null, null);
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, n, n2, coordinateSystem, unitArray, errorEstimateArray, true, true);
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        this(mathType, fArray, n, n2, coordinateSystem, unitArray, errorEstimateArray, true, true);
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl, boolean bl2) throws VisADException {
        super(mathType, fArray, Gridded2DSet.make_lengths(n, n2), coordinateSystem, unitArray, errorEstimateArray, bl);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        if (this.Samples != null && this.Lengths[0] > 1 && this.Lengths[1] > 1) {
            int n3 = 0;
            while (n3 < this.Length) {
                if (this.Samples[0][n3] != this.Samples[0][n3]) {
                    throw new SetException("Gridded2DSet: samples value #" + n3 + " may not be missing");
                }
                ++n3;
            }
            if (bl2) {
                this.Pos = (this.Samples[0][1] - this.Samples[0][0]) * (this.Samples[1][this.LengthX + 1] - this.Samples[1][1]) - (this.Samples[1][1] - this.Samples[1][0]) * (this.Samples[0][this.LengthX + 1] - this.Samples[0][1]) > 0.0f;
                n3 = 0;
                while (n3 < this.LengthY - 1) {
                    int n4 = 0;
                    while (n4 < this.LengthX - 1) {
                        float[] fArray2 = new float[2];
                        float[] fArray3 = new float[2];
                        float[] fArray4 = new float[2];
                        float[] fArray5 = new float[2];
                        int n5 = 0;
                        while (n5 < 2) {
                            fArray2[n5] = this.Samples[n5][n3 * this.LengthX + n4];
                            fArray3[n5] = this.Samples[n5][n3 * this.LengthX + n4 + 1];
                            fArray4[n5] = this.Samples[n5][(n3 + 1) * this.LengthX + n4];
                            fArray5[n5] = this.Samples[n5][(n3 + 1) * this.LengthX + n4 + 1];
                            ++n5;
                        }
                        if ((fArray3[0] - fArray2[0]) * (fArray5[1] - fArray3[1]) - (fArray3[1] - fArray2[1]) * (fArray5[0] - fArray3[0]) > 0.0f != this.Pos || (fArray5[0] - fArray3[0]) * (fArray4[1] - fArray5[1]) - (fArray5[1] - fArray3[1]) * (fArray4[0] - fArray5[0]) > 0.0f != this.Pos || (fArray4[0] - fArray5[0]) * (fArray2[1] - fArray4[1]) - (fArray4[1] - fArray5[1]) * (fArray2[0] - fArray4[0]) > 0.0f != this.Pos || (fArray2[0] - fArray4[0]) * (fArray3[1] - fArray2[1]) - (fArray2[1] - fArray4[1]) * (fArray3[0] - fArray2[0]) > 0.0f != this.Pos) {
                            throw new SetException("Gridded2DSet: samples do not form a valid grid (" + n4 + "," + n3 + ")");
                        }
                        ++n4;
                    }
                    ++n3;
                }
            }
        }
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n) throws VisADException {
        this(mathType, fArray, n, null, null, null);
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, n, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded2DSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, fArray, Gridded1DSet.make_lengths(n), coordinateSystem, unitArray, errorEstimateArray, bl);
        if (this.DomainDimension != 2) {
            throw new SetException("Gridded2DSet Domain dimension should be 2, not " + this.DomainDimension);
        }
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
    }
}

