/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded2DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Gridded2DDoubleSet
extends Gridded2DSet
implements GriddedDoubleSet {
    double[] Low = new double[2];
    double[] Hi = new double[2];
    double LowX;
    double HiX;
    double LowY;
    double HiY;
    double[][] Samples;
    private int gx = -1;
    private int gy = -1;

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        return Set.doubleToFloat(this.Samples);
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(nArray));
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(fArray));
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        return Set.doubleToFloat(this.gridToDouble(Set.floatToDouble(fArray)));
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        return Set.doubleToFloat(this.doubleToGrid(Set.floatToDouble(fArray)));
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int n = fArray2.length;
        double[][] dArray = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = new double[fArray2[n2].length];
            ++n2;
        }
        this.doubleToInterp(Set.floatToDouble(fArray), nArray, dArray);
        n2 = 0;
        while (n2 < n) {
            System.arraycopy(dArray[n2], 0, fArray2[n2], 0, dArray.length);
            ++n2;
        }
    }

    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    public double[][] getDoubles(boolean bl) throws VisADException {
        return bl ? Set.copyDoubles(this.Samples) : this.Samples;
    }

    public double[][] indexToDouble(int[] nArray) throws VisADException {
        int n = nArray.length;
        if (this.Samples == null) {
            double[][] dArray = new double[this.ManifoldDimension][n];
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int n4;
                if (nArray[n2] >= 0 && nArray[n2] < this.Length) {
                    n4 = nArray[n2] % this.LengthX;
                    n3 = nArray[n2] / this.LengthX;
                } else {
                    n4 = -1;
                    n3 = -1;
                }
                dArray[0][n2] = n4;
                dArray[1][n2] = n3;
                ++n2;
            }
            return this.gridToDouble(dArray);
        }
        double[][] dArray = new double[2][n];
        int n5 = 0;
        while (n5 < n) {
            if (nArray[n5] >= 0 && nArray[n5] < this.Length) {
                dArray[0][n5] = this.Samples[0][nArray[n5]];
                dArray[1][n5] = this.Samples[1][nArray[n5]];
            } else {
                dArray[0][n5] = Double.NaN;
                dArray[1][n5] = Double.NaN;
            }
            ++n5;
        }
        return dArray;
    }

    public int[] doubleToIndex(double[][] dArray) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Gridded2DDoubleSet.doubleToIndex: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = dArray[0].length;
        int[] nArray = new int[n];
        double[][] dArray2 = this.doubleToGrid(dArray);
        double[] dArray3 = dArray2[0];
        double[] dArray4 = dArray2[1];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray3[n2];
            double d2 = dArray4[n2];
            nArray[n2] = d != d || d2 != d2 ? -1 : (int)(d + 0.5) + this.LengthX * (int)(d2 + 0.5);
            ++n2;
        }
        return nArray;
    }

    public double[][] gridToDouble(double[][] dArray) throws VisADException {
        if (dArray.length != this.ManifoldDimension) {
            throw new SetException("Gridded2DDoubleSet.gridToDouble: bad dimension");
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DDoubleSet.gridToDouble: ManifoldDimension must be 2");
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Gridded2DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int n = Math.min(dArray[0].length, dArray[1].length);
        double[][] dArray2 = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[0][n2];
            double d2 = dArray[1][n2];
            if (d < -0.5 || d2 < -0.5 || d > (double)this.LengthX - 0.5 || d2 > (double)this.LengthY - 0.5) {
                dArray2[1][n2] = Double.NaN;
                dArray2[0][n2] = Double.NaN;
            } else {
                int n3;
                int n4 = (int)d;
                int n5 = (int)d2;
                if (n4 < 0) {
                    n4 = 0;
                }
                if (n4 > this.LengthX - 2) {
                    n4 = this.LengthX - 2;
                }
                if (n5 < 0) {
                    n5 = 0;
                }
                if (n5 > this.LengthY - 2) {
                    n5 = this.LengthY - 2;
                }
                int[][] nArray = new int[][]{{this.LengthX * n5 + n4, this.LengthX * (n5 + 1) + n4}, {this.LengthX * n5 + n4 + 1, this.LengthX * (n5 + 1) + n4 + 1}};
                if (d + d2 - (double)n4 - (double)n5 - 1.0 <= 0.0) {
                    n3 = 0;
                    while (n3 < 2) {
                        dArray2[n3][n2] = this.Samples[n3][nArray[0][0]] + (d - (double)n4) * (this.Samples[n3][nArray[1][0]] - this.Samples[n3][nArray[0][0]]) + (d2 - (double)n5) * (this.Samples[n3][nArray[0][1]] - this.Samples[n3][nArray[0][0]]);
                        ++n3;
                    }
                } else {
                    n3 = 0;
                    while (n3 < 2) {
                        dArray2[n3][n2] = this.Samples[n3][nArray[1][1]] + ((double)(1 + n4) - d) * (this.Samples[n3][nArray[0][1]] - this.Samples[n3][nArray[1][1]]) + ((double)(1 + n5) - d2) * (this.Samples[n3][nArray[1][0]] - this.Samples[n3][nArray[1][1]]);
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] doubleToGrid(double[][] dArray) throws VisADException {
        if (dArray.length < this.DomainDimension) {
            throw new SetException("Gridded2DDoubleSet.doubleToGrid: bad dimension");
        }
        if (this.ManifoldDimension < 2) {
            throw new SetException("Gridded2DDoubleSet.doubleToGrid: ManifoldDimension must be 2");
        }
        if (this.Lengths[0] < 2 || this.Lengths[1] < 2) {
            throw new SetException("Gridded2DDoubleSet.doubleToGrid: requires all grid dimensions to be > 1");
        }
        int n = Math.min(dArray[0].length, dArray[1].length);
        double[][] dArray2 = new double[this.ManifoldDimension][n];
        if (this.gx < 0 || this.gx >= this.LengthX || this.gy < 0 || this.gy >= this.LengthY) {
            this.gx = (this.LengthX - 1) / 2;
            this.gy = (this.LengthY - 1) / 2;
        }
        boolean bl = true;
        int n2 = 0;
        while (n2 < n) {
            if (n2 != 0 && dArray2[0][n2 - 1] != dArray2[0][n2 - 1]) {
                this.gx = (this.LengthX - 1) / 2;
                this.gy = (this.LengthY - 1) / 2;
            }
            dArray2[1][n2] = Double.NaN;
            dArray2[0][n2] = Double.NaN;
            int n3 = 0;
            while (n3 < 2 * (this.LengthX + this.LengthY)) {
                int n4;
                int n5;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                double d;
                double d2;
                double d3;
                double[] dArray3;
                double[] dArray4;
                double[] dArray5;
                double[] dArray6 = new double[]{this.Samples[0][this.gy * this.LengthX + this.gx], this.Samples[1][this.gy * this.LengthX + this.gx]};
                double[] dArray7 = new double[]{this.Samples[0][this.gy * this.LengthX + this.gx + 1], this.Samples[1][this.gy * this.LengthX + this.gx + 1]};
                double[] dArray8 = new double[]{this.Samples[0][(this.gy + 1) * this.LengthX + this.gx], this.Samples[1][(this.gy + 1) * this.LengthX + this.gx]};
                double[] dArray9 = new double[]{this.Samples[0][(this.gy + 1) * this.LengthX + this.gx + 1], this.Samples[1][(this.gy + 1) * this.LengthX + this.gx + 1]};
                double[] dArray10 = new double[]{dArray8[0] - dArray7[0], dArray8[1] - dArray7[1]};
                double[] dArray11 = new double[]{dArray[0][n2] - dArray7[0], dArray[1][n2] - dArray7[1]};
                double[] dArray12 = new double[]{dArray[0][n2] - dArray8[0], dArray[1][n2] - dArray8[1]};
                if (bl) {
                    dArray5 = new double[]{dArray7[0] - dArray6[0], dArray7[1] - dArray6[1]};
                    dArray4 = new double[]{dArray6[0] - dArray8[0], dArray6[1] - dArray8[1]};
                    dArray3 = new double[]{dArray[0][n2] - dArray6[0], dArray[1][n2] - dArray6[1]};
                    d3 = dArray5[0] * dArray3[1] - dArray5[1] * dArray3[0];
                    d2 = dArray10[0] * dArray11[1] - dArray10[1] * dArray11[0];
                    d = dArray4[0] * dArray12[1] - dArray4[1] * dArray12[0];
                    boolean bl5 = d3 != 0.0 && d3 > 0.0 != this.Pos ? false : (bl4 = true);
                    boolean bl6 = d2 != 0.0 && d2 > 0.0 != this.Pos ? false : (bl3 = true);
                    bl2 = d == 0.0 || d > 0.0 == this.Pos;
                    n5 = this.gx++;
                    n4 = this.gy--;
                    if (bl4 || bl3) {
                        if (!bl3 && !bl2) {
                            --this.gx;
                            ++this.gy;
                        } else if (!bl4 && !bl2) {
                            --this.gx;
                            --this.gy;
                        } else if (!bl4) {
                            --this.gy;
                        } else if (!bl2) {
                            --this.gx;
                        }
                    }
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gx == n5 && this.gy == n4 && bl3) {
                        dArray2[0][n2] = ((dArray[0][n2] - dArray6[0]) * (dArray8[1] - dArray6[1]) + (dArray6[1] - dArray[1][n2]) * (dArray8[0] - dArray6[0])) / ((dArray7[0] - dArray6[0]) * (dArray8[1] - dArray6[1]) + (dArray6[1] - dArray7[1]) * (dArray8[0] - dArray6[0])) + (double)this.gx;
                        dArray2[1][n2] = ((dArray[0][n2] - dArray6[0]) * (dArray7[1] - dArray6[1]) + (dArray6[1] - dArray[1][n2]) * (dArray7[0] - dArray6[0])) / ((dArray8[0] - dArray6[0]) * (dArray7[1] - dArray6[1]) + (dArray6[1] - dArray8[1]) * (dArray7[0] - dArray6[0])) + (double)this.gy;
                        break;
                    }
                    bl = false;
                } else {
                    dArray5 = new double[]{dArray9[0] - dArray7[0], dArray9[1] - dArray7[1]};
                    dArray4 = new double[]{dArray8[0] - dArray9[0], dArray8[1] - dArray9[1]};
                    dArray3 = new double[]{dArray[0][n2] - dArray9[0], dArray[1][n2] - dArray9[1]};
                    d3 = dArray5[0] * dArray11[1] - dArray5[1] * dArray11[0];
                    d2 = dArray4[0] * dArray3[1] - dArray4[1] * dArray3[0];
                    d = dArray10[0] * dArray12[1] - dArray10[1] * dArray12[0];
                    boolean bl7 = d3 != 0.0 && d3 > 0.0 != this.Pos ? false : (bl4 = true);
                    boolean bl8 = d2 != 0.0 && d2 > 0.0 != this.Pos ? false : (bl3 = true);
                    bl2 = d == 0.0 || d < 0.0 == this.Pos;
                    n5 = this.gx++;
                    n4 = this.gy--;
                    if (bl4 || bl2) {
                        if (!bl3 && !bl2) {
                            --this.gx;
                            ++this.gy;
                        } else if (!bl4 && !bl3) {
                            ++this.gx;
                            ++this.gy;
                        } else if (!bl4) {
                            ++this.gx;
                        } else if (!bl3) {
                            ++this.gy;
                        }
                    }
                    if (this.gx < 0) {
                        this.gx = 0;
                    }
                    if (this.gx > this.LengthX - 2) {
                        this.gx = this.LengthX - 2;
                    }
                    if (this.gy < 0) {
                        this.gy = 0;
                    }
                    if (this.gy > this.LengthY - 2) {
                        this.gy = this.LengthY - 2;
                    }
                    if (this.gx == n5 && this.gy == n4 && bl2) {
                        dArray2[0][n2] = ((dArray9[0] - dArray[0][n2]) * (dArray7[1] - dArray9[1]) + (dArray[1][n2] - dArray9[1]) * (dArray7[0] - dArray9[0])) / ((dArray8[0] - dArray9[0]) * (dArray7[1] - dArray9[1]) - (dArray8[1] - dArray9[1]) * (dArray7[0] - dArray9[0])) + (double)this.gx + 1.0;
                        dArray2[1][n2] = ((dArray8[1] - dArray9[1]) * (dArray9[0] - dArray[0][n2]) + (dArray8[0] - dArray9[0]) * (dArray[1][n2] - dArray9[1])) / ((dArray7[0] - dArray9[0]) * (dArray8[1] - dArray9[1]) - (dArray8[0] - dArray9[0]) * (dArray7[1] - dArray9[1])) + (double)this.gy + 1.0;
                        break;
                    }
                    bl = true;
                }
                if (dArray2[0][n2] > (double)this.LengthX - 0.5 || dArray2[1][n2] > (double)this.LengthY - 0.5 || dArray2[0][n2] < -0.5 || dArray2[1][n2] < -0.5) {
                    dArray2[1][n2] = Double.NaN;
                    dArray2[0][n2] = Double.NaN;
                }
                ++n3;
            }
            ++n2;
        }
        return dArray2;
    }

    public void doubleToInterp(double[][] dArray, int[][] nArray, double[][] dArray2) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Gridded2DDoubleSet.doubleToInterp: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = dArray[0].length;
        if (nArray.length != n) {
            throw new SetException("Gridded2DDoubleSet.valueToInterp: indices length " + nArray.length + " doesn't match value[0] length " + dArray[0].length);
        }
        if (dArray2.length != n) {
            throw new SetException("Gridded2DDoubleSet.valueToInterp: weights length " + dArray2.length + " doesn't match value[0] length " + dArray[0].length);
        }
        double[][] dArray3 = this.doubleToGrid(dArray);
        int[] nArray2 = new int[this.ManifoldDimension];
        double[] dArray4 = new double[this.ManifoldDimension];
        int[] nArray3 = new int[this.ManifoldDimension];
        nArray3[0] = 1;
        int n2 = 1;
        while (n2 < this.ManifoldDimension) {
            nArray3[n2] = nArray3[n2 - 1] * this.Lengths[n2 - 1];
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            double[] dArray5;
            int[] nArray4;
            int n4;
            int n5 = 1;
            if (Double.isNaN(dArray3[this.ManifoldDimension - 1][n3])) {
                n4 = -1;
            } else {
                nArray2[this.ManifoldDimension - 1] = (int)(dArray3[this.ManifoldDimension - 1][n3] + 0.5);
                if (nArray2[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n6 = this.ManifoldDimension - 1;
                    nArray2[n6] = nArray2[n6] - 1;
                }
                dArray4[this.ManifoldDimension - 1] = dArray3[this.ManifoldDimension - 1][n3] - (double)nArray2[this.ManifoldDimension - 1];
                if (!(nArray2[this.ManifoldDimension - 1] == 0 && dArray4[this.ManifoldDimension - 1] <= 0.0 || nArray2[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && dArray4[this.ManifoldDimension - 1] >= 0.0)) {
                    n5 *= 2;
                }
                n4 = nArray2[this.ManifoldDimension - 1];
            }
            n2 = this.ManifoldDimension - 2;
            while (n2 >= 0 && n4 >= 0) {
                if (Double.isNaN(dArray3[n2][n3])) {
                    n4 = -1;
                } else {
                    nArray2[n2] = (int)(dArray3[n2][n3] + 0.5);
                    if (nArray2[n2] == this.Lengths[n2]) {
                        int n7 = n2;
                        nArray2[n7] = nArray2[n7] - 1;
                    }
                    dArray4[n2] = dArray3[n2][n3] - (double)nArray2[n2];
                    if (!(nArray2[n2] == 0 && dArray4[n2] <= 0.0 || nArray2[n2] == this.Lengths[n2] - 1 && dArray4[n2] >= 0.0)) {
                        n5 *= 2;
                    }
                    n4 = nArray2[n2] + this.Lengths[n2] * n4;
                }
                --n2;
            }
            if (n4 < 0) {
                nArray4 = null;
                dArray5 = null;
            } else {
                nArray4 = new int[n5];
                dArray5 = new double[n5];
                nArray4[0] = n4;
                dArray5[0] = 1.0;
                int n8 = 1;
                n2 = 0;
                while (n2 < this.ManifoldDimension) {
                    if (!(nArray2[n2] == 0 && dArray4[n2] <= 0.0 || nArray2[n2] == this.Lengths[n2] - 1 && dArray4[n2] >= 0.0)) {
                        double d;
                        double d2;
                        int n9;
                        if (dArray4[n2] >= 0.0) {
                            n9 = nArray3[n2];
                            d2 = 1.0 - dArray4[n2];
                            d = dArray4[n2];
                        } else {
                            n9 = -nArray3[n2];
                            d2 = 1.0 + dArray4[n2];
                            d = -dArray4[n2];
                        }
                        int n10 = 0;
                        while (n10 < n8) {
                            nArray4[n10 + n8] = nArray4[n10] + n9;
                            dArray5[n10 + n8] = dArray5[n10] * d;
                            int n11 = n10++;
                            dArray5[n11] = dArray5[n11] * d2;
                        }
                        n8 *= 2;
                    }
                    ++n2;
                }
            }
            nArray[n3] = nArray4;
            dArray2[n3] = dArray5;
            ++n3;
        }
    }

    void init_doubles(double[][] dArray, boolean bl) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Gridded2DDoubleSet.init_doubles: samples  dimension " + dArray.length + " not equal to domain dimension " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = dArray[0].length;
        } else if (this.Length != dArray[0].length) {
            throw new SetException("Gridded2DDoubleSet.init_doubles: samples[0] length " + dArray[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = bl ? new double[this.DomainDimension][this.Length] : dArray;
        int n = 0;
        while (n < this.DomainDimension) {
            if (dArray[n].length != this.Length) {
                throw new SetException("Gridded2DDoubleSet.init_doubles: samples[" + n + "] length " + dArray[0].length + " doesn't match expected length " + this.Length);
            }
            double[] dArray2 = dArray[n];
            double[] dArray3 = this.Samples[n];
            if (bl) {
                System.arraycopy(dArray2, 0, dArray3, 0, this.Length);
            }
            this.Low[n] = Double.POSITIVE_INFINITY;
            this.Hi[n] = Double.NEGATIVE_INFINITY;
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.Length) {
                if (dArray3[n2] == dArray3[n2] && !Double.isInfinite(dArray3[n2])) {
                    if (dArray3[n2] < this.Low[n]) {
                        this.Low[n] = dArray3[n2];
                    }
                    if (dArray3[n2] > this.Hi[n]) {
                        this.Hi[n] = dArray3[n2];
                    }
                } else {
                    dArray3[n2] = Double.NaN;
                }
                d += dArray3[n2];
                ++n2;
            }
            if (this.SetErrors[n] != null) {
                this.SetErrors[n] = new ErrorEstimate(this.SetErrors[n].getErrorValue(), d / (double)this.Length, this.Length, this.SetErrors[n].getUnit());
            }
            ((SampledSet)this).Low[n] = (float)this.Low[n];
            ((SampledSet)this).Hi[n] = (float)this.Hi[n];
            ++n;
        }
    }

    public void cram_missing(boolean[] blArray) {
        int n = Math.min(blArray.length, this.Samples[0].length);
        int n2 = 0;
        while (n2 < n) {
            if (!blArray[n2]) {
                this.Samples[0][n2] = Double.NaN;
            }
            ++n2;
        }
    }

    public boolean isMissing() {
        return this.Samples == null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Gridded2DDoubleSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.testNotEqualsCache((Set)object)) {
            return false;
        }
        if (this.testEqualsCache((Set)object)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        try {
            if (this.DomainDimension != ((Gridded2DDoubleSet)object).getDimension() || this.ManifoldDimension != ((Gridded2DDoubleSet)object).getManifoldDimension() || this.Length != ((Gridded2DDoubleSet)object).getLength()) {
                return false;
            }
            int n = 0;
            while (n < this.ManifoldDimension) {
                if (this.Lengths[n] != ((Gridded2DDoubleSet)object).getLength(n)) {
                    return false;
                }
                ++n;
            }
            double[][] dArray = ((Gridded2DDoubleSet)object).getDoubles(false);
            if (this.Samples != null && dArray != null) {
                n = 0;
                while (n < this.DomainDimension) {
                    int n2 = 0;
                    while (n2 < this.Length) {
                        if (this.Samples[n][n2] != dArray[n][n2]) {
                            this.addNotEqualsCache((Set)object);
                            return false;
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else {
                double[][] dArray2 = this.getDoubles(false);
                if (dArray2 == null) {
                    if (dArray != null) {
                        return false;
                    }
                } else {
                    if (dArray == null) {
                        return false;
                    }
                    n = 0;
                    while (n < this.DomainDimension) {
                        int n3 = 0;
                        while (n3 < this.Length) {
                            if (dArray2[n][n3] != dArray[n][n3]) {
                                this.addNotEqualsCache((Set)object);
                                return false;
                            }
                            ++n3;
                        }
                        ++n;
                    }
                }
            }
            this.addEqualsCache((Set)object);
            return true;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public Object clone() {
        try {
            return new Gridded2DDoubleSet(this.Type, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("Gridded2DDoubleSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new Gridded2DDoubleSet(mathType, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n, int n2) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, n2, null, null, null, true);
    }

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, n2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, n2, coordinateSystem, unitArray, errorEstimateArray, bl);
    }

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, null, null, null, true);
    }

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded2DDoubleSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, coordinateSystem, unitArray, errorEstimateArray, bl);
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n, int n2) throws VisADException {
        this(mathType, dArray, n, n2, null, null, null, true);
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, dArray, n, n2, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n, int n2, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, null, n, n2, coordinateSystem, unitArray, errorEstimateArray, bl);
        if (dArray == null) {
            throw new SetException("Gridded2DDoubleSet: samples are null");
        }
        this.init_doubles(dArray, bl);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
        this.LengthY = this.Lengths[1];
        if (this.Samples != null && this.Lengths[0] > 1 && this.Lengths[1] > 1) {
            int n3 = 0;
            while (n3 < this.Length) {
                if (this.Samples[0][n3] != this.Samples[0][n3]) {
                    throw new SetException("Gridded2DDoubleSet: samples values may not be missing");
                }
                ++n3;
            }
            this.Pos = (this.Samples[0][1] - this.Samples[0][0]) * (this.Samples[1][this.LengthX + 1] - this.Samples[1][1]) - (this.Samples[1][1] - this.Samples[1][0]) * (this.Samples[0][this.LengthX + 1] - this.Samples[0][1]) > 0.0;
            n3 = 0;
            while (n3 < this.LengthY - 1) {
                int n4 = 0;
                while (n4 < this.LengthX - 1) {
                    double[] dArray2 = new double[2];
                    double[] dArray3 = new double[2];
                    double[] dArray4 = new double[2];
                    double[] dArray5 = new double[2];
                    int n5 = 0;
                    while (n5 < 2) {
                        dArray2[n5] = this.Samples[n5][n3 * this.LengthX + n4];
                        dArray3[n5] = this.Samples[n5][n3 * this.LengthX + n4 + 1];
                        dArray4[n5] = this.Samples[n5][(n3 + 1) * this.LengthX + n4];
                        dArray5[n5] = this.Samples[n5][(n3 + 1) * this.LengthX + n4 + 1];
                        ++n5;
                    }
                    if ((dArray3[0] - dArray2[0]) * (dArray5[1] - dArray3[1]) - (dArray3[1] - dArray2[1]) * (dArray5[0] - dArray3[0]) > 0.0 != this.Pos || (dArray5[0] - dArray3[0]) * (dArray4[1] - dArray5[1]) - (dArray5[1] - dArray3[1]) * (dArray4[0] - dArray5[0]) > 0.0 != this.Pos || (dArray4[0] - dArray5[0]) * (dArray2[1] - dArray4[1]) - (dArray4[1] - dArray5[1]) * (dArray2[0] - dArray4[0]) > 0.0 != this.Pos || (dArray2[0] - dArray4[0]) * (dArray3[1] - dArray2[1]) - (dArray2[1] - dArray4[1]) * (dArray3[0] - dArray2[0]) > 0.0 != this.Pos) {
                        throw new SetException("Gridded2DDoubleSet: samples do not form a valid grid (" + n4 + "," + n3 + ")");
                    }
                    ++n4;
                }
                ++n3;
            }
        }
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n) throws VisADException {
        this(mathType, dArray, n, null, null, null);
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, dArray, n, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded2DDoubleSet(MathType mathType, double[][] dArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        super(mathType, null, n, coordinateSystem, unitArray, errorEstimateArray, bl);
        if (dArray == null) {
            throw new SetException("Gridded2DDoubleSet: samples are null");
        }
        this.init_doubles(dArray, bl);
        this.LowX = this.Low[0];
        this.HiX = this.Hi[0];
        this.LengthX = this.Lengths[0];
        this.LowY = this.Low[1];
        this.HiY = this.Hi[1];
    }
}

