/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSetIface;
import visad.GriddedSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Gridded1DSet
extends GriddedSet
implements Gridded1DSetIface {
    private static final WeakHashMap cache = new WeakHashMap();
    int LengthX;
    float LowX;
    float HiX;
    boolean Ascending;
    private int ig;

    public static synchronized Gridded1DSet create(MathType mathType, float[] fArray, CoordinateSystem coordinateSystem, Unit unit, ErrorEstimate errorEstimate) throws VisADException {
        Gridded1DSet gridded1DSet = new Gridded1DSet(mathType, new float[][]{fArray}, fArray.length, coordinateSystem, new Unit[]{unit}, new ErrorEstimate[]{errorEstimate}, false);
        WeakReference weakReference = (WeakReference)cache.get(gridded1DSet);
        if (weakReference == null) {
            cache.put(gridded1DSet, new WeakReference<Gridded1DSet>(gridded1DSet));
        } else {
            Gridded1DSet gridded1DSet2 = (Gridded1DSet)weakReference.get();
            if (gridded1DSet2 == null) {
                cache.put(gridded1DSet, new WeakReference<Gridded1DSet>(gridded1DSet));
            } else {
                gridded1DSet = gridded1DSet2;
            }
        }
        return gridded1DSet;
    }

    static int[] make_lengths(int n) {
        int[] nArray = new int[]{n};
        return nArray;
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        int n = nArray.length;
        if (this.Samples == null) {
            float[][] fArray = new float[this.ManifoldDimension][n];
            int n2 = 0;
            while (n2 < n) {
                fArray[0][n2] = nArray[n2] >= 0 && nArray[n2] < this.Length ? (float)nArray[n2] : -1.0f;
                ++n2;
            }
            return this.gridToValue(fArray);
        }
        float[][] fArray = new float[1][n];
        int n3 = 0;
        while (n3 < n) {
            fArray[0][n3] = nArray[n3] >= 0 && nArray[n3] < this.Length ? this.Samples[0][nArray[n3]] : Float.NaN;
            ++n3;
        }
        return fArray;
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        if (fArray.length != this.DomainDimension) {
            throw new SetException("Gridded1DSet.valueToIndex: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = fArray[0].length;
        int[] nArray = new int[n];
        float[][] fArray2 = this.valueToGrid(fArray);
        float[] fArray3 = fArray2[0];
        int n2 = 0;
        while (n2 < n) {
            float f = fArray3[n2];
            nArray[n2] = Float.isNaN(f) ? -1 : (int)((double)f + 0.5);
            ++n2;
        }
        return nArray;
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        if (fArray.length < this.DomainDimension) {
            throw new SetException("Gridded1DSet.gridToValue: grid dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Gridded1DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[1][n];
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[0][n2];
            if ((double)f < -0.5 || (double)f > (double)this.LengthX - 0.5) {
                fArray2[0][n2] = Float.NaN;
            } else {
                int n3 = f < 0.0f ? 0 : (f >= (float)(this.LengthX - 1) ? this.LengthX - 2 : (int)f);
                float f2 = f - (float)n3;
                fArray2[0][n2] = (1.0f - f2) * this.Samples[0][n3] + f2 * this.Samples[0][n3 + 1];
            }
            ++n2;
        }
        return fArray2;
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        if (fArray.length < this.DomainDimension) {
            throw new SetException("Gridded1DSet.valueToGrid: value dimension " + fArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Gridded1DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        float[] fArray2 = fArray[0];
        int n = fArray2.length;
        float[] fArray3 = this.Samples[0];
        float[][] fArray4 = new float[1][n];
        if (this.ig < 0 || this.ig >= this.LengthX) {
            this.ig = (this.LengthX - 1) / 2;
        }
        int n2 = 0;
        while (n2 < n) {
            if (Float.isNaN(fArray2[n2])) {
                fArray4[0][n2] = Float.NaN;
            } else {
                float f;
                int n3 = 0;
                int n4 = this.LengthX - 1;
                while (n3 < n4) {
                    if ((fArray2[n2] - fArray3[this.ig]) * (fArray2[n2] - fArray3[this.ig + 1]) <= 0.0f) break;
                    boolean bl = this.Ascending ? fArray3[this.ig + 1] < fArray2[n2] : fArray3[this.ig + 1] > fArray2[n2];
                    if (bl) {
                        n3 = this.ig + 1;
                    } else {
                        boolean bl2 = this.Ascending ? fArray3[this.ig] > fArray2[n2] : fArray3[this.ig] < fArray2[n2];
                        if (bl2) {
                            n4 = this.ig;
                        }
                    }
                    if (n3 >= n4) continue;
                    this.ig = (n3 + n4) / 2;
                }
                if ((double)(f = (float)this.ig + (fArray2[n2] - fArray3[this.ig]) / (fArray3[this.ig + 1] - fArray3[this.ig])) >= -0.5 && (double)f <= (double)this.LengthX - 0.5) {
                    fArray4[0][n2] = f;
                } else {
                    fArray4[0][n2] = Float.NaN;
                    this.ig = (this.LengthX - 1) / 2;
                }
            }
            ++n2;
        }
        return fArray4;
    }

    public float getLowX() {
        return this.LowX;
    }

    public float getHiX() {
        return this.HiX;
    }

    public Object clone() {
        try {
            return new Gridded1DSet(this.Type, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("Gridded1DSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new Gridded1DSet(mathType, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public static void main(String[] stringArray) throws VisADException {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        int[] nArray = new int[80];
        try {
            nArray[0] = inputStreamReader.read();
        }
        catch (Exception exception) {
            System.out.println("Gridded1DSet: " + exception);
        }
        int n = 0;
        while (nArray[n] != 10) {
            try {
                nArray[++n] = inputStreamReader.read();
            }
            catch (Exception exception) {
                System.out.println("Gridded1DSet: " + exception);
            }
        }
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)nArray[n2];
            ++n2;
        }
        n2 = Integer.parseInt(new String(cArray));
        float[][] fArray = new float[1][n2];
        System.out.println("num_dimensions = 1, num_coords = " + n2 + "\n");
        try {
            nArray[0] = inputStreamReader.read();
        }
        catch (Exception exception) {
            System.out.println("Gridded1DSet: " + exception);
        }
        int n3 = 0;
        while (n3 < n2) {
            n = 0;
            try {
                nArray[0] = inputStreamReader.read();
            }
            catch (Exception exception) {
                System.out.println("Gridded1DSet: " + exception);
            }
            while (nArray[n] != 32) {
                try {
                    nArray[++n] = inputStreamReader.read();
                }
                catch (Exception exception) {
                    System.out.println("Gridded1DSet: " + exception);
                }
            }
            cArray = new char[n];
            int n4 = 0;
            while (n4 < n) {
                cArray[n4] = (char)nArray[n4];
                ++n4;
            }
            fArray[0][n3] = Float.valueOf(new String(cArray)).floatValue();
            ++n3;
        }
        try {
            inputStreamReader.close();
        }
        catch (Exception exception) {
            System.out.println("Gridded1DSet: " + exception);
        }
        RealType realType = new RealType("vis_data", null, null);
        RealType[] realTypeArray = new RealType[]{realType};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        Gridded1DSet gridded1DSet = new Gridded1DSet((MathType)realTupleType, fArray, n2);
        System.out.println("Lengths = " + n2 + " wedge = ");
        int[] nArray2 = gridded1DSet.getWedge();
        int n5 = 0;
        while (n5 < nArray2.length) {
            System.out.println(" " + nArray2[n5]);
            ++n5;
        }
        System.out.println("Samples (" + gridded1DSet.LengthX + "):");
        n5 = 0;
        while (n5 < gridded1DSet.LengthX) {
            System.out.println("#" + n5 + ":\t" + gridded1DSet.Samples[0][n5]);
            ++n5;
        }
        System.out.println("\ngridToValue test:");
        n5 = gridded1DSet.LengthX + 1;
        float[][] fArray2 = new float[1][n5];
        int n6 = 0;
        while (n6 < n5) {
            fArray2[0][n6] = (float)n6 - 0.5f;
            ++n6;
        }
        float[] fArray3 = fArray2[0];
        fArray3[0] = (float)((double)fArray3[0] + 0.1);
        float[] fArray4 = fArray2[0];
        int n7 = n5 - 1;
        fArray4[n7] = (float)((double)fArray4[n7] - 0.1);
        float[][] fArray5 = gridded1DSet.gridToValue(fArray2);
        int n8 = 0;
        while (n8 < n5) {
            System.out.println("(" + (float)Math.round(1000000.0f * fArray2[0][n8]) / 1000000.0f + ")\t-->  " + (float)Math.round(1000000.0f * fArray5[0][n8]) / 1000000.0f);
            ++n8;
        }
        System.out.println("\nvalueToGrid test:");
        float[][] fArray6 = gridded1DSet.valueToGrid(fArray5);
        int n9 = 0;
        while (n9 < fArray6[0].length) {
            System.out.println((float)Math.round(1000000.0f * fArray5[0][n9]) / 1000000.0f + "  \t-->  (" + (float)Math.round(1000000.0f * fArray6[0][n9]) / 1000000.0f + ")");
            ++n9;
        }
        System.out.println();
    }

    public Gridded1DSet(MathType mathType, float[][] fArray, int n) throws VisADException {
        this(mathType, fArray, n, null, null, null);
    }

    public Gridded1DSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, fArray, n, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded1DSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        block8: {
            super(mathType, fArray, Gridded1DSet.make_lengths(n), coordinateSystem, unitArray, errorEstimateArray, bl);
            this.ig = -1;
            this.LowX = this.Low[0];
            this.HiX = this.Hi[0];
            this.LengthX = this.Lengths[0];
            if (this.Samples == null || this.Lengths[0] <= 1) break block8;
            int n2 = 0;
            while (n2 < this.Length) {
                if (this.Samples[0][n2] != this.Samples[0][n2]) {
                    throw new SetException("Gridded1DSet: samples values may not be missing");
                }
                ++n2;
            }
            boolean bl2 = this.Ascending = this.Samples[0][this.LengthX - 1] > this.Samples[0][0];
            if (this.Ascending) {
                n2 = 1;
                while (n2 < this.LengthX) {
                    if (this.Samples[0][n2] < this.Samples[0][n2 - 1]) {
                        throw new SetException("Gridded1DSet: samples do not form a valid grid (" + n2 + ")");
                    }
                    ++n2;
                }
            } else {
                n2 = 1;
                while (n2 < this.LengthX) {
                    if (this.Samples[0][n2] > this.Samples[0][n2 - 1]) {
                        throw new SetException("Gridded1DSet: samples do not form a valid grid (" + n2 + ")");
                    }
                    ++n2;
                }
            }
        }
    }
}

