/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.GriddedDoubleSet;
import visad.MathType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.Unit;
import visad.VisADError;
import visad.VisADException;

public class Gridded1DDoubleSet
extends Gridded1DSet
implements GriddedDoubleSet {
    private static final WeakHashMap cache = new WeakHashMap();
    double[] Low;
    double[] Hi;
    double LowX;
    double HiX;
    double[][] Samples;
    private int ig;

    public static synchronized Gridded1DDoubleSet create(MathType mathType, double[] dArray, CoordinateSystem coordinateSystem, Unit unit, ErrorEstimate errorEstimate) throws VisADException {
        Gridded1DDoubleSet gridded1DDoubleSet = new Gridded1DDoubleSet(mathType, new double[][]{dArray}, dArray.length, coordinateSystem, new Unit[]{unit}, new ErrorEstimate[]{errorEstimate}, false);
        WeakReference weakReference = (WeakReference)cache.get(gridded1DDoubleSet);
        if (weakReference == null) {
            cache.put(gridded1DDoubleSet, new WeakReference<Gridded1DDoubleSet>(gridded1DDoubleSet));
        } else {
            Gridded1DDoubleSet gridded1DDoubleSet2 = (Gridded1DDoubleSet)weakReference.get();
            if (gridded1DDoubleSet2 == null) {
                cache.put(gridded1DDoubleSet, new WeakReference<Gridded1DDoubleSet>(gridded1DDoubleSet));
            } else {
                gridded1DDoubleSet = gridded1DDoubleSet2;
            }
        }
        return gridded1DDoubleSet;
    }

    public float[][] getSamples() throws VisADException {
        return this.getSamples(true);
    }

    public float[][] getSamples(boolean bl) throws VisADException {
        return Set.doubleToFloat(this.Samples);
    }

    public float[][] indexToValue(int[] nArray) throws VisADException {
        return Set.doubleToFloat(this.indexToDouble(nArray));
    }

    public int[] valueToIndex(float[][] fArray) throws VisADException {
        return this.doubleToIndex(Set.floatToDouble(fArray));
    }

    public float[][] gridToValue(float[][] fArray) throws VisADException {
        return Set.doubleToFloat(this.gridToDouble(Set.floatToDouble(fArray)));
    }

    public float[][] valueToGrid(float[][] fArray) throws VisADException {
        return Set.doubleToFloat(this.doubleToGrid(Set.floatToDouble(fArray)));
    }

    public void valueToInterp(float[][] fArray, int[][] nArray, float[][] fArray2) throws VisADException {
        int n = fArray2.length;
        double[][] dArray = new double[n][];
        this.doubleToInterp(Set.floatToDouble(fArray), nArray, dArray);
        int n2 = 0;
        while (n2 < n) {
            if (dArray[n2] != null) {
                fArray2[n2] = new float[dArray[n2].length];
                int n3 = 0;
                while (n3 < dArray[n2].length) {
                    fArray2[n2][n3] = (float)dArray[n2][n3];
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public float getLowX() {
        return (float)this.LowX;
    }

    public float getHiX() {
        return (float)this.HiX;
    }

    public double[][] getDoubles() throws VisADException {
        return this.getDoubles(true);
    }

    public double[][] getDoubles(boolean bl) throws VisADException {
        return bl ? Set.copyDoubles(this.Samples) : this.Samples;
    }

    public double[][] indexToDouble(int[] nArray) throws VisADException {
        int n = nArray.length;
        if (this.Samples == null) {
            double[][] dArray = new double[this.ManifoldDimension][n];
            int n2 = 0;
            while (n2 < n) {
                dArray[0][n2] = nArray[n2] >= 0 && nArray[n2] < this.Length ? (double)nArray[n2] : -1.0;
                ++n2;
            }
            return this.gridToDouble(dArray);
        }
        double[][] dArray = new double[1][n];
        int n3 = 0;
        while (n3 < n) {
            dArray[0][n3] = nArray[n3] >= 0 && nArray[n3] < this.Length ? this.Samples[0][nArray[n3]] : Double.NaN;
            ++n3;
        }
        return dArray;
    }

    public int[] doubleToIndex(double[][] dArray) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.doubleToIndex: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = dArray[0].length;
        int[] nArray = new int[n];
        double[][] dArray2 = this.doubleToGrid(dArray);
        double[] dArray3 = dArray2[0];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray3[n2];
            nArray[n2] = Double.isNaN(d) ? -1 : (int)(d + 0.5);
            ++n2;
        }
        return nArray;
    }

    public double[][] gridToDouble(double[][] dArray) throws VisADException {
        if (dArray.length < this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.gridToDouble: grid dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Gridded1DDoubleSet.gridToDouble: requires all grid dimensions to be > 1");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[1][n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[0][n2];
            if (d < -0.5 || d > (double)this.LengthX - 0.5) {
                dArray2[0][n2] = Double.NaN;
            } else {
                int n3 = d < 0.0 ? 0 : (d >= (double)(this.LengthX - 1) ? this.LengthX - 2 : (int)d);
                double d2 = d - (double)n3;
                dArray2[0][n2] = (1.0 - d2) * this.Samples[0][n3] + d2 * this.Samples[0][n3 + 1];
            }
            ++n2;
        }
        return dArray2;
    }

    public double[][] doubleToGrid(double[][] dArray) throws VisADException {
        if (dArray.length < this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.doubleToGrid: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Lengths[0] < 2) {
            throw new SetException("Gridded1DDoubleSet.doubleToGrid: requires all grid dimensions to be > 1");
        }
        double[] dArray2 = dArray[0];
        int n = dArray2.length;
        double[] dArray3 = this.Samples[0];
        double[][] dArray4 = new double[1][n];
        if (this.ig < 0 || this.ig >= this.LengthX) {
            this.ig = (this.LengthX - 1) / 2;
        }
        int n2 = 0;
        while (n2 < n) {
            if (Double.isNaN(dArray2[n2])) {
                dArray4[0][n2] = Double.NaN;
            } else {
                double d;
                int n3 = 0;
                int n4 = this.LengthX - 1;
                while (n3 < n4) {
                    if ((dArray2[n2] - dArray3[this.ig]) * (dArray2[n2] - dArray3[this.ig + 1]) <= 0.0) break;
                    boolean bl = this.Ascending ? dArray3[this.ig + 1] < dArray2[n2] : dArray3[this.ig + 1] > dArray2[n2];
                    if (bl) {
                        n3 = this.ig + 1;
                    } else {
                        boolean bl2 = this.Ascending ? dArray3[this.ig] > dArray2[n2] : dArray3[this.ig] < dArray2[n2];
                        if (bl2) {
                            n4 = this.ig;
                        }
                    }
                    if (n3 >= n4) continue;
                    this.ig = (n3 + n4) / 2;
                }
                if ((d = (double)this.ig + (dArray2[n2] - dArray3[this.ig]) / (dArray3[this.ig + 1] - dArray3[this.ig])) >= -0.5 && d <= (double)this.LengthX - 0.5) {
                    dArray4[0][n2] = d;
                } else {
                    dArray4[0][n2] = Double.NaN;
                    this.ig = (this.LengthX - 1) / 2;
                }
            }
            ++n2;
        }
        return dArray4;
    }

    public void doubleToInterp(double[][] dArray, int[][] nArray, double[][] dArray2) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.doubleToInterp: value dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        int n = dArray[0].length;
        if (nArray.length != n) {
            throw new SetException("Gridded1DDoubleinearLatLonSet.doubleToInterp: indices length " + nArray.length + " doesn't match value[0] length " + dArray[0].length);
        }
        if (dArray2.length != n) {
            throw new SetException("Gridded1DDoubleSet.doubleToInterp: weights length " + dArray2.length + " doesn't match value[0] length " + dArray[0].length);
        }
        double[][] dArray3 = this.doubleToGrid(dArray);
        int[] nArray2 = new int[this.ManifoldDimension];
        double[] dArray4 = new double[this.ManifoldDimension];
        int[] nArray3 = new int[this.ManifoldDimension];
        nArray3[0] = 1;
        int n2 = 1;
        while (n2 < this.ManifoldDimension) {
            nArray3[n2] = nArray3[n2 - 1] * this.Lengths[n2 - 1];
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            double[] dArray5;
            int[] nArray4;
            int n4;
            int n5 = 1;
            if (Double.isNaN(dArray3[this.ManifoldDimension - 1][n3])) {
                n4 = -1;
            } else {
                nArray2[this.ManifoldDimension - 1] = (int)(dArray3[this.ManifoldDimension - 1][n3] + 0.5);
                if (nArray2[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1]) {
                    int n6 = this.ManifoldDimension - 1;
                    nArray2[n6] = nArray2[n6] - 1;
                }
                dArray4[this.ManifoldDimension - 1] = dArray3[this.ManifoldDimension - 1][n3] - (double)nArray2[this.ManifoldDimension - 1];
                if (!(nArray2[this.ManifoldDimension - 1] == 0 && dArray4[this.ManifoldDimension - 1] <= 0.0 || nArray2[this.ManifoldDimension - 1] == this.Lengths[this.ManifoldDimension - 1] - 1 && dArray4[this.ManifoldDimension - 1] >= 0.0)) {
                    n5 *= 2;
                }
                n4 = nArray2[this.ManifoldDimension - 1];
            }
            n2 = this.ManifoldDimension - 2;
            while (n2 >= 0 && n4 >= 0) {
                if (Double.isNaN(dArray3[n2][n3])) {
                    n4 = -1;
                } else {
                    nArray2[n2] = (int)(dArray3[n2][n3] + 0.5);
                    if (nArray2[n2] == this.Lengths[n2]) {
                        int n7 = n2;
                        nArray2[n7] = nArray2[n7] - 1;
                    }
                    dArray4[n2] = dArray3[n2][n3] - (double)nArray2[n2];
                    if (!(nArray2[n2] == 0 && dArray4[n2] <= 0.0 || nArray2[n2] == this.Lengths[n2] - 1 && dArray4[n2] >= 0.0)) {
                        n5 *= 2;
                    }
                    n4 = nArray2[n2] + this.Lengths[n2] * n4;
                }
                --n2;
            }
            if (n4 < 0) {
                nArray4 = null;
                dArray5 = null;
            } else {
                nArray4 = new int[n5];
                dArray5 = new double[n5];
                nArray4[0] = n4;
                dArray5[0] = 1.0;
                int n8 = 1;
                n2 = 0;
                while (n2 < this.ManifoldDimension) {
                    if (!(nArray2[n2] == 0 && dArray4[n2] <= 0.0 || nArray2[n2] == this.Lengths[n2] - 1 && dArray4[n2] >= 0.0)) {
                        double d;
                        double d2;
                        int n9;
                        if (dArray4[n2] >= 0.0) {
                            n9 = nArray3[n2];
                            d2 = 1.0 - dArray4[n2];
                            d = dArray4[n2];
                        } else {
                            n9 = -nArray3[n2];
                            d2 = 1.0 + dArray4[n2];
                            d = -dArray4[n2];
                        }
                        int n10 = 0;
                        while (n10 < n8) {
                            nArray4[n10 + n8] = nArray4[n10] + n9;
                            dArray5[n10 + n8] = dArray5[n10] * d;
                            int n11 = n10++;
                            dArray5[n11] = dArray5[n11] * d2;
                        }
                        n8 *= 2;
                    }
                    ++n2;
                }
            }
            nArray[n3] = nArray4;
            dArray2[n3] = dArray5;
            ++n3;
        }
    }

    public double getDoubleLowX() {
        return this.LowX;
    }

    public double getDoubleHiX() {
        return this.HiX;
    }

    void init_doubles(double[][] dArray, boolean bl) throws VisADException {
        if (dArray.length != this.DomainDimension) {
            throw new SetException("Gridded1DDoubleSet.init_doubles: samples dimension " + dArray.length + " not equal to Domain dimension " + this.DomainDimension);
        }
        if (this.Length == 0) {
            this.Length = dArray[0].length;
        } else if (this.Length != dArray[0].length) {
            throw new SetException("Gridded1DDoubleSet.init_doubles: samples[0] length " + dArray[0].length + " doesn't match expected length " + this.Length);
        }
        this.Samples = bl ? new double[this.DomainDimension][this.Length] : dArray;
        int n = 0;
        while (n < this.DomainDimension) {
            if (dArray[n].length != this.Length) {
                throw new SetException("Gridded1DDoubleSet.init_doubles: samples[" + n + "] length " + dArray[0].length + " doesn't match expected length " + this.Length);
            }
            double[] dArray2 = dArray[n];
            double[] dArray3 = this.Samples[n];
            if (bl) {
                System.arraycopy(dArray2, 0, dArray3, 0, this.Length);
            }
            this.Low[n] = Double.POSITIVE_INFINITY;
            this.Hi[n] = Double.NEGATIVE_INFINITY;
            double d = 0.0;
            int n2 = 0;
            while (n2 < this.Length) {
                if (dArray3[n2] == dArray3[n2] && !Double.isInfinite(dArray3[n2])) {
                    if (dArray3[n2] < this.Low[n]) {
                        this.Low[n] = dArray3[n2];
                    }
                    if (dArray3[n2] > this.Hi[n]) {
                        this.Hi[n] = dArray3[n2];
                    }
                } else {
                    dArray3[n2] = Double.NaN;
                }
                d += dArray3[n2];
                ++n2;
            }
            if (this.SetErrors[n] != null) {
                this.SetErrors[n] = new ErrorEstimate(this.SetErrors[n].getErrorValue(), d / (double)this.Length, this.Length, this.SetErrors[n].getUnit());
            }
            ((SampledSet)this).Low[n] = (float)this.Low[n];
            ((SampledSet)this).Hi[n] = (float)this.Hi[n];
            ++n;
        }
    }

    public void cram_missing(boolean[] blArray) {
        int n = Math.min(blArray.length, this.Samples[0].length);
        int n2 = 0;
        while (n2 < n) {
            if (!blArray[n2]) {
                this.Samples[0][n2] = Double.NaN;
            }
            ++n2;
        }
    }

    public boolean isMissing() {
        return this.Samples == null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Gridded1DDoubleSet) || object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.testNotEqualsCache((Set)object)) {
            return false;
        }
        if (this.testEqualsCache((Set)object)) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)object)) {
            return false;
        }
        try {
            if (this.DomainDimension != ((Gridded1DDoubleSet)object).getDimension() || this.ManifoldDimension != ((Gridded1DDoubleSet)object).getManifoldDimension() || this.Length != ((Gridded1DDoubleSet)object).getLength()) {
                return false;
            }
            int n = 0;
            while (n < this.ManifoldDimension) {
                if (this.Lengths[n] != ((Gridded1DDoubleSet)object).getLength(n)) {
                    return false;
                }
                ++n;
            }
            double[][] dArray = ((Gridded1DDoubleSet)object).getDoubles(false);
            if (this.Samples != null && dArray != null) {
                n = 0;
                while (n < this.DomainDimension) {
                    int n2 = 0;
                    while (n2 < this.Length) {
                        if (this.Samples[n][n2] != dArray[n][n2]) {
                            this.addNotEqualsCache((Set)object);
                            return false;
                        }
                        ++n2;
                    }
                    ++n;
                }
            } else {
                double[][] dArray2 = this.getDoubles(false);
                if (dArray2 == null) {
                    if (dArray != null) {
                        return false;
                    }
                } else {
                    if (dArray == null) {
                        return false;
                    }
                    n = 0;
                    while (n < this.DomainDimension) {
                        int n3 = 0;
                        while (n3 < this.Length) {
                            if (dArray2[n][n3] != dArray[n][n3]) {
                                this.addNotEqualsCache((Set)object);
                                return false;
                            }
                            ++n3;
                        }
                        ++n;
                    }
                }
            }
            this.addEqualsCache((Set)object);
            return true;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode();
            this.hashCode ^= this.DomainDimension ^ this.ManifoldDimension ^ this.Length;
            int n = 0;
            while (n < this.ManifoldDimension) {
                this.hashCode ^= this.Lengths[n];
                ++n;
            }
            if (this.Samples != null) {
                n = 0;
                while (n < this.DomainDimension) {
                    int n2 = 0;
                    while (n2 < this.Length) {
                        this.hashCode ^= new Double(this.Samples[n][n2]).hashCode();
                        ++n2;
                    }
                    ++n;
                }
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object clone() {
        try {
            return new Gridded1DDoubleSet(this.Type, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("Gridded1DDoubleSet.clone: " + visADException.toString());
        }
    }

    public Object cloneButType(MathType mathType) throws VisADException {
        return new Gridded1DDoubleSet(mathType, this.Samples, this.Length, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors);
    }

    public Gridded1DDoubleSet(MathType mathType, float[][] fArray, int n) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, null, null, null, true);
    }

    public Gridded1DDoubleSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded1DDoubleSet(MathType mathType, float[][] fArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        this(mathType, Set.floatToDouble(fArray), n, coordinateSystem, unitArray, errorEstimateArray, bl);
    }

    public Gridded1DDoubleSet(MathType mathType, double[][] dArray, int n) throws VisADException {
        this(mathType, dArray, n, null, null, null, true);
    }

    public Gridded1DDoubleSet(MathType mathType, double[][] dArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        this(mathType, dArray, n, coordinateSystem, unitArray, errorEstimateArray, true);
    }

    public Gridded1DDoubleSet(MathType mathType, double[][] dArray, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException {
        block9: {
            super(mathType, null, n, coordinateSystem, unitArray, errorEstimateArray, bl);
            this.Low = new double[1];
            this.Hi = new double[1];
            this.ig = -1;
            if (dArray == null) {
                throw new SetException("Gridded1DDoubleSet: samples are null");
            }
            this.init_doubles(dArray, bl);
            this.LowX = this.Low[0];
            this.HiX = this.Hi[0];
            this.LengthX = this.Lengths[0];
            if (this.Samples == null || this.Lengths[0] <= 1) break block9;
            int n2 = 0;
            while (n2 < this.Length) {
                if (this.Samples[0][n2] != this.Samples[0][n2]) {
                    throw new SetException("Gridded1DDoubleSet: samples values may not be missing");
                }
                ++n2;
            }
            boolean bl2 = this.Ascending = this.Samples[0][this.LengthX - 1] > this.Samples[0][0];
            if (this.Ascending) {
                n2 = 1;
                while (n2 < this.LengthX) {
                    if (this.Samples[0][n2] < this.Samples[0][n2 - 1]) {
                        throw new SetException("Gridded1DDoubleSet: samples do not form a valid grid (" + n2 + ")");
                    }
                    ++n2;
                }
            } else {
                n2 = 1;
                while (n2 < this.LengthX) {
                    if (this.Samples[0][n2] > this.Samples[0][n2 - 1]) {
                        throw new SetException("Gridded1DDoubleSet: samples do not form a valid grid (" + n2 + ")");
                    }
                    ++n2;
                }
            }
        }
    }
}

