/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public class GridVectorType
extends RealVectorType {
    public double[][] transformVectors(RealTupleType realTupleType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, RealTupleType realTupleType2, CoordinateSystem coordinateSystem2, Unit[] unitArray2, CoordinateSystem coordinateSystem3, ErrorEstimate[] errorEstimateArray2, ErrorEstimate[] errorEstimateArray3, double[][] dArray, double[][] dArray2, double[][] dArray3) throws VisADException, RemoteException {
        int n = dArray3.length;
        double[][] dArray4 = new double[n][];
        if (n > 2) {
            dArray4[2] = dArray3[2];
        }
        return dArray4;
    }

    public GridVectorType(RealType[] realTypeArray) throws VisADException {
        this(realTypeArray, null);
    }

    public GridVectorType(RealType[] realTypeArray, CoordinateSystem coordinateSystem) throws VisADException {
        super(realTypeArray, coordinateSystem);
        if (realTypeArray.length != 2 && realTypeArray.length != 3) {
            throw new TypeException("GridVectorType must be 2-D or 3-D: " + realTypeArray.length);
        }
        int n = 0;
        while (n < realTypeArray.length) {
            if (!Unit.canConvert(CommonUnit.meterPerSecond, realTypeArray[n].getDefaultUnit())) {
                throw new TypeException("GridVectorType components must be convertable with meter / second: " + realTypeArray[n].getDefaultUnit());
            }
            ++n;
        }
    }
}

