/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class GridCoordinateSystem
extends CoordinateSystem {
    private GriddedSet set;
    private int dimension;

    public GriddedSet getGriddedSet() {
        return this.set;
    }

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != this.dimension) {
            throw new CoordinateSystemException("GridCoordinateSystem.toReference: tuples wrong dimension");
        }
        double[][] dArray2 = Set.floatToDouble(this.set.gridToValue(Set.doubleToFloat(dArray)));
        Unit[] unitArray = this.set.getSetUnits();
        Unit[] unitArray2 = this.getReference().getDefaultUnits();
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[1];
        int n = 0;
        while (n < this.dimension) {
            dArray2[n] = Unit.transformUnits(unitArray2[n], errorEstimateArray, unitArray[n], null, dArray2[n]);
            ++n;
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != this.dimension) {
            throw new CoordinateSystemException("GridCoordinateSystem.fromReference: tuples wrong dimension");
        }
        double[][] dArray2 = new double[this.dimension][];
        int n = 0;
        while (n < this.dimension) {
            dArray2[n] = dArray[n];
            ++n;
        }
        Unit[] unitArray = this.getReference().getDefaultUnits();
        Unit[] unitArray2 = this.set.getSetUnits();
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[1];
        int n2 = 0;
        while (n2 < this.dimension) {
            dArray2[n2] = Unit.transformUnits(unitArray2[n2], errorEstimateArray, unitArray[n2], null, dArray2[n2]);
            ++n2;
        }
        dArray2 = Set.floatToDouble(this.set.valueToGrid(Set.doubleToFloat(dArray2)));
        return dArray2;
    }

    public float[][] toReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != this.dimension) {
            throw new CoordinateSystemException("GridCoordinateSystem.toReference: tuples wrong dimension");
        }
        float[][] fArray2 = this.set.gridToValue(fArray);
        Unit[] unitArray = this.set.getSetUnits();
        Unit[] unitArray2 = this.getReference().getDefaultUnits();
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[1];
        int n = 0;
        while (n < this.dimension) {
            fArray2[n] = Unit.transformUnits(unitArray2[n], errorEstimateArray, unitArray[n], null, fArray2[n]);
            ++n;
        }
        return fArray2;
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != this.dimension) {
            throw new CoordinateSystemException("GridCoordinateSystem.fromReference: tuples wrong dimension");
        }
        float[][] fArray2 = new float[this.dimension][];
        int n = 0;
        while (n < this.dimension) {
            fArray2[n] = fArray[n];
            ++n;
        }
        Unit[] unitArray = this.getReference().getDefaultUnits();
        Unit[] unitArray2 = this.set.getSetUnits();
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[1];
        int n2 = 0;
        while (n2 < this.dimension) {
            fArray2[n2] = Unit.transformUnits(unitArray2[n2], errorEstimateArray, unitArray[n2], null, fArray2[n2]);
            ++n2;
        }
        fArray2 = this.set.valueToGrid(fArray2);
        return fArray2;
    }

    public boolean equals(Object object) {
        return object instanceof GridCoordinateSystem && this.set.equals(((GridCoordinateSystem)object).set);
    }

    public GridCoordinateSystem(GriddedSet griddedSet) throws VisADException {
        super(((SetType)griddedSet.getType()).getDomain(), null);
        this.set = griddedSet;
        this.dimension = this.set.getDimension();
    }
}

