/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.FieldImpl;
import visad.MathType;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ShadowType;
import visad.SingletonSet;
import visad.TextType;
import visad.TupleType;
import visad.TypeException;
import visad.VisADException;

public class FunctionType
extends MathType {
    public static final FunctionType REAL_1TO1_FUNCTION = new FunctionType(RealType.Generic, RealType.Generic, true);
    private static RealType[] real3 = new RealType[]{RealType.Generic, RealType.Generic, RealType.Generic};
    public static final FunctionType REAL_1TO3_FUNCTION = new FunctionType(RealType.Generic, new RealTupleType(real3, true), true);
    private static RealType[] real4 = new RealType[]{RealType.Generic, RealType.Generic, RealType.Generic, RealType.Generic};
    public static final FunctionType REAL_1TO4_FUNCTION = new FunctionType(RealType.Generic, new RealTupleType(real4, true), true);
    private RealTupleType Domain;
    private MathType Range;
    private RealTupleType FlatRange;
    private boolean Real;
    private boolean Flat;
    private RealType[] realComponents;
    private TextType[] textComponents;
    private int[] textIndices;

    private void makeTextComponents() {
        int n = 0;
        this.textComponents = null;
        this.textIndices = null;
        if (this.Range instanceof TextType) {
            this.textComponents = new TextType[]{(TextType)this.Range};
            this.textIndices = new int[]{0};
            n = 1;
        } else if (this.Range instanceof TupleType) {
            try {
                int n2 = 0;
                while (n2 < ((TupleType)this.Range).getDimension()) {
                    if (((TupleType)this.Range).getComponent(n2) instanceof TextType) {
                        ++n;
                    }
                    ++n2;
                }
                if (n == 0) {
                    return;
                }
                this.textComponents = new TextType[n];
                this.textIndices = new int[n];
                n2 = 0;
                int n3 = 0;
                while (n3 < ((TupleType)this.Range).getDimension()) {
                    if (((TupleType)this.Range).getComponent(n3) instanceof TextType) {
                        this.textComponents[n2] = (TextType)((TupleType)this.Range).getComponent(n3);
                        this.textIndices[n2] = n3;
                    }
                    ++n3;
                }
            }
            catch (VisADException visADException) {
                this.textComponents = null;
                this.textIndices = null;
            }
        }
    }

    public TextType[] getTextComponents() {
        return this.textComponents;
    }

    public int[] getTextIndices() {
        return this.textIndices;
    }

    private static RealType[] getComponents(MathType mathType) {
        if (mathType instanceof RealType) {
            RealType[] realTypeArray = new RealType[]{(RealType)mathType};
            return realTypeArray;
        }
        if (mathType instanceof TupleType) {
            return ((TupleType)mathType).getRealComponents();
        }
        return null;
    }

    private static RealTupleType makeFlat(MathType mathType) throws VisADException {
        if (mathType instanceof RealTupleType) {
            return (RealTupleType)mathType;
        }
        if (mathType instanceof RealType) {
            RealType[] realTypeArray = new RealType[]{(RealType)mathType};
            return new RealTupleType(realTypeArray, null, ((RealType)mathType).getDefaultSet());
        }
        if (mathType instanceof TupleType && ((TupleType)mathType).getFlat()) {
            return new RealTupleType(((TupleType)mathType).getRealComponents());
        }
        throw new TypeException("FunctionType: illegal input to makeFlat");
    }

    private static RealTupleType makeFlatTrusted(MathType mathType) {
        if (mathType instanceof RealTupleType) {
            return (RealTupleType)mathType;
        }
        if (mathType instanceof RealType) {
            RealType[] realTypeArray = new RealType[]{(RealType)mathType};
            return new RealTupleType(realTypeArray, true);
        }
        if (mathType instanceof TupleType && ((TupleType)mathType).getFlat()) {
            return new RealTupleType(((TupleType)mathType).getRealComponents(), true);
        }
        return null;
    }

    public RealTupleType getDomain() {
        return this.Domain;
    }

    public MathType getRange() {
        return this.Range;
    }

    public boolean getFlat() {
        return this.Flat;
    }

    public boolean getReal() {
        return this.Real;
    }

    public RealTupleType getFlatRange() {
        return this.FlatRange;
    }

    public RealType[] getRealComponents() {
        return this.realComponents;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FunctionType)) {
            return false;
        }
        return this.Domain.equals(((FunctionType)object).getDomain()) && this.Range.equals(((FunctionType)object).getRange());
    }

    public int hashCode() {
        return this.Domain.hashCode() ^ this.Range.hashCode();
    }

    public boolean equalsExceptName(MathType mathType) {
        if (!(mathType instanceof FunctionType)) {
            return false;
        }
        return this.Domain.equalsExceptName(((FunctionType)mathType).getDomain()) && this.Range.equalsExceptName(((FunctionType)mathType).getRange());
    }

    public boolean equalsExceptNameButUnits(MathType mathType) throws VisADException {
        if (!(mathType instanceof FunctionType)) {
            return false;
        }
        return this.Domain.equalsExceptNameButUnits(((FunctionType)mathType).getDomain()) && this.Range.equalsExceptNameButUnits(((FunctionType)mathType).getRange());
    }

    public MathType cloneDerivative(RealType realType) throws VisADException {
        return new FunctionType(this.Domain, this.Range.cloneDerivative(realType));
    }

    public MathType binary(MathType mathType, int n, Vector vector) throws VisADException {
        if (mathType == null) {
            throw new TypeException("FunctionType.binary: type may not be null");
        }
        if (this.equalsExceptName(mathType)) {
            return new FunctionType(this.Domain, this.Range.binary(((FunctionType)mathType).getRange(), n, vector));
        }
        if (mathType instanceof RealType || this.getRange().equalsExceptName(mathType)) {
            return new FunctionType(this.Domain, this.Range.binary(mathType, n, vector));
        }
        if (mathType instanceof FunctionType && ((FunctionType)mathType).getRange().equalsExceptName(this)) {
            return new FunctionType(((FunctionType)mathType).getDomain(), ((FunctionType)mathType).getRange().binary(this, DataImpl.invertOp(n), vector));
        }
        throw new TypeException("FunctionType.binary: types don't match");
    }

    public MathType unary(int n, Vector vector) throws VisADException {
        return new FunctionType(this.Domain, this.Range.unary(n, vector));
    }

    public String prettyString(int n) {
        String string = "(" + this.Domain.prettyString(n) + " -> ";
        int n2 = string.length();
        String string2 = this.Range.prettyString(n + n2) + ")";
        return string + string2;
    }

    public Data missingData() throws VisADException, RemoteException {
        int n = this.Domain.getDimension();
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = 0.0;
            ++n2;
        }
        RealTuple realTuple = new RealTuple(this.Domain, dArray);
        return new FieldImpl(this, new SingletonSet(realTuple));
    }

    public ShadowType buildShadowType(DataDisplayLink dataDisplayLink, ShadowType shadowType) throws VisADException, RemoteException {
        return dataDisplayLink.getRenderer().makeShadowFunctionType(this, dataDisplayLink, shadowType);
    }

    public FunctionType(MathType mathType, MathType mathType2) throws VisADException {
        if (!(mathType instanceof RealTupleType) && !(mathType instanceof RealType)) {
            throw new TypeException("FunctionType: domain must be RealTupleType or RealType");
        }
        this.Domain = FunctionType.makeFlat(mathType);
        this.Real = mathType2 instanceof RealType || mathType2 instanceof RealTupleType;
        this.Flat = this.Real || mathType2 instanceof TupleType && ((TupleType)mathType2).getFlat();
        this.Range = mathType2;
        this.FlatRange = this.Flat ? FunctionType.makeFlat(mathType2) : null;
        this.realComponents = FunctionType.getComponents(this.Range);
        this.makeTextComponents();
    }

    FunctionType(MathType mathType, MathType mathType2, boolean bl) {
        super(bl);
        this.Domain = FunctionType.makeFlatTrusted(mathType);
        this.Real = mathType2 instanceof RealType || mathType2 instanceof RealTupleType;
        this.Flat = this.Real || mathType2 instanceof TupleType && ((TupleType)mathType2).getFlat();
        this.Range = mathType2;
        this.FlatRange = this.Flat ? FunctionType.makeFlatTrusted(mathType2) : null;
        this.realComponents = FunctionType.getComponents(this.Range);
        this.makeTextComponents();
    }
}

