/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.Field;
import visad.Function;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.ShadowType;
import visad.SingletonSet;
import visad.Unit;
import visad.VisADException;

public abstract class FunctionImpl
extends DataImpl
implements Function {
    public int getDomainDimension() {
        return ((FunctionType)this.Type).getDomain().getDimension();
    }

    public Unit[] getDomainUnits() {
        return ((FunctionType)this.Type).getDomain().getDefaultUnits();
    }

    public CoordinateSystem getDomainCoordinateSystem() {
        return ((FunctionType)this.Type).getDomain().getCoordinateSystem();
    }

    public Data evaluate(Real real) throws VisADException, RemoteException {
        if (real == null) {
            return ((FunctionType)this.getType()).getRange().missingData();
        }
        CoordinateSystem coordinateSystem = this.getDomainCoordinateSystem();
        RealTuple realTuple = coordinateSystem == null ? new RealTuple(new Real[]{real}) : new RealTuple(new RealTupleType((RealType)real.getType(), coordinateSystem, null), new Real[]{real}, null);
        return this.evaluate(realTuple, 101, 202);
    }

    public Data evaluate(Real real, int n, int n2) throws VisADException, RemoteException {
        if (real == null) {
            return ((FunctionType)this.getType()).getRange().missingData();
        }
        CoordinateSystem coordinateSystem = this.getDomainCoordinateSystem();
        RealTuple realTuple = coordinateSystem == null ? new RealTuple(new Real[]{real}) : new RealTuple(new RealTupleType((RealType)real.getType(), coordinateSystem, null), new Real[]{real}, null);
        return this.evaluate(realTuple, n, n2);
    }

    public Data evaluate(RealTuple realTuple) throws VisADException, RemoteException {
        if (realTuple == null) {
            return ((FunctionType)this.getType()).getRange().missingData();
        }
        return this.evaluate(realTuple, 101, 202);
    }

    public Data evaluate(RealTuple realTuple, int n, int n2) throws VisADException, RemoteException {
        if (realTuple == null) {
            return ((FunctionType)this.getType()).getRange().missingData();
        }
        Field field = this.resample(new SingletonSet(realTuple, realTuple.getCoordinateSystem(), realTuple.getTupleUnits(), realTuple.getErrors()), n, n2);
        return field.getSample(0);
    }

    public Field resample(Set set) throws VisADException, RemoteException {
        return this.resample(set, 101, 202);
    }

    public abstract Field resample(Set var1, int var2, int var3) throws VisADException, RemoteException;

    public abstract Data derivative(RealTuple var1, RealType[] var2, MathType[] var3, int var4) throws VisADException, RemoteException;

    public abstract Data derivative(int var1) throws VisADException, RemoteException;

    public abstract Data derivative(MathType[] var1, int var2) throws VisADException, RemoteException;

    public abstract Function derivative(RealType var1, int var2) throws VisADException, RemoteException;

    public abstract Function derivative(RealType var1, MathType var2, int var3) throws VisADException, RemoteException;

    public Data __getitem__(Real real) throws VisADException, RemoteException {
        return this.evaluate(real);
    }

    public Data __getitem__(RealTuple realTuple) throws VisADException, RemoteException {
        return this.evaluate(realTuple);
    }

    public abstract boolean isMissing() throws VisADException, RemoteException;

    public abstract DataShadow computeRanges(ShadowType var1, DataShadow var2) throws VisADException, RemoteException;

    public FunctionImpl(FunctionType functionType) {
        super(functionType);
    }
}

