/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Control;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public abstract class FlowControl
extends Control {
    public static final int NH_ORIENTATION = 0;
    public static final int SH_ORIENTATION = 1;
    float flowScale = 0.02f;
    int barbOrientation = 1;
    boolean HorizontalVectorSlice = false;
    boolean VerticalVectorSlice = false;
    boolean HorizontalStreamSlice = false;
    boolean VerticalStreamSlice = false;
    boolean[] TrajectorySet = null;
    double HorizontalVectorSliceHeight = 0.0;
    double HorizontalStreamSliceHeight = 0.0;
    boolean streamlinesEnabled = false;
    float streamlineDensity = 1.0f;
    float arrowScale = 1.0f;
    float stepFactor = 2.0f;

    public void setFlowScale(float f) throws VisADException, RemoteException {
        this.flowScale = f;
        this.changeControl(true);
    }

    public float getFlowScale() {
        return this.flowScale;
    }

    public void setBarbOrientation(int n) throws VisADException, RemoteException {
        if (n != 1 && n != 0) {
            throw new VisADException("Invalid orientation value: " + n);
        }
        this.barbOrientation = n;
        this.changeControl(true);
    }

    public int getBarbOrientation() {
        return this.barbOrientation;
    }

    public void enableStreamlines(boolean bl) throws VisADException, RemoteException {
        this.streamlinesEnabled = bl;
        this.changeControl(true);
    }

    public void setStreamlineDensity(float f) throws VisADException, RemoteException {
        this.streamlineDensity = f;
        this.changeControl(true);
    }

    public void setArrowScale(float f) throws VisADException, RemoteException {
        this.arrowScale = f;
        this.changeControl(true);
    }

    public void setStepFactor(float f) throws VisADException, RemoteException {
        this.stepFactor = f;
        this.changeControl(true);
    }

    public boolean streamlinesEnabled() {
        return this.streamlinesEnabled;
    }

    public float getStreamlineDensity() {
        return this.streamlineDensity;
    }

    public float getArrowScale() {
        return this.arrowScale;
    }

    public float getStepFactor() {
        return this.stepFactor;
    }

    public String getSaveString() {
        return "" + this.flowScale + " " + this.barbOrientation;
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        if (string == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 2) {
            throw new VisADException("Invalid save string");
        }
        float f = Convert.getFloat(stringTokenizer.nextToken());
        int n = Convert.getInt(stringTokenizer.nextToken());
        this.flowScale = f;
        this.barbOrientation = n;
        this.changeControl(true);
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof FlowControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        FlowControl flowControl = (FlowControl)control;
        boolean bl = false;
        if (!Util.isApproximatelyEqual(this.flowScale, flowControl.flowScale)) {
            bl = true;
            this.flowScale = flowControl.flowScale;
        }
        if (this.barbOrientation != flowControl.barbOrientation) {
            bl = true;
            this.barbOrientation = flowControl.barbOrientation;
        }
        if (this.HorizontalVectorSlice != flowControl.HorizontalVectorSlice) {
            bl = true;
            this.HorizontalVectorSlice = flowControl.HorizontalVectorSlice;
        }
        if (this.VerticalVectorSlice != flowControl.VerticalVectorSlice) {
            bl = true;
            this.VerticalVectorSlice = flowControl.VerticalVectorSlice;
        }
        if (this.HorizontalStreamSlice != flowControl.HorizontalStreamSlice) {
            bl = true;
            this.HorizontalStreamSlice = flowControl.HorizontalStreamSlice;
        }
        if (this.VerticalStreamSlice != flowControl.VerticalStreamSlice) {
            bl = true;
            this.VerticalStreamSlice = flowControl.VerticalStreamSlice;
        }
        if (this.TrajectorySet == null) {
            if (flowControl.TrajectorySet != null) {
                bl = true;
                this.TrajectorySet = flowControl.TrajectorySet;
            }
        } else if (flowControl.TrajectorySet == null) {
            bl = true;
            this.TrajectorySet = null;
        } else if (this.TrajectorySet.length != flowControl.TrajectorySet.length) {
            bl = true;
            this.TrajectorySet = flowControl.TrajectorySet;
        } else {
            int n = 0;
            while (n < this.TrajectorySet.length) {
                if (this.TrajectorySet[n] != flowControl.TrajectorySet[n]) {
                    bl = true;
                    this.TrajectorySet[n] = flowControl.TrajectorySet[n];
                }
                ++n;
            }
        }
        if (!Util.isApproximatelyEqual(this.HorizontalVectorSliceHeight, flowControl.HorizontalVectorSliceHeight)) {
            bl = true;
            this.HorizontalVectorSliceHeight = flowControl.HorizontalVectorSliceHeight;
        }
        if (!Util.isApproximatelyEqual(this.HorizontalStreamSliceHeight, flowControl.HorizontalStreamSliceHeight)) {
            bl = true;
            this.HorizontalStreamSliceHeight = flowControl.HorizontalStreamSliceHeight;
        }
        if (this.streamlinesEnabled != flowControl.streamlinesEnabled) {
            bl = true;
            this.streamlinesEnabled = flowControl.streamlinesEnabled;
        }
        if (!Util.isApproximatelyEqual(this.streamlineDensity, flowControl.streamlineDensity)) {
            bl = true;
            this.streamlineDensity = flowControl.streamlineDensity;
        }
        if (!Util.isApproximatelyEqual(this.arrowScale, flowControl.arrowScale)) {
            bl = true;
            this.arrowScale = flowControl.arrowScale;
        }
        if (!Util.isApproximatelyEqual(this.stepFactor, flowControl.stepFactor)) {
            bl = true;
            this.stepFactor = flowControl.stepFactor;
        }
        if (bl) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        FlowControl flowControl = (FlowControl)object;
        if (!Util.isApproximatelyEqual(this.flowScale, flowControl.flowScale)) {
            return false;
        }
        if (this.barbOrientation != flowControl.barbOrientation) {
            return false;
        }
        if (this.HorizontalVectorSlice != flowControl.HorizontalVectorSlice) {
            return false;
        }
        if (this.VerticalVectorSlice != flowControl.VerticalVectorSlice) {
            return false;
        }
        if (this.HorizontalStreamSlice != flowControl.HorizontalStreamSlice) {
            return false;
        }
        if (this.VerticalStreamSlice != flowControl.VerticalStreamSlice) {
            return false;
        }
        if (this.TrajectorySet == null) {
            if (flowControl.TrajectorySet != null) {
                return false;
            }
        } else {
            if (flowControl.TrajectorySet == null) {
                return false;
            }
            if (this.TrajectorySet.length != flowControl.TrajectorySet.length) {
                return false;
            }
            int n = 0;
            while (n < this.TrajectorySet.length) {
                if (this.TrajectorySet[n] != flowControl.TrajectorySet[n]) {
                    return false;
                }
                ++n;
            }
        }
        if (!Util.isApproximatelyEqual(this.HorizontalVectorSliceHeight, flowControl.HorizontalVectorSliceHeight)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.HorizontalStreamSliceHeight, flowControl.HorizontalStreamSliceHeight)) {
            return false;
        }
        if (this.streamlinesEnabled != flowControl.streamlinesEnabled) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.streamlineDensity, flowControl.streamlineDensity)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.arrowScale, flowControl.arrowScale)) {
            return false;
        }
        return Util.isApproximatelyEqual(this.stepFactor, flowControl.stepFactor);
    }

    public Object clone() {
        FlowControl flowControl = (FlowControl)super.clone();
        if (this.TrajectorySet != null) {
            flowControl.TrajectorySet = (boolean[])this.TrajectorySet.clone();
        }
        return flowControl;
    }

    public FlowControl(DisplayImpl displayImpl) {
        super(displayImpl);
    }
}

