/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Random;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatFieldIface;
import visad.FloatSet;
import visad.Function;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Integer2DSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearSet;
import visad.MathType;
import visad.PromiscuousUnit;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowTupleType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class FlatField
extends FieldImpl
implements FlatFieldIface {
    private static final int MISSING1 = -128;
    private static final int MISSING2 = Short.MIN_VALUE;
    private static final int MISSING4 = Integer.MIN_VALUE;
    private static final int DOUBLE = 1;
    private static final int FLOAT = 2;
    private static final int LONG = 3;
    private static final int INT = 4;
    private static final int SHORT = 5;
    private static final int BYTE = 6;
    private int TupleDimension;
    private Set[] RangeSet;
    private int[] RangeMode;
    private CoordinateSystem RangeCoordinateSystem;
    private CoordinateSystem[] RangeCoordinateSystems;
    private boolean MissingFlag;
    private Unit[] RangeUnits;
    private ErrorEstimate[] RangeErrors;
    private double[][] DoubleRange;
    private float[][] FloatRange;
    private long[][] LongRange;
    private int[][] IntRange;
    private short[][] ShortRange;
    private byte[][] ByteRange;

    public CoordinateSystem[] getRangeCoordinateSystem() throws TypeException {
        MathType mathType = ((FunctionType)this.Type).getRange();
        if (!((FunctionType)this.Type).getReal()) {
            throw new TypeException("FlatField.getRangeCoordinateSystem: Range is not Real, need DefaultCoordinateSystem index");
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[]{this.RangeCoordinateSystem};
        return coordinateSystemArray;
    }

    public Set[] getRangeSets() {
        Set[] setArray = new Set[this.RangeSet.length];
        System.arraycopy(this.RangeSet, 0, setArray, 0, setArray.length);
        return setArray;
    }

    public CoordinateSystem[] getRangeCoordinateSystem(int n) throws TypeException {
        if (((FunctionType)this.Type).getReal()) {
            throw new TypeException("FlatField.getRangeCoordinateSystem: Range is Real, cannot specify CoordinateSystem index");
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[]{this.RangeCoordinateSystems[n]};
        return coordinateSystemArray;
    }

    public Unit[][] getRangeUnits() {
        Unit[][] unitArray = new Unit[this.RangeUnits.length][1];
        int n = 0;
        while (n < this.RangeUnits.length) {
            unitArray[n][0] = this.RangeUnits[n];
            ++n;
        }
        return unitArray;
    }

    public ErrorEstimate[] getRangeErrors() {
        ErrorEstimate[] errorEstimateArray = this.RangeErrors;
        synchronized (errorEstimateArray) {
            ErrorEstimate[] errorEstimateArray2 = ErrorEstimate.copyErrorsArray(this.RangeErrors);
            Object var2_3 = null;
            return errorEstimateArray2;
        }
    }

    public void setRangeErrors(ErrorEstimate[] errorEstimateArray) throws VisADException {
        ErrorEstimate[] errorEstimateArray2 = this.RangeErrors;
        synchronized (errorEstimateArray2) {
            if (errorEstimateArray == null) {
                int n = 0;
                while (n < this.TupleDimension) {
                    this.RangeErrors[n] = null;
                    ++n;
                }
            } else {
                if (errorEstimateArray.length != this.TupleDimension) {
                    throw new FieldException("FlatField.setRangeErrors: errors dimension does not match");
                }
                int n = 0;
                while (n < this.TupleDimension) {
                    this.RangeErrors[n] = errorEstimateArray[n];
                    ++n;
                }
            }
        }
    }

    public void setSamples(Data[] dataArray, boolean bl) throws VisADException, RemoteException {
        if (dataArray.length != this.Length) {
            throw new FieldException("setSamples: bad Data[] length");
        }
        int n = 0;
        while (n < this.Length) {
            this.setSample(n, dataArray[n]);
            ++n;
        }
    }

    public void setSamples(double[][] dArray) throws VisADException, RemoteException {
        this.setSamples(dArray, null, true);
    }

    public void setSamples(float[][] fArray) throws VisADException, RemoteException {
        this.setSamples(fArray, (ErrorEstimate[])null, true);
    }

    public void setSamples(double[][] dArray, boolean bl) throws VisADException, RemoteException {
        this.setSamples(dArray, null, bl);
    }

    public void setSamples(float[][] fArray, boolean bl) throws VisADException, RemoteException {
        this.setSamples(fArray, (ErrorEstimate[])null, bl);
    }

    public void setSamples(double[][] dArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException, RemoteException {
        if (dArray.length != this.TupleDimension || errorEstimateArray != null && errorEstimateArray.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        int n = 0;
        while (n < this.TupleDimension) {
            if (dArray[n].length != this.Length) {
                throw new FieldException("setSamples: bad array length");
            }
            ++n;
        }
        this.packValues(dArray, bl);
        this.setRangeErrors(errorEstimateArray);
        this.notifyReferences();
    }

    public void setSamples(int n, double[][] dArray) throws VisADException, RemoteException {
        if (dArray.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        int n2 = 0;
        while (n2 < this.TupleDimension) {
            if (dArray[n2].length + n > this.Length) {
                throw new FieldException("setSamples: bad array length");
            }
            ++n2;
        }
        n2 = 0;
        int n3 = dArray[0].length;
        double[][] dArray2 = this.DoubleRange;
        synchronized (dArray2) {
            int n4 = 0;
            while (n4 < this.TupleDimension) {
                double[] dArray3 = dArray[n4];
                double[][] dArray4 = new double[][]{dArray3};
                switch (this.RangeMode[n4]) {
                    case 1: {
                        if (this.DoubleRange[n4] == null) {
                            this.DoubleRange[n4] = new double[this.Length];
                        }
                        double[] dArray5 = this.DoubleRange[n4];
                        System.arraycopy(dArray3, 0, dArray5, n, n3);
                        break;
                    }
                    case 2: {
                        if (this.FloatRange[n4] == null) {
                            this.FloatRange[n4] = new float[this.Length];
                            int n5 = 0;
                            while (n5 < this.Length) {
                                this.FloatRange[n4][n5] = Float.NaN;
                                ++n5;
                            }
                        }
                        float[] fArray = this.FloatRange[n4];
                        int n6 = 0;
                        while (n6 < n3) {
                            fArray[n + n6] = (float)dArray3[n6];
                            ++n6;
                        }
                        break;
                    }
                    case 6: {
                        int[] nArray = this.RangeSet[n4].valueToIndex(Set.doubleToFloat(dArray4));
                        if (this.ByteRange[n4] == null) {
                            this.ByteRange[n4] = new byte[this.Length];
                            int n7 = 0;
                            while (n7 < this.Length) {
                                this.ByteRange[n4][n7] = -128;
                                ++n7;
                            }
                        }
                        byte[] byArray = this.ByteRange[n4];
                        int n8 = 0;
                        while (n8 < n3) {
                            byArray[n + n8] = (byte)(nArray[n8] + -128 + 1);
                            ++n8;
                        }
                        break;
                    }
                    case 5: {
                        int[] nArray = this.RangeSet[n4].valueToIndex(Set.doubleToFloat(dArray4));
                        if (this.ShortRange[n4] == null) {
                            this.ShortRange[n4] = new short[this.Length];
                            int n9 = 0;
                            while (n9 < this.Length) {
                                this.ShortRange[n4][n9] = Short.MIN_VALUE;
                                ++n9;
                            }
                        }
                        short[] sArray = this.ShortRange[n4];
                        int n10 = 0;
                        while (n10 < n3) {
                            sArray[n + n10] = (short)(nArray[n10] + Short.MIN_VALUE + 1);
                            ++n10;
                        }
                        break;
                    }
                    case 4: {
                        int[] nArray = this.RangeSet[n4].valueToIndex(Set.doubleToFloat(dArray4));
                        if (this.IntRange[n4] == null) {
                            this.IntRange[n4] = new int[this.Length];
                            int n11 = 0;
                            while (n11 < this.Length) {
                                this.IntRange[n4][n11] = Integer.MIN_VALUE;
                                ++n11;
                            }
                        }
                        int[] nArray2 = this.IntRange[n4];
                        int n12 = 0;
                        while (n12 < n3) {
                            nArray2[n + n12] = nArray[n12] + Integer.MIN_VALUE + 1;
                            ++n12;
                        }
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
                ++n4;
            }
            this.clearMissing();
        }
        this.setRangeErrors(null);
        this.notifyReferences();
    }

    public void setSamples(int[] nArray, double[][] dArray) throws VisADException, RemoteException {
        int n = nArray.length;
        if (dArray.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        if (n > this.Length) {
            throw new FieldException("setSamples: indices array too long");
        }
        int n2 = 0;
        while (n2 < this.TupleDimension) {
            if (dArray[n2].length != n) {
                throw new FieldException("setSamples: bad data array length");
            }
            ++n2;
        }
        n2 = 0;
        double[][] dArray2 = this.DoubleRange;
        synchronized (dArray2) {
            int n3 = 0;
            while (n3 < this.TupleDimension) {
                double[] dArray3 = dArray[n3];
                double[][] dArray4 = new double[][]{dArray3};
                switch (this.RangeMode[n3]) {
                    case 1: {
                        if (this.DoubleRange[n3] == null) {
                            this.DoubleRange[n3] = new double[this.Length];
                        }
                        double[] dArray5 = this.DoubleRange[n3];
                        int n4 = 0;
                        while (n4 < n) {
                            dArray5[nArray[n4]] = dArray3[n4];
                            ++n4;
                        }
                        break;
                    }
                    case 2: {
                        if (this.FloatRange[n3] == null) {
                            this.FloatRange[n3] = new float[this.Length];
                            int n5 = 0;
                            while (n5 < this.Length) {
                                this.FloatRange[n3][n5] = Float.NaN;
                                ++n5;
                            }
                        }
                        float[] fArray = this.FloatRange[n3];
                        int n6 = 0;
                        while (n6 < n) {
                            fArray[nArray[n6]] = (float)dArray3[n6];
                            ++n6;
                        }
                        break;
                    }
                    case 6: {
                        int[] nArray2 = this.RangeSet[n3].valueToIndex(Set.doubleToFloat(dArray4));
                        if (this.ByteRange[n3] == null) {
                            this.ByteRange[n3] = new byte[this.Length];
                            int n7 = 0;
                            while (n7 < this.Length) {
                                this.ByteRange[n3][n7] = -128;
                                ++n7;
                            }
                        }
                        byte[] byArray = this.ByteRange[n3];
                        int n8 = 0;
                        while (n8 < n) {
                            byArray[nArray[n8]] = (byte)(nArray2[n8] + -128 + 1);
                            ++n8;
                        }
                        break;
                    }
                    case 5: {
                        int[] nArray2 = this.RangeSet[n3].valueToIndex(Set.doubleToFloat(dArray4));
                        if (this.ShortRange[n3] == null) {
                            this.ShortRange[n3] = new short[this.Length];
                            int n9 = 0;
                            while (n9 < this.Length) {
                                this.ShortRange[n3][n9] = Short.MIN_VALUE;
                                ++n9;
                            }
                        }
                        short[] sArray = this.ShortRange[n3];
                        int n10 = 0;
                        while (n10 < n) {
                            sArray[nArray[n10]] = (short)(nArray2[n10] + Short.MIN_VALUE + 1);
                            ++n10;
                        }
                        break;
                    }
                    case 4: {
                        int[] nArray2 = this.RangeSet[n3].valueToIndex(Set.doubleToFloat(dArray4));
                        if (this.IntRange[n3] == null) {
                            this.IntRange[n3] = new int[this.Length];
                            int n11 = 0;
                            while (n11 < this.Length) {
                                this.IntRange[n3][n11] = Integer.MIN_VALUE;
                                ++n11;
                            }
                        }
                        int[] nArray3 = this.IntRange[n3];
                        int n12 = 0;
                        while (n12 < n) {
                            nArray3[nArray[n12]] = nArray2[n12] + Integer.MIN_VALUE + 1;
                            ++n12;
                        }
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
                ++n3;
            }
            this.clearMissing();
        }
        this.setRangeErrors(null);
        this.notifyReferences();
    }

    public void setSamples(float[][] fArray, ErrorEstimate[] errorEstimateArray, boolean bl) throws VisADException, RemoteException {
        if (fArray.length != this.TupleDimension || errorEstimateArray != null && errorEstimateArray.length != this.TupleDimension) {
            throw new FieldException("FlatField.setSamples: bad tuple length");
        }
        int n = 0;
        while (n < this.TupleDimension) {
            if (fArray[n].length != this.Length) {
                throw new FieldException("setSamples: bad array length");
            }
            ++n;
        }
        this.packValues(fArray, bl);
        this.setRangeErrors(errorEstimateArray);
        this.notifyReferences();
    }

    private void packValues(double[][] dArray, boolean bl) throws VisADException {
        double[][] dArray2 = this.DoubleRange;
        synchronized (dArray2) {
            this.nullRanges();
            int n = 0;
            while (n < this.TupleDimension) {
                double[] dArray3 = dArray[n];
                double[][] dArray4 = new double[][]{dArray3};
                switch (this.RangeMode[n]) {
                    case 1: {
                        Object[] objectArray;
                        if (bl) {
                            this.DoubleRange[n] = new double[this.Length];
                            objectArray = this.DoubleRange[n];
                            System.arraycopy(dArray3, 0, objectArray, 0, this.Length);
                            break;
                        }
                        this.DoubleRange[n] = dArray3;
                        break;
                    }
                    case 2: {
                        this.FloatRange[n] = new float[this.Length];
                        Object[] objectArray = this.FloatRange[n];
                        int n2 = 0;
                        while (n2 < this.Length) {
                            objectArray[n2] = (float)dArray3[n2];
                            ++n2;
                        }
                        break;
                    }
                    case 6: {
                        int[] nArray = this.RangeSet[n].valueToIndex(Set.doubleToFloat(dArray4));
                        this.ByteRange[n] = new byte[this.Length];
                        byte[] byArray = this.ByteRange[n];
                        int n3 = 0;
                        while (n3 < this.Length) {
                            byArray[n3] = (byte)(nArray[n3] + -128 + 1);
                            ++n3;
                        }
                        break;
                    }
                    case 5: {
                        int[] nArray = this.RangeSet[n].valueToIndex(Set.doubleToFloat(dArray4));
                        this.ShortRange[n] = new short[this.Length];
                        short[] sArray = this.ShortRange[n];
                        int n4 = 0;
                        while (n4 < this.Length) {
                            sArray[n4] = (short)(nArray[n4] + Short.MIN_VALUE + 1);
                            ++n4;
                        }
                        break;
                    }
                    case 4: {
                        int[] nArray = this.RangeSet[n].valueToIndex(Set.doubleToFloat(dArray4));
                        this.IntRange[n] = new int[this.Length];
                        int[] nArray2 = this.IntRange[n];
                        int n5 = 0;
                        while (n5 < this.Length) {
                            nArray2[n5] = nArray[n5] + Integer.MIN_VALUE + 1;
                            ++n5;
                        }
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
                ++n;
            }
            this.clearMissing();
        }
    }

    private void packValues(float[][] fArray, boolean bl) throws VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            this.nullRanges();
            int n = 0;
            while (n < this.TupleDimension) {
                float[] fArray2 = fArray[n];
                float[][] fArray3 = new float[][]{fArray2};
                switch (this.RangeMode[n]) {
                    case 1: {
                        this.DoubleRange[n] = new double[this.Length];
                        double[] dArray2 = this.DoubleRange[n];
                        int n2 = 0;
                        while (n2 < this.Length) {
                            dArray2[n2] = fArray2[n2];
                            ++n2;
                        }
                        break;
                    }
                    case 2: {
                        if (bl) {
                            this.FloatRange[n] = new float[this.Length];
                            float[] fArray4 = this.FloatRange[n];
                            System.arraycopy(fArray2, 0, fArray4, 0, this.Length);
                            break;
                        }
                        this.FloatRange[n] = fArray2;
                        break;
                    }
                    case 6: {
                        int[] nArray = this.RangeSet[n].valueToIndex(fArray3);
                        this.ByteRange[n] = new byte[this.Length];
                        byte[] byArray = this.ByteRange[n];
                        int n3 = 0;
                        while (n3 < this.Length) {
                            byArray[n3] = (byte)(nArray[n3] + -128 + 1);
                            ++n3;
                        }
                        break;
                    }
                    case 5: {
                        int[] nArray = this.RangeSet[n].valueToIndex(fArray3);
                        this.ShortRange[n] = new short[this.Length];
                        short[] sArray = this.ShortRange[n];
                        int n4 = 0;
                        while (n4 < this.Length) {
                            sArray[n4] = (short)(nArray[n4] + Short.MIN_VALUE + 1);
                            ++n4;
                        }
                        break;
                    }
                    case 4: {
                        int[] nArray = this.RangeSet[n].valueToIndex(fArray3);
                        this.IntRange[n] = new int[this.Length];
                        int[] nArray2 = this.IntRange[n];
                        int n5 = 0;
                        while (n5 < this.Length) {
                            nArray2[n5] = nArray[n5] + Integer.MIN_VALUE + 1;
                            ++n5;
                        }
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.packValues: bad RangeMode");
                    }
                }
                ++n;
            }
            this.clearMissing();
        }
    }

    public byte[][] grabBytes() {
        return this.ByteRange;
    }

    public double[][] unpackValues() throws VisADException {
        return this.unpackValues(true);
    }

    private double[][] unpackValues(boolean bl) throws VisADException {
        double[][] dArray;
        double[][] dArray2 = this.DoubleRange;
        synchronized (dArray2) {
            if (this.isMissing()) {
                double[][] dArray3 = new double[this.TupleDimension][this.Length];
                int n = 0;
                while (n < this.TupleDimension) {
                    int n2 = 0;
                    while (n2 < this.Length) {
                        dArray3[n][n2] = Double.NaN;
                        ++n2;
                    }
                    ++n;
                }
                double[][] dArray4 = dArray3;
                Object var4_10 = null;
                return dArray4;
            }
            dArray = new double[this.TupleDimension][];
            int n = 0;
            while (n < this.TupleDimension) {
                switch (this.RangeMode[n]) {
                    case 1: {
                        Object[] objectArray;
                        double[] dArray5;
                        if (bl) {
                            dArray[n] = new double[this.Length];
                            dArray5 = dArray[n];
                            objectArray = this.DoubleRange[n];
                            System.arraycopy(objectArray, 0, dArray5, 0, this.Length);
                            break;
                        }
                        dArray[n] = this.DoubleRange[n];
                        break;
                    }
                    case 2: {
                        dArray[n] = new double[this.Length];
                        double[] dArray5 = dArray[n];
                        Object[] objectArray = this.FloatRange[n];
                        int n3 = 0;
                        while (n3 < this.Length) {
                            dArray5[n3] = objectArray[n3];
                            ++n3;
                        }
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[this.Length];
                        byte[] byArray = this.ByteRange[n];
                        int n4 = 0;
                        while (n4 < this.Length) {
                            nArray[n4] = byArray[n4] - -128 - 1;
                            ++n4;
                        }
                        double[][] dArray6 = Set.floatToDouble(this.RangeSet[n].indexToValue(nArray));
                        dArray[n] = dArray6[0];
                        break;
                    }
                    case 5: {
                        int[] nArray = new int[this.Length];
                        short[] sArray = this.ShortRange[n];
                        int n5 = 0;
                        while (n5 < this.Length) {
                            nArray[n5] = sArray[n5] - Short.MIN_VALUE - 1;
                            ++n5;
                        }
                        double[][] dArray6 = Set.floatToDouble(this.RangeSet[n].indexToValue(nArray));
                        dArray[n] = dArray6[0];
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[this.Length];
                        int[] nArray2 = this.IntRange[n];
                        int n6 = 0;
                        while (n6 < this.Length) {
                            nArray[n6] = nArray2[n6] - Integer.MIN_VALUE - 1;
                            ++n6;
                        }
                        double[][] dArray6 = Set.floatToDouble(this.RangeSet[n].indexToValue(nArray));
                        dArray[n] = dArray6[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
                ++n;
            }
        }
        return dArray;
    }

    private float[][] unpackFloats(boolean bl) throws VisADException {
        float[][] fArray;
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            if (this.isMissing()) {
                float[][] fArray2 = new float[this.TupleDimension][this.Length];
                int n = 0;
                while (n < this.TupleDimension) {
                    int n2 = 0;
                    while (n2 < this.Length) {
                        fArray2[n][n2] = Float.NaN;
                        ++n2;
                    }
                    ++n;
                }
                float[][] fArray3 = fArray2;
                Object var4_10 = null;
                return fArray3;
            }
            fArray = new float[this.TupleDimension][];
            int n = 0;
            while (n < this.TupleDimension) {
                switch (this.RangeMode[n]) {
                    case 1: {
                        fArray[n] = new float[this.Length];
                        float[] fArray4 = fArray[n];
                        double[] dArray2 = this.DoubleRange[n];
                        int n3 = 0;
                        while (n3 < this.Length) {
                            fArray4[n3] = (float)dArray2[n3];
                            ++n3;
                        }
                        break;
                    }
                    case 2: {
                        float[] fArray4;
                        if (bl) {
                            fArray[n] = new float[this.Length];
                            fArray4 = fArray[n];
                            float[] fArray5 = this.FloatRange[n];
                            System.arraycopy(fArray5, 0, fArray4, 0, this.Length);
                            break;
                        }
                        fArray[n] = this.FloatRange[n];
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[this.Length];
                        byte[] byArray = this.ByteRange[n];
                        int n4 = 0;
                        while (n4 < this.Length) {
                            nArray[n4] = byArray[n4] - -128 - 1;
                            ++n4;
                        }
                        float[][] fArray6 = this.RangeSet[n].indexToValue(nArray);
                        fArray[n] = fArray6[0];
                        break;
                    }
                    case 5: {
                        int[] nArray = new int[this.Length];
                        short[] sArray = this.ShortRange[n];
                        int n5 = 0;
                        while (n5 < this.Length) {
                            nArray[n5] = sArray[n5] - Short.MIN_VALUE - 1;
                            ++n5;
                        }
                        float[][] fArray6 = this.RangeSet[n].indexToValue(nArray);
                        fArray[n] = fArray6[0];
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[this.Length];
                        int[] nArray2 = this.IntRange[n];
                        int n6 = 0;
                        while (n6 < this.Length) {
                            nArray[n6] = nArray2[n6] - Integer.MIN_VALUE - 1;
                            ++n6;
                        }
                        float[][] fArray6 = this.RangeSet[n].indexToValue(nArray);
                        fArray[n] = fArray6[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackFloats: bad RangeMode");
                    }
                }
                ++n;
            }
        }
        return fArray;
    }

    private double[] unpackOneRangeComp(int n) throws VisADException {
        double[] dArray = null;
        double[][] dArray2 = this.DoubleRange;
        synchronized (dArray2) {
            if (this.isMissing()) {
                dArray = new double[this.Length];
                int n2 = 0;
                while (n2 < this.Length) {
                    dArray[n2] = Double.NaN;
                    ++n2;
                }
                double[] dArray3 = dArray;
                Object var4_7 = null;
                return dArray3;
            }
            int n3 = 0;
            while (n3 < this.TupleDimension) {
                switch (this.RangeMode[n]) {
                    case 1: {
                        dArray = new double[this.Length];
                        double[] dArray4 = this.DoubleRange[n];
                        System.arraycopy(dArray4, 0, dArray, 0, this.Length);
                        break;
                    }
                    case 2: {
                        dArray = new double[this.Length];
                        float[] fArray = this.FloatRange[n];
                        int n4 = 0;
                        while (n4 < this.Length) {
                            dArray[n4] = fArray[n4];
                            ++n4;
                        }
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[this.Length];
                        byte[] byArray = this.ByteRange[n];
                        int n5 = 0;
                        while (n5 < this.Length) {
                            nArray[n5] = byArray[n5] - -128 - 1;
                            ++n5;
                        }
                        double[][] dArray5 = Set.floatToDouble(this.RangeSet[n].indexToValue(nArray));
                        dArray = dArray5[0];
                        break;
                    }
                    case 5: {
                        int[] nArray = new int[this.Length];
                        short[] sArray = this.ShortRange[n];
                        int n6 = 0;
                        while (n6 < this.Length) {
                            nArray[n6] = sArray[n6] - Short.MIN_VALUE - 1;
                            ++n6;
                        }
                        double[][] dArray5 = Set.floatToDouble(this.RangeSet[n].indexToValue(nArray));
                        dArray = dArray5[0];
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[this.Length];
                        int[] nArray2 = this.IntRange[n];
                        int n7 = 0;
                        while (n7 < this.Length) {
                            nArray[n7] = nArray2[n7] - Integer.MIN_VALUE - 1;
                            ++n7;
                        }
                        double[][] dArray5 = Set.floatToDouble(this.RangeSet[n].indexToValue(nArray));
                        dArray = dArray5[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
                ++n3;
            }
        }
        return dArray;
    }

    private double[] unpackValues(int n) throws VisADException {
        double[] dArray;
        double[][] dArray2 = this.DoubleRange;
        synchronized (dArray2) {
            if (this.isMissing()) {
                double[] dArray3 = new double[this.TupleDimension];
                int n2 = 0;
                while (n2 < this.TupleDimension) {
                    dArray3[n2] = Double.NaN;
                    ++n2;
                }
                double[] dArray4 = dArray3;
                Object var4_8 = null;
                return dArray4;
            }
            dArray = new double[this.TupleDimension];
            int n3 = 0;
            while (n3 < this.TupleDimension) {
                switch (this.RangeMode[n3]) {
                    case 1: {
                        dArray[n3] = this.DoubleRange[n3][n];
                        break;
                    }
                    case 2: {
                        dArray[n3] = this.FloatRange[n3][n];
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[1];
                        byte[] byArray = this.ByteRange[n3];
                        nArray[0] = byArray[n] - -128 - 1;
                        double[][] dArray5 = Set.floatToDouble(this.RangeSet[n3].indexToValue(nArray));
                        dArray[n3] = dArray5[0][0];
                        break;
                    }
                    case 5: {
                        int[] nArray = new int[1];
                        short[] sArray = this.ShortRange[n3];
                        nArray[0] = sArray[n] - Short.MIN_VALUE - 1;
                        double[][] dArray5 = Set.floatToDouble(this.RangeSet[n3].indexToValue(nArray));
                        dArray[n3] = dArray5[0][0];
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[1];
                        int[] nArray2 = this.IntRange[n3];
                        nArray[0] = nArray2[n] - Integer.MIN_VALUE - 1;
                        double[][] dArray5 = Set.floatToDouble(this.RangeSet[n3].indexToValue(nArray));
                        dArray[n3] = dArray5[0][0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.unpackValues: bad RangeMode");
                    }
                }
                ++n3;
            }
        }
        return dArray;
    }

    public float[][] getFloats() throws VisADException {
        return this.getFloats(true);
    }

    public float[][] getFloats(boolean bl) throws VisADException {
        float[][] fArray = this.unpackFloats(bl);
        Unit[] unitArray = ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
        return Unit.convertTuple(fArray, this.RangeUnits, unitArray);
    }

    public double[][] getValues() throws VisADException {
        return this.getValues(true);
    }

    public double[][] getValues(boolean bl) throws VisADException {
        double[][] dArray = this.unpackValues(bl);
        Unit[] unitArray = ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
        return Unit.convertTuple(dArray, this.RangeUnits, unitArray);
    }

    public String[][] getStringValues() throws VisADException, RemoteException {
        return null;
    }

    public double[] getValues(int n) throws VisADException {
        double[] dArray = new double[this.TupleDimension];
        dArray = this.unpackValues(n);
        double[][] dArray2 = new double[this.TupleDimension][1];
        int n2 = 0;
        while (n2 < this.TupleDimension) {
            dArray2[n2][0] = dArray[n2];
            ++n2;
        }
        Unit[] unitArray = ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
        double[][] dArray3 = Unit.convertTuple(dArray2, this.RangeUnits, unitArray);
        int n3 = 0;
        while (n3 < dArray.length) {
            dArray[n3] = dArray3[n3][0];
            ++n3;
        }
        return dArray;
    }

    public Unit[] getDefaultRangeUnits() {
        return ((FunctionType)this.Type).getFlatRange().getDefaultUnits();
    }

    public Data getSample(int n) throws VisADException, RemoteException {
        if (this.isMissing() || n < 0 || n >= this.Length) {
            return ((FunctionType)this.Type).getRange().missingData();
        }
        double[][] dArray = new double[this.TupleDimension][1];
        double[][] dArray2 = this.DoubleRange;
        synchronized (dArray2) {
            int n2 = 0;
            while (n2 < this.TupleDimension) {
                switch (this.RangeMode[n2]) {
                    case 1: {
                        dArray[n2][0] = this.DoubleRange[n2][n];
                        break;
                    }
                    case 2: {
                        dArray[n2][0] = this.FloatRange[n2][n];
                        break;
                    }
                    case 6: {
                        int[] nArray = new int[]{this.ByteRange[n2][n] - -128 - 1};
                        double[][] dArray3 = Set.floatToDouble(this.RangeSet[n2].indexToValue(nArray));
                        dArray[n2] = dArray3[0];
                        break;
                    }
                    case 5: {
                        int[] nArray = new int[]{this.ShortRange[n2][n] - Short.MIN_VALUE - 1};
                        double[][] dArray3 = Set.floatToDouble(this.RangeSet[n2].indexToValue(nArray));
                        dArray[n2] = dArray3[0];
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[]{this.IntRange[n2][n] - Integer.MIN_VALUE - 1};
                        double[][] dArray3 = Set.floatToDouble(this.RangeSet[n2].indexToValue(nArray));
                        dArray[n2] = dArray3[0];
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.getSample: bad RangeMode");
                    }
                }
                ++n2;
            }
        }
        MathType mathType = ((FunctionType)this.Type).getRange();
        if (mathType instanceof RealType) {
            return new Real((RealType)mathType, dArray[0][0], this.RangeUnits[0], this.RangeErrors[0]);
        }
        if (mathType instanceof RealTupleType) {
            Real[] realArray = new Real[this.TupleDimension];
            int n3 = 0;
            while (n3 < this.TupleDimension) {
                MathType mathType2 = ((RealTupleType)mathType).getComponent(n3);
                realArray[n3] = new Real((RealType)mathType2, dArray[n3][0], this.RangeUnits[n3], this.RangeErrors[n3]);
                ++n3;
            }
            return new RealTuple((RealTupleType)mathType, realArray, this.RangeCoordinateSystem);
        }
        int n4 = ((TupleType)mathType).getDimension();
        int n5 = 0;
        Data[] dataArray = new Data[n4];
        int n6 = 0;
        while (n6 < n4) {
            MathType mathType3 = ((TupleType)mathType).getComponent(n6);
            if (mathType3 instanceof RealType) {
                dataArray[n6] = new Real((RealType)mathType3, dArray[n5][0], this.RangeUnits[n5], this.RangeErrors[n5]);
                ++n5;
            } else {
                int n7 = ((RealTupleType)mathType3).getDimension();
                Real[] realArray = new Real[n7];
                int n8 = 0;
                while (n8 < n7) {
                    RealType realType = (RealType)((RealTupleType)mathType3).getComponent(n8);
                    realArray[n8] = new Real(realType, dArray[n5][0], this.RangeUnits[n5], this.RangeErrors[n5]);
                    ++n5;
                    ++n8;
                }
                dataArray[n6] = new RealTuple((RealTupleType)mathType3, realArray, this.RangeCoordinateSystems[n6]);
            }
            ++n6;
        }
        return new Tuple(dataArray);
    }

    public Data getSample(int n, boolean bl) throws VisADException, RemoteException {
        return this.getSample(n);
    }

    public void setSample(int n, Data data, boolean bl) throws VisADException, RemoteException {
        this.setSample(n, data);
    }

    public void setSample(int n, Data data) throws VisADException, RemoteException {
        int n2;
        int n3;
        Object object;
        if (this.DomainSet == null) {
            throw new FieldException("Field.setSample: DomainSet undefined");
        }
        if (!((FunctionType)this.Type).getRange().equals(data.getType())) {
            throw new TypeException("Field.setSample: bad range type");
        }
        if (n < 0 || n >= this.Length) {
            return;
        }
        double[] dArray = new double[this.TupleDimension];
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[this.TupleDimension];
        if (data instanceof Real) {
            dArray[0] = ((Real)data).getValue();
            dArray = Unit.transformUnits(this.RangeUnits[0], errorEstimateArray, ((Real)data).getUnit(), ((Real)data).getError(), dArray);
        } else if (data instanceof RealTuple) {
            object = new double[this.TupleDimension][1];
            n3 = 0;
            while (n3 < this.TupleDimension) {
                object[n3][0] = ((Real)((RealTuple)data).getComponent(n3)).getValue();
                ++n3;
            }
            object = CoordinateSystem.transformCoordinates((RealTupleType)((FunctionType)this.Type).getRange(), this.RangeCoordinateSystem, this.RangeUnits, errorEstimateArray, (RealTupleType)data.getType(), ((RealTuple)data).getCoordinateSystem(), ((RealTuple)data).getTupleUnits(), ((RealTuple)data).getErrors(), object);
            n3 = 0;
            while (n3 < this.TupleDimension) {
                dArray[n3] = object[n3][0];
                ++n3;
            }
        } else {
            object = ((FunctionType)this.Type).getRange();
            n3 = ((TupleIface)data).getDimension();
            int n4 = 0;
            n2 = 0;
            while (n2 < n3) {
                Object object2;
                Data data2 = ((TupleIface)data).getComponent(n2);
                if (data2 instanceof Real) {
                    double[] dArray2 = new double[]{((Real)data2).getValue()};
                    object2 = new ErrorEstimate[1];
                    dArray2 = Unit.transformUnits(this.RangeUnits[0], (ErrorEstimate[])object2, ((Real)data2).getUnit(), ((Real)data2).getError(), dArray2);
                    dArray[n4] = dArray2[0];
                    errorEstimateArray[n4] = object2[0];
                    ++n4;
                } else {
                    int n5 = ((RealTuple)data2).getDimension();
                    object2 = new double[n5][1];
                    Unit[] unitArray = new Unit[n5];
                    ErrorEstimate[] errorEstimateArray2 = ((RealTuple)data2).getErrors();
                    int n6 = 0;
                    while (n6 < n5) {
                        object2[n6][0] = ((Real)((RealTuple)data2).getComponent(n6)).getValue();
                        unitArray[n6] = this.RangeUnits[n4 + n6];
                        ++n6;
                    }
                    object2 = CoordinateSystem.transformCoordinates((RealTupleType)((TupleType)object).getComponent(n2), this.RangeCoordinateSystems[n2], unitArray, errorEstimateArray2, (RealTupleType)data2.getType(), ((RealTuple)data2).getCoordinateSystem(), ((RealTuple)data2).getTupleUnits(), ((RealTuple)data2).getErrors(), object2);
                    n6 = 0;
                    while (n6 < n5) {
                        dArray[n4] = object2[n6][0];
                        errorEstimateArray[n4] = errorEstimateArray2[n6];
                        ++n4;
                        ++n6;
                    }
                }
                ++n2;
            }
        }
        object = new int[this.TupleDimension];
        double[][] dArray3 = this.DoubleRange;
        synchronized (dArray3) {
            n2 = 0;
            while (n2 < this.TupleDimension) {
                object[n2] = (double[])(dArray[n2] == dArray[n2] ? 1 : 0);
                switch (this.RangeMode[n2]) {
                    case 1: {
                        int n7;
                        if (this.DoubleRange[n2] == null) {
                            this.DoubleRange[n2] = new double[this.Length];
                            n7 = 0;
                            while (n7 < this.Length) {
                                this.DoubleRange[n2][n7] = Double.NaN;
                                ++n7;
                            }
                        }
                        int n8 = n2;
                        object[n8] = object[n8] - (this.DoubleRange[n2][n] == this.DoubleRange[n2][n]);
                        this.DoubleRange[n2][n] = dArray[n2];
                        break;
                    }
                    case 2: {
                        int n7;
                        if (this.FloatRange[n2] == null) {
                            this.FloatRange[n2] = new float[this.Length];
                            n7 = 0;
                            while (n7 < this.Length) {
                                this.FloatRange[n2][n7] = Float.NaN;
                                ++n7;
                            }
                        }
                        int n9 = n2;
                        object[n9] = object[n9] - (this.FloatRange[n2][n] == this.FloatRange[n2][n]);
                        this.FloatRange[n2][n] = (float)dArray[n2];
                        break;
                    }
                    case 6: {
                        int n7;
                        double[][] dArray4 = new double[1][1];
                        dArray4[0][0] = dArray[n2];
                        int[] nArray = this.RangeSet[n2].valueToIndex(Set.doubleToFloat(dArray4));
                        if (this.ByteRange[n2] == null) {
                            this.ByteRange[n2] = new byte[this.Length];
                            n7 = 0;
                            while (n7 < this.Length) {
                                this.ByteRange[n2][n7] = -128;
                                ++n7;
                            }
                        }
                        int n10 = n2;
                        object[n10] = object[n10] - (this.ByteRange[n2][n] != -128);
                        this.ByteRange[n2][n] = (byte)(nArray[0] + -128 + 1);
                        break;
                    }
                    case 5: {
                        int n7;
                        double[][] dArray4 = new double[1][1];
                        dArray4[0][0] = dArray[n2];
                        int[] nArray = this.RangeSet[n2].valueToIndex(Set.doubleToFloat(dArray4));
                        if (this.ShortRange[n2] == null) {
                            this.ShortRange[n2] = new short[this.Length];
                            n7 = 0;
                            while (n7 < this.Length) {
                                this.ShortRange[n2][n7] = Short.MIN_VALUE;
                                ++n7;
                            }
                        }
                        int n11 = n2;
                        object[n11] = object[n11] - (this.ShortRange[n2][n] != Short.MIN_VALUE);
                        this.ShortRange[n2][n] = (short)(nArray[0] + Short.MIN_VALUE + 1);
                        break;
                    }
                    case 4: {
                        int n7;
                        double[][] dArray4 = new double[1][1];
                        dArray4[0][0] = dArray[n2];
                        int[] nArray = this.RangeSet[n2].valueToIndex(Set.doubleToFloat(dArray4));
                        if (this.IntRange[n2] == null) {
                            this.IntRange[n2] = new int[this.Length];
                            n7 = 0;
                            while (n7 < this.Length) {
                                this.IntRange[n2][n7] = Integer.MIN_VALUE;
                                ++n7;
                            }
                        }
                        int n12 = n2;
                        object[n12] = object[n12] - (this.IntRange[n2][n] != Integer.MIN_VALUE);
                        this.IntRange[n2][n] = nArray[0] + Integer.MIN_VALUE + 1;
                        break;
                    }
                    default: {
                        throw new SetException("FlatField.setSample: bad RangeMode");
                    }
                }
                ++n2;
            }
            ErrorEstimate[] errorEstimateArray3 = this.RangeErrors;
            synchronized (errorEstimateArray3) {
                int n13 = 0;
                while (n13 < this.TupleDimension) {
                    this.RangeErrors[n13] = new ErrorEstimate(this.RangeErrors[n13], errorEstimateArray[n13], dArray[n13], (int)object[n13]);
                    ++n13;
                }
            }
        }
        this.clearMissing();
        this.notifyReferences();
    }

    private void nullRanges() throws VisADException {
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            int n = 0;
            while (n < this.TupleDimension) {
                this.DoubleRange[n] = null;
                ++n;
            }
            this.FloatRange = new float[this.TupleDimension][];
            this.LongRange = new long[this.TupleDimension][];
            this.IntRange = new int[this.TupleDimension][];
            this.ShortRange = new short[this.TupleDimension][];
            this.ByteRange = new byte[this.TupleDimension][];
            n = 0;
            while (n < this.TupleDimension) {
                int n2;
                this.RangeMode[n] = this.RangeSet[n] instanceof DoubleSet ? 1 : (this.RangeSet[n] instanceof FloatSet ? 2 : ((n2 = this.RangeSet[n].getLength()) < 256 ? 6 : (n2 < 65536 ? 5 : 4)));
                ++n;
            }
        }
    }

    public boolean isMissing() {
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            boolean bl = this.MissingFlag;
            Object var2_3 = null;
            return bl;
        }
    }

    public void clearMissing() {
        double[][] dArray = this.DoubleRange;
        synchronized (dArray) {
            this.MissingFlag = false;
        }
    }

    public Data binary(Data data, int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        if (mathType == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (data instanceof Field) {
            Object object;
            FunctionType functionType = (FunctionType)data.getType();
            if (functionType.getRange().equalsExceptName(this.Type)) {
                if (!functionType.equalsExceptName(mathType)) {
                    throw new TypeException("binary: new_type doesn't match return type");
                }
                return data.binary(this, DataImpl.invertOp(n), mathType, n2, n3);
            }
            if (!this.Type.equalsExceptName(data.getType())) {
                throw new TypeException("FlatField.binary: types don't match");
            }
            if (!this.Type.equalsExceptName(mathType)) {
                throw new TypeException();
            }
            if (!((Field)data).isFlatField()) {
                return this.convertToField().binary(data, n, mathType, n2, n3);
            }
            data = data.local();
            if (this.isMissing() || data.isMissing()) {
                return this.cloneMissing();
            }
            data = ((FlatField)data).resample(this.DomainSet, n2, n3);
            double[][] dArray = this.unpackValues();
            double[][] dArray2 = ((FlatField)data).unpackValues();
            Unit[][] unitArray = ((FlatField)data).getRangeUnits();
            Unit[] unitArray2 = new Unit[unitArray.length];
            int n4 = 0;
            while (n4 < unitArray.length) {
                unitArray2[n4] = unitArray[n4][0];
                ++n4;
            }
            ErrorEstimate[] errorEstimateArray = ((FlatField)data).getRangeErrors();
            if (unitArray2 == null) {
                unitArray2 = new Unit[this.TupleDimension];
            }
            if (errorEstimateArray == null) {
                errorEstimateArray = new ErrorEstimate[this.TupleDimension];
            }
            Unit[] unitArray3 = new Unit[this.TupleDimension];
            ErrorEstimate[] errorEstimateArray2 = new ErrorEstimate[this.TupleDimension];
            if (((FunctionType)this.Type).getReal()) {
                object = ((FlatField)data).getRangeCoordinateSystem();
                dArray2 = CoordinateSystem.transformCoordinatesFreeUnits(((FunctionType)this.Type).getFlatRange(), this.RangeCoordinateSystem, unitArray3, errorEstimateArray2, ((FunctionType)data.getType()).getFlatRange(), (CoordinateSystem)object[0], unitArray2, errorEstimateArray, dArray2);
            } else if (this.RangeCoordinateSystems != null) {
                object = (TupleType)((FunctionType)this.Type).getRange();
                TupleType tupleType = (TupleType)((FunctionType)data.getType()).getRange();
                int n5 = ((TupleType)object).getDimension();
                int n6 = 0;
                int n7 = 0;
                while (n7 < n5) {
                    MathType mathType2 = ((TupleType)object).getComponent(n7);
                    MathType mathType3 = tupleType.getComponent(n7);
                    if (mathType2 instanceof RealTupleType) {
                        int n8 = ((RealTupleType)mathType2).getDimension();
                        double[][] dArray3 = new double[n8][];
                        Unit[] unitArray4 = new Unit[n8];
                        Unit[] unitArray5 = new Unit[n8];
                        ErrorEstimate[] errorEstimateArray3 = new ErrorEstimate[n8];
                        ErrorEstimate[] errorEstimateArray4 = new ErrorEstimate[n8];
                        int n9 = 0;
                        while (n9 < n8) {
                            dArray3[n9] = dArray2[n6 + n9];
                            unitArray5[n9] = unitArray2[n6 + n9];
                            errorEstimateArray4[n9] = errorEstimateArray[n6 + n9];
                            ++n9;
                        }
                        CoordinateSystem[] coordinateSystemArray = ((FlatField)data).getRangeCoordinateSystem(n7);
                        dArray3 = CoordinateSystem.transformCoordinatesFreeUnits((RealTupleType)mathType2, this.RangeCoordinateSystems[n7], unitArray4, errorEstimateArray3, (RealTupleType)mathType3, coordinateSystemArray[0], unitArray5, errorEstimateArray4, dArray3);
                        int n10 = 0;
                        while (n10 < n8) {
                            dArray2[n6 + n10] = dArray3[n10];
                            errorEstimateArray2[n6 + n10] = errorEstimateArray3[n10];
                            unitArray3[n6 + n10] = unitArray4[n10];
                            ++n10;
                        }
                        n6 += n8;
                    } else {
                        errorEstimateArray2[n6] = errorEstimateArray[n6];
                        unitArray3[n6] = unitArray2[n6];
                        ++n6;
                    }
                    ++n7;
                }
            }
            unitArray2 = (Unit[])this.RangeUnits.clone();
            errorEstimateArray = (ErrorEstimate[])this.RangeErrors.clone();
            FlatField.makeRational(dArray, unitArray2, errorEstimateArray);
            FlatField.makeRational(dArray2, unitArray3, errorEstimateArray2);
            block0 : switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: {
                    int n11 = 0;
                    while (n11 < this.TupleDimension) {
                        Unit unit;
                        if (unitArray2[n11] == null || unitArray3[n11] == null) {
                            unit = null;
                        } else if (unitArray2[n11] == CommonUnit.promiscuous) {
                            unit = unitArray3[n11];
                        } else if (unitArray3[n11] == CommonUnit.promiscuous) {
                            unit = unitArray2[n11];
                        } else if (Unit.canConvert(unitArray2[n11], unitArray3[n11])) {
                            unit = unitArray2[n11];
                            dArray2[n11] = unitArray2[n11].toThis(dArray2[n11], unitArray3[n11]);
                            if (n3 != 202 && errorEstimateArray2[n11] != null) {
                                double d = 0.5 * errorEstimateArray2[n11].getErrorValue();
                                double d2 = errorEstimateArray2[n11].getMean();
                                double d3 = unitArray2[n11].toThis(d2 + d, unitArray3[n11]);
                                double d4 = unitArray2[n11].toThis(d2 - d, unitArray3[n11]);
                                double d5 = Math.abs(d3 - d4);
                                double d6 = 0.5 * (d3 + d4);
                                errorEstimateArray2[n11] = new ErrorEstimate(d6, d5, unitArray2[n11]);
                            }
                        } else {
                            unit = null;
                        }
                        unitArray3[n11] = unit;
                        ++n11;
                    }
                    switch (n) {
                        case 1: {
                            n11 = 0;
                            while (n11 < this.TupleDimension) {
                                double[] dArray4 = dArray[n11];
                                double[] dArray5 = dArray2[n11];
                                int n12 = 0;
                                while (n12 < this.Length) {
                                    int n13 = n12;
                                    dArray4[n13] = dArray4[n13] + dArray5[n12];
                                    ++n12;
                                }
                                ++n11;
                            }
                            break block0;
                        }
                        case 2: {
                            n11 = 0;
                            while (n11 < this.TupleDimension) {
                                double[] dArray6 = dArray[n11];
                                double[] dArray7 = dArray2[n11];
                                int n14 = 0;
                                while (n14 < this.Length) {
                                    int n15 = n14;
                                    dArray6[n15] = dArray6[n15] - dArray7[n14];
                                    ++n14;
                                }
                                ++n11;
                            }
                            break block0;
                        }
                        case 3: {
                            n11 = 0;
                            while (n11 < this.TupleDimension) {
                                double[] dArray8 = dArray[n11];
                                double[] dArray9 = dArray2[n11];
                                int n16 = 0;
                                while (n16 < this.Length) {
                                    dArray8[n16] = dArray9[n16] - dArray8[n16];
                                    ++n16;
                                }
                                ++n11;
                            }
                            break block0;
                        }
                        case 9: {
                            n11 = 0;
                            while (n11 < this.TupleDimension) {
                                double[] dArray10 = dArray[n11];
                                double[] dArray11 = dArray2[n11];
                                int n17 = 0;
                                while (n17 < this.Length) {
                                    dArray10[n17] = Math.max(dArray10[n17], dArray11[n17]);
                                    ++n17;
                                }
                                ++n11;
                            }
                            break block0;
                        }
                        default: {
                            n11 = 0;
                            while (n11 < this.TupleDimension) {
                                double[] dArray12 = dArray[n11];
                                double[] dArray13 = dArray2[n11];
                                int n18 = 0;
                                while (n18 < this.Length) {
                                    dArray12[n18] = Math.min(dArray12[n18], dArray13[n18]);
                                    ++n18;
                                }
                                ++n11;
                            }
                            break block0;
                        }
                    }
                }
                case 4: {
                    int n19 = 0;
                    while (n19 < this.TupleDimension) {
                        double[] dArray14 = dArray[n19];
                        double[] dArray15 = dArray2[n19];
                        int n20 = 0;
                        while (n20 < this.Length) {
                            int n21 = n20;
                            dArray14[n21] = dArray14[n21] * dArray15[n20];
                            ++n20;
                        }
                        unitArray3[n19] = unitArray2[n19] == null || unitArray3[n19] == null ? null : unitArray2[n19].multiply(unitArray3[n19]);
                        ++n19;
                    }
                    break;
                }
                case 5: {
                    int n22 = 0;
                    while (n22 < this.TupleDimension) {
                        double[] dArray16 = dArray[n22];
                        double[] dArray17 = dArray2[n22];
                        int n23 = 0;
                        while (n23 < this.Length) {
                            int n24 = n23;
                            dArray16[n24] = dArray16[n24] / dArray17[n23];
                            ++n23;
                        }
                        unitArray3[n22] = unitArray2[n22] == null || unitArray3[n22] == null ? null : unitArray2[n22].divide(unitArray3[n22]);
                        ++n22;
                    }
                    break;
                }
                case 6: {
                    int n25 = 0;
                    while (n25 < this.TupleDimension) {
                        double[] dArray18 = dArray[n25];
                        double[] dArray19 = dArray2[n25];
                        int n26 = 0;
                        while (n26 < this.Length) {
                            dArray18[n26] = dArray19[n26] / dArray18[n26];
                            ++n26;
                        }
                        unitArray3[n25] = unitArray2[n25] == null || unitArray3[n25] == null ? null : unitArray3[n25].divide(unitArray2[n25]);
                        ++n25;
                    }
                    break;
                }
                case 7: {
                    int n27 = 0;
                    while (n27 < this.TupleDimension) {
                        double[] dArray20 = dArray[n27];
                        double[] dArray21 = dArray2[n27];
                        int n28 = 0;
                        while (n28 < this.Length) {
                            dArray20[n28] = Math.pow(dArray20[n28], dArray21[n28]);
                            ++n28;
                        }
                        unitArray3[n27] = null;
                        ++n27;
                    }
                    break;
                }
                case 8: {
                    int n29 = 0;
                    while (n29 < this.TupleDimension) {
                        double[] dArray22 = dArray[n29];
                        double[] dArray23 = dArray2[n29];
                        int n30 = 0;
                        while (n30 < this.Length) {
                            dArray22[n30] = Math.pow(dArray23[n30], dArray22[n30]);
                            ++n30;
                        }
                        unitArray3[n29] = null;
                        ++n29;
                    }
                    break;
                }
                case 11: {
                    int n31 = 0;
                    while (n31 < this.TupleDimension) {
                        double[] dArray24 = dArray[n31];
                        double[] dArray25 = dArray2[n31];
                        int n32 = 0;
                        while (n32 < this.Length) {
                            dArray24[n32] = Math.atan2(dArray24[n32], dArray25[n32]);
                            ++n32;
                        }
                        unitArray3[n31] = CommonUnit.radian;
                        ++n31;
                    }
                    break;
                }
                case 12: {
                    int n33 = 0;
                    while (n33 < this.TupleDimension) {
                        double[] dArray26 = dArray[n33];
                        double[] dArray27 = dArray2[n33];
                        int n34 = 0;
                        while (n34 < this.Length) {
                            dArray26[n34] = 57.29577951308232 * Math.atan2(dArray26[n34], dArray27[n34]);
                            ++n34;
                        }
                        unitArray3[n33] = CommonUnit.degree;
                        ++n33;
                    }
                    break;
                }
                case 13: {
                    int n35 = 0;
                    while (n35 < this.TupleDimension) {
                        double[] dArray28 = dArray[n35];
                        double[] dArray29 = dArray2[n35];
                        int n36 = 0;
                        while (n36 < this.Length) {
                            dArray28[n36] = Math.atan2(dArray29[n36], dArray28[n36]);
                            ++n36;
                        }
                        unitArray3[n35] = CommonUnit.radian;
                        ++n35;
                    }
                    break;
                }
                case 14: {
                    int n37 = 0;
                    while (n37 < this.TupleDimension) {
                        double[] dArray30 = dArray[n37];
                        double[] dArray31 = dArray2[n37];
                        int n38 = 0;
                        while (n38 < this.Length) {
                            dArray30[n38] = 57.29577951308232 * Math.atan2(dArray31[n38], dArray30[n38]);
                            ++n38;
                        }
                        unitArray3[n37] = CommonUnit.degree;
                        ++n37;
                    }
                    break;
                }
                case 15: {
                    int n39 = 0;
                    while (n39 < this.TupleDimension) {
                        double[] dArray32 = dArray[n39];
                        double[] dArray33 = dArray2[n39];
                        int n40 = 0;
                        while (n40 < this.Length) {
                            int n41 = n40;
                            dArray32[n41] = dArray32[n41] % dArray33[n40];
                            ++n40;
                        }
                        unitArray3[n39] = unitArray2[n39];
                        ++n39;
                    }
                    break;
                }
                case 16: {
                    int n42 = 0;
                    while (n42 < this.TupleDimension) {
                        double[] dArray34 = dArray[n42];
                        double[] dArray35 = dArray2[n42];
                        int n43 = 0;
                        while (n43 < this.Length) {
                            dArray34[n43] = dArray35[n43] % dArray34[n43];
                            ++n43;
                        }
                        ++n42;
                    }
                    break;
                }
            }
            int n44 = 0;
            while (n44 < this.TupleDimension) {
                errorEstimateArray2[n44] = n3 == 202 || errorEstimateArray[n44] == null || errorEstimateArray2[n44] == null ? null : new ErrorEstimate(dArray[n44], unitArray3[n44], n, errorEstimateArray[n44], errorEstimateArray2[n44], n3);
                ++n44;
            }
            FlatField flatField = this.cloneDouble(mathType, unitArray3, errorEstimateArray2);
            flatField.packValues(dArray, false);
            flatField.clearMissing();
            return flatField;
        }
        if (data instanceof Real || data instanceof RealTuple || data instanceof TupleIface && ((TupleType)data.getType()).getFlat()) {
            Object object;
            Object object2;
            int n45;
            int n46;
            MathType mathType4 = ((FunctionType)this.Type).getRange();
            if (!this.Type.equalsExceptName(mathType)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            if (this.isMissing() || data.isMissing()) {
                return this.cloneDouble();
            }
            double[][] dArray = this.unpackValues();
            double[][] dArray36 = new double[this.TupleDimension][1];
            Unit[] unitArray = new Unit[this.TupleDimension];
            ErrorEstimate[] errorEstimateArray = new ErrorEstimate[this.TupleDimension];
            if (data instanceof Real) {
                n46 = 0;
                while (n46 < this.TupleDimension) {
                    dArray36[n46][0] = ((Real)data).getValue();
                    unitArray[n46] = ((Real)data).getUnit();
                    errorEstimateArray[n46] = ((Real)data).getError();
                    ++n46;
                }
            } else if (data instanceof RealTuple) {
                n46 = 0;
                while (n46 < this.TupleDimension) {
                    dArray36[n46][0] = ((Real)((RealTuple)data).getComponent(n46)).getValue();
                    ++n46;
                }
                dArray36 = CoordinateSystem.transformCoordinatesFreeUnits(((FunctionType)this.Type).getFlatRange(), this.RangeCoordinateSystem, unitArray, errorEstimateArray, (RealTupleType)data.getType(), ((RealTuple)data).getCoordinateSystem(), ((RealTuple)data).getTupleUnits(), ((RealTuple)data).getErrors(), dArray36);
            } else {
                n46 = ((TupleIface)data).getDimension();
                int n47 = 0;
                n45 = 0;
                while (n45 < n46) {
                    Data data2 = ((TupleIface)data).getComponent(n45);
                    if (data2 instanceof Real) {
                        dArray36[n47][0] = ((Real)data2).getValue();
                        unitArray[n47] = ((Real)data2).getUnit();
                        errorEstimateArray[n47] = ((Real)data2).getError();
                        ++n47;
                    } else {
                        int n48 = ((TupleIface)data2).getDimension();
                        object2 = new double[n48][1];
                        object = new Unit[n48];
                        ErrorEstimate[] errorEstimateArray5 = new ErrorEstimate[n48];
                        int n49 = 0;
                        while (n49 < n48) {
                            object2[n49][0] = ((Real)((TupleIface)data2).getComponent(n49)).getValue();
                            ++n49;
                        }
                        object2 = CoordinateSystem.transformCoordinatesFreeUnits((RealTupleType)((TupleType)mathType4).getComponent(n45), this.RangeCoordinateSystems[n45], object, errorEstimateArray5, (RealTupleType)data2.getType(), ((RealTuple)data2).getCoordinateSystem(), ((RealTuple)data2).getTupleUnits(), ((RealTuple)data2).getErrors(), object2);
                        n49 = 0;
                        while (n49 < n48) {
                            dArray36[n47 + n49][0] = object2[n49][0];
                            unitArray[n47 + n49] = object[n49];
                            errorEstimateArray[n47 + n49] = errorEstimateArray5[n49];
                            ++n49;
                        }
                        n47 += n48;
                    }
                    ++n45;
                }
            }
            Unit[] unitArray6 = (Unit[])this.RangeUnits.clone();
            ErrorEstimate[] errorEstimateArray6 = (ErrorEstimate[])this.RangeErrors.clone();
            FlatField.makeRational(dArray, unitArray6, errorEstimateArray6);
            FlatField.makeRational(dArray36, unitArray, errorEstimateArray);
            n45 = 0;
            while (n45 < this.TupleDimension) {
                double d = dArray36[n45][0];
                object2 = dArray[n45];
                block20 : switch (n) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: 
                    case 10: {
                        if (unitArray6[n45] == null || unitArray[n45] == null) {
                            object = null;
                        } else if (unitArray6[n45] == CommonUnit.promiscuous) {
                            object = unitArray[n45];
                        } else if (unitArray[n45] == CommonUnit.promiscuous) {
                            object = unitArray6[n45];
                        } else if (Unit.canConvert(unitArray6[n45], unitArray[n45])) {
                            object = unitArray6[n45];
                            d = unitArray6[n45].toThis(d, unitArray[n45]);
                            if (n3 == 202 && errorEstimateArray[n45] != null) {
                                double d7 = 0.5 * errorEstimateArray[n45].getErrorValue();
                                double d8 = errorEstimateArray[n45].getMean();
                                double d9 = unitArray6[n45].toThis(d8 + d7, unitArray[n45]);
                                double d10 = unitArray6[n45].toThis(d8 - d7, unitArray[n45]);
                                double d11 = Math.abs(d9 - d10);
                                double d12 = 0.5 * (d9 + d10);
                                errorEstimateArray[n45] = new ErrorEstimate(d12, d11, unitArray6[n45]);
                            }
                        } else {
                            object = null;
                        }
                        unitArray[n45] = object;
                        switch (n) {
                            case 1: {
                                int n50 = 0;
                                while (n50 < this.Length) {
                                    int n51 = n50++;
                                    object2[n51] = object2[n51] + d;
                                }
                                break block20;
                            }
                            case 2: {
                                int n50 = 0;
                                while (n50 < this.Length) {
                                    int n52 = n50++;
                                    object2[n52] = object2[n52] - d;
                                }
                                break block20;
                            }
                            case 3: {
                                int n50 = 0;
                                while (n50 < this.Length) {
                                    object2[n50] = (double[])(d - object2[n50]);
                                    ++n50;
                                }
                                break block20;
                            }
                            case 9: {
                                int n50 = 0;
                                while (n50 < this.Length) {
                                    object2[n50] = (double[])Math.max((double)object2[n50], d);
                                    ++n50;
                                }
                                break block20;
                            }
                            default: {
                                int n50 = 0;
                                while (n50 < this.Length) {
                                    object2[n50] = (double[])Math.min((double)object2[n50], d);
                                    ++n50;
                                }
                                break block20;
                            }
                        }
                    }
                    case 4: {
                        int n53 = 0;
                        while (n53 < this.Length) {
                            int n54 = n53++;
                            object2[n54] = object2[n54] * d;
                        }
                        if (unitArray6[n45] == null || unitArray[n45] == null) {
                            unitArray[n45] = null;
                            break;
                        }
                        unitArray[n45] = unitArray6[n45].multiply(unitArray[n45]);
                        break;
                    }
                    case 5: {
                        int n55 = 0;
                        while (n55 < this.Length) {
                            int n56 = n55++;
                            object2[n56] = object2[n56] / d;
                        }
                        if (unitArray6[n45] == null || unitArray[n45] == null) {
                            unitArray[n45] = null;
                            break;
                        }
                        unitArray[n45] = unitArray6[n45].divide(unitArray[n45]);
                        break;
                    }
                    case 6: {
                        int n57 = 0;
                        while (n57 < this.Length) {
                            object2[n57] = (double[])(d / object2[n57]);
                            ++n57;
                        }
                        if (unitArray6[n45] == null || unitArray[n45] == null) {
                            unitArray[n45] = null;
                            break;
                        }
                        unitArray[n45] = unitArray[n45].divide(unitArray6[n45]);
                        break;
                    }
                    case 7: {
                        int n58 = 0;
                        while (n58 < this.Length) {
                            object2[n58] = (double[])Math.pow((double)object2[n58], d);
                            ++n58;
                        }
                        unitArray[n45] = CommonUnit.dimensionless.equals(unitArray6[n45]) ? CommonUnit.dimensionless : null;
                        break;
                    }
                    case 8: {
                        int n59 = 0;
                        while (n59 < this.Length) {
                            object2[n59] = (double[])Math.pow(d, (double)object2[n59]);
                            ++n59;
                        }
                        unitArray[n45] = null;
                        break;
                    }
                    case 11: {
                        int n60 = 0;
                        while (n60 < this.Length) {
                            object2[n60] = (double[])Math.atan2((double)object2[n60], d);
                            ++n60;
                        }
                        unitArray[n45] = CommonUnit.radian;
                        break;
                    }
                    case 12: {
                        int n61 = 0;
                        while (n61 < this.Length) {
                            object2[n61] = (double[])(57.29577951308232 * Math.atan2((double)object2[n61], d));
                            ++n61;
                        }
                        unitArray[n45] = CommonUnit.degree;
                        break;
                    }
                    case 13: {
                        int n62 = 0;
                        while (n62 < this.Length) {
                            object2[n62] = (double[])Math.atan2(d, (double)object2[n62]);
                            ++n62;
                        }
                        unitArray[n45] = CommonUnit.radian;
                        break;
                    }
                    case 14: {
                        int n63 = 0;
                        while (n63 < this.Length) {
                            object2[n63] = (double[])(57.29577951308232 * Math.atan2(d, (double)object2[n63]));
                            ++n63;
                        }
                        unitArray[n45] = CommonUnit.degree;
                        break;
                    }
                    case 15: {
                        int n64 = 0;
                        while (n64 < this.Length) {
                            int n65 = n64++;
                            object2[n65] = object2[n65] % d;
                        }
                        unitArray[n45] = unitArray6[n45];
                        break;
                    }
                    case 16: {
                        int n66 = 0;
                        while (n66 < this.Length) {
                            object2[n66] = (double[])(d % object2[n66]);
                            ++n66;
                        }
                        break;
                    }
                }
                ++n45;
            }
            n45 = 0;
            while (n45 < this.TupleDimension) {
                errorEstimateArray[n45] = n3 == 202 || errorEstimateArray6[n45] == null || errorEstimateArray[n45] == null ? null : new ErrorEstimate(dArray[n45], unitArray[n45], n, errorEstimateArray6[n45], errorEstimateArray[n45], n3);
                ++n45;
            }
            FlatField flatField = this.cloneDouble(mathType, unitArray, errorEstimateArray);
            flatField.packValues(dArray, false);
            flatField.clearMissing();
            return flatField;
        }
        throw new TypeException("Field.binary");
    }

    public Data unary(int n, MathType mathType, int n2, int n3) throws VisADException {
        int n4;
        if (this.isMissing()) {
            return this.cloneDouble();
        }
        if (mathType == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        double[][] dArray = this.unpackValues();
        Unit[] unitArray = new Unit[this.TupleDimension];
        Unit[] unitArray2 = (Unit[])this.RangeUnits.clone();
        ErrorEstimate[] errorEstimateArray = (ErrorEstimate[])this.RangeErrors.clone();
        FlatField.makeRational(dArray, unitArray2, errorEstimateArray);
        switch (n) {
            case 21: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.abs(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = unitArray2[n4];
                    ++n4;
                }
                break;
            }
            case 22: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.acos(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = CommonUnit.radian;
                    ++n4;
                }
                break;
            }
            case 23: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = 57.29577951308232 * Math.acos(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = CommonUnit.degree;
                    ++n4;
                }
                break;
            }
            case 24: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.asin(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = CommonUnit.radian;
                    ++n4;
                }
                break;
            }
            case 25: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = 57.29577951308232 * Math.asin(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = CommonUnit.degree;
                    ++n4;
                }
                break;
            }
            case 26: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.atan(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = CommonUnit.radian;
                    ++n4;
                }
                break;
            }
            case 27: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = 57.29577951308232 * Math.atan(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = CommonUnit.degree;
                    ++n4;
                }
                break;
            }
            case 28: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.ceil(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = unitArray2[n4];
                    ++n4;
                }
                break;
            }
            case 29: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    if (CommonUnit.degree.equals(unitArray2[n4])) {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.cos(Math.PI / 180 * dArray2[n5]);
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.cos(dArray2[n5]);
                            ++n5;
                        }
                    }
                    unitArray[n4] = CommonUnit.dimensionless.equals(unitArray2[n4]) ? unitArray2[n4] : null;
                    ++n4;
                }
                break;
            }
            case 30: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    if (CommonUnit.radian.equals(unitArray2[n4])) {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.cos(dArray2[n5]);
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.cos(Math.PI / 180 * dArray2[n5]);
                            ++n5;
                        }
                    }
                    unitArray[n4] = CommonUnit.dimensionless.equals(unitArray2[n4]) ? unitArray2[n4] : null;
                    ++n4;
                }
                break;
            }
            case 31: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.exp(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = CommonUnit.dimensionless.equals(unitArray2[n4]) ? unitArray2[n4] : null;
                    ++n4;
                }
                break;
            }
            case 32: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.floor(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = unitArray2[n4];
                    ++n4;
                }
                break;
            }
            case 33: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.log(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = CommonUnit.dimensionless.equals(unitArray2[n4]) ? unitArray2[n4] : null;
                    ++n4;
                }
                break;
            }
            case 34: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.rint(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = unitArray2[n4];
                    ++n4;
                }
                break;
            }
            case 35: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.round(dArray2[n5]);
                        ++n5;
                    }
                    unitArray[n4] = unitArray2[n4];
                    ++n4;
                }
                break;
            }
            case 36: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    if (CommonUnit.degree.equals(unitArray2[n4])) {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.sin(Math.PI / 180 * dArray2[n5]);
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.sin(dArray2[n5]);
                            ++n5;
                        }
                    }
                    unitArray[n4] = CommonUnit.dimensionless.equals(unitArray2[n4]) ? unitArray2[n4] : null;
                    ++n4;
                }
                break;
            }
            case 37: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    if (CommonUnit.radian.equals(unitArray2[n4])) {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.sin(dArray2[n5]);
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.sin(Math.PI / 180 * dArray2[n5]);
                            ++n5;
                        }
                    }
                    unitArray[n4] = CommonUnit.dimensionless.equals(unitArray2[n4]) ? unitArray2[n4] : null;
                    ++n4;
                }
                break;
            }
            case 38: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = Math.sqrt(dArray2[n5]);
                        ++n5;
                    }
                    if (unitArray2[n4] == null) {
                        unitArray[n4] = null;
                    } else {
                        try {
                            unitArray[n4] = unitArray2[n4].sqrt();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            unitArray[n4] = null;
                        }
                        catch (UnitException unitException) {
                            unitArray[n4] = null;
                        }
                    }
                    ++n4;
                }
                break;
            }
            case 39: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    if (CommonUnit.degree.equals(unitArray2[n4])) {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.tan(Math.PI / 180 * dArray2[n5]);
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.tan(dArray2[n5]);
                            ++n5;
                        }
                    }
                    unitArray[n4] = CommonUnit.dimensionless.equals(unitArray2[n4]) ? unitArray2[n4] : null;
                    ++n4;
                }
                break;
            }
            case 40: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    if (CommonUnit.radian.equals(unitArray2[n4])) {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.tan(dArray2[n5]);
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < this.Length) {
                            dArray2[n5] = Math.tan(Math.PI / 180 * dArray2[n5]);
                            ++n5;
                        }
                    }
                    unitArray[n4] = CommonUnit.dimensionless.equals(unitArray2[n4]) ? unitArray2[n4] : null;
                    ++n4;
                }
                break;
            }
            case 41: {
                int n5;
                double[] dArray2;
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    dArray2 = dArray[n4];
                    n5 = 0;
                    while (n5 < this.Length) {
                        dArray2[n5] = -dArray2[n5];
                        ++n5;
                    }
                    unitArray[n4] = unitArray2[n4];
                    ++n4;
                }
                break;
            }
            case 42: {
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    unitArray[n4] = unitArray2[n4];
                    ++n4;
                }
                break;
            }
        }
        ErrorEstimate[] errorEstimateArray2 = new ErrorEstimate[this.TupleDimension];
        n4 = 0;
        while (n4 < this.TupleDimension) {
            errorEstimateArray2[n4] = n3 == 202 || errorEstimateArray[n4] == null ? null : new ErrorEstimate(dArray[n4], unitArray[n4], n, errorEstimateArray[n4], n3);
            ++n4;
        }
        FlatField flatField = this.cloneDouble(mathType, unitArray, errorEstimateArray2);
        flatField.packValues(dArray, false);
        flatField.clearMissing();
        return flatField;
    }

    protected static void makeRational(double[][] dArray, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws UnitException {
        int n = 0;
        while (n < dArray.length) {
            Unit unit = unitArray[n];
            if (unit != null && !(unit instanceof PromiscuousUnit)) {
                Unit unit2 = unit.getAbsoluteUnit();
                if (Unit.canConvert(unit2, CommonUnit.dimensionless)) {
                    unit2 = CommonUnit.dimensionless;
                }
                if (!unit2.equals(unit)) {
                    dArray[n] = unit2.toThis(dArray[n], unit);
                    if (errorEstimateArray[n] != null) {
                        errorEstimateArray[n] = new ErrorEstimate(unit2.toThis(errorEstimateArray[n].getMean(), unit), errorEstimateArray[n].getErrorValue(), unit2);
                    }
                    unitArray[n] = unit2;
                }
            }
            ++n;
        }
    }

    public Field extract(int n) throws VisADException, RemoteException {
        CoordinateSystem coordinateSystem;
        int[] nArray;
        int n2;
        Set set = this.getDomainSet();
        int n3 = set.getLength();
        MathType mathType = ((FunctionType)this.Type).getRange();
        RealTupleType realTupleType = ((FunctionType)this.Type).getDomain();
        if (mathType instanceof RealType) {
            if (n != 0) {
                throw new VisADException("extract: component index must be zero");
            }
            return this;
        }
        int n4 = ((TupleType)mathType).getDimension();
        if (n + 1 > n4) {
            throw new VisADException("extract: component index too large");
        }
        MathType mathType2 = ((TupleType)mathType).getComponent(n);
        FunctionType functionType = new FunctionType(realTupleType, mathType2);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n) {
            MathType mathType3 = ((TupleType)mathType).getComponent(n7);
            if (mathType3 instanceof RealType) {
                ++n5;
            } else {
                n5 += ((RealTupleType)mathType3).getDimension();
                ++n6;
            }
            ++n7;
        }
        if (mathType2 instanceof RealType) {
            n2 = 1;
            nArray = new int[n2];
            nArray[0] = n5;
            coordinateSystem = null;
        } else {
            n2 = ((RealTupleType)mathType2).getDimension();
            nArray = new int[n2];
            int n8 = 0;
            while (n8 < n2) {
                nArray[n8] = n5++;
                ++n8;
            }
            coordinateSystem = this.RangeCoordinateSystems[n6];
        }
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[n2];
        Unit[] unitArray = new Unit[n2];
        Set[] setArray = new Set[n2];
        n7 = 0;
        while (n7 < n2) {
            unitArray[n7] = this.RangeUnits[nArray[n7]];
            errorEstimateArray[n7] = this.RangeErrors[nArray[n7]];
            setArray[n7] = this.RangeSet[nArray[n7]];
            ++n7;
        }
        FlatField flatField = new FlatField(functionType, set, coordinateSystem, null, setArray, unitArray);
        flatField.setRangeErrors(errorEstimateArray);
        double[][] dArray = new double[n2][n3];
        double[] dArray2 = null;
        n7 = 0;
        while (n7 < n2) {
            dArray2 = this.unpackOneRangeComp(nArray[n7]);
            System.arraycopy(dArray2, 0, dArray[n7], 0, n3);
            ++n7;
        }
        flatField.setSamples(dArray);
        return flatField;
    }

    public Data derivative(RealTuple realTuple, RealType[] realTypeArray, MathType[] mathTypeArray, int n) throws VisADException, RemoteException {
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object3;
        boolean bl;
        int n4;
        int n5;
        Set set = this.getDomainSet();
        int n6 = set.getDimension();
        int n7 = set.getManifoldDimension();
        int n8 = set.getLength();
        CoordinateSystem coordinateSystem = this.getDomainCoordinateSystem();
        RealTupleType realTupleType = coordinateSystem == null ? null : coordinateSystem.getReference();
        MathType mathType = null;
        Object var20_12 = null;
        Object var21_13 = null;
        Object var22_14 = null;
        Object var23_15 = null;
        boolean bl2 = true;
        if (n7 != n6) {
            throw new SetException("derivative: manifoldDimension must equal domain dimension");
        }
        n = 202;
        if (realTuple != null) {
            bl2 = false;
        }
        RealTupleType realTupleType2 = ((FunctionType)this.Type).getDomain();
        RealType[] realTypeArray2 = realTupleType2.getRealComponents();
        RealType[] realTypeArray3 = ((FunctionType)this.Type).getFlatRange().getRealComponents();
        RealType[] realTypeArray4 = realTupleType == null ? null : realTupleType.getRealComponents();
        MathType mathType2 = ((FunctionType)this.Type).getRange();
        if (realTypeArray == null) {
            n5 = n6;
            realTypeArray = realTypeArray2;
        } else {
            n5 = realTypeArray.length;
            if (n5 > n6) {
                throw new VisADException("derivative: too many d_partial components");
            }
        }
        int[] nArray = new int[n5];
        double[][] dArray = new double[n5][n6];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n5) {
            n4 = 0;
            while (n4 < n6) {
                dArray[n11][n4] = 0.0;
                if (realTypeArray2[n4].equals(realTypeArray[n11])) {
                    nArray[n11] = n4;
                    dArray[n11][n4] = 1.0;
                    ++n9;
                } else if (realTupleType != null && realTypeArray4[n4].equals(realTypeArray[n11])) {
                    nArray[n11] = n4;
                    dArray[n4][n11] = 1.0;
                    ++n10;
                }
                ++n4;
            }
            ++n11;
        }
        if (n9 == 0) {
            if (n10 == 0) {
                throw new VisADException("derivative: d_partial_s not in domain or reference");
            }
            if (n10 > 0 && n10 < n5) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            bl = true;
        } else {
            if (n9 > 0 && n9 < n5) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            bl = false;
        }
        Unit[] unitArray = null;
        Unit[][] unitArray2 = this.getRangeUnits();
        Object var38_32 = null;
        Unit[][] unitArray3 = new Unit[n5][this.TupleDimension];
        MathType[] mathTypeArray2 = new MathType[n5];
        MathType[] mathTypeArray3 = new MathType[n5];
        unitArray = !bl ? set.getSetUnits() : realTupleType.getDefaultUnits();
        n11 = 0;
        while (n11 < n5) {
            n4 = 0;
            while (n4 < this.TupleDimension) {
                unitArray3[n11][n4] = unitArray2 == null || unitArray == null ? null : (unitArray2[n4][0] == null || unitArray[nArray[n11]] == null ? null : unitArray2[n4][0].divide(unitArray[nArray[n11]]));
                ++n4;
            }
            ++n11;
        }
        if (mathTypeArray == null) {
            n11 = 0;
            while (n11 < n5) {
                object3 = this.Type.cloneDerivative(realTypeArray[n11]);
                mathTypeArray3[n11] = bl2 ? object3 : ((FunctionType)object3).getRange();
                ++n11;
            }
            mathTypeArray = mathTypeArray3;
        } else {
            if (mathTypeArray.length != n5) {
                throw new VisADException("derivative: must be a single MathType for each domain RealType");
            }
            n11 = 0;
            while (n11 < n5) {
                if (bl2 ? !this.Type.equalsExceptName(mathTypeArray[n11]) : !((FunctionType)this.Type).getRange().equalsExceptName(mathTypeArray[n11])) {
                    throw new TypeException("derivative: incompatible with function range");
                }
                ++n11;
            }
        }
        object3 = null;
        Data[] dataArray = new DataImpl[n5];
        ErrorEstimate[][] errorEstimateArray = new ErrorEstimate[n5][this.TupleDimension];
        if (bl2) {
            object3 = new double[n5][this.TupleDimension][n8];
            n11 = 0;
            while (n11 < n5) {
                dataArray[n11] = this.cloneDouble(mathTypeArray[n11], unitArray3[n11], null);
                ++n11;
            }
            if (this.isMissing()) {
                if (n5 == 1) {
                    return dataArray[0];
                }
                return new Tuple(dataArray);
            }
        } else {
            object3 = new double[n5][this.TupleDimension][1];
            if (this.isMissing()) {
                n11 = 0;
                while (n11 < n5) {
                    n4 = 0;
                    while (n4 < this.TupleDimension) {
                        object3[n11][n4][0] = Double.NaN;
                        errorEstimateArray[n11][n4] = null;
                        ++n4;
                    }
                    ++n11;
                }
            }
        }
        if (!this.isMissing()) {
            int n12;
            int n13;
            object2 = null;
            object = null;
            ErrorEstimate[] errorEstimateArray2 = set.getSetErrors();
            if (set instanceof LinearSet && bl2) {
                object2 = this.getValues();
                n13 = 0;
                while (n13 < n5) {
                    n3 = nArray[n13];
                    object = set.getNeighbors(n3);
                    float f = (float)((LinearSet)((Object)set)).getLinear1DComponent(n13).getStep();
                    n11 = 0;
                    while (n11 < n8) {
                        Object object4;
                        Object object5;
                        float f2;
                        if (object[n11][0] == -1) {
                            f2 = f;
                            object5 = object[n11][1];
                            object4 = n11;
                        } else if (object[n11][1] == -1) {
                            f2 = f;
                            object5 = n11;
                            object4 = object[n11][0];
                        } else {
                            f2 = 2.0f * f;
                            object5 = object[n11][1];
                            object4 = object[n11][0];
                        }
                        n12 = 0;
                        while (n12 < this.TupleDimension) {
                            object3[n13][n12][n11] = (object2[n12][object5] - object2[n12][object4]) / (double)f2;
                            ++n12;
                        }
                        ++n11;
                    }
                    if (n != 202) {
                        n12 = 0;
                        while (n12 < this.TupleDimension) {
                            Object object6 = object3[n13][n12];
                            errorEstimateArray[n13][n12] = new ErrorEstimate((double[])object6, unitArray3[n13][n12], 5, this.RangeErrors[n12], errorEstimateArray2[n3], n);
                            ++n12;
                        }
                    }
                    ++n13;
                }
                object = null;
                object2 = null;
            } else {
                Object object7;
                Object object8;
                Object object9;
                int n14;
                float[][] fArray;
                float[][] fArray2 = null;
                if (bl2) {
                    object2 = this.getValues();
                    object = new int[n8][];
                    fArray2 = new float[n8][];
                    set.getNeighbors((int[][])object, fArray2);
                    if (bl) {
                        fArray = set.getSamples(true);
                        fArray = CoordinateSystem.transformCoordinates(realTupleType, null, null, null, realTupleType2, coordinateSystem, null, null, fArray);
                    } else {
                        fArray = set.getSamples(false);
                    }
                } else {
                    n8 = 1;
                    float[][] fArray3 = set.getSamples(false);
                    FlatField flatField = (FlatField)this.resample(new SingletonSet(realTuple, null, null, null), 101, n);
                    float[][] fArray4 = flatField.getDomainSet().getSamples(false);
                    object = new int[n8][];
                    fArray2 = new float[n8][];
                    ((SimpleSet)this.DomainSet).valueToInterp(fArray4, (int[][])object, fArray2);
                    n14 = ((Object)object[0]).length;
                    object9 = new int[n8][n14];
                    object8 = new double[this.TupleDimension][n14 + 1];
                    float[][] fArray5 = new float[n6][n14 + 1];
                    n11 = 0;
                    while (n11 < n6) {
                        fArray5[n11][0] = fArray4[n11][0];
                        ++n11;
                    }
                    object7 = flatField.unpackValues(0);
                    n11 = 0;
                    while (n11 < this.TupleDimension) {
                        object8[n11][0] = object7[n11];
                        ++n11;
                    }
                    n13 = 0;
                    while (n13 < n14) {
                        object7 = this.unpackValues((int)object[0][n13]);
                        object9[0][n13] = n13 + 1;
                        n11 = 0;
                        while (n11 < this.TupleDimension) {
                            object8[n11][n13 + 1] = object7[n11];
                            ++n11;
                        }
                        n11 = 0;
                        while (n11 < n6) {
                            fArray5[n11][n13 + 1] = fArray3[n11][object[0][n13]];
                            ++n11;
                        }
                        ++n13;
                    }
                    object = object9;
                    object2 = object8;
                    fArray = fArray5;
                    if (bl) {
                        fArray = CoordinateSystem.transformCoordinates(realTupleType, null, null, null, realTupleType2, coordinateSystem, null, null, fArray);
                    }
                }
                n11 = 0;
                while (n11 < n8) {
                    int n15;
                    n14 = ((Object)object[n11]).length;
                    object8 = new double[n14];
                    object7 = new double[n14][this.TupleDimension];
                    object9 = new double[n14][n6];
                    n13 = 0;
                    while (n13 < n14) {
                        float f = 0.0f;
                        n15 = 0;
                        while (n15 < n6) {
                            f += (fArray[n15][object[n11][n13]] - fArray[n15][n11]) * (fArray[n15][object[n11][n13]] - fArray[n15][n11]);
                            object9[n13][n15] = fArray[n15][object[n11][n13]] - fArray[n15][n11];
                            ++n15;
                        }
                        object8[n13] = Math.sqrt(f);
                        n12 = 0;
                        while (n12 < this.TupleDimension) {
                            object7[n13][n12] = (double)(object2[n12][object[n11][n13]] - object2[n12][n11]);
                            ++n12;
                        }
                        ++n13;
                    }
                    n2 = 0;
                    while (n2 < n5) {
                        float f = 0.0f;
                        n13 = 0;
                        while (n13 < n14) {
                            float f3 = 0.0f;
                            n15 = 0;
                            while (n15 < n6) {
                                f3 = (float)((double)f3 + object9[n13][n15] * dArray[n2][n15]);
                                ++n15;
                            }
                            float f4 = 1.0f / f3;
                            if (!Float.isInfinite(f4)) {
                                f += fArray2[n11][n13];
                                n12 = 0;
                                while (n12 < this.TupleDimension) {
                                    Object object10 = object3[n2][n12];
                                    int n16 = n11;
                                    object10[n16] = object10[n16] + object7[n13][n12] * (double)f4 * (double)fArray2[n11][n13];
                                    ++n12;
                                }
                            }
                            ++n13;
                        }
                        n12 = 0;
                        while (n12 < this.TupleDimension) {
                            Object object11 = object3[n2][n12];
                            int n17 = n11;
                            object11[n17] = object11[n17] / (double)f;
                            ++n12;
                        }
                        ++n2;
                    }
                    ++n11;
                }
            }
        }
        object2 = null;
        n2 = 0;
        while (n2 < n5) {
            object2 = object3[n2];
            if (bl2) {
                ((FlatField)dataArray[n2]).setSamples((double[][])object2);
                ((FlatField)dataArray[n2]).setRangeErrors(errorEstimateArray[n2]);
            } else {
                object = mathTypeArray[n2];
                if (object instanceof RealType) {
                    dataArray[n2] = new Real((RealType)object, (double)object2[0][0], unitArray3[n2][0], errorEstimateArray[n2][0]);
                } else if (object instanceof RealTupleType) {
                    Real[] realArray = new Real[this.TupleDimension];
                    n11 = 0;
                    while (n11 < this.TupleDimension) {
                        realArray[n11] = new Real((RealType)((TupleType)object).getComponent(n11), (double)object2[n11][0], unitArray3[n2][n11], errorEstimateArray[n2][0]);
                        ++n11;
                    }
                    dataArray[n2] = new RealTuple((RealTupleType)object, realArray, this.RangeCoordinateSystem);
                } else if (object instanceof TupleType) {
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = ((TupleType)object).getDimension();
                    Data[] dataArray2 = new Data[n20];
                    n11 = 0;
                    while (n11 < n20) {
                        mathType = ((TupleType)object).getComponent(n11);
                        if (mathType instanceof RealType) {
                            dataArray2[n11] = new Real((RealType)mathType, (double)object2[n19][0], unitArray3[n2][n11], errorEstimateArray[n2][n11]);
                            ++n19;
                        } else if (mathType instanceof RealTupleType) {
                            n3 = ((TupleType)mathType).getDimension();
                            Real[] realArray = new Real[n3];
                            n4 = 0;
                            while (n4 < n3) {
                                realArray[n4] = new Real((RealType)((TupleType)mathType).getComponent(n4), (double)object2[n19][0], unitArray3[n2][n4], errorEstimateArray[n2][n4]);
                                ++n19;
                                ++n4;
                            }
                            dataArray2[n11] = new RealTuple((RealTupleType)mathType, realArray, this.RangeCoordinateSystems[n18]);
                            ++n18;
                        }
                        ++n11;
                    }
                    dataArray[n2] = new Tuple((TupleType)object, dataArray2);
                }
            }
            ++n2;
        }
        if (n5 == 1) {
            return dataArray[0];
        }
        return new Tuple(dataArray);
    }

    public Data derivative(int n) throws VisADException, RemoteException {
        MathType[] mathTypeArray = null;
        RealType[] realTypeArray = null;
        return this.derivative(null, realTypeArray, mathTypeArray, n);
    }

    public Data derivative(MathType[] mathTypeArray, int n) throws VisADException, RemoteException {
        return this.derivative(null, null, mathTypeArray, n);
    }

    public Function derivative(RealType realType, int n) throws VisADException, RemoteException {
        MathType[] mathTypeArray = null;
        RealType[] realTypeArray = new RealType[]{realType};
        return (Function)this.derivative(null, realTypeArray, mathTypeArray, n);
    }

    public Function derivative(RealType realType, MathType mathType, int n) throws VisADException, RemoteException {
        MathType[] mathTypeArray = new MathType[1];
        RealType[] realTypeArray = new RealType[1];
        mathTypeArray[0] = mathType;
        realTypeArray[0] = realType;
        return (Function)this.derivative(null, realTypeArray, mathTypeArray, n);
    }

    public Field resample(Set set, int n, int n2) throws VisADException, RemoteException {
        double[] dArray;
        float[] fArray;
        int n3;
        Object object;
        Object object2;
        int n4;
        boolean bl;
        ErrorEstimate[] errorEstimateArray;
        MathType mathType;
        if (this.DomainSet.equals(set)) {
            return this;
        }
        int n5 = this.DomainSet.getDimension();
        if (n5 != set.getDimension()) {
            throw new SetException("FlatField.resample: bad Set Dimension");
        }
        CoordinateSystem coordinateSystem = set.getCoordinateSystem();
        Unit[] unitArray = set.getSetUnits();
        ErrorEstimate[] errorEstimateArray2 = n2 == 202 ? new ErrorEstimate[n5] : set.getSetErrors();
        Set[] setArray = new Set[this.TupleDimension];
        int n6 = 0;
        while (n6 < this.TupleDimension) {
            mathType = new SetType(((FunctionType)this.Type).getFlatRange().getComponent(n6));
            setArray[n6] = n == 100 ? this.RangeSet[n6] : new FloatSet(mathType);
            ++n6;
        }
        MathType mathType2 = ((FunctionType)this.Type).getRange();
        mathType = ((SetType)set.getType()).getDomain();
        FunctionType functionType = new FunctionType(mathType, mathType2);
        FlatField flatField = new FlatField(functionType, set, this.RangeCoordinateSystem, this.RangeCoordinateSystems, setArray, this.RangeUnits);
        if (this.isMissing()) {
            return flatField;
        }
        ErrorEstimate[] errorEstimateArray3 = errorEstimateArray = n2 == 202 ? new ErrorEstimate[this.TupleDimension] : this.RangeErrors;
        int n7 = set.getLength();
        int[] nArray = set.getWedge();
        float[][] fArray2 = set.indexToValue(nArray);
        ErrorEstimate[] errorEstimateArray4 = new ErrorEstimate[n5];
        float[][] fArray3 = fArray2;
        try {
            fArray2 = CoordinateSystem.transformCoordinates(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errorEstimateArray4, ((SetType)set.getType()).getDomain(), coordinateSystem, unitArray, errorEstimateArray2, fArray2);
        }
        catch (UnitException unitException) {
            throw new VisADException("Sampling set is not compatible with domain");
        }
        boolean bl2 = !(fArray2 == fArray3);
        boolean bl3 = bl = n2 != 202;
        if (bl) {
            n4 = 0;
            while (n4 < n5) {
                if (errorEstimateArray4[n4] == null) {
                    bl = false;
                }
                ++n4;
            }
            boolean bl4 = false;
            n4 = 0;
            while (n4 < this.TupleDimension) {
                if (errorEstimateArray[n4] != null) {
                    bl4 = true;
                }
                ++n4;
            }
            if (!bl4) {
                bl = false;
            }
        }
        float[][] fArray4 = new float[this.TupleDimension][n5];
        float[][] fArray5 = new float[1][1];
        if (bl) {
            fArray5 = Set.doubleToFloat(ErrorEstimate.init_error_values(errorEstimateArray4));
        }
        float[][] fArray6 = null;
        if (bl || 10 * n7 > this.getLength()) {
            fArray6 = this.unpackFloats(false);
        }
        double[][] dArray2 = new double[this.TupleDimension][n7];
        if (n == 101 && this.DomainSet instanceof SimpleSet) {
            float f;
            int n8;
            object2 = new int[n7][];
            object = new float[n7][];
            ((SimpleSet)this.DomainSet).valueToInterp(fArray2, (int[][])object2, (float[][])object);
            if (fArray6 != null) {
                n3 = 0;
                while (n3 < this.TupleDimension) {
                    fArray = fArray6[n3];
                    dArray = dArray2[n3];
                    n4 = 0;
                    while (n4 < n7) {
                        int n9;
                        float f2 = Float.NaN;
                        int n10 = n9 = object2[n4] == null ? 0 : ((int)object2[n4]).length;
                        if (n9 > 0) {
                            f2 = fArray[object2[n4][0]] * object[n4][0];
                            n8 = 1;
                            while (n8 < n9) {
                                f2 += fArray[object2[n4][n8]] * object[n4][n8];
                                ++n8;
                            }
                            dArray[nArray[n4]] = f2;
                        } else {
                            dArray[nArray[n4]] = Double.NaN;
                        }
                        ++n4;
                    }
                    ++n3;
                }
            } else {
                n4 = 0;
                while (n4 < n7) {
                    int n11;
                    int n12 = n11 = object2[n4] == null ? 0 : ((int)object2[n4]).length;
                    if (n11 > 0) {
                        double[][] dArray3 = new double[n11][];
                        n8 = 0;
                        while (n8 < n11) {
                            dArray3[n8] = this.unpackValues((int)object2[n4][n8]);
                            ++n8;
                        }
                        n3 = 0;
                        while (n3 < this.TupleDimension) {
                            f = (float)dArray3[0][n3] * object[n4][0];
                            n8 = 1;
                            while (n8 < n11) {
                                f += (float)dArray3[n8][n3] * object[n4][n8];
                                ++n8;
                            }
                            dArray2[n3][nArray[n4]] = f;
                            ++n3;
                        }
                    } else {
                        n3 = 0;
                        while (n3 < this.TupleDimension) {
                            dArray2[n3][nArray[n4]] = Double.NaN;
                            ++n3;
                        }
                    }
                    ++n4;
                }
            }
            if (bl) {
                int[][] nArray2 = new int[2 * n5][];
                float[][] fArray7 = new float[2 * n5][];
                ((SimpleSet)this.DomainSet).valueToInterp(fArray5, nArray2, fArray7);
                n3 = 0;
                while (n3 < this.TupleDimension) {
                    n4 = 0;
                    while (n4 < n5) {
                        f = Float.NaN;
                        float f3 = Float.NaN;
                        int n13 = nArray2[2 * n4].length;
                        if (n13 > 0) {
                            f = fArray6[n3][nArray2[2 * n4][0]] * fArray7[2 * n4][0];
                            n8 = 1;
                            while (n8 < n13) {
                                f += fArray6[n3][nArray2[2 * n4][n8]] * fArray7[2 * n4][n8];
                                ++n8;
                            }
                        }
                        if ((n13 = nArray2[2 * n4 + 1].length) > 0) {
                            f3 = fArray6[n3][nArray2[2 * n4 + 1][0]] * fArray7[2 * n4 + 1][0];
                            n8 = 1;
                            while (n8 < n13) {
                                f3 += fArray6[n3][nArray2[2 * n4 + 1][n8]] * fArray7[2 * n4 + 1][n8];
                                ++n8;
                            }
                        }
                        fArray4[n3][n4] = Math.abs(f3 - f);
                        ++n4;
                    }
                    ++n3;
                }
            }
        } else {
            object2 = this.DomainSet.valueToIndex(fArray2);
            if (fArray6 != null) {
                n3 = 0;
                while (n3 < this.TupleDimension) {
                    fArray = fArray6[n3];
                    dArray = dArray2[n3];
                    n4 = 0;
                    while (n4 < n7) {
                        dArray[nArray[n4]] = object2[n4] >= 0 ? (double)fArray[object2[n4]] : Double.NaN;
                        ++n4;
                    }
                    ++n3;
                }
            } else {
                n4 = 0;
                while (n4 < n7) {
                    if (object2[n4] >= 0) {
                        object = this.unpackValues(object2[n4]);
                        n3 = 0;
                        while (n3 < this.TupleDimension) {
                            dArray2[n3][nArray[n4]] = (float)object[n3];
                            ++n3;
                        }
                    } else {
                        n3 = 0;
                        while (n3 < this.TupleDimension) {
                            dArray2[n3][nArray[n4]] = Double.NaN;
                            ++n3;
                        }
                    }
                    ++n4;
                }
            }
            if (bl) {
                object = this.DomainSet.valueToIndex(fArray5);
                n3 = 0;
                while (n3 < this.TupleDimension) {
                    n4 = 0;
                    while (n4 < n5) {
                        float f = (float)(object[2 * n4] >= 0 ? (double)fArray6[n3][object[2 * n4]] : Double.NaN);
                        float f4 = (float)(object[2 * n4 + 1] >= 0 ? (double)fArray6[n3][object[2 * n4 + 1]] : Double.NaN);
                        fArray4[n3][n4] = Math.abs(f4 - f);
                        ++n4;
                    }
                    ++n3;
                }
            }
        }
        if (bl) {
            n3 = 0;
            while (n3 < this.TupleDimension) {
                if (errorEstimateArray[n3] != null) {
                    float f = (float)errorEstimateArray[n3].getErrorValue();
                    if (n2 == 200) {
                        f *= f;
                        n4 = 0;
                        while (n4 < n5) {
                            f += fArray4[n3][n4] * fArray4[n3][n4];
                            ++n4;
                        }
                        f = (float)Math.sqrt(f);
                    } else {
                        n4 = 0;
                        while (n4 < n5) {
                            f += fArray4[n3][n4];
                            ++n4;
                        }
                    }
                    errorEstimateArray3[n3] = new ErrorEstimate(dArray2[n3], (double)f, this.RangeUnits[n3]);
                }
                ++n3;
            }
        } else if (n2 != 202) {
            n3 = 0;
            while (n3 < this.TupleDimension) {
                if (errorEstimateArray[n3] != null) {
                    errorEstimateArray3[n3] = new ErrorEstimate(dArray2[n3], errorEstimateArray[n3].getErrorValue(), this.RangeUnits[n3]);
                }
                ++n3;
            }
        }
        if (bl2) {
            errorEstimateArray = errorEstimateArray3;
            MathType mathType3 = ((FunctionType)this.Type).getRange();
            if (mathType3 instanceof RealVectorType) {
                dArray2 = ((RealVectorType)mathType3).transformVectors(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errorEstimateArray4, ((SetType)set.getType()).getDomain(), coordinateSystem, unitArray, this.RangeCoordinateSystem, errorEstimateArray, errorEstimateArray3, Set.floatToDouble(fArray3), Set.floatToDouble(fArray2), dArray2);
            } else if (mathType3 instanceof TupleType && !(mathType3 instanceof RealTupleType)) {
                int n14 = 0;
                int n15 = ((TupleType)mathType3).getDimension();
                n3 = 0;
                while (n3 < n15) {
                    MathType mathType4 = ((TupleType)mathType3).getComponent(n3);
                    if (mathType4 instanceof RealVectorType) {
                        int n16 = ((RealVectorType)mathType4).getDimension();
                        double[][] dArray4 = new double[n16][];
                        int n17 = 0;
                        while (n17 < n16) {
                            dArray4[n17] = dArray2[n14 + n17];
                            ++n17;
                        }
                        ErrorEstimate[] errorEstimateArray5 = new ErrorEstimate[n16];
                        int n18 = 0;
                        while (n18 < n16) {
                            errorEstimateArray5[n18] = errorEstimateArray[n14 + n18];
                            ++n18;
                        }
                        ErrorEstimate[] errorEstimateArray6 = errorEstimateArray5;
                        dArray4 = ((RealVectorType)mathType4).transformVectors(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errorEstimateArray4, ((SetType)set.getType()).getDomain(), coordinateSystem, unitArray, this.RangeCoordinateSystems[n3], errorEstimateArray5, errorEstimateArray6, Set.floatToDouble(fArray3), Set.floatToDouble(fArray2), dArray4);
                        int n19 = 0;
                        while (n19 < n16) {
                            dArray2[n14 + n19] = dArray4[n19];
                            ++n19;
                        }
                        n19 = 0;
                        while (n19 < n16) {
                            errorEstimateArray3[n14 + n19] = errorEstimateArray6[n19];
                            ++n19;
                        }
                    }
                    n14 = mathType4 instanceof RealType ? ++n14 : (n14 += ((RealTupleType)mathType4).getDimension());
                    ++n3;
                }
            }
        }
        flatField.packValues(dArray2, false);
        flatField.setRangeErrors(errorEstimateArray3);
        flatField.clearMissing();
        return flatField;
    }

    public Field convertToField() throws VisADException, RemoteException {
        FieldImpl fieldImpl = new FieldImpl((FunctionType)this.Type, this.DomainSet);
        if (this.isMissing()) {
            return fieldImpl;
        }
        int n = 0;
        while (n < this.Length) {
            fieldImpl.setSample(n, this.getSample(n));
            ++n;
        }
        return fieldImpl;
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow) throws VisADException {
        Serializable serializable;
        int n;
        if (this.isMissing()) {
            return dataShadow;
        }
        ShadowRealTupleType shadowRealTupleType = ((ShadowFunctionType)shadowType).getDomain();
        int n2 = shadowRealTupleType.getDimension();
        double[][] dArray = new double[2][n2];
        dataShadow = this.DomainSet.computeRanges(shadowRealTupleType, dataShadow, dArray, true);
        int[] nArray = ((ShadowFunctionType)shadowType).getRangeDisplayIndices();
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.TupleDimension) {
            if (nArray[n3] >= 0) {
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            return dataShadow;
        }
        int n4 = n3 = this.RangeCoordinateSystem == null ? 0 : 1;
        if (this.RangeCoordinateSystems != null) {
            int n5 = 0;
            while (n5 < this.RangeCoordinateSystems.length) {
                n3 |= this.RangeCoordinateSystems[n5] == null ? 0 : 1;
                ++n5;
            }
        }
        dArray = n3 != 0 ? new double[2][this.TupleDimension] : null;
        double[][] dArray2 = this.unpackValues();
        int n6 = 0;
        while (n6 < this.TupleDimension) {
            double[] dArray3 = dArray2[n6];
            n = nArray[n6];
            if (n >= 0 || n3 != 0) {
                double d = Double.MAX_VALUE;
                double d2 = -1.7976931348623157E308;
                int n7 = 0;
                while (n7 < this.Length) {
                    if (dArray3[n7] == dArray3[n7]) {
                        d = Math.min(d, dArray3[n7]);
                        d2 = Math.max(d2, dArray3[n7]);
                    }
                    ++n7;
                }
                serializable = ((RealType)((FunctionType)this.Type).getFlatRange().getComponent(n6)).getDefaultUnit();
                if (serializable != null && !((Unit)serializable).equals(this.RangeUnits[n6])) {
                    d = ((Unit)serializable).toThis(d, this.RangeUnits[n6]);
                    d2 = ((Unit)serializable).toThis(d2, this.RangeUnits[n6]);
                }
                if (n3 != 0) {
                    dArray[0][n6] = Math.min(dArray[0][n6], d);
                    dArray[1][n6] = Math.max(dArray[1][n6], d2);
                }
                if (n >= 0 && n < dataShadow.ranges[0].length) {
                    dataShadow.ranges[0][n] = Math.min(dataShadow.ranges[0][n], d);
                    dataShadow.ranges[1][n] = Math.max(dataShadow.ranges[1][n], d2);
                }
            }
            ++n6;
        }
        if (this.RangeCoordinateSystem != null) {
            ShadowRealTupleType shadowRealTupleType2 = (ShadowRealTupleType)((ShadowFunctionType)shadowType).getRange();
            ShadowRealTupleType shadowRealTupleType3 = shadowRealTupleType2.getReference();
            dataShadow = this.computeReferenceRanges(shadowRealTupleType2, this.RangeCoordinateSystem, this.RangeUnits, dataShadow, shadowRealTupleType3, dArray);
        } else if (this.RangeCoordinateSystems != null) {
            TupleType tupleType = (TupleType)((FunctionType)this.Type).getRange();
            int n8 = 0;
            n = 0;
            while (n < this.RangeCoordinateSystems.length) {
                MathType mathType = tupleType.getComponent(n);
                if (mathType instanceof RealType) {
                    ++n8;
                } else {
                    int n9 = ((RealTupleType)mathType).getDimension();
                    if (this.RangeCoordinateSystems[n] != null) {
                        double[][] dArray4 = new double[2][n9];
                        Unit[] unitArray = new Unit[n9];
                        int n10 = 0;
                        while (n10 < n9) {
                            dArray4[0][n10] = dArray[0][n8];
                            dArray4[1][n10] = dArray[1][n8];
                            unitArray[n10] = this.RangeUnits[n8];
                            ++n8;
                            ++n10;
                        }
                        serializable = (ShadowRealTupleType)((ShadowTupleType)((ShadowFunctionType)shadowType).getRange()).getComponent(n);
                        ShadowRealTupleType shadowRealTupleType4 = ((ShadowRealTupleType)serializable).getReference();
                        dataShadow = this.computeReferenceRanges((ShadowRealTupleType)serializable, this.RangeCoordinateSystems[n], unitArray, dataShadow, shadowRealTupleType4, dArray4);
                    } else {
                        n8 += n9;
                    }
                }
                ++n;
            }
        }
        return dataShadow;
    }

    public Data adjustSamplingError(Data data, int n) throws VisADException, RemoteException {
        if (this.isMissing() || data == null || data.isMissing()) {
            return this;
        }
        FlatField flatField = new FlatField((FunctionType)this.Type, this.DomainSet, this.RangeCoordinateSystem, this.RangeCoordinateSystems, this.RangeSet, this.RangeUnits);
        if (this.isMissing()) {
            return flatField;
        }
        FlatField flatField2 = (FlatField)((FlatField)data).resample(this.DomainSet, 100, 202);
        double[][] dArray = this.unpackValues();
        flatField.packValues(dArray, false);
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[this.TupleDimension];
        double[][] dArray2 = flatField2.unpackValues();
        int n2 = 0;
        while (n2 < this.TupleDimension) {
            double d = 0.0;
            int n3 = 0;
            while (n3 < dArray2[n2].length) {
                d += dArray2[n2][n3];
                ++n3;
            }
            double d2 = this.RangeErrors[n2].getErrorValue();
            double d3 = n == 200 ? Math.sqrt(d * d + d2 * d2) : Math.abs(d /= (double)dArray2.length) + Math.abs(d2);
            errorEstimateArray[n2] = new ErrorEstimate(dArray[n2], d3, this.RangeUnits[n2]);
            ++n2;
        }
        flatField.setRangeErrors(errorEstimateArray);
        return flatField;
    }

    public boolean isFlatField() {
        return true;
    }

    private FlatField cloneDouble() throws VisADException {
        return this.cloneDouble(this.RangeUnits, this.RangeErrors);
    }

    private FlatField cloneDouble(Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        return this.cloneDouble(null, unitArray, errorEstimateArray);
    }

    private FlatField cloneDouble(MathType mathType, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) throws VisADException {
        Object object;
        MathType mathType2 = mathType == null ? this.Type : mathType;
        Set[] setArray = new Set[this.TupleDimension];
        int n = 0;
        while (n < this.TupleDimension) {
            object = new SetType(((FunctionType)mathType2).getFlatRange().getComponent(n));
            setArray[n] = new DoubleSet((MathType)object);
            ++n;
        }
        FlatField flatField = new FlatField((FunctionType)mathType2, this.DomainSet, this.RangeCoordinateSystem, this.RangeCoordinateSystems, setArray, unitArray);
        object = this.unpackValues();
        flatField.packValues((double[][])object, false);
        flatField.setRangeErrors(errorEstimateArray);
        flatField.clearMissing();
        return flatField;
    }

    private FlatField cloneMissing() throws VisADException {
        return new FlatField((FunctionType)this.Type, this.DomainSet, this.RangeCoordinateSystem, this.RangeCoordinateSystems, this.RangeSet, this.RangeUnits);
    }

    public Object clone() {
        FlatField flatField;
        try {
            flatField = new FlatField((FunctionType)this.Type, this.DomainSet, this.RangeCoordinateSystem, this.RangeCoordinateSystems, this.RangeSet, this.RangeUnits);
            if (this.isMissing()) {
                return flatField;
            }
            double[][] dArray = this.unpackValues();
            flatField.packValues(dArray, true);
            flatField.setRangeErrors(this.RangeErrors);
        }
        catch (VisADException visADException) {
            throw new VisADError("FlatField.clone: VisADException occurred");
        }
        return flatField;
    }

    String valuesString() throws VisADException {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 8 / this.TupleDimension;
        if (n < 1) {
            n = 1;
        }
        int n2 = this.DomainSet instanceof GriddedSet ? ((GriddedSet)this.DomainSet).getLength(0) : this.Length;
        RealTupleType realTupleType = ((FunctionType)this.Type).getFlatRange();
        RealType[] realTypeArray = realTupleType.getRealComponents();
        double[][] dArray = this.unpackValues();
        int n3 = n2;
        int n4 = 0;
        while (n4 < this.Length) {
            int n5 = Math.min(n3, Math.min(n, this.Length - n4));
            int n6 = n4 + n5;
            int n7 = n4;
            while (n7 < n6) {
                Object object;
                if (n7 > n4) {
                    stringBuffer.append(", ");
                }
                if (this.TupleDimension == 1) {
                    stringBuffer.append(new Real(realTypeArray[0], dArray[0][n7], this.RangeUnits[0]).toString());
                } else if (((FunctionType)this.Type).getReal()) {
                    object = "(" + new Real(realTypeArray[0], dArray[0][n7], this.RangeUnits[0]);
                    int n8 = 1;
                    while (n8 < this.TupleDimension) {
                        object = (String)object + ", " + new Real(realTypeArray[n8], dArray[n8][n7], this.RangeUnits[n8]);
                        ++n8;
                    }
                    object = (String)object + ")";
                    stringBuffer.append((String)object);
                } else {
                    object = (TupleType)((FunctionType)this.Type).getRange();
                    String string = "(";
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < ((TupleType)object).getDimension()) {
                        MathType mathType;
                        if (n9 > 0) {
                            string = string + ", ";
                        }
                        if ((mathType = ((TupleType)object).getComponent(n10)) instanceof RealType) {
                            string = string + new Real(realTypeArray[n9], dArray[n9][n7], this.RangeUnits[n9]);
                            ++n9;
                        } else {
                            int n11 = ((TupleType)mathType).getDimension();
                            string = string + "(" + new Real(realTypeArray[n9], dArray[n9][n7], this.RangeUnits[n9]);
                            ++n9;
                            int n12 = 1;
                            while (n12 < n11) {
                                string = string + ", " + new Real(realTypeArray[n9], dArray[n9][n7], this.RangeUnits[n9]);
                                ++n9;
                                ++n12;
                            }
                            string = string + ")";
                        }
                        ++n10;
                    }
                    string = string + ")";
                    stringBuffer.append(string);
                }
                ++n7;
            }
            stringBuffer.append("\n");
            n4 = n6;
            if ((n3 -= n5) > 0) continue;
            n3 = n2;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        try {
            if (this.isMissing()) {
                return "FlatField  missing\n";
            }
            return "FlatField\n    " + this.Type + "\n" + this.valuesString();
        }
        catch (VisADException visADException) {
            return visADException.toString();
        }
    }

    public String longString(String string) throws VisADException {
        String string2 = string + "FlatField\n" + string + "  Type: " + this.Type.toString() + "\n";
        string2 = this.DomainSet != null ? string2 + string + "  DomainSet:\n" + this.DomainSet.longString(string + "    ") : string2 + string + "  DomainSet: undefined\n";
        int n = 0;
        while (n < this.TupleDimension) {
            string2 = this.RangeSet[n] != null ? string2 + string + "  RangeSet[" + n + "]:\n" + this.RangeSet[n].longString(string + "    ") : string2 + string + "  RangeSet[" + n + "]: undefined\n";
            ++n;
        }
        if (this.isMissing()) {
            return string2 + "  missing\n";
        }
        return string2 + this.valuesString();
    }

    public int getRangeDimension() {
        return this.TupleDimension;
    }

    public boolean equals(Object object) {
        int n;
        if (object == null || !(object instanceof FlatField)) {
            return false;
        }
        FlatField flatField = (FlatField)object;
        if (this.RangeMode == null || flatField.RangeMode == null) {
            if (this.RangeMode != null || flatField.RangeMode != null) {
                return false;
            }
        } else {
            if (this.RangeMode.length != flatField.RangeMode.length) {
                return false;
            }
            n = 0;
            while (n < this.RangeMode.length) {
                if (this.RangeMode[n] != flatField.RangeMode[n]) {
                    return false;
                }
                ++n;
            }
        }
        if (this.RangeSet == null || flatField.RangeSet == null) {
            if (this.RangeSet != null || flatField.RangeSet != null) {
                return false;
            }
        } else {
            if (this.RangeSet.length != flatField.RangeSet.length) {
                return false;
            }
            n = 0;
            while (n < this.RangeSet.length) {
                if (!this.RangeSet[n].equals(flatField.RangeSet[n])) {
                    return false;
                }
                ++n;
            }
        }
        return super.equals(object);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FlatField makeField(FunctionType functionType, int n, boolean bl) throws VisADException, RemoteException {
        void var15_19;
        double d = 0.0;
        double d2 = (double)n - 1.0;
        double d3 = 1.0;
        double d4 = 0.5 * d2;
        RealTupleType realTupleType = functionType.getDomain();
        RealTupleType realTupleType2 = functionType.getFlatRange();
        int n2 = realTupleType.getDimension();
        int n3 = realTupleType2.getDimension();
        Object var15_11 = null;
        int n4 = 0;
        Random random = new Random();
        if (bl) {
            if (n2 == 1) {
                n4 = n;
                float[][] fArray = new float[1][n4];
                int n5 = 0;
                while (n5 < n4) {
                    fArray[0][n5] = (float)(d2 * (double)random.nextFloat());
                    ++n5;
                }
                Irregular1DSet irregular1DSet = new Irregular1DSet((MathType)realTupleType, fArray);
            } else if (n2 == 2) {
                n4 = n * n;
                float[][] fArray = new float[2][n4];
                int n6 = 0;
                while (n6 < n4) {
                    fArray[0][n6] = (float)(d2 * (double)random.nextFloat());
                    fArray[1][n6] = (float)(d2 * (double)random.nextFloat());
                    ++n6;
                }
                Irregular2DSet irregular2DSet = new Irregular2DSet((MathType)realTupleType, fArray);
            } else {
                if (n2 != 3) throw new FieldException("FlatField.makeField: bad domain dimension");
                n4 = n * n * n;
                float[][] fArray = new float[3][n4];
                int n7 = 0;
                while (n7 < n4) {
                    fArray[0][n7] = (float)(d2 * (double)random.nextFloat());
                    fArray[1][n7] = (float)(d2 * (double)random.nextFloat());
                    fArray[2][n7] = (float)(d2 * (double)random.nextFloat());
                    ++n7;
                }
                Irregular3DSet irregular3DSet = new Irregular3DSet((MathType)realTupleType, fArray);
            }
        } else if (n2 == 1) {
            Linear1DSet linear1DSet = new Linear1DSet((MathType)realTupleType, d, d2, n);
            n4 = n;
        } else if (n2 == 2) {
            Linear2DSet linear2DSet = new Linear2DSet((MathType)realTupleType, d, d2, n, d, d2, n);
            n4 = n * n;
        } else {
            if (n2 != 3) throw new FieldException("FlatField.makeField: bad domain dimension");
            Linear3DSet linear3DSet = new Linear3DSet((MathType)realTupleType, d, d2, n, d, d2, n, d, d2, n);
            n4 = n * n * n;
        }
        FlatField flatField = new FlatField(functionType, (Set)var15_19);
        FlatField.fillField(flatField, d3, d4);
        return flatField;
    }

    public static void fillField(FlatField flatField, double d, double d2) throws VisADException, RemoteException {
        Random random = new Random();
        FunctionType functionType = (FunctionType)flatField.getType();
        RealTupleType realTupleType = functionType.getDomain();
        RealTupleType realTupleType2 = functionType.getFlatRange();
        int n = realTupleType.getDimension();
        int n2 = realTupleType2.getDimension();
        SampledSet sampledSet = (SampledSet)flatField.getDomainSet();
        int n3 = sampledSet.getLength();
        double[][] dArray = new double[n2][n3];
        float[][] fArray = sampledSet.getSamples();
        int n4 = 0;
        while (n4 < n2) {
            float f;
            float f2;
            int n5;
            if (n == 1) {
                n5 = 0;
                while (n5 < n3) {
                    f2 = fArray[0][n5];
                    dArray[n4][n5] = n4 == 0 ? (double)((float)Math.abs(d * ((double)f2 - d2))) : (n4 == 1 ? (double)f2 : random.nextDouble());
                    ++n5;
                }
            } else if (n == 2) {
                n5 = 0;
                while (n5 < n3) {
                    f2 = fArray[0][n5];
                    f = fArray[1][n5];
                    dArray[n4][n5] = n4 == 0 ? (double)((float)(d * Math.sqrt(((double)f2 - d2) * ((double)f2 - d2) + ((double)f - d2) * ((double)f - d2)))) : (n4 == 1 ? (double)f2 : (n4 == 2 ? (double)f : random.nextDouble()));
                    ++n5;
                }
            } else if (n == 3) {
                n5 = 0;
                while (n5 < n3) {
                    f2 = fArray[0][n5];
                    f = fArray[1][n5];
                    float f3 = fArray[2][n5];
                    dArray[n4][n5] = n4 == 0 ? (double)((float)(d * Math.sqrt(((double)f2 - d2) * ((double)f2 - d2) + ((double)f - d2) * ((double)f - d2) + ((double)f3 - d2) * ((double)f3 - d2)))) : (n4 == 1 ? (double)f2 : (n4 == 2 ? (double)f : (n4 == 3 ? (double)f3 : random.nextDouble())));
                    ++n5;
                }
            }
            ++n4;
        }
        flatField.setSamples(dArray);
    }

    public static FlatField makeField1(FunctionType functionType, double d, double d2, int n, double d3, double d4, int n2) throws VisADException, RemoteException {
        double d5 = (d2 - d) / (double)(n - 1);
        double d6 = (d4 - d3) / (double)(n2 - 1);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)functionType.getDomain(), d, d2, n, d3, d4, n2);
        FlatField flatField = new FlatField(functionType, linear2DSet);
        double[][] dArray = new double[1][n * n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[0][n3 + n * n4] = d + d5 * (double)n3 + (d3 + d6 * (double)n4);
                ++n4;
            }
            ++n3;
        }
        flatField.setSamples(dArray);
        return flatField;
    }

    public static FlatField makeField2(FunctionType functionType, double d, double d2, int n, double d3, double d4, int n2) throws VisADException, RemoteException {
        double d5 = (d2 - d) / (double)(n - 1);
        double d6 = (d4 - d3) / (double)(n2 - 1);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)functionType.getDomain(), d, d2, n, d3, d4, n2);
        FlatField flatField = new FlatField(functionType, linear2DSet);
        double[][] dArray = new double[2][n * n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[0][n3 + n * n4] = d + d5 * (double)n3;
                dArray[1][n3 + n * n4] = d3 + d6 * (double)n4;
                ++n4;
            }
            ++n3;
        }
        flatField.setSamples(dArray);
        return flatField;
    }

    static FlatField makeRandomField2(FunctionType functionType, double d, double d2, int n, double d3, double d4, int n2) throws VisADException, RemoteException {
        double d5 = (d2 - d) / (double)(n - 1);
        double d6 = (d4 - d3) / (double)(n2 - 1);
        Linear2DSet linear2DSet = new Linear2DSet((MathType)functionType.getDomain(), d, d2, n, d3, d4, n2);
        FlatField flatField = new FlatField(functionType, linear2DSet);
        Random random = new Random();
        double[][] dArray = new double[2][n * n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray[0][n3 + n * n4] = random.nextDouble();
                dArray[1][n3 + n * n4] = random.nextDouble();
                ++n4;
            }
            ++n3;
        }
        flatField.setSamples(dArray);
        return flatField;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        int n = 10;
        Real real = new Real(n);
        RealType realType = new RealType("X", null, null);
        RealType realType2 = new RealType("Y", null, null);
        RealType realType3 = new RealType("Z", null, null);
        RealType realType4 = new RealType("A", null, null);
        RealType realType5 = new RealType("B", null, null);
        RealType[] realTypeArray = new RealType[]{realType, realType2};
        RealTupleType realTupleType = new RealTupleType(realTypeArray, null, null);
        Integer2DSet integer2DSet = new Integer2DSet((MathType)realTupleType, 4, 4);
        realTupleType.setDefaultSet(integer2DSet);
        RealType[] realTypeArray2 = new RealType[]{realType4, realType5};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        FunctionType functionType = new FunctionType(realTupleType, realType4);
        FunctionType functionType2 = new FunctionType(realTupleType, realTupleType2);
        double d = 0.0;
        double d2 = 3.0;
        int n2 = 4;
        double d3 = 0.0;
        double d4 = 3.0;
        int n3 = 4;
        FlatField flatField = FlatField.makeField1(functionType, d, d2, n2, d3, d4, n3);
        FlatField flatField2 = FlatField.makeField2(functionType2, d, d2, n2, d3, d4, n3);
        Real[] realArray = new Real[]{new Real(realType, 1.5), new Real(realType2, 2.5)};
        RealTuple realTuple = new RealTuple(realArray);
        double d5 = 0.0;
        double d6 = 3.0;
        int n4 = 7;
        double d7 = 0.0;
        double d8 = 3.0;
        int n5 = 7;
        FlatField flatField3 = FlatField.makeField1(functionType, d5, d6, n4, d7, d8, n5);
        FlatField flatField4 = FlatField.makeField2(functionType2, d5, d6, n4, d7, d8, n5);
        System.out.println("image1 = " + flatField);
        System.out.println("image2 = " + flatField3);
        System.out.println("image3 = " + flatField2);
        System.out.println("image4 = " + flatField4);
        System.out.println("sampling mode is NEAREST_NEIGHBOR");
        System.out.println("image3 + image4 = " + flatField2.add(flatField4));
        System.out.println("image4 - image3 = " + flatField4.subtract(flatField2));
        System.out.println("image3 * image4 = " + flatField2.multiply(flatField4));
        System.out.println("image4 / image3 = " + flatField4.divide(flatField2));
        System.out.println("sqrt(image3) = " + flatField2.sqrt());
        System.out.println("val = " + realTuple + " image1(val) = " + flatField.evaluate(realTuple));
        System.out.println("val = " + realTuple + " image3(val) = " + flatField2.evaluate(realTuple) + "\n");
        System.out.println("image3 + val = " + flatField2.add(realTuple));
        System.out.println("val - image3 = " + realTuple.subtract(flatField2));
        System.out.println("image3 * val = " + flatField2.multiply(realTuple));
        System.out.println("val / image3 = " + realTuple.divide(flatField2));
        System.out.println("Field.Mode is WEIGHTED_AVERAGE");
        System.out.println("image3 + image4 = " + flatField2.add(flatField4, 101, 200));
        System.out.println("image4 - image3 = " + flatField4.subtract(flatField2, 101, 200));
        System.out.println("image3 * image4 = " + flatField2.multiply(flatField4, 101, 200));
        System.out.println("image4 / image3 = " + flatField4.divide(flatField2, 101, 200));
        System.out.println("val = " + realTuple + " image1(val) = " + flatField.evaluate(realTuple, 101, 200));
        System.out.println("val = " + realTuple + " image3(val) = " + flatField2.evaluate(realTuple, 101, 200) + "\n");
        System.out.println("image3 + val = " + flatField2.add(realTuple, 101, 200));
        System.out.println("val - image3 = " + realTuple.subtract(flatField2, 101, 200));
        System.out.println("image3 * val = " + flatField2.multiply(realTuple, 101, 200));
        System.out.println("val / image3 = " + realTuple.divide(flatField2, 101, 200));
        System.out.println("sampling mode is NEAREST_NEIGHBOR");
        System.out.println("image1 + w = " + flatField.add(real));
        System.out.println("image1 - w = " + flatField.subtract(real));
        System.out.println("image1 * w = " + flatField.multiply(real));
        System.out.println("image1 / w = " + flatField.divide(real));
        System.out.println("w + image2 = " + real.add(flatField3));
        System.out.println("w - image2 = " + real.subtract(flatField3));
        System.out.println("w * image2 = " + real.multiply(flatField3));
        System.out.println("w / image2 = " + real.divide(flatField3));
        RealType[] realTypeArray3 = new RealType[]{realType4, RealType.Time};
        RealTupleType realTupleType3 = new RealTupleType(realTypeArray3);
        FunctionType functionType3 = new FunctionType(realTupleType, realTupleType3);
        FlatField flatField5 = FlatField.makeField2(functionType3, d, d2, n2, d3, d4, n3);
        System.out.println("imaget = " + flatField5);
    }

    public FlatField(FunctionType functionType) throws VisADException {
        this(functionType, functionType.getDomain().getDefaultSet(), null, null, null, null);
    }

    public FlatField(FunctionType functionType, Set set) throws VisADException {
        this(functionType, set, null, null, null, null);
    }

    public FlatField(FunctionType functionType, Set set, CoordinateSystem coordinateSystem, Set[] setArray, Unit[] unitArray) throws VisADException {
        this(functionType, set, coordinateSystem, null, setArray, unitArray);
    }

    public FlatField(FunctionType functionType, Set set, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray) throws VisADException {
        this(functionType, set, null, coordinateSystemArray, setArray, unitArray);
    }

    public FlatField(FunctionType functionType, Set set, CoordinateSystem coordinateSystem, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray) throws VisADException {
        super(functionType, set);
        int n;
        if (!functionType.getFlat()) {
            throw new FieldException("FlatField: FunctionType must be Flat");
        }
        MathType mathType = functionType.getRange();
        RealTupleType realTupleType = functionType.getFlatRange();
        this.TupleDimension = realTupleType.getDimension();
        this.DoubleRange = new double[this.TupleDimension][];
        this.RangeSet = new Set[this.TupleDimension];
        this.RangeMode = new int[this.TupleDimension];
        if (setArray == null) {
            n = 0;
            while (n < this.TupleDimension) {
                this.RangeSet[n] = ((RealType)realTupleType.getComponent(n)).getDefaultSet();
                if (this.RangeSet[n] == null) {
                    this.RangeSet[n] = new FloatSet(new SetType(realTupleType.getComponent(n)));
                }
                ++n;
            }
        } else {
            if (this.TupleDimension != setArray.length) {
                throw new SetException("FlatField: range set dimensions don't match");
            }
            n = 0;
            while (n < this.TupleDimension) {
                if (setArray[n] == null || setArray[n].getDimension() != 1) {
                    throw new SetException("FlatField: each range set dimension must be 1");
                }
                ++n;
            }
            n = 0;
            while (n < this.TupleDimension) {
                this.RangeSet[n] = realTupleType.getComponent(n).equals(((SetType)setArray[n].getType()).getDomain()) ? setArray[n] : (Set)setArray[n].cloneButType(new SetType(realTupleType.getComponent(n)));
                ++n;
            }
        }
        this.nullRanges();
        if (functionType.getReal()) {
            if (coordinateSystemArray != null) {
                throw new CoordinateSystemException("FlatField: Real Function Type requires single range coordinate system");
            }
            this.RangeCoordinateSystems = null;
            this.RangeCoordinateSystem = realTupleType.getCoordinateSystem();
            if (coordinateSystem != null) {
                if (!(mathType instanceof RealTupleType)) {
                    throw new CoordinateSystemException("FlatField: range_coord_sys supplied, but RangeType is not RealTupleType");
                }
                if (this.RangeCoordinateSystem == null || !this.RangeCoordinateSystem.getReference().equals(coordinateSystem.getReference())) {
                    throw new CoordinateSystemException("FlatField: range_coord_sys " + (coordinateSystem == null ? null : coordinateSystem.getReference()) + " must match" + " default range CoordinateSystem " + (this.RangeCoordinateSystem == null ? null : this.RangeCoordinateSystem.getReference()));
                }
                this.RangeCoordinateSystem = coordinateSystem;
            }
            if (unitArray == null) {
                this.RangeUnits = this.RangeCoordinateSystem == null ? realTupleType.getDefaultUnits() : this.RangeCoordinateSystem.getCoordinateSystemUnits();
            } else {
                if (unitArray.length != this.TupleDimension) {
                    throw new UnitException("FlatField: units dimension does not match");
                }
                this.RangeUnits = new Unit[this.TupleDimension];
                int n2 = 0;
                while (n2 < this.TupleDimension) {
                    RealType realType = (RealType)realTupleType.getComponent(n2);
                    Unit unit = unitArray[n2];
                    this.RangeUnits[n2] = unit == null || !realType.isInterval() ? unit : unit.getAbsoluteUnit();
                    ++n2;
                }
            }
            Unit[] unitArray2 = mathType instanceof RealTupleType ? ((RealTupleType)mathType).getDefaultUnits() : new Unit[]{((RealType)mathType).getDefaultUnit()};
            if (this.RangeCoordinateSystem != null && !Unit.canConvertArray(this.RangeCoordinateSystem.getCoordinateSystemUnits(), unitArray2)) {
                throw new UnitException("FlatField: RangeCoordinateSystem Units must be convertable with RangeType default Units");
            }
            if (this.RangeCoordinateSystem != null && !Unit.canConvertArray(this.RangeCoordinateSystem.getCoordinateSystemUnits(), this.RangeUnits)) {
                throw new UnitException("FlatField: RangeUnits must be convertable with RangeCoordinateSystem Units");
            }
            if (!Unit.canConvertArray(unitArray2, this.RangeUnits)) {
                throw new UnitException("FlatField: RangeUnits must be convertable with RangeType default Units");
            }
        } else {
            Serializable serializable;
            MathType mathType2;
            if (coordinateSystem != null) {
                throw new CoordinateSystemException("FlatField: non-Real Function Type requires multiple range coordinate systems");
            }
            this.RangeCoordinateSystem = null;
            int n3 = ((TupleType)mathType).getDimension();
            this.RangeCoordinateSystems = new CoordinateSystem[n3];
            int n4 = 0;
            while (n4 < n3) {
                mathType2 = ((TupleType)mathType).getComponent(n4);
                if (mathType2 instanceof RealTupleType) {
                    this.RangeCoordinateSystems[n4] = ((RealTupleType)mathType2).getCoordinateSystem();
                    if (coordinateSystemArray != null && coordinateSystemArray[n4] != null) {
                        if (this.RangeCoordinateSystems[n4] == null || this.RangeCoordinateSystems[n4].getReference() != coordinateSystemArray[n4].getReference()) {
                            throw new TypeException("FlatField: range_coord_syses must match Range DefaultCoordinateSystem");
                        }
                        this.RangeCoordinateSystems[n4] = coordinateSystemArray[n4];
                    }
                } else {
                    this.RangeCoordinateSystems[n4] = null;
                }
                ++n4;
            }
            if (unitArray == null) {
                this.RangeUnits = realTupleType.getDefaultUnits();
                n4 = 0;
                int n5 = 0;
                while (n5 < n3) {
                    if (this.RangeCoordinateSystems[n5] != null) {
                        Unit[] unitArray3 = this.RangeCoordinateSystems[n5].getCoordinateSystemUnits();
                        int n6 = 0;
                        while (n6 < unitArray3.length) {
                            this.RangeUnits[n4 + n6] = unitArray3[n6];
                            ++n6;
                        }
                    }
                    if ((serializable = ((TupleType)mathType).getComponent(n5)) instanceof RealType) {
                        ++n4;
                    } else if (serializable instanceof RealTupleType) {
                        n4 += ((RealTupleType)serializable).getDimension();
                    }
                    ++n5;
                }
            } else {
                if (unitArray.length != this.TupleDimension) {
                    throw new UnitException("FlatField: units dimension does not match");
                }
                this.RangeUnits = new Unit[this.TupleDimension];
                n4 = 0;
                while (n4 < this.TupleDimension) {
                    mathType2 = (RealType)realTupleType.getComponent(n4);
                    serializable = unitArray[n4];
                    this.RangeUnits[n4] = serializable == null || !((RealType)mathType2).isInterval() ? serializable : ((Unit)serializable).getAbsoluteUnit();
                    ++n4;
                }
            }
            n4 = 0;
            int n7 = 0;
            while (n7 < n3) {
                Unit[] unitArray4;
                int n8;
                Unit[] unitArray5;
                MathType mathType3 = ((TupleType)mathType).getComponent(n7);
                if (mathType3 instanceof RealTupleType) {
                    unitArray5 = ((RealTupleType)mathType3).getDefaultUnits();
                    n8 = ((RealTupleType)mathType3).getDimension();
                    unitArray4 = new Unit[n8];
                    int n9 = 0;
                    while (n9 < n8) {
                        unitArray4[n9] = this.RangeUnits[n4 + n9];
                        ++n9;
                    }
                } else {
                    unitArray5 = new Unit[]{((RealType)mathType3).getDefaultUnit()};
                    n8 = 1;
                    unitArray4 = new Unit[]{this.RangeUnits[n4]};
                }
                if (this.RangeCoordinateSystems[n7] != null && !Unit.canConvertArray(unitArray5, this.RangeCoordinateSystems[n7].getCoordinateSystemUnits())) {
                    throw new UnitException("FlatField: RangeCoordinateSystems Units must be convertable with RangeType default Units");
                }
                if (this.RangeCoordinateSystems[n7] != null && !Unit.canConvertArray(unitArray4, this.RangeCoordinateSystems[n7].getCoordinateSystemUnits())) {
                    throw new UnitException("FlatField: RangeUnits must be convertable with RangeCoordinateSystems Units");
                }
                if (!Unit.canConvertArray(unitArray5, unitArray4)) {
                    throw new UnitException("FlatField: RangeUnits must be convertable with RangeType default Units");
                }
                n4 += n8;
                ++n7;
            }
        }
        if (this.RangeUnits == null) {
            this.RangeUnits = new Unit[this.TupleDimension];
        }
        this.RangeErrors = new ErrorEstimate[this.TupleDimension];
        this.MissingFlag = true;
    }
}

