/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataShadow;
import visad.DomainException;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldEnumerator;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.Function;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.GriddedSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.SampledSet;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleIface;
import visad.TupleType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.UnitException;
import visad.VisADError;
import visad.VisADException;

public class FieldImpl
extends FunctionImpl
implements Field {
    Set DomainSet;
    CoordinateSystem DomainCoordinateSystem;
    Unit[] DomainUnits;
    int Length;
    private Data[] Range;
    private boolean MissingFlag;

    public void setSamples(Data[] dataArray, boolean bl) throws VisADException, RemoteException {
        if (dataArray == null) {
            this.Range = new Data[this.Length];
            this.MissingFlag = true;
            return;
        }
        if (dataArray.length != this.Length) {
            throw new FieldException("FieldImpl.setSamples: bad array length");
        }
        Data[] dataArray2 = this.Range;
        synchronized (dataArray2) {
            this.MissingFlag = false;
            MathType mathType = ((FunctionType)this.Type).getRange();
            int n = 0;
            while (n < this.Length) {
                if (dataArray[n] != null) {
                    if (!mathType.equals(dataArray[n].getType())) {
                        throw new TypeException("FieldImpl.setSamples: types don't match");
                    }
                    this.Range[n] = bl ? (Data)dataArray[n].dataClone() : dataArray[n];
                } else {
                    this.Range[n] = null;
                }
                ++n;
            }
            n = 0;
            while (n < this.Length) {
                if (this.Range[n] instanceof DataImpl) {
                    ((DataImpl)this.Range[n]).setParent(this);
                }
                ++n;
            }
        }
        this.notifyReferences();
    }

    public Set getDomainSet() {
        return this.DomainSet;
    }

    public int getLength() {
        return this.Length;
    }

    public Unit[] getDomainUnits() {
        return this.DomainUnits;
    }

    public CoordinateSystem getDomainCoordinateSystem() {
        return this.DomainCoordinateSystem;
    }

    public String[][] getStringValues() throws VisADException, RemoteException {
        TextType[] textTypeArray = ((FunctionType)this.Type).getTextComponents();
        if (textTypeArray == null) {
            return null;
        }
        int[] nArray = ((FunctionType)this.Type).getTextIndices();
        int n = textTypeArray.length;
        int n2 = this.getLength();
        String[][] stringArray = new String[n][n2];
        if (this.isMissing()) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    stringArray[n3][n4] = "";
                    ++n4;
                }
                ++n3;
            }
            return stringArray;
        }
        MathType mathType = ((FunctionType)this.Type).getRange();
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                Data data = this.Range[n5];
                if (data == null || data.isMissing()) {
                    n6 = 0;
                    while (n6 < n) {
                        stringArray[n6][n5] = "";
                        ++n6;
                    }
                } else if (mathType instanceof TextType) {
                    stringArray[0][n5] = ((Text)data).getValue();
                } else if (mathType instanceof TupleType) {
                    n6 = 0;
                    while (n6 < n) {
                        Text text = (Text)((TupleIface)data).getComponent(nArray[n6]);
                        stringArray[n6][n5] = text.getValue();
                        ++n6;
                    }
                }
                ++n5;
            }
        }
        return stringArray;
    }

    public float[][] getFloats() throws VisADException, RemoteException {
        return this.getFloats(true);
    }

    public float[][] getFloats(boolean bl) throws VisADException, RemoteException {
        return Set.doubleToFloat(this.getValues(bl));
    }

    public double[][] getValues() throws VisADException, RemoteException {
        return this.getValues(true);
    }

    public double[][] getValues(boolean bl) throws VisADException, RemoteException {
        RealType[] realTypeArray = ((FunctionType)this.Type).getRealComponents();
        if (realTypeArray == null) {
            return null;
        }
        int n = realTypeArray.length;
        Unit[] unitArray = this.getDefaultRangeUnits();
        int n2 = this.getLength();
        double[][] dArray = new double[n][n2];
        if (this.isMissing()) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    dArray[n3][n4] = Double.NaN;
                    ++n4;
                }
                ++n3;
            }
            return dArray;
        }
        MathType mathType = ((FunctionType)this.Type).getRange();
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            int n5 = 0;
            while (n5 < n2) {
                int n6;
                Data data = this.Range[n5];
                if (data == null || data.isMissing()) {
                    n6 = 0;
                    while (n6 < n) {
                        dArray[n6][n5] = Double.NaN;
                        ++n6;
                    }
                } else if (mathType instanceof RealType) {
                    dArray[0][n5] = ((Real)data).getValue(unitArray[0]);
                } else if (mathType instanceof TupleType) {
                    n6 = 0;
                    int n7 = 0;
                    while (n7 < ((TupleType)mathType).getDimension()) {
                        MathType mathType2 = ((TupleType)mathType).getComponent(n7);
                        Data data2 = ((TupleIface)data).getComponent(n7);
                        if (mathType2 instanceof RealType) {
                            dArray[n6][n5] = ((Real)data2).getValue(unitArray[n6]);
                            ++n6;
                        } else if (mathType2 instanceof RealTupleType) {
                            int n8 = 0;
                            while (n8 < ((TupleType)mathType2).getDimension()) {
                                Data data3 = ((TupleIface)data2).getComponent(n8);
                                dArray[n6][n5] = ((Real)data3).getValue(unitArray[n6]);
                                ++n6;
                                ++n8;
                            }
                        }
                        ++n7;
                    }
                }
                ++n5;
            }
        }
        return dArray;
    }

    public void setSamples(double[][] dArray) throws VisADException, RemoteException {
        RealType[] realTypeArray = ((FunctionType)this.Type).getRealComponents();
        if (!((FunctionType)this.Type).getFlat()) {
            throw new FieldException("FieldImpl.setSamples: not Flat range");
        }
        if (realTypeArray == null) {
            throw new FieldException("FieldImpl.setSamples: no Real components");
        }
        int n = realTypeArray.length;
        int n2 = this.getLength();
        if (dArray == null || dArray.length != n) {
            throw new FieldException("FieldImpl.setSamples: bad tuple length");
        }
        if (dArray[0] == null || dArray[0].length != n2) {
            throw new FieldException("FieldImpl.setSamples: bad array length");
        }
        Unit[] unitArray = this.getDefaultRangeUnits();
        MathType mathType = ((FunctionType)this.Type).getRange();
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            if (mathType instanceof RealType) {
                int n3 = 0;
                while (n3 < n2) {
                    this.Range[n3] = new Real((RealType)mathType, dArray[0][n3], unitArray[0]);
                    ++n3;
                }
            } else if (mathType instanceof RealTupleType) {
                int n4 = ((RealTupleType)mathType).getDimension();
                Real[] realArray = new Real[n4];
                int n5 = 0;
                while (n5 < n2) {
                    int n6 = 0;
                    while (n6 < n4) {
                        RealType realType = (RealType)((RealTupleType)mathType).getComponent(n6);
                        realArray[n6] = new Real(realType, dArray[n6][n5], unitArray[n6]);
                        ++n6;
                    }
                    this.Range[n5] = new RealTuple(realArray);
                    ++n5;
                }
            } else if (mathType instanceof TupleType) {
                int n7 = ((TupleType)mathType).getDimension();
                Data[] dataArray2 = new Real[n7];
                MathType[] mathTypeArray = new MathType[n7];
                int n8 = 0;
                while (n8 < n7) {
                    mathTypeArray[n8] = ((TupleType)mathType).getComponent(n8);
                    ++n8;
                }
                n8 = 0;
                while (n8 < n2) {
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < n7) {
                        if (mathTypeArray[n10] instanceof RealType) {
                            dataArray2[n10] = new Real((RealType)mathTypeArray[n10], dArray[n9][n8], unitArray[n9]);
                            ++n9;
                        } else {
                            int n11 = ((RealTupleType)mathTypeArray[n10]).getDimension();
                            Real[] realArray = new Real[n11];
                            int n12 = 0;
                            while (n12 < n11) {
                                RealType realType = (RealType)((RealTupleType)mathTypeArray[n10]).getComponent(n12);
                                realArray[n12] = new Real(realType, dArray[n9][n8], unitArray[n9]);
                                ++n9;
                                ++n12;
                            }
                            dataArray2[n10] = new RealTuple(realArray);
                        }
                        ++n10;
                    }
                    this.Range[n8] = new Tuple(dataArray2);
                    ++n8;
                }
            }
        }
    }

    public void setSamples(float[][] fArray) throws VisADException, RemoteException {
        this.setSamples(Set.floatToDouble(fArray));
    }

    public Unit[][] getRangeUnits() throws VisADException, RemoteException {
        RealType[] realTypeArray = ((FunctionType)this.Type).getRealComponents();
        if (realTypeArray == null) {
            return null;
        }
        int n = realTypeArray.length;
        Unit[][] unitArray = new Unit[n][this.Length];
        Unit[] unitArray2 = this.getDefaultRangeUnits();
        MathType mathType = ((FunctionType)this.Type).getRange();
        int n2 = 0;
        while (n2 < this.Length) {
            int n3;
            Data data = this.Range[n2];
            if (data == null || data.isMissing()) {
                n3 = 0;
                while (n3 < n) {
                    unitArray[n3][n2] = unitArray2[n3];
                    ++n3;
                }
            } else if (mathType instanceof RealType) {
                unitArray[0][n2] = ((Real)data).getUnit();
            } else if (mathType instanceof TupleType) {
                n3 = 0;
                int n4 = 0;
                while (n4 < ((TupleType)mathType).getDimension()) {
                    MathType mathType2 = ((TupleType)mathType).getComponent(n2);
                    Data data2 = ((TupleIface)data).getComponent(n4);
                    if (mathType2 instanceof RealType) {
                        unitArray[n3][n2] = ((Real)data2).getUnit();
                        ++n3;
                    } else if (mathType2 instanceof RealTupleType) {
                        int n5 = 0;
                        while (n5 < ((TupleType)mathType2).getDimension()) {
                            Data data3 = ((TupleIface)data2).getComponent(n5);
                            unitArray[n3][n2] = ((Real)data3).getUnit();
                            ++n3;
                            ++n5;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return unitArray;
    }

    public CoordinateSystem[] getRangeCoordinateSystem() throws VisADException, RemoteException {
        MathType mathType = ((FunctionType)this.Type).getRange();
        if (!(mathType instanceof RealTupleType)) {
            throw new TypeException("FieldImpl.getRangeCoordinateSystem: Range is not RealTupleType");
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[this.Length];
        CoordinateSystem coordinateSystem = ((RealTupleType)mathType).getCoordinateSystem();
        int n = 0;
        while (n < this.Length) {
            Data data = this.Range[n];
            coordinateSystemArray[n] = data == null || data.isMissing() ? coordinateSystem : ((RealTuple)data).getCoordinateSystem();
            ++n;
        }
        return coordinateSystemArray;
    }

    public CoordinateSystem[] getRangeCoordinateSystem(int n) throws VisADException, RemoteException {
        MathType mathType = ((FunctionType)this.Type).getRange();
        if (!(mathType instanceof TupleType) || mathType instanceof RealTupleType) {
            throw new TypeException("FieldImpl.getRangeCoordinateSystem: Range must be TupleType but not RealTupleType");
        }
        MathType mathType2 = ((TupleType)mathType).getComponent(n);
        if (!(mathType2 instanceof RealTupleType)) {
            throw new TypeException("FieldImpl.getRangeCoordinateSystem: selected Range component must be RealTupleType");
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[this.Length];
        CoordinateSystem coordinateSystem = ((RealTupleType)mathType2).getCoordinateSystem();
        int n2 = 0;
        while (n2 < this.Length) {
            Data data;
            Data data2 = this.Range[n2];
            coordinateSystemArray[n2] = data2 == null || data2.isMissing() ? coordinateSystem : ((data = ((TupleIface)data2).getComponent(n)) == null || data.isMissing() ? coordinateSystem : ((RealTuple)data).getCoordinateSystem());
            ++n2;
        }
        return coordinateSystemArray;
    }

    public Unit[] getDefaultRangeUnits() {
        RealType[] realTypeArray = ((FunctionType)this.Type).getRealComponents();
        if (realTypeArray == null) {
            return null;
        }
        int n = realTypeArray.length;
        Unit[] unitArray = new Unit[n];
        int n2 = 0;
        while (n2 < n) {
            unitArray[n2] = realTypeArray[n2].getDefaultUnit();
            ++n2;
        }
        return unitArray;
    }

    public Data getSample(int n) throws VisADException, RemoteException {
        return this.getSample(n, false);
    }

    public Data getSample(int n, boolean bl) throws VisADException, RemoteException {
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            if (this.isMissing() || n < 0 || n >= this.Length || this.Range[n] == null) {
                Data data = ((FunctionType)this.Type).getRange().missingData();
                Object var4_6 = null;
                return data;
            }
            Data data = this.Range[n];
            Object var4_7 = null;
            return data;
        }
    }

    public void setSample(RealTuple realTuple, Data data, boolean bl) throws VisADException, RemoteException {
        if (this.DomainSet == null) {
            throw new FieldException("FieldImpl.setSample: DomainSet undefined");
        }
        if (!((FunctionType)this.Type).getDomain().equals(realTuple.getType())) {
            throw new TypeException("FieldImpl.setSample: bad domain type");
        }
        int n = this.DomainSet.getDimension();
        double[][] dArray = new double[n][1];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2][0] = ((Real)realTuple.getComponent(n2)).getValue();
            ++n2;
        }
        int[] nArray = this.DomainSet.doubleToIndex(dArray);
        this.setSample(nArray[0], data, bl);
    }

    public void setSample(RealTuple realTuple, Data data) throws VisADException, RemoteException {
        this.setSample(realTuple, data, true);
    }

    public void setSample(int n, Data data) throws VisADException, RemoteException {
        this.setSample(n, data, true);
    }

    public void setSample(int n, Data data, boolean bl) throws VisADException, RemoteException {
        if (this.DomainSet == null) {
            throw new FieldException("FieldImpl.setSample: DomainSet undefined");
        }
        if (!((FunctionType)this.Type).getRange().equals(data.getType())) {
            throw new TypeException("FieldImpl.setSample: bad range type");
        }
        if (n >= 0 && n < this.Length) {
            Data[] dataArray = this.Range;
            synchronized (dataArray) {
                this.MissingFlag = false;
                this.Range[n] = bl ? (Data)data.dataClone() : data;
                if (this.Range[n] instanceof DataImpl) {
                    ((DataImpl)this.Range[n]).setParent(this);
                }
            }
        }
        this.notifyReferences();
    }

    public boolean isMissing() {
        Data[] dataArray = this.Range;
        synchronized (dataArray) {
            boolean bl = this.MissingFlag;
            Object var2_3 = null;
            return bl;
        }
    }

    public Data binary(Data data, int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        boolean bl;
        if (mathType == null) {
            throw new TypeException("binary: new_type may not be null");
        }
        if (this.Type.equalsExceptName(data.getType())) {
            if (!this.Type.equalsExceptName(mathType)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
            bl = true;
            if (((Field)data).isFlatField()) {
                data = data.local();
                data = ((FlatField)data).convertToField();
            }
        } else if (data instanceof Real || ((FunctionType)this.Type).getRange().equalsExceptName(data.getType())) {
            bl = false;
            if (!this.Type.equalsExceptName(mathType)) {
                throw new TypeException("binary: new_type doesn't match return type");
            }
        } else {
            if (data instanceof Field && ((FunctionType)data.getType()).getRange().equalsExceptName(this.Type)) {
                if (!((FunctionType)data.getType()).getRange().equalsExceptName(mathType)) {
                    throw new TypeException("binary: new_type doesn't match return type");
                }
                return data.binary(this, DataImpl.invertOp(n), mathType, n2, n3);
            }
            throw new TypeException("FieldImpl.binary: types don't match");
        }
        FieldImpl fieldImpl = new FieldImpl((FunctionType)mathType, this.DomainSet);
        if (this.isMissing() || data.isMissing()) {
            return fieldImpl;
        }
        Data[] dataArray = new Data[this.Length];
        MathType mathType2 = ((FunctionType)mathType).getRange();
        if (bl) {
            data = ((Field)data).resample(this.DomainSet, n2, n3);
            int n4 = 0;
            while (n4 < this.Length) {
                Data[] dataArray2 = this.Range;
                synchronized (dataArray2) {
                    dataArray[n4] = this.Range[n4] == null ? null : this.Range[n4].binary(((Field)data).getSample(n4), n, mathType2, n2, n3);
                }
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < this.Length) {
                Data[] dataArray3 = this.Range;
                synchronized (dataArray3) {
                    dataArray[n5] = this.Range[n5] == null ? null : this.Range[n5].binary(data, n, mathType2, n2, n3);
                }
                ++n5;
            }
        }
        fieldImpl.setSamples(dataArray, false);
        return fieldImpl;
    }

    public Data unary(int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        if (mathType == null) {
            throw new TypeException("unary: new_type may not be null");
        }
        if (!this.Type.equalsExceptName(mathType)) {
            throw new TypeException("unary: new_type doesn't match return type");
        }
        MathType mathType2 = ((FunctionType)mathType).getRange();
        FieldImpl fieldImpl = new FieldImpl((FunctionType)mathType, this.DomainSet);
        if (this.isMissing()) {
            return fieldImpl;
        }
        Data[] dataArray = new Data[this.Length];
        int n4 = 0;
        while (n4 < this.Length) {
            Data[] dataArray2 = this.Range;
            synchronized (dataArray2) {
                dataArray[n4] = this.Range[n4] == null ? null : this.Range[n4].unary(n, mathType2, n2, n3);
            }
            ++n4;
        }
        fieldImpl.setSamples(dataArray, false);
        return fieldImpl;
    }

    public static Field combine(Field[] fieldArray) throws VisADException, RemoteException {
        return FieldImpl.combine(fieldArray, 100, 202);
    }

    public static Field combine(Field[] fieldArray, int n, int n2) throws VisADException, RemoteException {
        FieldImpl fieldImpl;
        int n3;
        int n4;
        int n5 = 0;
        boolean bl = true;
        Field field = fieldArray[0];
        int n6 = fieldArray.length;
        MathType[] mathTypeArray = new MathType[n6];
        MathType[][] mathTypeArray2 = new MathType[n6][];
        FunctionType[] functionTypeArray = new FunctionType[n6];
        boolean bl2 = false;
        n6 = fieldArray.length;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n6) {
            if (n8 == 0) {
                n5 = field.getDomainDimension();
            } else if (n5 != fieldArray[n8].getDomainDimension()) {
                throw new VisADException("FieldImpl.combine: domain dimensions of inputfields must match");
            }
            if (!fieldArray[n8].isFlatField()) {
                bl = false;
            }
            functionTypeArray[n8] = (FunctionType)fieldArray[n8].getType();
            mathTypeArray[n8] = ((FunctionType)fieldArray[n8].getType()).getRange();
            MathType mathType = mathTypeArray[n8];
            if (mathType instanceof RealType) {
                mathTypeArray2[n8] = new MathType[1];
                mathTypeArray2[n8][0] = mathType;
                ++n7;
            } else if (mathType instanceof RealTupleType) {
                mathTypeArray2[n8] = new MathType[1];
                mathTypeArray2[n8][0] = mathType;
                ++n7;
            } else if (mathType instanceof TupleType) {
                n4 = ((TupleType)mathType).getDimension();
                mathTypeArray2[n8] = new MathType[n4];
                n3 = 0;
                while (n3 < n4) {
                    mathTypeArray2[n8][n3] = ((TupleType)mathType).getComponent(n3);
                    ++n3;
                }
                n7 += n4;
            } else {
                mathTypeArray2[n8] = new MathType[1];
                mathTypeArray2[n8][0] = mathType;
                ++n7;
            }
            ++n8;
        }
        Set set = field.getDomainSet();
        RealTupleType realTupleType = ((FunctionType)field.getType()).getDomain();
        int n9 = set.getLength();
        if (bl) {
            TupleType tupleType;
            Serializable[] serializableArray;
            int n10;
            boolean bl3 = true;
            int n11 = 0;
            bl2 = false;
            Vector<CoordinateSystem> vector = new Vector<CoordinateSystem>();
            Vector<MathType> vector2 = new Vector<MathType>();
            Vector<MathType> vector3 = new Vector<MathType>();
            n8 = 0;
            while (n8 < n6) {
                MathType mathType;
                CoordinateSystem[] coordinateSystemArray;
                Field field2 = fieldArray[n8];
                MathType mathType2 = mathTypeArray[n8];
                if (mathType2 instanceof RealType) {
                    vector2.add(mathType2);
                    vector3.add(mathType2);
                    coordinateSystemArray = field2.getRangeCoordinateSystem();
                    vector.add(coordinateSystemArray[0]);
                    ++n11;
                } else if (mathType2 instanceof RealTupleType) {
                    n4 = ((RealTupleType)mathType2).getDimension();
                    n11 += n4;
                    coordinateSystemArray = field2.getRangeCoordinateSystem();
                    if (coordinateSystemArray[0] == null) {
                        n3 = 0;
                        while (n3 < n4) {
                            mathType = ((RealTupleType)mathType2).getComponent(n3);
                            vector2.add(mathType);
                            vector3.add(mathType);
                            vector.add(null);
                            ++n3;
                        }
                    } else {
                        vector2.add(mathType2);
                        vector.add(coordinateSystemArray[0]);
                        bl3 = false;
                    }
                } else {
                    n3 = 0;
                    while (n3 < mathTypeArray2[n8].length) {
                        coordinateSystemArray = field2.getRangeCoordinateSystem(n3);
                        mathType = mathTypeArray2[n8][n3];
                        if (mathType instanceof RealType) {
                            vector3.add(mathType);
                            vector2.add(mathType);
                            vector.add(coordinateSystemArray[0]);
                            ++n11;
                        } else if (mathType instanceof RealTupleType) {
                            n4 = ((RealTupleType)mathType).getDimension();
                            n11 += n4;
                            if (coordinateSystemArray[0] == null) {
                                int n12 = 0;
                                while (n12 < n4) {
                                    vector2.add(((RealTupleType)mathType).getComponent(n12));
                                    vector3.add(((RealTupleType)mathType).getComponent(n12));
                                    vector.add(null);
                                    ++n12;
                                }
                            } else {
                                vector2.add(mathType);
                                vector.add(coordinateSystemArray[0]);
                                bl3 = false;
                            }
                        }
                        ++n3;
                    }
                }
                ++n8;
            }
            if (bl3) {
                n10 = vector3.size();
                serializableArray = new RealType[n10];
                n8 = 0;
                while (n8 < n10) {
                    serializableArray[n8] = (RealType)vector3.elementAt(n8);
                    ++n8;
                }
                tupleType = new RealTupleType((RealType[])serializableArray);
            } else {
                n10 = vector2.size();
                serializableArray = new MathType[n10];
                n8 = 0;
                while (n8 < n10) {
                    serializableArray[n8] = (MathType)vector2.elementAt(n8);
                    ++n8;
                }
                tupleType = new TupleType((MathType[])serializableArray);
            }
            FunctionType functionType = new FunctionType(realTupleType, tupleType);
            n10 = vector.size();
            serializableArray = new CoordinateSystem[n10];
            n8 = 0;
            while (n8 < n10) {
                serializableArray[n8] = (CoordinateSystem)vector.elementAt(n8);
                ++n8;
            }
            Set[] setArray = new Set[n11];
            Unit[] unitArray = new Unit[n11];
            double[][] dArray = new double[n11][n9];
            int n13 = 0;
            int n14 = 0;
            boolean bl4 = false;
            int n15 = 0;
            boolean bl5 = false;
            n8 = 0;
            while (n8 < n6) {
                FlatField flatField = (FlatField)fieldArray[n8].local();
                if (n8 > 0) {
                    flatField = (FlatField)flatField.resample(set, n, n2);
                }
                Set[] setArray2 = flatField.getRangeSets();
                int n16 = setArray2.length;
                System.arraycopy(setArray2, 0, setArray, n13, n16);
                n13 += n16;
                Unit[][] unitArray2 = flatField.getRangeUnits();
                int n17 = unitArray2.length;
                Unit[] unitArray3 = new Unit[n17];
                n3 = 0;
                while (n3 < n17) {
                    unitArray3[n3] = unitArray2[n3][0];
                    ++n3;
                }
                System.arraycopy(unitArray3, 0, unitArray, n15, n17);
                n15 += n17;
                double[][] dArray2 = flatField.getValues();
                n3 = 0;
                while (n3 < dArray2.length) {
                    System.arraycopy(dArray2[n3], 0, dArray[n14++], 0, n9);
                    ++n3;
                }
                ++n8;
            }
            fieldImpl = functionType.getReal() ? new FlatField(functionType, set, null, null, setArray, null) : new FlatField(functionType, set, (CoordinateSystem[])serializableArray, setArray, null);
            ((FlatField)fieldImpl).setSamples(dArray);
        } else {
            TupleType tupleType;
            MathType[] mathTypeArray3;
            Vector<MathType> vector = new Vector<MathType>();
            boolean bl6 = true;
            Vector[] vectorArray = new Vector[n9];
            n8 = 0;
            while (n8 < n9) {
                vectorArray[n8] = new Vector();
                ++n8;
            }
            n8 = 0;
            while (n8 < n6) {
                int n18;
                Field field3 = n8 == 0 ? (Field)((Object)fieldArray[n8].local()) : fieldArray[n8].resample(set, n, n2);
                MathType mathType = mathTypeArray[n8];
                if (mathType instanceof RealType) {
                    vector.add(mathType);
                    n18 = 0;
                    while (n18 < n9) {
                        vectorArray[n18].add(field3.getSample(n18));
                        ++n18;
                    }
                } else if (mathType instanceof RealTupleType) {
                    if (((RealTupleType)mathType).getCoordinateSystem() != null) {
                        vector.add(mathType);
                        bl6 = false;
                        n18 = 0;
                        while (n18 < n9) {
                            vectorArray[n18].add(field3.getSample(n18));
                            ++n18;
                        }
                    } else {
                        n4 = ((RealTupleType)mathType).getDimension();
                        n3 = 0;
                        while (n3 < n4) {
                            vector.add(((RealTupleType)mathType).getComponent(n3));
                            ++n3;
                        }
                        n18 = 0;
                        while (n18 < n9) {
                            Data data = field3.getSample(n18);
                            n3 = 0;
                            while (n3 < n4) {
                                vectorArray[n18].add(((RealTuple)data).getComponent(n3));
                                ++n3;
                            }
                            ++n18;
                        }
                    }
                } else if (mathType instanceof TupleType && !(mathType instanceof RealTupleType)) {
                    if (!((TupleType)mathType).getFlat()) {
                        vector.add(mathType);
                        n18 = 0;
                        while (n18 < n9) {
                            vectorArray[n18].add(field3.getSample(n18));
                            ++n18;
                        }
                        bl6 = false;
                    } else {
                        n4 = ((TupleType)mathType).getDimension();
                        n8 = 0;
                        while (n8 < n4) {
                            MathType mathType3 = ((TupleType)mathType).getComponent(n8);
                            if (mathType3 instanceof RealType) {
                                vector.add(mathType3);
                                n18 = 0;
                                while (n18 < n9) {
                                    vectorArray[n18].add(((TupleIface)field3.getSample(n18)).getComponent(n8));
                                    ++n18;
                                }
                            } else if (mathType3 instanceof RealTupleType) {
                                if (((RealTupleType)mathType3).getCoordinateSystem() != null) {
                                    vector.add(mathType3);
                                    bl6 = false;
                                    n18 = 0;
                                    while (n18 < n9) {
                                        vectorArray[n18].add(((TupleIface)field3.getSample(n18)).getComponent(n8));
                                        ++n18;
                                    }
                                } else {
                                    n3 = 0;
                                    while (n3 < ((RealTupleType)mathType3).getDimension()) {
                                        vector.add(((RealTupleType)mathType3).getComponent(n3));
                                        ++n3;
                                    }
                                    n18 = 0;
                                    while (n18 < n9) {
                                        RealTuple realTuple = (RealTuple)((TupleIface)field3.getSample(n18)).getComponent(n8);
                                        n3 = 0;
                                        while (n3 < ((RealTupleType)mathType3).getDimension()) {
                                            vectorArray[n18].add(realTuple.getComponent(n3));
                                            ++n3;
                                        }
                                        ++n18;
                                    }
                                }
                            }
                            ++n8;
                        }
                    }
                } else if (mathType instanceof FunctionType) {
                    vector.add(mathType);
                    n18 = 0;
                    while (n18 < n9) {
                        vectorArray[n18].add(field3.getSample(n18));
                        ++n18;
                    }
                    bl6 = false;
                }
                ++n8;
            }
            int n19 = vector.size();
            if (bl6) {
                mathTypeArray3 = new RealType[n19];
                n8 = 0;
                while (n8 < n19) {
                    mathTypeArray3[n8] = (RealType)vector.elementAt(n8);
                    ++n8;
                }
                tupleType = new RealTupleType((RealType[])mathTypeArray3);
            } else {
                mathTypeArray3 = new MathType[n19];
                n8 = 0;
                while (n8 < n19) {
                    mathTypeArray3[n8] = (MathType)vector.elementAt(n8);
                    ++n8;
                }
                tupleType = new TupleType(mathTypeArray3);
            }
            FunctionType functionType = new FunctionType(realTupleType, tupleType);
            fieldImpl = new FieldImpl(functionType, set);
            n8 = 0;
            while (n8 < n9) {
                n19 = vectorArray[n8].size();
                Data[] dataArray = new Data[n19];
                n3 = 0;
                while (n3 < n19) {
                    dataArray[n3] = (Data)vectorArray[n8].elementAt(n3);
                    ++n3;
                }
                Tuple tuple = new Tuple(dataArray);
                fieldImpl.setSample(n8, (Data)tuple);
                ++n8;
            }
        }
        return fieldImpl;
    }

    public Field extract(MathType mathType) throws VisADException, RemoteException {
        int n = -1;
        MathType mathType2 = ((FunctionType)this.Type).getRange();
        if (!(mathType2 instanceof TupleType)) {
            throw new VisADException("FieldImpl.extract: range must be a TupleType");
        }
        int n2 = ((TupleType)mathType2).getDimension();
        int n3 = 0;
        while (n3 < n2) {
            MathType mathType3 = ((TupleType)mathType2).getComponent(n3);
            if (mathType3.equals(mathType)) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n != -1) {
            return this.extract(n);
        }
        return null;
    }

    public Field extract(String string) throws VisADException, RemoteException {
        int n = -1;
        MathType mathType = ((FunctionType)this.Type).getRange();
        if (!(mathType instanceof TupleType)) {
            throw new VisADException("FieldImpl.extract: range must be a TupleType");
        }
        int n2 = ((TupleType)mathType).getDimension();
        int n3 = 0;
        while (n3 < n2) {
            String string2 = ((TupleType)mathType).getComponent(n3).toString();
            if (string2.equals(string) || string2.equals("(" + string + ")")) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n != -1) {
            return this.extract(n);
        }
        return null;
    }

    public Field extract(int n) throws VisADException, RemoteException {
        FieldImpl fieldImpl;
        Set set = this.getDomainSet();
        int n2 = set.getLength();
        MathType mathType = ((FunctionType)this.Type).getRange();
        RealTupleType realTupleType = ((FunctionType)this.Type).getDomain();
        if (!(mathType instanceof TupleType)) {
            throw new VisADException("extract: range type must be TupleType");
        }
        int n3 = ((TupleType)mathType).getDimension();
        if (n + 1 > n3) {
            throw new VisADException("extract: component selection too large");
        }
        MathType mathType2 = ((TupleType)mathType).getComponent(n);
        FunctionType functionType = new FunctionType(realTupleType, mathType2);
        if (mathType2 instanceof RealType) {
            Unit[] unitArray = new Unit[]{((RealType)mathType2).getDefaultUnit()};
            fieldImpl = new FlatField(functionType, set, null, null, null, unitArray);
            double[][] dArray = new double[1][n2];
            int n4 = 0;
            while (n4 < n2) {
                Real real = (Real)this.getSample(n4);
                double d = real.getValue();
                Unit unit = real.getUnit();
                dArray[0][n4] = unitArray[0].toThis(d, unit);
                ++n4;
            }
            ((FlatField)fieldImpl).setSamples(dArray);
        } else if (mathType2 instanceof RealTupleType) {
            CoordinateSystem coordinateSystem = ((RealTupleType)mathType2).getCoordinateSystem();
            int n5 = ((RealTupleType)mathType2).getDimension();
            Unit[] unitArray = new Unit[n5];
            Unit[] unitArray2 = new Unit[n5];
            unitArray = ((RealTupleType)mathType2).getDefaultUnits();
            fieldImpl = new FlatField(functionType, set, coordinateSystem, null, unitArray);
            double[][] dArray = new double[n5][n2];
            double[][] dArray2 = new double[n5][1];
            int n6 = 0;
            while (n6 < n2) {
                RealTuple realTuple = (RealTuple)((TupleIface)this.getSample(n6)).getComponent(n);
                CoordinateSystem coordinateSystem2 = realTuple.getCoordinateSystem();
                unitArray2 = realTuple.getTupleUnits();
                int n7 = 0;
                while (n7 < n5) {
                    dArray2[n7][0] = ((Real)realTuple.getComponent(n7)).getValue();
                    ++n7;
                }
                dArray2 = CoordinateSystem.transformCoordinates((RealTupleType)mathType2, coordinateSystem, unitArray, null, (RealTupleType)mathType2, coordinateSystem2, unitArray2, null, dArray2);
                n7 = 0;
                while (n7 < n5) {
                    dArray[n7][n6] = dArray2[n7][0];
                    ++n7;
                }
                ++n6;
            }
            ((FlatField)fieldImpl).setSamples(dArray);
        } else if (mathType2 instanceof TupleType && ((TupleType)mathType2).getFlat()) {
            MathType mathType3;
            fieldImpl = new FlatField(functionType, set);
            int n8 = ((TupleType)mathType2).getDimension();
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            while (n11 < n8) {
                mathType3 = ((TupleType)mathType2).getComponent(n11);
                if (mathType3 instanceof RealType) {
                    ++n9;
                } else if (mathType3 instanceof RealTupleType) {
                    RealTupleType realTupleType2 = (RealTupleType)mathType3;
                    n9 += realTupleType2.getDimension();
                    if (realTupleType2.getCoordinateSystem() != null) {
                        ++n10;
                    }
                }
                ++n11;
            }
            double[][] dArray = new double[n9][n2];
            n9 = 0;
            n11 = 0;
            while (n11 < n2) {
                Data data = this.getSample(n11);
                mathType3 = data.getType();
                int n12 = 0;
                while (n12 < n8) {
                    if (mathType3 instanceof RealType) {
                        dArray[n9][n11] = ((Real)((TupleIface)data).getComponent(n12)).getValue();
                        ++n9;
                    } else {
                        RealTuple realTuple = (RealTuple)((TupleIface)data).getComponent(n12);
                        int n13 = 0;
                        while (n13 < ((RealTupleType)mathType3).getDimension()) {
                            dArray[n9][n11] = ((Real)realTuple.getComponent(n13)).getValue();
                            ++n9;
                            ++n13;
                        }
                    }
                    ++n12;
                }
                ++n11;
            }
            ((FlatField)fieldImpl).setSamples(dArray);
        } else {
            fieldImpl = new FieldImpl(functionType, set);
            int n14 = 0;
            while (n14 < n2) {
                Data data = this.getSample(n14);
                Data data2 = ((TupleIface)data).getComponent(n);
                fieldImpl.setSample(n14, data2);
                ++n14;
            }
        }
        return fieldImpl;
    }

    public Field domainFactor(RealType realType) throws DomainException, VisADException, RemoteException {
        int n;
        int n2;
        int n3;
        int n4;
        SampledSet[] sampledSetArray;
        int n5;
        Object[] objectArray;
        Linear1DSet[] linear1DSetArray;
        Set set = null;
        Object var5_3 = null;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        SampledSet sampledSet = null;
        RealTupleType realTupleType = null;
        FieldImpl fieldImpl = null;
        FieldImpl fieldImpl2 = null;
        FunctionType functionType = null;
        double[][] dArray = null;
        double[][] dArray2 = null;
        Data[] dataArray = null;
        RealTupleType realTupleType2 = ((FunctionType)this.Type).getDomain();
        MathType mathType = ((FunctionType)this.Type).getRange();
        int n6 = realTupleType2.getDimension();
        RealType[] realTypeArray = new RealType[n6 - 1];
        int n7 = realTupleType2.getIndex(realType);
        if (n7 < 0) {
            throw new DomainException("domainFactor: factor not element of domain");
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 < n6) {
            if (n9 != n7) {
                realTypeArray[n8++] = (RealType)realTupleType2.getComponent(n9);
            }
            ++n9;
        }
        realTupleType = new RealTupleType(realTypeArray);
        if (this.DomainSet instanceof LinearSet) {
            set = ((LinearSet)((Object)this.DomainSet)).getLinear1DComponent(n7);
            nArray2 = ((GriddedSet)this.DomainSet).getLengths();
            linear1DSetArray = new Linear1DSet[n6 - 1];
            nArray = new int[n6 - 1];
            nArray4 = new int[n6 - 1];
            n8 = 0;
            n9 = 0;
            while (n9 < n6) {
                if (n9 != n7) {
                    linear1DSetArray[n8] = ((LinearSet)((Object)this.DomainSet)).getLinear1DComponent(n9);
                    nArray[n8] = linear1DSetArray[n8].LengthX;
                    nArray4[n8] = n9;
                    ++n8;
                }
                ++n9;
            }
            sampledSet = new LinearNDSet((MathType)realTupleType, linear1DSetArray);
            functionType = new FunctionType(realTupleType, mathType);
        } else {
            if (this.DomainSet instanceof GriddedSet) {
                throw new DomainException("domainFactor: DomainSet is GriddedSet, if aligned use ProductSet");
            }
            if (this.DomainSet instanceof ProductSet) {
                linear1DSetArray = (Linear1DSet[])((ProductSet)this.DomainSet).product();
                objectArray = linear1DSetArray.Sets;
                n5 = objectArray.length;
                sampledSetArray = new SampledSet[n5 - 1];
                Set set2 = null;
                Set set3 = null;
                n4 = -1;
                n3 = -1;
                n2 = -1;
                int[] nArray5 = new int[n5 - 1];
                int[] nArray6 = new int[n5 - 1];
                n8 = 0;
                n = 0;
                while (n < n5) {
                    SetType setType = (SetType)objectArray[n].getType();
                    n4 = setType.getDomain().getIndex(realType);
                    if (n4 >= 0) {
                        set2 = objectArray[n];
                        n3 = n;
                        n2 = set2.getLength();
                    } else {
                        sampledSetArray[n8] = objectArray[n];
                        nArray5[n8] = n;
                        nArray6[n8] = objectArray[n].getLength();
                        ++n8;
                    }
                    ++n;
                }
                int n10 = set2.getDimension();
                int n11 = sampledSetArray.length;
                if (n10 == 1) {
                    set3 = set2;
                    nArray = new int[n11];
                    nArray4 = new int[n11];
                    nArray2 = new int[n5];
                    sampledSet = n11 > 1 ? new ProductSet(sampledSetArray) : sampledSetArray[0];
                    set = set2;
                    System.arraycopy(nArray6, 0, nArray, 0, n11);
                    System.arraycopy(nArray5, 0, nArray4, 0, n11);
                    n9 = 0;
                    while (n9 < n11) {
                        nArray2[nArray5[n9]] = nArray6[n9];
                        ++n9;
                    }
                    nArray2[n3] = n2;
                    functionType = new FunctionType(((SetType)sampledSet.getType()).getDomain(), mathType);
                } else {
                    if (!(set2 instanceof LinearNDSet)) {
                        throw new DomainException("cannot factor into " + set2.getClass());
                    }
                    MathType mathType2 = null;
                    nArray = new int[n11 + 1];
                    nArray4 = new int[n11 + 1];
                    nArray2 = new int[n5 + 1];
                    Linear1DSet[] linear1DSetArray2 = new Linear1DSet[n10 - 1];
                    n8 = 0;
                    n9 = 0;
                    while (n9 < n10) {
                        if (n9 != n4) {
                            linear1DSetArray2[n8] = ((LinearSet)((Object)this.DomainSet)).getLinear1DComponent(n9);
                            ++n8;
                        } else {
                            set3 = ((LinearSet)((Object)this.DomainSet)).getLinear1DComponent(n9);
                        }
                        ++n9;
                    }
                    LinearNDSet linearNDSet = new LinearNDSet(mathType2, linear1DSetArray2);
                    n8 = 0;
                    System.arraycopy(nArray6, 0, nArray, 0, n3);
                    System.arraycopy(nArray5, 0, nArray4, 0, n3);
                    n8 += n3;
                    nArray[n3] = linearNDSet.getLength();
                    System.arraycopy(nArray6, n3, nArray, ++n8, n11 - n3);
                    System.arraycopy(nArray5, n3, nArray4, n8, n11 - n3);
                    functionType = new FunctionType(((SetType)linearNDSet.getType()).getDomain(), mathType);
                    sampledSet = linearNDSet;
                }
            } else {
                if (this.DomainSet instanceof UnionSet) {
                    throw new UnimplementedException("domainFactor: DomainSet is UnionSet");
                }
                if (this.DomainSet instanceof IrregularSet) {
                    throw new DomainException("domainFactor: DomainSet is IrregularSet, can't factor");
                }
            }
        }
        int n12 = set.getLength();
        dataArray = new Data[n12];
        nArray3 = new int[n6];
        n = 0;
        while (n < n6) {
            nArray3[n] = 1;
            int n13 = 0;
            while (n13 < n) {
                int n14 = n;
                nArray3[n14] = nArray3[n14] * nArray2[n13];
                ++n13;
            }
            ++n;
        }
        int n15 = nArray.length;
        objectArray = new int[n15];
        n5 = 1;
        n9 = 0;
        while (n9 < n15) {
            n5 *= nArray[n9];
            ++n9;
        }
        sampledSetArray = (SampledSet[])new int[n5];
        int n16 = 0;
        while (n16 < n5) {
            int n17 = n16;
            n4 = n15 - 1;
            while (n4 >= 0) {
                n3 = 1;
                n2 = 0;
                while (n2 < n4) {
                    n3 *= nArray[n2];
                    ++n2;
                }
                objectArray[n4] = (SampledSet)(n17 / n3);
                n17 -= n3 * objectArray[n4];
                --n4;
            }
            n4 = 0;
            while (n4 < objectArray.length) {
                int n18 = n16;
                sampledSetArray[n18] = sampledSetArray[n18] + nArray3[nArray4[n4]] * objectArray[n4];
                ++n4;
            }
            ++n16;
        }
        if (this.isFlatField()) {
            dArray2 = this.getValues();
            n16 = dArray2.length;
            dArray = new double[n16][sampledSetArray.length];
            n9 = 0;
            while (n9 < n12) {
                fieldImpl = new FlatField(functionType, sampledSet);
                int n19 = 0;
                while (n19 < sampledSetArray.length) {
                    int n20 = 0;
                    n20 = n9 * nArray3[n7];
                    n20 += sampledSetArray[n19];
                    n = 0;
                    while (n < n16) {
                        dArray[n][n19] = dArray2[n][n20];
                        ++n;
                    }
                    ++n19;
                }
                ((FlatField)fieldImpl).setSamples(dArray);
                dataArray[n9] = fieldImpl;
                ++n9;
            }
        } else {
            n9 = 0;
            while (n9 < n12) {
                fieldImpl = new FieldImpl(functionType, sampledSet);
                int n21 = 0;
                while (n21 < sampledSetArray.length) {
                    int n22 = 0;
                    n22 = n9 * nArray3[n7];
                    dataArray[n21] = this.getSample(n22 += sampledSetArray[n21]);
                    ++n21;
                }
                fieldImpl.setSamples(dataArray, false);
                dataArray[n9] = fieldImpl;
                ++n9;
            }
        }
        fieldImpl2 = new FieldImpl(new FunctionType(realType, functionType), set);
        fieldImpl2.setSamples(dataArray, false);
        return fieldImpl2;
    }

    public Field domainMultiply() throws VisADException, RemoteException {
        return this.domainMultiply(1);
    }

    public Field domainMultiply(int n) throws VisADException, RemoteException {
        FieldImpl fieldImpl;
        Object object;
        int n2;
        int n3;
        MathType mathType;
        SampledSet sampledSet = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        class Helper {
            int cnt;
            int n_samples;
            int depth;
            int depth_max;
            boolean flat;
            MathType range_type;
            MathType new_range_type;
            SampledSet[] last_set;
            SampledSet[] fac_sets;
            Object[] collapse_array;
            private final /* synthetic */ FieldImpl this$0;

            public SampledSet[] getSets() {
                int n = this.last_set.length;
                this.fac_sets = new SampledSet[n];
                int n2 = 0;
                while (n2 < n) {
                    this.fac_sets[n - 1 - n2] = this.last_set[n2];
                    ++n2;
                }
                return this.fac_sets;
            }

            public Object[] getRangeArray() {
                return this.collapse_array;
            }

            public MathType getRangeType() {
                return this.new_range_type;
            }

            public int checkType(MathType mathType) throws VisADException, RemoteException {
                if (mathType instanceof FunctionType) {
                    if (((FunctionType)mathType).getFlat()) {
                        this.flat = true;
                        this.new_range_type = ((FunctionType)mathType).getRange();
                        return this.depth;
                    }
                    this.range_type = ((FunctionType)mathType).getRange();
                    ++this.depth;
                    return this.checkType(this.range_type);
                }
                this.new_range_type = mathType;
                return this.depth;
            }

            public void collapse(Data data) throws VisADException, RemoteException {
                if (this.depth == this.depth_max) {
                    if (this.flat) {
                        double[][] dArray = ((FieldImpl)data).getValues();
                        this.collapse_array[this.cnt++] = dArray;
                    } else {
                        this.collapse_array[this.cnt++] = data;
                    }
                } else {
                    ++this.depth;
                    this.n_samples = ((Field)data).getDomainSet().getLength();
                    int n = 0;
                    while (n < this.n_samples) {
                        this.collapse(((FieldImpl)data).getSample(n));
                        ++n;
                    }
                }
            }

            public boolean setsEqual(Field field) throws VisADException, RemoteException {
                Set set = field.getDomainSet();
                int n = set.getLength();
                if (this.depth == 0) {
                    this.last_set[this.depth] = (SampledSet)set;
                }
                ++this.depth;
                if (this.last_set[this.depth] == null) {
                    this.last_set[this.depth] = (SampledSet)((Field)field.getSample(0)).getDomainSet();
                }
                int n2 = 0;
                while (n2 < n) {
                    Field field2 = (Field)field.getSample(n2);
                    Set set2 = field2.getDomainSet();
                    if (!this.last_set[this.depth].equals(set2)) {
                        return false;
                    }
                    if (this.depth != this.depth_max) {
                        if (!this.setsEqual(field2)) {
                            return false;
                        }
                        --this.depth;
                    }
                    ++n2;
                }
                return true;
            }

            /* synthetic */ Helper(FieldImpl fieldImpl, Data data, int n) throws VisADException, RemoteException {
                this.this$0 = fieldImpl;
                this.cnt = 0;
                this.constructor$0(fieldImpl, data, n);
            }

            private final void constructor$0(FieldImpl fieldImpl, Data data, int n) throws VisADException, RemoteException {
                MathType mathType = data.getType();
                this.depth = 0;
                this.flat = false;
                this.depth_max = this.checkType(mathType);
                if (this.depth_max == 0) {
                    throw new FieldException("MathType " + mathType.prettyString());
                }
                if (this.depth_max >= n) {
                    this.depth_max = n;
                }
                this.last_set = new SampledSet[this.depth_max + 1];
                this.depth = 0;
                if (!this.setsEqual((Field)data)) {
                    throw new FieldException("sets not equal");
                }
                int n2 = 1;
                int n3 = 0;
                while (n3 < this.depth_max) {
                    n2 *= this.last_set[n3].getLength();
                    ++n3;
                }
                this.collapse_array = new Object[n2];
                this.depth = 0;
                this.collapse(data);
            }
        }
        Helper helper = new Helper(this, this, n);
        SampledSet[] sampledSetArray = helper.getSets();
        int n8 = sampledSetArray.length;
        Object[] objectArray = helper.getRangeArray();
        MathType mathType2 = helper.getRangeType();
        SetType[] setTypeArray = new SetType[n8];
        int n9 = 1;
        int n10 = 0;
        while (n10 < n8) {
            n9 *= sampledSetArray[n10].getLength();
            n6 += sampledSetArray[n10].getDimension();
            n7 += sampledSetArray[n10].getManifoldDimension();
            setTypeArray[n10] = (SetType)sampledSetArray[n10].getType();
            if (sampledSetArray[n10] instanceof IrregularSet) {
                ++n4;
            } else if (sampledSetArray[n10] instanceof LinearSet) {
                ++n5;
            }
            ++n10;
        }
        RealType[] realTypeArray = new RealType[n6];
        int n11 = 0;
        int n12 = 0;
        while (n12 < n8) {
            mathType = setTypeArray[n12].getDomain();
            int n13 = 0;
            while (n13 < ((TupleType)mathType).getDimension()) {
                realTypeArray[n11++] = (RealType)((TupleType)mathType).getComponent(n13);
                ++n13;
            }
            ++n12;
        }
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        mathType = new FunctionType(realTupleType, mathType2);
        if (n4 > 0) {
            sampledSet = new ProductSet(sampledSetArray);
        } else if (n5 == n8) {
            Linear1DSet[] linear1DSetArray = new Linear1DSet[n6];
            n11 = 0;
            n3 = 0;
            while (n3 < n8) {
                n2 = 0;
                while (n2 < sampledSetArray[n3].getDimension()) {
                    linear1DSetArray[n11++] = ((LinearSet)((Object)sampledSetArray[n3])).getLinear1DComponent(n2);
                    ++n2;
                }
                ++n3;
            }
            sampledSet = new LinearNDSet((MathType)realTupleType, linear1DSetArray);
        } else {
            int n14;
            int n15;
            float[][] fArray = new float[n6][n9];
            float[][] fArray2 = new float[n6][];
            int[][] nArray = new int[n6][];
            int[][] nArray2 = new int[n6][];
            int[] nArray3 = new int[n7];
            n11 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            while (n18 < n8) {
                SampledSet sampledSet2 = sampledSetArray[n18];
                float[][] fArray3 = sampledSet2.getSamples();
                n2 = sampledSet2.getDimension();
                n3 = ((Set)sampledSet2).getManifoldDimension();
                object = ((GriddedSet)sampledSet2).getLengths();
                n15 = 0;
                while (n15 < n2) {
                    fArray2[n11] = fArray3[n15];
                    nArray[n11] = (int[])object;
                    nArray2[n11] = new int[n3];
                    n14 = 0;
                    while (n14 < n3) {
                        nArray2[n11][n14] = n14 + n17;
                        ++n14;
                    }
                    ++n11;
                    ++n15;
                }
                n15 = 0;
                while (n15 < n3) {
                    nArray3[n16++] = (int)object[n15];
                    ++n15;
                }
                n17 += n3;
                ++n18;
            }
            int[] nArray4 = new int[n7];
            n15 = 0;
            while (n15 < n9) {
                int n19;
                int n20;
                n14 = n15;
                int n21 = n7 - 1;
                while (n21 >= 0) {
                    n20 = 1;
                    n19 = 0;
                    while (n19 < n21) {
                        n20 *= nArray3[n19];
                        ++n19;
                    }
                    nArray4[n21] = n14 / n20;
                    n14 -= n20 * nArray4[n21];
                    --n21;
                }
                n21 = 0;
                while (n21 < n6) {
                    n20 = 0;
                    n19 = nArray2[n21].length - 1;
                    while (n19 >= 0) {
                        int n22 = 1;
                        int n23 = 0;
                        while (n23 < n19) {
                            n22 *= nArray[n21][n23];
                            ++n23;
                        }
                        n20 += (n22 *= nArray4[nArray2[n21][n19]]);
                        --n19;
                    }
                    fArray[n21][n15] = fArray2[n21][n20];
                    ++n21;
                }
                ++n15;
            }
            sampledSet = new GriddedSet(realTupleType, fArray, nArray3);
        }
        if (((FunctionType)mathType).getFlat()) {
            fieldImpl = new FlatField((FunctionType)mathType, sampledSet);
            n3 = ((FunctionType)mathType).getFlatRange().getDimension();
            double[][] dArray = new double[n3][n9];
            n11 = 0;
            int n24 = 0;
            while (n24 < objectArray.length) {
                object = (double[][])objectArray[n24];
                int n25 = object[0].length;
                int n26 = 0;
                while (n26 < n3) {
                    System.arraycopy(object[n26], 0, dArray[n26], n11, n25);
                    ++n26;
                }
                n11 += n25;
                ++n24;
            }
            ((FlatField)fieldImpl).setSamples(dArray, false);
        } else {
            fieldImpl = new FieldImpl((FunctionType)mathType, sampledSet);
            n3 = 0;
            while (n3 < n9) {
                fieldImpl.setSample(n3, (Data)objectArray[n3]);
                ++n3;
            }
        }
        return fieldImpl;
    }

    public Data derivative(RealTuple realTuple, RealType[] realTypeArray, MathType[] mathTypeArray, int n) throws VisADException, RemoteException {
        Object object;
        boolean bl;
        int n2;
        Set set = this.getDomainSet();
        int n3 = set.getDimension();
        int n4 = set.getManifoldDimension();
        int n5 = set.getLength();
        CoordinateSystem coordinateSystem = this.getDomainCoordinateSystem();
        RealTupleType realTupleType = coordinateSystem == null ? null : coordinateSystem.getReference();
        Object var19_11 = null;
        Object var20_12 = null;
        Object var21_13 = null;
        Object var22_14 = null;
        Object var23_15 = null;
        boolean bl2 = true;
        if (n4 != n3) {
            throw new SetException("derivative: manifoldDimension must equal domain dimension");
        }
        n = 202;
        int n6 = 101;
        if (realTuple != null) {
            bl2 = false;
        }
        RealTupleType realTupleType2 = ((FunctionType)this.Type).getDomain();
        RealType[] realTypeArray2 = realTupleType2.getRealComponents();
        RealType[] realTypeArray3 = realTupleType == null ? null : realTupleType.getRealComponents();
        MathType mathType = ((FunctionType)this.Type).getRange();
        if (realTypeArray == null) {
            n2 = n3;
            realTypeArray = realTypeArray2;
        } else {
            n2 = realTypeArray.length;
            if (n2 > n3) {
                throw new VisADException("derivative: too many d_partial components");
            }
        }
        int[] nArray = new int[n2];
        double[][] dArray = new double[n2][n3];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n2) {
            int n10 = 0;
            while (n10 < n3) {
                dArray[n9][n10] = 0.0;
                if (realTypeArray2[n10].equals(realTypeArray[n9])) {
                    nArray[n9] = n10;
                    dArray[n9][n10] = 1.0;
                    ++n7;
                } else if (realTupleType != null && realTypeArray3[n10].equals(realTypeArray[n9])) {
                    nArray[n9] = n10;
                    dArray[n10][n9] = 1.0;
                    ++n8;
                }
                ++n10;
            }
            ++n9;
        }
        if (n7 == 0) {
            if (n8 == 0) {
                throw new VisADException("derivative: d_partial_s not in domain or reference");
            }
            if (n8 > 0 && n8 < n2) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            bl = true;
        } else {
            if (n7 > 0 && n7 < n2) {
                throw new VisADException("derivative: d_partial_s must ALL be in function's domain or ALL in domain's reference");
            }
            bl = false;
        }
        Object var36_30 = null;
        MathType[] mathTypeArray2 = new MathType[n2];
        MathType[] mathTypeArray3 = new MathType[n2];
        Unit[] unitArray = !bl ? set.getSetUnits() : realTupleType.getDefaultUnits();
        if (mathTypeArray == null) {
            n9 = 0;
            while (n9 < n2) {
                object = this.Type.cloneDerivative(realTypeArray[n9]);
                mathTypeArray3[n9] = bl2 ? object : ((FunctionType)object).getRange();
                ++n9;
            }
            mathTypeArray = mathTypeArray3;
        } else {
            if (mathTypeArray.length != n2) {
                throw new VisADException("derivative: must be a single MathType for each domain RealType");
            }
            n9 = 0;
            while (n9 < n2) {
                if (bl2 ? !this.Type.equalsExceptName(mathTypeArray[n9]) : !((FunctionType)this.Type).getRange().equalsExceptName(mathTypeArray[n9])) {
                    throw new TypeException("derivative: incompatible with function range");
                }
                ++n9;
            }
        }
        object = null;
        Data[] dataArray = new Data[n2];
        ErrorEstimate[] errorEstimateArray = set.getSetErrors();
        Data[] dataArray2 = new FieldImpl[n2];
        Data[] dataArray3 = null;
        int n11 = 0;
        while (n11 < n2) {
            dataArray2[n11] = new FieldImpl((FunctionType)mathTypeArray[n11], set);
            ++n11;
        }
        if (this.isMissing()) {
            if (set instanceof LinearSet && bl2) {
                int n12 = 0;
                while (n12 < n2) {
                    mathType = ((FunctionType)mathTypeArray[n12]).getRange();
                    int n13 = nArray[n12];
                    object = set.getNeighbors(n13);
                    float f = (float)((LinearSet)((Object)set)).getLinear1DComponent(n12).getStep();
                    n9 = 0;
                    while (n9 < n5) {
                        Object object2;
                        Object object3;
                        float f2;
                        if (object[n9][0] == -1) {
                            f2 = f;
                            object3 = object[n9][1];
                            object2 = n9;
                        } else if (object[n9][1] == -1) {
                            f2 = f;
                            object3 = n9;
                            object2 = object[n9][0];
                        } else {
                            f2 = 2.0f * f;
                            object3 = object[n9][1];
                            object2 = object[n9][0];
                        }
                        Data data = this.getSample((int)object3);
                        Data data2 = this.getSample((int)object2);
                        Real real = new Real(realTypeArray[n12], f2, unitArray[n13]);
                        Data data3 = data.binary(data2, 2, n6, n);
                        Data data4 = data3.binary(real, 5, mathType, n6, n);
                        ((FieldImpl)dataArray2[n12]).setSample(n9, data4);
                        ++n9;
                    }
                    ++n12;
                }
            } else {
                int n14;
                Data[] dataArray4;
                Object object4;
                int n15;
                Object object5;
                Object object6;
                float[][] fArray;
                float[][] fArray2 = null;
                if (bl2) {
                    object = new int[n5][];
                    fArray2 = new float[n5][];
                    set.getNeighbors((int[][])object, fArray2);
                    if (bl) {
                        fArray = set.getSamples(true);
                        fArray = CoordinateSystem.transformCoordinates(realTupleType, null, null, null, realTupleType2, coordinateSystem, null, null, fArray);
                    } else {
                        fArray = set.getSamples(false);
                    }
                } else {
                    n5 = 1;
                    object6 = set.getSamples(false);
                    object5 = this.resample(new SingletonSet(realTuple, null, null, null), 101, n);
                    float[][] fArray3 = object5.getDomainSet().getSamples(false);
                    object = new int[n5][];
                    fArray2 = new float[n5][];
                    ((SimpleSet)this.DomainSet).valueToInterp(fArray3, (int[][])object, fArray2);
                    n15 = ((Object)object[0]).length;
                    object4 = new int[n5][n15];
                    dataArray4 = new Data[n15 + 1];
                    float[][] fArray4 = new float[n3][n15 + 1];
                    n9 = 0;
                    while (n9 < n3) {
                        fArray4[n9][0] = fArray3[n9][0];
                        ++n9;
                    }
                    dataArray4[0] = object5.getSample(0);
                    n14 = 0;
                    while (n14 < n15) {
                        object4[0][n14] = n14 + 1;
                        dataArray4[n14 + 1] = this.getSample((int)object[0][n14]);
                        n9 = 0;
                        while (n9 < n3) {
                            fArray4[n9][n14 + 1] = object6[n9][object[0][n14]];
                            ++n9;
                        }
                        ++n14;
                    }
                    object = object4;
                    dataArray3 = dataArray4;
                    fArray = fArray4;
                    if (bl) {
                        fArray = CoordinateSystem.transformCoordinates(realTupleType, null, null, null, realTupleType2, coordinateSystem, null, null, fArray);
                    }
                }
                n9 = 0;
                while (n9 < n5) {
                    int n16;
                    n15 = ((Object)object[n9]).length;
                    dataArray4 = new Data[n15];
                    object4 = null;
                    object5 = new double[n15][n3];
                    Data data = bl2 ? this.getSample(n9) : dataArray3[n9];
                    n14 = 0;
                    while (n14 < n15) {
                        n16 = 0;
                        while (n16 < n3) {
                            object5[n14][n16] = (double)(fArray[n16][object[n9][n14]] - fArray[n16][n9]);
                            ++n16;
                        }
                        Data data5 = bl2 ? this.getSample((int)object[n9][n14]) : dataArray3[object[n9][n14]];
                        dataArray4[n14] = data5.binary(data, 2, n6, n);
                        ++n14;
                    }
                    boolean bl3 = true;
                    n11 = 0;
                    while (n11 < n2) {
                        int n17 = nArray[n11];
                        mathType = ((FunctionType)mathTypeArray[n11]).getRange();
                        float f = 0.0f;
                        n14 = 0;
                        while (n14 < n15) {
                            float f3 = 0.0f;
                            n16 = 0;
                            while (n16 < n3) {
                                f3 = (float)((double)f3 + object5[n14][n16] * dArray[n11][n16]);
                                ++n16;
                            }
                            float f4 = 1.0f / f3;
                            if (!Float.isInfinite(f4)) {
                                f += fArray2[n9][n14];
                                float f5 = f4 * fArray2[n9][n14];
                                dataArray4[n14] = dataArray4[n14].binary(new Real(f5), 4, n6, n);
                                if (bl3) {
                                    object4 = dataArray4[n14];
                                    bl3 = false;
                                } else {
                                    object4 = object4.binary(dataArray4[n14], 1, n6, n);
                                }
                            }
                            ++n14;
                        }
                        object6 = new Real(realTypeArray[n11], f, unitArray[n17]);
                        object4 = object4.binary((Data)object6, 5, mathType, n6, n);
                        ((FieldImpl)dataArray2[n11]).setSample(n9, (Data)object4);
                        ++n11;
                    }
                    ++n9;
                }
            }
        }
        if (n2 == 1) {
            return dataArray2[0];
        }
        return new Tuple(dataArray2);
    }

    public Data derivative(int n) throws VisADException, RemoteException {
        MathType[] mathTypeArray = null;
        RealType[] realTypeArray = null;
        return this.derivative(null, realTypeArray, mathTypeArray, n);
    }

    public Data derivative(MathType[] mathTypeArray, int n) throws VisADException, RemoteException {
        return this.derivative(null, null, mathTypeArray, n);
    }

    public Function derivative(RealType realType, int n) throws VisADException, RemoteException {
        MathType[] mathTypeArray = null;
        RealType[] realTypeArray = new RealType[]{realType};
        return (Function)this.derivative(null, realTypeArray, mathTypeArray, n);
    }

    public Function derivative(RealType realType, MathType mathType, int n) throws VisADException, RemoteException {
        MathType[] mathTypeArray = new MathType[1];
        RealType[] realTypeArray = new RealType[1];
        mathTypeArray[0] = mathType;
        realTypeArray[0] = realType;
        return (Function)this.derivative(null, realTypeArray, mathTypeArray, n);
    }

    public Field resample(Set set, int n, int n2) throws VisADException, RemoteException {
        Data data;
        Data data2;
        float[][] fArray;
        Object object;
        Object object2;
        int n3;
        int n4;
        Object object3;
        boolean bl;
        if (this.DomainSet.equals(set)) {
            return this;
        }
        FieldImpl fieldImpl = new FieldImpl((FunctionType)this.Type, set);
        if (this.isMissing()) {
            return fieldImpl;
        }
        int n5 = this.DomainSet.getDimension();
        if (n5 != set.getDimension()) {
            throw new SetException("FieldImpl.resample: bad Set Dimension");
        }
        CoordinateSystem coordinateSystem = set.getCoordinateSystem();
        Unit[] unitArray = set.getSetUnits();
        ErrorEstimate[] errorEstimateArray = n2 == 202 ? new ErrorEstimate[n5] : set.getSetErrors();
        int n6 = set.getLength();
        int[] nArray = set.getWedge();
        Data[] dataArray = new Data[n6];
        float[][] fArray2 = set.indexToValue(nArray);
        ErrorEstimate[] errorEstimateArray2 = new ErrorEstimate[n5];
        float[][] fArray3 = fArray2;
        try {
            fArray2 = CoordinateSystem.transformCoordinates(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errorEstimateArray2, ((SetType)set.getType()).getDomain(), coordinateSystem, unitArray, errorEstimateArray, fArray2);
        }
        catch (UnitException unitException) {
            throw new VisADException("Sampling set is not compatible with domain");
        }
        boolean bl2 = !(fArray2 == fArray3);
        boolean bl3 = bl = n2 != 202;
        if (bl) {
            int n7 = 0;
            while (n7 < n5) {
                if (errorEstimateArray2[n7] == null) {
                    bl = false;
                }
                ++n7;
            }
        }
        Data[] dataArray2 = new Data[n5];
        double[] dArray = new double[n5];
        if (n == 101 && this.DomainSet instanceof SimpleSet) {
            object3 = new int[n6][];
            float[][] fArray4 = new float[n6][];
            ((GriddedSet)this.DomainSet).valueToInterp(fArray2, (int[][])object3, fArray4);
            n4 = 0;
            while (n4 < n6) {
                int n8 = n3 = object3[n4] == null ? 0 : ((int)object3[n4]).length;
                if (n3 > 0) {
                    object2 = null;
                    int n9 = 0;
                    while (n9 < n3) {
                        Data[] dataArray3 = this.Range;
                        synchronized (dataArray3) {
                            object = this.Range[object3[n4][n9]];
                        }
                        if (object == null) {
                            object2 = null;
                            break;
                        }
                        object2 = object2 == null ? object.multiply(new Real(fArray4[n4][n9])) : object2.add(object.multiply(new Real(fArray4[n4][n9])));
                        ++n9;
                    }
                    dataArray[nArray[n4]] = object2;
                } else {
                    dataArray[nArray[n4]] = ((FunctionType)this.Type).getRange().missingData();
                }
                if (bl && !dataArray[nArray[n4]].isMissing()) {
                    int n10;
                    int n11 = 0;
                    while (n11 < n5) {
                        dArray[n11] = fArray2[n11][n4];
                        ++n11;
                    }
                    fArray = Set.doubleToFloat(ErrorEstimate.init_error_values(errorEstimateArray2, dArray));
                    object2 = new int[2 * n5][];
                    float[][] fArray5 = new float[2 * n5][];
                    fArray4 = new float[2 * n5][];
                    ((SimpleSet)this.DomainSet).valueToInterp(fArray, (int[][])object2, fArray5);
                    int n12 = 0;
                    while (n12 < n5) {
                        Data[] dataArray4;
                        int n13;
                        Data data3 = null;
                        data2 = null;
                        n3 = object2[2 * n12].length;
                        if (n3 > 0) {
                            n13 = 0;
                            while (n13 < n3) {
                                dataArray4 = this.Range;
                                synchronized (dataArray4) {
                                    data = this.Range[object2[2 * n12][n13]];
                                }
                                if (data == null) {
                                    data3 = null;
                                    break;
                                }
                                data3 = data3 == null ? data.multiply(new Real(fArray5[2 * n12][n13])) : data3.add(data.multiply(new Real(fArray5[2 * n12][n13])));
                                ++n13;
                            }
                        }
                        if ((n3 = object2[2 * n12 + 1].length) > 0) {
                            n13 = 0;
                            while (n13 < n3) {
                                dataArray4 = this.Range;
                                synchronized (dataArray4) {
                                    data = this.Range[object2[2 * n12 + 1][n13]];
                                }
                                if (data == null) {
                                    data2 = null;
                                    break;
                                }
                                data2 = data2 == null ? data.multiply(new Real(fArray5[2 * n12 + 1][n13])) : data2.add(data.multiply(new Real(fArray5[2 * n12 + 1][n13])));
                                ++n13;
                            }
                        }
                        dataArray2[n12] = data3 == null || data2 == null ? null : data2.subtract(data3).abs();
                        ++n12;
                    }
                    object = null;
                    if (n2 == 200) {
                        n10 = 0;
                        while (n10 < n5) {
                            data2 = dataArray2[n10].multiply(dataArray2[n10]);
                            object = object == null ? data2 : object.add(data2);
                            ++n10;
                        }
                        object = object.sqrt();
                    } else {
                        n10 = 0;
                        while (n10 < n5) {
                            data2 = dataArray2[n10];
                            object = object == null ? data2 : object.add(data2);
                            ++n10;
                        }
                    }
                    dataArray[nArray[n4]] = dataArray[nArray[n4]].adjustSamplingError((Data)object, n2);
                }
                ++n4;
            }
        } else {
            object3 = this.DomainSet.valueToIndex(fArray2);
            int n14 = 0;
            while (n14 < n6) {
                Data[] dataArray5 = this.Range;
                synchronized (dataArray5) {
                    dataArray[nArray[n14]] = object3[n14] >= 0 && this.Range[object3[n14]] != null ? this.Range[object3[n14]] : ((FunctionType)this.Type).getRange().missingData();
                }
                if (bl && !dataArray[nArray[n14]].isMissing()) {
                    int n15;
                    int n16 = 0;
                    while (n16 < n5) {
                        dArray[n16] = fArray2[n16][n14];
                        ++n16;
                    }
                    fArray = Set.doubleToFloat(ErrorEstimate.init_error_values(errorEstimateArray2, dArray));
                    int[] nArray2 = this.DomainSet.valueToIndex(fArray);
                    int n17 = 0;
                    while (n17 < n5) {
                        Data[] dataArray6 = this.Range;
                        synchronized (dataArray6) {
                            dataArray2[n17] = nArray2[2 * n17] < 0 || this.Range[nArray2[2 * n17]] == null || nArray2[2 * n17 + 1] < 0 || this.Range[nArray2[2 * n17 + 1]] == null ? null : this.Range[nArray2[2 * n17 + 1]].subtract(this.Range[nArray2[2 * n17]]).abs();
                        }
                        ++n17;
                    }
                    object = null;
                    if (n2 == 200) {
                        n15 = 0;
                        while (n15 < n5) {
                            data2 = dataArray2[n15].multiply(dataArray2[n15]);
                            object = object == null ? data2 : object.add(data2);
                            ++n15;
                        }
                        object = object.sqrt();
                    } else {
                        n15 = 0;
                        while (n15 < n5) {
                            data2 = dataArray2[n15];
                            object = object == null ? data2 : object.add(data2);
                            ++n15;
                        }
                    }
                    dataArray[nArray[n14]] = dataArray[nArray[n14]].adjustSamplingError((Data)object, n2);
                }
                ++n14;
            }
        }
        if (bl2) {
            object3 = ((FunctionType)this.Type).getRange();
            if (object3 instanceof RealVectorType) {
                int n18 = fArray2.length;
                float[][] fArray6 = new float[n18][1];
                float[][] fArray7 = new float[n18][1];
                int n19 = 0;
                while (n19 < n6) {
                    int n20 = 0;
                    while (n20 < n18) {
                        fArray6[n20][0] = fArray3[n20][n19];
                        ++n20;
                    }
                    n20 = 0;
                    while (n20 < n18) {
                        fArray7[n20][0] = fArray2[n20][n19];
                        ++n20;
                    }
                    dataArray[n19] = ((RealVectorType)object3).transformVectors(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errorEstimateArray2, ((SetType)set.getType()).getDomain(), coordinateSystem, unitArray, ((RealTuple)dataArray[n19]).getCoordinateSystem(), fArray6, fArray7, (RealTuple)dataArray[n19]);
                    ++n19;
                }
            } else if (object3 instanceof TupleType && !(object3 instanceof RealTupleType)) {
                int n21 = ((TupleType)object3).getDimension();
                n4 = 0;
                n3 = 0;
                while (n3 < n21) {
                    if (((TupleType)object3).getComponent(n3) instanceof RealVectorType) {
                        n4 = 1;
                    }
                    ++n3;
                }
                if (n4 != 0) {
                    n3 = fArray2.length;
                    object2 = new float[n3][1];
                    float[][] fArray8 = new float[n3][1];
                    object = new Data[n21];
                    int n22 = 0;
                    while (n22 < n6) {
                        int n23 = 0;
                        while (n23 < n3) {
                            object2[n23][0] = fArray3[n23][n22];
                            ++n23;
                        }
                        n23 = 0;
                        while (n23 < n3) {
                            fArray8[n23][0] = fArray2[n23][n22];
                            ++n23;
                        }
                        n23 = 0;
                        while (n23 < n21) {
                            MathType mathType = ((TupleType)object3).getComponent(n23);
                            if (mathType instanceof RealVectorType) {
                                data = (RealTuple)((TupleIface)dataArray[n22]).getComponent(n23);
                                object[n23] = ((RealVectorType)mathType).transformVectors(((FunctionType)this.Type).getDomain(), this.DomainCoordinateSystem, this.DomainUnits, errorEstimateArray2, ((SetType)set.getType()).getDomain(), coordinateSystem, unitArray, ((RealTuple)data).getCoordinateSystem(), (float[][])object2, fArray8, (RealTuple)data);
                            } else {
                                object[n23] = ((TupleIface)dataArray[n22]).getComponent(n23);
                            }
                            ++n23;
                        }
                        dataArray[n22] = new Tuple((Data[])object);
                        ++n22;
                    }
                }
            }
        }
        fieldImpl.setSamples(dataArray, false);
        return fieldImpl;
    }

    public DataShadow computeRanges(ShadowType shadowType, DataShadow dataShadow) throws VisADException, RemoteException {
        if (this.isMissing()) {
            return dataShadow;
        }
        ShadowRealTupleType shadowRealTupleType = ((ShadowFunctionType)shadowType).getDomain();
        int n = shadowRealTupleType.getDimension();
        double[][] dArray = new double[2][n];
        dataShadow = this.DomainSet.computeRanges(shadowRealTupleType, dataShadow, dArray, true);
        ShadowType shadowType2 = ((ShadowFunctionType)shadowType).getRange();
        int n2 = 0;
        while (n2 < this.Range.length) {
            Data[] dataArray = this.Range;
            synchronized (dataArray) {
                if (this.Range[n2] != null) {
                    dataShadow = this.Range[n2].computeRanges(shadowType2, dataShadow);
                }
            }
            ++n2;
        }
        return dataShadow;
    }

    public Data adjustSamplingError(Data data, int n) throws VisADException, RemoteException {
        if (this.isMissing() || data == null || data.isMissing()) {
            return this;
        }
        FieldImpl fieldImpl = new FieldImpl((FunctionType)this.Type, this.DomainSet);
        if (this.isMissing()) {
            return fieldImpl;
        }
        Field field = ((Field)data).resample(this.DomainSet, 100, 202);
        Data[] dataArray = new Data[this.Length];
        int n2 = 0;
        while (n2 < this.Length) {
            Data[] dataArray2 = this.Range;
            synchronized (dataArray2) {
                dataArray[n2] = this.Range[n2].adjustSamplingError(field.getSample(n2), n);
            }
            ++n2;
        }
        fieldImpl.setSamples(this.Range, true);
        return fieldImpl;
    }

    public boolean isFlatField() {
        return false;
    }

    public int __len__() throws VisADException, RemoteException {
        return this.getLength();
    }

    public Data __getitem__(int n) throws VisADException, RemoteException {
        return this.getSample(n);
    }

    public void __setitem__(int n, Data data) throws VisADException, RemoteException {
        this.setSample(n, data);
    }

    public void __setitem__(int n, double d) throws VisADException, RemoteException {
        RealType realType = null;
        boolean bl = false;
        MathType mathType = ((FunctionType)this.getType()).getRange();
        if (mathType instanceof RealType) {
            realType = (RealType)mathType;
        } else if (mathType instanceof RealTupleType && ((RealTupleType)mathType).getDimension() == 1) {
            realType = (RealType)((RealTupleType)mathType).getComponent(0);
            bl = true;
        }
        if (realType != null) {
            Real real = new Real(realType, d);
            if (bl) {
                this.__setitem__(n, new RealTuple(new Real[]{real}));
            } else {
                this.__setitem__(n, real);
            }
        } else {
            System.out.println("FieldImpl.__setitem__ bad type");
        }
    }

    public Object clone() {
        FieldImpl fieldImpl;
        try {
            fieldImpl = new FieldImpl((FunctionType)this.Type, this.DomainSet);
            if (this.isMissing()) {
                return fieldImpl;
            }
            Data[] dataArray = this.Range;
            synchronized (dataArray) {
                fieldImpl.setSamples(this.Range, true);
            }
        }
        catch (VisADException visADException) {
            throw new VisADError("FieldImpl.clone: VisADException occured");
        }
        catch (RemoteException remoteException) {
            throw new VisADError("FieldImpl.clone: RemoteException occured");
        }
        return fieldImpl;
    }

    public String longString(String string) throws VisADException, RemoteException {
        StringBuffer stringBuffer = new StringBuffer(string + "FieldImpl\n" + string + "  Type: " + this.Type.toString() + "\n");
        if (this.DomainSet != null) {
            stringBuffer.append(string + "  DomainSet:\n" + this.DomainSet.longString(string + "    "));
        } else {
            stringBuffer.append(string + "  DomainSet: undefined\n");
        }
        if (this.isMissing()) {
            stringBuffer.append("  missing\n");
            return stringBuffer.toString();
        }
        int n = 0;
        while (n < this.Length) {
            stringBuffer.append(string + "  Range value " + n + ":\n" + (this.Range[n] == null ? string + "missing\n" : this.Range[n].longString(string + "    ")));
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FieldImpl)) {
            return false;
        }
        FieldImpl fieldImpl = (FieldImpl)object;
        if (!this.getType().equals(fieldImpl.getType())) {
            return false;
        }
        if (this.Length != fieldImpl.Length) {
            return false;
        }
        if (this.MissingFlag != fieldImpl.MissingFlag) {
            return false;
        }
        return !(this.DomainSet == null || fieldImpl.DomainSet == null ? this.DomainSet != null || fieldImpl.DomainSet != null : !this.DomainSet.equals(fieldImpl.DomainSet));
    }

    public Enumeration domainEnumeration() throws VisADException, RemoteException {
        return new FieldEnumerator(this);
    }

    public FieldImpl(FunctionType functionType) throws VisADException {
        this(functionType, null);
    }

    public FieldImpl(FunctionType functionType, Set set) throws VisADException {
        super(functionType);
        RealTupleType realTupleType = functionType.getDomain();
        if (set == null) {
            set = realTupleType.getDefaultSet();
        }
        if (set == null) {
            throw new SetException("FieldImpl: set cannot be null");
        }
        if (set instanceof DoubleSet || set instanceof FloatSet) {
            throw new SetException("FieldImpl: set may not be DoubleSet or FloatSet");
        }
        if (realTupleType.getDimension() != set.getDimension()) {
            throw new SetException("FieldImpl: set and type dimensions don't match");
        }
        this.DomainSet = realTupleType.equals(((SetType)set.getType()).getDomain()) ? set : (Set)set.cloneButType(new SetType(realTupleType));
        this.DomainCoordinateSystem = this.DomainSet.getCoordinateSystem();
        this.DomainUnits = this.DomainSet.getSetUnits();
        this.Length = this.DomainSet.getLength();
        this.Range = new Data[this.Length];
        this.MissingFlag = true;
    }
}

