/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import visad.CoordinateSystem;
import visad.Field;
import visad.FieldException;
import visad.FunctionType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

class FieldEnumerator
implements Enumeration {
    Field field;
    int[] index;
    int dimension;
    RealTupleType type;
    CoordinateSystem coordinateSystem;
    RealType[] types;
    Unit[] units;

    public boolean hasMoreElements() {
        try {
            return this.index[0] < this.field.getLength();
        }
        catch (RemoteException remoteException) {
            return false;
        }
        catch (VisADException visADException) {
            return false;
        }
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            if (this.index[0] < this.field.getLength()) {
                float[][] fArray = this.field.getDomainSet().indexToValue(this.index);
                this.index[0] = this.index[0] + 1;
                Real[] realArray = new Real[this.dimension];
                int n = 0;
                while (n < this.dimension) {
                    realArray[n] = new Real(this.types[n], fArray[n][0], this.units[n]);
                    ++n;
                }
                return new RealTuple(this.type, realArray, this.coordinateSystem);
            }
            throw new NoSuchElementException("FieldImplEnumerator.nextElement: no more elements");
        }
        catch (VisADException visADException) {
            throw new NoSuchElementException("FieldImplEnumerator.nextElement: " + visADException);
        }
        catch (RemoteException remoteException) {
            throw new NoSuchElementException("FieldImplEnumerator.nextElement: " + remoteException);
        }
    }

    FieldEnumerator(Field field) throws VisADException, RemoteException {
        this.field = field;
        if (this.field.getDomainSet() == null) {
            throw new FieldException("FieldImplEnumerator: DomainSet undefined");
        }
        this.index = new int[1];
        this.index[0] = 0;
        this.dimension = this.field.getDomainSet().getDimension();
        this.type = ((FunctionType)this.field.getType()).getDomain();
        this.coordinateSystem = this.type.getCoordinateSystem();
        if (this.coordinateSystem != null) {
            this.coordinateSystem = this.field.getDomainCoordinateSystem();
        }
        this.types = new RealType[this.dimension];
        this.units = this.field.getDomainUnits();
        int n = 0;
        while (n < this.dimension) {
            this.types[n] = (RealType)this.type.getComponent(n);
            ++n;
        }
    }
}

