/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class ErrorEstimate
implements Serializable,
Comparable {
    private static final double DERIVATIVE_LOW_LIMIT = 0.01;
    private static final double DERIVATIVE_HI_LIMIT = 100.0;
    final double Error;
    final double Mean;
    final long NumberNotMissing;
    final Unit unit;

    public static ErrorEstimate[] copyErrorsArray(ErrorEstimate[] errorEstimateArray) {
        if (errorEstimateArray == null) {
            return null;
        }
        int n = errorEstimateArray.length;
        ErrorEstimate[] errorEstimateArray2 = new ErrorEstimate[n];
        int n2 = 0;
        while (n2 < n) {
            errorEstimateArray2[n2] = errorEstimateArray[n2];
            ++n2;
        }
        return errorEstimateArray2;
    }

    private double binary(int n, ErrorEstimate errorEstimate, ErrorEstimate errorEstimate2, int n2) throws VisADException {
        double d;
        double d2;
        double d3 = Double.NaN;
        if (errorEstimate.isMissing() || errorEstimate2.isMissing() || n2 == 202) {
            return d3;
        }
        Unit unit = null;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: {
                d2 = this.unit != null && errorEstimate.unit != null && !this.unit.equals(errorEstimate.unit) ? Math.abs(this.unit.toThis(errorEstimate.Mean + 0.5 * errorEstimate.Error, errorEstimate.unit) - this.unit.toThis(errorEstimate.Mean - 0.5 * errorEstimate.Error, errorEstimate.unit)) : errorEstimate.Error;
                d = this.unit != null && errorEstimate2.unit != null && !this.unit.equals(errorEstimate2.unit) ? Math.abs(this.unit.toThis(errorEstimate2.Mean + 0.5 * errorEstimate2.Error, errorEstimate2.unit) - this.unit.toThis(errorEstimate2.Mean - 0.5 * errorEstimate2.Error, errorEstimate2.unit)) : errorEstimate2.Error;
                d2 = errorEstimate.Error;
                d = errorEstimate2.Error;
                break;
            }
            case 4: {
                if (errorEstimate.unit != null && errorEstimate2.unit != null) {
                    unit = errorEstimate.unit.multiply(errorEstimate2.unit);
                }
                d2 = errorEstimate.Error * errorEstimate2.Mean;
                d = errorEstimate2.Error * errorEstimate.Mean;
                break;
            }
            case 5: {
                if (errorEstimate.unit != null && errorEstimate2.unit != null) {
                    unit = errorEstimate.unit.divide(errorEstimate2.unit);
                }
                double d4 = Math.max(0.01, Math.abs(errorEstimate2.Mean));
                d2 = errorEstimate.Error / d4;
                d = errorEstimate2.Error * this.Mean / d4;
                break;
            }
            case 6: {
                if (errorEstimate.unit != null && errorEstimate2.unit != null) {
                    unit = errorEstimate2.unit.divide(errorEstimate.unit);
                }
                double d5 = Math.max(0.01, Math.abs(errorEstimate.Mean));
                d = errorEstimate.Error * this.Mean / d5;
                d2 = errorEstimate2.Error / d5;
                break;
            }
            case 7: {
                d2 = errorEstimate.Error * Math.abs(this.Mean) * (errorEstimate2.Mean / Math.max(0.01, Math.abs(errorEstimate.Mean)));
                double d6 = Math.log(Math.abs(errorEstimate.Mean));
                if (Double.isNaN(d6)) {
                    d6 = 1.0;
                }
                d6 = Math.max(0.01, Math.min(100.0, d6));
                d = errorEstimate2.Error * Math.abs(this.Mean) * d6;
                break;
            }
            case 8: {
                double d7 = Math.log(Math.abs(errorEstimate2.Mean));
                if (Double.isNaN(d7)) {
                    d7 = 1.0;
                }
                d7 = Math.max(0.01, Math.min(100.0, d7));
                d2 = errorEstimate.Error * Math.abs(this.Mean) * d7;
                d = errorEstimate2.Error * Math.abs(this.Mean) * (errorEstimate.Mean / Math.max(0.01, Math.abs(errorEstimate2.Mean)));
                break;
            }
            case 11: {
                double d8 = Math.min(100.0, 1.0 + this.Mean * this.Mean) / Math.max(0.01, Math.abs(errorEstimate2.Mean));
                d2 = errorEstimate.Error * d8;
                d = errorEstimate2.Error * this.Mean * d8;
                break;
            }
            case 12: {
                double d9 = Math.min(100.0, 1.0 + this.Mean * this.Mean) / Math.max(0.01, Math.abs(errorEstimate2.Mean));
                d2 = errorEstimate.Error * d9;
                d = errorEstimate2.Error * this.Mean * d9;
                break;
            }
            case 13: {
                double d10 = Math.min(100.0, 1.0 + this.Mean * this.Mean) / Math.max(0.01, Math.abs(errorEstimate.Mean));
                d2 = errorEstimate.Error * this.Mean * d10;
                d = errorEstimate2.Error * d10;
                break;
            }
            case 14: {
                double d11 = Math.min(100.0, 1.0 + this.Mean * this.Mean) / Math.max(0.01, Math.abs(errorEstimate.Mean));
                d2 = errorEstimate.Error * this.Mean * d11;
                d = errorEstimate2.Error * d11;
                break;
            }
            case 15: {
                d2 = errorEstimate.Error;
                d = errorEstimate2.Error * errorEstimate.Mean / Math.max(0.01, Math.abs(errorEstimate2.Mean));
                break;
            }
            case 16: {
                d2 = errorEstimate.Error * errorEstimate2.Mean / Math.max(0.01, Math.abs(errorEstimate.Mean));
                d = errorEstimate2.Error;
                break;
            }
            default: {
                throw new ArithmeticException("ErrorEstimate.binary: illegal operation");
            }
        }
        d3 = n2 == 200 ? Math.sqrt(d2 * d2 + d * d) : Math.abs(d2) + Math.abs(d);
        if (this.unit != null && unit != null && !this.unit.equals(unit)) {
            d3 = Math.abs(this.unit.toThis(this.Mean + 0.5 * d3, unit) - this.unit.toThis(this.Mean - 0.5 * d3, unit));
        }
        return d3;
    }

    private double unary(int n, ErrorEstimate errorEstimate, int n2) throws UnitException {
        double d = Double.NaN;
        if (errorEstimate.isMissing() || n2 == 202) {
            return d;
        }
        switch (n) {
            case 21: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 41: 
            case 42: {
                if (this.unit != null && errorEstimate.unit != null && !this.unit.equals(errorEstimate.unit)) {
                    d = Math.abs(this.unit.toThis(errorEstimate.Mean + 0.5 * errorEstimate.Error, errorEstimate.unit) - this.unit.toThis(errorEstimate.Mean - 0.5 * errorEstimate.Error, errorEstimate.unit));
                    break;
                }
                d = errorEstimate.Error;
                break;
            }
            case 22: 
            case 24: {
                double d2 = Math.sqrt(1.0 - errorEstimate.Mean * errorEstimate.Mean);
                if (Double.isNaN(d2)) {
                    d2 = 1.0;
                }
                d2 = Math.max(0.01, Math.min(100.0, d2));
                d = errorEstimate.Error / d2;
                break;
            }
            case 23: 
            case 25: {
                double d3 = Math.sqrt(1.0 - errorEstimate.Mean * errorEstimate.Mean);
                if (Double.isNaN(d3)) {
                    d3 = 1.0;
                }
                d3 = Math.max(0.01, Math.min(100.0, d3));
                d = errorEstimate.Error * 57.29577951308232 / d3;
                break;
            }
            case 26: {
                d = errorEstimate.Error / Math.min(100.0, 1.0 + errorEstimate.Mean * errorEstimate.Mean);
                break;
            }
            case 27: {
                d = errorEstimate.Error * 57.29577951308232 / Math.min(100.0, 1.0 + errorEstimate.Mean * errorEstimate.Mean);
                break;
            }
            case 29: 
            case 36: {
                double d4 = Math.sqrt(1.0 - this.Mean * this.Mean);
                if (Double.isNaN(d4)) {
                    d4 = 1.0;
                }
                d4 = Math.max(0.01, Math.min(100.0, d4));
                d = errorEstimate.Error * d4;
                break;
            }
            case 30: 
            case 37: {
                double d5 = Math.sqrt(1.0 - this.Mean * this.Mean);
                if (Double.isNaN(d5)) {
                    d5 = 1.0;
                }
                d5 = Math.max(0.01, Math.min(100.0, d5));
                d = errorEstimate.Error * (Math.PI / 180) * d5;
                break;
            }
            case 31: {
                d = errorEstimate.Error * Math.abs(this.Mean);
                break;
            }
            case 33: {
                double d6 = Math.max(0.01, Math.min(100.0, Math.abs(errorEstimate.Mean)));
                d = errorEstimate.Error / d6;
                break;
            }
            case 38: {
                double d7 = Math.max(0.01, Math.min(100.0, 2.0 * Math.abs(this.Mean)));
                d = errorEstimate.Error / d7;
                break;
            }
            case 39: {
                d = errorEstimate.Error * Math.min(100.0, 1.0 + this.Mean * this.Mean);
                break;
            }
            case 40: {
                d = errorEstimate.Error * (Math.PI / 180) * Math.min(100.0, 1.0 + this.Mean * this.Mean);
                break;
            }
            default: {
                throw new ArithmeticException("ErrorEstimate.unary: illegal operation");
            }
        }
        return d;
    }

    public boolean isMissing() {
        return Double.isNaN(this.Error);
    }

    public double getMean() {
        return this.Mean;
    }

    public double getErrorValue() {
        return this.Error;
    }

    public long getNumberNotMissing() {
        return this.NumberNotMissing;
    }

    public Unit getUnit() {
        return this.unit;
    }

    static double[][] init_error_values(ErrorEstimate[] errorEstimateArray) {
        int n = errorEstimateArray.length;
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = errorEstimateArray[n2].getMean();
            ++n2;
        }
        return ErrorEstimate.init_error_values(errorEstimateArray, dArray);
    }

    static double[][] init_error_values(ErrorEstimate[] errorEstimateArray, double[] dArray) {
        int n = errorEstimateArray.length;
        double[][] dArray2 = new double[n][2 * n];
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            double d2 = 0.5 * errorEstimateArray[n2].getErrorValue();
            int n3 = 0;
            while (n3 < n) {
                if (n3 == n2) {
                    dArray2[n2][2 * n3] = d - d2;
                    dArray2[n2][2 * n3 + 1] = d + d2;
                } else {
                    dArray2[n2][2 * n3] = d;
                    dArray2[n2][2 * n3 + 1] = d;
                }
                ++n3;
            }
            ++n2;
        }
        return dArray2;
    }

    public String toString() {
        return "NumberNotMissing = " + this.NumberNotMissing + "  Error = " + (Double.isNaN(this.Error) ? "missing" : Double.toString(this.Error)) + "  Mean = " + (Double.isNaN(this.Mean) ? "missing" : Double.toString(this.Mean));
    }

    public int compareTo(Object object) {
        int n;
        if (object == null) {
            n = 1;
        } else {
            ErrorEstimate errorEstimate = (ErrorEstimate)object;
            if (this.unit == null) {
                n = errorEstimate.unit == null ? new Double(this.Error).compareTo(new Double(errorEstimate.Error)) : -1;
            } else if (errorEstimate.unit == null) {
                n = 1;
            } else {
                try {
                    n = new Double(this.Error).compareTo(new Double(this.unit.toThis(errorEstimate.Error, errorEstimate.unit)));
                }
                catch (UnitException unitException) {
                    n = 1;
                }
            }
        }
        return n;
    }

    public ErrorEstimate(double d, double d2, long l, Unit unit) {
        this.unit = unit;
        if (Double.isNaN(d) || Double.isNaN(d2) || l <= 0L) {
            this.Error = Double.NaN;
            this.Mean = Double.NaN;
            this.NumberNotMissing = 0L;
        } else {
            this.Error = d;
            this.Mean = d2;
            this.NumberNotMissing = l;
        }
    }

    public ErrorEstimate(double d, double d2, Unit unit) {
        this.unit = unit;
        if (Double.isNaN(d)) {
            this.NumberNotMissing = 0L;
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        } else {
            this.NumberNotMissing = 1L;
            this.Mean = d;
            this.Error = d2;
        }
    }

    public ErrorEstimate(ErrorEstimate errorEstimate, ErrorEstimate errorEstimate2, double d, int n) throws VisADException {
        double d2;
        double d3;
        Unit unit;
        Unit unit2;
        long l;
        double d4;
        double d5;
        if (errorEstimate == null) {
            d5 = Double.NaN;
            d4 = Double.NaN;
            l = 0L;
            unit2 = null;
        } else {
            d5 = errorEstimate.Error;
            d4 = errorEstimate.Mean;
            l = errorEstimate.NumberNotMissing;
            unit2 = errorEstimate.unit;
        }
        long l2 = Double.isNaN(d) ? 0 : 1;
        if (errorEstimate2 == null) {
            unit = null;
            d3 = Double.NaN;
            d2 = Double.NaN;
        } else {
            unit = errorEstimate2.unit;
            if (unit2 == null || unit2 == unit) {
                d3 = errorEstimate2.Error;
                d2 = d;
            } else {
                d3 = unit2.toThis(errorEstimate2.Error, unit);
                d2 = unit2.toThis(d, unit);
            }
        }
        this.unit = errorEstimate != null ? unit2 : unit;
        long l3 = l + (long)n;
        if (l3 > 0L) {
            double d6 = 0.0;
            double d7 = 0.0;
            if (!Double.isNaN(d5)) {
                d7 += (double)(l3 - l2) * d5;
            }
            if (!Double.isNaN(d4)) {
                d6 += (double)(l3 - l2) * d4;
            }
            if (!Double.isNaN(d3)) {
                d7 += (double)l2 * d3;
            }
            if (!Double.isNaN(d2)) {
                d6 += (double)l2 * d2;
            }
            this.NumberNotMissing = l3;
            this.Error = d7 / (double)this.NumberNotMissing;
            this.Mean = d6 / (double)this.NumberNotMissing;
        } else {
            this.NumberNotMissing = 0L;
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(double d, Unit unit, int n, ErrorEstimate errorEstimate, ErrorEstimate errorEstimate2, int n2) throws VisADException {
        this.unit = unit;
        if (Double.isNaN(d)) {
            this.NumberNotMissing = 0L;
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        } else {
            this.NumberNotMissing = 1L;
            this.Mean = d;
            this.Error = this.binary(n, errorEstimate, errorEstimate2, n2);
        }
    }

    public ErrorEstimate(double d, Unit unit, int n, ErrorEstimate errorEstimate, int n2) throws VisADException {
        this.unit = unit;
        if (Double.isNaN(d)) {
            this.NumberNotMissing = 0L;
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        } else {
            this.NumberNotMissing = 1L;
            this.Mean = d;
            this.Error = this.unary(n, errorEstimate, n2);
        }
    }

    public ErrorEstimate(double[] dArray, double d, Unit unit) {
        this.unit = unit;
        int n = 0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (!Double.isNaN(dArray[n2])) {
                ++n;
                d2 += dArray[n2];
            }
            ++n2;
        }
        this.NumberNotMissing = n;
        if (this.NumberNotMissing > 0L) {
            this.Mean = d2 / (double)this.NumberNotMissing;
            this.Error = d;
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(float[] fArray, double d, Unit unit) {
        this.unit = unit;
        int n = 0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < fArray.length) {
            if (!Float.isNaN(fArray[n2])) {
                ++n;
                d2 += (double)fArray[n2];
            }
            ++n2;
        }
        this.NumberNotMissing = n;
        if (this.NumberNotMissing > 0L) {
            this.Mean = d2 / (double)this.NumberNotMissing;
            this.Error = d;
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(double[] dArray, Unit unit, int n, ErrorEstimate errorEstimate, ErrorEstimate errorEstimate2, int n2) throws VisADException {
        this.unit = unit;
        int n3 = 0;
        double d = 0.0;
        int n4 = 0;
        while (n4 < dArray.length) {
            if (!Double.isNaN(dArray[n4])) {
                ++n3;
                d += dArray[n4];
            }
            ++n4;
        }
        this.NumberNotMissing = n3;
        if (this.NumberNotMissing > 0L) {
            this.Mean = d / (double)this.NumberNotMissing;
            this.Error = this.binary(n, errorEstimate, errorEstimate2, n2);
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(float[] fArray, Unit unit, int n, ErrorEstimate errorEstimate, ErrorEstimate errorEstimate2, int n2) throws VisADException {
        this.unit = unit;
        int n3 = 0;
        double d = 0.0;
        int n4 = 0;
        while (n4 < fArray.length) {
            if (!Float.isNaN(fArray[n4])) {
                ++n3;
                d += (double)fArray[n4];
            }
            ++n4;
        }
        this.NumberNotMissing = n3;
        if (this.NumberNotMissing > 0L) {
            this.Mean = d / (double)this.NumberNotMissing;
            this.Error = this.binary(n, errorEstimate, errorEstimate2, n2);
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(double[] dArray, Unit unit, int n, ErrorEstimate errorEstimate, int n2) throws VisADException {
        this.unit = unit;
        int n3 = 0;
        double d = 0.0;
        int n4 = 0;
        while (n4 < dArray.length) {
            if (!Double.isNaN(dArray[n4])) {
                ++n3;
                d += dArray[n4];
            }
            ++n4;
        }
        this.NumberNotMissing = n3;
        if (this.NumberNotMissing > 0L) {
            this.Mean = d / (double)this.NumberNotMissing;
            this.Error = this.unary(n, errorEstimate, n2);
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }

    public ErrorEstimate(float[] fArray, Unit unit, int n, ErrorEstimate errorEstimate, int n2) throws VisADException {
        this.unit = unit;
        int n3 = 0;
        double d = 0.0;
        int n4 = 0;
        while (n4 < fArray.length) {
            if (!Float.isNaN(fArray[n4])) {
                ++n3;
                d += (double)fArray[n4];
            }
            ++n4;
        }
        this.NumberNotMissing = n3;
        if (this.NumberNotMissing > 0L) {
            this.Mean = d / (double)this.NumberNotMissing;
            this.Error = this.unary(n, errorEstimate, n2);
        } else {
            this.Mean = Double.NaN;
            this.Error = Double.NaN;
        }
    }
}

