/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import visad.CoordinateSystem;
import visad.Field;
import visad.FunctionType;
import visad.GridCoordinateSystem;
import visad.GriddedSet;
import visad.RealTupleType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.VisADException;

public final class EmpiricalCoordinateSystem
extends CoordinateSystem
implements Serializable {
    private final GridCoordinateSystem worldCS;
    private final GridCoordinateSystem referenceCS;

    protected static GriddedSet ensureNoCoordinateSystem(GriddedSet griddedSet) throws VisADException {
        if (griddedSet.getCoordinateSystem() != null) {
            SetType setType = (SetType)griddedSet.getType();
            RealTupleType realTupleType = setType.getDomain();
            if (realTupleType.getCoordinateSystem() != null) {
                setType = new SetType(new RealTupleType(realTupleType.getRealComponents()));
            }
            griddedSet = GriddedSet.create(setType, griddedSet.getSamples(), griddedSet.getLengths(), null, griddedSet.getSetUnits(), griddedSet.getSetErrors());
        }
        return griddedSet;
    }

    public static EmpiricalCoordinateSystem create(Field field) throws SetException, VisADException, RemoteException {
        Set set = field.getDomainSet();
        float[][] fArray = field.getFloats(false);
        if (!(set instanceof GriddedSet)) {
            throw new SetException("Domain set must be GriddedSet");
        }
        return new EmpiricalCoordinateSystem((GriddedSet)set, GriddedSet.create(((FunctionType)field.getType()).getFlatRange(), fArray, new int[]{fArray[0].length}, null, null, null));
    }

    public static EmpiricalCoordinateSystem inverseCreate(Field field) throws SetException, VisADException, RemoteException {
        Set set = field.getDomainSet();
        float[][] fArray = field.getFloats(false);
        if (!(set instanceof GriddedSet)) {
            throw new SetException("Domain set must be GriddedSet");
        }
        return new EmpiricalCoordinateSystem(GriddedSet.create(((FunctionType)field.getType()).getFlatRange(), fArray, new int[]{fArray[0].length}, null, null, null), (GriddedSet)set);
    }

    public GriddedSet getWorldSet() {
        return this.worldCS.getGriddedSet();
    }

    public GriddedSet getReferenceSet() {
        return this.referenceCS.getGriddedSet();
    }

    public double[][] fromReference(double[][] dArray) throws SetException, VisADException {
        return this.worldCS.toReference(this.referenceCS.fromReference(dArray));
    }

    public double[][] toReference(double[][] dArray) throws SetException, VisADException {
        return this.referenceCS.toReference(this.worldCS.fromReference(dArray));
    }

    public boolean equals(Object object) {
        if (!(object instanceof EmpiricalCoordinateSystem)) {
            return false;
        }
        EmpiricalCoordinateSystem empiricalCoordinateSystem = (EmpiricalCoordinateSystem)object;
        return this.worldCS.equals(empiricalCoordinateSystem.worldCS) && this.referenceCS.equals(empiricalCoordinateSystem.referenceCS);
    }

    public EmpiricalCoordinateSystem(GriddedSet griddedSet, GriddedSet griddedSet2) throws VisADException {
        super(((SetType)griddedSet2.getType()).getDomain(), griddedSet.getSetUnits());
        this.worldCS = new GridCoordinateSystem(EmpiricalCoordinateSystem.ensureNoCoordinateSystem(griddedSet));
        this.referenceCS = new GridCoordinateSystem(EmpiricalCoordinateSystem.ensureNoCoordinateSystem(griddedSet2));
    }
}

