/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public class DisplayTupleType
extends RealTupleType {
    public DisplayTupleType(DisplayRealType[] displayRealTypeArray) throws VisADException {
        this(displayRealTypeArray, null);
    }

    public DisplayTupleType(DisplayRealType[] displayRealTypeArray, CoordinateSystem coordinateSystem) throws VisADException {
        super((RealType[])displayRealTypeArray, coordinateSystem, null);
        if (coordinateSystem != null) {
            RealTupleType realTupleType = coordinateSystem.getReference();
            if (!(realTupleType instanceof DisplayTupleType)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference must be a DisplayTupleType");
            }
            if (Display.DisplaySpatialOffsetTuple.equals(realTupleType)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference cannot be DisplaySpatialOffsetTuple");
            }
            if (Display.DisplayFlow1Tuple.equals(realTupleType)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference cannot be DisplayFlow1Tuple");
            }
            if (Display.DisplayFlow2Tuple.equals(realTupleType)) {
                throw new CoordinateSystemException("DisplayTupleType: CoordinateSystem.Reference cannot be DisplayFlow2Tuple");
            }
            Unit[] unitArray = this.getDefaultUnits();
            Unit[] unitArray2 = coordinateSystem.getCoordinateSystemUnits();
            int n = unitArray.length;
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                if (unitArray[n2] == null) {
                    if (unitArray2[n2] != null) {
                        bl = false;
                    }
                } else if (!unitArray[n2].equals(unitArray2[n2])) {
                    bl = false;
                }
                ++n2;
            }
            if (!bl) {
                throw new UnitException("RealTupleType: CoordinateSystem Units must equal default Units");
            }
        }
        int n = 0;
        while (n < displayRealTypeArray.length) {
            if (displayRealTypeArray[n].getTuple() != null) {
                throw new DisplayException("DisplayTupleType: DisplayRealType already part of a DisplayTupleType");
            }
            displayRealTypeArray[n].setTuple(this, n);
            ++n;
        }
    }

    DisplayTupleType(DisplayRealType[] displayRealTypeArray, boolean bl) {
        this(displayRealTypeArray, (CoordinateSystem)null, bl);
    }

    DisplayTupleType(DisplayRealType[] displayRealTypeArray, CoordinateSystem coordinateSystem, boolean bl) {
        super((RealType[])displayRealTypeArray, coordinateSystem, bl);
        int n = 0;
        while (n < displayRealTypeArray.length) {
            displayRealTypeArray[n].setTuple(this, n);
            ++n;
        }
    }
}

