/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.AxisScale;
import visad.CommonUnit;
import visad.Control;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DataRenderer;
import visad.DataShadow;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.RendererControl;
import visad.ScalarMap;
import visad.Unit;
import visad.VisADException;
import visad.VisADLineArray;
import visad.VisADRay;
import visad.VisADTriangleArray;

public abstract class DisplayRenderer
implements ControlListener {
    private transient DisplayImpl display;
    private transient RendererControl rendererControl = null;
    private Vector cursorStringVector = new Vector();
    String[] animationString = new String[]{null, null};
    private int[] axisOrdinals = new int[]{-1, -1, -1};
    private boolean waitFlag = false;
    private boolean cursor_string = true;
    private float pickThreshhold = 0.05f;

    public float getPickThreshhold() {
        return this.pickThreshhold;
    }

    public void setPickThreshhold(float f) {
        this.pickThreshhold = f;
    }

    public abstract void setBoxAspect(double[] var1);

    public void setDisplay(DisplayImpl displayImpl) throws VisADException {
        if (this.display != null) {
            throw new DisplayException("DisplayRenderer.setDisplay: display already set");
        }
        this.display = displayImpl;
        if (this.rendererControl == null) {
            this.rendererControl = new RendererControl(this.display);
            this.initControl(this.rendererControl);
        } else {
            RendererControl rendererControl = new RendererControl(this.display);
            rendererControl.syncControl(this.rendererControl);
            this.rendererControl = rendererControl;
        }
        this.rendererControl.addControlListener(this);
        this.display.addControl(this.rendererControl);
    }

    public abstract void initControl(RendererControl var1);

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public RendererControl getRendererControl() {
        return this.rendererControl;
    }

    public void setWaitFlag(boolean bl) {
        this.waitFlag = bl;
    }

    public boolean getWaitFlag() {
        return this.waitFlag;
    }

    int getAxisOrdinal(int n) {
        int[] nArray = this.axisOrdinals;
        synchronized (nArray) {
            int n2 = n;
            this.axisOrdinals[n2] = this.axisOrdinals[n2] + 1;
            int n3 = this.axisOrdinals[n];
            Object var3_4 = null;
            return n3;
        }
    }

    void clearAxisOrdinals() {
        int[] nArray = this.axisOrdinals;
        synchronized (nArray) {
            this.axisOrdinals[0] = -1;
            this.axisOrdinals[1] = -1;
            this.axisOrdinals[2] = -1;
        }
        this.clearScales();
    }

    public abstract BufferedImage getImage();

    public abstract void setScale(AxisScale var1) throws VisADException;

    public abstract void setScale(int var1, int var2, VisADLineArray var3, float[] var4) throws VisADException;

    public abstract void setScale(int var1, int var2, VisADLineArray var3, VisADTriangleArray var4, float[] var5) throws VisADException;

    public abstract void clearScales();

    public abstract void clearScale(AxisScale var1);

    public abstract void setScaleOn(boolean var1);

    public boolean getMode2D() {
        return false;
    }

    public void setBackgroundColor(float f, float f2, float f3) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setBackgroundColor(f, f2, f3);
    }

    public void setForegroundColor(float f, float f2, float f3) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setForegroundColor(f, f2, f3);
    }

    public boolean getBoxOn() throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        return this.rendererControl.getBoxOn();
    }

    public void setBoxColor(float f, float f2, float f3) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setBoxColor(f, f2, f3);
    }

    public void setBoxOn(boolean bl) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setBoxOn(bl);
    }

    public float[] getCursorColor() throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        return this.rendererControl.getCursorColor();
    }

    public void setCursorColor(float f, float f2, float f3) throws RemoteException, VisADException {
        if (this.rendererControl == null) {
            throw new VisADException("DisplayRenderer not yet assigned to a Display");
        }
        this.rendererControl.setCursorColor(f, f2, f3);
    }

    public abstract Control makeControl(ScalarMap var1);

    public abstract DataRenderer makeDefaultRenderer();

    public abstract boolean legalDataRenderer(DataRenderer var1);

    public String[] getAnimationString() {
        return this.animationString;
    }

    public void setAnimationString(String[] stringArray) {
        this.animationString[0] = stringArray[0];
        this.animationString[1] = stringArray[1];
    }

    public abstract double[] getCursor();

    public abstract void setCursorOn(boolean var1);

    public abstract void depth_cursor(VisADRay var1);

    public abstract void drag_cursor(VisADRay var1, boolean var2);

    public abstract void setDirectOn(boolean var1);

    public abstract void drag_depth(float var1);

    public abstract boolean anyDirects();

    public abstract MouseBehavior getMouseBehavior();

    public abstract DataRenderer findDirect(VisADRay var1, int var2);

    public void setCursorStringOn(boolean bl) {
        this.cursor_string = bl;
    }

    public Vector getCursorStringVector() {
        if (this.cursor_string) {
            return (Vector)this.cursorStringVector.clone();
        }
        return new Vector();
    }

    public Vector getCursorStringVectorUnconditional() {
        return (Vector)this.cursorStringVector.clone();
    }

    public double getDirectAxisValue(RealType realType) {
        return this.getDirectAxisValue(realType.getName());
    }

    public double getDirectAxisValue(String string) {
        Vector vector = this.cursorStringVector;
        synchronized (vector) {
            if (this.cursorStringVector != null) {
                Enumeration enumeration = this.cursorStringVector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.startsWith(string)) continue;
                    String string3 = string2.substring(string2.indexOf("=") + 2);
                    int n = string3.indexOf(" ");
                    if (n >= 0) {
                        string3 = string3.substring(0, n);
                    }
                    try {
                        double d;
                        double d2 = d = Double.valueOf(string3).doubleValue();
                        Object var3_11 = null;
                        return d2;
                    }
                    catch (NumberFormatException numberFormatException) {
                        double d = Double.NaN;
                        Object var3_12 = null;
                        return d;
                    }
                }
            }
        }
        return Double.NaN;
    }

    public void setCursorStringVector(Vector vector) {
        Vector vector2 = this.cursorStringVector;
        synchronized (vector2) {
            this.cursorStringVector.removeAllElements();
            if (vector != null) {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    this.cursorStringVector.addElement(enumeration.nextElement());
                }
            }
        }
        this.render_trigger();
    }

    public void setCursorStringVector() {
        Vector vector = this.cursorStringVector;
        synchronized (vector) {
            this.cursorStringVector.removeAllElements();
            float[][] fArray = new float[3][1];
            double[] dArray = this.getCursor();
            fArray[0][0] = (float)dArray[0];
            fArray[1][0] = (float)dArray[1];
            fArray[2][0] = (float)dArray[2];
            Enumeration enumeration = this.display.getMapVector().elements();
            while (enumeration.hasMoreElements()) {
                try {
                    Object object;
                    ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                    DisplayRealType displayRealType = scalarMap.getDisplayScalar();
                    DisplayTupleType displayTupleType = displayRealType.getTuple();
                    int n = displayRealType.getTupleIndex();
                    if (displayTupleType == null || !displayTupleType.equals(Display.DisplaySpatialCartesianTuple) && (displayTupleType.getCoordinateSystem() == null || !displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
                    float[] fArray2 = new float[1];
                    if (displayTupleType.equals(Display.DisplaySpatialCartesianTuple)) {
                        fArray2[0] = fArray[n][0];
                    } else {
                        object = displayTupleType.getCoordinateSystem().fromReference(fArray);
                        fArray2[0] = object[n][0];
                    }
                    object = scalarMap.inverseScaleValues(fArray2);
                    RealType realType = (RealType)scalarMap.getScalar();
                    Real real = new Real(realType, (double)object[0]);
                    Unit unit = scalarMap.getOverrideUnit();
                    Unit unit2 = realType.getDefaultUnit();
                    if (!(unit == null || unit.equals(unit2) || Unit.canConvert(unit2, CommonUnit.secondsSinceTheEpoch) && !unit2.getAbsoluteUnit().equals(unit2))) {
                        object[0] = (float[])((float)unit.toThis((double)object[0], unit2));
                        real = new Real(realType, (double)object[0], unit);
                    }
                    String string = real.toValueString();
                    String string2 = scalarMap.getScalarName() + " = " + string;
                    this.cursorStringVector.addElement(string2);
                }
                catch (VisADException visADException) {
                    // empty catch block
                }
            }
        }
        this.render_trigger();
    }

    public void render_trigger() {
    }

    public boolean legalDisplayScalar(DisplayRealType displayRealType) {
        RealTupleType realTupleType;
        int n = 0;
        while (n < Display.DisplayRealArray.length) {
            if (Display.DisplayRealArray[n].equals(displayRealType)) {
                return true;
            }
            ++n;
        }
        return displayRealType.getTuple() != null && displayRealType.getTuple().getCoordinateSystem() != null && ((realTupleType = displayRealType.getTuple().getCoordinateSystem().getReference()).equals(Display.DisplaySpatialCartesianTuple) || realTupleType.equals(Display.DisplayRGBTuple) || realTupleType.equals(Display.DisplayFlow1Tuple) || realTupleType.equals(Display.DisplayFlow2Tuple));
    }

    public void prepareAction(Vector vector, Vector vector2, boolean bl, boolean bl2) throws VisADException, RemoteException {
        Object object;
        DataShadow dataShadow = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (DataRenderer)enumeration.nextElement();
            dataShadow = ((DataRenderer)object).prepareAction(bl, bl2, dataShadow);
        }
        if (dataShadow != null) {
            object = vector2.elements();
            while (object.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)object.nextElement();
                scalarMap.setRange(dataShadow);
            }
        }
        ScalarMap.equalizeFlow(vector2, Display.DisplayFlow1Tuple);
        ScalarMap.equalizeFlow(vector2, Display.DisplayFlow2Tuple);
    }

    public abstract void controlChanged(ControlEvent var1) throws VisADException, RemoteException;
}

