/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.Serializable;
import java.rmi.ConnectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import visad.ActionImpl;
import visad.ActivityHandler;
import visad.AnimationControl;
import visad.BadMappingException;
import visad.ConstantMap;
import visad.Control;
import visad.DataDisplayLink;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayActivity;
import visad.DisplayEvent;
import visad.DisplayException;
import visad.DisplayListener;
import visad.DisplayMapEvent;
import visad.DisplayRealType;
import visad.DisplayReferenceEvent;
import visad.DisplayRenderer;
import visad.DisplayTupleType;
import visad.GraphicsModeControl;
import visad.LocalDisplay;
import visad.MathType;
import visad.MessageEvent;
import visad.MessageListener;
import visad.MouseBehavior;
import visad.ProjectionControl;
import visad.RealType;
import visad.ReferenceActionLink;
import visad.ReferenceException;
import visad.RemoteDataReference;
import visad.RemoteDisplay;
import visad.RemoteDisplayImpl;
import visad.RemoteReferenceLink;
import visad.RemoteSlaveDisplay;
import visad.RemoteSourceListener;
import visad.RemoteVisADException;
import visad.RendererSourceListener;
import visad.ScalarMap;
import visad.ScalarType;
import visad.ThingReference;
import visad.TypeException;
import visad.ValueControl;
import visad.VisADError;
import visad.VisADException;
import visad.browser.Convert;
import visad.browser.Divider;
import visad.collab.CollabUtil;
import visad.collab.ControlMonitorEvent;
import visad.collab.DisplayMonitor;
import visad.collab.DisplayMonitorImpl;
import visad.collab.DisplaySync;
import visad.collab.DisplaySyncImpl;
import visad.util.AnimationWidget;
import visad.util.ContourWidget;
import visad.util.Delay;
import visad.util.GMCWidget;
import visad.util.LabeledColorWidget;
import visad.util.RangeWidget;
import visad.util.SelectRangeWidget;
import visad.util.VisADSlider;

public abstract class DisplayImpl
extends ActionImpl
implements LocalDisplay {
    private Vector MapVector = new Vector();
    private Vector ConstantMapVector = new Vector();
    private Vector RealTypeVector = new Vector();
    private Vector DisplayRealTypeVector = new Vector();
    private Vector ControlVector = new Vector();
    private Vector RendererVector = new Vector();
    private Vector RendererSourceListeners = new Vector();
    private Vector RmtSrcListeners = new Vector();
    private Vector MessageListeners = new Vector();
    private DisplayRenderer displayRenderer;
    Component component;
    private boolean initialize = true;
    private boolean always_initialize = false;
    private boolean redisplay_all = false;
    private int valueArrayLength;
    private int[] valueToScalar;
    private int[] valueToMap;
    private transient Vector ListenerVector = new Vector();
    private Object mapslock = new Object();
    private MouseBehavior mouse = null;
    private transient DisplayMonitor displayMonitor = null;
    private transient DisplaySync displaySync = null;
    private transient DisplayActivity displayActivity = null;
    private Printable printer;
    private boolean cluster = false;
    private RemoteDisplayImpl rd = null;
    private Vector Slaves = new Vector();
    private boolean needWidgetRefresh = true;
    private JPanel widgetPanel = null;
    private static /* synthetic */ Class class$Lvisad$AnimationControl;
    private static /* synthetic */ Class class$Lvisad$ValueControl;

    void copyScalarMaps(RemoteDisplay remoteDisplay) {
        Vector vector;
        try {
            vector = remoteDisplay.getMapVector();
        }
        catch (Exception exception) {
            System.err.println("Couldn't copy ScalarMaps");
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
            try {
                this.addMap((ScalarMap)scalarMap.clone());
            }
            catch (DisplayException displayException) {
                try {
                    this.addMap(new ScalarMap(scalarMap.getScalar(), scalarMap.getDisplayScalar()));
                }
                catch (Exception exception) {
                    System.err.println("Couldn't copy remote ScalarMap " + scalarMap);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void copyConstantMaps(RemoteDisplay remoteDisplay) {
        Vector vector;
        try {
            vector = remoteDisplay.getConstantMapVector();
        }
        catch (Exception exception) {
            System.err.println("Couldn't copy ConstantMaps");
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ConstantMap constantMap = (ConstantMap)enumeration.nextElement();
            try {
                this.addMap((ConstantMap)constantMap.clone());
            }
            catch (DisplayException displayException) {
                try {
                    this.addMap(new ConstantMap(constantMap.getConstant(), constantMap.getDisplayScalar()));
                }
                catch (Exception exception) {
                    System.err.println("Couldn't copy remote ConstantMap " + constantMap);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void copyGraphicsModeControl(RemoteDisplay remoteDisplay) {
        try {
            this.getGraphicsModeControl().syncControl(remoteDisplay.getGraphicsModeControl());
        }
        catch (UnmarshalException unmarshalException) {
            System.err.println("Couldn't copy remote GraphicsModeControl");
            return;
        }
        catch (ConnectException connectException) {
            System.err.println("Couldn't copy remote GraphicsModeControl");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void copyRefLinks(RemoteDisplay remoteDisplay, DataReference[] dataReferenceArray) {
        String[] stringArray;
        Vector vector;
        try {
            vector = remoteDisplay.getReferenceLinks();
        }
        catch (UnmarshalException unmarshalException) {
            System.err.println("Couldn't copy remote DataReferences");
            return;
        }
        catch (ConnectException connectException) {
            System.err.println("Couldn't copy remote DataReferences");
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (dataReferenceArray == null) {
            stringArray = null;
        } else {
            stringArray = new String[dataReferenceArray.length];
            int n = 0;
            while (n < stringArray.length) {
                try {
                    stringArray[n] = dataReferenceArray[n].getName();
                }
                catch (VisADException visADException) {
                    stringArray[n] = null;
                }
                catch (RemoteException remoteException) {
                    stringArray[n] = null;
                }
                ++n;
            }
        }
        Enumeration enumeration = vector.elements();
        if (enumeration.hasMoreElements()) {
            DataRenderer dataRenderer = this.displayRenderer.makeDefaultRenderer();
            String string = dataRenderer.getClass().getName();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object object2;
                ConstantMap[] constantMapArray;
                RemoteDataReference remoteDataReference;
                RemoteReferenceLink remoteReferenceLink = (RemoteReferenceLink)enumeration.nextElement();
                try {
                    remoteDataReference = remoteReferenceLink.getReference();
                }
                catch (Exception exception) {
                    System.err.println("Couldn't copy remote DataReference");
                    remoteDataReference = null;
                }
                if (remoteDataReference != null && stringArray != null) {
                    try {
                        constantMapArray = remoteDataReference.getName();
                    }
                    catch (VisADException visADException) {
                        System.err.println("Couldn't get DataReference name");
                        constantMapArray = null;
                    }
                    catch (RemoteException remoteException) {
                        System.err.println("Couldn't get remote DataReference name");
                        constantMapArray = null;
                    }
                    if (constantMapArray != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            if (constantMapArray.equals(stringArray[n])) {
                                remoteDataReference = null;
                                break;
                            }
                            ++n;
                        }
                    }
                }
                if (remoteDataReference == null) continue;
                constantMapArray = null;
                try {
                    object2 = remoteReferenceLink.getConstantMapVector();
                    int n = ((Vector)object2).size();
                    if (n > 0) {
                        constantMapArray = new ConstantMap[n];
                        int n2 = 0;
                        while (n2 < n) {
                            constantMapArray[n2] = (ConstantMap)((Vector)object2).elementAt(n2);
                            ++n2;
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println("Couldn't copy ConstantMaps for remote DataReference");
                }
                try {
                    object = remoteReferenceLink.getRendererClassName();
                    if (((String)object).equals(string)) {
                        object2 = null;
                    } else {
                        Object obj = Class.forName((String)object).newInstance();
                        object2 = (DataRenderer)obj;
                    }
                }
                catch (Exception exception) {
                    System.err.println("Couldn't copy remote DataRenderer name; using " + string);
                    object2 = null;
                }
                try {
                    object = new RemoteDisplayImpl(this);
                    if (object2 == null) {
                        ((RemoteDisplayImpl)object).addReference(remoteDataReference, constantMapArray);
                        continue;
                    }
                    ((RemoteDisplayImpl)object).addReferences((DataRenderer)object2, remoteDataReference, constantMapArray);
                }
                catch (Exception exception) {
                    System.err.println("Couldn't add remote DataReference " + remoteDataReference);
                }
            }
        }
    }

    protected void syncRemoteData(RemoteDisplay remoteDisplay) throws VisADException, RemoteException {
        this.copyScalarMaps(remoteDisplay);
        this.copyConstantMaps(remoteDisplay);
        this.copyGraphicsModeControl(remoteDisplay);
        if (!this.cluster) {
            this.copyRefLinks(remoteDisplay, null);
        }
        this.notifyAction();
        if (!this.cluster) {
            this.waitForTasks();
        }
        this.displayMonitor.addRemoteListener(remoteDisplay);
        this.initializeControls();
    }

    private void initializeControls() {
        ListIterator listIterator = ((AbstractList)this.ControlVector).listIterator();
        while (listIterator.hasNext()) {
            try {
                Control control = (Control)listIterator.next();
                ControlMonitorEvent controlMonitorEvent = new ControlMonitorEvent(20, (Control)control.clone());
                this.displayMonitor.notifyListeners(controlMonitorEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void notifyListeners(int n, int n2, int n3) throws VisADException, RemoteException {
        this.notifyListeners(new DisplayEvent(this, n, n2, n3));
    }

    public void notifyListeners(DisplayEvent displayEvent) throws VisADException, RemoteException {
        if (this.ListenerVector != null) {
            Vector vector = this.ListenerVector;
            synchronized (vector) {
                Enumeration enumeration = this.ListenerVector.elements();
                while (enumeration.hasMoreElements()) {
                    DisplayListener displayListener = (DisplayListener)enumeration.nextElement();
                    if (displayListener instanceof Remote) {
                        if (this.rd == null) {
                            this.rd = new RemoteDisplayImpl(this);
                        }
                        displayListener.displayChanged(displayEvent.cloneButDisplay(this.rd));
                        continue;
                    }
                    displayListener.displayChanged(displayEvent.cloneButDisplay(this));
                }
            }
        }
    }

    public void addDisplayListener(DisplayListener displayListener) {
        this.ListenerVector.addElement(displayListener);
    }

    public void removeDisplayListener(DisplayListener displayListener) {
        if (displayListener != null) {
            this.ListenerVector.removeElement(displayListener);
        }
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        this.component = component;
    }

    public void reAutoScale() {
        this.initialize = true;
    }

    public void setAlwaysAutoScale(boolean bl) {
        this.always_initialize = bl;
    }

    public void reDisplayAll() {
        this.redisplay_all = true;
        this.notifyAction();
    }

    void addSlave(RemoteSlaveDisplay remoteSlaveDisplay) {
        if (!this.Slaves.contains(remoteSlaveDisplay)) {
            this.Slaves.add(remoteSlaveDisplay);
        }
    }

    void removeSlave(RemoteSlaveDisplay remoteSlaveDisplay) {
        if (this.Slaves.contains(remoteSlaveDisplay)) {
            this.Slaves.remove(remoteSlaveDisplay);
        }
    }

    void removeAllSlaves() {
        this.Slaves.removeAllElements();
    }

    public boolean hasSlaves() {
        return !this.Slaves.isEmpty();
    }

    public void updateSlaves(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getType();
        int[] nArray = new int[n * n2];
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        int[] nArray2 = Convert.encodeRLE(nArray);
        Vector vector = this.Slaves;
        synchronized (vector) {
            int n4 = 0;
            while (n4 < this.Slaves.size()) {
                RemoteSlaveDisplay remoteSlaveDisplay = (RemoteSlaveDisplay)this.Slaves.elementAt(n4);
                try {
                    remoteSlaveDisplay.sendImage(nArray2, n, n2, n3);
                }
                catch (ConnectException connectException) {
                    this.Slaves.remove(n4--);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ++n4;
            }
        }
    }

    public void updateSlaves(String string) {
        Vector vector = this.Slaves;
        synchronized (vector) {
            int n = 0;
            while (n < this.Slaves.size()) {
                RemoteSlaveDisplay remoteSlaveDisplay = (RemoteSlaveDisplay)this.Slaves.elementAt(n);
                try {
                    remoteSlaveDisplay.sendMessage(string);
                }
                catch (ConnectException connectException) {
                    this.Slaves.remove(n--);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ++n;
            }
        }
    }

    public void addReference(ThingReference thingReference) throws VisADException, RemoteException {
        if (!(thingReference instanceof DataReference)) {
            throw new ReferenceException("DisplayImpl.addReference: ref must be DataReference");
        }
        this.addReference((DataReference)thingReference, null);
    }

    public void replaceReference(RemoteDisplay remoteDisplay, ThingReference thingReference) throws VisADException, RemoteException {
        if (!(thingReference instanceof DataReference)) {
            throw new ReferenceException("DisplayImpl.replaceReference: ref must be DataReference");
        }
        this.replaceReference(remoteDisplay, (DataReference)thingReference, null);
    }

    void addLink(DataDisplayLink dataDisplayLink) throws VisADException, RemoteException {
        this.addLink(dataDisplayLink, true);
    }

    private void addLink(DataDisplayLink dataDisplayLink, boolean bl) throws VisADException, RemoteException {
        super.addLink(dataDisplayLink);
        if (bl) {
            this.notifyListeners(new DisplayReferenceEvent((Display)this, 13, dataDisplayLink));
        }
    }

    public void addReference(DataReference dataReference, ConstantMap[] constantMapArray) throws VisADException, RemoteException {
        if (!(dataReference instanceof DataReferenceImpl)) {
            throw new RemoteVisADException("DisplayImpl.addReference: requires DataReferenceImpl");
        }
        if (this.findReference(dataReference) != null) {
            throw new TypeException("DisplayImpl.addReference: link already exists");
        }
        DataRenderer dataRenderer = this.displayRenderer.makeDefaultRenderer();
        DataDisplayLink[] dataDisplayLinkArray = new DataDisplayLink[]{new DataDisplayLink(dataReference, this, this, constantMapArray, dataRenderer, this.getLinkId())};
        this.addLink(dataDisplayLinkArray[0]);
        dataRenderer.setLinks(dataDisplayLinkArray, this);
        Object object = this.mapslock;
        synchronized (object) {
            this.RendererVector.addElement(dataRenderer);
        }
        this.initialize |= this.computeInitialize();
        this.notifyAction();
    }

    public void replaceReference(RemoteDisplay remoteDisplay, DataReference dataReference, ConstantMap[] constantMapArray) throws VisADException, RemoteException {
        this.replaceReferences(remoteDisplay, null, new DataReference[]{dataReference}, new ConstantMap[][]{constantMapArray});
    }

    private boolean computeInitialize() {
        Object object;
        boolean bl = false;
        Vector vector = (Vector)this.MapVector.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (ScalarMap)enumeration.nextElement();
            bl |= ((ScalarMap)object).doInitialize();
        }
        object = (AnimationControl)((Object)this.getControl(class$Lvisad$AnimationControl != null ? class$Lvisad$AnimationControl : (class$Lvisad$AnimationControl = DisplayImpl.class$("visad.AnimationControl"))));
        if (object != null) {
            bl |= object.getSet() == null;
        }
        return bl;
    }

    void adaptedAddReference(RemoteDataReference remoteDataReference, RemoteDisplay remoteDisplay, ConstantMap[] constantMapArray) throws VisADException, RemoteException {
        if (this.findReference(remoteDataReference) != null) {
            throw new TypeException("DisplayImpl.adaptedAddReference: link already exists");
        }
        DataRenderer dataRenderer = this.displayRenderer.makeDefaultRenderer();
        DataDisplayLink[] dataDisplayLinkArray = new DataDisplayLink[]{new DataDisplayLink(remoteDataReference, this, remoteDisplay, constantMapArray, dataRenderer, this.getLinkId())};
        this.addLink(dataDisplayLinkArray[0]);
        dataRenderer.setLinks(dataDisplayLinkArray, this);
        Object object = this.mapslock;
        synchronized (object) {
            this.RendererVector.addElement(dataRenderer);
        }
        this.initialize |= this.computeInitialize();
        this.notifyAction();
    }

    public void addReferences(DataRenderer dataRenderer, DataReference dataReference) throws VisADException, RemoteException {
        this.addReferences(dataRenderer, new DataReference[]{dataReference}, null);
    }

    public void replaceReferences(RemoteDisplay remoteDisplay, DataRenderer dataRenderer, DataReference dataReference) throws VisADException, RemoteException {
        this.replaceReferences(remoteDisplay, dataRenderer, new DataReference[]{dataReference}, null);
    }

    public void addReferences(DataRenderer dataRenderer, DataReference dataReference, ConstantMap[] constantMapArray) throws VisADException, RemoteException {
        this.addReferences(dataRenderer, new DataReference[]{dataReference}, new ConstantMap[][]{constantMapArray});
    }

    public void replaceReferences(RemoteDisplay remoteDisplay, DataRenderer dataRenderer, DataReference dataReference, ConstantMap[] constantMapArray) throws VisADException, RemoteException {
        this.replaceReferences(remoteDisplay, dataRenderer, new DataReference[]{dataReference}, new ConstantMap[][]{constantMapArray});
    }

    public void addReferences(DataRenderer dataRenderer, DataReference[] dataReferenceArray) throws VisADException, RemoteException {
        this.addReferences(dataRenderer, dataReferenceArray, null);
    }

    public void replaceReferences(RemoteDisplay remoteDisplay, DataRenderer dataRenderer, DataReference[] dataReferenceArray) throws VisADException, RemoteException {
        this.replaceReferences(remoteDisplay, dataRenderer, dataReferenceArray, null);
    }

    public void addReferences(DataRenderer dataRenderer, DataReference[] dataReferenceArray, ConstantMap[][] constantMapArray) throws VisADException, RemoteException {
        this.addReferences(dataRenderer, dataReferenceArray, constantMapArray, true);
    }

    private void addReferences(DataRenderer dataRenderer, DataReference[] dataReferenceArray, ConstantMap[][] constantMapArray, boolean bl) throws VisADException, RemoteException {
        if (dataReferenceArray.length < 1) {
            throw new DisplayException("DisplayImpl.addReferences: must have at least one DataReference");
        }
        if (constantMapArray != null && dataReferenceArray.length != constantMapArray.length) {
            throw new DisplayException("DisplayImpl.addReferences: constant_maps length must match refs length");
        }
        if (!this.displayRenderer.legalDataRenderer(dataRenderer)) {
            throw new DisplayException("DisplayImpl.addReferences: illegal DataRenderer class");
        }
        DataDisplayLink[] dataDisplayLinkArray = new DataDisplayLink[dataReferenceArray.length];
        int n = 0;
        while (n < dataReferenceArray.length) {
            if (!(dataReferenceArray[n] instanceof DataReferenceImpl)) {
                throw new RemoteVisADException("DisplayImpl.addReferences: requires DataReferenceImpl");
            }
            if (this.findReference(dataReferenceArray[n]) != null) {
                throw new TypeException("DisplayImpl.addReferences: link already exists");
            }
            dataDisplayLinkArray[n] = constantMapArray == null ? new DataDisplayLink(dataReferenceArray[n], this, this, null, dataRenderer, this.getLinkId()) : new DataDisplayLink(dataReferenceArray[n], this, this, constantMapArray[n], dataRenderer, this.getLinkId());
            this.addLink(dataDisplayLinkArray[n], bl);
            ++n;
        }
        dataRenderer.setLinks(dataDisplayLinkArray, this);
        Object object = this.mapslock;
        synchronized (object) {
            this.RendererVector.addElement(dataRenderer);
        }
        this.initialize |= this.computeInitialize();
        this.notifyAction();
    }

    public void replaceReferences(RemoteDisplay remoteDisplay, DataRenderer dataRenderer, DataReference[] dataReferenceArray, ConstantMap[][] constantMapArray) throws VisADException, RemoteException {
        if (dataRenderer == null) {
            dataRenderer = this.displayRenderer.makeDefaultRenderer();
        }
        this.removeAllReferences();
        this.addReferences(dataRenderer, dataReferenceArray, constantMapArray, false);
        this.copyRefLinks(remoteDisplay, dataReferenceArray);
    }

    void adaptedAddReferences(DataRenderer dataRenderer, DataReference[] dataReferenceArray, RemoteDisplay remoteDisplay, ConstantMap[][] constantMapArray) throws VisADException, RemoteException {
        if (dataReferenceArray.length < 1) {
            throw new DisplayException("DisplayImpl.addReferences: must have at least one DataReference");
        }
        if (constantMapArray != null && dataReferenceArray.length != constantMapArray.length) {
            throw new DisplayException("DisplayImpl.addReferences: constant_maps length must match refs length");
        }
        if (!this.displayRenderer.legalDataRenderer(dataRenderer)) {
            throw new DisplayException("DisplayImpl.addReferences: illegal DataRenderer class");
        }
        DataDisplayLink[] dataDisplayLinkArray = new DataDisplayLink[dataReferenceArray.length];
        int n = 0;
        while (n < dataReferenceArray.length) {
            if (this.findReference(dataReferenceArray[n]) != null) {
                throw new TypeException("DisplayImpl.addReferences: link already exists");
            }
            dataDisplayLinkArray[n] = dataReferenceArray[n] instanceof DataReferenceImpl ? (constantMapArray == null ? new DataDisplayLink(dataReferenceArray[n], this, this, null, dataRenderer, this.getLinkId()) : new DataDisplayLink(dataReferenceArray[n], this, this, constantMapArray[n], dataRenderer, this.getLinkId())) : (constantMapArray == null ? new DataDisplayLink(dataReferenceArray[n], this, remoteDisplay, null, dataRenderer, this.getLinkId()) : new DataDisplayLink(dataReferenceArray[n], this, remoteDisplay, constantMapArray[n], dataRenderer, this.getLinkId()));
            this.addLink(dataDisplayLinkArray[n]);
            ++n;
        }
        dataRenderer.setLinks(dataDisplayLinkArray, this);
        Object object = this.mapslock;
        synchronized (object) {
            this.RendererVector.addElement(dataRenderer);
        }
        this.initialize |= this.computeInitialize();
        this.notifyAction();
    }

    public void removeReference(ThingReference thingReference) throws VisADException, RemoteException {
        if (!(thingReference instanceof DataReferenceImpl)) {
            throw new RemoteVisADException("ActionImpl.removeReference: requires DataReferenceImpl");
        }
        this.adaptedDisplayRemoveReference((DataReference)thingReference);
    }

    void removeLinks(DataDisplayLink[] dataDisplayLinkArray) throws RemoteException, VisADException {
        int n = dataDisplayLinkArray.length - 1;
        while (n >= 0) {
            if (dataDisplayLinkArray[n] != null) {
                dataDisplayLinkArray[n].clearMaps();
            }
            --n;
        }
        super.removeLinks(dataDisplayLinkArray);
    }

    void adaptedDisplayRemoveReference(DataReference dataReference) throws VisADException, RemoteException {
        DataDisplayLink dataDisplayLink = (DataDisplayLink)this.findReference(dataReference);
        if (dataDisplayLink == null) {
            return;
        }
        DataRenderer dataRenderer = dataDisplayLink.getRenderer();
        DataDisplayLink[] dataDisplayLinkArray = dataRenderer.getLinks();
        Object object = this.mapslock;
        synchronized (object) {
            dataRenderer.clearAVControls();
            dataRenderer.clearScene();
            this.RendererVector.removeElement(dataRenderer);
        }
        this.removeLinks(dataDisplayLinkArray);
    }

    public void removeAllReferences() throws VisADException, RemoteException {
        Vector vector = (Vector)this.RendererVector.clone();
        Object object = this.mapslock;
        synchronized (object) {
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                DataRenderer dataRenderer = (DataRenderer)iterator.next();
                dataRenderer.clearAVControls();
                dataRenderer.clearScene();
                DataDisplayLink[] dataDisplayLinkArray = dataRenderer.getLinks();
                iterator.remove();
                this.removeLinks(dataDisplayLinkArray);
            }
            this.RendererVector.removeAllElements();
            this.initialize = true;
        }
    }

    public void controlChanged() {
        this.notifyAction();
    }

    public boolean checkTicks() {
        return true;
    }

    public void destroy() throws VisADException, RemoteException {
        Object object;
        VisADException visADException = null;
        RemoteException remoteException = null;
        this.stop();
        if (this.displayActivity != null) {
            this.displayActivity.destroy();
        }
        this.notifyListeners(new DisplayEvent(this, 15));
        if (this.ListenerVector != null) {
            object = this.ListenerVector;
            synchronized (object) {
                this.ListenerVector.removeAllElements();
            }
        }
        try {
            this.removeAllReferences();
        }
        catch (RemoteException remoteException2) {
            remoteException = remoteException2;
        }
        catch (VisADException visADException2) {
            visADException = visADException2;
        }
        try {
            this.clearMaps();
        }
        catch (RemoteException remoteException3) {
            remoteException = remoteException3;
        }
        catch (VisADException visADException3) {
            visADException = visADException3;
        }
        object = (AnimationControl)((Object)this.getControl(class$Lvisad$AnimationControl != null ? class$Lvisad$AnimationControl : (class$Lvisad$AnimationControl = DisplayImpl.class$("visad.AnimationControl"))));
        if (object != null) {
            object.stop();
        }
        if (visADException != null) {
            throw visADException;
        }
        if (remoteException != null) {
            throw remoteException;
        }
    }

    public void doAction() throws VisADException, RemoteException {
        if (this.mapslock == null) {
            return;
        }
        Object object = this.mapslock;
        synchronized (object) {
            Object object2;
            Enumeration enumeration;
            block28: {
                block27: {
                    if (this.RendererVector == null) break block27;
                    if (this.displayRenderer != null) break block28;
                }
                Object var2_2 = null;
                return;
            }
            this.displayRenderer.setWaitFlag(true);
            Vector vector = (Vector)this.MapVector.clone();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration2.nextElement();
                scalarMap.setTicks();
            }
            int n = this.getDisplayScalarCount();
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = -1;
                ++n2;
            }
            this.valueArrayLength = 0;
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration2.nextElement();
                enumeration = scalarMap.getDisplayScalar();
                scalarMap.setValueIndex(this.valueArrayLength);
                ++this.valueArrayLength;
            }
            this.valueToScalar = new int[this.valueArrayLength];
            this.valueToMap = new int[this.valueArrayLength];
            int n3 = 0;
            while (n3 < vector.size()) {
                enumeration = (ScalarMap)vector.elementAt(n3);
                DisplayRealType displayRealType = ((ScalarMap)((Object)enumeration)).getDisplayScalar();
                this.valueToScalar[((ScalarMap)((Object)enumeration)).getValueIndex()] = this.getDisplayScalarIndex(displayRealType);
                this.valueToMap[((ScalarMap)((Object)enumeration)).getValueIndex()] = n3++;
            }
            Vector vector2 = (Vector)this.RendererVector.clone();
            enumeration = vector2.elements();
            boolean bl = false;
            if (this.initialize) {
                enumeration = vector2.elements();
                while (!bl && enumeration.hasMoreElements()) {
                    object2 = (DataRenderer)enumeration.nextElement();
                    bl |= ((DataRenderer)object2).checkAction();
                }
            }
            if (this.redisplay_all) {
                bl = true;
                this.redisplay_all = false;
            }
            if (!this.initialize || bl) {
                Object object3;
                this.displayRenderer.prepareAction(vector2, vector, bl, this.initialize);
                boolean bl2 = false;
                enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    ScalarMap scalarMap = (ScalarMap)enumeration2.nextElement();
                    if (!scalarMap.badRange()) continue;
                    bl2 = true;
                }
                enumeration = vector2.elements();
                boolean bl3 = false;
                while (enumeration.hasMoreElements()) {
                    DataRenderer dataRenderer = (DataRenderer)enumeration.nextElement();
                    bl3 |= dataRenderer.getBadScale(bl2);
                }
                this.initialize = bl3;
                if (this.always_initialize) {
                    this.initialize = true;
                }
                boolean bl4 = false;
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    object3 = (DataRenderer)enumeration.nextElement();
                    boolean bl5 = ((DataRenderer)object3).doAction();
                    bl4 |= bl5;
                }
                if (bl4) {
                    object3 = (AnimationControl)((Object)this.getControl(class$Lvisad$AnimationControl != null ? class$Lvisad$AnimationControl : (class$Lvisad$AnimationControl = DisplayImpl.class$("visad.AnimationControl"))));
                    if (object3 != null) {
                        object3.init();
                    }
                    Vector vector3 = this.ControlVector;
                    synchronized (vector3) {
                        Enumeration enumeration3 = this.ControlVector.elements();
                        while (enumeration3.hasMoreElements()) {
                            Control control;
                            if (!(class$Lvisad$ValueControl != null ? class$Lvisad$ValueControl : DisplayImpl.class$("visad.ValueControl")).isInstance(control = (Control)enumeration3.nextElement())) continue;
                            ((ValueControl)((Object)control)).init();
                        }
                    }
                    this.notifyListeners(2, 0, 0);
                }
            }
            enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                object2 = (ScalarMap)enumeration2.nextElement();
                ((ScalarMap)object2).resetTicks();
            }
            this.displayRenderer.setWaitFlag(false);
        }
    }

    protected abstract DisplayRenderer getDefaultDisplayRenderer();

    public DisplayRenderer getDisplayRenderer() {
        return this.displayRenderer;
    }

    public Vector getRendererVector() {
        return (Vector)this.RendererVector.clone();
    }

    public int getDisplayScalarCount() {
        return this.DisplayRealTypeVector.size();
    }

    public DisplayRealType getDisplayScalar(int n) {
        return (DisplayRealType)this.DisplayRealTypeVector.elementAt(n);
    }

    public int getDisplayScalarIndex(DisplayRealType displayRealType) {
        int n;
        Vector vector = this.DisplayRealTypeVector;
        synchronized (vector) {
            DisplayTupleType displayTupleType = displayRealType.getTuple();
            if (displayTupleType != null) {
                int n2 = displayTupleType.getDimension();
                int n3 = 0;
                while (n3 < n2) {
                    try {
                        DisplayRealType displayRealType2 = (DisplayRealType)displayTupleType.getComponent(n3);
                        int n4 = this.DisplayRealTypeVector.indexOf(displayRealType2);
                        if (n4 < 0) {
                            this.DisplayRealTypeVector.addElement(displayRealType2);
                        }
                    }
                    catch (VisADException visADException) {
                        // empty catch block
                    }
                    ++n3;
                }
            }
            if ((n = this.DisplayRealTypeVector.indexOf(displayRealType)) < 0) {
                this.DisplayRealTypeVector.addElement(displayRealType);
                n = this.DisplayRealTypeVector.indexOf(displayRealType);
            }
        }
        return n;
    }

    public int getScalarCount() {
        return this.RealTypeVector.size();
    }

    public ScalarType getScalar(int n) {
        return (ScalarType)this.RealTypeVector.elementAt(n);
    }

    public int getScalarIndex(ScalarType scalarType) throws RemoteException {
        return this.RealTypeVector.indexOf(scalarType);
    }

    public void addMap(ScalarMap scalarMap) throws VisADException, RemoteException {
        this.addMap(scalarMap, 0);
    }

    public void addMap(ScalarMap scalarMap, int n) throws VisADException, RemoteException {
        Object object = this.mapslock;
        synchronized (object) {
            int n2;
            Object object2;
            Object object3;
            Object object4;
            Serializable serializable;
            ScalarType scalarType;
            if (!this.RendererVector.isEmpty()) {
                scalarType = scalarMap.getScalar();
                serializable = (Vector)this.RendererVector.clone();
                object4 = ((AbstractList)((Object)serializable)).iterator();
                while (object4.hasNext()) {
                    object3 = (DataRenderer)object4.next();
                    object2 = ((DataRenderer)object3).getLinks();
                    object4.remove();
                    int n3 = 0;
                    while (n3 < ((DataDisplayLink[])object2).length) {
                        if (scalarMap instanceof ConstantMap) {
                            if (object2[n3].getData() != null) {
                                throw new DisplayException("DisplayImpl.addMap(ConstantMap): data must be null in all DataReferences");
                            }
                        } else if (MathType.findScalarType(object2[n3].getType(), scalarType)) {
                            throw new DisplayException("DisplayImpl.addMap(): ScalarType may not occur in any DataReference");
                        }
                        ++n3;
                    }
                }
            }
            if (!this.displayRenderer.legalDisplayScalar((DisplayRealType)(scalarType = scalarMap.getDisplayScalar()))) {
                throw new BadMappingException("DisplayImpl.addMap: " + scalarMap.getDisplayScalar() + " illegal for this DisplayRenderer");
            }
            if ((Display.LineWidth.equals(scalarType) || Display.PointSize.equals(scalarType)) && !(scalarMap instanceof ConstantMap)) {
                throw new BadMappingException("DisplayImpl.addMap: " + scalarMap.getDisplayScalar() + " for ConstantMap only");
            }
            scalarMap.setDisplay(this);
            if (scalarMap instanceof ConstantMap) {
                serializable = this.ConstantMapVector;
                synchronized (serializable) {
                    object3 = this.ConstantMapVector.elements();
                    while (object3.hasMoreElements()) {
                        object2 = (ConstantMap)object3.nextElement();
                        if (!((ScalarMap)object2).getDisplayScalar().equals(scalarMap.getDisplayScalar())) continue;
                        throw new BadMappingException("Display.addMap: two ConstantMaps have the same DisplayScalar");
                    }
                    this.ConstantMapVector.addElement(scalarMap);
                }
            }
            serializable = scalarMap.getScalar();
            object4 = scalarMap.getDisplayScalar();
            object3 = this.MapVector;
            synchronized (object3) {
                Enumeration enumeration = this.MapVector.elements();
                while (enumeration.hasMoreElements()) {
                    ScalarMap scalarMap2 = (ScalarMap)enumeration.nextElement();
                    if (((ScalarType)serializable).equals(scalarMap2.getScalar()) && ((RealType)object4).equals(scalarMap2.getDisplayScalar()) && !((RealType)object4).equals(Display.Shape)) {
                        throw new BadMappingException("Display.addMap: two ScalarMaps with the same RealType & DisplayRealType");
                    }
                    if (!((RealType)object4).equals(Display.Animation) || !scalarMap2.getDisplayScalar().equals(Display.Animation)) continue;
                    throw new BadMappingException("Display.addMap: two RealTypes are mapped to Animation");
                }
                this.MapVector.addElement(scalarMap);
                this.needWidgetRefresh = true;
            }
            object3 = this.RealTypeVector;
            synchronized (object3) {
                n2 = this.RealTypeVector.indexOf(serializable);
                if (n2 < 0) {
                    this.RealTypeVector.addElement(serializable);
                    n2 = this.RealTypeVector.indexOf(serializable);
                }
            }
            scalarMap.setScalarIndex(n2);
            scalarMap.setControl();
            this.addDisplayScalar(scalarMap);
            this.notifyListeners(new DisplayMapEvent((Display)this, 11, scalarMap, n));
            scalarMap.addScalarMapListener(this.displayMonitor);
        }
    }

    void addDisplayScalar(ScalarMap scalarMap) {
        int n;
        DisplayRealType displayRealType = scalarMap.getDisplayScalar();
        Vector vector = this.DisplayRealTypeVector;
        synchronized (vector) {
            DisplayTupleType displayTupleType = displayRealType.getTuple();
            if (displayTupleType != null) {
                int n2 = displayTupleType.getDimension();
                int n3 = 0;
                while (n3 < n2) {
                    try {
                        DisplayRealType displayRealType2 = (DisplayRealType)displayTupleType.getComponent(n3);
                        int n4 = this.DisplayRealTypeVector.indexOf(displayRealType2);
                        if (n4 < 0) {
                            this.DisplayRealTypeVector.addElement(displayRealType2);
                        }
                    }
                    catch (VisADException visADException) {
                        // empty catch block
                    }
                    ++n3;
                }
            }
            if ((n = this.DisplayRealTypeVector.indexOf(displayRealType)) < 0) {
                this.DisplayRealTypeVector.addElement(displayRealType);
                n = this.DisplayRealTypeVector.indexOf(displayRealType);
            }
        }
        scalarMap.setDisplayScalarIndex(n);
    }

    public void clearMaps() throws VisADException, RemoteException {
        Object object = this.mapslock;
        synchronized (object) {
            Cloneable cloneable;
            Enumeration enumeration;
            if (!this.RendererVector.isEmpty()) {
                throw new DisplayException("DisplayImpl.clearMaps: RendererVector must be empty");
            }
            Vector vector = this.MapVector;
            synchronized (vector) {
                enumeration = this.MapVector.elements();
                while (enumeration.hasMoreElements()) {
                    cloneable = (ScalarMap)enumeration.nextElement();
                    cloneable.nullDisplay();
                    cloneable.removeScalarMapListener(this.displayMonitor);
                }
                this.MapVector.removeAllElements();
                this.needWidgetRefresh = true;
            }
            vector = this.ConstantMapVector;
            synchronized (vector) {
                enumeration = this.ConstantMapVector.elements();
                while (enumeration.hasMoreElements()) {
                    cloneable = (ConstantMap)enumeration.nextElement();
                    cloneable.nullDisplay();
                    cloneable.removeScalarMapListener(this.displayMonitor);
                }
                this.ConstantMapVector.removeAllElements();
            }
            vector = this.ControlVector;
            synchronized (vector) {
                enumeration = this.ControlVector.elements();
                while (enumeration.hasMoreElements()) {
                    cloneable = (Control)enumeration.nextElement();
                    ((Control)cloneable).removeControlListener(this.displayMonitor);
                    ((Control)cloneable).setInstanceNumber(-1);
                }
                this.ControlVector.removeAllElements();
                cloneable = this.getGraphicsModeControl();
                if (cloneable != null) {
                    this.addControl((Control)cloneable);
                }
                if ((cloneable = this.getProjectionControl()) != null) {
                    this.addControl((Control)cloneable);
                }
                if ((cloneable = this.displayRenderer.getRendererControl()) != null) {
                    this.addControl((Control)cloneable);
                }
            }
            this.RealTypeVector.removeAllElements();
            vector = this.DisplayRealTypeVector;
            synchronized (vector) {
                this.DisplayRealTypeVector.removeAllElements();
                int n = 0;
                while (n < Display.DisplayRealArray.length) {
                    this.DisplayRealTypeVector.addElement(Display.DisplayRealArray[n]);
                    ++n;
                }
            }
            this.displayRenderer.clearAxisOrdinals();
            this.displayRenderer.setAnimationString(new String[]{null, null});
        }
        this.notifyListeners(new DisplayEvent(this, 12));
    }

    public Vector getMapVector() {
        return (Vector)this.MapVector.clone();
    }

    public Vector getConstantMapVector() {
        return (Vector)this.ConstantMapVector.clone();
    }

    private int getInstanceNumber(Control control) {
        Class<?> clazz = control.getClass();
        int n = 0;
        Enumeration enumeration = this.ControlVector.elements();
        while (enumeration.hasMoreElements()) {
            Control control2 = (Control)enumeration.nextElement();
            if (!clazz.isInstance(control2)) continue;
            if (control == control2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int getConnectionID(RemoteDisplay remoteDisplay) throws RemoteException {
        return this.displayMonitor.getConnectionID(remoteDisplay);
    }

    public void addControl(Control control) {
        if (control != null && !this.ControlVector.contains(control)) {
            this.ControlVector.addElement(control);
            control.setIndex(this.ControlVector.indexOf(control));
            control.setInstanceNumber(this.getInstanceNumber(control));
            control.addControlListener(this.displayMonitor);
        }
    }

    public Control getControl(Class clazz) {
        return this.getControl(clazz, 0);
    }

    public Control getControl(Class clazz, int n) {
        return this.getControls(clazz, null, n);
    }

    public Vector getControls(Class clazz) {
        Vector vector = new Vector();
        this.getControls(clazz, vector, -1);
        return vector;
    }

    private Control getControls(Class clazz, Vector vector, int n) {
        if (clazz == null) {
            return null;
        }
        GraphicsModeControl graphicsModeControl = this.getGraphicsModeControl();
        if (clazz.isInstance(graphicsModeControl)) {
            if (vector == null) {
                return graphicsModeControl;
            }
            vector.addElement(graphicsModeControl);
        } else {
            Vector vector2 = this.ControlVector;
            synchronized (vector2) {
                Enumeration enumeration = this.ControlVector.elements();
                while (enumeration.hasMoreElements()) {
                    Control control = (Control)enumeration.nextElement();
                    if (!clazz.isInstance(control)) continue;
                    if (vector != null) {
                        vector.addElement(control);
                        continue;
                    }
                    if (control.getInstanceNumber() != n) continue;
                    Control control2 = control;
                    Object var6_9 = null;
                    return control2;
                }
            }
        }
        return null;
    }

    public int getNumberOfControls() {
        return this.ControlVector.size();
    }

    public Vector getControlVector() {
        return (Vector)this.ControlVector.clone();
    }

    public Container getWidgetPanel() {
        if (this.needWidgetRefresh) {
            Vector vector = this.MapVector;
            synchronized (vector) {
                if (this.widgetPanel == null) {
                    this.widgetPanel = new JPanel();
                    this.widgetPanel.setLayout(new BoxLayout(this.widgetPanel, 1));
                } else {
                    this.widgetPanel.removeAll();
                }
                if (this.getLinks().size() > 0) {
                    GMCWidget gMCWidget = new GMCWidget(this.getGraphicsModeControl());
                    this.addToWidgetPanel(gMCWidget, false);
                }
                int n = 0;
                while (n < this.MapVector.size()) {
                    Object object;
                    ScalarMap scalarMap = (ScalarMap)this.MapVector.elementAt(n);
                    DisplayRealType displayRealType = scalarMap.getDisplayScalar();
                    try {
                        object = new double[2];
                        double[] dArray = new double[2];
                        double[] dArray2 = new double[2];
                        boolean bl = scalarMap.getScale((double[])object, dArray, dArray2);
                        if (bl) {
                            RangeWidget rangeWidget = new RangeWidget(scalarMap);
                            this.addToWidgetPanel(rangeWidget, true);
                        }
                    }
                    catch (VisADException visADException) {
                        // empty catch block
                    }
                    try {
                        if (displayRealType.equals(Display.RGB) || displayRealType.equals(Display.RGBA)) {
                            try {
                                object = new LabeledColorWidget(scalarMap);
                                this.addToWidgetPanel((Component)object, true);
                            }
                            catch (VisADException visADException) {
                            }
                            catch (RemoteException remoteException) {}
                        } else if (displayRealType.equals(Display.SelectValue)) {
                            object = new VisADSlider(scalarMap);
                            ((JComponent)object).setAlignmentX(0.5f);
                            this.addToWidgetPanel((Component)object, true);
                        } else if (displayRealType.equals(Display.SelectRange)) {
                            object = new SelectRangeWidget(scalarMap);
                            this.addToWidgetPanel((Component)object, true);
                        } else if (displayRealType.equals(Display.IsoContour)) {
                            object = new ContourWidget(scalarMap);
                            this.addToWidgetPanel((Component)object, true);
                        } else if (displayRealType.equals(Display.Animation)) {
                            object = new AnimationWidget(scalarMap);
                            this.addToWidgetPanel((Component)object, true);
                        }
                    }
                    catch (VisADException visADException) {
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    ++n;
                }
            }
            this.needWidgetRefresh = false;
        }
        return this.widgetPanel;
    }

    private void addToWidgetPanel(Component component, boolean bl) {
        if (bl) {
            this.widgetPanel.add(new Divider());
        }
        this.widgetPanel.add(component);
    }

    public int getValueArrayLength() {
        return this.valueArrayLength;
    }

    public int[] getValueToScalar() {
        return this.valueToScalar;
    }

    public int[] getValueToMap() {
        return this.valueToMap;
    }

    public abstract ProjectionControl getProjectionControl();

    public abstract GraphicsModeControl getGraphicsModeControl();

    public static void delay(int n) {
        new Delay(n);
    }

    public static void printStack(String string) {
        try {
            throw new DisplayException("printStack: " + string);
        }
        catch (DisplayException displayException) {
            displayException.printStackTrace();
            return;
        }
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public Vector getRenderers() {
        return (Vector)this.RendererVector.clone();
    }

    public int getAPI() throws VisADException {
        throw new VisADException("No API specified");
    }

    public DisplayMonitor getDisplayMonitor() {
        return this.displayMonitor;
    }

    public DisplaySync getDisplaySync() {
        return this.displaySync;
    }

    public void setMouseBehavior(MouseBehavior mouseBehavior) {
        this.mouse = mouseBehavior;
    }

    public MouseBehavior getMouseBehavior() {
        return this.mouse;
    }

    public double[] make_matrix(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (this.mouse != null) {
            return this.mouse.make_matrix(d, d2, d3, d4, d5, d6, d7);
        }
        return null;
    }

    public double[] multiply_matrix(double[] dArray, double[] dArray2) {
        if (this.mouse != null && dArray != null && dArray2 != null) {
            return this.mouse.multiply_matrix(dArray, dArray2);
        }
        return null;
    }

    public BufferedImage getImage() {
        return this.getImage(false);
    }

    public BufferedImage getImage(boolean bl) {
        Thread thread = Thread.currentThread();
        String string = thread.getName();
        if (thread.equals(this.getCurrentActionThread()) || string.startsWith("J3D-Renderer") || string.startsWith("AWT-EventQueue")) {
            throw new VisADError("cannot call getImage() from Thread: " + string);
        }
        if (bl) {
            new Syncher(this);
        }
        return this.displayRenderer.getImage();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        ScalarMap scalarMap;
        String string2 = string + "Display\n";
        Enumeration enumeration = this.MapVector.elements();
        while (enumeration.hasMoreElements()) {
            scalarMap = (ScalarMap)enumeration.nextElement();
            string2 = string2 + scalarMap.toString(string + "    ");
        }
        enumeration = this.ConstantMapVector.elements();
        while (enumeration.hasMoreElements()) {
            scalarMap = (ConstantMap)enumeration.nextElement();
            string2 = string2 + ((ConstantMap)scalarMap).toString(string + "    ");
        }
        return string2;
    }

    public Printable getPrintable() {
        if (this.printer == null) {
            this.printer = new Printable(this){
                private final /* synthetic */ DisplayImpl this$0;

                public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
                    if (n >= 1) {
                        return 1;
                    }
                    BufferedImage bufferedImage = this.this$0.getImage();
                    graphics.drawImage(bufferedImage, (int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), this.this$0.component);
                    return 0;
                }
                {
                    this.this$0 = displayImpl;
                    this.constructor$0(displayImpl);
                }

                private final void constructor$0(DisplayImpl displayImpl) {
                }
            };
        }
        return this.printer;
    }

    void handleRunDisconnectException(ReferenceActionLink referenceActionLink) {
        if (!(referenceActionLink instanceof DataDisplayLink)) {
            return;
        }
        DataDisplayLink dataDisplayLink = (DataDisplayLink)referenceActionLink;
    }

    public void connectionFailed(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        Object object;
        try {
            this.removeLinks(new DataDisplayLink[]{dataDisplayLink});
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        if (dataRenderer != null && ((DataDisplayLink[])(object = dataRenderer.getLinks())).length <= 1) {
            this.deleteRenderer(dataRenderer);
        }
        object = this.RmtSrcListeners.elements();
        while (object.hasMoreElements()) {
            RemoteSourceListener remoteSourceListener = (RemoteSourceListener)object.nextElement();
            remoteSourceListener.dataSourceLost(dataDisplayLink.getName());
        }
    }

    public void addRendererSourceListener(RendererSourceListener rendererSourceListener) {
        this.RendererSourceListeners.addElement(rendererSourceListener);
    }

    public void removeRendererSourceListener(RendererSourceListener rendererSourceListener) {
        this.RendererSourceListeners.removeElement(rendererSourceListener);
    }

    private void deleteRenderer(DataRenderer dataRenderer) {
        this.RendererVector.removeElement(dataRenderer);
        Enumeration enumeration = this.RendererSourceListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RendererSourceListener)enumeration.nextElement()).rendererDeleted(dataRenderer);
        }
    }

    public void addDataSourceListener(RemoteSourceListener remoteSourceListener) {
        this.addRemoteSourceListener(remoteSourceListener);
    }

    public void removeDataSourceListener(RemoteSourceListener remoteSourceListener) {
        this.removeRemoteSourceListener(remoteSourceListener);
    }

    public void addRemoteSourceListener(RemoteSourceListener remoteSourceListener) {
        this.RmtSrcListeners.addElement(remoteSourceListener);
    }

    public void removeRemoteSourceListener(RemoteSourceListener remoteSourceListener) {
        this.RmtSrcListeners.removeElement(remoteSourceListener);
    }

    public void lostCollabConnection(int n) {
        Enumeration enumeration = this.RmtSrcListeners.elements();
        while (enumeration.hasMoreElements()) {
            ((RemoteSourceListener)enumeration.nextElement()).collabSourceLost(n);
        }
    }

    public void addMessageListener(MessageListener messageListener) {
        this.MessageListeners.addElement(messageListener);
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.MessageListeners.removeElement(messageListener);
    }

    public void sendMessage(MessageEvent messageEvent) throws RemoteException {
        RemoteException remoteException = null;
        Enumeration enumeration = this.MessageListeners.elements();
        while (enumeration.hasMoreElements()) {
            MessageListener messageListener = (MessageListener)enumeration.nextElement();
            try {
                messageListener.receiveMessage(messageEvent);
            }
            catch (RemoteException remoteException2) {
                if (CollabUtil.isDisconnectException(remoteException2)) {
                    this.MessageListeners.removeElement(messageListener);
                    continue;
                }
                remoteException = remoteException2;
            }
        }
        if (remoteException != null) {
            throw remoteException;
        }
    }

    void setAspectCartesian(double[] dArray) throws VisADException, RemoteException {
        if (this.mapslock == null) {
            return;
        }
        Object object = this.mapslock;
        synchronized (object) {
            ScalarMap scalarMap;
            Vector vector = (Vector)this.MapVector.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                scalarMap = (ScalarMap)enumeration.nextElement();
                scalarMap.setAspectCartesian(dArray);
            }
            vector = (Vector)this.ConstantMapVector.clone();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                scalarMap = (ConstantMap)enumeration.nextElement();
                ((ConstantMap)scalarMap).setAspectCartesian(dArray);
            }
            this.getDisplayRenderer().setBoxAspect(dArray);
            this.reDisplayAll();
        }
    }

    public void addActivityHandler(ActivityHandler activityHandler) throws VisADException {
        if (this.displayActivity == null) {
            this.displayActivity = new DisplayActivity(this);
        }
        this.displayActivity.addHandler(activityHandler);
    }

    public void removeActivityHandler(ActivityHandler activityHandler) throws VisADException {
        if (this.displayActivity == null) {
            this.displayActivity = new DisplayActivity(this);
        }
        this.displayActivity.removeHandler(activityHandler);
    }

    public void updateBusyStatus() {
        if (this.displayActivity != null) {
            this.displayActivity.updateBusyStatus();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DisplayImpl(String string, DisplayRenderer displayRenderer) throws VisADException, RemoteException {
        super(string);
        int n = 0;
        while (n < Display.DisplayRealArray.length) {
            this.DisplayRealTypeVector.addElement(Display.DisplayRealArray[n]);
            ++n;
        }
        this.displayMonitor = new DisplayMonitorImpl(this);
        this.displaySync = new DisplaySyncImpl(this);
        this.displayRenderer = displayRenderer != null ? displayRenderer : this.getDefaultDisplayRenderer();
        this.displayRenderer.setDisplay(this);
        this.clearMaps();
    }

    public DisplayImpl(RemoteDisplay remoteDisplay, DisplayRenderer displayRenderer) throws VisADException, RemoteException {
        this(remoteDisplay, displayRenderer, false);
    }

    public DisplayImpl(RemoteDisplay remoteDisplay, DisplayRenderer displayRenderer, boolean bl) throws VisADException, RemoteException {
        super(remoteDisplay.getName() + ".remote");
        Class<?> clazz;
        this.cluster = bl;
        String string = remoteDisplay.getDisplayClassName();
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DisplayException("Cannot find remote display class " + string);
        }
        if (!clazz.isInstance(this)) {
            throw new DisplayException("Cannot construct " + this.getClass().getName() + " from remote " + string);
        }
        int n = 0;
        while (n < Display.DisplayRealArray.length) {
            this.DisplayRealTypeVector.addElement(Display.DisplayRealArray[n]);
            ++n;
        }
        this.displayMonitor = new DisplayMonitorImpl(this, this.cluster);
        this.displaySync = new DisplaySyncImpl(this, this.cluster);
        if (displayRenderer != null) {
            this.displayRenderer = displayRenderer;
        } else {
            try {
                String string2 = remoteDisplay.getDisplayRendererClassName();
                Object obj = Class.forName(string2).newInstance();
                this.displayRenderer = (DisplayRenderer)obj;
            }
            catch (Exception exception) {
                this.displayRenderer = this.getDefaultDisplayRenderer();
            }
        }
        this.displayRenderer.setDisplay(this);
        this.clearMaps();
    }

    public class Syncher
    implements DisplayListener {
        private ProjectionControl control;
        int count;

        public void displayChanged(DisplayEvent displayEvent) throws VisADException, RemoteException {
            if (displayEvent.getId() == 2) {
                this.count = 2;
                this.control.setMatrix(this.control.getMatrix());
            } else if (displayEvent.getId() == 3) {
                if (this.count > 0) {
                    this.control.setMatrix(this.control.getMatrix());
                    --this.count;
                } else if (this.count == 0) {
                    Syncher syncher = this;
                    synchronized (syncher) {
                        this.notify();
                    }
                    --this.count;
                }
            }
        }

        Syncher(DisplayImpl displayImpl2) {
            try {
                Syncher syncher = this;
                synchronized (syncher) {
                    this.control = displayImpl2.getProjectionControl();
                    this.count = -1;
                    displayImpl2.disableAction();
                    displayImpl2.addDisplayListener(this);
                    displayImpl2.reDisplayAll();
                    displayImpl2.enableAction();
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            displayImpl2.removeDisplayListener(this);
        }
    }
}

