/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.Timer;
import visad.ActivityHandler;
import visad.DisplayImpl;
import visad.VisADException;

public class DisplayActivity {
    private static final int DEFAULT_IDLE_MILLISECONDS = 250;
    private static final boolean DEBUG = false;
    private transient DisplayImpl dpy;
    private int interval;
    private long lastBusyEvt;
    private boolean isBusy;
    private transient Timer busyTimer;
    private transient BusyAction busyAction;
    private transient ArrayList handlerList;

    public void destroy() {
        Timer timer = this.busyTimer;
        synchronized (timer) {
            if (this.busyAction != null) {
                this.busyTimer.removeActionListener(this.busyAction);
                this.busyAction = null;
            }
            this.busyTimer.stop();
        }
    }

    public void addHandler(ActivityHandler activityHandler) throws VisADException {
        if (this.handlerList == null) {
            throw new VisADException("No handler list found; was this object serialized?");
        }
        if (!this.busyTimer.isRunning()) {
            this.busyTimer.restart();
        }
        this.handlerList.add(activityHandler);
    }

    public void removeHandler(ActivityHandler activityHandler) throws VisADException {
        if (this.handlerList == null) {
            throw new VisADException("No handler list found; was this object serialized?");
        }
        ((AbstractCollection)this.handlerList).remove(activityHandler);
        if (this.handlerList.size() == 0 && this.busyTimer.isRunning()) {
            this.busyTimer.stop();
        }
    }

    private void notifyList(boolean bl) {
        if (this.handlerList != null && this.busyTimer != null) {
            ArrayList arrayList = this.handlerList;
            synchronized (arrayList) {
                int n = this.handlerList.size();
                int n2 = 0;
                while (n2 < n) {
                    ActivityHandler activityHandler = (ActivityHandler)this.handlerList.get(n2);
                    if (bl) {
                        activityHandler.busyDisplay(this.dpy);
                    } else {
                        activityHandler.idleDisplay(this.dpy);
                    }
                    ++n2;
                }
            }
        }
    }

    public void updateBusyStatus() {
        long l = System.currentTimeMillis();
        if (!(this.isBusy || l >= this.lastBusyEvt && l <= this.lastBusyEvt + (long)this.interval)) {
            this.isBusy = true;
            if (this.busyAction == null && this.busyTimer != null) {
                Timer timer = this.busyTimer;
                synchronized (timer) {
                    if (this.busyAction == null) {
                        this.busyAction = new BusyAction();
                        this.busyTimer.addActionListener(this.busyAction);
                    }
                }
            }
            this.notifyList(true);
        }
        this.lastBusyEvt = l;
    }

    static /* synthetic */ boolean access$4() {
        return DEBUG;
    }

    public DisplayActivity(DisplayImpl displayImpl) {
        this(displayImpl, 250);
    }

    public DisplayActivity(DisplayImpl displayImpl, int n) {
        this.dpy = displayImpl;
        this.interval = n < 100 ? 100 : n;
        this.lastBusyEvt = System.currentTimeMillis() - (long)this.interval;
        this.isBusy = false;
        this.busyAction = new BusyAction();
        this.busyTimer = new Timer(this.interval, this.busyAction);
        this.busyTimer.removeActionListener(this.busyAction);
        this.busyAction = null;
        this.handlerList = new ArrayList();
    }

    private class BusyAction
    implements ActionListener {
        private static final int MAX_IDLE = 10;
        private int idleCount = 0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (!DisplayActivity.this.isBusy) {
                ++this.idleCount;
                if (this.idleCount > 10 && DisplayActivity.this.busyTimer != null) {
                    Timer timer = DisplayActivity.this.busyTimer;
                    synchronized (timer) {
                        DisplayActivity.this.busyTimer.removeActionListener(DisplayActivity.this.busyAction);
                        DisplayActivity.this.busyAction = null;
                    }
                }
            } else {
                long l = System.currentTimeMillis();
                if (DisplayActivity.this.lastBusyEvt + (long)DisplayActivity.this.interval <= l) {
                    DisplayActivity.this.isBusy = false;
                    this.idleCount = 0;
                    DisplayActivity.this.notifyList(false);
                }
            }
        }

        BusyAction() {
        }
    }
}

