/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.text.ChoiceFormat;
import java.util.Vector;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.Factor;
import visad.OffsetUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.UnitException;

public final class DerivedUnit
extends Unit
implements Serializable {
    private static AddPow addPow = new AddPow();
    private static SubPow subPow = new SubPow();
    Factor[] factors;

    protected static Factor[] newFactors(BaseUnit[] baseUnitArray, int[] nArray) {
        Factor[] factorArray = new Factor[baseUnitArray.length];
        int n = 0;
        while (n < baseUnitArray.length) {
            factorArray[n] = new Factor(baseUnitArray[n], nArray[n]);
            ++n;
        }
        return factorArray;
    }

    protected Unit protectedClone(String string) {
        return new DerivedUnit(this, string);
    }

    public Unit pow(int n) {
        DerivedUnit derivedUnit;
        if (n == 1) {
            derivedUnit = this;
        } else {
            Factor[] factorArray = new Factor[this.factors.length];
            int n2 = 0;
            while (n2 < this.factors.length) {
                Factor factor = this.factors[n2];
                factorArray[n2] = new Factor(factor.baseUnit, factor.power * n);
                ++n2;
            }
            derivedUnit = new DerivedUnit(factorArray);
        }
        return derivedUnit;
    }

    public Unit root(int n) throws IllegalArgumentException {
        DerivedUnit derivedUnit;
        if (n == 0) {
            throw new IllegalArgumentException(this.getClass().getName() + ".root(int): zero root");
        }
        if (n == 1) {
            derivedUnit = this;
        } else {
            Factor[] factorArray = new Factor[this.factors.length];
            int n2 = 0;
            while (n2 < this.factors.length) {
                Factor factor = this.factors[n2];
                if (factor.power % n != 0) {
                    throw new IllegalArgumentException(this.getClass().getName() + ".root(int): " + "Non-integral resulting dimension");
                }
                factorArray[n2] = new Factor(factor.baseUnit, factor.power / n);
                ++n2;
            }
            derivedUnit = new DerivedUnit(factorArray);
        }
        return derivedUnit;
    }

    public Unit pow(double d) throws IllegalArgumentException {
        Unit unit;
        if (this.factors.length == 0) {
            unit = this;
        } else if (Math.abs(d) > 1.0) {
            double d2 = Math.rint(d);
            if (d < ChoiceFormat.previousDouble(d2) || d > ChoiceFormat.nextDouble(d2)) {
                throw new IllegalArgumentException(this.getClass().getName() + ".pow(double): " + "Non-integral power");
            }
            unit = this.pow((int)d2);
        } else {
            double d3 = 1.0 / d;
            double d4 = Math.rint(d3);
            if (d3 < ChoiceFormat.previousDouble(d4) || d3 > ChoiceFormat.nextDouble(d4)) {
                throw new IllegalArgumentException(this.getClass().getName() + ".pow(double): " + "Non-integral reciprocal power");
            }
            unit = this.root((int)d4);
        }
        return unit;
    }

    public Unit scale(double d) throws UnitException {
        return new ScaledUnit(d, this);
    }

    public Unit shift(double d) throws UnitException {
        return new OffsetUnit(d, this);
    }

    public String getDefinition() {
        String string;
        if (this.factors == null) {
            string = "<unconstructed DerivedUnit>";
        } else {
            StringBuffer stringBuffer = new StringBuffer(80);
            int n = 0;
            while (n < this.factors.length) {
                if (this.factors[n].power == 1) {
                    stringBuffer.append(this.factors[n].baseUnit.toString() + ".");
                } else if (this.factors[n].power != 0) {
                    stringBuffer.append(this.factors[n].baseUnit.toString() + this.factors[n].power + ".");
                }
                ++n;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public static void main(String[] stringArray) throws UnitException {
        BaseUnit baseUnit = SI.meter;
        BaseUnit baseUnit2 = SI.second;
        DerivedUnit derivedUnit = new DerivedUnit(new BaseUnit[]{baseUnit, baseUnit2}, new int[]{1, -1});
        Unit unit = derivedUnit.pow(2);
        System.out.println("speed=\"" + derivedUnit + "\"");
        System.out.println("speed.pow(2)=\"" + derivedUnit.pow(2) + "\"");
        System.out.println("speed.pow(2.0+ULP)=\"" + derivedUnit.pow(ChoiceFormat.nextDouble(2.0)) + "\"");
        System.out.println("speed2.root(2)=\"" + unit.root(2) + "\"");
        System.out.println("speed2.pow(1/(2.0+ULP))=\"" + unit.pow(1.0 / ChoiceFormat.nextDouble(2.0)) + "\"");
        System.out.println("speed*meter=\"" + derivedUnit.multiply(baseUnit) + "\"");
        System.out.println("meter*speed=\"" + baseUnit.multiply(derivedUnit) + "\"");
        System.out.println("speed/meter=\"" + derivedUnit.divide(baseUnit) + "\"");
        System.out.println("meter/speed=\"" + baseUnit.divide(derivedUnit) + "\"");
        System.out.println("speed.toThis(5,speed)=" + derivedUnit.toThis(5.0, (Unit)derivedUnit));
        System.out.println("speed.toThat(5,speed)=" + derivedUnit.toThat(5.0, (Unit)derivedUnit));
        double[] dArray = derivedUnit.toThis(new double[]{1.0, 2.0}, derivedUnit);
        System.out.println("speed.toThis({1,2},speed)=" + dArray[0] + "," + dArray[1]);
        dArray = derivedUnit.toThat(new double[]{1.0, 2.0}, derivedUnit);
        System.out.println("speed.toThat({1,2},speed)=" + dArray[0] + "," + dArray[1]);
        DerivedUnit derivedUnit2 = (DerivedUnit)derivedUnit.pow(2).multiply(SI.kilogram);
        System.out.println("energy=\"" + derivedUnit2 + "\"");
        System.out.println("Checking exceptions:");
        try {
            derivedUnit.toThis(5.0, (Unit)derivedUnit2);
            System.err.println("ERROR: energy -> speed");
            System.exit(1);
        }
        catch (UnitException unitException) {
            System.out.println(unitException.getMessage());
        }
        try {
            System.out.println("speed.pow(2+2*ULP)=\"" + derivedUnit.pow(ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(2.0))) + "\"");
            System.err.println("ERROR: IllegalArgumentException not thrown!");
            System.exit(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
        }
        try {
            System.out.println("speed2.pow(1/(2+2*ULP))=\"" + unit.pow(1.0 / ChoiceFormat.nextDouble(ChoiceFormat.nextDouble(2.0))) + "\"");
            System.err.println("ERROR: IllegalArgumentException not thrown!");
            System.exit(1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
        }
    }

    private Vector[] common(DerivedUnit derivedUnit) {
        int n;
        Vector[] vectorArray = new Vector[3];
        int n2 = this.factors.length + derivedUnit.factors.length;
        vectorArray[0] = new Vector(n2);
        vectorArray[1] = new Vector(n2);
        vectorArray[2] = new Vector(n2);
        int n3 = 0;
        while (n3 < this.factors.length) {
            if (this.factors[n3].power != 0) {
                n = 0;
                while (n < derivedUnit.factors.length) {
                    if (derivedUnit.factors[n].power != 0 && this.factors[n3].baseUnit.equals(derivedUnit.factors[n].baseUnit)) {
                        vectorArray[2].addElement(new Factor[]{this.factors[n3], derivedUnit.factors[n]});
                        break;
                    }
                    ++n;
                }
                if (n == derivedUnit.factors.length) {
                    vectorArray[0].addElement(this.factors[n3]);
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < derivedUnit.factors.length) {
            if (derivedUnit.factors[n3].power != 0) {
                n = 0;
                while (n < this.factors.length) {
                    if (this.factors[n].power != 0 && this.factors[n].baseUnit.equals(derivedUnit.factors[n3].baseUnit)) break;
                    ++n;
                }
                if (n == this.factors.length) {
                    vectorArray[1].addElement(derivedUnit.factors[n3]);
                }
            }
            ++n3;
        }
        return vectorArray;
    }

    public Unit multiply(Unit unit) throws UnitException {
        return unit instanceof DerivedUnit ? this.multiply((DerivedUnit)unit) : unit.multiply(this);
    }

    public Unit multiply(DerivedUnit derivedUnit) {
        return addPow.multOp(this, derivedUnit);
    }

    public Unit divide(Unit unit) throws UnitException {
        return unit instanceof DerivedUnit ? this.divide((DerivedUnit)unit) : unit.divideInto(this);
    }

    Unit divide(DerivedUnit derivedUnit) {
        return subPow.multOp(this, derivedUnit);
    }

    protected Unit divideInto(Unit unit) throws UnitException {
        return unit.divide(this);
    }

    boolean sameDimensionality(DerivedUnit derivedUnit) {
        Vector[] vectorArray = this.common(derivedUnit);
        if (vectorArray[0].size() != 0 || vectorArray[1].size() != 0) {
            return false;
        }
        int n = vectorArray[2].size();
        int n2 = 0;
        while (n2 < n) {
            Factor[] factorArray = (Factor[])vectorArray[2].elementAt(n2);
            if (factorArray[0].power != factorArray[1].power) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    boolean reciprocalDimensionality(DerivedUnit derivedUnit) {
        Vector[] vectorArray = this.common(derivedUnit);
        if (vectorArray[0].size() != 0 || vectorArray[1].size() != 0) {
            return false;
        }
        int n = vectorArray[2].size();
        int n2 = 0;
        while (n2 < n) {
            Factor[] factorArray = (Factor[])vectorArray[2].elementAt(n2);
            if (factorArray[0].power != -factorArray[1].power) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public double[] toThis(double[] dArray, Unit unit) throws UnitException {
        return unit instanceof DerivedUnit ? this.toThis(dArray, (DerivedUnit)unit) : unit.toThat(dArray, (Unit)this);
    }

    public float[] toThis(float[] fArray, Unit unit) throws UnitException {
        return unit instanceof DerivedUnit ? this.toThis(fArray, (DerivedUnit)unit) : unit.toThat(fArray, (Unit)this);
    }

    double[] toThis(double[] dArray, DerivedUnit derivedUnit) throws UnitException {
        double[] dArray2;
        if (this.sameDimensionality(derivedUnit)) {
            dArray2 = new double[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                dArray2[n] = dArray[n];
                ++n;
            }
        } else if (this.reciprocalDimensionality(derivedUnit)) {
            dArray2 = new double[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                dArray2[n] = 1.0 / dArray[n];
                ++n;
            }
        } else {
            throw new UnitException("Attempt to convert from unit \"" + derivedUnit + "\" to unit \"" + this + "\"");
        }
        return dArray2;
    }

    float[] toThis(float[] fArray, DerivedUnit derivedUnit) throws UnitException {
        float[] fArray2;
        if (this.sameDimensionality(derivedUnit)) {
            fArray2 = new float[fArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray2[n] = fArray[n];
                ++n;
            }
        } else if (this.reciprocalDimensionality(derivedUnit)) {
            fArray2 = new float[fArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray2[n] = 1.0f / fArray[n];
                ++n;
            }
        } else {
            throw new UnitException("Attempt to convert from unit \"" + derivedUnit + "\" to unit \"" + this + "\"");
        }
        return fArray2;
    }

    public double[] toThat(double[] dArray, Unit unit) throws UnitException {
        return unit instanceof DerivedUnit ? this.toThat(dArray, (DerivedUnit)unit) : unit.toThis(dArray, (Unit)this);
    }

    public float[] toThat(float[] fArray, Unit unit) throws UnitException {
        return unit instanceof DerivedUnit ? this.toThat(fArray, (DerivedUnit)unit) : unit.toThis(fArray, (Unit)this);
    }

    double[] toThat(double[] dArray, DerivedUnit derivedUnit) throws UnitException {
        return derivedUnit.toThis(dArray, this);
    }

    float[] toThat(float[] fArray, DerivedUnit derivedUnit) throws UnitException {
        return derivedUnit.toThis(fArray, this);
    }

    public boolean isConvertible(Unit unit) {
        DerivedUnit derivedUnit;
        boolean bl = unit == null ? false : (unit instanceof DerivedUnit ? this.sameDimensionality(derivedUnit = (DerivedUnit)unit) || this.reciprocalDimensionality(derivedUnit) : unit.isConvertible(this));
        return bl;
    }

    public boolean equals(Unit unit) {
        if (unit == null) {
            return false;
        }
        if (unit instanceof BaseUnit) {
            return this.equals(new DerivedUnit((BaseUnit)unit));
        }
        if (!(unit instanceof DerivedUnit)) {
            return unit.equals(this);
        }
        int n = this.factors.length;
        if (n != ((DerivedUnit)unit).factors.length) {
            return false;
        }
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = false;
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                if (!blArray[n3] && this.factors[n2].equals(((DerivedUnit)unit).factors[n3])) {
                    blArray[n3] = true;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (!blArray[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public DerivedUnit() {
        this(new BaseUnit[0], new int[0], "");
    }

    public DerivedUnit(String string) {
        this(new BaseUnit[0], new int[0], string);
    }

    public DerivedUnit(BaseUnit baseUnit) {
        this(new BaseUnit[]{baseUnit}, new int[]{1}, baseUnit.getIdentifier());
    }

    public DerivedUnit(BaseUnit[] baseUnitArray, int[] nArray) {
        this(DerivedUnit.newFactors(baseUnitArray, nArray), baseUnitArray.length == 1 ? baseUnitArray[0].getIdentifier() : null);
    }

    public DerivedUnit(BaseUnit[] baseUnitArray, int[] nArray, String string) {
        this(DerivedUnit.newFactors(baseUnitArray, nArray), string);
    }

    public DerivedUnit(DerivedUnit derivedUnit, String string) {
        this(derivedUnit.factors, string);
    }

    private DerivedUnit(Factor[] factorArray) {
        this(factorArray, null);
    }

    private DerivedUnit(Factor[] factorArray, String string) {
        super(string);
        Factor factor;
        int n = 0;
        int n2 = 0;
        while (n2 < factorArray.length) {
            factor = factorArray[n2];
            if (factor != null && factor.power != 0) {
                ++n;
            }
            ++n2;
        }
        this.factors = new Factor[n];
        n = 0;
        n2 = 0;
        while (n2 < factorArray.length) {
            factor = factorArray[n2];
            if (factor != null && factor.power != 0) {
                this.factors[n++] = factor;
            }
            ++n2;
        }
    }

    /* synthetic */ DerivedUnit(1 var1_1, Factor[] factorArray) {
        this(factorArray);
    }

    static abstract class Op {
        public DerivedUnit multOp(DerivedUnit derivedUnit, DerivedUnit derivedUnit2) {
            Vector[] vectorArray = derivedUnit.common(derivedUnit2);
            int n = vectorArray[0].size();
            int n2 = vectorArray[1].size();
            int n3 = vectorArray[2].size();
            Factor[] factorArray = new Factor[n + n2 + n3];
            int n4 = 0;
            int n5 = 0;
            while (n5 < n) {
                factorArray[n4++] = (Factor)vectorArray[0].elementAt(n5);
                ++n5;
            }
            n5 = 0;
            while (n5 < n2) {
                factorArray[n4++] = this.op((Factor)vectorArray[1].elementAt(n5));
                ++n5;
            }
            n5 = 0;
            while (n5 < n3) {
                Factor[] factorArray2 = (Factor[])vectorArray[2].elementAt(n5);
                factorArray[n4++] = this.op(factorArray2[0], factorArray2[1]);
                ++n5;
            }
            return new DerivedUnit(null, factorArray);
        }

        protected abstract Factor op(Factor var1);

        protected abstract Factor op(Factor var1, Factor var2);

        Op() {
        }
    }

    private static final class AddPow
    extends Op {
        protected Factor op(Factor factor) {
            return factor;
        }

        protected Factor op(Factor factor, Factor factor2) {
            return new Factor(factor.baseUnit, factor.power + factor2.power);
        }

        AddPow() {
        }
    }

    private static final class SubPow
    extends Op {
        protected Factor op(Factor factor) {
            return new Factor(factor.baseUnit, -factor.power);
        }

        protected Factor op(Factor factor, Factor factor2) {
            return new Factor(factor.baseUnit, factor.power - factor2.power);
        }

        SubPow() {
        }
    }
}

