/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import visad.Delaunay;
import visad.SetException;
import visad.VisADException;

public class DelaunayOverlap
extends Delaunay {
    static final float[][] m_samples = new float[][]{{65.0f, 142.0f, 215.0f, 315.0f, 373.0f, 435.0f, 39.0f, 118.0f, 202.0f, 320.0f, 373.0f, 455.0f, 40.0f, 114.0f, 206.0f, 307.0f, 384.0f, 457.0f, 66.0f, 128.0f, 208.0f, 308.0f, 380.0f, 436.0f, 83.0f, 144.0f, 201.0f, 293.0f, 354.0f, 433.0f, 60.0f, 135.0f, 202.0f, 285.0f, 355.0f, 456.0f, 59.0f, 136.0f, 204.0f, 284.0f, 362.0f, 456.0f, 75.0f, 138.0f, 207.0f, 285.0f, 363.0f, 438.0f, 90.0f, 153.0f, 217.0f, 292.0f, 358.0f, 441.0f, 61.0f, 145.0f, 216.0f, 292.0f, 366.0f, 452.0f, 55.0f, 143.0f, 213.0f, 295.0f, 373.0f, 463.0f, 80.0f, 148.0f, 217.0f, 295.0f, 375.0f, 444.0f}, {67.0f, 87.0f, 103.0f, 104.0f, 72.0f, 42.0f, 122.0f, 148.0f, 160.0f, 165.0f, 156.0f, 109.0f, 212.0f, 211.0f, 203.0f, 200.0f, 204.0f, 211.0f, 282.0f, 263.0f, 248.0f, 243.0f, 256.0f, 287.0f, 166.0f, 187.0f, 201.0f, 207.0f, 185.0f, 155.0f, 230.0f, 235.0f, 240.0f, 241.0f, 235.0f, 210.0f, 283.0f, 275.0f, 270.0f, 267.0f, 273.0f, 280.0f, 338.0f, 310.0f, 299.0f, 297.0f, 305.0f, 331.0f, 247.0f, 270.0f, 277.0f, 276.0f, 265.0f, 233.0f, 295.0f, 319.0f, 325.0f, 322.0f, 306.0f, 281.0f, 368.0f, 371.0f, 368.0f, 362.0f, 372.0f, 376.0f, 464.0f, 431.0f, 417.0f, 418.0f, 424.0f, 455.0f}};
    static final int m_lenx = 6;
    static final int m_leny = 4;
    static final int m_numgrids = 3;
    static final Color[] m_col = new Color[]{Color.black, Color.gray, Color.blue};
    static DelaunayOverlap delO = null;
    private boolean sig;

    public static void main(String[] stringArray) throws VisADException {
        Frame frame = new Frame("DelaunayOverlap");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        frame.addWindowListener(windowAdapter);
        ((Component)frame).setSize(500, 600);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation(dimension.width / 2 - 250, dimension.height / 2 - 300);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(1, 1));
        frame.add(panel);
        Canvas canvas = new Canvas(){

            public void paint(Graphics graphics) {
                int n;
                int n2;
                int n3;
                int n4;
                if (delO != null) {
                    graphics.setColor(Color.red);
                    n4 = 0;
                    while (n4 < DelaunayOverlap.delO.Tri.length) {
                        n3 = 0;
                        while (n3 < 3) {
                            n2 = (int)m_samples[0][DelaunayOverlap.delO.Tri[n4][n3]];
                            n = (int)m_samples[1][DelaunayOverlap.delO.Tri[n4][n3]];
                            int n5 = (int)m_samples[0][DelaunayOverlap.delO.Tri[n4][(n3 + 1) % 3]];
                            int n6 = (int)m_samples[1][DelaunayOverlap.delO.Tri[n4][(n3 + 1) % 3]];
                            graphics.drawLine(n2, n, n5, n6);
                            ++n3;
                        }
                        ++n4;
                    }
                }
                n4 = 0;
                n3 = 0;
                while (n3 < 72) {
                    n2 = (int)m_samples[0][n3];
                    n = (int)m_samples[1][n3];
                    if (n3 % 24 == 0) {
                        graphics.setColor(m_col[n4++]);
                    }
                    graphics.fillRect(n2 - 2, n - 2, 4, 4);
                    ++n3;
                }
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        panel.add(canvas);
        System.out.println("Constructing triangulation...");
        long l = System.currentTimeMillis();
        delO = new DelaunayOverlap(m_samples, 6, 4);
        long l2 = System.currentTimeMillis();
        ((Component)frame).setVisible(true);
        System.out.println("Algorithm completed successfully.");
        float f = (float)(l2 - l) / 1000.0f;
        System.out.println("Triangulation took " + f + " seconds.");
        System.out.println("Testing triangulation...");
        boolean bl = delO.test(m_samples);
        if (!bl) {
            System.out.println("Errors in triangulation!");
        } else {
            System.out.println("Triangulation was constructed correctly.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DelaunayOverlap(float[][] fArray, int n, int n2) throws VisADException {
        int n3;
        int n4;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        if (fArray.length < 2) {
            throw new SetException("DelaunayOverlap: bad dimension");
        }
        if (n < 2 || n2 < 2) {
            throw new SetException("DelaunayOverlap: must have at least two points per dimension");
        }
        if (fArray[0].length < n * n2) {
            throw new SetException("DelaunayOverlap: not enough samples");
        }
        int n14 = n * n2;
        int n15 = (n - 1) * (n2 - 1);
        int n16 = fArray[0].length / n14;
        if (n16 < 2) {
            throw new SetException("DelaunayOverlap: not enough grids (try Gridded2DSet instead)");
        }
        this.sig = (fArray[0][1] - fArray[0][0]) * (fArray[1][n + 1] - fArray[1][1]) - (fArray[1][1] - fArray[1][0]) * (fArray[0][n + 1] - fArray[0][1]) > 0.0f;
        int n17 = 0;
        while (n17 < n16) {
            int n18 = 0;
            while (n18 < n2 - 1) {
                int n19 = 0;
                while (n19 < n - 1) {
                    int n20 = n17 * n14 + n18 * n + n19;
                    float f8 = fArray[0][n20];
                    float f9 = fArray[1][n20];
                    float f10 = fArray[0][n20 + 1];
                    float f11 = fArray[1][n20 + 1];
                    float f12 = fArray[0][n20 + n];
                    float f13 = fArray[1][n20 + n];
                    float f14 = fArray[1][n20 + n + 1];
                    float f15 = fArray[0][n20 + n + 1];
                    if ((f10 - f8) * (f14 - f11) - (f11 - f9) * (f15 - f10) > 0.0f != this.sig || (f15 - f10) * (f13 - f14) - (f14 - f11) * (f12 - f15) > 0.0f != this.sig || (f12 - f15) * (f9 - f13) - (f13 - f14) * (f8 - f12) > 0.0f != this.sig || (f8 - f12) * (f11 - f9) - (f9 - f13) * (f10 - f8) > 0.0f != this.sig) {
                        throw new SetException("DelaunayOverlap: samples from grid " + n17 + " do not form a valid grid " + "(" + n19 + "," + n18 + ")");
                    }
                    ++n19;
                }
                ++n18;
            }
            ++n17;
        }
        n17 = (n16 - 1) * (n - 1) * (n2 - 1);
        int[][] nArray = new int[n17][5];
        int[] nArray2 = new int[n17];
        int[] nArray3 = new int[n17];
        int n21 = 0;
        while (n21 < n16 - 1) {
            int n22 = 0;
            while (n22 < n2 - 1) {
                int n23 = 0;
                while (n23 < n - 1) {
                    int n24 = n15 * n21 + (n - 1) * n22 + n23;
                    nArray2[n24] = 4;
                    nArray3[n24] = 0;
                    ++n23;
                }
                ++n22;
            }
            ++n21;
        }
        int[][] nArray4 = new int[n16][n + 1];
        int n25 = 0;
        while (n25 < n16) {
            int n26 = 0;
            while (n26 < n + 1) {
                nArray4[n25][n26] = -1;
                ++n26;
            }
            ++n25;
        }
        int[] nArray5 = new int[n16 * n2];
        int n27 = 0;
        int[] nArray6 = new int[n16 * n2];
        int n28 = 0;
        int[] nArray7 = new int[n16 * n2];
        int[] nArray8 = new int[n16 * n2];
        int[] nArray9 = new int[n16 * n2];
        int[] nArray10 = new int[n16 * n2];
        boolean[] blArray = new boolean[n16 * n * n2];
        int n29 = 0;
        while (n29 < n16) {
            n13 = 0;
            while (n13 < n2) {
                int n30 = 0;
                while (n30 < n) {
                    blArray[n14 * n29 + n * n13 + n30] = false;
                    ++n30;
                }
                ++n13;
            }
            ++n29;
        }
        int[] nArray11 = new int[n - 1];
        n13 = 0;
        while (n13 < n - 1) {
            nArray11[n13] = -1;
            ++n13;
        }
        int[][] nArray12 = new int[n15][3];
        boolean[] blArray2 = new boolean[n15];
        int n31 = 0;
        int n32 = 0;
        int n33 = 0;
        int[] nArray13 = new int[n16];
        int[] nArray14 = new int[n16];
        int n34 = n / 2 - 1;
        int n35 = n2 / 2 - 1;
        int n36 = 1;
        while (n36 < n16) {
            n12 = 0;
            while (n12 < n16) {
                nArray13[n12] = n34;
                nArray14[n12] = n35;
                ++n12;
            }
            n11 = n36;
            int n37 = 0;
            while (n37 < n2) {
                n12 = n36;
                int n38 = 0;
                while (n38 < n) {
                    n10 = n14 * n36 + n * n37 + n38;
                    float f16 = fArray[0][n10];
                    float f17 = fArray[1][n10];
                    n9 = 0;
                    n8 = n33;
                    while (n8 < n36) {
                        n7 = nArray13[n8];
                        n6 = nArray14[n8];
                        while (n9 == 0) {
                            n5 = n14 * n8 + n * n6 + n7;
                            f7 = fArray[0][n5];
                            f6 = fArray[1][n5];
                            f5 = fArray[0][n5 + 1];
                            f4 = fArray[1][n5 + 1];
                            f3 = fArray[0][n5 + n];
                            float f18 = fArray[1][n5 + n];
                            f2 = fArray[0][n5 + n + 1];
                            f = fArray[1][n5 + n + 1];
                            n4 = n7;
                            n3 = n6;
                            switch (((f7 - f5) * (f17 - f4) - (f6 - f4) * (f16 - f5) < 0.0f == this.sig ? 0 : 1) + ((f5 - f2) * (f17 - f) - (f4 - f) * (f16 - f2) < 0.0f == this.sig ? 0 : 2) + ((f2 - f3) * (f17 - f18) - (f - f18) * (f16 - f3) < 0.0f == this.sig ? 0 : 4) + ((f3 - f7) * (f17 - f6) - (f18 - f6) * (f16 - f7) < 0.0f == this.sig ? 0 : 8)) {
                                case 0: {
                                    int n39 = n15 * n8 + (n - 1) * n6 + n7;
                                    n9 = 1;
                                    if (n12 > n8) {
                                        n12 = n8;
                                    }
                                    if (n11 > n8) {
                                        n11 = n8;
                                    }
                                    nArray13[n8] = n7;
                                    nArray14[n8] = n6;
                                    int n40 = n39;
                                    int n41 = nArray3[n40];
                                    nArray3[n40] = n41 + 1;
                                    nArray[n39][n41] = n10;
                                    if (nArray3[n39] > nArray2[n39]) {
                                        int[] nArray15 = new int[nArray2[n5] + nArray2[n5] + 1];
                                        System.arraycopy(nArray[n39], 0, nArray15, 0, nArray2[n39]);
                                        nArray[n39] = nArray15;
                                        int n42 = n39;
                                        nArray2[n42] = nArray2[n42] + nArray2[n39];
                                    }
                                    blArray[n10] = true;
                                    if (nArray4[n36][n38] < n37) {
                                        nArray4[n36][n38] = n37;
                                    }
                                    if (nArray4[n36][n38 + 1] >= n37) break;
                                    nArray4[n36][n38 + 1] = n37;
                                    break;
                                }
                                case 1: 
                                case 11: {
                                    --n6;
                                    break;
                                }
                                case 2: 
                                case 7: {
                                    ++n7;
                                    break;
                                }
                                case 3: {
                                    ++n7;
                                    --n6;
                                    break;
                                }
                                case 4: 
                                case 14: {
                                    ++n6;
                                    break;
                                }
                                case 6: {
                                    ++n7;
                                    ++n6;
                                    break;
                                }
                                case 8: 
                                case 13: {
                                    --n7;
                                    break;
                                }
                                case 9: {
                                    --n7;
                                    --n6;
                                    break;
                                }
                                case 12: {
                                    --n7;
                                    ++n6;
                                    break;
                                }
                                default: {
                                    throw new SetException("DelaunayOverlap: pathological grid");
                                }
                            }
                            if (n7 > n - 2) {
                                n7 = n - 2;
                            }
                            if (n7 < 0) {
                                n7 = 0;
                            }
                            if (n6 > n2 - 2) {
                                n6 = n2 - 2;
                            }
                            if (n6 < 0) {
                                n6 = 0;
                            }
                            if (n4 == n7 && n3 == n6 && n9 == 0) break;
                        }
                        if (n9 != 0) break;
                        ++n8;
                    }
                    ++n38;
                }
                n33 = n12;
                ++n37;
            }
            n33 = n11;
            ++n36;
        }
        n12 = n14 - n;
        n11 = 0;
        while (n11 < n16) {
            nArray13[n11] = n34;
            nArray14[n11] = n35;
            ++n11;
        }
        n36 = 0;
        while (n36 < n16 - 1) {
            n11 = 0;
            while (n11 < n) {
                n10 = n14 * n36 + n12 + n11;
                float f19 = fArray[0][n10];
                float f20 = fArray[1][n10];
                int n43 = n36 + 1;
                int n44 = nArray13[n43];
                n9 = nArray14[n43];
                n4 = 0;
                while (n4 == 0) {
                    n6 = n14 * n43 + n * n9 + n44;
                    float f21 = fArray[0][n6];
                    float f22 = fArray[1][n6];
                    float f23 = fArray[0][n6 + 1];
                    f7 = fArray[1][n6 + 1];
                    f6 = fArray[0][n6 + n];
                    f5 = fArray[1][n6 + n];
                    f4 = fArray[0][n6 + n + 1];
                    f3 = fArray[1][n6 + n + 1];
                    n8 = n44;
                    n7 = n9;
                    switch (((f21 - f23) * (f20 - f7) - (f22 - f7) * (f19 - f23) < 0.0f == this.sig ? 0 : 1) + ((f23 - f4) * (f20 - f3) - (f7 - f3) * (f19 - f4) < 0.0f == this.sig ? 0 : 2) + ((f4 - f6) * (f20 - f5) - (f3 - f5) * (f19 - f6) < 0.0f == this.sig ? 0 : 4) + ((f6 - f21) * (f20 - f22) - (f5 - f22) * (f19 - f21) < 0.0f == this.sig ? 0 : 8)) {
                        case 0: {
                            n4 = 1;
                            nArray13[n43] = n44;
                            nArray14[n43] = n9;
                            if (nArray4[n43][n44 + 1] >= n9) break;
                            nArray4[n43][n44 + 1] = n9;
                            break;
                        }
                        case 1: 
                        case 11: {
                            --n9;
                            break;
                        }
                        case 2: 
                        case 7: {
                            ++n44;
                            break;
                        }
                        case 3: {
                            ++n44;
                            --n9;
                            break;
                        }
                        case 4: 
                        case 14: {
                            ++n9;
                            break;
                        }
                        case 6: {
                            ++n44;
                            ++n9;
                            break;
                        }
                        case 8: 
                        case 13: {
                            --n44;
                            break;
                        }
                        case 9: {
                            --n44;
                            --n9;
                            break;
                        }
                        case 12: {
                            --n44;
                            ++n9;
                            break;
                        }
                        default: {
                            throw new SetException("DelaunayOverlap: pathological grid");
                        }
                    }
                    if (n44 > n - 2) {
                        n44 = n - 2;
                    }
                    if (n44 < 0) {
                        n44 = 0;
                    }
                    if (n9 > n2 - 2) {
                        n9 = n2 - 2;
                    }
                    if (n9 < 0) {
                        n9 = 0;
                    }
                    if (n8 == n44 && n7 == n9 && n4 == 0) break;
                }
                ++n11;
            }
            ++n36;
        }
        nArray5[0] = 0;
        n11 = 1;
        while (n11 < n2) {
            nArray5[n11] = nArray5[n11 - 1] + n;
            ++n11;
        }
        n27 += n2;
        nArray6[0] = n - 1;
        n11 = 1;
        while (n11 < n2) {
            nArray6[n11] = nArray6[n11 - 1] + n;
            ++n11;
        }
        n28 += n2;
        n36 = 0;
        while (n36 < n16) {
            n11 = 0;
            while (n11 < n2 - 1) {
                int n45 = 0;
                while (n45 < n - 1) {
                    int n46 = n36 == n16 - 1 ? 0 : nArray3[n15 * n36 + (n - 1) * n11 + n45];
                    n31 += 2 * n46 + 2;
                    ++n45;
                }
                ++n11;
            }
            ++n36;
        }
        int[][] nArray16 = new int[(n31 += 2 * n2 * n16) + 2][3];
        int[][] nArray17 = new int[n31 + 2][3];
        n11 = 0;
        while (n11 < n31 + 2) {
            nArray17[n11][0] = -1;
            nArray17[n11][1] = -1;
            nArray17[n11][2] = -1;
            ++n11;
        }
        n36 = 0;
        while (n36 < n16) {
            int n47;
            int n48;
            int n49;
            int n50;
            int n51;
            float f24;
            float f25;
            float f26;
            float f27;
            float f28;
            float f29;
            float f30;
            float f31;
            float f32;
            float f33;
            float f34;
            int[] nArray18 = nArray11;
            nArray11 = new int[n - 1];
            n11 = 0;
            while (n11 < n - 1) {
                nArray11[n11] = -1;
                ++n11;
            }
            n11 = 0;
            while (n11 < n - 1) {
                int n52 = nArray4[n36][n11 + 1] + 1;
                while (n52 < n2 - 1) {
                    int n53 = n14 * n36 + n * n52 + n11;
                    int n54 = (n - 1) * n52 + n11;
                    int n55 = n15 * n36 + n54;
                    int n56 = n53;
                    int n57 = n53 + 1;
                    n7 = n53 + n;
                    n6 = n53 + n + 1;
                    switch (n36 == n16 - 1 ? 0 : nArray3[n55]) {
                        case 0: {
                            float f35 = fArray[0][n56];
                            float f36 = fArray[1][n56];
                            float f37 = fArray[0][n57];
                            float f38 = fArray[1][n57];
                            float f39 = fArray[0][n7];
                            float f40 = fArray[1][n7];
                            float f41 = fArray[0][n6];
                            float f42 = fArray[1][n6];
                            f = f35 - f37;
                            float f43 = f36 - f38;
                            float f44 = f35 - f39;
                            float f45 = f36 - f40;
                            float f46 = f41 - f37;
                            f34 = f42 - f38;
                            f33 = f41 - f39;
                            f32 = f42 - f40;
                            f31 = f * f44 + f43 * f45;
                            f30 = f46 * f + f34 * f43;
                            f29 = f44 * f33 + f45 * f32;
                            f28 = f46 * f33 + f34 * f32;
                            boolean bl = f31 < 0.0f && f28 < 0.0f || f30 > 0.0f && f29 > 0.0f ? true : (f30 < 0.0f && f29 < 0.0f || f31 > 0.0f && f28 > 0.0f ? false : (f31 < 0.0f ? f31 : f28) < (f30 < 0.0f ? f30 : f29));
                            if (bl) {
                                nArray16[n32][0] = n57;
                                nArray16[n32][1] = n6;
                                nArray16[n32][2] = n56;
                                nArray17[n32][2] = nArray11[n11];
                                if (nArray11[n11] >= 0) {
                                    nArray17[nArray11[n11]][1] = n32;
                                }
                                nArray17[n32][1] = n32 + 1;
                                nArray16[++n32][0] = n56;
                                nArray16[n32][1] = n6;
                                nArray16[n32][2] = n7;
                                if (n11 > 0 && nArray4[n36][n11] < n52) {
                                    nArray17[n32][2] = nArray12[n54 - 1][2];
                                    nArray17[nArray12[n54 - 1][2]][0] = n32;
                                } else {
                                    nArray17[n32][2] = -1;
                                }
                                nArray17[n32][0] = n32 - 1;
                                nArray11[n11] = ++n32 - 1;
                                nArray12[n54][0] = n32 - 2;
                                nArray12[n54][1] = n32 - 1;
                                nArray12[n54][2] = n32 - 2;
                                blArray2[n54] = true;
                                break;
                            }
                            nArray16[n32][0] = n56;
                            nArray16[n32][1] = n57;
                            nArray16[n32][2] = n7;
                            nArray17[n32][0] = nArray11[n11];
                            if (nArray11[n11] >= 0) {
                                nArray17[nArray11[n11]][1] = n32;
                            }
                            if (n11 > 0 && nArray4[n36][n11] < n52) {
                                nArray17[n32][2] = nArray12[n54 - 1][2];
                                nArray17[nArray12[n54 - 1][2]][0] = n32;
                            } else {
                                nArray17[n32][2] = -1;
                            }
                            nArray17[n32][1] = n32 + 1;
                            nArray16[++n32][0] = n57;
                            nArray16[n32][1] = n6;
                            nArray16[n32][2] = n7;
                            nArray17[n32][2] = n32 - 1;
                            nArray11[n11] = ++n32 - 1;
                            nArray12[n54][0] = n32 - 2;
                            nArray12[n54][1] = n32 - 2;
                            nArray12[n54][2] = n32 - 1;
                            blArray2[n54] = false;
                            break;
                        }
                        case 1: {
                            int n58 = nArray[n55][0];
                            nArray16[n32][0] = n57;
                            nArray16[n32][1] = n58;
                            nArray16[n32][2] = n56;
                            nArray17[n32][2] = nArray11[n11];
                            if (nArray11[n11] >= 0) {
                                nArray17[nArray11[n11]][1] = n32;
                            }
                            nArray17[n32][0] = n32 + 1;
                            nArray17[n32][1] = n32 + 3;
                            nArray16[++n32][0] = n57;
                            nArray16[n32][1] = n6;
                            nArray16[n32][2] = n58;
                            nArray17[n32][1] = n32 + 1;
                            nArray17[n32][2] = n32 - 1;
                            nArray16[++n32][0] = n58;
                            nArray16[n32][1] = n6;
                            nArray16[n32][2] = n7;
                            nArray17[n32][0] = n32 - 1;
                            nArray17[n32][2] = n32 + 1;
                            nArray16[++n32][0] = n56;
                            nArray16[n32][1] = n58;
                            nArray16[n32][2] = n7;
                            if (n11 > 0 && nArray4[n36][n11] < n52) {
                                nArray17[n32][2] = nArray12[n54 - 1][2];
                                nArray17[nArray12[n54 - 1][2]][0] = n32;
                            } else {
                                nArray17[n32][2] = -1;
                            }
                            nArray17[n32][0] = n32 - 3;
                            nArray17[n32][1] = n32 - 1;
                            nArray11[n11] = ++n32 - 2;
                            nArray12[n54][0] = n32 - 4;
                            nArray12[n54][1] = n32 - 1;
                            nArray12[n54][2] = n32 - 3;
                            blArray2[n54] = true;
                            break;
                        }
                        default: {
                            float f47;
                            float f48;
                            float f49;
                            float f50;
                            int n58 = nArray[n55][0];
                            int n59 = nArray[n55][1];
                            f27 = fArray[0][n59] - fArray[0][n58];
                            f26 = fArray[1][n59] - fArray[1][n58];
                            float f35 = fArray[0][n56];
                            float f36 = fArray[1][n56];
                            float f37 = fArray[0][n57];
                            float f38 = fArray[1][n57];
                            float f39 = fArray[0][n7];
                            float f40 = fArray[1][n7];
                            float f41 = fArray[0][n6];
                            float f42 = fArray[1][n6];
                            f25 = f27 * (f35 - f41) + f26 * (f36 - f42);
                            if (f25 < 0.0f) {
                                f25 = -f25;
                            }
                            if ((f24 = f27 * (f37 - f39) + f26 * (f38 - f40)) < 0.0f) {
                                f24 = -f24;
                            }
                            if (f25 > f24) {
                                f50 = f35 - fArray[0][n58];
                                f49 = f36 - fArray[1][n58];
                                f48 = f35 - fArray[0][n59];
                                f47 = f36 - fArray[1][n59];
                                if (f50 * f50 + f49 * f49 < f48 * f48 + f47 * f47) {
                                    nArray16[n32][0] = n57;
                                    nArray16[n32][1] = n58;
                                    nArray16[n32][2] = n56;
                                    nArray17[n32][2] = nArray11[n11];
                                    if (nArray11[n11] >= 0) {
                                        nArray17[nArray11[n11]][1] = n32;
                                    }
                                    nArray17[n32][0] = n32 + 5;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray16[++n32][0] = n56;
                                    nArray16[n32][1] = n58;
                                    nArray16[n32][2] = n7;
                                    if (n11 > 0 && nArray4[n36][n11] < n52) {
                                        nArray17[n32][2] = nArray12[n54 - 1][2];
                                        nArray17[nArray12[n54 - 1][2]][0] = n32;
                                    } else {
                                        nArray17[n32][2] = -1;
                                    }
                                    nArray17[n32][0] = n32 - 1;
                                    nArray17[n32][1] = n32 + 3;
                                    nArray16[++n32][0] = n59;
                                    nArray16[n32][1] = n6;
                                    nArray16[n32][2] = n7;
                                    nArray17[n32][0] = n32 + 1;
                                    nArray17[n32][2] = n32 + 2;
                                    nArray16[++n32][0] = n57;
                                    nArray16[n32][1] = n6;
                                    nArray16[n32][2] = n59;
                                    nArray17[n32][1] = n32 - 1;
                                    nArray17[n32][2] = n32 + 2;
                                    nArray16[++n32][0] = n7;
                                    nArray16[n32][1] = n58;
                                    nArray16[n32][2] = n59;
                                    nArray17[n32][0] = n32 - 3;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray17[n32][2] = n32 - 2;
                                    nArray16[++n32][0] = n57;
                                    nArray16[n32][1] = n59;
                                    nArray16[n32][2] = n58;
                                    nArray17[n32][0] = n32 - 2;
                                    nArray17[n32][1] = n32 - 1;
                                    nArray17[n32][2] = n32 - 5;
                                    nArray11[n11] = ++n32 - 4;
                                    nArray12[n54][0] = n32 - 6;
                                    nArray12[n54][1] = n32 - 5;
                                    nArray12[n54][2] = n32 - 3;
                                    blArray2[n54] = true;
                                } else {
                                    nArray16[n32][0] = n57;
                                    nArray16[n32][1] = n59;
                                    nArray16[n32][2] = n56;
                                    nArray17[n32][2] = nArray11[n11];
                                    if (nArray11[n11] >= 0) {
                                        nArray17[nArray11[n11]][1] = n32;
                                    }
                                    nArray17[n32][0] = n32 + 5;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray16[++n32][0] = n56;
                                    nArray16[n32][1] = n59;
                                    nArray16[n32][2] = n7;
                                    if (n11 > 0 && nArray4[n36][n11] < n52) {
                                        nArray17[n32][2] = nArray12[n54 - 1][2];
                                        nArray17[nArray12[n54 - 1][2]][0] = n32;
                                    } else {
                                        nArray17[n32][2] = -1;
                                    }
                                    nArray17[n32][0] = n32 - 1;
                                    nArray17[n32][1] = n32 + 3;
                                    nArray16[++n32][0] = n58;
                                    nArray16[n32][1] = n6;
                                    nArray16[n32][2] = n7;
                                    nArray17[n32][0] = n32 + 1;
                                    nArray17[n32][2] = n32 + 2;
                                    nArray16[++n32][0] = n57;
                                    nArray16[n32][1] = n6;
                                    nArray16[n32][2] = n58;
                                    nArray17[n32][1] = n32 - 1;
                                    nArray17[n32][2] = n32 + 2;
                                    nArray16[++n32][0] = n7;
                                    nArray16[n32][1] = n59;
                                    nArray16[n32][2] = n58;
                                    nArray17[n32][0] = n32 - 3;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray17[n32][2] = n32 - 2;
                                    nArray16[++n32][0] = n57;
                                    nArray16[n32][1] = n58;
                                    nArray16[n32][2] = n59;
                                    nArray17[n32][0] = n32 - 2;
                                    nArray17[n32][1] = n32 - 1;
                                    nArray17[n32][2] = n32 - 5;
                                    nArray11[n11] = ++n32 - 4;
                                    nArray12[n54][0] = n32 - 6;
                                    nArray12[n54][1] = n32 - 5;
                                    nArray12[n54][2] = n32 - 3;
                                    blArray2[n54] = true;
                                }
                            } else {
                                f50 = f37 - fArray[0][n58];
                                f49 = f38 - fArray[1][n58];
                                f48 = f37 - fArray[0][n59];
                                f47 = f38 - fArray[1][n59];
                                if (f50 * f50 + f49 * f49 < f48 * f48 + f47 * f47) {
                                    nArray16[n32][0] = n57;
                                    nArray16[n32][1] = n58;
                                    nArray16[n32][2] = n56;
                                    nArray17[n32][2] = nArray11[n11];
                                    if (nArray11[n11] >= 0) {
                                        nArray17[nArray11[n11]][1] = n32;
                                    }
                                    nArray17[n32][0] = n32 + 3;
                                    nArray17[n32][1] = n32 + 4;
                                    nArray16[++n32][0] = n56;
                                    nArray16[n32][1] = n59;
                                    nArray16[n32][2] = n7;
                                    if (n11 > 0 && nArray4[n36][n11] < n52) {
                                        nArray17[n32][2] = nArray12[n54 - 1][2];
                                        nArray17[nArray12[n54 - 1][2]][0] = n32;
                                    } else {
                                        nArray17[n32][2] = -1;
                                    }
                                    nArray17[n32][0] = n32 + 3;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray16[++n32][0] = n59;
                                    nArray16[n32][1] = n6;
                                    nArray16[n32][2] = n7;
                                    nArray17[n32][0] = n32 + 3;
                                    nArray17[n32][2] = n32 - 1;
                                    nArray16[++n32][0] = n57;
                                    nArray16[n32][1] = n6;
                                    nArray16[n32][2] = n58;
                                    nArray17[n32][1] = n32 + 2;
                                    nArray17[n32][2] = n32 - 3;
                                    nArray16[++n32][0] = n56;
                                    nArray16[n32][1] = n58;
                                    nArray16[n32][2] = n59;
                                    nArray17[n32][0] = n32 - 4;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray17[n32][2] = n32 - 3;
                                    nArray16[++n32][0] = n6;
                                    nArray16[n32][1] = n59;
                                    nArray16[n32][2] = n58;
                                    nArray17[n32][0] = n32 - 3;
                                    nArray17[n32][1] = n32 - 1;
                                    nArray17[n32][2] = n32 - 2;
                                    nArray11[n11] = ++n32 - 4;
                                    nArray12[n54][0] = n32 - 6;
                                    nArray12[n54][1] = n32 - 5;
                                    nArray12[n54][2] = n32 - 3;
                                    blArray2[n54] = true;
                                } else {
                                    nArray16[n32][0] = n57;
                                    nArray16[n32][1] = n59;
                                    nArray16[n32][2] = n56;
                                    nArray17[n32][2] = nArray11[n11];
                                    if (nArray11[n11] >= 0) {
                                        nArray17[nArray11[n11]][1] = n32;
                                    }
                                    nArray17[n32][0] = n32 + 3;
                                    nArray17[n32][1] = n32 + 4;
                                    nArray16[++n32][0] = n56;
                                    nArray16[n32][1] = n58;
                                    nArray16[n32][2] = n7;
                                    if (n11 > 0 && nArray4[n36][n11] < n52) {
                                        nArray17[n32][2] = nArray12[n54 - 1][2];
                                        nArray17[nArray12[n54 - 1][2]][0] = n32;
                                    } else {
                                        nArray17[n32][2] = -1;
                                    }
                                    nArray17[n32][0] = n32 + 3;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray16[++n32][0] = n58;
                                    nArray16[n32][1] = n6;
                                    nArray16[n32][2] = n7;
                                    nArray17[n32][0] = n32 + 3;
                                    nArray17[n32][2] = n32 - 1;
                                    nArray16[++n32][0] = n57;
                                    nArray16[n32][1] = n6;
                                    nArray16[n32][2] = n59;
                                    nArray17[n32][1] = n32 + 2;
                                    nArray17[n32][2] = n32 - 3;
                                    nArray16[++n32][0] = n56;
                                    nArray16[n32][1] = n59;
                                    nArray16[n32][2] = n58;
                                    nArray17[n32][0] = n32 - 4;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray17[n32][2] = n32 - 3;
                                    nArray16[++n32][0] = n6;
                                    nArray16[n32][1] = n58;
                                    nArray16[n32][2] = n59;
                                    nArray17[n32][0] = n32 - 3;
                                    nArray17[n32][1] = n32 - 1;
                                    nArray17[n32][2] = n32 - 2;
                                    nArray11[n11] = ++n32 - 4;
                                    nArray12[n54][0] = n32 - 6;
                                    nArray12[n54][1] = n32 - 5;
                                    nArray12[n54][2] = n32 - 3;
                                    blArray2[n54] = true;
                                }
                            }
                            int n60 = n32 - 1;
                            int n61 = 2 * nArray3[n55] + 2;
                            int n62 = 2;
                            while (n62 < nArray3[n55]) {
                                int n63;
                                int n64;
                                int n65;
                                int n66 = nArray[n55][n62];
                                int n67 = n60;
                                n51 = -1;
                                n50 = -1;
                                n49 = -1;
                                n48 = -1;
                                n47 = -1;
                                int n68 = -1;
                                boolean bl = false;
                                int n69 = 0;
                                while (n69 < n61 && !bl) {
                                    boolean bl2;
                                    boolean bl3;
                                    boolean bl4;
                                    n51 = nArray16[n67][0];
                                    n50 = nArray16[n67][1];
                                    n49 = nArray16[n67][2];
                                    n48 = nArray17[n67][0];
                                    n47 = nArray17[n67][1];
                                    n68 = nArray17[n67][2];
                                    float f51 = fArray[0][n66];
                                    float f52 = fArray[1][n66];
                                    float f53 = fArray[0][n51];
                                    float f54 = fArray[1][n51];
                                    float f55 = fArray[0][n50];
                                    float f56 = fArray[1][n50];
                                    float f57 = fArray[0][n49];
                                    float f58 = fArray[1][n49];
                                    float f59 = f53 - f55;
                                    float f60 = f54 - f56;
                                    float f61 = f53 - f57;
                                    float f62 = f54 - f58;
                                    float f63 = f55 - f57;
                                    float f64 = f56 - f58;
                                    float f65 = f59 * (f54 - f52) - f60 * (f53 - f51);
                                    float f66 = f63 * (f56 - f52) - f64 * (f55 - f51);
                                    float f67 = f61 * (f52 - f58) - f62 * (f51 - f57);
                                    boolean bl5 = f65 != 0.0f && f65 > 0.0f != f59 * f62 - f60 * f61 > 0.0f ? false : (bl4 = true);
                                    boolean bl6 = f66 != 0.0f && f66 > 0.0f != f63 * f60 - f64 * f59 > 0.0f ? false : (bl3 = true);
                                    boolean bl7 = f67 != 0.0f && f67 > 0.0f != f61 * f64 - f62 * f63 > 0.0f ? false : (bl2 = true);
                                    if (!(bl4 || bl3 || bl2)) {
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    if (!bl4) {
                                        if (n67 == nArray12[n54][2]) throw new SetException("DelaunayOverlap: subtriangulation error");
                                        n67 = n48;
                                    } else if (!bl3) {
                                        if (n67 == nArray11[n11]) throw new SetException("DelaunayOverlap: subtriangulation error");
                                        n67 = n47;
                                    } else if (!bl2) {
                                        if (n67 == nArray12[n54][0] || n67 == nArray12[n54][1]) throw new SetException("DelaunayOverlap: subtriangulation error");
                                        n67 = n68;
                                    } else {
                                        bl = true;
                                    }
                                    ++n69;
                                }
                                if (!bl) {
                                    throw new SetException("DelaunayOverlap: subtriangulation error");
                                }
                                if (n67 == nArray11[n11]) {
                                    n65 = -1;
                                    n64 = -1;
                                    n63 = 0;
                                    while (n63 < 3) {
                                        if (nArray17[n48][n63] == n67) {
                                            n65 = n63;
                                        }
                                        if (nArray17[n68][n63] == n67) {
                                            n64 = n63;
                                        }
                                        ++n63;
                                    }
                                    if (n65 < 0 || n64 < 0) {
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    nArray16[n67][0] = n66;
                                    nArray17[n67][0] = n32;
                                    nArray17[n67][2] = n32 + 1;
                                    nArray16[n32][0] = n50;
                                    nArray16[n32][1] = n66;
                                    nArray16[n32][2] = n51;
                                    nArray17[n32][0] = n67;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray17[n32][2] = n48;
                                    nArray17[n48][n65] = n32++;
                                    nArray16[n32][0] = n51;
                                    nArray16[n32][1] = n66;
                                    nArray16[n32][2] = n49;
                                    nArray17[n32][0] = n32 - 1;
                                    nArray17[n32][1] = n67;
                                    nArray17[n32][2] = n68;
                                    nArray17[n68][n64] = n32++;
                                } else if (n67 == nArray12[n54][0] || n67 == nArray12[n54][1]) {
                                    n65 = -1;
                                    n64 = -1;
                                    n63 = 0;
                                    while (n63 < 3) {
                                        if (nArray17[n48][n63] == n67) {
                                            n65 = n63;
                                        }
                                        if (nArray17[n47][n63] == n67) {
                                            n64 = n63;
                                        }
                                        ++n63;
                                    }
                                    if (n65 < 0 || n64 < 0) {
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    nArray16[n67][1] = n66;
                                    nArray17[n67][0] = n32;
                                    nArray17[n67][1] = n32 + 1;
                                    nArray16[n32][0] = n51;
                                    nArray16[n32][1] = n50;
                                    nArray16[n32][2] = n66;
                                    nArray17[n32][0] = n48;
                                    nArray17[n48][n65] = n32;
                                    nArray17[n32][1] = n32 + 1;
                                    nArray17[n32][2] = n67;
                                    nArray16[++n32][0] = n66;
                                    nArray16[n32][1] = n50;
                                    nArray16[n32][2] = n49;
                                    nArray17[n32][0] = n32 - 1;
                                    nArray17[n32][1] = n47;
                                    nArray17[n47][n64] = n32;
                                    nArray17[n32][2] = n67;
                                    ++n32;
                                } else {
                                    n65 = -1;
                                    n64 = -1;
                                    n63 = 0;
                                    while (n63 < 3) {
                                        if (nArray17[n47][n63] == n67) {
                                            n65 = n63;
                                        }
                                        if (nArray17[n68][n63] == n67) {
                                            n64 = n63;
                                        }
                                        ++n63;
                                    }
                                    if (n65 < 0 || n64 < 0) {
                                        throw new SetException("DelaunayOverlap: subtriangulation error");
                                    }
                                    nArray16[n67][2] = n66;
                                    nArray17[n67][1] = n32;
                                    nArray17[n67][2] = n32 + 1;
                                    nArray16[n32][0] = n66;
                                    nArray16[n32][1] = n50;
                                    nArray16[n32][2] = n49;
                                    nArray17[n32][0] = n67;
                                    nArray17[n32][1] = n47;
                                    nArray17[n47][n65] = n32;
                                    nArray17[n32][2] = n32 + 1;
                                    nArray16[++n32][0] = n51;
                                    nArray16[n32][1] = n66;
                                    nArray16[n32][2] = n49;
                                    nArray17[n32][0] = n67;
                                    nArray17[n32][1] = n32 - 1;
                                    nArray17[n32][2] = n68;
                                    nArray17[n68][n64] = n32++;
                                }
                                ++n62;
                            }
                            break block22;
                        }
                    }
                    ++n52;
                }
                ++n11;
            }
            if (n36 == 0) {
                n11 = 0;
                while (n11 < n27 - 1) {
                    nArray7[n11] = nArray12[n11 * (n - 1)][1];
                    nArray8[n11] = 2;
                    ++n11;
                }
                n11 = 0;
                while (n11 < n28 - 1) {
                    nArray9[n11] = nArray12[(n11 + 1) * (n - 1) - 1][2];
                    nArray10[n11] = 0;
                    ++n11;
                }
            } else {
                int n70;
                int n71;
                int n72;
                int n73;
                int n74;
                int n75;
                int n76 = n36 * n14 + n * (nArray4[n36][0] + 1);
                float f68 = fArray[0][n76];
                float f69 = fArray[1][n76];
                if ((!(fArray[1][nArray5[n27 - 1]] < f69) ? 0 : 1) != (n7 = !(fArray[1][nArray5[0]] < fArray[1][nArray5[n27 - 1]]) ? 0 : 1) && fArray[1][nArray5[n27 - 1]] != f69) {
                    int n77;
                    n6 = 0;
                    int n78 = n27 - 1;
                    int n79 = (n6 + n78) / 2;
                    int n80 = 0;
                    while (fArray[1][nArray5[n79 + 1]] < f69 == fArray[1][nArray5[n79]] < f69 && n80 < n27) {
                        if ((!(fArray[1][nArray5[n79]] < f69) ? 0 : 1) == n7) {
                            n6 = n79;
                        } else {
                            if (n79 == 0) {
                                throw new SetException("DelaunayOverlap: illegal grid overlap");
                            }
                            n78 = n79;
                        }
                        n79 = (n6 + n78) / 2;
                        if (n79 == n27 - 1) {
                            throw new SetException("DelaunayOverlap: pathological grid overlap");
                        }
                        ++n80;
                    }
                    if (n80 >= n27) {
                        throw new SetException("DelaunayOverlap: corrupt left edge structure");
                    }
                    int n81 = nArray5[n79];
                    float f70 = fArray[0][n81];
                    int n82 = nArray5[n79 + 1];
                    float f71 = fArray[1][n82];
                    float f72 = fArray[1][n81];
                    float f73 = fArray[0][n82];
                    if ((f68 - f70) * (f69 - f71) - (f69 - f72) * (f68 - f73) > 0.0f == ((f2 = fArray[0][n77 = n36 * n14 - n + 1]) - f70) * ((f = fArray[1][n77]) - f71) - (f - f72) * (f2 - f73) > 0.0f) {
                        n75 = n27 - 1;
                        n6 = 0;
                        n78 = n2 - 1;
                        n79 = (n6 + n78) / 2;
                        n80 = 0;
                        float f74 = fArray[1][nArray5[n27 - 1]];
                        int n83 = n36 * n14;
                        int n84 = n83 + n;
                        while (fArray[1][n * n79 + n83] < f74 == fArray[1][n * n79 + n84] < f74 && n80 < n2) {
                            if (f74 > fArray[1][n * n79 + n83]) {
                                n6 = n79;
                            } else {
                                if (n79 == 0) {
                                    throw new SetException("DelaunayOverlap: illegal grid overlap");
                                }
                                n78 = n79;
                            }
                            n79 = (n6 + n78) / 2;
                            if (n79 == n2 - 1) {
                                throw new SetException("DelaunayOverlap: pathological grid overlap");
                            }
                            ++n80;
                        }
                        if (n80 >= n2) {
                            throw new SetException("DelaunayOverlap:  corrupt grid structure");
                        }
                        n11 = n * n79 + n84;
                    } else {
                        n11 = n76;
                        n75 = n79;
                    }
                } else {
                    n11 = n76;
                    n75 = n27 - 1;
                }
                n76 = n36 * n14 + n * (nArray4[n36][n] + 2) - 1;
                f68 = fArray[0][n76];
                f69 = fArray[1][n76];
                n7 = !(fArray[1][nArray6[0]] < fArray[1][nArray6[n28 - 1]]) ? 0 : 1;
                if ((!(fArray[1][nArray6[n28 - 1]] < f69) ? 0 : 1) != n7 && fArray[1][nArray6[n28 - 1]] != f69) {
                    int n85;
                    n6 = 0;
                    int n86 = n28 - 1;
                    int n87 = (n6 + n86) / 2;
                    int n88 = 0;
                    while (fArray[1][nArray6[n87 + 1]] < f69 == fArray[1][nArray6[n87]] < f69 && n88 < n28) {
                        if ((!(fArray[1][nArray6[n87]] < f69) ? 0 : 1) == n7) {
                            n6 = n87;
                        } else {
                            if (n87 == 0) {
                                throw new SetException("DelaunayOverlap: illegal grid overlap");
                            }
                            n86 = n87;
                        }
                        n87 = (n6 + n86) / 2;
                        if (n87 == n28 - 1) {
                            throw new SetException("DelaunayOverlap: pathological grid overlap");
                        }
                        ++n88;
                    }
                    if (n88 >= n28) {
                        throw new SetException("DelaunayOverlap: corrupt right edge structure");
                    }
                    int n89 = nArray6[n87];
                    float f75 = fArray[0][n89];
                    int n90 = nArray6[n87 + 1];
                    float f76 = fArray[1][n90];
                    float f77 = fArray[1][n89];
                    float f78 = fArray[0][n90];
                    if ((f68 - f75) * (f69 - f76) - (f69 - f77) * (f68 - f78) > 0.0f == ((f2 = fArray[0][n85 = n36 * n14 - 2]) - f75) * ((f = fArray[1][n85]) - f76) - (f - f77) * (f2 - f78) > 0.0f) {
                        n74 = n28 - 1;
                        n6 = 0;
                        n86 = n2 - 1;
                        n87 = (n6 + n86) / 2;
                        n88 = 0;
                        float f79 = fArray[1][nArray6[n28 - 1]];
                        int n91 = n36 * n14 + n - 1;
                        int n92 = n91 + n;
                        while (fArray[1][n * n87 + n91] < f79 == fArray[1][n * n87 + n92] < f79 && n88 < n2) {
                            if (f79 > fArray[1][n * n87 + n91]) {
                                n6 = n87;
                            } else {
                                if (n87 == 0) {
                                    throw new SetException("DelaunayOverlap: illegal grid overlap");
                                }
                                n86 = n87;
                            }
                            n87 = (n6 + n86) / 2;
                            if (n87 == n2 - 1) {
                                throw new SetException("DelaunayOverlap: pathological grid overlap");
                            }
                            ++n88;
                        }
                        if (n88 >= n2) {
                            throw new SetException("DelaunayOverlap:  corrupt grid structure");
                        }
                        n73 = n * n87 + n92;
                    } else {
                        n73 = n76;
                        n74 = n87;
                    }
                } else {
                    n73 = n76;
                    n74 = n28 - 1;
                }
                int[] nArray19 = nArray5;
                int[] nArray20 = nArray6;
                int n93 = n27;
                int n94 = n28;
                int[] nArray21 = nArray7;
                int[] nArray22 = nArray8;
                int[] nArray23 = nArray9;
                int[] nArray24 = nArray10;
                nArray5 = new int[n16 * n2];
                nArray7 = new int[n16 * n2];
                nArray8 = new int[n16 * n2];
                n27 = 0;
                nArray6 = new int[n16 * n2];
                nArray9 = new int[n16 * n2];
                nArray10 = new int[n16 * n2];
                n28 = 0;
                System.arraycopy(nArray19, 0, nArray5, 0, n75 + 1);
                System.arraycopy(nArray21, 0, nArray7, 0, n75);
                System.arraycopy(nArray22, 0, nArray8, 0, n75);
                n27 += n75 + 1;
                System.arraycopy(nArray20, 0, nArray6, 0, n74 + 1);
                System.arraycopy(nArray23, 0, nArray9, 0, n74);
                System.arraycopy(nArray24, 0, nArray10, 0, n74);
                n28 += n74 + 1;
                n6 = n11;
                while (n6 <= (n36 + 1) * n14 - n) {
                    nArray5[n27++] = n6;
                    n6 += n;
                }
                n6 = n73;
                while (n6 < (n36 + 1) * n14) {
                    nArray6[n28++] = n6;
                    n6 += n;
                }
                n6 = n75;
                int n95 = n28 - n2 + nArray4[n36][n - 1];
                int n96 = 0;
                int n97 = n11;
                int n98 = n75;
                if (n98 == n93 - 1) {
                    n98 = n36 * n14 - n;
                    n96 = 1;
                }
                int n99 = 0;
                int n100 = n97 % n14 / n;
                boolean bl = false;
                if (n100 > 0 && nArray4[n36][0] < n100 - 1) {
                    n72 = 0;
                    n71 = n100 - 1;
                } else if (n100 == n2 - 1 || nArray4[n36][1] < n100) {
                    n72 = 1;
                    n71 = n100;
                } else {
                    n72 = 0;
                    n71 = n100 + 1;
                    bl = true;
                }
                int n101 = n36 * n14 + n71 * n + n72;
                int n102 = n98 + 1;
                boolean bl8 = false;
                boolean bl9 = true;
                while (n97 != n73 || n98 != n74 || n96 != 2) {
                    if (n97 == n73) {
                        bl8 = true;
                    } else if (n98 == n74 && n96 == 2) {
                        bl8 = false;
                    } else {
                        float f80 = fArray[0][n97];
                        float f81 = fArray[1][n97];
                        float f82 = fArray[0][n101];
                        f34 = fArray[1][n101];
                        if (n96 == 0) {
                            f33 = fArray[0][nArray19[n98]];
                            f32 = fArray[1][nArray19[n98]];
                            f31 = fArray[0][nArray19[n102]];
                            f30 = fArray[1][nArray19[n102]];
                        } else if (n96 == 1) {
                            f33 = fArray[0][n98];
                            f32 = fArray[1][n98];
                            f31 = fArray[0][n102];
                            f30 = fArray[1][n102];
                        } else {
                            f33 = fArray[0][nArray20[n98]];
                            f32 = fArray[1][nArray20[n98]];
                            f31 = fArray[0][nArray20[n102]];
                            f30 = fArray[1][nArray20[n102]];
                        }
                        f29 = f80 - f33;
                        f28 = f81 - f32;
                        float f83 = f80 - f82;
                        f27 = f81 - f34;
                        f26 = f31 - f33;
                        f25 = f30 - f32;
                        f24 = f31 - f82;
                        float f84 = f30 - f34;
                        float f85 = f29 * f83 + f28 * f27;
                        float f86 = f26 * f29 + f25 * f28;
                        float f87 = f83 * f24 + f27 * f84;
                        float f88 = f26 * f24 + f25 * f84;
                        n51 = !(f29 * f27 - f28 * f83 > 0.0f) ? 0 : 1;
                        n50 = !(f26 * f28 - f25 * f29 > 0.0f) ? 0 : 1;
                        n49 = !(f83 * f84 - f27 * f24 > 0.0f) ? 0 : 1;
                        n48 = !(f24 * f25 - f84 * f26 > 0.0f) ? 0 : 1;
                        int n103 = n47 = (n51 != 0 ? 1 : 0) + (n50 != 0 ? 1 : 0) + (n49 != 0 ? 1 : 0) + (n48 != 0 ? 1 : 0) >= 2 ? 0 : 1;
                        bl8 = n51 == n47 ? true : (n50 == n47 || n49 == n47 ? false : (n48 == n47 ? true : (f85 < 0.0f && f88 < 0.0f || f86 > 0.0f && f87 > 0.0f ? true : (f86 < 0.0f && f87 < 0.0f || f85 > 0.0f && f88 > 0.0f ? false : (f85 < 0.0f ? f85 : f88) < (f86 < 0.0f ? f86 : f87)))));
                    }
                    if (bl8) {
                        int n104;
                        if (n96 == 0) {
                            nArray16[n32][0] = nArray19[n102];
                            nArray16[n32][1] = n97;
                            nArray16[n32][2] = nArray19[n98];
                        } else if (n96 == 1) {
                            nArray16[n32][0] = n102;
                            nArray16[n32][1] = n97;
                            nArray16[n32][2] = n98;
                        } else {
                            nArray16[n32][0] = nArray20[n102];
                            nArray16[n32][1] = n97;
                            nArray16[n32][2] = nArray20[n98];
                        }
                        nArray17[n32][0] = -1;
                        if (bl9) {
                            nArray7[n6] = n32;
                            nArray8[n6] = 2;
                            ++n6;
                            bl9 = false;
                        } else {
                            nArray17[n32][1] = n32 - 1;
                            nArray17[n32 - 1][0] = n32;
                        }
                        if (n96 == 0) {
                            nArray17[n32][2] = n104 = nArray21[n98];
                            nArray17[n104][nArray22[n98]] = n32;
                        } else if (n96 == 1) {
                            nArray17[n32][2] = n104 = nArray18[n98 % n];
                            nArray17[n104][1] = n32;
                        } else {
                            nArray17[n32][2] = n104 = nArray23[n102];
                            nArray17[n104][nArray24[n102]] = n32;
                        }
                        n98 = n102;
                        if (n96 == 0 && n98 == n93 - 1) {
                            n96 = 1;
                            n98 = n36 * n14 - n;
                        }
                        if (n96 == 1 && n98 == n36 * n14 - 1) {
                            n96 = 2;
                            n98 = n94 - 1;
                        }
                        n102 = n98 + (n96 == 2 ? -1 : 1);
                    } else {
                        if (n96 == 0) {
                            nArray16[n32][0] = nArray19[n98];
                            nArray16[n32][1] = n101;
                            nArray16[n32][2] = n97;
                        } else if (n96 == 1) {
                            nArray16[n32][0] = n98;
                            nArray16[n32][1] = n101;
                            nArray16[n32][2] = n97;
                        } else {
                            nArray16[n32][0] = nArray20[n98];
                            nArray16[n32][1] = n101;
                            nArray16[n32][2] = n97;
                        }
                        nArray17[n32][0] = -1;
                        if (bl9) {
                            nArray7[n6] = n32;
                            nArray8[n6] = 1;
                            ++n6;
                            bl9 = false;
                        } else {
                            nArray17[n32][2] = n32 - 1;
                            nArray17[n32 - 1][0] = n32;
                        }
                        if (n101 - n97 == -n) {
                            if (n99 < n - 1) {
                                int n105;
                                nArray17[n32][1] = n105 = nArray12[(n - 1) * n71 + n72][1];
                                nArray17[n105][2] = n32;
                            } else {
                                nArray17[n32][1] = -1;
                                nArray9[n95] = n32;
                                nArray10[n95] = 1;
                                --n95;
                            }
                        } else if (n101 - n97 == 1) {
                            if (n100 < n2 - 1) {
                                int n106;
                                int n107 = (n - 1) * n100 + n99;
                                nArray17[n32][1] = n106 = nArray12[n107][0];
                                nArray17[n106][blArray2[n107] ? 2 : 0] = n32;
                            } else {
                                nArray17[n32][1] = -1;
                                nArray11[n99] = n32;
                            }
                        } else if (n99 > 0) {
                            int n108;
                            nArray17[n32][1] = n108 = nArray12[(n - 1) * n100 + n99 - 1][2];
                            nArray17[n108][0] = n32;
                        } else {
                            nArray17[n32][1] = -1;
                            nArray7[n6] = n32;
                            nArray8[n6] = 1;
                            ++n6;
                        }
                        n97 = n101;
                        n99 = n72;
                        n100 = n71;
                        if (nArray4[n36][n99 == 0 ? 0 : n99 + 1] < n100 - 1 && n100 > 0 && !bl) {
                            n72 = n99;
                            n71 = n100 - 1;
                        } else if (n100 == n2 - 1 || n99 < n - 1 && nArray4[n36][n99 + 1] < n100) {
                            n72 = n99 + 1;
                            n71 = n100;
                            bl = false;
                        } else {
                            n72 = n99;
                            n71 = n100 + 1;
                            bl = true;
                        }
                        n101 = n36 * n14 + n71 * n + n72;
                    }
                    if (++n32 <= n31) continue;
                    n31 += n31;
                    int[][] nArray25 = new int[n31 + 2][3];
                    int[][] nArray26 = new int[n31 + 2][3];
                    int n109 = 0;
                    while (n109 < n32) {
                        nArray25[n109][0] = nArray16[n109][0];
                        nArray25[n109][1] = nArray16[n109][1];
                        nArray25[n109][2] = nArray16[n109][2];
                        nArray26[n109][0] = nArray17[n109][0];
                        nArray26[n109][1] = nArray17[n109][1];
                        nArray26[n109][2] = nArray17[n109][2];
                        ++n109;
                    }
                    n109 = n32;
                    while (n109 < n31 + 2) {
                        nArray26[n109][0] = -1;
                        nArray26[n109][1] = -1;
                        nArray26[n109][2] = -1;
                        ++n109;
                    }
                    nArray16 = nArray25;
                    nArray17 = nArray26;
                }
                nArray9[n95] = n32 - 1;
                nArray10[n95] = bl8 ? 2 : 1;
                n95 = n28 - n2 + nArray4[n36][n - 1] + 1;
                int n110 = n70 = nArray4[n36][1] + 1;
                while (n110 < n2 - 1) {
                    nArray7[n6] = nArray12[(n - 1) * n110][1];
                    nArray8[n6] = 2;
                    ++n6;
                    ++n110;
                }
                n110 = n70 = nArray4[n36][n - 1] + 1;
                while (n110 < n2 - 1) {
                    nArray9[n95] = nArray12[(n - 1) * (n110 + 1) - 1][2];
                    nArray10[n95] = 0;
                    ++n95;
                    ++n110;
                }
            }
            ++n36;
        }
        n36 = 0;
        while (n36 < n16) {
            if (n36 < n16 - 1) {
                n11 = n32 / 2;
                int n111 = 0;
                while (n111 < n - 1) {
                    int n112 = 0;
                    while (n112 <= nArray4[n36][n111 + 1]) {
                        int n113 = n15 * n36 + (n - 1) * n112 + n111;
                        if (n11 < 0) {
                            n11 = n32 / 2;
                        }
                        int n114 = 0;
                        while (n114 < nArray3[n113]) {
                            int n115;
                            int n116;
                            float f89 = fArray[0][nArray[n113][n114]];
                            float f90 = fArray[1][nArray[n113][n114]];
                            n7 = 0;
                            n6 = 0;
                            while (n6 < n32 && n7 == 0) {
                                int n117;
                                int n118;
                                boolean bl;
                                boolean bl10;
                                n116 = nArray16[n11][0];
                                n3 = nArray16[n11][1];
                                n5 = nArray16[n11][2];
                                float f91 = fArray[0][n116];
                                float f92 = fArray[1][n116];
                                float f93 = fArray[0][n3];
                                float f94 = fArray[1][n3];
                                float f95 = fArray[0][n5];
                                float f96 = fArray[1][n5];
                                float f97 = (f93 - f91) * (f90 - f92) - (f94 - f92) * (f89 - f91);
                                float f98 = (f95 - f93) * (f90 - f94) - (f96 - f94) * (f89 - f93);
                                float f99 = (f91 - f95) * (f90 - f96) - (f92 - f96) * (f89 - f95);
                                int n119 = f97 != 0.0f && f97 > 0.0f != (f93 - f91) * (f96 - f92) - (f94 - f92) * (f95 - f91) > 0.0f ? 0 : (n115 = 1);
                                boolean bl11 = f98 != 0.0f && f98 > 0.0f != (f95 - f93) * (f92 - f94) - (f96 - f94) * (f91 - f93) > 0.0f ? false : (bl10 = true);
                                boolean bl12 = f99 != 0.0f && f99 > 0.0f != (f91 - f95) * (f94 - f96) - (f92 - f96) * (f93 - f95) > 0.0f ? false : (bl = true);
                                if (n115 == 0 && !bl10 && !bl) {
                                    throw new SetException("DelaunayOverlap: corrupt triangle structure");
                                }
                                if (n115 == 0 && !bl10) {
                                    n118 = nArray17[n11][0];
                                    n117 = nArray17[n11][1];
                                    n11 = n118 == -1 ? n117 : n118;
                                } else if (n115 == 0 && !bl) {
                                    n118 = nArray17[n11][0];
                                    n117 = nArray17[n11][2];
                                    n11 = n118 == -1 ? n117 : n118;
                                } else if (!bl10 && !bl) {
                                    n118 = nArray17[n11][1];
                                    n117 = nArray17[n11][2];
                                    n11 = n118 == -1 ? n117 : n118;
                                } else if (n115 == 0) {
                                    n11 = nArray17[n11][0];
                                } else if (!bl10) {
                                    n11 = nArray17[n11][1];
                                } else if (!bl) {
                                    n11 = nArray17[n11][2];
                                } else {
                                    n7 = 1;
                                }
                                if (n11 < 0) {
                                    n6 = n32;
                                }
                                ++n6;
                            }
                            if (n6 < n32) {
                                int n120;
                                int n121;
                                int n122;
                                n116 = nArray[n113][n114];
                                n3 = nArray16[n11][0];
                                n5 = nArray16[n11][1];
                                int n123 = nArray16[n11][2];
                                int n124 = nArray17[n11][0];
                                int n125 = nArray17[n11][1];
                                int n126 = nArray17[n11][2];
                                if (n124 == -1) {
                                    n122 = -1;
                                } else if (nArray17[n124][0] == n11) {
                                    n122 = 0;
                                } else if (nArray17[n124][1] == n11) {
                                    n122 = 1;
                                } else {
                                    if (nArray17[n124][2] != n11) throw new SetException("DelaunayOverlap: corrupt walk structure");
                                    n122 = 2;
                                }
                                if (n125 == -1) {
                                    n121 = -1;
                                } else if (nArray17[n125][0] == n11) {
                                    n121 = 0;
                                } else if (nArray17[n125][1] == n11) {
                                    n121 = 1;
                                } else {
                                    if (nArray17[n125][2] != n11) throw new SetException("DelaunayOverlap: corrupt walk structure");
                                    n121 = 2;
                                }
                                if (n126 == -1) {
                                    n120 = -1;
                                } else if (nArray17[n126][0] == n11) {
                                    n120 = 0;
                                } else if (nArray17[n126][1] == n11) {
                                    n120 = 1;
                                } else {
                                    if (nArray17[n126][2] != n11) throw new SetException("DelaunayOverlap: corrupt walk structure");
                                    n120 = 2;
                                }
                                nArray16[n11][2] = n116;
                                nArray17[n11][1] = n32;
                                nArray17[n11][2] = n32 + 1;
                                nArray16[n32][0] = n116;
                                nArray16[n32][1] = n5;
                                nArray16[n32][2] = n123;
                                nArray17[n32][0] = n11;
                                nArray17[n32][1] = n125;
                                if (n121 >= 0) {
                                    nArray17[n125][n121] = n32;
                                }
                                nArray17[n32][2] = n32 + 1;
                                nArray16[++n32][0] = n3;
                                nArray16[n32][1] = n116;
                                nArray16[n32][2] = n123;
                                nArray17[n32][0] = n11;
                                nArray17[n32][1] = n32 - 1;
                                nArray17[n32][2] = n126;
                                if (n120 >= 0) {
                                    nArray17[n126][n120] = n32;
                                }
                                if (++n32 > n31) {
                                    n31 += n31;
                                    int[][] nArray27 = new int[n31 + 2][3];
                                    int[][] nArray28 = new int[n31 + 2][3];
                                    n115 = 0;
                                    while (n115 < n32) {
                                        nArray27[n115][0] = nArray16[n115][0];
                                        nArray27[n115][1] = nArray16[n115][1];
                                        nArray27[n115][2] = nArray16[n115][2];
                                        nArray28[n115][0] = nArray17[n115][0];
                                        nArray28[n115][1] = nArray17[n115][1];
                                        nArray28[n115][2] = nArray17[n115][2];
                                        ++n115;
                                    }
                                    n115 = n32;
                                    while (n115 < n31 + 2) {
                                        nArray28[n115][0] = -1;
                                        nArray28[n115][1] = -1;
                                        nArray28[n115][2] = -1;
                                        ++n115;
                                    }
                                    nArray16 = nArray27;
                                    nArray17 = nArray28;
                                }
                            }
                            ++n114;
                        }
                        ++n112;
                    }
                    ++n111;
                }
            }
            n11 = n32 / 2;
            int n127 = 0;
            while (n127 < n2 - 1) {
                int n128 = 1;
                while (n128 < n - 1) {
                    int n129 = n14 * n36 + n * n127 + n128;
                    if (!blArray[n129] && nArray4[n36][n128] >= n127 && nArray4[n36][n128 + 1] >= n127) {
                        int n130;
                        float f100 = fArray[0][n129];
                        float f101 = fArray[1][n129];
                        boolean bl = false;
                        n7 = 0;
                        while (n7 < n32 && !bl) {
                            int n131;
                            int n132;
                            boolean bl13;
                            boolean bl14;
                            boolean bl15;
                            n6 = nArray16[n11][0];
                            n130 = nArray16[n11][1];
                            n3 = nArray16[n11][2];
                            float f102 = fArray[0][n6];
                            float f103 = fArray[1][n6];
                            float f104 = fArray[0][n130];
                            float f105 = fArray[1][n130];
                            float f106 = fArray[0][n3];
                            float f107 = fArray[1][n3];
                            float f108 = (f104 - f102) * (f101 - f103) - (f105 - f103) * (f100 - f102);
                            float f109 = (f106 - f104) * (f101 - f105) - (f107 - f105) * (f100 - f104);
                            float f110 = (f102 - f106) * (f101 - f107) - (f103 - f107) * (f100 - f106);
                            boolean bl16 = f108 != 0.0f && f108 > 0.0f != (f104 - f102) * (f107 - f103) - (f105 - f103) * (f106 - f102) > 0.0f ? false : (bl15 = true);
                            boolean bl17 = f109 != 0.0f && f109 > 0.0f != (f106 - f104) * (f103 - f105) - (f107 - f105) * (f102 - f104) > 0.0f ? false : (bl14 = true);
                            boolean bl18 = f110 != 0.0f && f110 > 0.0f != (f102 - f106) * (f105 - f107) - (f103 - f107) * (f104 - f106) > 0.0f ? false : (bl13 = true);
                            if (!(bl15 || bl14 || bl13)) {
                                throw new SetException("DelaunayOverlap: corrupt triangle structure");
                            }
                            if (!bl15 && !bl14) {
                                n132 = nArray17[n11][0];
                                n131 = nArray17[n11][1];
                                n11 = n132 == -1 ? n131 : n132;
                            } else if (!bl15 && !bl13) {
                                n132 = nArray17[n11][0];
                                n131 = nArray17[n11][2];
                                n11 = n132 == -1 ? n131 : n132;
                            } else if (!bl14 && !bl13) {
                                n132 = nArray17[n11][1];
                                n131 = nArray17[n11][2];
                                n11 = n132 == -1 ? n131 : n132;
                            } else if (!bl15) {
                                n11 = nArray17[n11][0];
                            } else if (!bl14) {
                                n11 = nArray17[n11][1];
                            } else if (!bl13) {
                                n11 = nArray17[n11][2];
                            } else {
                                bl = true;
                            }
                            if (n11 < 0) {
                                n7 = n32;
                            }
                            ++n7;
                        }
                        if (n7 < n32) {
                            int n133;
                            int n134;
                            int n135;
                            n6 = nArray16[n11][0];
                            n130 = nArray16[n11][1];
                            n3 = nArray16[n11][2];
                            int n136 = nArray17[n11][0];
                            int n137 = nArray17[n11][1];
                            int n138 = nArray17[n11][2];
                            if (n136 == -1) {
                                n135 = -1;
                            } else if (nArray17[n136][0] == n11) {
                                n135 = 0;
                            } else if (nArray17[n136][1] == n11) {
                                n135 = 1;
                            } else {
                                if (nArray17[n136][2] != n11) throw new SetException("DelaunayOverlap: corrupt walk structure");
                                n135 = 2;
                            }
                            if (n137 == -1) {
                                n134 = -1;
                            } else if (nArray17[n137][0] == n11) {
                                n134 = 0;
                            } else if (nArray17[n137][1] == n11) {
                                n134 = 1;
                            } else {
                                if (nArray17[n137][2] != n11) throw new SetException("DelaunayOverlap: corrupt walk structure");
                                n134 = 2;
                            }
                            if (n138 == -1) {
                                n133 = -1;
                            } else if (nArray17[n138][0] == n11) {
                                n133 = 0;
                            } else if (nArray17[n138][1] == n11) {
                                n133 = 1;
                            } else {
                                if (nArray17[n138][2] != n11) throw new SetException("DelaunayOverlap: corrupt walk structure");
                                n133 = 2;
                            }
                            nArray16[n11][2] = n129;
                            nArray17[n11][1] = n32;
                            nArray17[n11][2] = n32 + 1;
                            nArray16[n32][0] = n129;
                            nArray16[n32][1] = n130;
                            nArray16[n32][2] = n3;
                            nArray17[n32][0] = n11;
                            nArray17[n32][1] = n137;
                            if (n134 >= 0) {
                                nArray17[n137][n134] = n32;
                            }
                            nArray17[n32][2] = n32 + 1;
                            nArray16[++n32][0] = n6;
                            nArray16[n32][1] = n129;
                            nArray16[n32][2] = n3;
                            nArray17[n32][0] = n11;
                            nArray17[n32][1] = n32 - 1;
                            nArray17[n32][2] = n138;
                            if (n133 >= 0) {
                                nArray17[n138][n133] = n32;
                            }
                            if (++n32 > n31) {
                                n31 += n31;
                                int[][] nArray29 = new int[n31 + 2][3];
                                int[][] nArray30 = new int[n31 + 2][3];
                                int n139 = 0;
                                while (n139 < n32) {
                                    nArray29[n139][0] = nArray16[n139][0];
                                    nArray29[n139][1] = nArray16[n139][1];
                                    nArray29[n139][2] = nArray16[n139][2];
                                    nArray30[n139][0] = nArray17[n139][0];
                                    nArray30[n139][1] = nArray17[n139][1];
                                    nArray30[n139][2] = nArray17[n139][2];
                                    ++n139;
                                }
                                n139 = n32;
                                while (n139 < n31 + 2) {
                                    nArray30[n139][0] = -1;
                                    nArray30[n139][1] = -1;
                                    nArray30[n139][2] = -1;
                                    ++n139;
                                }
                                nArray16 = nArray29;
                                nArray17 = nArray30;
                            }
                        }
                    }
                    ++n128;
                }
                ++n127;
            }
            ++n36;
        }
        this.Tri = new int[n32][3];
        this.Walk = new int[n32][3];
        n11 = 0;
        while (n11 < n32) {
            this.Tri[n11][0] = nArray16[n11][0];
            this.Tri[n11][1] = nArray16[n11][1];
            this.Tri[n11][2] = nArray16[n11][2];
            this.Walk[n11][0] = nArray17[n11][0];
            this.Walk[n11][1] = nArray17[n11][1];
            this.Walk[n11][2] = nArray17[n11][2];
            ++n11;
        }
        this.finish_triang(fArray);
    }
}

