/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.Delaunay;
import visad.DelaunayClarkson;
import visad.DelaunayWatson;
import visad.UnimplementedException;
import visad.VisADException;

public class DelaunayFast
extends Delaunay {
    public static final double ROTATE = 0.17453292519943295;

    private final void qsort(int[] nArray, float[][] fArray, int n, int n2, int n3) {
        if (n2 < n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = nArray[n2];
            nArray[n2] = nArray[n4];
            nArray[n4] = n5;
            n4 = n2;
            int n6 = n2 + 1;
            while (n6 <= n3) {
                if (fArray[n][nArray[n6]] < fArray[n][nArray[n2]]) {
                    n5 = nArray[n6];
                    nArray[n6] = nArray[++n4];
                    nArray[n4] = n5;
                }
                ++n6;
            }
            n5 = nArray[n2];
            nArray[n2] = nArray[n4];
            nArray[n4] = n5;
            if (n2 < n4 - 1) {
                this.qsort(nArray, fArray, n, n2, n4 - 1);
            }
            if (n4 + 1 < n3) {
                this.qsort(nArray, fArray, n, n4 + 1, n3);
            }
        }
    }

    public static void main(String[] stringArray) throws VisADException {
        boolean bl = false;
        int n = 0;
        if (stringArray.length < 1) {
            bl = true;
        } else {
            try {
                n = Integer.parseInt(stringArray[0]);
                if (n < 3) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        if (bl) {
            System.out.println("Usage:\n   java visad.DelaunayFast points\npoints = the number of points to triangulate.\n");
            System.exit(1);
        }
        System.out.println("Generating " + n + " random points...");
        float[][] fArray = new float[2][n];
        float[] fArray2 = fArray[0];
        float[] fArray3 = fArray[1];
        int n2 = 0;
        while (n2 < n) {
            fArray2[n2] = (float)(500.0 * Math.random());
            fArray3[n2] = (float)(500.0 * Math.random());
            ++n2;
        }
        System.out.println("\nTriangulating points with Clarkson algorithm...");
        long l = System.currentTimeMillis();
        DelaunayClarkson delaunayClarkson = new DelaunayClarkson(fArray);
        long l2 = System.currentTimeMillis();
        float f = (float)(l2 - l) / 1000.0f;
        System.out.println("Triangulation took " + f + " seconds.");
        System.out.println("\nTriangulating points with Watson algorithm...");
        long l3 = System.currentTimeMillis();
        DelaunayWatson delaunayWatson = new DelaunayWatson(fArray);
        long l4 = System.currentTimeMillis();
        float f2 = (float)(l4 - l3) / 1000.0f;
        System.out.println("Triangulation took " + f2 + " seconds.");
        System.out.println("\nTriangulating points with Fast algorithm...");
        long l5 = System.currentTimeMillis();
        DelaunayFast delaunayFast = new DelaunayFast(fArray);
        long l6 = System.currentTimeMillis();
        float f3 = (float)(l6 - l5) / 1000.0f;
        System.out.println("Triangulation took " + f3 + " seconds.");
        float f4 = f / f3;
        System.out.println("\nAt " + n + " points:");
        System.out.println("  Fast is " + f4 + " times faster than Clarkson.");
        float f5 = f2 / f3;
        System.out.println("  Fast is " + f5 + " times faster than Watson.");
    }

    public DelaunayFast(float[][] fArray) throws VisADException {
        int n;
        if (fArray.length < 2 || fArray.length > 3) {
            throw new VisADException("DelaunayFast: dimension must be 2 or 3");
        }
        if (fArray.length == 3) {
            throw new UnimplementedException("DelaunayFast: only two dimensions for now");
        }
        int n2 = Math.min(fArray[0].length, fArray[1].length);
        if (n2 < 3) {
            throw new VisADException("DelaunayFast: triangulation is futile with less than 3 samples");
        }
        float[][] fArray2 = new float[2][n2];
        System.arraycopy(fArray[0], 0, fArray2[0], 0, n2);
        System.arraycopy(fArray[1], 0, fArray2[1], 0, n2);
        float[] fArray3 = fArray2[0];
        float[] fArray4 = fArray2[1];
        double d = Math.cos(0.17453292519943295);
        double d2 = Math.sin(0.17453292519943295);
        int n3 = 0;
        while (n3 < n2) {
            double d3 = fArray3[n3];
            double d4 = fArray4[n3];
            fArray3[n3] = (float)(d3 * d - d4 * d2);
            fArray4[n3] = (float)(d4 * d + d3 * d2);
            ++n3;
        }
        n3 = 0;
        int n4 = (int)(0.6666667f * (float)n2) + 10;
        int[][][] nArray = new int[n4][3][];
        int n5 = 0;
        int[] nArray2 = new int[n2];
        int n6 = 0;
        while (n6 < n2) {
            nArray2[n6] = 0;
            ++n6;
        }
        n6 = 20;
        Object object = new int[n6 + 2];
        int[] nArray3 = new int[n6 + 2];
        boolean[] blArray = new boolean[n6 + 2];
        boolean[] blArray2 = new boolean[n6 + 2];
        int n7 = 0;
        int n8 = 10;
        int[][] nArray4 = new int[n8 + 2][];
        int n9 = 0;
        int[] nArray5 = new int[n2];
        int n10 = 0;
        while (n10 < n2) {
            nArray5[n10] = n10;
            ++n10;
        }
        ++n7;
        object[0] = 0;
        nArray3[0] = n2 - 1;
        blArray[0] = false;
        blArray2[0] = false;
        while (n7 != 0) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            Object[] objectArray;
            int[] nArray6;
            Object object2;
            if (n9 > n8) {
                n8 += n8;
                object2 = new int[n8 + 2][];
                System.arraycopy(nArray4, 0, object2, 0, nArray4.length);
                nArray4 = object2;
            }
            if (n7 > n6) {
                n6 += n6;
                object2 = new int[n6 + 2];
                nArray6 = new int[n6 + 2];
                objectArray = new boolean[n6 + 2];
                boolean[] blArray3 = new boolean[n6 + 2];
                System.arraycopy(object, 0, object2, 0, ((int[])object).length);
                System.arraycopy(nArray3, 0, nArray6, 0, nArray3.length);
                System.arraycopy(blArray, 0, objectArray, 0, blArray.length);
                System.arraycopy(blArray2, 0, blArray3, 0, blArray2.length);
                object = object2;
                nArray3 = nArray6;
                blArray = objectArray;
                blArray2 = blArray3;
            }
            n10 = object[--n7];
            int n17 = nArray3[n7];
            boolean bl = blArray[n7];
            boolean bl2 = blArray2[n7];
            if (!bl2) {
                if (n17 - n10 >= 3) {
                    this.qsort(nArray5, fArray2, bl ? 0 : 1, n10, n17);
                    object[n7] = n10;
                    nArray3[n7] = n17;
                    blArray[n7] = bl;
                    blArray2[n7] = true;
                    int n18 = (n10 + n17) / 2;
                    object[++n7] = n10;
                    nArray3[n7] = n18;
                    blArray[n7] = !bl;
                    blArray2[n7] = false;
                    object[++n7] = n18 + 1;
                    nArray3[n7] = n17;
                    blArray[n7] = !bl;
                    blArray2[n7] = false;
                    ++n7;
                    continue;
                }
                if (n17 - n10 + 1 == 3) {
                    object2 = new int[3];
                    object2[0] = (int[])nArray5[n10];
                    object2[1] = (int[])nArray5[n10 + 1];
                    object2[2] = (int[])nArray5[n17];
                    float f = fArray3[object2[0]];
                    float f2 = fArray4[object2[0]];
                    if ((fArray3[object2[1]] - f) * (fArray4[object2[2]] - f2) - (fArray4[object2[1]] - f2) * (fArray3[object2[2]] - f) > 0.0f) {
                        object2[1] = (int[])nArray5[n17];
                        object2[2] = (int[])nArray5[n10 + 1];
                    }
                    nArray[n5][0] = new int[1];
                    nArray[n5][1] = new int[1];
                    nArray[n5][2] = new int[1];
                    nArray[n5][0][0] = (int)object2[0];
                    nArray[n5][1][0] = (int)object2[1];
                    nArray[n5][2][0] = (int)object2[2];
                    ++n5;
                    ++n3;
                    int n19 = nArray5[n10];
                    nArray2[n19] = nArray2[n19] + 1;
                    int n20 = nArray5[n17];
                    nArray2[n20] = nArray2[n20] + 1;
                    int n21 = nArray5[n10 + 1];
                    nArray2[n21] = nArray2[n21] + 1;
                } else {
                    object2 = new int[2];
                    object2[0] = (int[])nArray5[n10];
                    object2[1] = (int[])nArray5[n17];
                }
                nArray4[n9++] = (int[])object2;
                continue;
            }
            int n22 = bl ? 1 : 0;
            objectArray = bl ? nArray4[n9 + 1] : nArray4[n9 -= 2];
            nArray6 = bl ? nArray4[n9] : nArray4[n9 + 1];
            nArray4[n9 + 1] = null;
            nArray4[n9] = null;
            int n23 = 0;
            n = 0;
            int n24 = 0;
            int n25 = 0;
            int n26 = 1;
            while (n26 < nArray6.length) {
                if (fArray2[n22][nArray6[n26]] > fArray2[n22][nArray6[n23]]) {
                    n23 = n26;
                }
                if (fArray2[n22][nArray6[n26]] < fArray2[n22][nArray6[n24]]) {
                    n24 = n26;
                }
                ++n26;
            }
            n26 = 1;
            while (n26 < objectArray.length) {
                if (fArray2[n22][objectArray[n26]] > fArray2[n22][objectArray[n]]) {
                    n = n26;
                }
                if (fArray2[n22][objectArray[n26]] < fArray2[n22][objectArray[n25]]) {
                    n25 = n26;
                }
                ++n26;
            }
            n26 = 0;
            while (n26 < 3) {
                n16 = (n23 + 1) % nArray6.length;
                float f = fArray3[objectArray[n]];
                float f3 = fArray4[objectArray[n]];
                float f4 = fArray3[nArray6[n16]] - f;
                float f5 = fArray4[nArray6[n16]] - f3;
                float f6 = fArray3[nArray6[n23]] - f;
                float f7 = fArray4[nArray6[n23]] - f3;
                float f8 = bl ? (float)((double)f5 / Math.sqrt(f4 * f4 + f5 * f5)) : (float)((double)f4 / Math.sqrt(f4 * f4 + f5 * f5));
                float f9 = bl ? (float)((double)f7 / Math.sqrt(f6 * f6 + f7 * f7)) : (float)((double)f6 / Math.sqrt(f6 * f6 + f7 * f7));
                int n27 = n15 = !(f8 < f9) ? 0 : 1;
                if (n15 == 0) {
                    n16 = n23;
                    f8 = 0.0f;
                    f9 = 1.0f;
                }
                while (f8 < f9) {
                    n23 = n16;
                    n16 = n15 != 0 ? (n23 + 1) % nArray6.length : (n23 + nArray6.length - 1) % nArray6.length;
                    f4 = fArray3[nArray6[n16]] - f;
                    f5 = fArray4[nArray6[n16]] - f3;
                    f6 = fArray3[nArray6[n23]] - f;
                    f7 = fArray4[nArray6[n23]] - f3;
                    f8 = bl ? (float)((double)f5 / Math.sqrt(f4 * f4 + f5 * f5)) : (float)((double)f4 / Math.sqrt(f4 * f4 + f5 * f5));
                    float f10 = f9 = bl ? (float)((double)f7 / Math.sqrt(f6 * f6 + f7 * f7)) : (float)((double)f6 / Math.sqrt(f6 * f6 + f7 * f7));
                }
                n16 = (n + 1) % objectArray.length;
                f = fArray3[nArray6[n23]];
                f3 = fArray4[nArray6[n23]];
                f4 = fArray3[objectArray[n16]] - f;
                f5 = fArray4[objectArray[n16]] - f3;
                f6 = fArray3[objectArray[n]] - f;
                f7 = fArray4[objectArray[n]] - f3;
                f8 = bl ? (float)((double)f5 / Math.sqrt(f4 * f4 + f5 * f5)) : (float)((double)f4 / Math.sqrt(f4 * f4 + f5 * f5));
                f9 = bl ? (float)((double)f7 / Math.sqrt(f6 * f6 + f7 * f7)) : (float)((double)f6 / Math.sqrt(f6 * f6 + f7 * f7));
                int n28 = n15 = !(f8 < f9) ? 0 : 1;
                if (n15 == 0) {
                    n16 = n;
                    f8 = 0.0f;
                    f9 = 1.0f;
                }
                while (f8 < f9) {
                    n = n16;
                    n16 = n15 != 0 ? (n + 1) % objectArray.length : (n + objectArray.length - 1) % objectArray.length;
                    f4 = fArray3[objectArray[n16]] - f;
                    f5 = fArray4[objectArray[n16]] - f3;
                    f6 = fArray3[objectArray[n]] - f;
                    f7 = fArray4[objectArray[n]] - f3;
                    f8 = bl ? (float)((double)f5 / Math.sqrt(f4 * f4 + f5 * f5)) : (float)((double)f4 / Math.sqrt(f4 * f4 + f5 * f5));
                    float f11 = f9 = bl ? (float)((double)f7 / Math.sqrt(f6 * f6 + f7 * f7)) : (float)((double)f6 / Math.sqrt(f6 * f6 + f7 * f7));
                }
                n16 = (n24 + 1) % nArray6.length;
                f = fArray3[objectArray[n25]];
                f3 = fArray4[objectArray[n25]];
                f4 = fArray3[nArray6[n16]] - f;
                f5 = fArray4[nArray6[n16]] - f3;
                f6 = fArray3[nArray6[n24]] - f;
                f7 = fArray4[nArray6[n24]] - f3;
                f8 = bl ? (float)((double)f5 / Math.sqrt(f4 * f4 + f5 * f5)) : (float)((double)f4 / Math.sqrt(f4 * f4 + f5 * f5));
                f9 = bl ? (float)((double)f7 / Math.sqrt(f6 * f6 + f7 * f7)) : (float)((double)f6 / Math.sqrt(f6 * f6 + f7 * f7));
                int n29 = n15 = !(f8 > f9) ? 0 : 1;
                if (n15 == 0) {
                    n16 = n24;
                    f8 = 1.0f;
                    f9 = 0.0f;
                }
                while (f8 > f9) {
                    n24 = n16;
                    n16 = n15 != 0 ? (n24 + 1) % nArray6.length : (n24 + nArray6.length - 1) % nArray6.length;
                    f4 = fArray3[nArray6[n16]] - f;
                    f5 = fArray4[nArray6[n16]] - f3;
                    f6 = fArray3[nArray6[n24]] - f;
                    f7 = fArray4[nArray6[n24]] - f3;
                    f8 = bl ? (float)((double)f5 / Math.sqrt(f4 * f4 + f5 * f5)) : (float)((double)f4 / Math.sqrt(f4 * f4 + f5 * f5));
                    float f12 = f9 = bl ? (float)((double)f7 / Math.sqrt(f6 * f6 + f7 * f7)) : (float)((double)f6 / Math.sqrt(f6 * f6 + f7 * f7));
                }
                n16 = (n25 + 1) % objectArray.length;
                f = fArray3[nArray6[n24]];
                f3 = fArray4[nArray6[n24]];
                f4 = fArray3[objectArray[n16]] - f;
                f5 = fArray4[objectArray[n16]] - f3;
                f6 = fArray3[objectArray[n25]] - f;
                f7 = fArray4[objectArray[n25]] - f3;
                f8 = bl ? (float)((double)f5 / Math.sqrt(f4 * f4 + f5 * f5)) : (float)((double)f4 / Math.sqrt(f4 * f4 + f5 * f5));
                f9 = bl ? (float)((double)f7 / Math.sqrt(f6 * f6 + f7 * f7)) : (float)((double)f6 / Math.sqrt(f6 * f6 + f7 * f7));
                int n30 = n15 = !(f8 > f9) ? 0 : 1;
                if (n15 == 0) {
                    n16 = n25;
                    f8 = 1.0f;
                    f9 = 0.0f;
                }
                while (f8 > f9) {
                    n25 = n16;
                    n16 = n15 != 0 ? (n25 + 1) % objectArray.length : (n25 + objectArray.length - 1) % objectArray.length;
                    f4 = fArray3[objectArray[n16]] - f;
                    f5 = fArray4[objectArray[n16]] - f3;
                    f6 = fArray3[objectArray[n25]] - f;
                    f7 = fArray4[objectArray[n25]] - f3;
                    f8 = bl ? (float)((double)f5 / Math.sqrt(f4 * f4 + f5 * f5)) : (float)((double)f4 / Math.sqrt(f4 * f4 + f5 * f5));
                    float f13 = f9 = bl ? (float)((double)f7 / Math.sqrt(f6 * f6 + f7 * f7)) : (float)((double)f6 / Math.sqrt(f6 * f6 + f7 * f7));
                }
                ++n26;
            }
            if (n24 == n23) {
                n26 = nArray6.length;
                n14 = 1;
                n13 = 0;
            } else {
                n26 = n24 - n23 + 1;
                if (n26 <= 0) {
                    n26 += nArray6.length;
                }
                n14 = nArray6.length - n26 + 2;
                n13 = 1;
            }
            if (n25 == n) {
                n16 = objectArray.length;
                n12 = 1;
                n11 = 0;
            } else {
                n16 = n - n25 + 1;
                if (n16 <= 0) {
                    n16 += objectArray.length;
                }
                n12 = objectArray.length - n16 + 2;
                n11 = 1;
            }
            int[] nArray7 = new int[n14 + n12];
            int n31 = 0;
            int n32 = n24;
            while (n32 != n23) {
                nArray7[n31] = nArray6[n32];
                ++n31;
                n32 = (n32 + 1) % nArray6.length;
            }
            nArray7[n31++] = nArray6[n23];
            n32 = n;
            while (n32 != n25) {
                nArray7[n31] = objectArray[n32];
                ++n31;
                n32 = (n32 + 1) % objectArray.length;
            }
            nArray7[n31++] = objectArray[n25];
            nArray4[n9++] = nArray7;
            int n33 = n24;
            n15 = n25;
            int n34 = (n33 + nArray6.length - 1) % nArray6.length;
            int n35 = (n15 + 1) % objectArray.length;
            int n36 = n14 == 1 || n12 == 1 ? n26 + n16 - 1 : n26 + n16 - 2;
            nArray[n5][0] = new int[n36];
            nArray[n5][1] = new int[n36];
            nArray[n5][2] = new int[n36];
            int n37 = 0;
            while (n37 < n36) {
                if (n13 == n26) {
                    n35 = (n15 + 1) % objectArray.length;
                    nArray[n5][0][n37] = objectArray[n15];
                    nArray[n5][1][n37] = nArray6[n33];
                    nArray[n5][2][n37] = objectArray[n35];
                    ++n3;
                    int n38 = nArray6[n33];
                    nArray2[n38] = nArray2[n38] + 1;
                    int n39 = objectArray[n15];
                    nArray2[n39] = nArray2[n39] + 1;
                    int n40 = objectArray[n35];
                    nArray2[n40] = nArray2[n40] + 1;
                    n15 = n35;
                    ++n11;
                } else if (n11 == n16) {
                    n34 = (n33 + nArray6.length - 1) % nArray6.length;
                    nArray[n5][0][n37] = objectArray[n15];
                    nArray[n5][1][n37] = nArray6[n33];
                    nArray[n5][2][n37] = nArray6[n34];
                    ++n3;
                    int n41 = nArray6[n33];
                    nArray2[n41] = nArray2[n41] + 1;
                    int n42 = objectArray[n15];
                    nArray2[n42] = nArray2[n42] + 1;
                    int n43 = nArray6[n34];
                    nArray2[n43] = nArray2[n43] + 1;
                    n33 = n34;
                    ++n13;
                } else {
                    boolean bl3;
                    int n44 = nArray6[n33];
                    int n45 = nArray6[n34];
                    int n46 = objectArray[n15];
                    int n47 = objectArray[n35];
                    float f = fArray3[n47];
                    float f14 = fArray4[n47];
                    float f15 = fArray3[n46];
                    float f16 = fArray4[n46];
                    float f17 = fArray3[n45];
                    float f18 = fArray4[n45];
                    float f19 = fArray3[n44];
                    float f20 = fArray4[n44];
                    float f21 = f - f15;
                    float f22 = f14 - f16;
                    float f23 = f - f17;
                    float f24 = f14 - f18;
                    float f25 = f19 - f15;
                    float f26 = f20 - f16;
                    float f27 = f19 - f17;
                    float f28 = f20 - f18;
                    float f29 = f21 * f23 + f22 * f24;
                    float f30 = f25 * f21 + f26 * f22;
                    float f31 = f23 * f27 + f24 * f28;
                    float f32 = f25 * f27 + f26 * f28;
                    boolean bl4 = f21 * f24 - f22 * f23 >= 0.0f;
                    boolean bl5 = f25 * f22 - f26 * f21 >= 0.0f;
                    boolean bl6 = f23 * f28 - f24 * f27 >= 0.0f;
                    boolean bl7 = f27 * f26 - f28 * f25 >= 0.0f;
                    boolean bl8 = bl3 = (bl4 ? 1 : 0) + (bl5 ? 1 : 0) + (bl6 ? 1 : 0) + (bl7 ? 1 : 0) < 2;
                    boolean bl9 = bl4 == bl3 ? true : (bl5 == bl3 ? false : (bl6 == bl3 ? false : (bl7 == bl3 ? true : (f29 < 0.0f && f32 < 0.0f || f30 > 0.0f && f31 > 0.0f ? true : (f30 < 0.0f && f31 < 0.0f || f29 > 0.0f && f32 > 0.0f ? false : (f29 < 0.0f ? f29 : f32) < (f30 < 0.0f ? f30 : f31))))));
                    if (bl9) {
                        nArray[n5][0][n37] = objectArray[n15];
                        nArray[n5][1][n37] = nArray6[n33];
                        nArray[n5][2][n37] = objectArray[n35];
                        ++n3;
                        int n48 = nArray6[n33];
                        nArray2[n48] = nArray2[n48] + 1;
                        int n49 = objectArray[n15];
                        nArray2[n49] = nArray2[n49] + 1;
                        int n50 = objectArray[n35];
                        nArray2[n50] = nArray2[n50] + 1;
                        n15 = n35;
                        ++n11;
                        n35 = (n15 + 1) % objectArray.length;
                    } else {
                        nArray[n5][0][n37] = objectArray[n15];
                        nArray[n5][1][n37] = nArray6[n33];
                        nArray[n5][2][n37] = nArray6[n34];
                        ++n3;
                        int n51 = nArray6[n33];
                        nArray2[n51] = nArray2[n51] + 1;
                        int n52 = objectArray[n15];
                        nArray2[n52] = nArray2[n52] + 1;
                        int n53 = nArray6[n34];
                        nArray2[n53] = nArray2[n53] + 1;
                        n33 = n34;
                        ++n13;
                        n34 = (n33 + nArray6.length - 1) % nArray6.length;
                    }
                }
                ++n37;
            }
            ++n5;
        }
        this.Tri = new int[n3][3];
        int n54 = 0;
        int n55 = 0;
        while (n55 < n5) {
            int n56 = 0;
            while (n56 < nArray[n55][0].length) {
                this.Tri[n54][0] = nArray[n55][0][n56];
                this.Tri[n54][1] = nArray[n55][1][n56];
                this.Tri[n54][2] = nArray[n55][2][n56];
                ++n54;
                ++n56;
            }
            ++n55;
        }
        this.Vertices = new int[n2][];
        n55 = 0;
        while (n55 < n2) {
            this.Vertices[n55] = new int[nArray2[n55]];
            nArray2[n55] = 0;
            ++n55;
        }
        n = 0;
        while (n < n3) {
            n55 = this.Tri[n][0];
            int n57 = this.Tri[n][1];
            int n58 = this.Tri[n][2];
            int n59 = n55;
            int n60 = nArray2[n59];
            nArray2[n59] = n60 + 1;
            this.Vertices[n55][n60] = n;
            int n61 = n57;
            int n62 = nArray2[n61];
            nArray2[n61] = n62 + 1;
            this.Vertices[n57][n62] = n;
            int n63 = n58;
            int n64 = nArray2[n63];
            nArray2[n63] = n64 + 1;
            this.Vertices[n58][n64] = n++;
        }
        this.finish_triang(fArray);
    }
}

