/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.Delaunay;
import visad.Gridded2DSet;
import visad.Irregular2DSet;
import visad.SampledSet;
import visad.SetException;
import visad.UnionSet;
import visad.VisADException;

public class DelaunayCustom
extends Delaunay {
    private static final float SELF = 0.9999f;
    private static final float PULL = 1.00016594E-4f;
    private static final float PULL2 = 5.0008297E-5f;

    public static boolean checkSelfIntersection(Gridded2DSet gridded2DSet) throws VisADException {
        if (gridded2DSet == null) {
            return false;
        }
        if (gridded2DSet.getManifoldDimension() != 1) {
            throw new SetException("Gridded2DSet musy have manifold dimension = 1");
        }
        return DelaunayCustom.checkSelfIntersection(gridded2DSet.getSamples());
    }

    public static boolean checkSelfIntersection(float[][] fArray) throws VisADException {
        if (fArray == null) {
            return false;
        }
        if (fArray.length != 2 || fArray[0].length != fArray[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        int n = fArray[0].length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n - 1) {
            nArray[n2] = n2 + 1;
            ++n2;
        }
        nArray[n - 1] = 0;
        n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                float f;
                float f2;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                float f9;
                if (n2 != n3 && n2 != nArray[n3] && nArray[n2] != n3 && !((double)Math.abs(f9 = ((f8 = fArray[0][nArray[n2]]) - (f7 = fArray[0][n2])) * ((f6 = fArray[1][n3]) - (f5 = fArray[1][nArray[n3]])) - ((f4 = fArray[1][nArray[n2]]) - (f3 = fArray[1][n2])) * ((f2 = fArray[0][n3]) - (f = fArray[0][nArray[n3]]))) < 1.0E-7)) {
                    float f10 = ((f8 - f7) * (f6 - f3) - (f4 - f3) * (f2 - f7)) / f9;
                    float f11 = ((f2 - f7) * (f6 - f5) - (f6 - f3) * (f2 - f)) / f9;
                    if (0.0f < f10 && f10 < 1.0f && 0.0f < f11 && f11 < 1.0f) {
                        return true;
                    }
                }
                ++n3;
            }
            ++n2;
        }
        return false;
    }

    public static boolean checkAndFixSelfIntersection(float[][] fArray) throws VisADException {
        if (fArray == null) {
            return false;
        }
        if (fArray.length != 2 || fArray[0].length != fArray[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        int n = fArray[0].length;
        boolean bl = false;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n - 1) {
            nArray[n2] = n2 + 1;
            ++n2;
        }
        nArray[n - 1] = 0;
        float[][] fArray2 = new float[2][n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (fArray[0][n4] != fArray[0][nArray[n4]] || fArray[1][n4] != fArray[1][nArray[n4]]) {
                fArray2[0][n3] = fArray[0][n4];
                fArray2[1][n3] = fArray[1][n4];
                ++n3;
            }
            ++n4;
        }
        if (n3 != n) {
            fArray[0] = new float[n3];
            fArray[1] = new float[n3];
            if (n3 == 0) {
                return false;
            }
            System.arraycopy(fArray2[0], 0, fArray[0], 0, n3);
            System.arraycopy(fArray2[1], 0, fArray[1], 0, n3);
            n = n3;
            nArray = new int[n];
            n4 = 0;
            while (n4 < n - 1) {
                nArray[n4] = n4 + 1;
                ++n4;
            }
            nArray[n - 1] = 0;
        }
        int[] nArray2 = new int[n];
        int n5 = 1;
        while (n5 < n) {
            nArray2[n5] = n5 - 1;
            ++n5;
        }
        nArray2[0] = n - 1;
        n5 = 0;
        while (n5 < n) {
            if (fArray[0][n5] == fArray[0][nArray[n5]] && fArray[1][n5] == fArray[1][nArray[n5]]) {
                System.out.println("equal consecutive points");
            }
            int n6 = 0;
            while (n6 < n) {
                float f;
                float f2;
                float f3;
                float f4;
                float f5;
                float f6;
                float f7;
                float f8;
                float f9;
                if (n5 != n6 && n5 != nArray[n6] && nArray[n5] != n6 && !((double)Math.abs(f9 = ((f8 = fArray[0][nArray[n5]]) - (f7 = fArray[0][n5])) * ((f6 = fArray[1][n6]) - (f5 = fArray[1][nArray[n6]])) - ((f4 = fArray[1][nArray[n5]]) - (f3 = fArray[1][n5])) * ((f2 = fArray[0][n6]) - (f = fArray[0][nArray[n6]]))) < 1.0E-7)) {
                    float f10 = ((f8 - f7) * (f6 - f3) - (f4 - f3) * (f2 - f7)) / f9;
                    float f11 = ((f2 - f7) * (f6 - f5) - (f6 - f3) * (f2 - f)) / f9;
                    if (0.0f < f10 && f10 < 1.0f && 0.0f < f11 && f11 < 1.0f) {
                        bl = true;
                    } else if (!(0.0f != f10 && f10 != 1.0f || 0.0f != f11 && f11 != 1.0f)) {
                        if (f10 == 0.0f) {
                            fArray[0][n5] = 0.9999f * f7 + 5.0008297E-5f * (f8 + fArray[0][nArray2[n5]]);
                            fArray[1][n5] = 0.9999f * f3 + 5.0008297E-5f * (f4 + fArray[1][nArray2[n5]]);
                        } else if (f10 == 1.0f) {
                            n3 = nArray[n5];
                            fArray[0][n3] = 0.9999f * f8 + 5.0008297E-5f * (f7 + fArray[0][nArray[n3]]);
                            fArray[1][n3] = 0.9999f * f4 + 5.0008297E-5f * (f3 + fArray[1][nArray[n3]]);
                        }
                        if (f11 == 0.0f) {
                            fArray[0][n6] = 0.9999f * f2 + 5.0008297E-5f * (f + fArray[0][nArray2[n6]]);
                            fArray[1][n6] = 0.9999f * f6 + 5.0008297E-5f * (f5 + fArray[1][nArray2[n6]]);
                        } else if (f11 == 1.0f) {
                            n3 = nArray[n6];
                            fArray[0][n3] = 0.9999f * f + 5.0008297E-5f * (f2 + fArray[0][nArray[n3]]);
                            fArray[1][n3] = 0.9999f * f5 + 5.0008297E-5f * (f6 + fArray[1][nArray[n3]]);
                        }
                    }
                }
                ++n6;
            }
            ++n5;
        }
        return bl;
    }

    public static float computeArea(UnionSet unionSet) throws VisADException {
        if (unionSet == null) {
            return 0.0f;
        }
        if (unionSet.getManifoldDimension() != 1) {
            throw new SetException("UnionSet must have manifold dimension = 1");
        }
        SampledSet[] sampledSetArray = unionSet.getSets();
        if (sampledSetArray == null) {
            return 0.0f;
        }
        int n = sampledSetArray.length;
        if (n == 0) {
            return 0.0f;
        }
        float[][][] fArray = new float[n][][];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (!(sampledSetArray[n3] instanceof Gridded2DSet)) {
                throw new SetException("UnionSet must contain only Gridded2DSets");
            }
            fArray[n2] = sampledSetArray[n3].getSamples();
            if (fArray[n2] != null && fArray[n2].length == 2 && fArray[n2][0].length > 2) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return 0.0f;
        }
        float[][][] fArray2 = new float[n2][][];
        System.arraycopy(fArray, 0, fArray2, 0, n2);
        fArray = fArray2;
        float[][] fArray3 = DelaunayCustom.link(fArray);
        if (fArray3 == null) {
            return 0.0f;
        }
        return DelaunayCustom.computeArea(fArray3);
    }

    public static float computeArea(Gridded2DSet gridded2DSet) throws VisADException {
        if (gridded2DSet == null) {
            return 0.0f;
        }
        if (gridded2DSet.getManifoldDimension() != 1) {
            throw new SetException("Gridded2DSet musy have manifold dimension = 1");
        }
        return DelaunayCustom.computeArea(gridded2DSet.getSamples());
    }

    public static float computeArea(float[][] fArray) throws VisADException {
        if (fArray == null) {
            return 0.0f;
        }
        if (fArray.length != 2 || fArray[0].length != fArray[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        if (fArray[0].length < 3) {
            return 0.0f;
        }
        if (DelaunayCustom.checkSelfIntersection(fArray)) {
            throw new VisADException("path self intersects");
        }
        int n = fArray[0].length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n - 1) {
            nArray[n2] = n2 + 1;
            ++n2;
        }
        nArray[n - 1] = 0;
        float f = 0.0f;
        int n3 = 0;
        while (n3 < n) {
            f += fArray[0][n3] * fArray[1][nArray[n3]] - fArray[0][nArray[n3]] * fArray[1][n3];
            ++n3;
        }
        return (float)Math.abs(0.5 * (double)f);
    }

    public static Irregular2DSet fill(Gridded2DSet gridded2DSet) throws VisADException {
        return DelaunayCustom.fillCheck(gridded2DSet, true);
    }

    public static Irregular2DSet fillCheck(Gridded2DSet gridded2DSet, boolean bl) throws VisADException {
        if (gridded2DSet == null) {
            return null;
        }
        if (gridded2DSet.getManifoldDimension() != 1) {
            throw new SetException("Gridded2DSet musy have manifold dimension = 1");
        }
        float[][] fArray = gridded2DSet.getSamples();
        int[][] nArray = DelaunayCustom.fillCheck(fArray, bl);
        if (nArray == null || nArray[0].length == 0) {
            return null;
        }
        DelaunayCustom delaunayCustom = new DelaunayCustom(fArray, nArray);
        if (delaunayCustom == null) {
            return null;
        }
        return new Irregular2DSet(gridded2DSet.getType(), fArray, null, null, null, delaunayCustom);
    }

    public static int[][] fill(float[][] fArray) throws VisADException {
        return DelaunayCustom.fillCheck(fArray, true);
    }

    public static int[][] fillCheck(float[][] fArray, boolean bl) throws VisADException {
        if (fArray == null) {
            return null;
        }
        if (fArray.length != 2 || fArray[0].length != fArray[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        if (fArray[0].length < 3) {
            return null;
        }
        if (DelaunayCustom.checkAndFixSelfIntersection(fArray) && bl) {
            throw new VisADException("path self intersects");
        }
        int n = fArray[0].length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n - 1) {
            nArray[n2] = n2 + 1;
            ++n2;
        }
        nArray[n - 1] = 0;
        int[] nArray2 = new int[n];
        int n3 = 1;
        while (n3 < n) {
            nArray2[n3] = n3 - 1;
            ++n3;
        }
        nArray2[0] = n - 1;
        float f = 0.0f;
        int n4 = 0;
        while (n4 < n) {
            f += fArray[0][n4] * fArray[1][nArray[n4]] - fArray[0][nArray[n4]] * fArray[1][n4];
            ++n4;
        }
        n4 = !((double)f > 0.0) ? 0 : 1;
        int[][] nArray3 = new int[n - 2][];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = false;
        while (n - n6 > 2) {
            boolean bl3;
            int n8 = nArray[n5];
            float f2 = fArray[0][n8] - fArray[0][n5];
            int n9 = nArray[n8];
            float f3 = fArray[1][n9] - fArray[1][n8];
            float f4 = fArray[0][n9] - fArray[0][n8];
            float f5 = fArray[1][n8] - fArray[1][n5];
            boolean bl4 = bl3 = (!((double)(f2 * f3 - f4 * f5) > 0.0) ? 0 : 1) == n4;
            if (bl3 && n5 != nArray[n9]) {
                float f6;
                int n10;
                float f7;
                float f8 = fArray[1][n5] - fArray[1][n9];
                float f9 = fArray[0][n5] - fArray[0][n9];
                float f10 = fArray[1][n9] * f9 - fArray[0][n9] * f8;
                float f11 = fArray[1][n8] - fArray[1][n5];
                float f12 = fArray[0][n8] - fArray[0][n5];
                float f13 = fArray[1][n5] * f12 - fArray[0][n5] * f11;
                float f14 = fArray[1][n9] - fArray[1][n8];
                float f15 = fArray[0][n9] - fArray[0][n8];
                float f16 = fArray[1][n8] * f15 - fArray[0][n8] * f14;
                int n11 = nArray[n9];
                float f17 = fArray[0][n11];
                float f18 = fArray[1][n11];
                if ((!((double)(f10 + f17 * f8 - f18 * f9) > 0.0) ? 0 : 1) != n4 && (!((double)(f16 + f17 * f14 - f18 * f15) > 0.0) ? 0 : 1) != n4) {
                    bl3 = false;
                }
                if ((!((double)(f10 + (f7 = fArray[0][n10 = nArray2[n5]]) * f8 - (f6 = fArray[1][n10]) * f9) > 0.0) ? 0 : 1) != n4 && (!((double)(f13 + f7 * f11 - f6 * f12) > 0.0) ? 0 : 1) != n4) {
                    bl3 = false;
                }
                if (bl3) {
                    int n12 = nArray[n9];
                    int n13 = nArray[n12];
                    f2 = fArray[0][n5];
                    f5 = fArray[1][n5];
                    f4 = fArray[0][n9];
                    f3 = fArray[1][n9];
                    while (n13 != n5) {
                        float f19 = fArray[0][n12];
                        float f20 = fArray[1][n12];
                        float f21 = fArray[0][n13];
                        float f22 = fArray[1][n13];
                        float f23 = (f4 - f2) * (f20 - f22) - (f3 - f5) * (f19 - f21);
                        n12 = n13;
                        n13 = nArray[n12];
                        if ((double)Math.abs(f23) == 0.0) continue;
                        float f24 = ((f4 - f2) * (f20 - f5) - (f3 - f5) * (f19 - f2)) / f23;
                        float f25 = ((f19 - f2) * (f20 - f22) - (f20 - f5) * (f19 - f21)) / f23;
                        if (!(0.0f <= f24) || !(f24 <= 1.0f) || !(0.0f <= f25) || !(f25 <= 1.0f)) continue;
                        bl3 = false;
                        break;
                    }
                }
            }
            if (bl3) {
                nArray3[n6++] = new int[]{n5, n8, n9};
                nArray[n5] = n9;
                nArray2[n9] = n5;
                n7 = 0;
                continue;
            }
            n5 = n8;
            if (n7++ <= n - n6) continue;
            if (bl2) {
                if (n6 > 0) {
                    int[][] nArray4 = new int[n6][];
                    System.arraycopy(nArray3, 0, nArray4, 0, n6);
                    return nArray4;
                }
                return null;
            }
            bl2 = true;
            n7 = 0;
        }
        return nArray3;
    }

    public static Irregular2DSet fill(UnionSet unionSet) throws VisADException {
        return DelaunayCustom.fillCheck(unionSet, true);
    }

    public static Irregular2DSet fillCheck(UnionSet unionSet, boolean bl) throws VisADException {
        if (unionSet == null) {
            return null;
        }
        if (unionSet.getManifoldDimension() != 1) {
            throw new SetException("UnionSet must have manifold dimension = 1");
        }
        SampledSet[] sampledSetArray = unionSet.getSets();
        if (sampledSetArray == null) {
            return null;
        }
        int n = sampledSetArray.length;
        if (n == 0) {
            return null;
        }
        float[][][] fArray = new float[n][][];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (!(sampledSetArray[n3] instanceof Gridded2DSet)) {
                throw new SetException("UnionSet must contain only Gridded2DSets");
            }
            fArray[n2] = sampledSetArray[n3].getSamples();
            if (fArray[n2] != null && fArray[n2].length == 2 && fArray[n2][0].length > 2) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        float[][][] fArray2 = new float[n2][][];
        System.arraycopy(fArray, 0, fArray2, 0, n2);
        fArray = fArray2;
        float[][] fArray3 = DelaunayCustom.link(fArray);
        int[][] nArray = DelaunayCustom.fillCheck(fArray3, bl);
        if (nArray == null || nArray[0].length == 0) {
            return null;
        }
        DelaunayCustom delaunayCustom = new DelaunayCustom(fArray3, nArray);
        if (delaunayCustom == null) {
            return null;
        }
        return new Irregular2DSet(unionSet.getType(), fArray3, null, null, null, delaunayCustom);
    }

    public static float[][] link(float[][][] fArray) throws VisADException {
        int n;
        int n2;
        if (fArray == null || fArray.length == 0) {
            return null;
        }
        int n3 = fArray.length;
        int n4 = 0;
        while (n4 < n3) {
            if (fArray[n4].length != 2 || fArray[n4][0].length != fArray[n4][1].length) {
                throw new VisADException("samples argument bad dimensions");
            }
            if (DelaunayCustom.checkAndFixSelfIntersection(fArray[n4])) {
                throw new VisADException("path self intersects");
            }
            ++n4;
        }
        float[][][] fArray2 = new float[n3][][];
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            if (fArray[n6][0].length > 2) {
                fArray2[n5] = fArray[n6];
                ++n5;
            }
            ++n6;
        }
        if (n5 == 0) {
            return null;
        }
        if (n5 == 1) {
            return fArray2[0];
        }
        fArray = new float[n5][][];
        System.arraycopy(fArray2, 0, fArray, 0, n5);
        n3 = n5;
        boolean[][] blArray = new boolean[n3][n3];
        int n7 = 0;
        while (n7 < n3) {
            n2 = 0;
            while (n2 < n3) {
                blArray[n7][n2] = n7 == n2 ? false : DelaunayCustom.inside(fArray[n7], fArray[n2][0][0], fArray[n2][1][0]);
                ++n2;
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n3) {
            n2 = 0;
            int n8 = n7;
            while (n8 < n3) {
                boolean bl = false;
                int n9 = n7;
                while (n9 < n3) {
                    if (blArray[n9][n8]) {
                        bl = true;
                        break;
                    }
                    ++n9;
                }
                if (!bl) {
                    n2 = 1;
                    if (n7 == n8) break;
                    float[][] fArray3 = fArray[n7];
                    fArray[n7] = fArray[n8];
                    fArray[n8] = fArray3;
                    boolean[] blArray2 = blArray[n7];
                    blArray[n7] = blArray[n8];
                    blArray[n8] = blArray2;
                    int n10 = 0;
                    while (n10 < n3) {
                        n = blArray[n10][n7];
                        blArray[n10][n7] = blArray[n10][n8];
                        blArray[n10][n8] = n;
                        ++n10;
                    }
                    break;
                }
                ++n8;
            }
            if (n2 == 0) {
                // empty if block
            }
            ++n7;
        }
        boolean[] blArray3 = new boolean[n3];
        n2 = 0;
        while (n2 < n3) {
            float f = 0.0f;
            float[][] fArray4 = fArray[n2];
            int n11 = fArray4[0].length;
            int n12 = 0;
            while (n12 < n11 - 1) {
                f += fArray4[0][n12] * fArray4[1][n12 + 1] - fArray4[0][n12 + 1] * fArray4[1][n12];
                ++n12;
            }
            blArray3[n2] = (double)(f += fArray4[0][n11 - 1] * fArray4[1][0] - fArray4[0][0] * fArray4[1][n11 - 1]) > 0.0;
            ++n2;
        }
        float[][] fArray5 = fArray[0];
        int n13 = 1;
        while (n13 < n3) {
            float[][] fArray6 = fArray[n13];
            if (fArray6[0].length >= 3) {
                int n14;
                int n15 = fArray5[0].length;
                int n16 = fArray6[0].length;
                float f = Float.MAX_VALUE;
                n = -1;
                int n17 = -1;
                int n18 = 0;
                while (n18 < n15) {
                    n14 = 0;
                    while (n14 < n16) {
                        float f2 = (fArray5[0][n18] - fArray6[0][n14]) * (fArray5[0][n18] - fArray6[0][n14]) + (fArray5[1][n18] - fArray6[1][n14]) * (fArray5[1][n18] - fArray6[1][n14]);
                        if (f2 < f) {
                            f = f2;
                            n = n18;
                            n17 = n14;
                        }
                        ++n14;
                    }
                    ++n18;
                }
                if (n >= 0) {
                    int n19;
                    n18 = blArray[0][n13];
                    n14 = (blArray3[0] != blArray3[n13] ? 0 : 1) != n18 ? 0 : 1;
                    int n20 = n15 + n16 + 2;
                    float[][] fArray7 = new float[2][n20];
                    n5 = 0;
                    System.arraycopy(fArray5[0], 0, fArray7[0], n5, n + 1);
                    System.arraycopy(fArray5[1], 0, fArray7[1], n5, n + 1);
                    int n21 = (n5 += n + 1) - 1;
                    int n22 = n5;
                    if (n14 != 0) {
                        n19 = n17;
                        while (n19 >= 0) {
                            fArray7[0][n5] = fArray6[0][n19];
                            fArray7[1][n5] = fArray6[1][n19];
                            ++n5;
                            --n19;
                        }
                        n19 = n16 - 1;
                        while (n19 >= n17) {
                            fArray7[0][n5] = fArray6[0][n19];
                            fArray7[1][n5] = fArray6[1][n19];
                            ++n5;
                            --n19;
                        }
                    } else {
                        System.arraycopy(fArray6[0], n17, fArray7[0], n5, n16 - n17);
                        System.arraycopy(fArray6[1], n17, fArray7[1], n5, n16 - n17);
                        System.arraycopy(fArray6[0], 0, fArray7[0], n5 += n16 - n17, n17 + 1);
                        System.arraycopy(fArray6[1], 0, fArray7[1], n5, n17 + 1);
                        n5 += n17 + 1;
                    }
                    n19 = n5 - 1;
                    int n23 = n5;
                    System.arraycopy(fArray5[0], n, fArray7[0], n5, n15 - n);
                    System.arraycopy(fArray5[1], n, fArray7[1], n5, n15 - n);
                    fArray5[0] = fArray7[0];
                    fArray5[1] = fArray7[1];
                    int n24 = n21 > 0 ? n21 - 1 : n20 - 1;
                    int n25 = n22 < n20 - 1 ? n22 + 1 : 0;
                    int n26 = n19 > 0 ? n19 - 1 : n20 - 1;
                    int n27 = n23 < n20 - 1 ? n23 + 1 : 0;
                    fArray7[0][n21] = 0.9999f * fArray7[0][n21] + 1.00016594E-4f * fArray7[0][n24];
                    fArray7[1][n21] = 0.9999f * fArray7[1][n21] + 1.00016594E-4f * fArray7[1][n24];
                    fArray7[0][n22] = 0.9999f * fArray7[0][n22] + 1.00016594E-4f * fArray7[0][n25];
                    fArray7[1][n22] = 0.9999f * fArray7[1][n22] + 1.00016594E-4f * fArray7[1][n25];
                    fArray7[0][n19] = 0.9999f * fArray7[0][n19] + 1.00016594E-4f * fArray7[0][n26];
                    fArray7[1][n19] = 0.9999f * fArray7[1][n19] + 1.00016594E-4f * fArray7[1][n26];
                    fArray7[0][n23] = 0.9999f * fArray7[0][n23] + 1.00016594E-4f * fArray7[0][n27];
                    fArray7[1][n23] = 0.9999f * fArray7[1][n23] + 1.00016594E-4f * fArray7[1][n27];
                }
            }
            ++n13;
        }
        return fArray5;
    }

    public static boolean inside(float[][] fArray, float f, float f2) throws VisADException {
        if (fArray == null) {
            return false;
        }
        if (fArray.length != 2 || fArray[0].length != fArray[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        int n = fArray[0].length;
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 < n - 1 ? n2 + 1 : 0;
            double d2 = Math.atan2(fArray[0][n2] - f, fArray[1][n2] - f2) - Math.atan2(fArray[0][n3] - f, fArray[1][n3] - f2);
            if (d2 < -Math.PI) {
                d2 += Math.PI;
            }
            if (d2 > Math.PI) {
                d2 -= Math.PI;
            }
            d += d2;
            ++n2;
        }
        return Math.abs(d) > 0.5;
    }

    public static void clip(float[][] fArray, int[][] nArray, float f, float f2, float f3, float[][][] fArray2, int[][][] nArray2) throws VisADException {
        float[][] fArray3 = null;
        int[][] nArray3 = null;
        if (fArray == null || nArray == null) {
            fArray2[0] = fArray3;
            nArray2[0] = nArray3;
            return;
        }
        int n = fArray[0].length;
        int n2 = 0;
        fArray3 = new float[2][2 * n];
        int n3 = nArray.length;
        int n4 = 0;
        nArray3 = new int[2 * n3][];
        int[] nArray4 = new int[n];
        int[][] nArray5 = new int[n][6];
        int[][] nArray6 = new int[n][6];
        int[] nArray7 = new int[]{-1, -1, -1, -1, -1, -1};
        int n5 = 0;
        while (n5 < n) {
            System.arraycopy(nArray7, 0, nArray5[n5], 0, 6);
            if (f * fArray[0][n5] + f2 * fArray[1][n5] <= f3) {
                fArray3[0][n2] = fArray[0][n5];
                fArray3[1][n2] = fArray[1][n5];
                nArray4[n5] = n2++;
            } else {
                nArray4[n5] = -1;
            }
            ++n5;
        }
        n5 = n2;
        int[] nArray8 = new int[]{0, 1, 1, 2, 1, 2, 2, 3};
        int[] nArray9 = new int[]{-1, 0, 1, 0, 2, 0, 1, 0};
        int[] nArray10 = new int[]{-1, 1, 0, 1, 0, 2, 2, 1};
        int[] nArray11 = new int[]{-1, 2, 2, 2, 1, 1, 0, 2};
        int n6 = 0;
        while (n6 < n3) {
            int n7 = nArray[n6][0];
            int n8 = nArray[n6][1];
            int n9 = nArray[n6][2];
            int n10 = nArray4[n7] < 0 ? 0 : 1;
            n10 += nArray4[n8] < 0 ? 0 : 2;
            switch (nArray8[n10 += nArray4[n9] < 0 ? 0 : 4]) {
                case 0: {
                    break;
                }
                case 3: {
                    nArray3[n4] = new int[]{nArray4[nArray[n6][0]], nArray4[nArray[n6][1]], nArray4[nArray[n6][2]]};
                    ++n4;
                    break;
                }
                case 1: {
                    int n11 = nArray[n6][nArray9[n10]];
                    int n12 = nArray[n6][nArray10[n10]];
                    int n13 = nArray[n6][nArray11[n10]];
                    float f4 = f3 - (f * fArray[0][n11] + f2 * fArray[1][n11]);
                    float f5 = f3 - (f * fArray[0][n12] + f2 * fArray[1][n12]);
                    float f6 = f3 - (f * fArray[0][n13] + f2 * fArray[1][n13]);
                    float f7 = f4 / (f4 - f5);
                    float f8 = 1.0f - f7;
                    float f9 = f4 / (f4 - f6);
                    float f10 = 1.0f - f9;
                    float[] fArray4 = new float[]{f8 * fArray[0][n11] + f7 * fArray[0][n12], f8 * fArray[1][n11] + f7 * fArray[1][n12]};
                    float[] fArray5 = new float[]{f10 * fArray[0][n11] + f9 * fArray[0][n13], f10 * fArray[1][n11] + f9 * fArray[1][n13]};
                    int n14 = -1;
                    int n15 = -1;
                    int n16 = -1;
                    int n17 = 0;
                    while (n17 < 6) {
                        if (nArray5[n11][n17] < 0) break;
                        n16 = n17;
                        if (nArray5[n11][n17] == n12) {
                            n14 = nArray6[n11][n17];
                        }
                        if (nArray5[n11][n17] == n13) {
                            n15 = nArray6[n11][n17];
                        }
                        ++n17;
                    }
                    if (n14 < 0) {
                        fArray3[0][n2] = fArray4[0];
                        fArray3[1][n2] = fArray4[1];
                        if (n16 < 5) {
                            nArray5[n11][++n16] = n12;
                            nArray6[n11][n16] = n2;
                        }
                        n14 = n2++;
                    }
                    if (n15 < 0) {
                        fArray3[0][n2] = fArray5[0];
                        fArray3[1][n2] = fArray5[1];
                        if (n16 < 5) {
                            nArray5[n11][++n16] = n13;
                            nArray6[n11][n16] = n2;
                        }
                        n15 = n2++;
                    }
                    nArray3[n4] = new int[]{nArray4[n11], n14, n15};
                    ++n4;
                    break;
                }
                case 2: {
                    int n11 = nArray[n6][nArray9[n10]];
                    int n12 = nArray[n6][nArray10[n10]];
                    int n13 = nArray[n6][nArray11[n10]];
                    float f4 = f3 - (f * fArray[0][n11] + f2 * fArray[1][n11]);
                    float f5 = f3 - (f * fArray[0][n12] + f2 * fArray[1][n12]);
                    float f6 = f3 - (f * fArray[0][n13] + f2 * fArray[1][n13]);
                    float f11 = f4 / (f4 - f6);
                    float f12 = 1.0f - f11;
                    float f7 = f5 / (f5 - f6);
                    float f8 = 1.0f - f7;
                    float[] fArray6 = new float[]{f12 * fArray[0][n11] + f11 * fArray[0][n13], f12 * fArray[1][n11] + f11 * fArray[1][n13]};
                    float[] fArray4 = new float[]{f8 * fArray[0][n12] + f7 * fArray[0][n13], f8 * fArray[1][n12] + f7 * fArray[1][n13]};
                    int n18 = -1;
                    int n14 = -1;
                    int n19 = -1;
                    int n20 = 0;
                    while (n20 < 6) {
                        if (nArray5[n11][n20] < 0) break;
                        n19 = n20;
                        if (nArray5[n11][n20] == n13) {
                            n18 = nArray6[n11][n20];
                        }
                        ++n20;
                    }
                    n20 = -1;
                    int n21 = 0;
                    while (n21 < 6) {
                        if (nArray5[n12][n21] < 0) break;
                        n20 = n21;
                        if (nArray5[n12][n21] == n13) {
                            n14 = nArray6[n12][n21];
                        }
                        ++n21;
                    }
                    if (n18 < 0) {
                        fArray3[0][n2] = fArray6[0];
                        fArray3[1][n2] = fArray6[1];
                        if (n19 < 5) {
                            nArray5[n11][++n19] = n13;
                            nArray6[n11][n19] = n2;
                        }
                        n18 = n2++;
                    }
                    if (n14 < 0) {
                        fArray3[0][n2] = fArray4[0];
                        fArray3[1][n2] = fArray4[1];
                        if (n20 < 5) {
                            nArray5[n12][++n20] = n13;
                            nArray6[n12][n20] = n2;
                        }
                        n14 = n2++;
                    }
                    nArray3[n4] = new int[]{nArray4[n11], nArray4[n12], n18};
                    nArray3[++n4] = new int[]{nArray4[n12], n18, n14};
                    ++n4;
                    break;
                }
            }
            ++n6;
        }
        if (n2 == 0 || n4 == 0) {
            fArray2[0] = null;
            nArray2[0] = null;
        } else {
            float[][] fArray7 = new float[2][n2];
            System.arraycopy(fArray3[0], 0, fArray7[0], 0, n2);
            System.arraycopy(fArray3[1], 0, fArray7[1], 0, n2);
            int[][] nArray12 = new int[n4][];
            System.arraycopy(nArray3, 0, nArray12, 0, n4);
            fArray2[0] = fArray7;
            nArray2[0] = nArray12;
        }
    }

    public DelaunayCustom(float[][] fArray, int[][] nArray) throws VisADException {
        this(fArray, nArray, null, null, null, 0, true);
    }

    public DelaunayCustom(float[][] fArray, int[][] nArray, int[][] nArray2, int[][] nArray3, int[][] nArray4, int n) throws VisADException {
        this(fArray, nArray, nArray2, nArray3, nArray4, n, true);
    }

    public DelaunayCustom(float[][] fArray, int[][] nArray, int[][] nArray2, int[][] nArray3, int[][] nArray4, int n, boolean bl) throws VisADException {
        if (nArray == null) {
            throw new VisADException("DelaunayCustom: Tri array must be specified!");
        }
        if (fArray == null && nArray2 == null) {
            throw new VisADException("DelaunayCustom: Cannot construct Vertices without samples!");
        }
        if (fArray == null && nArray3 == null) {
            throw new VisADException("DelaunayCustom: Cannot construct Walk without samples!");
        }
        if (fArray == null && nArray4 == null) {
            throw new VisADException("DelaunayCustom: Cannot construct Edges without samples!");
        }
        if (bl) {
            this.Tri = new int[nArray.length][];
            int n2 = 0;
            while (n2 < nArray.length) {
                this.Tri[n2] = new int[nArray[n2].length];
                System.arraycopy(nArray[n2], 0, this.Tri[n2], 0, nArray[n2].length);
                ++n2;
            }
            if (nArray2 != null) {
                this.Vertices = new int[nArray2.length][];
                n2 = 0;
                while (n2 < nArray2.length) {
                    this.Vertices[n2] = new int[nArray2[n2].length];
                    System.arraycopy(nArray2[n2], 0, this.Vertices[n2], 0, nArray2[n2].length);
                    ++n2;
                }
            }
            if (nArray3 != null) {
                this.Walk = new int[nArray3.length][];
                n2 = 0;
                while (n2 < nArray3.length) {
                    this.Walk[n2] = new int[nArray3[n2].length];
                    System.arraycopy(nArray3[n2], 0, this.Walk[n2], 0, nArray3[n2].length);
                    ++n2;
                }
            }
            if (nArray4 != null) {
                this.Edges = new int[nArray4.length][];
                n2 = 0;
                while (n2 < nArray4.length) {
                    this.Edges[n2] = new int[nArray4[n2].length];
                    System.arraycopy(nArray4[n2], 0, this.Edges[n2], 0, nArray4[n2].length);
                    ++n2;
                }
            }
        } else {
            this.Tri = nArray;
            this.Vertices = nArray2;
            this.Walk = nArray3;
            this.Edges = nArray4;
        }
        this.NumEdges = n;
        if (fArray != null) {
            super.finish_triang(fArray);
        }
    }
}

