/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.Delaunay;
import visad.SetException;
import visad.VisADException;

public class DelaunayClarkson
extends Delaunay {
    private static final double DBL_MANT_DIG = 53.0;
    private static final double FLT_RADIX = 2.0;
    private static final double DBL_EPSILON = 2.220446049250313E-16;
    private static final double ln2 = Math.log(2.0);
    private static final int INFINITY = -2;
    private static final int NOVAL = -1;
    private static final int max_blocks = 10000;
    private static final int Nobj = 10000;
    private static final int MAXDIM = 8;
    private float[][] site_blocks;
    private int[][] a3s;
    private int a3size;
    private int nts = 0;
    private int dim;
    private int p;
    private long pnum;
    private int rdim;
    private int cdim;
    private int exact_bits;
    private double b_err_min;
    private double b_err_min_sq;
    private double ldetbound = 0.0;
    private int failcount = 0;
    private int lscale;
    private double max_scale;
    private float Sb;
    private int nsb = 0;
    private int nbb = 0;
    private int ss = 8;
    private int ss2 = 2000;
    private long vnum = -1L;
    private int p_neigh_vert = -1;
    private int[] voidp = new int[1];
    private int[] voidp_bn = new int[1];
    private int[][] bbt_next = new int[10000][];
    private int[][] bbt_next_bn = new int[10000][];
    private int[][] bbt_ref_count = new int[10000][];
    private int[][] bbt_lscale = new int[10000][];
    private double[][] bbt_sqa = new double[10000][];
    private double[][] bbt_sqb = new double[10000][];
    private double[][][] bbt_vecs = new double[10000][][];
    private int ttbp;
    private int ttbp_bn;
    private int ib;
    private int ib_bn;
    private int basis_s_list = -1;
    private int basis_s_list_bn;
    private int pnb = -1;
    private int pnb_bn;
    private int b = -1;
    private int b_bn;
    private int[][] sbt_next = new int[10000][];
    private int[][] sbt_next_bn = new int[10000][];
    private long[][] sbt_visit = new long[10000][];
    private short[][] sbt_mark = new short[10000][];
    private int[][] sbt_normal = new int[10000][];
    private int[][] sbt_normal_bn = new int[10000][];
    private int[][] sbt_peak_vert = new int[10000][];
    private int[][] sbt_peak_simp = new int[10000][];
    private int[][] sbt_peak_simp_bn = new int[10000][];
    private int[][] sbt_peak_basis = new int[10000][];
    private int[][] sbt_peak_basis_bn = new int[10000][];
    private int[][][] sbt_neigh_vert = new int[10000][][];
    private int[][][] sbt_neigh_simp = new int[10000][][];
    private int[][][] sbt_neigh_simp_bn = new int[10000][][];
    private int[][][] sbt_neigh_basis = new int[10000][][];
    private int[][][] sbt_neigh_basis_bn = new int[10000][][];
    private int simplex_list = -1;
    private int simplex_list_bn;
    private int ch_root;
    private int ch_root_bn;
    private int ns;
    private int ns_bn;
    private int[] st = new int[this.ss + 8 + 1];
    private int[] st_bn = new int[this.ss + 8 + 1];
    private int[] st2 = new int[this.ss2 + 8 + 1];
    private int[] st2_bn = new int[this.ss2 + 8 + 1];

    private int new_block_basis_s() {
        this.bbt_next[this.nbb] = new int[10000];
        this.bbt_next_bn[this.nbb] = new int[10000];
        this.bbt_ref_count[this.nbb] = new int[10000];
        this.bbt_lscale[this.nbb] = new int[10000];
        this.bbt_sqa[this.nbb] = new double[10000];
        this.bbt_sqb[this.nbb] = new double[10000];
        this.bbt_vecs[this.nbb] = new double[2 * this.rdim][];
        int n = 0;
        while (n < 2 * this.rdim) {
            this.bbt_vecs[this.nbb][n] = new double[10000];
            ++n;
        }
        n = 0;
        while (n < 10000) {
            this.bbt_next[this.nbb][n] = n + 1;
            this.bbt_next_bn[this.nbb][n] = this.nbb;
            this.bbt_ref_count[this.nbb][n] = 0;
            this.bbt_lscale[this.nbb][n] = 0;
            this.bbt_sqa[this.nbb][n] = 0.0;
            this.bbt_sqb[this.nbb][n] = 0.0;
            int n2 = 0;
            while (n2 < 2 * this.rdim) {
                this.bbt_vecs[this.nbb][n2][n] = 0.0;
                ++n2;
            }
            ++n;
        }
        this.bbt_next[this.nbb][9999] = -1;
        this.basis_s_list = 0;
        this.basis_s_list_bn = this.nbb++;
        return this.basis_s_list;
    }

    private int reduce_inner(int n, int n2, int n3, int n4, int n5) {
        double d = 0.0;
        this.bbt_sqa[n2][n] = 0.0;
        int n6 = 0;
        while (n6 < this.rdim) {
            double[] dArray = this.bbt_sqa[n2];
            int n7 = n;
            dArray[n7] = dArray[n7] + this.bbt_vecs[n2][n6][n] * this.bbt_vecs[n2][n6][n];
            ++n6;
        }
        this.bbt_sqb[n2][n] = this.bbt_sqa[n2][n];
        if (n5 <= 1) {
            n6 = 0;
            while (n6 < this.rdim) {
                this.bbt_vecs[n2][n6][n] = this.bbt_vecs[n2][this.rdim + n6][n];
                ++n6;
            }
            return 1;
        }
        n6 = 0;
        while (n6 < 250) {
            double d2;
            int n8;
            double d3;
            int n9;
            int n10;
            int n11 = this.rdim;
            int n12 = 0;
            while (n12 < this.rdim) {
                this.bbt_vecs[n2][n12][n] = this.bbt_vecs[n2][this.rdim + n12][n];
                ++n12;
            }
            n12 = n5 - 1;
            while (n12 > 0) {
                n10 = this.sbt_neigh_basis[n4][n12][n3];
                n9 = this.sbt_neigh_basis_bn[n4][n12][n3];
                d3 = 0.0;
                n8 = 0;
                while (n8 < this.rdim) {
                    d3 -= this.bbt_vecs[n9][n8][n10] * this.bbt_vecs[n2][n8][n];
                    ++n8;
                }
                d3 /= this.bbt_sqb[n9][n10];
                n8 = 0;
                while (n8 < this.rdim) {
                    double[] dArray = this.bbt_vecs[n2][n8];
                    int n13 = n;
                    dArray[n13] = dArray[n13] + d3 * this.bbt_vecs[n9][this.rdim + n8][n10];
                    ++n8;
                }
                --n12;
            }
            this.bbt_sqb[n2][n] = 0.0;
            n12 = 0;
            while (n12 < this.rdim) {
                double[] dArray = this.bbt_sqb[n2];
                int n14 = n;
                dArray[n14] = dArray[n14] + this.bbt_vecs[n2][n12][n] * this.bbt_vecs[n2][n12][n];
                ++n12;
            }
            this.bbt_sqa[n2][n] = 0.0;
            n12 = 0;
            while (n12 < this.rdim) {
                double[] dArray = this.bbt_sqa[n2];
                int n15 = n;
                dArray[n15] = dArray[n15] + this.bbt_vecs[n2][this.rdim + n12][n] * this.bbt_vecs[n2][this.rdim + n12][n];
                ++n12;
            }
            if (2.0 * this.bbt_sqb[n2][n] >= this.bbt_sqa[n2][n]) {
                return 1;
            }
            if (n6 < 10) {
                double d4 = Math.floor(Math.log(this.bbt_sqa[n2][n]) / ln2) / 2.0;
                this.max_scale = (double)this.exact_bits - d4 - 0.66 * (double)(n5 - 2) - 1.0;
                if (this.max_scale < 1.0) {
                    this.max_scale = 1.0;
                }
                if (n6 == 0) {
                    this.ldetbound = 0.0;
                    d = 0.0;
                    n12 = n5 - 1;
                    while (n12 > 0) {
                        n10 = this.sbt_neigh_basis[n4][n12][n3];
                        n9 = this.sbt_neigh_basis_bn[n4][n12][n3];
                        d += this.bbt_sqb[n9][n10];
                        this.ldetbound += Math.floor(Math.log(this.bbt_sqb[n9][n10]) / ln2) / 2.0 + 1.0;
                        this.ldetbound -= (double)this.bbt_lscale[n9][n10];
                        --n12;
                    }
                }
            }
            if (this.ldetbound - (double)this.bbt_lscale[n2][n] + Math.floor(Math.log(this.bbt_sqb[n2][n]) / ln2) / 2.0 + 1.0 < 0.0) {
                d2 = 0.0;
            } else {
                this.lscale = (int)(Math.log(2.0 * d / (this.bbt_sqb[n2][n] + this.bbt_sqa[n2][n] * this.b_err_min)) / ln2) / 2;
                if ((double)this.lscale > this.max_scale) {
                    this.lscale = (int)this.max_scale;
                } else if (this.lscale < 0) {
                    this.lscale = 0;
                }
                int[] nArray = this.bbt_lscale[n2];
                int n16 = n;
                nArray[n16] = nArray[n16] + this.lscale;
                d2 = this.lscale < 20 ? (double)(1 << this.lscale) : Math.pow(2.0, this.lscale);
            }
            while (n11 < 2 * this.rdim) {
                double[] dArray = this.bbt_vecs[n2][n11++];
                int n17 = n;
                dArray[n17] = dArray[n17] * d2;
            }
            n12 = n5 - 1;
            while (n12 > 0) {
                n10 = this.sbt_neigh_basis[n4][n12][n3];
                n9 = this.sbt_neigh_basis_bn[n4][n12][n3];
                d3 = 0.0;
                n8 = 0;
                while (n8 < this.rdim) {
                    d3 -= this.bbt_vecs[n9][n8][n10] * this.bbt_vecs[n2][this.rdim + n8][n];
                    ++n8;
                }
                d3 /= this.bbt_sqb[n9][n10];
                d3 = Math.floor(d3 + 0.5);
                n8 = 0;
                while (n8 < this.rdim) {
                    double[] dArray = this.bbt_vecs[n2][this.rdim + n8];
                    int n18 = n;
                    dArray[n18] = dArray[n18] + d3 * this.bbt_vecs[n9][this.rdim + n8][n10];
                    ++n8;
                }
                --n12;
            }
            ++n6;
        }
        if (this.failcount++ < 10) {
            System.out.println("reduce_inner failed!");
        }
        return 0;
    }

    private int reduce(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4) {
        if (nArray[0] == -1) {
            nArray[0] = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
            nArray2[0] = this.basis_s_list_bn;
            this.basis_s_list = this.bbt_next[nArray2[0]][nArray[0]];
            this.basis_s_list_bn = this.bbt_next_bn[nArray2[0]][nArray[0]];
            this.bbt_ref_count[nArray2[0]][nArray[0]] = 1;
        } else {
            this.bbt_lscale[nArray2[0]][nArray[0]] = 0;
        }
        if (n == -2) {
            this.bbt_next[nArray2[0]][nArray[0]] = this.bbt_next[this.ib_bn][this.ib];
            this.bbt_next_bn[nArray2[0]][nArray[0]] = this.bbt_next_bn[this.ib_bn][this.ib];
            this.bbt_ref_count[nArray2[0]][nArray[0]] = this.bbt_ref_count[this.ib_bn][this.ib];
            this.bbt_lscale[nArray2[0]][nArray[0]] = this.bbt_lscale[this.ib_bn][this.ib];
            this.bbt_sqa[nArray2[0]][nArray[0]] = this.bbt_sqa[this.ib_bn][this.ib];
            this.bbt_sqb[nArray2[0]][nArray[0]] = this.bbt_sqb[this.ib_bn][this.ib];
            int n5 = 0;
            while (n5 < 2 * this.rdim) {
                this.bbt_vecs[nArray2[0]][n5][nArray[0]] = this.bbt_vecs[this.ib_bn][n5][this.ib];
                ++n5;
            }
        } else {
            int n6;
            double d = 0.0;
            int n7 = this.sbt_neigh_vert[n3][0][n2];
            if (n7 == -2) {
                n6 = 0;
                while (n6 < this.dim) {
                    double d2 = this.site_blocks[n6][n];
                    this.bbt_vecs[nArray2[0]][n6][nArray[0]] = d2;
                    this.bbt_vecs[nArray2[0]][n6 + this.rdim][nArray[0]] = d2;
                    ++n6;
                }
            } else {
                n6 = 0;
                while (n6 < this.dim) {
                    double d3 = this.site_blocks[n6][n] - this.site_blocks[n6][n7];
                    this.bbt_vecs[nArray2[0]][n6][nArray[0]] = d3;
                    this.bbt_vecs[nArray2[0]][n6 + this.rdim][nArray[0]] = d3;
                    ++n6;
                }
            }
            n6 = 0;
            while (n6 < this.dim) {
                d += this.bbt_vecs[nArray2[0]][n6][nArray[0]] * this.bbt_vecs[nArray2[0]][n6][nArray[0]];
                ++n6;
            }
            this.bbt_vecs[nArray2[0]][2 * this.rdim - 1][nArray[0]] = d;
            this.bbt_vecs[nArray2[0]][this.rdim - 1][nArray[0]] = d;
        }
        return this.reduce_inner(nArray[0], nArray2[0], n2, n3, n4);
    }

    /*
     * Unable to fully structure code
     */
    private void get_basis_sede(int var1_1, int var2_2) {
        block9: {
            block8: {
                var3_3 = 1;
                var6_4 = new int[1];
                var7_5 = new int[1];
                if (this.sbt_neigh_vert[var2_2][0][var1_1] != -2 || this.cdim <= 1) break block8;
                var8_6 = this.sbt_neigh_vert[var2_2][0][var1_1];
                var9_7 = this.sbt_neigh_simp[var2_2][0][var1_1];
                var10_8 = this.sbt_neigh_simp_bn[var2_2][0][var1_1];
                var11_9 = this.sbt_neigh_basis[var2_2][0][var1_1];
                var12_10 = this.sbt_neigh_basis_bn[var2_2][0][var1_1];
                this.sbt_neigh_vert[var2_2][0][var1_1] = this.sbt_neigh_vert[var2_2][var3_3][var1_1];
                this.sbt_neigh_simp[var2_2][0][var1_1] = this.sbt_neigh_simp[var2_2][var3_3][var1_1];
                this.sbt_neigh_simp_bn[var2_2][0][var1_1] = this.sbt_neigh_simp_bn[var2_2][var3_3][var1_1];
                this.sbt_neigh_basis[var2_2][0][var1_1] = this.sbt_neigh_basis[var2_2][var3_3][var1_1];
                this.sbt_neigh_basis_bn[var2_2][0][var1_1] = this.sbt_neigh_basis_bn[var2_2][var3_3][var1_1];
                this.sbt_neigh_vert[var2_2][var3_3][var1_1] = var8_6;
                this.sbt_neigh_simp[var2_2][var3_3][var1_1] = var9_7;
                this.sbt_neigh_simp_bn[var2_2][var3_3][var1_1] = var10_8;
                this.sbt_neigh_basis[var2_2][var3_3][var1_1] = var11_9;
                this.sbt_neigh_basis_bn[var2_2][var3_3][var1_1] = var12_10;
                var4_11 = this.sbt_neigh_basis[var2_2][0][var1_1];
                var5_12 = this.sbt_neigh_basis_bn[var2_2][0][var1_1];
                if (var4_11 != -1) {
                    v0 = this.bbt_ref_count[var5_12];
                    v1 = var4_11;
                    v0[v1] = v0[v1] - 1;
                    if (v0[v1] == 0) {
                        this.bbt_next[var5_12][var4_11] = this.basis_s_list;
                        this.bbt_next_bn[var5_12][var4_11] = this.basis_s_list_bn;
                        this.bbt_ref_count[var5_12][var4_11] = 0;
                        this.bbt_lscale[var5_12][var4_11] = 0;
                        this.bbt_sqa[var5_12][var4_11] = 0.0;
                        this.bbt_sqb[var5_12][var4_11] = 0.0;
                        var13_13 = 0;
                        while (var13_13 < 2 * this.rdim) {
                            this.bbt_vecs[var5_12][var13_13][var4_11] = 0.0;
                            ++var13_13;
                        }
                        this.basis_s_list = var4_11;
                        this.basis_s_list_bn = var5_12;
                    }
                }
                this.sbt_neigh_basis[var2_2][0][var1_1] = this.ttbp;
                this.sbt_neigh_basis_bn[var2_2][0][var1_1] = this.ttbp_bn;
                v2 = this.bbt_ref_count[this.ttbp_bn];
                v3 = this.ttbp;
                v2[v3] = v2[v3] + 1;
                break block9;
            }
            if (this.sbt_neigh_basis[var2_2][0][var1_1] != -1) ** GOTO lbl55
            this.sbt_neigh_basis[var2_2][0][var1_1] = this.ttbp;
            this.sbt_neigh_basis_bn[var2_2][0][var1_1] = this.ttbp_bn;
            v4 = this.bbt_ref_count[this.ttbp_bn];
            v5 = this.ttbp;
            v4[v5] = v4[v5] + 1;
            break block9;
lbl-1000:
            // 1 sources

            {
                ++var3_3;
lbl55:
                // 2 sources

                ** while (var3_3 < this.cdim && this.sbt_neigh_basis[var2_2][var3_3][var1_1] != -1)
            }
        }
        while (var3_3 < this.cdim) {
            var4_11 = this.sbt_neigh_basis[var2_2][var3_3][var1_1];
            var5_12 = this.sbt_neigh_basis_bn[var2_2][var3_3][var1_1];
            if (var4_11 != -1) {
                v6 = this.bbt_ref_count[var5_12];
                v7 = var4_11;
                v6[v7] = v6[v7] - 1;
                if (v6[v7] == 0) {
                    this.bbt_next[var5_12][var4_11] = this.basis_s_list;
                    this.bbt_next_bn[var5_12][var4_11] = this.basis_s_list_bn;
                    this.bbt_ref_count[var5_12][var4_11] = 0;
                    this.bbt_lscale[var5_12][var4_11] = 0;
                    this.bbt_sqa[var5_12][var4_11] = 0.0;
                    this.bbt_sqb[var5_12][var4_11] = 0.0;
                    var8_6 = 0;
                    while (var8_6 < 2 * this.rdim) {
                        this.bbt_vecs[var5_12][var8_6][var4_11] = 0.0;
                        ++var8_6;
                    }
                    this.basis_s_list = var4_11;
                    this.basis_s_list_bn = var5_12;
                }
            }
            this.sbt_neigh_basis[var2_2][var3_3][var1_1] = -1;
            var6_4[0] = this.sbt_neigh_basis[var2_2][var3_3][var1_1];
            var7_5[0] = this.sbt_neigh_basis_bn[var2_2][var3_3][var1_1];
            this.reduce(var6_4, var7_5, this.sbt_neigh_vert[var2_2][var3_3][var1_1], var1_1, var2_2, var3_3);
            this.sbt_neigh_basis[var2_2][var3_3][var1_1] = var6_4[0];
            this.sbt_neigh_basis_bn[var2_2][var3_3][var1_1] = var7_5[0];
            ++var3_3;
        }
    }

    private int sees(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.b == -1) {
            this.b = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
            this.b_bn = this.basis_s_list_bn;
            this.basis_s_list = this.bbt_next[this.b_bn][this.b];
            this.basis_s_list_bn = this.bbt_next_bn[this.b_bn][this.b];
        } else {
            this.bbt_lscale[this.b_bn][this.b] = 0;
        }
        if (this.cdim == 0) {
            return 0;
        }
        if (this.sbt_normal[n3][n2] == -1) {
            int n9;
            this.get_basis_sede(n2, n3);
            if (this.rdim == 3 && this.cdim == 3) {
                this.sbt_normal[n3][n2] = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
                this.sbt_normal_bn[n3][n2] = this.basis_s_list_bn;
                n8 = this.sbt_normal[n3][n2];
                n7 = this.sbt_normal_bn[n3][n2];
                this.basis_s_list = this.bbt_next[n7][n8];
                this.basis_s_list_bn = this.bbt_next_bn[n7][n8];
                int n10 = this.sbt_neigh_basis[n3][1][n2];
                int n11 = this.sbt_neigh_basis_bn[n3][1][n2];
                int n12 = this.sbt_neigh_basis[n3][2][n2];
                int n13 = this.sbt_neigh_basis_bn[n3][2][n2];
                this.bbt_ref_count[n7][n8] = 1;
                this.bbt_vecs[n7][0][n8] = this.bbt_vecs[n11][1][n10] * this.bbt_vecs[n13][2][n12] - this.bbt_vecs[n11][2][n10] * this.bbt_vecs[n13][1][n12];
                this.bbt_vecs[n7][1][n8] = this.bbt_vecs[n11][2][n10] * this.bbt_vecs[n13][0][n12] - this.bbt_vecs[n11][0][n10] * this.bbt_vecs[n13][2][n12];
                this.bbt_vecs[n7][2][n8] = this.bbt_vecs[n11][0][n10] * this.bbt_vecs[n13][1][n12] - this.bbt_vecs[n11][1][n10] * this.bbt_vecs[n13][0][n12];
                this.bbt_sqb[n7][n8] = 0.0;
                n6 = 0;
                while (n6 < this.rdim) {
                    double[] dArray = this.bbt_sqb[n7];
                    int n14 = n8;
                    dArray[n14] = dArray[n14] + this.bbt_vecs[n7][n6][n8] * this.bbt_vecs[n7][n6][n8];
                    ++n6;
                }
                n6 = this.cdim + 1;
                while (n6 > 0) {
                    n9 = n6 > 1 ? this.sbt_neigh_vert[this.ch_root_bn][n6 - 2][this.ch_root] : -2;
                    n5 = 0;
                    while (n5 < this.cdim && n9 != this.sbt_neigh_vert[n3][n5][n2]) {
                        ++n5;
                    }
                    if (n5 >= this.cdim && !(n9 == -2 ? this.bbt_vecs[n7][2][n8] > -this.b_err_min : this.sees(n9, n2, n3) == 0)) {
                        this.bbt_vecs[n7][0][n8] = -this.bbt_vecs[n7][0][n8];
                        this.bbt_vecs[n7][1][n8] = -this.bbt_vecs[n7][1][n8];
                        this.bbt_vecs[n7][2][n8] = -this.bbt_vecs[n7][2][n8];
                        break;
                    }
                    --n6;
                }
            } else {
                n6 = this.cdim + 1;
                while (n6 > 0) {
                    n9 = n6 > 1 ? this.sbt_neigh_vert[this.ch_root_bn][n6 - 2][this.ch_root] : -2;
                    n5 = 0;
                    while (n5 < this.cdim && n9 != this.sbt_neigh_vert[n3][n5][n2]) {
                        ++n5;
                    }
                    if (n5 >= this.cdim) {
                        nArray[0] = this.sbt_normal[n3][n2];
                        nArray2[0] = this.sbt_normal_bn[n3][n2];
                        this.reduce(nArray, nArray2, n9, n2, n3, this.cdim);
                        int n15 = nArray[0];
                        this.sbt_normal[n3][n2] = n15;
                        n8 = n15;
                        int n16 = nArray2[0];
                        this.sbt_normal_bn[n3][n2] = n16;
                        n7 = n16;
                        if (this.bbt_sqb[n7][n8] != 0.0) break;
                    }
                    --n6;
                }
            }
            n6 = 0;
            while (n6 < this.cdim) {
                n8 = this.sbt_neigh_basis[n3][n6][n2];
                n7 = this.sbt_neigh_basis_bn[n3][n6][n2];
                if (n8 != -1) {
                    int[] nArray3 = this.bbt_ref_count[n7];
                    int n17 = n8;
                    nArray3[n17] = nArray3[n17] - 1;
                    if (nArray3[n17] == 0) {
                        this.bbt_next[n7][n8] = this.basis_s_list;
                        this.bbt_next_bn[n7][n8] = this.basis_s_list_bn;
                        this.bbt_ref_count[n7][n8] = 0;
                        this.bbt_lscale[n7][n8] = 0;
                        this.bbt_sqa[n7][n8] = 0.0;
                        this.bbt_sqb[n7][n8] = 0.0;
                        n9 = 0;
                        while (n9 < 2 * this.rdim) {
                            this.bbt_vecs[n7][n9][n8] = 0.0;
                            ++n9;
                        }
                        this.basis_s_list = n8;
                        this.basis_s_list_bn = n7;
                    }
                }
                this.sbt_neigh_basis[n3][n6][n2] = -1;
                ++n6;
            }
        }
        if (n == -2) {
            this.bbt_next[this.b_bn][this.b] = this.bbt_next[this.ib_bn][this.ib];
            this.bbt_next_bn[this.b_bn][this.b] = this.bbt_next_bn[this.ib_bn][this.ib];
            this.bbt_ref_count[this.b_bn][this.b] = this.bbt_ref_count[this.ib_bn][this.ib];
            this.bbt_lscale[this.b_bn][this.b] = this.bbt_lscale[this.ib_bn][this.ib];
            this.bbt_sqa[this.b_bn][this.b] = this.bbt_sqa[this.ib_bn][this.ib];
            this.bbt_sqb[this.b_bn][this.b] = this.bbt_sqb[this.ib_bn][this.ib];
            n6 = 0;
            while (n6 < 2 * this.rdim) {
                this.bbt_vecs[this.b_bn][n6][this.b] = this.bbt_vecs[this.ib_bn][n6][this.ib];
                ++n6;
            }
        } else {
            double d = 0.0;
            n5 = this.sbt_neigh_vert[n3][0][n2];
            if (n5 == -2) {
                n4 = 0;
                while (n4 < this.dim) {
                    double d2 = this.site_blocks[n4][n];
                    this.bbt_vecs[this.b_bn][n4][this.b] = d2;
                    this.bbt_vecs[this.b_bn][n4 + this.rdim][this.b] = d2;
                    ++n4;
                }
            } else {
                n4 = 0;
                while (n4 < this.dim) {
                    double d3 = this.site_blocks[n4][n] - this.site_blocks[n4][n5];
                    this.bbt_vecs[this.b_bn][n4][this.b] = d3;
                    this.bbt_vecs[this.b_bn][n4 + this.rdim][this.b] = d3;
                    ++n4;
                }
            }
            n4 = 0;
            while (n4 < this.dim) {
                d += this.bbt_vecs[this.b_bn][n4][this.b] * this.bbt_vecs[this.b_bn][n4][this.b];
                ++n4;
            }
            double d4 = d;
            this.bbt_vecs[this.b_bn][this.rdim - 1][this.b] = d4;
            this.bbt_vecs[this.b_bn][2 * this.rdim - 1][this.b] = d4;
        }
        n8 = this.sbt_normal[n3][n2];
        n7 = this.sbt_normal_bn[n3][n2];
        int n18 = 0;
        while (n18 < 3) {
            double d = 0.0;
            double d5 = 0.0;
            n4 = 0;
            while (n4 < this.rdim) {
                d5 += this.bbt_vecs[this.b_bn][n4][this.b] * this.bbt_vecs[n7][n4][n8];
                ++n4;
            }
            if (d5 == 0.0) {
                return 0;
            }
            n4 = 0;
            while (n4 < this.rdim) {
                d += this.bbt_vecs[this.b_bn][n4][this.b] * this.bbt_vecs[this.b_bn][n4][this.b];
                ++n4;
            }
            double d6 = d5 * d5 / this.bbt_sqb[n7][n8] / d;
            if (d6 > this.b_err_min_sq) {
                return d5 < 0.0 ? 1 : 0;
            }
            this.get_basis_sede(n2, n3);
            this.reduce_inner(this.b, this.b_bn, n2, n3, this.cdim);
            ++n18;
        }
        return 0;
    }

    private int new_block_simplex() {
        this.sbt_next[this.nsb] = new int[10000];
        this.sbt_next_bn[this.nsb] = new int[10000];
        this.sbt_visit[this.nsb] = new long[10000];
        this.sbt_mark[this.nsb] = new short[10000];
        this.sbt_normal[this.nsb] = new int[10000];
        this.sbt_normal_bn[this.nsb] = new int[10000];
        this.sbt_peak_vert[this.nsb] = new int[10000];
        this.sbt_peak_simp[this.nsb] = new int[10000];
        this.sbt_peak_simp_bn[this.nsb] = new int[10000];
        this.sbt_peak_basis[this.nsb] = new int[10000];
        this.sbt_peak_basis_bn[this.nsb] = new int[10000];
        this.sbt_neigh_vert[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_simp[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_simp_bn[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_basis[this.nsb] = new int[this.rdim][];
        this.sbt_neigh_basis_bn[this.nsb] = new int[this.rdim][];
        int n = 0;
        while (n < this.rdim) {
            this.sbt_neigh_vert[this.nsb][n] = new int[10000];
            this.sbt_neigh_simp[this.nsb][n] = new int[10000];
            this.sbt_neigh_simp_bn[this.nsb][n] = new int[10000];
            this.sbt_neigh_basis[this.nsb][n] = new int[10000];
            this.sbt_neigh_basis_bn[this.nsb][n] = new int[10000];
            ++n;
        }
        n = 0;
        while (n < 10000) {
            this.sbt_next[this.nsb][n] = n + 1;
            this.sbt_next_bn[this.nsb][n] = this.nsb;
            this.sbt_visit[this.nsb][n] = 0L;
            this.sbt_mark[this.nsb][n] = 0;
            this.sbt_normal[this.nsb][n] = -1;
            this.sbt_peak_vert[this.nsb][n] = -1;
            this.sbt_peak_simp[this.nsb][n] = -1;
            this.sbt_peak_basis[this.nsb][n] = -1;
            int n2 = 0;
            while (n2 < this.rdim) {
                this.sbt_neigh_vert[this.nsb][n2][n] = -1;
                this.sbt_neigh_simp[this.nsb][n2][n] = -1;
                this.sbt_neigh_basis[this.nsb][n2][n] = -1;
                ++n2;
            }
            ++n;
        }
        this.sbt_next[this.nsb][9999] = -1;
        this.simplex_list = 0;
        this.simplex_list_bn = this.nsb++;
        return this.simplex_list;
    }

    private void visit_triang_gen(int n, int n2, int n3, int[] nArray, int[] nArray2) {
        int n4 = 0;
        --this.vnum;
        if (n != -1) {
            this.st2[n4] = n;
            this.st2_bn[n4] = n2;
            ++n4;
        }
        while (n4 != 0) {
            int n5;
            int[] nArray3;
            if (n4 > this.ss2) {
                this.ss2 += this.ss2;
                nArray3 = new int[this.ss2 + 8 + 1];
                int[] nArray4 = new int[this.ss2 + 8 + 1];
                System.arraycopy(this.st2, 0, nArray3, 0, this.st2.length);
                System.arraycopy(this.st2_bn, 0, nArray4, 0, this.st2_bn.length);
                this.st2 = nArray3;
                this.st2_bn = nArray4;
            }
            int n6 = this.st2[--n4];
            int n7 = this.st2_bn[n4];
            if (n6 == -1 || this.sbt_visit[n7][n6] == this.vnum) continue;
            this.sbt_visit[n7][n6] = this.vnum;
            if (n3 == 1) {
                int n8;
                int n9;
                if (this.sbt_peak_vert[n7][n6] == -1) {
                    n9 = n6;
                    n8 = n7;
                } else {
                    n9 = -1;
                    n8 = -1;
                }
                if (n9 != -1) {
                    nArray[0] = n9;
                    nArray2[0] = n8;
                    return;
                }
            } else {
                nArray3 = new int[this.cdim];
                if (n6 != -1) {
                    int n10 = 0;
                    while (n10 < this.cdim) {
                        nArray3[n10] = this.sbt_neigh_vert[n7][n10][n6];
                        ++n10;
                    }
                    n10 = 0;
                    while (n10 < this.cdim) {
                        this.a3s[n10][this.nts] = nArray3[n10] == -2 ? -1 : nArray3[n10];
                        ++n10;
                    }
                    ++this.nts;
                    if (this.nts > this.a3size) {
                        this.a3size += this.a3size;
                        int[][] nArray5 = new int[this.rdim][this.a3size + 8 + 1];
                        n5 = 0;
                        while (n5 < this.rdim) {
                            System.arraycopy(this.a3s[n5], 0, nArray5[n5], 0, this.a3s[n5].length);
                            ++n5;
                        }
                        this.a3s = nArray5;
                    }
                }
            }
            int n11 = 0;
            while (n11 < this.cdim) {
                int n12 = this.sbt_neigh_simp[n7][n11][n6];
                n5 = this.sbt_neigh_simp_bn[n7][n11][n6];
                if (n12 != -1 && this.sbt_visit[n5][n12] != this.vnum) {
                    this.st2[n4] = n12;
                    this.st2_bn[n4] = n5;
                    ++n4;
                }
                ++n11;
            }
        }
        nArray[0] = -1;
    }

    private void connect(int n, int n2) {
        if (n == -1) {
            return;
        }
        int n3 = 0;
        while (this.sbt_neigh_vert[n2][n3][n] != this.p && n3 < this.cdim) {
            ++n3;
        }
        if (this.sbt_visit[n2][n] == this.pnum) {
            return;
        }
        this.sbt_visit[n2][n] = this.pnum;
        int n4 = this.sbt_peak_simp[n2][n];
        int n5 = this.sbt_peak_simp_bn[n2][n];
        int n6 = 0;
        while ((this.sbt_neigh_simp[n5][n6][n4] != n || this.sbt_neigh_simp_bn[n5][n6][n4] != n2) && n6 < this.cdim) {
            ++n6;
        }
        n3 = 0;
        while (n3 < this.cdim) {
            block10: {
                int n7;
                int n8;
                int n9;
                int n10;
                block12: {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    block11: {
                        if (this.p == this.sbt_neigh_vert[n2][n3][n]) break block10;
                        n14 = this.sbt_peak_simp[n2][n];
                        n13 = this.sbt_peak_simp_bn[n2][n];
                        n10 = this.sbt_neigh_simp[n2][n3][n];
                        n9 = this.sbt_neigh_simp_bn[n2][n3][n];
                        n8 = this.sbt_neigh_vert[n5][n6][n4];
                        if (this.sbt_peak_vert[n9][n10] != -1) break block11;
                        n7 = 0;
                        while (this.sbt_neigh_vert[n5][n7][n4] != this.sbt_neigh_vert[n2][n3][n] && n7 < this.cdim) {
                            ++n7;
                        }
                        n9 = this.sbt_neigh_simp_bn[n5][n7][n4];
                        n10 = this.sbt_neigh_simp[n5][n7][n4];
                        if (this.sbt_peak_vert[n9][n10] == -1) break block12;
                        break block10;
                    }
                    do {
                        int n15 = n8;
                        n7 = 0;
                        while ((this.sbt_neigh_simp[n9][n7][n10] != n14 || this.sbt_neigh_simp_bn[n9][n7][n10] != n13) && n7 < this.cdim) {
                            ++n7;
                        }
                        n8 = this.sbt_neigh_vert[n9][n7][n10];
                        n14 = n10;
                        n13 = n9;
                        n7 = 0;
                        while (this.sbt_neigh_vert[n13][n7][n14] != n15 && n7 < this.cdim) {
                            ++n7;
                        }
                    } while (this.sbt_peak_vert[n9 = (n12 = this.sbt_neigh_simp_bn[n9][n7][n10])][n10 = (n11 = this.sbt_neigh_simp[n9][n7][n10])] != -1);
                }
                this.sbt_neigh_simp[n2][n3][n] = n10;
                this.sbt_neigh_simp_bn[n2][n3][n] = n9;
                n7 = 0;
                while (this.sbt_neigh_vert[n9][n7][n10] != n8 && n7 < this.cdim) {
                    ++n7;
                }
                this.sbt_neigh_simp[n9][n7][n10] = n;
                this.sbt_neigh_simp_bn[n9][n7][n10] = n2;
                this.connect(n10, n9);
            }
            ++n3;
        }
    }

    private void make_facets(int n, int n2, int[] nArray, int[] nArray2) {
        if (n == -1) {
            nArray[0] = -1;
            return;
        }
        this.sbt_peak_vert[n2][n] = this.p;
        int n3 = 0;
        while (n3 < this.cdim) {
            int n4 = this.sbt_neigh_simp_bn[n2][n3][n];
            int n5 = this.sbt_neigh_simp[n2][n3][n];
            if (this.pnum != this.sbt_visit[n4][n5]) {
                this.sbt_visit[n4][n5] = this.pnum;
                if (this.sees(this.p, n5, n4) != 0) {
                    this.make_facets(n5, n4, this.voidp, this.voidp_bn);
                }
            }
            if (this.sbt_peak_vert[n4][n5] == -1) {
                int n6;
                int n7;
                this.ns = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
                this.ns_bn = this.simplex_list_bn;
                this.simplex_list = this.sbt_next[this.ns_bn][this.ns];
                this.simplex_list_bn = this.sbt_next_bn[this.ns_bn][this.ns];
                this.sbt_next[this.ns_bn][this.ns] = this.sbt_next[n2][n];
                this.sbt_next_bn[this.ns_bn][this.ns] = this.sbt_next_bn[n2][n];
                this.sbt_visit[this.ns_bn][this.ns] = this.sbt_visit[n2][n];
                this.sbt_mark[this.ns_bn][this.ns] = this.sbt_mark[n2][n];
                this.sbt_normal[this.ns_bn][this.ns] = this.sbt_normal[n2][n];
                this.sbt_normal_bn[this.ns_bn][this.ns] = this.sbt_normal_bn[n2][n];
                this.sbt_peak_vert[this.ns_bn][this.ns] = this.sbt_peak_vert[n2][n];
                this.sbt_peak_simp[this.ns_bn][this.ns] = this.sbt_peak_simp[n2][n];
                this.sbt_peak_simp_bn[this.ns_bn][this.ns] = this.sbt_peak_simp_bn[n2][n];
                this.sbt_peak_basis[this.ns_bn][this.ns] = this.sbt_peak_basis[n2][n];
                this.sbt_peak_basis_bn[this.ns_bn][this.ns] = this.sbt_peak_basis_bn[n2][n];
                int n8 = 0;
                while (n8 < this.rdim) {
                    this.sbt_neigh_vert[this.ns_bn][n8][this.ns] = this.sbt_neigh_vert[n2][n8][n];
                    this.sbt_neigh_simp[this.ns_bn][n8][this.ns] = this.sbt_neigh_simp[n2][n8][n];
                    this.sbt_neigh_simp_bn[this.ns_bn][n8][this.ns] = this.sbt_neigh_simp_bn[n2][n8][n];
                    this.sbt_neigh_basis[this.ns_bn][n8][this.ns] = this.sbt_neigh_basis[n2][n8][n];
                    this.sbt_neigh_basis_bn[this.ns_bn][n8][this.ns] = this.sbt_neigh_basis_bn[n2][n8][n];
                    ++n8;
                }
                n8 = 0;
                while (n8 < this.cdim) {
                    n7 = this.sbt_neigh_basis[n2][n8][n];
                    n6 = this.sbt_neigh_basis_bn[n2][n8][n];
                    if (n7 != -1) {
                        int[] nArray3 = this.bbt_ref_count[n6];
                        int n9 = n7;
                        nArray3[n9] = nArray3[n9] + 1;
                    }
                    ++n8;
                }
                this.sbt_visit[this.ns_bn][this.ns] = 0L;
                this.sbt_peak_vert[this.ns_bn][this.ns] = -1;
                this.sbt_normal[this.ns_bn][this.ns] = -1;
                this.sbt_peak_simp[this.ns_bn][this.ns] = n;
                this.sbt_peak_simp_bn[this.ns_bn][this.ns] = n2;
                n7 = this.sbt_neigh_basis[this.ns_bn][n3][this.ns];
                n6 = this.sbt_neigh_basis_bn[this.ns_bn][n3][this.ns];
                if (n7 != -1) {
                    int[] nArray4 = this.bbt_ref_count[n6];
                    int n10 = n7;
                    nArray4[n10] = nArray4[n10] - 1;
                    if (nArray4[n10] == 0) {
                        this.bbt_next[n6][n7] = this.basis_s_list;
                        this.bbt_next_bn[n6][n7] = this.basis_s_list_bn;
                        this.bbt_ref_count[n6][n7] = 0;
                        this.bbt_lscale[n6][n7] = 0;
                        this.bbt_sqa[n6][n7] = 0.0;
                        this.bbt_sqb[n6][n7] = 0.0;
                        int n11 = 0;
                        while (n11 < 2 * this.rdim) {
                            this.bbt_vecs[n6][n11][n7] = 0.0;
                            ++n11;
                        }
                        this.basis_s_list = n7;
                        this.basis_s_list_bn = n6;
                    }
                }
                this.sbt_neigh_basis[this.ns_bn][n3][this.ns] = -1;
                this.sbt_neigh_vert[this.ns_bn][n3][this.ns] = this.p;
                n8 = 0;
                while ((this.sbt_neigh_simp[n4][n8][n5] != n || this.sbt_neigh_simp_bn[n4][n8][n5] != n2) && n8 < this.cdim) {
                    ++n8;
                }
                int n12 = this.ns;
                this.sbt_neigh_simp[n4][n8][n5] = n12;
                this.sbt_neigh_simp[n2][n3][n] = n12;
                this.sbt_neigh_simp_bn[n2][n3][n] = this.ns_bn;
                this.sbt_neigh_simp_bn[n4][n8][n5] = this.ns_bn;
            }
            ++n3;
        }
        nArray[0] = this.ns;
        nArray2[0] = this.ns_bn;
    }

    private void extend_simplices(int n, int n2, int[] nArray, int[] nArray2) {
        int n3;
        if (this.sbt_visit[n2][n] == this.pnum) {
            if (this.sbt_peak_vert[n2][n] != -1) {
                nArray[0] = this.sbt_neigh_simp[n2][this.cdim - 1][n];
                nArray2[0] = this.sbt_neigh_simp_bn[n2][this.cdim - 1][n];
            } else {
                nArray[0] = n;
                nArray2[0] = n2;
            }
            return;
        }
        this.sbt_visit[n2][n] = this.pnum;
        this.sbt_neigh_vert[n2][this.cdim - 1][n] = this.p;
        int n4 = this.sbt_normal[n2][n];
        int n5 = this.sbt_normal_bn[n2][n];
        if (n4 != -1) {
            int[] nArray3 = this.bbt_ref_count[n5];
            int n6 = n4;
            nArray3[n6] = nArray3[n6] - 1;
            if (nArray3[n6] == 0) {
                this.bbt_next[n5][n4] = this.basis_s_list;
                this.bbt_next_bn[n5][n4] = this.basis_s_list_bn;
                this.bbt_ref_count[n5][n4] = 0;
                this.bbt_lscale[n5][n4] = 0;
                this.bbt_sqa[n5][n4] = 0.0;
                this.bbt_sqb[n5][n4] = 0.0;
                n3 = 0;
                while (n3 < 2 * this.rdim) {
                    this.bbt_vecs[n5][n3][n4] = 0.0;
                    ++n3;
                }
                this.basis_s_list = n4;
                this.basis_s_list_bn = n5;
            }
        }
        this.sbt_normal[n2][n] = -1;
        n4 = this.sbt_neigh_basis[n2][0][n];
        n5 = this.sbt_neigh_basis_bn[n2][0][n];
        if (n4 != -1) {
            int[] nArray4 = this.bbt_ref_count[n5];
            int n7 = n4;
            nArray4[n7] = nArray4[n7] - 1;
            if (nArray4[n7] == 0) {
                this.bbt_next[n5][n4] = this.basis_s_list;
                this.bbt_ref_count[n5][n4] = 0;
                this.bbt_lscale[n5][n4] = 0;
                this.bbt_sqa[n5][n4] = 0.0;
                this.bbt_sqb[n5][n4] = 0.0;
                n3 = 0;
                while (n3 < 2 * this.rdim) {
                    this.bbt_vecs[n5][n3][n4] = 0.0;
                    ++n3;
                }
                this.basis_s_list = n4;
                this.basis_s_list_bn = n5;
            }
        }
        this.sbt_neigh_basis[n2][0][n] = -1;
        if (this.sbt_peak_vert[n2][n] == -1) {
            int[] nArray5 = new int[1];
            int[] nArray6 = new int[1];
            this.extend_simplices(this.sbt_peak_simp[n2][n], this.sbt_peak_simp_bn[n2][n], nArray5, nArray6);
            this.sbt_neigh_simp[n2][this.cdim - 1][n] = nArray5[0];
            this.sbt_neigh_simp_bn[n2][this.cdim - 1][n] = nArray6[0];
            nArray[0] = n;
            nArray2[0] = n2;
            return;
        }
        int n8 = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
        int n9 = this.simplex_list_bn;
        this.simplex_list = this.sbt_next[n9][n8];
        this.simplex_list_bn = this.sbt_next_bn[n9][n8];
        this.sbt_next[n9][n8] = this.sbt_next[n2][n];
        this.sbt_next_bn[n9][n8] = this.sbt_next_bn[n2][n];
        this.sbt_visit[n9][n8] = this.sbt_visit[n2][n];
        this.sbt_mark[n9][n8] = this.sbt_mark[n2][n];
        this.sbt_normal[n9][n8] = this.sbt_normal[n2][n];
        this.sbt_normal_bn[n9][n8] = this.sbt_normal_bn[n2][n];
        this.sbt_peak_vert[n9][n8] = this.sbt_peak_vert[n2][n];
        this.sbt_peak_simp[n9][n8] = this.sbt_peak_simp[n2][n];
        this.sbt_peak_simp_bn[n9][n8] = this.sbt_peak_simp_bn[n2][n];
        this.sbt_peak_basis[n9][n8] = this.sbt_peak_basis[n2][n];
        this.sbt_peak_basis_bn[n9][n8] = this.sbt_peak_basis_bn[n2][n];
        n3 = 0;
        while (n3 < this.rdim) {
            this.sbt_neigh_vert[n9][n3][n8] = this.sbt_neigh_vert[n2][n3][n];
            this.sbt_neigh_simp[n9][n3][n8] = this.sbt_neigh_simp[n2][n3][n];
            this.sbt_neigh_simp_bn[n9][n3][n8] = this.sbt_neigh_simp_bn[n2][n3][n];
            this.sbt_neigh_basis[n9][n3][n8] = this.sbt_neigh_basis[n2][n3][n];
            this.sbt_neigh_basis_bn[n9][n3][n8] = this.sbt_neigh_basis_bn[n2][n3][n];
            ++n3;
        }
        n3 = 0;
        while (n3 < this.cdim) {
            n4 = this.sbt_neigh_basis[n2][n3][n];
            n5 = this.sbt_neigh_basis_bn[n2][n3][n];
            if (n4 != -1) {
                int[] nArray7 = this.bbt_ref_count[n5];
                int n10 = n4;
                nArray7[n10] = nArray7[n10] + 1;
            }
            ++n3;
        }
        this.sbt_neigh_simp[n2][this.cdim - 1][n] = n8;
        this.sbt_neigh_simp_bn[n2][this.cdim - 1][n] = n9;
        this.sbt_peak_vert[n9][n8] = -1;
        this.sbt_peak_simp[n9][n8] = n;
        this.sbt_peak_simp_bn[n9][n8] = n2;
        this.sbt_neigh_vert[n9][this.cdim - 1][n8] = this.sbt_peak_vert[n2][n];
        this.sbt_neigh_simp[n9][this.cdim - 1][n8] = this.sbt_peak_simp[n2][n];
        this.sbt_neigh_simp_bn[n9][this.cdim - 1][n8] = this.sbt_peak_simp_bn[n2][n];
        this.sbt_neigh_basis[n9][this.cdim - 1][n8] = this.sbt_peak_basis[n2][n];
        this.sbt_neigh_basis_bn[n9][this.cdim - 1][n8] = this.sbt_peak_basis_bn[n2][n];
        n4 = this.sbt_peak_basis[n2][n];
        n5 = this.sbt_peak_basis_bn[n2][n];
        if (n4 != -1) {
            int[] nArray8 = this.bbt_ref_count[n5];
            int n11 = n4;
            nArray8[n11] = nArray8[n11] + 1;
        }
        n3 = 0;
        while (n3 < this.cdim) {
            int[] nArray9 = new int[1];
            int[] nArray10 = new int[1];
            this.extend_simplices(this.sbt_neigh_simp[n9][n3][n8], this.sbt_neigh_simp_bn[n9][n3][n8], nArray9, nArray10);
            this.sbt_neigh_simp[n9][n3][n8] = nArray9[0];
            this.sbt_neigh_simp_bn[n9][n3][n8] = nArray10[0];
            ++n3;
        }
        nArray[0] = n8;
        nArray2[0] = n9;
    }

    private void search(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = 0;
        this.st[n3] = this.sbt_peak_simp[n2][n];
        this.st_bn[n3] = this.sbt_peak_simp_bn[n2][n];
        ++n3;
        this.sbt_visit[n2][n] = this.pnum;
        if (this.sees(this.p, n, n2) == 0) {
            int n4 = 0;
            while (n4 < this.cdim) {
                this.st[n3] = this.sbt_neigh_simp[n2][n4][n];
                this.st_bn[n3] = this.sbt_neigh_simp_bn[n2][n4][n];
                ++n3;
                ++n4;
            }
        }
        while (n3 != 0) {
            int n5;
            int n6;
            if (n3 > this.ss) {
                this.ss += this.ss;
                int[] nArray3 = new int[this.ss + 8 + 1];
                int[] nArray4 = new int[this.ss + 8 + 1];
                System.arraycopy(this.st, 0, nArray3, 0, this.st.length);
                System.arraycopy(this.st_bn, 0, nArray4, 0, this.st_bn.length);
                this.st = nArray3;
                this.st_bn = nArray4;
            }
            if (this.sbt_visit[n6 = this.st_bn[--n3]][n5 = this.st[n3]] == this.pnum) continue;
            this.sbt_visit[n6][n5] = this.pnum;
            if (this.sees(this.p, n5, n6) == 0) continue;
            if (this.sbt_peak_vert[n6][n5] == -1) {
                nArray[0] = n5;
                nArray2[0] = n6;
                return;
            }
            int n7 = 0;
            while (n7 < this.cdim) {
                this.st[n3] = this.sbt_neigh_simp[n6][n7][n5];
                this.st_bn[n3] = this.sbt_neigh_simp_bn[n6][n7][n5];
                ++n3;
                ++n7;
            }
        }
        nArray[0] = -1;
    }

    public DelaunayClarkson(float[][] fArray) throws VisADException {
        boolean bl;
        int n;
        int n2;
        int n3;
        boolean bl2 = false;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        int n4 = 0;
        this.dim = fArray.length;
        int n5 = fArray[0].length;
        int n6 = 1;
        while (n6 < this.dim) {
            n5 = Math.min(n5, fArray[n6].length);
            ++n6;
        }
        if (n5 <= this.dim) {
            throw new SetException("DelaunayClarkson: not enough samples");
        }
        if (this.dim > 8) {
            throw new SetException("DelaunayClarkson: dimension bound MAXDIM exceeded");
        }
        this.site_blocks = new float[this.dim][n5];
        n6 = 0;
        while (n6 < this.dim) {
            System.arraycopy(fArray[n6], 0, this.site_blocks[n6], 0, n5);
            ++n6;
        }
        this.exact_bits = (int)(53.0 * Math.log(2.0) / ln2);
        this.b_err_min = 1.0950316209346055E-11;
        this.b_err_min_sq = this.b_err_min * this.b_err_min;
        this.cdim = 0;
        this.rdim = this.dim + 1;
        if (this.rdim > 8) {
            throw new SetException("dimension bound MAXDIM exceeded; rdim=" + this.rdim + "; dim=" + this.dim);
        }
        this.pnb = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
        this.pnb_bn = this.basis_s_list_bn;
        this.basis_s_list = this.bbt_next[this.pnb_bn][this.pnb];
        this.basis_s_list_bn = this.bbt_next_bn[this.pnb_bn][this.pnb];
        this.bbt_next[this.pnb_bn][this.pnb] = -1;
        this.ttbp = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
        this.ttbp_bn = this.basis_s_list_bn;
        this.basis_s_list = this.bbt_next[this.ttbp_bn][this.ttbp];
        this.basis_s_list_bn = this.bbt_next_bn[this.ttbp_bn][this.ttbp];
        this.bbt_next[this.ttbp_bn][this.ttbp] = -1;
        this.bbt_ref_count[this.ttbp_bn][this.ttbp] = 1;
        this.bbt_lscale[this.ttbp_bn][this.ttbp] = -1;
        this.bbt_sqa[this.ttbp_bn][this.ttbp] = 0.0;
        this.bbt_sqb[this.ttbp_bn][this.ttbp] = 0.0;
        n6 = 0;
        while (n6 < 2 * this.rdim) {
            this.bbt_vecs[this.ttbp_bn][n6][this.ttbp] = 0.0;
            ++n6;
        }
        int n7 = -1;
        this.p = -2;
        this.ib = this.basis_s_list != -1 ? this.basis_s_list : this.new_block_basis_s();
        this.ib_bn = this.basis_s_list_bn;
        this.basis_s_list = this.bbt_next[this.ib_bn][this.ib];
        this.basis_s_list_bn = this.bbt_next_bn[this.ib_bn][this.ib];
        this.bbt_ref_count[this.ib_bn][this.ib] = 1;
        this.bbt_vecs[this.ib_bn][this.rdim - 1][this.ib] = 1.0;
        this.bbt_vecs[this.ib_bn][2 * this.rdim - 1][this.ib] = 1.0;
        this.bbt_sqb[this.ib_bn][this.ib] = 1.0;
        this.bbt_sqa[this.ib_bn][this.ib] = 1.0;
        n7 = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
        int n8 = this.simplex_list_bn;
        this.simplex_list = this.sbt_next[n8][n7];
        this.simplex_list_bn = this.sbt_next_bn[n8][n7];
        this.ch_root = n7;
        this.ch_root_bn = n8;
        int n9 = this.simplex_list != -1 ? this.simplex_list : this.new_block_simplex();
        int n10 = this.simplex_list_bn;
        this.simplex_list = this.sbt_next[n10][n9];
        this.simplex_list_bn = this.sbt_next_bn[n10][n9];
        this.sbt_next[n10][n9] = this.sbt_next[n8][n7];
        this.sbt_next_bn[n10][n9] = this.sbt_next_bn[n8][n7];
        this.sbt_visit[n10][n9] = this.sbt_visit[n8][n7];
        this.sbt_mark[n10][n9] = this.sbt_mark[n8][n7];
        this.sbt_normal[n10][n9] = this.sbt_normal[n8][n7];
        this.sbt_normal_bn[n10][n9] = this.sbt_normal_bn[n8][n7];
        this.sbt_peak_vert[n10][n9] = this.sbt_peak_vert[n8][n7];
        this.sbt_peak_simp[n10][n9] = this.sbt_peak_simp[n8][n7];
        this.sbt_peak_simp_bn[n10][n9] = this.sbt_peak_simp_bn[n8][n7];
        this.sbt_peak_basis[n10][n9] = this.sbt_peak_basis[n8][n7];
        this.sbt_peak_basis_bn[n10][n9] = this.sbt_peak_basis_bn[n8][n7];
        n6 = 0;
        while (n6 < this.rdim) {
            this.sbt_neigh_vert[n10][n6][n9] = this.sbt_neigh_vert[n8][n6][n7];
            this.sbt_neigh_simp[n10][n6][n9] = this.sbt_neigh_simp[n8][n6][n7];
            this.sbt_neigh_simp_bn[n10][n6][n9] = this.sbt_neigh_simp_bn[n8][n6][n7];
            this.sbt_neigh_basis[n10][n6][n9] = this.sbt_neigh_basis[n8][n6][n7];
            this.sbt_neigh_basis_bn[n10][n6][n9] = this.sbt_neigh_basis_bn[n8][n6][n7];
            ++n6;
        }
        n6 = 0;
        while (n6 < this.cdim) {
            n3 = this.sbt_neigh_basis[n8][n6][n7];
            n2 = this.sbt_neigh_basis_bn[n8][n6][n7];
            if (n3 != -1) {
                int[] nArray7 = this.bbt_ref_count[n2];
                int n11 = n3;
                nArray7[n11] = nArray7[n11] + 1;
            }
            ++n6;
        }
        this.sbt_peak_vert[n8][n7] = this.p;
        this.sbt_peak_simp[n8][n7] = n9;
        this.sbt_peak_simp_bn[n8][n7] = n10;
        this.sbt_peak_simp[n10][n9] = n7;
        this.sbt_peak_simp_bn[n10][n9] = n8;
        while (this.cdim < this.rdim) {
            n6 = 0;
            this.p = n4 == 0 ? 0 : ++this.p;
            n = 0;
            while (n < this.dim) {
                this.site_blocks[n][this.p] = (float)Math.floor((double)this.site_blocks[n][this.p] + 0.5);
                ++n;
            }
            this.pnum = (++n4 * this.dim - 1) / this.dim + 2;
            ++this.cdim;
            this.sbt_neigh_vert[n8][this.cdim - 1][n7] = this.sbt_peak_vert[n8][n7];
            n3 = this.sbt_neigh_basis[n8][this.cdim - 1][n7];
            n2 = this.sbt_neigh_basis_bn[n8][this.cdim - 1][n7];
            if (n3 != -1) {
                int[] nArray8 = this.bbt_ref_count[n2];
                int n12 = n3;
                nArray8[n12] = nArray8[n12] - 1;
                if (nArray8[n12] == 0) {
                    this.bbt_next[n2][n3] = this.basis_s_list;
                    this.bbt_next_bn[n2][n3] = this.basis_s_list_bn;
                    this.bbt_ref_count[n2][n3] = 0;
                    this.bbt_lscale[n2][n3] = 0;
                    this.bbt_sqa[n2][n3] = 0.0;
                    this.bbt_sqb[n2][n3] = 0.0;
                    n = 0;
                    while (n < 2 * this.rdim) {
                        this.bbt_vecs[n2][n][n3] = 0.0;
                        ++n;
                    }
                    this.basis_s_list = n3;
                    this.basis_s_list_bn = n2;
                }
            }
            this.sbt_neigh_basis[n8][this.cdim - 1][n7] = -1;
            this.get_basis_sede(n7, n8);
            if (this.sbt_neigh_vert[n8][0][n7] == -2) {
                n6 = 1;
            } else {
                nArray5[0] = this.pnb;
                nArray6[0] = this.pnb_bn;
                this.reduce(nArray5, nArray6, this.p, n7, n8, this.cdim);
                this.pnb = nArray5[0];
                this.pnb_bn = nArray6[0];
                if (this.bbt_sqa[this.pnb_bn][this.pnb] != 0.0) {
                    n6 = 1;
                } else {
                    --this.cdim;
                }
            }
            if (n6 != 0) {
                this.extend_simplices(n7, n8, this.voidp, this.voidp_bn);
                continue;
            }
            this.search(n7, n8, nArray, nArray2);
            this.make_facets(nArray[0], nArray2[0], nArray3, nArray4);
            this.connect(nArray3[0], nArray4[0]);
        }
        n6 = n4;
        while (n6 < n5) {
            ++this.p;
            ++n4;
            n = 0;
            while (n < this.dim) {
                this.site_blocks[n][this.p] = (float)Math.floor((double)this.site_blocks[n][this.p] + 0.5);
                ++n;
            }
            this.pnum = (n4 * this.dim - 1) / this.dim + 2;
            this.search(n7, n8, nArray, nArray2);
            this.make_facets(nArray[0], nArray2[0], nArray3, nArray4);
            this.connect(nArray3[0], nArray4[0]);
            ++n6;
        }
        this.a3size = this.rdim * n5;
        this.a3s = new int[this.rdim][this.a3size + 8 + 1];
        this.visit_triang_gen(n7, n8, 1, nArray, nArray2);
        this.visit_triang_gen(nArray[0], nArray2[0], 0, this.voidp, this.voidp_bn);
        this.site_blocks = null;
        this.st = null;
        this.st_bn = null;
        this.st2 = null;
        this.st2_bn = null;
        this.sbt_next = null;
        this.sbt_next_bn = null;
        this.sbt_visit = null;
        this.sbt_mark = null;
        this.sbt_normal = null;
        this.sbt_normal_bn = null;
        this.sbt_peak_vert = null;
        this.sbt_peak_simp = null;
        this.sbt_peak_simp_bn = null;
        this.sbt_peak_basis = null;
        this.sbt_peak_basis_bn = null;
        this.sbt_neigh_vert = null;
        this.sbt_neigh_simp = null;
        this.sbt_neigh_simp_bn = null;
        this.sbt_neigh_basis = null;
        this.sbt_neigh_basis_bn = null;
        this.bbt_next = null;
        this.bbt_next_bn = null;
        this.bbt_ref_count = null;
        this.bbt_lscale = null;
        this.bbt_sqa = null;
        this.bbt_sqb = null;
        this.bbt_vecs = null;
        int[] nArray9 = new int[n5];
        n = 0;
        while (n < n5) {
            nArray9[n] = 0;
            ++n;
        }
        n = 0;
        int n13 = 0;
        while (n13 < this.nts) {
            bl = true;
            int n14 = 0;
            while (n14 < this.rdim) {
                if (this.a3s[n14][n13] < 0) {
                    bl = false;
                }
                ++n14;
            }
            if (bl) {
                ++n;
                n14 = 0;
                while (n14 < this.rdim) {
                    int n15 = this.a3s[n14][n13];
                    nArray9[n15] = nArray9[n15] + 1;
                    ++n14;
                }
            }
            ++n13;
        }
        this.Vertices = new int[n5][];
        n13 = 0;
        while (n13 < n5) {
            this.Vertices[n13] = new int[nArray9[n13]];
            ++n13;
        }
        n13 = 0;
        while (n13 < n5) {
            nArray9[n13] = 0;
            ++n13;
        }
        this.Tri = new int[n][this.rdim];
        int n16 = 0;
        int n17 = 0;
        while (n17 < this.nts) {
            bl = true;
            int n18 = 0;
            while (n18 < this.rdim) {
                if (this.a3s[n18][n17] < 0) {
                    bl = false;
                }
                ++n18;
            }
            if (bl) {
                n18 = 0;
                while (n18 < this.rdim) {
                    int n19 = this.a3s[n18][n17];
                    int n20 = nArray9[n19];
                    nArray9[n19] = n20 + 1;
                    this.Vertices[this.a3s[n18][n17]][n20] = n16;
                    this.Tri[n16][n18] = this.a3s[n18][n17];
                    ++n18;
                }
                ++n16;
            }
            ++n17;
        }
        this.a3s = null;
        this.finish_triang(fArray);
    }
}

