/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.rmi.RemoteException;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ConstantMap;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DelaunayClarkson;
import visad.DelaunayCustom;
import visad.DelaunayFast;
import visad.DelaunayWatson;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded3DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.SetException;
import visad.Text;
import visad.TextType;
import visad.ThingReference;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.VisADError;
import visad.VisADException;
import visad.java3d.DisplayImplJ3D;

public abstract class Delaunay
implements Serializable {
    public int[][] Tri = null;
    public int[][] Vertices = null;
    public int[][] Walk = null;
    public int[][] Edges = null;
    public int NumEdges = 0;

    public Object clone() {
        try {
            return new DelaunayCustom(null, this.Tri, this.Vertices, this.Walk, this.Edges, this.NumEdges);
        }
        catch (VisADException visADException) {
            throw new VisADError("Delaunay.clone: " + visADException.toString());
        }
    }

    public static Delaunay factory(float[][] fArray, boolean bl) throws VisADException {
        block11: {
            int n;
            int n2 = 0;
            int n3 = 1;
            int n4 = 2;
            int n5 = fArray.length;
            if (n5 < 2) {
                throw new VisADException("Delaunay.factory: dimension must be 2 or higher");
            }
            if (n5 > 3) {
                n = n3;
            } else {
                int n6 = fArray[0].length;
                int n7 = 1;
                while (n7 < n5) {
                    n6 = Math.min(n6, fArray[n7].length);
                    ++n7;
                }
                n = n5 == 2 && !bl && n6 > 10000 ? n2 : (n6 > 3000 ? n3 : n4);
            }
            try {
                if (n == n2) {
                    DelaunayFast delaunayFast = new DelaunayFast(fArray);
                    delaunayFast.improve(fArray, 1);
                    return delaunayFast;
                }
                if (n == n3) {
                    DelaunayClarkson delaunayClarkson = new DelaunayClarkson(fArray);
                    return delaunayClarkson;
                }
                if (n == n4) {
                    DelaunayWatson delaunayWatson = new DelaunayWatson(fArray);
                    return delaunayWatson;
                }
            }
            catch (Exception exception) {
                if (n == n3) break block11;
                try {
                    DelaunayClarkson delaunayClarkson = new DelaunayClarkson(fArray);
                    return delaunayClarkson;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static float[][] scale(float[][] fArray, float f, boolean bl) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        int n3 = 1;
        while (n3 < n) {
            if (fArray[n3].length < n2) {
                n2 = fArray[n3].length;
            }
            ++n3;
        }
        float[][] fArray2 = bl ? Set.copyFloats(fArray) : fArray;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                float[] fArray3 = fArray2[n4];
                int n6 = n5++;
                fArray3[n6] = fArray3[n6] * f;
            }
            ++n4;
        }
        return fArray2;
    }

    public static float[][] perturb(float[][] fArray, float f, boolean bl) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        int n3 = 1;
        while (n3 < n) {
            if (fArray[n3].length < n2) {
                n2 = fArray[n3].length;
            }
            ++n3;
        }
        float[][] fArray2 = bl ? Set.copyFloats(fArray) : fArray;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                float[] fArray3 = fArray2[n4];
                int n6 = n5++;
                fArray3[n6] = fArray3[n6] + (float)((double)(2.0f * f) * (Math.random() - 0.5));
            }
            ++n4;
        }
        return fArray2;
    }

    public boolean test(float[][] fArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = fArray.length;
        int n6 = n5 + 1;
        int n7 = this.Tri.length;
        int n8 = fArray[0].length;
        int n9 = 1;
        while (n9 < n5) {
            n8 = Math.min(n8, fArray[n9].length);
            ++n9;
        }
        n9 = 0;
        while (n9 < n7) {
            if (this.Tri[n9].length < n6) {
                return false;
            }
            ++n9;
        }
        n9 = 0;
        while (n9 < n7) {
            n4 = 0;
            while (n4 < n6) {
                if (this.Tri[n9][n4] < 0 || this.Tri[n9][n4] >= n8) {
                    return false;
                }
                ++n4;
            }
            ++n9;
        }
        int[] nArray = new int[n8];
        n4 = 0;
        while (n4 < n8) {
            nArray[n4] = 0;
            ++n4;
        }
        n4 = 0;
        while (n4 < n7) {
            n3 = 0;
            while (n3 < n6) {
                int n10 = this.Tri[n4][n3];
                nArray[n10] = nArray[n10] + 1;
                ++n3;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n8) {
            if (nArray[n4] == 0) {
                return false;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n7) {
            n3 = n4 + 1;
            while (n3 < n7) {
                boolean[] blArray = new boolean[n6];
                n2 = 0;
                while (n2 < n6) {
                    blArray[n2] = false;
                    ++n2;
                }
                n2 = 0;
                while (n2 < n6) {
                    n = 0;
                    while (n < n6) {
                        if (this.Tri[n4][n2] == this.Tri[n3][n] && !blArray[n]) {
                            blArray[n] = true;
                        }
                        ++n;
                    }
                    ++n2;
                }
                n2 = 1;
                n = 0;
                while (n < n6) {
                    if (!blArray[n]) {
                        n2 = 0;
                    }
                    ++n;
                }
                if (n2 != 0) {
                    return false;
                }
                ++n3;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n7) {
            n3 = 0;
            while (n3 < n6) {
                if (this.Walk[n4][n3] != -1) {
                    boolean bl = false;
                    n2 = 0;
                    while (n2 < n6) {
                        if (this.Walk[this.Walk[n4][n3]][n2] == n4) {
                            bl = true;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        return false;
                    }
                    n2 = 0;
                    n = 0;
                    while (n < n6) {
                        int n11 = 0;
                        while (n11 < n6) {
                            if (this.Tri[n4][n] == this.Tri[this.Walk[n4][n3]][n11]) {
                                ++n2;
                            }
                            ++n11;
                        }
                        ++n;
                    }
                    if (n2 != n5) {
                        return false;
                    }
                }
                ++n3;
            }
            ++n4;
        }
        return true;
    }

    public void improve(float[][] fArray, int n) throws VisADException {
        int n2 = fArray.length;
        int n3 = n2 + 1;
        if (this.Tri[0].length != n3) {
            throw new SetException("Delaunay.improve: samples dimension does not match");
        }
        if (n2 > 2) {
            throw new UnimplementedException("Delaunay.improve: dimension must be 2!");
        }
        int n4 = this.Tri.length;
        int n5 = fArray[0].length;
        int n6 = 1;
        while (n6 < n2) {
            n5 = Math.min(n5, fArray[n6].length);
            ++n6;
        }
        float[] fArray2 = fArray[0];
        float[] fArray3 = fArray[1];
        boolean bl = false;
        int n7 = 0;
        while (n7 < n) {
            bl = false;
            boolean[] blArray = new boolean[this.NumEdges];
            int n8 = 0;
            while (n8 < this.NumEdges) {
                blArray[n8] = true;
                ++n8;
            }
            n8 = 0;
            while (n8 < n4) {
                int[] nArray = this.Tri[n8];
                int[] nArray2 = this.Walk[n8];
                int[] nArray3 = this.Edges[n8];
                int n9 = 0;
                while (n9 < 2) {
                    int n10 = nArray3[n9];
                    if (blArray[n10]) {
                        int n11 = nArray2[n9];
                        if (n11 >= 0) {
                            boolean bl2;
                            int[] nArray4 = this.Tri[n11];
                            int[] nArray5 = this.Walk[n11];
                            int[] nArray6 = this.Edges[n11];
                            int n12 = nArray5[0] == n8 ? 0 : (nArray5[1] == n8 ? 1 : 2);
                            int n13 = (n9 + 2) % 3;
                            int n14 = (n13 + 1) % 3;
                            int n15 = (n14 + 1) % 3;
                            int n16 = (n12 + 2) % 3;
                            float f = fArray2[nArray[n13]];
                            float f2 = fArray3[nArray[n13]];
                            float f3 = fArray2[nArray[n14]];
                            float f4 = fArray3[nArray[n14]];
                            float f5 = fArray2[nArray[n15]];
                            float f6 = fArray3[nArray[n15]];
                            float f7 = fArray2[nArray4[n16]];
                            float f8 = fArray3[nArray4[n16]];
                            float f9 = f - f3;
                            float f10 = f2 - f4;
                            float f11 = f - f5;
                            float f12 = f2 - f6;
                            float f13 = f7 - f3;
                            float f14 = f8 - f4;
                            float f15 = f7 - f5;
                            float f16 = f8 - f6;
                            float f17 = f9 * f11 + f10 * f12;
                            float f18 = f13 * f9 + f14 * f10;
                            float f19 = f11 * f15 + f12 * f16;
                            float f20 = f13 * f15 + f14 * f16;
                            boolean bl3 = f9 * f12 - f10 * f11 >= 0.0f;
                            boolean bl4 = f13 * f10 - f14 * f9 >= 0.0f;
                            boolean bl5 = f11 * f16 - f12 * f15 >= 0.0f;
                            boolean bl6 = f15 * f14 - f16 * f13 >= 0.0f;
                            boolean bl7 = bl2 = (bl3 ? 1 : 0) + (bl4 ? 1 : 0) + (bl5 ? 1 : 0) + (bl6 ? 1 : 0) < 2;
                            boolean bl8 = bl3 == bl2 ? true : (bl4 == bl2 ? false : (bl5 == bl2 ? false : (bl6 == bl2 ? true : (f17 < 0.0f && f20 < 0.0f || f18 > 0.0f && f19 > 0.0f ? true : (f18 < 0.0f && f19 < 0.0f || f17 > 0.0f && f20 > 0.0f ? false : (f17 < 0.0f ? f17 : f20) < (f18 < 0.0f ? f18 : f19))))));
                            if (bl8) {
                                int n17;
                                int n18;
                                int n19;
                                int n20;
                                int n21;
                                bl = true;
                                int n22 = nArray[n13];
                                int n23 = nArray[n14];
                                int n24 = nArray[n15];
                                int n25 = nArray4[n16];
                                int n26 = nArray2[n13];
                                int n27 = nArray2[n15];
                                int n28 = nArray3[n13];
                                int n29 = nArray3[n15];
                                if (nArray4[(n16 + 1) % 3] == nArray[n15]) {
                                    n21 = nArray5[n16];
                                    n20 = nArray5[(n16 + 2) % 3];
                                    n19 = nArray6[n16];
                                    n18 = nArray6[(n16 + 2) % 3];
                                } else {
                                    n21 = nArray5[(n16 + 2) % 3];
                                    n20 = nArray5[n16];
                                    n19 = nArray6[(n16 + 2) % 3];
                                    n18 = nArray6[n16];
                                }
                                nArray[0] = n22;
                                nArray[1] = n23;
                                nArray[2] = n25;
                                nArray4[0] = n22;
                                nArray4[1] = n25;
                                nArray4[2] = n24;
                                nArray2[0] = n26;
                                nArray2[1] = n20;
                                nArray2[2] = n11;
                                nArray5[0] = n8;
                                nArray5[1] = n21;
                                nArray5[2] = n27;
                                if (n27 >= 0) {
                                    n17 = this.Walk[n27][0] == n8 ? 0 : (this.Walk[n27][1] == n8 ? 1 : 2);
                                    this.Walk[n27][n17] = n11;
                                }
                                if (n20 >= 0) {
                                    n17 = this.Walk[n20][0] == n11 ? 0 : (this.Walk[n20][1] == n11 ? 1 : 2);
                                    this.Walk[n20][n17] = n8;
                                }
                                nArray3[0] = n28;
                                nArray3[1] = n18;
                                nArray6[1] = n19;
                                nArray6[2] = n29;
                                int[] nArray7 = this.Vertices[n22];
                                int[] nArray8 = this.Vertices[n23];
                                int[] nArray9 = this.Vertices[n24];
                                int[] nArray10 = this.Vertices[n25];
                                int n30 = nArray7.length;
                                int n31 = nArray8.length;
                                int n32 = nArray9.length;
                                int n33 = nArray10.length;
                                int[] nArray11 = new int[n30 + 1];
                                int[] nArray12 = new int[n31 - 1];
                                int[] nArray13 = new int[n32 - 1];
                                int[] nArray14 = new int[n33 + 1];
                                System.arraycopy(nArray7, 0, nArray11, 0, n30);
                                nArray11[n30] = n11;
                                int n34 = 0;
                                int n35 = 0;
                                while (n35 < n31) {
                                    if (nArray8[n35] != n11) {
                                        nArray12[n34++] = nArray8[n35];
                                    }
                                    ++n35;
                                }
                                n34 = 0;
                                n35 = 0;
                                while (n35 < n32) {
                                    if (nArray9[n35] != n8) {
                                        nArray13[n34++] = nArray9[n35];
                                    }
                                    ++n35;
                                }
                                System.arraycopy(nArray10, 0, nArray14, 0, n33);
                                nArray14[n33] = n8;
                                this.Vertices[n22] = nArray11;
                                this.Vertices[n23] = nArray12;
                                this.Vertices[n24] = nArray13;
                                this.Vertices[n25] = nArray14;
                            }
                        }
                        blArray[n10] = false;
                    }
                    ++n9;
                }
                ++n8;
            }
            if (!bl) break;
            ++n7;
        }
    }

    public void finish_triang(float[][] fArray) throws VisADException {
        block40: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9 = this.Tri[0].length - 1;
            int n10 = n9 + 1;
            int n11 = fArray.length;
            int n12 = n11 + 1;
            int n13 = this.Tri.length;
            int n14 = fArray[0].length;
            int n15 = 1;
            while (n15 < n11) {
                n14 = Math.min(n14, fArray[n15].length);
                ++n15;
            }
            if (this.Vertices == null) {
                this.Vertices = new int[n14][];
                int[] nArray = new int[n14];
                n8 = 0;
                while (n8 < n13) {
                    n7 = 0;
                    while (n7 < n10) {
                        int n16 = this.Tri[n8][n7];
                        nArray[n16] = nArray[n16] + 1;
                        ++n7;
                    }
                    ++n8;
                }
                n8 = 0;
                while (n8 < n14) {
                    this.Vertices[n8] = new int[nArray[n8]];
                    nArray[n8] = 0;
                    ++n8;
                }
                n8 = 0;
                while (n8 < n13) {
                    n7 = 0;
                    while (n7 < n10) {
                        int n17 = this.Tri[n8][n7];
                        int n18 = nArray[n17];
                        nArray[n17] = n18 + 1;
                        this.Vertices[this.Tri[n8][n7]][n18] = n8;
                        ++n7;
                    }
                    ++n8;
                }
            }
            if (this.Walk == null && n9 <= 3) {
                this.Walk = new int[n13][n10];
                int n19 = 0;
                while (n19 < n13) {
                    n8 = 0;
                    while (n8 < n10) {
                        n7 = n8;
                        n6 = (n7 + 1) % n10;
                        this.Walk[n19][n8] = -1;
                        n5 = 0;
                        block8: while (n5 < this.Vertices[this.Tri[n19][n7]].length) {
                            n4 = this.Vertices[this.Tri[n19][n7]][n5];
                            if (n4 != n19) {
                                n3 = 0;
                                while (n3 < this.Vertices[this.Tri[n19][n6]].length) {
                                    if (n9 == 2) {
                                        if (n4 == this.Vertices[this.Tri[n19][n6]][n3]) {
                                            this.Walk[n19][n8] = n4;
                                            break block8;
                                        }
                                    } else {
                                        int n20 = this.Vertices[this.Tri[n19][n6]][n3];
                                        n2 = (n6 + 1) % n10;
                                        if (n4 == n20) {
                                            n = 0;
                                            while (n < this.Vertices[this.Tri[n19][n2]].length) {
                                                if (n4 == this.Vertices[this.Tri[n19][n2]][n]) {
                                                    this.Walk[n19][n8] = n4;
                                                    break block8;
                                                }
                                                ++n;
                                            }
                                        }
                                    }
                                    ++n3;
                                }
                            }
                            ++n5;
                        }
                        ++n8;
                    }
                    ++n19;
                }
            }
            if (this.Edges != null || n9 > 3) break block40;
            int n21 = 3 * (n9 - 1);
            this.Edges = new int[n13][n21];
            n8 = 0;
            while (n8 < n13) {
                n7 = 0;
                while (n7 < n21) {
                    this.Edges[n8][n7] = -1;
                    ++n7;
                }
                ++n8;
            }
            this.NumEdges = 0;
            if (n9 == 2) {
                n8 = 0;
                while (n8 < n13) {
                    n7 = 0;
                    while (n7 < 3) {
                        if (this.Edges[n8][n7] < 0) {
                            n6 = this.Walk[n8][n7];
                            if (n6 >= 0) {
                                n5 = -1;
                                n4 = 0;
                                while (n4 < 3) {
                                    if (this.Walk[n6][n4] == n8) {
                                        n5 = n4;
                                    }
                                    ++n4;
                                }
                                if (n5 != -1) {
                                    this.Edges[n6][n5] = this.NumEdges;
                                } else {
                                    throw new SetException("Delaunay.finish_triang: error in triangulation!");
                                }
                            }
                            this.Edges[n8][n7] = this.NumEdges++;
                        }
                        ++n7;
                    }
                    ++n8;
                }
            } else {
                int[] nArray = new int[]{0, 0, 0, 1, 1, 2};
                int[] nArray2 = new int[]{1, 2, 3, 2, 3, 3};
                n6 = 0;
                while (n6 < n13) {
                    n5 = 0;
                    while (n5 < 6) {
                        if (this.Edges[n6][n5] < 0) {
                            int n22;
                            int n23;
                            n4 = this.Tri[n6][nArray[n5]];
                            n3 = this.Tri[n6][nArray2[n5]];
                            int[] nArray3 = new int[this.Vertices[n4].length];
                            n2 = 0;
                            n = 0;
                            while (n < this.Vertices[n4].length) {
                                n23 = this.Vertices[n4][n];
                                n22 = 0;
                                while (n22 < this.Vertices[n3].length) {
                                    if (n23 == this.Vertices[n3][n22]) {
                                        nArray3[n2++] = n23;
                                        break;
                                    }
                                    ++n22;
                                }
                                ++n;
                            }
                            n = 0;
                            while (n < n2) {
                                n23 = nArray3[n];
                                n22 = 0;
                                while (n22 < n21) {
                                    if (this.Tri[n23][nArray[n22]] == n4 && this.Tri[n23][nArray2[n22]] == n3 || this.Tri[n23][nArray[n22]] == n3 && this.Tri[n23][nArray2[n22]] == n4) {
                                        this.Edges[n23][n22] = this.NumEdges;
                                    }
                                    ++n22;
                                }
                                ++n;
                            }
                            this.Edges[n6][n5] = this.NumEdges++;
                        }
                        ++n5;
                    }
                    ++n6;
                }
            }
        }
    }

    public String toString() {
        return this.sampleString(null);
    }

    public String sampleString(float[][] fArray) {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer("");
        if (fArray != null) {
            stringBuffer.append("\nsamples " + fArray[0].length + "\n");
            n2 = 0;
            while (n2 < fArray[0].length) {
                stringBuffer.append("  " + n2 + " -> " + fArray[0][n2] + " " + fArray[1][n2] + " " + fArray[2][n2] + "\n");
                ++n2;
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nTri (triangles -> vertices) " + this.Tri.length + "\n");
        n2 = 0;
        while (n2 < this.Tri.length) {
            stringBuffer.append("  " + n2 + " -> ");
            n = 0;
            while (n < this.Tri[n2].length) {
                stringBuffer.append(" " + this.Tri[n2][n]);
                ++n;
            }
            stringBuffer.append("\n");
            ++n2;
        }
        stringBuffer.append("\nVertices (vertices -> triangles) " + this.Vertices.length + "\n");
        n2 = 0;
        while (n2 < this.Vertices.length) {
            stringBuffer.append("  " + n2 + " -> ");
            n = 0;
            while (n < this.Vertices[n2].length) {
                stringBuffer.append(" " + this.Vertices[n2][n]);
                ++n;
            }
            stringBuffer.append("\n");
            ++n2;
        }
        stringBuffer.append("\nWalk (triangles -> triangles) " + this.Walk.length + "\n");
        n2 = 0;
        while (n2 < this.Walk.length) {
            stringBuffer.append("  " + n2 + " -> ");
            n = 0;
            while (n < this.Walk[n2].length) {
                stringBuffer.append(" " + this.Walk[n2][n]);
                ++n;
            }
            stringBuffer.append("\n");
            ++n2;
        }
        stringBuffer.append("\nEdges (triangles -> global edges) " + this.Edges.length + "\n");
        n2 = 0;
        while (n2 < this.Edges.length) {
            stringBuffer.append("  " + n2 + " -> ");
            n = 0;
            while (n < this.Edges[n2].length) {
                stringBuffer.append(" " + this.Edges[n2][n]);
                ++n;
            }
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        if (stringArray.length < 3) {
            bl = true;
        } else {
            try {
                n2 = Integer.parseInt(stringArray[0]);
                n3 = Integer.parseInt(stringArray[1]);
                n4 = Integer.parseInt(stringArray[2]);
                if (stringArray.length > 3) {
                    n5 = Integer.parseInt(stringArray[3]);
                }
                if (n2 < 2 || n2 > 3 || n3 < 1 || n4 < 1 || n5 < 1 || n5 > 4) {
                    bl = true;
                }
                if (n2 == 3 && n4 > 2) {
                    System.out.println("Only Clarkson and Watson support 3-D triangulation.\n");
                    System.exit(2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        if (bl) {
            System.out.println("Usage:\n   java visad.Delaunay dim points type [label]\ndim    = The dimension of the triangulation\n         2 = 2-D\n         3 = 3-D\npoints = The number of points to triangulate.\ntype   = The triangulation method to use:\n         1 = Clarkson\n         2 = Watson\n         3 = Fast\n     X + 3 = Fast with X improvement passes\nlabel  = How to label the diagram:\n         1 = No labels (default)\n         2 = Vertex boxes\n         3 = Triangle numbers\n         4 = Vertex numbers\n");
            System.exit(1);
        }
        if (n4 > 3) {
            n = n4 - 3;
            n4 = 3;
        }
        float[][] fArray = null;
        fArray = n2 == 2 ? new float[2][n3] : new float[3][n3];
        float[] fArray2 = fArray[0];
        float[] fArray3 = fArray[1];
        float[] fArray4 = null;
        if (n2 == 3) {
            fArray4 = fArray[2];
        }
        Delaunay delaunay = null;
        int n6 = 0;
        while (n6 < n3) {
            fArray2[n6] = (float)(500.0 * Math.random());
            fArray3[n6] = (float)(500.0 * Math.random());
            ++n6;
        }
        if (n2 == 3) {
            n6 = 0;
            while (n6 < n3) {
                fArray4[n6] = (float)(500.0 * Math.random());
                ++n6;
            }
        }
        System.out.print("Triangulating " + n3 + " points " + "in " + n2 + "-D with ");
        long l = 0L;
        long l2 = 0L;
        if (n4 == 1) {
            System.out.println("the Clarkson algorithm.");
            l = System.currentTimeMillis();
            delaunay = new DelaunayClarkson(fArray);
            l2 = System.currentTimeMillis();
        } else if (n4 == 2) {
            System.out.println("the Watson algorithm.");
            l = System.currentTimeMillis();
            delaunay = new DelaunayWatson(fArray);
            l2 = System.currentTimeMillis();
        } else if (n4 == 3) {
            System.out.println("the Fast algorithm.");
            l = System.currentTimeMillis();
            delaunay = new DelaunayFast(fArray);
            l2 = System.currentTimeMillis();
        }
        float f = (float)(l2 - l) / 1000.0f;
        System.out.println("Triangulation took " + f + " seconds.");
        if (n > 0) {
            System.out.println("Improving samples: " + n + " pass" + (n > 1 ? "es..." : "..."));
            l = System.currentTimeMillis();
            delaunay.improve(fArray, n);
            l2 = System.currentTimeMillis();
            f = (float)(l2 - l) / 1000.0f;
            System.out.println("Improvement took " + f + " seconds.");
        }
        int n7 = n5;
        int[][] nArray = delaunay.Tri;
        int[][] nArray2 = delaunay.Edges;
        int n8 = delaunay.NumEdges;
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        if (n2 == 2) {
            float[] fArray5 = fArray2;
            float[] fArray6 = fArray3;
            JComponent jComponent = new JComponent(nArray, fArray5, fArray6, n7){
                private final /* synthetic */ int[][] val$tri;
                private final /* synthetic */ float[] val$s0;
                private final /* synthetic */ float[] val$s1;
                private final /* synthetic */ int val$label;

                public void paint(Graphics graphics) {
                    block5: {
                        int n;
                        block6: {
                            block4: {
                                n = 0;
                                while (n < this.val$tri.length) {
                                    int[] nArray = this.val$tri[n];
                                    graphics.drawLine((int)this.val$s0[nArray[0]], (int)this.val$s1[nArray[0]], (int)this.val$s0[nArray[1]], (int)this.val$s1[nArray[1]]);
                                    graphics.drawLine((int)this.val$s0[nArray[1]], (int)this.val$s1[nArray[1]], (int)this.val$s0[nArray[2]], (int)this.val$s1[nArray[2]]);
                                    graphics.drawLine((int)this.val$s0[nArray[2]], (int)this.val$s1[nArray[2]], (int)this.val$s0[nArray[0]], (int)this.val$s1[nArray[0]]);
                                    ++n;
                                }
                                if (this.val$label != 2) break block4;
                                n = 0;
                                while (n < this.val$s0.length) {
                                    graphics.drawRect((int)this.val$s0[n] - 2, (int)this.val$s1[n] - 2, 4, 4);
                                    ++n;
                                }
                                break block5;
                            }
                            if (this.val$label != 3) break block6;
                            n = 0;
                            while (n < this.val$tri.length) {
                                int n2 = this.val$tri[n][0];
                                int n3 = this.val$tri[n][1];
                                int n4 = this.val$tri[n][2];
                                int n5 = (int)((this.val$s0[n2] + this.val$s0[n3] + this.val$s0[n4]) / 3.0f);
                                int n6 = (int)((this.val$s1[n2] + this.val$s1[n3] + this.val$s1[n4]) / 3.0f);
                                graphics.drawString(String.valueOf(n), n5 - 4, n6);
                                ++n;
                            }
                            break block5;
                        }
                        if (this.val$label != 4) break block5;
                        n = 0;
                        while (n < this.val$s0.length) {
                            graphics.drawString("" + n, (int)this.val$s0[n], (int)this.val$s1[n]);
                            ++n;
                        }
                    }
                }
                {
                    this.val$tri = nArray;
                    this.val$s0 = fArray;
                    this.val$s1 = fArray2;
                    this.val$label = n;
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            };
            jFrame.getContentPane().add(jComponent);
        } else {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n9;
            Object object5;
            Object object6;
            float[][] fArray7 = fArray;
            float[] fArray8 = fArray2;
            float[] fArray9 = fArray3;
            float[] fArray10 = fArray4;
            RealType realType = new RealType("x");
            RealType realType2 = new RealType("y");
            RealType realType3 = new RealType("z");
            RealTupleType realTupleType = new RealTupleType(realType, realType2, realType3);
            int[] nArray3 = new int[]{0, 0, 0, 1, 1, 2};
            int[] nArray4 = new int[]{1, 2, 3, 2, 3, 3};
            SampledSet[] sampledSetArray = new Gridded3DSet[n8];
            int n10 = 0;
            while (n10 < n8) {
                sampledSetArray[n10] = null;
                ++n10;
            }
            n10 = 0;
            while (n10 < nArray2.length) {
                object6 = nArray[n10];
                object5 = nArray2[n10];
                n9 = 0;
                while (n9 < 6) {
                    if (sampledSetArray[object5[n9]] == null) {
                        object4 = new float[3][2];
                        object3 = object4[0];
                        object2 = object4[1];
                        object = object4[2];
                        Object object7 = object6[nArray3[n9]];
                        Object object8 = object6[nArray4[n9]];
                        object3[0] = fArray2[object7];
                        object2[0] = fArray3[object7];
                        object[0] = fArray4[object7];
                        object3[1] = fArray2[object8];
                        object2[1] = fArray3[object8];
                        object[1] = fArray4[object8];
                        sampledSetArray[object5[n9]] = new Gridded3DSet((MathType)realTupleType, (float[][])object4, 2);
                    }
                    ++n9;
                }
                ++n10;
            }
            UnionSet unionSet = new UnionSet((MathType)realTupleType, sampledSetArray);
            object6 = new DataReferenceImpl("tet");
            object6.setData(unionSet);
            object5 = new DisplayImplJ3D("image display");
            ((DisplayImpl)object5).addMap(new ScalarMap(realType, Display.XAxis));
            ((DisplayImpl)object5).addMap(new ScalarMap(realType2, Display.YAxis));
            ((DisplayImpl)object5).addMap(new ScalarMap(realType3, Display.ZAxis));
            ((DisplayImpl)object5).addMap(new ConstantMap(1.0, Display.Red));
            ((DisplayImpl)object5).addMap(new ConstantMap(1.0, Display.Green));
            ((DisplayImpl)object5).addMap(new ConstantMap(0.0, Display.Blue));
            if (n7 == 2) {
                throw new UnimplementedException("Delaunay.main: vertex boxes");
            }
            if (n7 == 3) {
                n9 = nArray.length;
                object4 = new TextType("text");
                object3 = new RealType("t");
                object2 = new RealTupleType(new RealType[]{object3});
                object = new Linear1DSet((MathType)object2, 0.0, n9 - 1, n9);
                TupleType tupleType = new TupleType(new MathType[]{realType, realType2, realType3, object4});
                FunctionType functionType = new FunctionType((MathType)object3, tupleType);
                FieldImpl fieldImpl = new FieldImpl(functionType, (Set)object);
                int n11 = 0;
                while (n11 < n9) {
                    int n12 = nArray[n11][0];
                    int n13 = nArray[n11][1];
                    int n14 = nArray[n11][2];
                    int n15 = nArray[n11][3];
                    int n16 = (int)((fArray8[n12] + fArray8[n13] + fArray8[n14] + fArray8[n15]) / 4.0f);
                    int n17 = (int)((fArray9[n12] + fArray9[n13] + fArray9[n14] + fArray9[n15]) / 4.0f);
                    int n18 = (int)((fArray10[n12] + fArray10[n13] + fArray10[n14] + fArray10[n15]) / 4.0f);
                    Data[] dataArray = new Data[]{new Real(realType, (double)n16), new Real(realType2, (double)n17), new Real(realType3, (double)n18), new Text((TextType)object4, "" + n11)};
                    Tuple tuple = new Tuple(tupleType, dataArray);
                    fieldImpl.setSample(n11, (Data)tuple);
                    ++n11;
                }
                ((DisplayImpl)object5).addMap(new ScalarMap((ScalarType)object4, Display.Text));
                DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("rtf");
                dataReferenceImpl.setData(fieldImpl);
                ((DisplayImpl)object5).addReference(dataReferenceImpl, null);
            } else if (n7 == 4) {
                n9 = fArray8.length;
                object4 = new TextType("text");
                object3 = new RealType("t");
                object2 = new RealTupleType(new RealType[]{object3});
                object = new Linear1DSet((MathType)object2, 0.0, n9 - 1, n9);
                TupleType tupleType = new TupleType(new MathType[]{realType, realType2, realType3, object4});
                FunctionType functionType = new FunctionType((MathType)object3, tupleType);
                FieldImpl fieldImpl = new FieldImpl(functionType, (Set)object);
                int n19 = 0;
                while (n19 < n9) {
                    Data[] dataArray = new Data[]{new Real(realType, (double)fArray8[n19]), new Real(realType2, (double)fArray9[n19]), new Real(realType3, (double)fArray10[n19]), new Text((TextType)object4, "" + n19)};
                    Tuple tuple = new Tuple(tupleType, dataArray);
                    fieldImpl.setSample(n19, (Data)tuple);
                    ++n19;
                }
                ((DisplayImpl)object5).addMap(new ScalarMap((ScalarType)object4, Display.Text));
                DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("rtf");
                dataReferenceImpl.setData(fieldImpl);
                ((DisplayImpl)object5).addReference(dataReferenceImpl, null);
            }
            ((DisplayImpl)object5).addReference((ThingReference)object6);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(((DisplayImpl)object5).getComponent());
            jFrame.getContentPane().add(jPanel);
        }
        ((Component)jFrame).setSize(new Dimension(510, 530));
        jFrame.setTitle("Triangulation results");
        ((Component)jFrame).setVisible(true);
    }
}

