/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import visad.CommonUnit;
import visad.Gridded1DDoubleSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public final class DateTime
extends Real {
    private static final double secondsPerDay = 86400.0;
    private static final String isoTimeFmtPattern = "yyyy-MM-dd HH:mm:ss'Z'";
    private static String formatPattern = "yyyy-MM-dd HH:mm:ss'Z'";
    private static final TimeZone defaultTimeZone;
    private static TimeZone timeZone;
    private final GregorianCalendar utcCalendar = new GregorianCalendar(defaultTimeZone);

    public static Real fromYearDaySeconds(int n, int n2, double d) throws VisADException {
        if (n2 < 1) {
            throw new VisADException("DateTime.fromYearDaySeconds: invalid day");
        }
        if (d > 86400.0 || d < 0.0) {
            throw new VisADException("DateTime.fromYearDaySeconds: invalid seconds");
        }
        return DateTime.fromYearDaySecondsTrusted(n, n2, d);
    }

    private static Real fromYearDaySecondsTrusted(int n, int n2, double d) throws VisADException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.clear();
        ((Calendar)gregorianCalendar).setTimeZone(defaultTimeZone);
        if (n == 0) {
            n = -1;
        }
        gregorianCalendar.set(0, n < 0 ? 0 : 1);
        gregorianCalendar.set(1, Math.abs(n));
        gregorianCalendar.setLenient(true);
        gregorianCalendar.set(6, n2);
        int n3 = (int)Math.round(d * 1000.0);
        int n4 = n3 / 1000;
        int n5 = n3 % 1000;
        gregorianCalendar.set(13, n4);
        gregorianCalendar.set(14, n5);
        return new Real(RealType.Time, (double)gregorianCalendar.getTime().getTime() / 1000.0, CommonUnit.secondsSinceTheEpoch);
    }

    public Real getReal() {
        return this;
    }

    public String toString() {
        return this.formattedString(!formatPattern.equals(isoTimeFmtPattern) ? formatPattern : (this.utcCalendar.get(0) == 0 ? "yyyy-MM-dd HH:mm:ss'Z' 'BCE'" : isoTimeFmtPattern), timeZone);
    }

    public String toValueString() {
        return this.toString();
    }

    public String formattedString(String string, TimeZone timeZone) {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.setTimeZone(timeZone);
        if (string != null) {
            simpleDateFormat.applyPattern(string);
        }
        return new String(simpleDateFormat.format(this.utcCalendar.getTime(), stringBuffer, new FieldPosition(0)).toString());
    }

    public String dateString() {
        String string = this.utcCalendar.get(0) == 0 ? "yyyy-MM-dd 'BCE'" : "yyyy-MM-dd";
        return this.formattedString(string, defaultTimeZone);
    }

    public String timeString() {
        return this.formattedString("HH:mm:ss'Z'", defaultTimeZone);
    }

    public static void setFormatPattern(String string) {
        formatPattern = string;
    }

    public static String getFormatPattern() {
        return formatPattern;
    }

    public static void setFormatTimeZone(TimeZone timeZone) {
        DateTime.timeZone = timeZone;
    }

    public static TimeZone getFormatTimeZone() {
        return timeZone;
    }

    public static void resetFormat() {
        formatPattern = isoTimeFmtPattern;
        timeZone = defaultTimeZone;
    }

    public static DateTime createDateTime(String string) throws VisADException {
        return DateTime.createDateTime(string, formatPattern, defaultTimeZone);
    }

    public static DateTime createDateTime(String string, String string2) throws VisADException {
        return DateTime.createDateTime(string, string2, defaultTimeZone);
    }

    public static DateTime createDateTime(String string, String string2, TimeZone timeZone) throws VisADException {
        Date date;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.setTimeZone(timeZone);
            simpleDateFormat.applyPattern(string2);
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            throw new VisADException("invalid date string: " + string);
        }
        return new DateTime(date);
    }

    public int compareTo(Object object) {
        return super.compareTo((DateTime)object);
    }

    public static Gridded1DDoubleSet makeTimeSet(DateTime[] dateTimeArray) throws VisADException {
        if (dateTimeArray == null || dateTimeArray.length < 2) {
            throw new VisADException("Must be at least 2 times to create a Gridded1DDoubleSet");
        }
        Arrays.sort(dateTimeArray);
        double[][] dArray = new double[1][dateTimeArray.length];
        int n = 0;
        while (n < dateTimeArray.length) {
            dArray[0][n] = dateTimeArray[n].getValue();
            ++n;
        }
        return new Gridded1DDoubleSet((MathType)RealType.Time, dArray, dateTimeArray.length);
    }

    public static Gridded1DDoubleSet makeTimeSet(double[] dArray) throws VisADException {
        if (dArray == null || dArray.length < 2) {
            throw new VisADException("Must be at least 2 times to create a Gridded1DDoubleSet");
        }
        Arrays.sort(dArray);
        double[][] dArray2 = new double[1][dArray.length];
        int n = 0;
        while (n < dArray.length) {
            dArray2[0][n] = dArray[n];
            ++n;
        }
        return new Gridded1DDoubleSet((MathType)RealType.Time, dArray2, dArray.length);
    }

    public static DateTime[] timeSetToArray(Gridded1DDoubleSet gridded1DDoubleSet) throws VisADException {
        RealTupleType realTupleType = ((SetType)gridded1DDoubleSet.getType()).getDomain();
        Unit unit = CommonUnit.secondsSinceTheEpoch;
        if (!realTupleType.equals(RealTupleType.Time1DTuple) && !Unit.canConvert(unit = realTupleType.getDefaultUnits()[0], CommonUnit.secondsSinceTheEpoch)) {
            throw new VisADException("Invalid MathType or Units for timeSet");
        }
        double[][] dArray = !unit.equals(CommonUnit.secondsSinceTheEpoch) ? Unit.convertTuple(gridded1DDoubleSet.getDoubles(), new Unit[]{unit}, new Unit[]{CommonUnit.secondsSinceTheEpoch}) : gridded1DDoubleSet.getDoubles();
        DateTime[] dateTimeArray = new DateTime[gridded1DDoubleSet.getLength()];
        int n = 0;
        while (n < gridded1DDoubleSet.getLength()) {
            dateTimeArray[n] = new DateTime(dArray[0][n]);
            ++n;
        }
        return dateTimeArray;
    }

    public static void main(String[] stringArray) throws VisADException {
        Real real;
        System.out.println("\nInitialized using DateTime(1959, 284, 36600.):");
        DateTime dateTime = new DateTime(1959, 284, 36600.0);
        System.out.println("\n\ttoString()        = " + dateTime + "\n\tdateString()      = " + dateTime.dateString() + "\n\ttimeString()      = " + dateTime.timeString() + "\n\tformattedString() = " + dateTime.formattedString("(EEE) dd-MMM-yy hh:mm:SS.sss z", TimeZone.getTimeZone("EST")) + "\n\t  (using pattern " + "'(EEE) dd-MMM-yy hh:mm:SS.sss z' and timezone 'EST')");
        System.out.println("\nIncrementing 5 times by 20 days each time:\n");
        int n = 0;
        while (n < 5) {
            real = new Real(RealType.Time, dateTime.getValue() + 1728000.0, CommonUnit.secondsSinceTheEpoch);
            dateTime = new DateTime(real);
            System.out.println("\t" + dateTime);
            ++n;
        }
        System.out.println("\nInitialized using Real of RealType.Time but no Unit (backward compatibility):");
        real = new Real(RealType.Time, dateTime.getValue() + 86400.0);
        dateTime = new DateTime(real);
        System.out.println("\n\t" + dateTime);
        System.out.println("\nInitialized with a BCE date DateTime(-5, 196, 24493.):");
        dateTime = new DateTime(-5, 193, 24493.0);
        System.out.println("\n\ttoString()        = " + dateTime + "\n\tdateString()      = " + dateTime.dateString() + "\n\ttimeString()      = " + dateTime.timeString());
        Date date = new Date();
        dateTime = new DateTime(date);
        System.out.println("\nInitialized with current Date(): " + dateTime);
        dateTime = new DateTime((double)date.getTime() / 1000.0);
        System.out.println("\nInitialized with current seconds since the epoch: " + dateTime + "\n");
        dateTime = DateTime.createDateTime(dateTime.toString());
        System.out.println("\nUsing createDateTime with string of current Date(): " + dateTime);
    }

    public DateTime(Real real) throws VisADException {
        super(RealType.Time, real.getValue(CommonUnit.secondsSinceTheEpoch), CommonUnit.secondsSinceTheEpoch);
        this.utcCalendar.setTime(new Date(Math.round(this.getValue() * 1000.0)));
    }

    public DateTime(double d) throws VisADException {
        this(new Real(RealType.Time, d, CommonUnit.secondsSinceTheEpoch));
    }

    public DateTime(Date date) throws VisADException {
        this(new Real(RealType.Time, (double)date.getTime() / 1000.0, CommonUnit.secondsSinceTheEpoch));
    }

    public DateTime() throws VisADException {
        this(new Real(RealType.Time, (double)System.currentTimeMillis() / 1000.0, CommonUnit.secondsSinceTheEpoch));
    }

    public DateTime(int n, int n2, double d) throws VisADException {
        this(DateTime.fromYearDaySeconds(n, n2, d));
    }

    static {
        timeZone = defaultTimeZone = TimeZone.getTimeZone("GMT");
    }
}

