/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.AVControl;
import visad.AnimationControl;
import visad.CommonUnit;
import visad.Control;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataImpl;
import visad.DataReference;
import visad.DataShadow;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.DisplayTupleType;
import visad.Field;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.RemoteData;
import visad.RemoteDataReference;
import visad.ScalarMap;
import visad.ScalarType;
import visad.SetType;
import visad.ShadowFunctionType;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.TextType;
import visad.ToggleControl;
import visad.TupleType;
import visad.Unit;
import visad.ValueControl;
import visad.VisADException;
import visad.VisADRay;
import visad.collab.CollabUtil;

public abstract class DataRenderer {
    private static final int OFFSET_COUNT_INIT = 30;
    private static final String notRealFunction = "FunctionType must be Real";
    private static final String notSimpleField = "not simple field";
    private static final String notSimpleTuple = "not simple tuple";
    private static final String multipleMapping = "RealType with multiple mappings";
    private static final String multipleSpatialMapping = "RealType with multiple spatial mappings";
    private static final String nonSpatial = "no spatial mapping";
    private static final String viaReference = "spatial mapping through Reference";
    private static final String domainDimension = "domain dimension must be 1";
    private static final String domainNotSpatial = "domain must be mapped to spatial";
    private static final String rangeType = "range must be RealType or RealTupleType";
    private static final String rangeNotSpatial = "range must be mapped to spatial";
    private static final String domainSet = "domain Set must be Gridded1DSet";
    private static final String tooFewSpatial = "Function without spatial domain";
    private static final String functionTooFew = "Function directManifoldDimension < 2";
    private static final String badCoordSysManifoldDim = "bad directManifoldDimension with spatial CoordinateSystem";
    private static final String lostConnection = "lost connection to Data server";
    private static final int HALF_GUESSES = 200;
    private static final int GUESSES = 401;
    private static final float RAY_POS_INC = 0.1f;
    private static final int TRYS = 10;
    private static final double EPS = (double)0.001f;
    private DisplayImpl display = null;
    private DisplayRenderer displayRenderer;
    private transient DataDisplayLink[] Links = null;
    private boolean[] feasible;
    private boolean[] is_null;
    private boolean[] changed;
    private boolean any_changed;
    private boolean all_feasible;
    private boolean any_transform_control;
    private Vector exceptionVector = new Vector();
    private boolean suppress_exceptions = false;
    private boolean enabled = true;
    boolean lat_lon_in = false;
    boolean lat_lon_in_by_coord = false;
    boolean lat_lon_out = false;
    boolean lat_lon_out_by_coord = false;
    int lat_lon_dimension = -1;
    ShadowRealTupleType shadow_data_out = null;
    RealTupleType data_out = null;
    Unit[] data_units_out = null;
    ShadowRealTupleType shadow_data_in = null;
    RealTupleType data_in = null;
    Unit[] data_units_in = null;
    CoordinateSystem[] data_coord_in = null;
    ScalarMap[] sdo_maps = null;
    ScalarMap[] sdi_maps = null;
    int[] sdo_spatial_index = null;
    int[] sdi_spatial_index = null;
    int lat_index = -1;
    int lon_index = -1;
    int other_index = -1;
    boolean other_meters = false;
    RealVectorType[] rvts = new RealVectorType[]{null, null};
    CoordinateSystem display_coordinate_system = null;
    DisplayTupleType spatial_tuple = null;
    int[] spatial_value_indices = new int[]{-1, -1, -1};
    float[] default_spatial_in = new float[]{0.0f, 0.0f, 0.0f};
    boolean lat_lon_spatial = false;
    ScalarMap lat_map = null;
    ScalarMap lon_map = null;
    int lat_spatial_index = -1;
    int lon_spatial_index = -1;
    double[] ranges = null;
    private float[][] spatialValues = null;
    private int lastIndex = -1;
    double[] lastD = null;
    float[] lastX = new float[6];
    private int closeIndex = -1;
    private float offsetx = 0.0f;
    private float offsety = 0.0f;
    private float offsetz = 0.0f;
    private int offset_count = 0;
    private transient DataDisplayLink link = null;
    private transient DataReference ref = null;
    private transient MathType type = null;
    private transient ShadowType shadow = null;
    private float point_x;
    private float point_y;
    private float point_z;
    private float line_x;
    private float line_y;
    private float line_z;
    private float[] f = new float[1];
    private float[] d = new float[1];
    private float[][] value = new float[1][1];
    private String whyNotDirect = null;
    private int[] axisToComponent = new int[]{-1, -1, -1};
    private ScalarMap[] directMap = new ScalarMap[]{null, null, null};
    private int domainAxis = -1;
    private int directManifoldDimension = 0;
    DisplayTupleType tuple;
    private boolean stop = false;
    private int LastMouseModifiers = 0;
    private boolean isDirectManipulation;
    private float ray_pos;
    private static /* synthetic */ Class class$Lvisad$AVControl;

    public void clearExceptions() {
        this.exceptionVector.removeAllElements();
    }

    public void suppressExceptions(boolean bl) {
        this.suppress_exceptions = bl;
    }

    public void addException(Exception exception) {
        this.exceptionVector.addElement(exception);
    }

    public Vector getExceptionVector() {
        return this.suppress_exceptions ? new Vector() : (Vector)this.exceptionVector.clone();
    }

    public boolean get_all_feasible() {
        return this.all_feasible;
    }

    public boolean get_any_changed() {
        return this.any_changed;
    }

    public boolean get_any_transform_control() {
        return this.any_transform_control;
    }

    public void set_all_feasible(boolean bl) {
        this.all_feasible = bl;
    }

    public abstract void setLinks(DataDisplayLink[] var1, DisplayImpl var2) throws VisADException;

    public void toggle(boolean bl) {
        this.enabled = bl;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public synchronized void setLinks(DataDisplayLink[] dataDisplayLinkArray) {
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length == 0) {
            return;
        }
        this.Links = dataDisplayLinkArray;
        this.feasible = new boolean[this.Links.length];
        this.is_null = new boolean[this.Links.length];
        this.changed = new boolean[this.Links.length];
        int n = 0;
        while (n < this.Links.length) {
            this.feasible[n] = false;
            this.is_null[n] = true;
            ++n;
        }
    }

    public DataDisplayLink[] getLinks() {
        return this.Links;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public void setDisplay(DisplayImpl displayImpl) {
        this.display = displayImpl;
    }

    public DisplayRenderer getDisplayRenderer() {
        return this.displayRenderer;
    }

    public void setDisplayRenderer(DisplayRenderer displayRenderer) {
        this.displayRenderer = displayRenderer;
    }

    public boolean checkAction() {
        int n = 0;
        while (n < this.Links.length) {
            if (this.Links[n].checkTicks() || !this.feasible[n]) {
                return true;
            }
            Enumeration enumeration = this.Links[n].getSelectedMapVector().elements();
            while (enumeration.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                if (!scalarMap.checkTicks(this, this.Links[n])) continue;
                return true;
            }
            ++n;
        }
        return false;
    }

    public DataShadow prepareAction(boolean bl, boolean bl2, DataShadow dataShadow) throws VisADException, RemoteException {
        this.any_changed = false;
        this.all_feasible = true;
        this.any_transform_control = false;
        int n = 0;
        while (n < this.Links.length) {
            block12: {
                Object object;
                Object object2;
                this.changed[n] = false;
                DataReference dataReference = this.Links[n].getDataReference();
                if (this.Links[n].checkTicks() || !this.feasible[n] || bl) {
                    this.changed[n] = true;
                    this.any_changed = true;
                    try {
                        this.feasible[n] = this.Links[n].prepareData();
                        this.is_null[n] = this.Links[n].getData() == null;
                    }
                    catch (RemoteException remoteException) {
                        if (CollabUtil.isDisconnectException(remoteException)) {
                            this.getDisplay().connectionFailed(this, this.Links[n]);
                            this.removeLink(this.Links[n]);
                            --n;
                            break block12;
                        }
                        throw remoteException;
                    }
                    if (!this.feasible[n]) {
                        this.all_feasible = false;
                        this.clearBranch();
                    }
                    if (bl2 && this.feasible[n]) {
                        object2 = this.Links[n].getShadow().getAdaptedShadowType();
                        try {
                            object = this.Links[n].getData();
                        }
                        catch (RemoteException remoteException) {
                            if (CollabUtil.isDisconnectException(remoteException)) {
                                this.getDisplay().connectionFailed(this, this.Links[n]);
                                this.removeLink(this.Links[n]);
                                --n;
                                break block12;
                            }
                            throw remoteException;
                        }
                        dataShadow = this.computeRanges((Data)object, (ShadowType)object2, dataShadow);
                    }
                }
                if (this.feasible[n]) {
                    object2 = this.Links[n].getSelectedMapVector().elements();
                    while (object2.hasMoreElements()) {
                        object = (ScalarMap)object2.nextElement();
                        if (!((ScalarMap)object).checkTicks(this, this.Links[n])) continue;
                        this.any_transform_control = true;
                    }
                }
            }
            ++n;
        }
        return dataShadow;
    }

    public DataShadow computeRanges(Data data, ShadowType shadowType, DataShadow dataShadow) throws VisADException, RemoteException {
        dataShadow = dataShadow == null ? data.computeRanges(shadowType, this.display.getScalarCount()) : data.computeRanges(shadowType, dataShadow);
        return dataShadow;
    }

    public abstract void clearBranch();

    public abstract boolean doAction() throws VisADException, RemoteException;

    public boolean getBadScale(boolean bl) {
        boolean bl2 = false;
        int n = 0;
        while (n < this.Links.length) {
            if (!(this.feasible[n] || !bl && this.is_null[n])) {
                return true;
            }
            Enumeration enumeration = this.Links[n].getSelectedMapVector().elements();
            while (enumeration.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                bl2 |= scalarMap.badRange();
            }
            ++n;
        }
        return bl2;
    }

    public abstract void clearScene();

    public void clearAVControls() {
        Enumeration enumeration = this.display.getControls(class$Lvisad$AVControl != null ? class$Lvisad$AVControl : (class$Lvisad$AVControl = DataRenderer.class$("visad.AVControl"))).elements();
        while (enumeration.hasMoreElements()) {
            ((AVControl)enumeration.nextElement()).clearSwitches(this);
        }
        ProjectionControl projectionControl = this.display.getProjectionControl();
        projectionControl.clearSwitches(this);
        this.lat_index = -1;
        this.lon_index = -1;
    }

    public abstract ShadowType makeShadowFunctionType(FunctionType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowRealTupleType(RealTupleType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowRealType(RealType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowSetType(SetType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowTextType(TextType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public abstract ShadowType makeShadowTupleType(TupleType var1, DataDisplayLink var2, ShadowType var3) throws VisADException, RemoteException;

    public boolean isTransformControl(Control control, DataDisplayLink dataDisplayLink) {
        if (control instanceof ProjectionControl || control instanceof ToggleControl) {
            return false;
        }
        return !(control instanceof AnimationControl) && !(control instanceof ValueControl);
    }

    public DataDisplayLink getLink() {
        return null;
    }

    public boolean isLegalTextureMap() {
        return true;
    }

    public RealVectorType getRealVectorTypes(int n) {
        if (n == 0 || n == 1) {
            return this.rvts[n];
        }
        return null;
    }

    public int[] getLatLonIndices() {
        return new int[]{this.lat_index, this.lon_index};
    }

    public void setLatLonIndices(int[] nArray) {
        this.lat_index = nArray[0];
        this.lon_index = nArray[1];
    }

    public int getEarthDimension() {
        return this.lat_lon_dimension;
    }

    public Unit[] getEarthUnits() {
        Object object = null;
        object = this.lat_lon_in ? this.data_units_in : (this.lat_lon_out ? this.data_units_out : (this.lat_lon_spatial ? new Unit[]{RealType.Latitude.getDefaultUnit(), RealType.Longitude.getDefaultUnit()} : null));
        int n = this.lat_index;
        int n2 = this.lon_index;
        int n3 = this.other_index;
        if (object == null) {
            return null;
        }
        if (((Unit[])object).length == 2) {
            return new Unit[]{n >= 0 ? object[n] : null, n2 >= 0 ? object[n2] : null};
        }
        if (((Unit[])object).length == 3) {
            return new Unit[]{n >= 0 ? object[n] : null, n2 >= 0 ? object[n2] : null, n3 >= 0 ? object[n3] : null};
        }
        return null;
    }

    public float getLatLonRange() {
        double[] dArray = null;
        double[] dArray2 = null;
        int n = this.lat_index;
        int n2 = this.lon_index;
        if (this.lat_lon_out && !this.lat_lon_out_by_coord || this.lat_lon_in && this.lat_lon_in_by_coord) {
            double[] dArray3;
            double[] dArray4;
            if (n >= 0) {
                dArray4 = this.sdo_maps[n].getRange();
            } else {
                double[] dArray5 = new double[2];
                dArray5[0] = Double.NaN;
                dArray4 = dArray5;
                dArray5[1] = Double.NaN;
            }
            dArray = dArray4;
            if (n2 >= 0) {
                dArray3 = this.sdo_maps[n2].getRange();
            } else {
                double[] dArray6 = new double[2];
                dArray6[0] = Double.NaN;
                dArray3 = dArray6;
                dArray6[1] = Double.NaN;
            }
            dArray2 = dArray3;
        } else if (this.lat_lon_in && !this.lat_lon_in_by_coord || this.lat_lon_out && this.lat_lon_out_by_coord) {
            double[] dArray7;
            double[] dArray8;
            if (n >= 0) {
                dArray8 = this.sdi_maps[n].getRange();
            } else {
                double[] dArray9 = new double[2];
                dArray9[0] = Double.NaN;
                dArray8 = dArray9;
                dArray9[1] = Double.NaN;
            }
            dArray = dArray8;
            if (n2 >= 0) {
                dArray7 = this.sdi_maps[n2].getRange();
            } else {
                double[] dArray10 = new double[2];
                dArray10[0] = Double.NaN;
                dArray7 = dArray10;
                dArray10[1] = Double.NaN;
            }
            dArray2 = dArray7;
        } else if (this.lat_lon_spatial) {
            dArray = this.lat_map.getRange();
            dArray2 = this.lon_map.getRange();
        } else {
            return 1.0f;
        }
        double d = Math.abs(dArray[1] - dArray[0]);
        double d2 = Math.abs(dArray2[1] - dArray2[0]);
        if (d != d) {
            d = 1.0;
        }
        if (d2 != d2) {
            d2 = 1.0;
        }
        return d > d2 ? (float)d : (float)d2;
    }

    public float[][] earthToSpatial(float[][] fArray, float[] fArray2) throws VisADException {
        return this.earthToSpatial(fArray, fArray2, null);
    }

    public float[][] earthToSpatial(float[][] fArray, float[] fArray2, float[][] fArray3) throws VisADException {
        int n;
        int n2;
        int n3;
        int n4;
        float[][] fArray4;
        int n5 = this.lat_index;
        int n6 = this.lon_index;
        int n7 = this.other_index;
        if (this.lat_index < 0 || this.lon_index < 0) {
            return null;
        }
        int n8 = fArray[0].length;
        if (fArray.length < this.lat_lon_dimension) {
            fArray4 = fArray;
            fArray = new float[this.lat_lon_dimension][];
            int n9 = 0;
            while (n9 < fArray.length) {
                fArray[n9] = fArray4[n9];
                ++n9;
            }
            float[] fArray5 = new float[n8];
            n4 = 0;
            while (n4 < n8) {
                fArray5[n4] = 0.0f;
                ++n4;
            }
            n4 = fArray.length;
            while (n4 < this.lat_lon_dimension) {
                fArray[n4] = fArray5;
                ++n4;
            }
        } else if (fArray.length > this.lat_lon_dimension) {
            fArray4 = fArray;
            fArray = new float[this.lat_lon_dimension][];
            int n10 = 0;
            while (n10 < this.lat_lon_dimension) {
                fArray[n10] = fArray4[n10];
                ++n10;
            }
        }
        fArray4 = new float[this.lat_lon_dimension][];
        float[][] fArray6 = new float[3][];
        fArray4[n5] = fArray[0];
        fArray4[n6] = fArray[1];
        if (this.lat_lon_dimension == 3) {
            fArray4[n7] = fArray[2];
        }
        n4 = -1;
        if (this.lat_lon_in) {
            if (this.lat_lon_in_by_coord) {
                if (this.data_coord_in.length == 1) {
                    fArray4 = CoordinateSystem.transformCoordinates(this.data_out, null, this.data_units_out, null, this.data_in, this.data_coord_in[0], this.data_units_in, null, fArray4);
                } else {
                    float[][] fArray7 = new float[this.lat_lon_dimension][1];
                    n3 = 0;
                    while (n3 < n8) {
                        n2 = 0;
                        while (n2 < this.lat_lon_dimension) {
                            fArray7[n2][0] = fArray4[n2][n3];
                            ++n2;
                        }
                        fArray7 = CoordinateSystem.transformCoordinates(this.data_out, null, this.data_units_out, null, this.data_in, this.data_coord_in[n3], this.data_units_in, null, fArray7);
                        n2 = 0;
                        while (n2 < this.lat_lon_dimension) {
                            fArray4[n2][n3] = fArray7[n2][0];
                            ++n2;
                        }
                        ++n3;
                    }
                }
                n = 0;
                while (n < this.lat_lon_dimension) {
                    fArray6[this.sdo_spatial_index[n]] = this.sdo_maps[n].scaleValues(fArray4[n]);
                    ++n;
                }
                if (this.lat_lon_dimension == 2) {
                    n4 = 3 - (this.sdo_spatial_index[0] + this.sdo_spatial_index[1]);
                }
            } else {
                n = 0;
                while (n < this.lat_lon_dimension) {
                    fArray6[this.sdi_spatial_index[n]] = this.sdi_maps[n].scaleValues(fArray4[n]);
                    ++n;
                }
                if (this.lat_lon_dimension == 2) {
                    n4 = 3 - (this.sdi_spatial_index[0] + this.sdi_spatial_index[1]);
                }
            }
        } else if (this.lat_lon_out) {
            if (this.lat_lon_out_by_coord) {
                if (this.data_coord_in.length == 1) {
                    fArray4 = CoordinateSystem.transformCoordinates(this.data_in, this.data_coord_in[0], this.data_units_in, null, this.data_out, null, this.data_units_out, null, fArray4);
                } else {
                    float[][] fArray8 = new float[this.lat_lon_dimension][1];
                    n3 = 0;
                    while (n3 < n8) {
                        n2 = 0;
                        while (n2 < this.lat_lon_dimension) {
                            fArray8[n2][0] = fArray4[n2][n3];
                            ++n2;
                        }
                        fArray8 = CoordinateSystem.transformCoordinates(this.data_in, this.data_coord_in[n3], this.data_units_in, null, this.data_out, null, this.data_units_out, null, fArray8);
                        n2 = 0;
                        while (n2 < this.lat_lon_dimension) {
                            fArray4[n2][n3] = fArray8[n2][0];
                            ++n2;
                        }
                        ++n3;
                    }
                }
                n = 0;
                while (n < this.lat_lon_dimension) {
                    fArray6[this.sdi_spatial_index[n]] = this.sdi_maps[n].scaleValues(fArray4[n]);
                    ++n;
                }
                if (this.lat_lon_dimension == 2) {
                    n4 = 3 - (this.sdi_spatial_index[0] + this.sdi_spatial_index[1]);
                }
            } else {
                n = 0;
                while (n < this.lat_lon_dimension) {
                    fArray6[this.sdo_spatial_index[n]] = this.sdo_maps[n].scaleValues(fArray4[n]);
                    ++n;
                }
                if (this.lat_lon_dimension == 2) {
                    n4 = 3 - (this.sdo_spatial_index[0] + this.sdo_spatial_index[1]);
                }
            }
        } else if (this.lat_lon_spatial) {
            fArray6[this.lat_spatial_index] = this.lat_map.scaleValues(fArray4[n5]);
            fArray6[this.lon_spatial_index] = this.lon_map.scaleValues(fArray4[n6]);
            n4 = 3 - (this.lat_spatial_index + this.lon_spatial_index);
        } else {
            return null;
        }
        n = 0;
        while (n < 3) {
            if (fArray6[n] == null) {
                if (fArray3 != null && fArray3[n] != null) {
                    fArray6[n] = fArray3[n];
                } else {
                    fArray6[n] = new float[n8];
                    float f = this.default_spatial_in[n];
                    n2 = 0;
                    while (n2 < n8) {
                        fArray6[n][n2] = f;
                        ++n2;
                    }
                }
            }
            ++n;
        }
        if (fArray2 != null && n4 > -1 && fArray6[n4] != null) {
            n = 0;
            while (n < n8) {
                float[] fArray9 = fArray6[n4];
                int n11 = n;
                fArray9[n11] = fArray9[n11] + fArray2[n];
                ++n;
            }
        }
        if (this.display_coordinate_system != null && fArray6 != null && fArray6.length > 0 && fArray6[0] != null && fArray6[0].length > 0) {
            fArray6 = this.display_coordinate_system.toReference(fArray6);
        }
        return fArray6;
    }

    public float[][] spatialToEarth(float[][] fArray) throws VisADException {
        float[][] fArray2 = new float[3][];
        return this.spatialToEarth(fArray, fArray2);
    }

    public float[][] spatialToEarth(float[][] fArray, float[][] fArray2) throws VisADException {
        int n;
        int n2 = this.lat_index;
        int n3 = this.lon_index;
        int n4 = this.other_index;
        if (this.lat_index < 0 || this.lon_index < 0) {
            return null;
        }
        if (fArray.length != 3) {
            return null;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < 3) {
            if (fArray[n6] != null && fArray[n6].length > n5) {
                n5 = fArray[n6].length;
            }
            ++n6;
        }
        if (n5 == 0) {
            return null;
        }
        n6 = 0;
        while (n6 < 3) {
            if (fArray[n6] == null) {
                fArray[n6] = new float[n5];
                n = 0;
                while (n < n5) {
                    fArray[n6][n] = 0.0f;
                    ++n;
                }
            }
            ++n6;
        }
        if (this.display_coordinate_system != null) {
            fArray = this.display_coordinate_system.fromReference(fArray);
        }
        fArray2[0] = fArray[0];
        fArray2[1] = fArray[1];
        fArray2[2] = fArray[2];
        float[][] fArray3 = new float[this.lat_lon_dimension][];
        if (this.lat_lon_in) {
            if (this.lat_lon_in_by_coord) {
                n = 0;
                while (n < this.lat_lon_dimension) {
                    fArray3[n] = this.sdo_maps[n].inverseScaleValues(fArray[this.sdo_spatial_index[n]]);
                    ++n;
                }
                if (this.data_coord_in.length == 1) {
                    fArray3 = CoordinateSystem.transformCoordinates(this.data_in, this.data_coord_in[0], this.data_units_in, null, this.data_out, null, this.data_units_out, null, fArray3);
                } else {
                    float[][] fArray4 = new float[this.lat_lon_dimension][1];
                    int n7 = 0;
                    while (n7 < n5) {
                        int n8 = 0;
                        while (n8 < this.lat_lon_dimension) {
                            fArray4[n8][0] = fArray3[n8][n7];
                            ++n8;
                        }
                        fArray4 = CoordinateSystem.transformCoordinates(this.data_in, this.data_coord_in[n7], this.data_units_in, null, this.data_out, null, this.data_units_out, null, fArray4);
                        n8 = 0;
                        while (n8 < this.lat_lon_dimension) {
                            fArray3[n8][n7] = fArray4[n8][0];
                            ++n8;
                        }
                        ++n7;
                    }
                }
            } else {
                n = 0;
                while (n < this.lat_lon_dimension) {
                    fArray3[n] = this.sdi_maps[n].inverseScaleValues(fArray[this.sdi_spatial_index[n]]);
                    ++n;
                }
            }
        } else if (this.lat_lon_out) {
            if (this.lat_lon_out_by_coord) {
                n = 0;
                while (n < this.lat_lon_dimension) {
                    fArray3[n] = this.sdi_maps[n].inverseScaleValues(fArray[this.sdi_spatial_index[n]]);
                    ++n;
                }
                if (this.data_coord_in.length == 1) {
                    fArray3 = CoordinateSystem.transformCoordinates(this.data_out, null, this.data_units_out, null, this.data_in, this.data_coord_in[0], this.data_units_in, null, fArray3);
                } else {
                    float[][] fArray5 = new float[this.lat_lon_dimension][1];
                    int n9 = 0;
                    while (n9 < n5) {
                        int n10 = 0;
                        while (n10 < this.lat_lon_dimension) {
                            fArray5[n10][0] = fArray3[n10][n9];
                            ++n10;
                        }
                        fArray5 = CoordinateSystem.transformCoordinates(this.data_out, null, this.data_units_out, null, this.data_in, this.data_coord_in[n9], this.data_units_in, null, fArray5);
                        n10 = 0;
                        while (n10 < this.lat_lon_dimension) {
                            fArray3[n10][n9] = fArray5[n10][0];
                            ++n10;
                        }
                        ++n9;
                    }
                }
            } else {
                n = 0;
                while (n < this.lat_lon_dimension) {
                    fArray3[n] = this.sdo_maps[n].inverseScaleValues(fArray[this.sdo_spatial_index[n]]);
                    ++n;
                }
            }
        } else if (this.lat_lon_spatial) {
            fArray3[n2] = this.lat_map.inverseScaleValues(fArray[this.lat_spatial_index]);
            fArray3[n3] = this.lon_map.inverseScaleValues(fArray[this.lon_spatial_index]);
        } else {
            return null;
        }
        float[][] fArray6 = new float[this.lat_lon_dimension][];
        fArray6[0] = fArray3[n2];
        fArray6[1] = fArray3[n3];
        if (this.lat_lon_dimension == 3) {
            fArray6[2] = fArray3[n4];
        }
        return fArray6;
    }

    public void setEarthSpatialData(ShadowRealTupleType shadowRealTupleType, ShadowRealTupleType shadowRealTupleType2, RealTupleType realTupleType, Unit[] unitArray, RealTupleType realTupleType2, CoordinateSystem[] coordinateSystemArray, Unit[] unitArray2) throws VisADException {
        RealType realType;
        int n;
        ScalarMap[] scalarMapArray;
        int n2;
        if (realTupleType != null && realTupleType instanceof RealVectorType && (n2 = this.getFlowMaps(shadowRealTupleType2, scalarMapArray = new ScalarMap[3])) > -1) {
            this.rvts[n2] = (RealVectorType)realTupleType;
        }
        if (realTupleType2 != null && realTupleType2 instanceof RealVectorType && (n2 = this.getFlowMaps(shadowRealTupleType, scalarMapArray = new ScalarMap[3])) > -1) {
            this.rvts[n2] = (RealVectorType)realTupleType2;
        }
        int n3 = -1;
        n2 = -1;
        this.other_index = -1;
        int n4 = 0;
        int n5 = 0;
        if (realTupleType2 != null) {
            n4 = realTupleType2.getDimension();
            n = 0;
            while (n < n4) {
                realType = (RealType)realTupleType2.getComponent(n);
                if (RealType.Latitude.equals(realType)) {
                    n3 = n;
                }
                if (RealType.Longitude.equals(realType)) {
                    n2 = n;
                }
                ++n;
            }
        }
        if (n3 > -1 && n2 > -1 && (n4 == 2 || n4 == 3)) {
            if (shadowRealTupleType != null && shadowRealTupleType.getAllSpatial() && !shadowRealTupleType.getSpatialReference()) {
                this.lat_lon_in_by_coord = false;
                this.sdi_spatial_index = new int[shadowRealTupleType.getDimension()];
                this.sdi_maps = this.getSpatialMaps(shadowRealTupleType, this.sdi_spatial_index);
                if (this.sdi_maps == null) {
                    throw new DisplayException("sdi_maps null A");
                }
            } else if (shadowRealTupleType2 != null && shadowRealTupleType2.getAllSpatial() && !shadowRealTupleType2.getSpatialReference()) {
                this.lat_lon_in_by_coord = true;
                this.sdo_spatial_index = new int[shadowRealTupleType2.getDimension()];
                this.sdo_maps = this.getSpatialMaps(shadowRealTupleType2, this.sdo_spatial_index);
                if (this.sdo_maps == null) {
                    throw new DisplayException("sdo_maps null A");
                }
            } else {
                return;
            }
            this.lat_lon_in = true;
            this.lat_lon_out = false;
            this.lat_lon_out_by_coord = false;
            this.lat_lon_spatial = false;
            this.lat_lon_dimension = n4;
            if (n4 == 3) {
                this.other_index = 3 - (n3 + n2);
                if (Unit.canConvert(unitArray2[this.other_index], CommonUnit.meter)) {
                    this.other_meters = true;
                }
            }
        } else {
            n3 = -1;
            n2 = -1;
            if (realTupleType != null) {
                n5 = realTupleType.getDimension();
                n = 0;
                while (n < n5) {
                    realType = (RealType)realTupleType.getComponent(n);
                    if (RealType.Latitude.equals(realType)) {
                        n3 = n;
                    }
                    if (RealType.Longitude.equals(realType)) {
                        n2 = n;
                    }
                    ++n;
                }
            }
            if (n3 < 0 || n2 < 0 || n5 != 2 && n5 != 3) {
                return;
            }
            if (shadowRealTupleType2 != null && shadowRealTupleType2.getAllSpatial() && !shadowRealTupleType2.getSpatialReference()) {
                this.lat_lon_out_by_coord = false;
                this.sdo_spatial_index = new int[shadowRealTupleType2.getDimension()];
                this.sdo_maps = this.getSpatialMaps(shadowRealTupleType2, this.sdo_spatial_index);
                if (this.sdo_maps == null) {
                    throw new DisplayException("sdo_maps null B");
                }
            } else if (shadowRealTupleType != null && shadowRealTupleType.getAllSpatial() && !shadowRealTupleType.getSpatialReference()) {
                this.lat_lon_out_by_coord = true;
                this.sdi_spatial_index = new int[shadowRealTupleType.getDimension()];
                this.sdi_maps = this.getSpatialMaps(shadowRealTupleType, this.sdi_spatial_index);
                if (this.sdi_maps == null) {
                    throw new DisplayException("sdi_maps null B");
                }
            } else {
                return;
            }
            this.lat_lon_out = true;
            this.lat_lon_in = false;
            this.lat_lon_in_by_coord = false;
            this.lat_lon_spatial = false;
            this.lat_lon_dimension = n5;
            if (n5 == 3) {
                this.other_index = 3 - (n3 + n2);
                if (Unit.canConvert(unitArray2[this.other_index], CommonUnit.meter)) {
                    this.other_meters = true;
                }
            }
        }
        this.shadow_data_out = shadowRealTupleType2;
        this.data_out = realTupleType;
        this.data_units_out = unitArray;
        this.shadow_data_in = shadowRealTupleType;
        this.data_in = realTupleType2;
        this.data_units_in = unitArray2;
        this.data_coord_in = coordinateSystemArray;
        this.lat_index = n3;
        this.lon_index = n2;
    }

    private ScalarMap[] getSpatialMaps(ShadowRealTupleType shadowRealTupleType, int[] nArray) {
        int n = shadowRealTupleType.getDimension();
        ScalarMap[] scalarMapArray = new ScalarMap[n];
        int n2 = 0;
        while (n2 < n) {
            ShadowRealType shadowRealType = (ShadowRealType)shadowRealTupleType.getComponent(n2);
            Enumeration enumeration = shadowRealType.getSelectedMapVector().elements();
            while (enumeration.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                DisplayRealType displayRealType = scalarMap.getDisplayScalar();
                DisplayTupleType displayTupleType = displayRealType.getTuple();
                if (displayTupleType == null || !displayTupleType.equals(Display.DisplaySpatialCartesianTuple) && (displayTupleType.getCoordinateSystem() == null || !displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
                scalarMapArray[n2] = scalarMap;
                nArray[n2] = displayRealType.getTupleIndex();
                break;
            }
            if (scalarMapArray[n2] == null) {
                return null;
            }
            ++n2;
        }
        return scalarMapArray;
    }

    private int getFlowMaps(ShadowRealTupleType shadowRealTupleType, ScalarMap[] scalarMapArray) {
        int n = shadowRealTupleType.getDimension();
        scalarMapArray[0] = null;
        scalarMapArray[1] = null;
        scalarMapArray[2] = null;
        DisplayTupleType displayTupleType = null;
        int n2 = 0;
        while (n2 < n) {
            ShadowRealType shadowRealType = (ShadowRealType)shadowRealTupleType.getComponent(n2);
            Enumeration enumeration = shadowRealType.getSelectedMapVector().elements();
            while (enumeration.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                DisplayRealType displayRealType = scalarMap.getDisplayScalar();
                DisplayTupleType displayTupleType2 = displayRealType.getTuple();
                if (!Display.DisplayFlow1Tuple.equals(displayTupleType2) && !Display.DisplayFlow2Tuple.equals(displayTupleType2)) continue;
                if (displayTupleType != null && !displayTupleType.equals(displayTupleType2)) {
                    return -1;
                }
                displayTupleType = displayTupleType2;
                scalarMapArray[n2] = scalarMap;
                break;
            }
            if (scalarMapArray[n2] == null) {
                return -1;
            }
            ++n2;
        }
        return Display.DisplayFlow1Tuple.equals(displayTupleType) ? 0 : 1;
    }

    public double[] getRanges() {
        return this.ranges;
    }

    public CoordinateSystem getDisplayCoordinateSystem() {
        return this.display_coordinate_system;
    }

    public void setEarthSpatialDisplay(CoordinateSystem coordinateSystem, DisplayTupleType displayTupleType, DisplayImpl displayImpl, int[] nArray, float[] fArray, double[] dArray) throws VisADException {
        this.display_coordinate_system = coordinateSystem;
        this.spatial_tuple = displayTupleType;
        System.arraycopy(nArray, 0, this.spatial_value_indices, 0, 3);
        this.ranges = dArray;
        int n = 0;
        while (n < 3) {
            int n2 = displayImpl.getDisplayScalarIndex((DisplayRealType)displayTupleType.getComponent(n));
            this.default_spatial_in[n] = fArray[n2];
            ++n;
        }
        if (this.lat_index > -1 && this.lon_index > -1) {
            return;
        }
        this.lat_index = -1;
        this.lon_index = -1;
        this.other_index = -1;
        n = displayImpl.getValueArrayLength();
        int[] nArray2 = displayImpl.getValueToScalar();
        int[] nArray3 = displayImpl.getValueToMap();
        Vector vector = displayImpl.getMapVector();
        int n3 = 0;
        while (n3 < n) {
            ScalarMap scalarMap = (ScalarMap)vector.elementAt(nArray3[n3]);
            ScalarType scalarType = scalarMap.getScalar();
            DisplayRealType displayRealType = scalarMap.getDisplayScalar();
            DisplayTupleType displayTupleType2 = displayRealType.getTuple();
            if (displayTupleType2 != null && (displayTupleType2.equals(Display.DisplaySpatialCartesianTuple) || displayTupleType2.getCoordinateSystem() != null && displayTupleType2.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                if (RealType.Latitude.equals(scalarType)) {
                    this.lat_index = 0;
                    this.lat_map = scalarMap;
                    this.lat_spatial_index = displayRealType.getTupleIndex();
                }
                if (RealType.Longitude.equals(scalarType)) {
                    this.lon_index = 1;
                    this.lon_map = scalarMap;
                    this.lon_spatial_index = displayRealType.getTupleIndex();
                }
            }
            ++n3;
        }
        if (this.lat_index > -1 && this.lon_index > -1) {
            this.lat_lon_spatial = true;
            this.lat_lon_dimension = 2;
            this.lat_lon_out = false;
            this.lat_lon_in_by_coord = false;
            this.lat_lon_in = false;
        } else {
            this.lat_lon_spatial = false;
            this.lat_index = -1;
            this.lon_index = -1;
        }
    }

    public synchronized void realCheckDirect() throws VisADException, RemoteException {
        this.setIsDirectManipulation(false);
        DataDisplayLink[] dataDisplayLinkArray = this.getLinks();
        if (dataDisplayLinkArray == null || dataDisplayLinkArray.length == 0) {
            this.link = null;
            return;
        }
        this.link = dataDisplayLinkArray[0];
        this.ref = this.link.getDataReference();
        this.shadow = this.link.getShadow().getAdaptedShadowType();
        this.type = this.link.getType();
        this.tuple = null;
        if (this.type instanceof FunctionType) {
            Data data;
            ShadowRealTupleType shadowRealTupleType = ((ShadowFunctionType)this.shadow).getDomain();
            ShadowType shadowType = ((ShadowFunctionType)this.shadow).getRange();
            this.tuple = shadowRealTupleType.getDisplaySpatialTuple();
            if (!((FunctionType)this.type).getReal()) {
                this.whyNotDirect = notRealFunction;
                return;
            }
            if (this.shadow.getLevelOfDifficulty() != 3) {
                this.whyNotDirect = notSimpleField;
                return;
            }
            if (this.shadow.getMultipleSpatialDisplayScalar()) {
                this.whyNotDirect = multipleSpatialMapping;
                return;
            }
            if (shadowRealTupleType.getDimension() != 1) {
                this.whyNotDirect = domainDimension;
                return;
            }
            if (!(Display.DisplaySpatialCartesianTuple.equals(this.tuple) || this.tuple != null && this.tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                this.whyNotDirect = domainNotSpatial;
                return;
            }
            if (shadowRealTupleType.getSpatialReference()) {
                this.whyNotDirect = viaReference;
                return;
            }
            DisplayTupleType displayTupleType = null;
            if (shadowType instanceof ShadowRealTupleType) {
                displayTupleType = ((ShadowRealTupleType)shadowType).getDisplaySpatialTuple();
            } else if (shadowType instanceof ShadowRealType) {
                displayTupleType = ((ShadowRealType)shadowType).getDisplaySpatialTuple();
            } else {
                this.whyNotDirect = rangeType;
                return;
            }
            if (!this.tuple.equals(displayTupleType)) {
                this.whyNotDirect = rangeNotSpatial;
                return;
            }
            if (shadowType instanceof ShadowRealTupleType && ((ShadowRealTupleType)shadowType).getSpatialReference()) {
                this.whyNotDirect = viaReference;
                return;
            }
            try {
                data = this.link.getData();
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    this.link = null;
                    this.whyNotDirect = lostConnection;
                    return;
                }
                throw remoteException;
            }
            if (!(data instanceof Field) || !(((Field)data).getDomainSet() instanceof Gridded1DSet)) {
                this.whyNotDirect = domainSet;
                return;
            }
            if (Display.DisplaySpatialCartesianTuple.equals(this.tuple)) {
                this.tuple = null;
            }
            this.domainAxis = -1;
            int n = 0;
            while (n < 3) {
                this.axisToComponent[n] = -1;
                this.directMap[n] = null;
                ++n;
            }
            this.directManifoldDimension = this.setDirectMap((ShadowRealType)shadowRealTupleType.getComponent(0), -1, true);
            if (shadowType instanceof ShadowRealType) {
                this.directManifoldDimension += this.setDirectMap((ShadowRealType)shadowType, 0, false);
            } else if (shadowType instanceof ShadowRealTupleType) {
                ShadowRealTupleType shadowRealTupleType2 = (ShadowRealTupleType)shadowType;
                int n2 = 0;
                while (n2 < shadowRealTupleType2.getDimension()) {
                    this.directManifoldDimension += this.setDirectMap((ShadowRealType)shadowRealTupleType2.getComponent(n2), n2, false);
                    ++n2;
                }
            }
            if (this.domainAxis == -1) {
                this.whyNotDirect = tooFewSpatial;
                return;
            }
            if (this.directManifoldDimension < 2) {
                this.whyNotDirect = functionTooFew;
                return;
            }
            boolean bl = this.displayRenderer.getMode2D();
            if (this.tuple != null && (!bl && this.directManifoldDimension != 3 || bl && this.directManifoldDimension != 2)) {
                this.whyNotDirect = badCoordSysManifoldDim;
                return;
            }
            this.setIsDirectManipulation(true);
        } else if (this.type instanceof RealTupleType) {
            this.tuple = ((ShadowRealTupleType)this.shadow).getDisplaySpatialTuple();
            if (this.shadow.getLevelOfDifficulty() != 5) {
                this.whyNotDirect = notSimpleTuple;
                return;
            }
            if (this.shadow.getMultipleSpatialDisplayScalar()) {
                this.whyNotDirect = multipleSpatialMapping;
                return;
            }
            if (!(Display.DisplaySpatialCartesianTuple.equals(this.tuple) || this.tuple != null && this.tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                this.whyNotDirect = nonSpatial;
                return;
            }
            if (((ShadowRealTupleType)this.shadow).getSpatialReference()) {
                this.whyNotDirect = viaReference;
                return;
            }
            if (Display.DisplaySpatialCartesianTuple.equals(this.tuple)) {
                this.tuple = null;
            }
            this.domainAxis = -1;
            int n = 0;
            while (n < 3) {
                this.axisToComponent[n] = -1;
                this.directMap[n] = null;
                ++n;
            }
            this.directManifoldDimension = 0;
            n = 0;
            while (n < ((ShadowRealTupleType)this.shadow).getDimension()) {
                this.directManifoldDimension += this.setDirectMap((ShadowRealType)((ShadowRealTupleType)this.shadow).getComponent(n), n, false);
                ++n;
            }
            n = this.displayRenderer.getMode2D() ? 1 : 0;
            if (this.tuple != null && (n == 0 && this.directManifoldDimension != 3 || n != 0 && this.directManifoldDimension != 2)) {
                this.whyNotDirect = badCoordSysManifoldDim;
                return;
            }
            this.setIsDirectManipulation(true);
        } else if (this.type instanceof RealType) {
            this.tuple = ((ShadowRealType)this.shadow).getDisplaySpatialTuple();
            if (this.shadow.getLevelOfDifficulty() != 5) {
                this.whyNotDirect = notSimpleTuple;
                return;
            }
            if (this.shadow.getMultipleSpatialDisplayScalar()) {
                this.whyNotDirect = multipleSpatialMapping;
                return;
            }
            if (!(Display.DisplaySpatialCartesianTuple.equals(this.tuple) || this.tuple != null && this.tuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) {
                this.whyNotDirect = nonSpatial;
                return;
            }
            if (Display.DisplaySpatialCartesianTuple.equals(this.tuple)) {
                this.tuple = null;
            }
            this.domainAxis = -1;
            int n = 0;
            while (n < 3) {
                this.axisToComponent[n] = -1;
                this.directMap[n] = null;
                ++n;
            }
            this.directManifoldDimension = this.setDirectMap((ShadowRealType)this.shadow, 0, false);
            n = this.displayRenderer.getMode2D() ? 1 : 0;
            if (this.tuple != null && (n == 0 && this.directManifoldDimension != 3 || n != 0 && this.directManifoldDimension != 2)) {
                this.whyNotDirect = badCoordSysManifoldDim;
                return;
            }
            this.setIsDirectManipulation(true);
        }
    }

    synchronized int setDirectMap(ShadowRealType shadowRealType, int n, boolean bl) {
        Enumeration enumeration = shadowRealType.getSelectedMapVector().elements();
        while (enumeration.hasMoreElements()) {
            ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
            DisplayRealType displayRealType = scalarMap.getDisplayScalar();
            DisplayTupleType displayTupleType = displayRealType.getTuple();
            if (!Display.DisplaySpatialCartesianTuple.equals(displayTupleType) && (displayTupleType == null || !displayTupleType.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
            int n2 = displayRealType.getTupleIndex();
            if (bl) {
                this.domainAxis = n2;
            } else {
                this.axisToComponent[n2] = n;
            }
            this.directMap[n2] = scalarMap;
            return 1;
        }
        return 0;
    }

    private int getDirectManifoldDimension() {
        return this.directManifoldDimension;
    }

    public String getWhyNotDirect() {
        return this.whyNotDirect;
    }

    private int getAxisToComponent(int n) {
        return this.axisToComponent[n];
    }

    private ScalarMap getDirectMap(int n) {
        return this.directMap[n];
    }

    private int getDomainAxis() {
        return this.domainAxis;
    }

    public synchronized void setSpatialValues(float[][] fArray) {
        this.spatialValues = fArray;
    }

    public synchronized float checkClose(double[] dArray, double[] dArray2) {
        float f = Float.MAX_VALUE;
        this.lastIndex = -1;
        if (this.spatialValues == null) {
            return f;
        }
        float f2 = (float)dArray[0];
        float f3 = (float)dArray[1];
        float f4 = (float)dArray[2];
        float f5 = (float)dArray2[0];
        float f6 = (float)dArray2[1];
        float f7 = (float)dArray2[2];
        int n = 0;
        while (n < this.spatialValues[0].length) {
            float f8;
            float f9;
            float f10 = this.spatialValues[0][n] - f2;
            float f11 = this.spatialValues[1][n] - f3;
            float f12 = this.spatialValues[2][n] - f4;
            if ((f9 = (float)Math.sqrt((f10 -= (f8 = f10 * f5 + f11 * f6 + f12 * f7) * f5) * f10 + (f11 -= f8 * f6) * f11 + (f12 -= f8 * f7) * f12)) < f) {
                f = f9;
                this.closeIndex = n;
                this.offsetx = f10;
                this.offsety = f11;
                this.offsetz = f12;
            }
            ++n;
        }
        return f;
    }

    public synchronized void release_direct() {
    }

    public void stop_direct() {
        this.stop = true;
    }

    public int getLastMouseModifiers() {
        return this.LastMouseModifiers;
    }

    public void setLastMouseModifiers(int n) {
        this.LastMouseModifiers = n;
    }

    public synchronized void drag_direct(VisADRay visADRay, boolean bl, int n) {
        float f;
        float f2;
        if (this.spatialValues == null || this.ref == null || this.shadow == null || this.link == null) {
            return;
        }
        if (bl) {
            this.stop = false;
        } else if (this.stop) {
            return;
        }
        float f3 = (float)visADRay.position[0];
        float f4 = (float)visADRay.position[1];
        float f5 = (float)visADRay.position[2];
        float f6 = (float)visADRay.vector[0];
        float f7 = (float)visADRay.vector[1];
        float f8 = (float)visADRay.vector[2];
        if (bl) {
            this.offset_count = 30;
        } else if (this.offset_count > 0) {
            --this.offset_count;
        }
        if (this.offset_count > 0) {
            float f9 = (float)this.offset_count / 30.0f;
            f3 += f9 * this.offsetx;
            f4 += f9 * this.offsety;
            f5 += f9 * this.offsetz;
        }
        if (bl) {
            this.point_x = this.spatialValues[0][this.closeIndex];
            this.point_y = this.spatialValues[1][this.closeIndex];
            this.point_z = this.spatialValues[2][this.closeIndex];
            int n2 = -1;
            if (this.getDirectManifoldDimension() == 3) {
                this.line_x = f6;
                this.line_y = f7;
                this.line_z = f8;
            } else {
                int n3;
                if (this.getDirectManifoldDimension() == 2) {
                    if (this.displayRenderer.getMode2D()) {
                        n2 = 2;
                    } else {
                        n3 = 0;
                        while (n3 < 3) {
                            if (this.getAxisToComponent(n3) < 0 && this.getDomainAxis() != n3) {
                                n2 = n3;
                            }
                            ++n3;
                        }
                    }
                } else if (this.getDirectManifoldDimension() == 1) {
                    n3 = 0;
                    while (n3 < 3) {
                        if (this.getAxisToComponent(n3) >= 0) {
                            n2 = n3;
                        }
                        ++n3;
                    }
                }
                this.line_x = n2 == 0 ? 1.0f : 0.0f;
                this.line_y = n2 == 1 ? 1.0f : 0.0f;
                this.line_z = n2 == 2 ? 1.0f : 0.0f;
            }
        }
        float[] fArray = new float[3];
        if (this.getDirectManifoldDimension() == 1) {
            f2 = f6 * this.line_x + f7 * this.line_y + f8 * this.line_z;
            f = f3 * f6 + f4 * f7 + f5 * f8;
            float f10 = this.point_x * f6 + this.point_y * f7 + this.point_z * f8;
            float f11 = f3 * this.line_x + f4 * this.line_y + f5 * this.line_z;
            float f12 = this.point_x * this.line_x + this.point_y * this.line_y + this.point_z * this.line_z;
            if (f2 * f2 == 1.0f) {
                return;
            }
            float f13 = (f12 - f11 - f2 * (f10 - f)) / (f2 * f2 - 1.0f);
            fArray[0] = this.point_x + f13 * this.line_x;
            fArray[1] = this.point_y + f13 * this.line_y;
            fArray[2] = this.point_z + f13 * this.line_z;
        } else {
            f2 = (this.point_x - f3) * this.line_x + (this.point_y - f4) * this.line_y + (this.point_z - f5) * this.line_z;
            f = f6 * this.line_x + f7 * this.line_y + f8 * this.line_z;
            if ((double)f == 0.0) {
                return;
            }
            fArray[0] = f3 + (f2 /= f) * f6;
            fArray[1] = f4 + f2 * f7;
            fArray[2] = f5 + f2 * f8;
        }
        try {
            Data data;
            float[] fArray2 = new float[]{fArray[0], fArray[1], fArray[2]};
            if (this.tuple != null) {
                float[][] fArray3 = new float[][]{{fArray[0]}, {fArray[1]}, {fArray[2]}};
                float[][] fArray4 = this.tuple.getCoordinateSystem().fromReference(fArray3);
                fArray[0] = fArray4[0][0];
                fArray[1] = fArray4[1][0];
                fArray[2] = fArray4[2][0];
            }
            DataImpl dataImpl = null;
            try {
                data = this.link.getData();
            }
            catch (RemoteException remoteException) {
                if (CollabUtil.isDisconnectException(remoteException)) {
                    this.getDisplay().connectionFailed(this, this.link);
                    this.removeLink(this.link);
                    this.link = null;
                    return;
                }
                throw remoteException;
            }
            if (this.type instanceof RealType) {
                this.addPoint(fArray2);
                int n4 = 0;
                while (n4 < 3) {
                    if (this.getAxisToComponent(n4) >= 0) {
                        this.f[0] = fArray[n4];
                        this.d = this.getDirectMap(n4).inverseScaleValues(this.f);
                        RealType realType = (RealType)this.type;
                        dataImpl = new Real(realType, (double)this.d[0], realType.getDefaultUnit(), null);
                        Vector<String> vector = new Vector<String>();
                        Real real = new Real(realType, (double)this.d[0]);
                        Unit unit = this.getDirectMap(n4).getOverrideUnit();
                        Unit unit2 = realType.getDefaultUnit();
                        if (!(unit == null || unit.equals(unit2) || Unit.canConvert(unit2, CommonUnit.secondsSinceTheEpoch) && !unit2.getAbsoluteUnit().equals(unit2))) {
                            double d = unit.toThis(this.d[0], unit2);
                            real = new Real(realType, d, unit);
                        }
                        String string = real.toValueString();
                        vector.addElement(realType.getName() + " = " + string);
                        this.getDisplayRenderer().setCursorStringVector(vector);
                        break;
                    }
                    ++n4;
                }
                this.ref.setData(dataImpl);
                this.link.clearData();
            } else if (this.type instanceof RealTupleType) {
                this.addPoint(fArray2);
                int n5 = ((RealTuple)data).getDimension();
                Real[] realArray = new Real[n5];
                Vector<String> vector = new Vector<String>();
                int n6 = 0;
                while (n6 < 3) {
                    int n7 = this.getAxisToComponent(n6);
                    if (n7 >= 0) {
                        this.f[0] = fArray[n6];
                        this.d = this.getDirectMap(n6).inverseScaleValues(this.f);
                        Real real = (Real)((RealTuple)data).getComponent(n7);
                        RealType realType = (RealType)real.getType();
                        realArray[n7] = new Real(realType, (double)this.d[0], realType.getDefaultUnit(), null);
                        Real real2 = new Real(realType, (double)this.d[0]);
                        Unit unit = this.getDirectMap(n6).getOverrideUnit();
                        Unit unit3 = realType.getDefaultUnit();
                        if (!(unit == null || unit.equals(unit3) || Unit.canConvert(unit3, CommonUnit.secondsSinceTheEpoch) && !unit3.getAbsoluteUnit().equals(unit3))) {
                            double d = unit.toThis(this.d[0], unit3);
                            real2 = new Real(realType, d, unit);
                        }
                        String string = real2.toValueString();
                        vector.addElement(realType.getName() + " = " + string);
                    }
                    ++n6;
                }
                this.getDisplayRenderer().setCursorStringVector(vector);
                n6 = 0;
                while (n6 < n5) {
                    if (realArray[n6] == null) {
                        realArray[n6] = (Real)((RealTuple)data).getComponent(n6);
                    }
                    ++n6;
                }
                dataImpl = new RealTuple((RealTupleType)this.type, realArray, ((RealTuple)data).getCoordinateSystem());
                this.ref.setData(dataImpl);
                this.link.clearData();
            } else if (this.type instanceof FunctionType) {
                int n8;
                Vector<String> vector = new Vector<String>();
                if (bl) {
                    this.lastIndex = -1;
                }
                int n9 = this.getDomainAxis();
                this.f[0] = fArray[n9];
                this.d = this.getDirectMap(n9).inverseScaleValues(this.f);
                RealType realType = (RealType)this.getDirectMap(n9).getScalar();
                double d = this.d[0];
                Unit[] unitArray = ((Field)data).getDomainUnits();
                if (unitArray != null && unitArray[0] != null) {
                    this.d[0] = (float)unitArray[0].toThis(this.d[0], realType.getDefaultUnit());
                }
                Real real = new Real(realType, d);
                Unit unit = this.getDirectMap(n9).getOverrideUnit();
                Unit unit4 = realType.getDefaultUnit();
                if (!(unit == null || unit.equals(unit4) || Unit.canConvert(unit4, CommonUnit.secondsSinceTheEpoch) && !unit4.getAbsoluteUnit().equals(unit4))) {
                    d = unit.toThis(d, unit4);
                    real = new Real(realType, d, unit);
                }
                String string = real.toValueString();
                vector.addElement(realType.getName() + " = " + string);
                Gridded1DSet gridded1DSet = (Gridded1DSet)((Field)data).getDomainSet();
                this.value[0][0] = this.d[0];
                int[] nArray = gridded1DSet.valueToIndex(this.value);
                int n10 = nArray[0];
                if (n10 < 0) {
                    this.lastIndex = -1;
                    return;
                }
                if (this.lastIndex < 0) {
                    this.addPoint(fArray2);
                } else {
                    this.lastX[3] = fArray2[0];
                    this.lastX[4] = fArray2[1];
                    this.lastX[5] = fArray2[2];
                    this.addPoint(this.lastX);
                }
                this.lastX[0] = fArray2[0];
                this.lastX[1] = fArray2[1];
                this.lastX[2] = fArray2[2];
                MathType mathType = ((FunctionType)this.type).getRange();
                int n11 = mathType instanceof RealType ? 1 : ((RealTupleType)mathType).getDimension();
                double[] dArray = new double[n11];
                boolean[] blArray = new boolean[n11];
                int n12 = 0;
                while (n12 < n11) {
                    dArray[n12] = Double.NaN;
                    blArray[n12] = false;
                    ++n12;
                }
                n12 = 0;
                while (n12 < 3) {
                    n8 = this.getAxisToComponent(n12);
                    if (n8 >= 0) {
                        this.f[0] = fArray[n12];
                        this.d = this.getDirectMap(n12).inverseScaleValues(this.f);
                        realType = (RealType)this.getDirectMap(n12).getScalar();
                        real = new Real(realType, (double)this.d[0]);
                        unit = this.getDirectMap(n12).getOverrideUnit();
                        unit4 = realType.getDefaultUnit();
                        if (!(unit == null || unit.equals(unit4) || Unit.canConvert(unit4, CommonUnit.secondsSinceTheEpoch) && !unit4.getAbsoluteUnit().equals(unit4))) {
                            double d2 = unit.toThis(this.d[0], unit4);
                            real = new Real(realType, d2, unit);
                        }
                        string = real.toValueString();
                        vector.addElement(realType.getName() + " = " + string);
                        dArray[n8] = this.d[0];
                        blArray[n8] = true;
                    }
                    ++n12;
                }
                this.getDisplayRenderer().setCursorStringVector(vector);
                if (this.lastIndex < 0) {
                    this.lastIndex = n10;
                    this.lastD = new double[n11];
                    n12 = 0;
                    while (n12 < n11) {
                        this.lastD[n12] = dArray[n12];
                        ++n12;
                    }
                }
                Real[] realArray = new Real[n11];
                n8 = Math.abs(this.lastIndex - n10) + 1;
                nArray = new int[n8];
                int n13 = n10;
                int n14 = this.lastIndex >= n10 ? 1 : -1;
                int n15 = 0;
                while (n15 < n8) {
                    nArray[n15] = n13;
                    n13 += n14;
                    ++n15;
                }
                float[][] fArray5 = gridded1DSet.indexToValue(nArray);
                double d3 = fArray5[0][n8 - 1] - fArray5[0][0];
                int n16 = 0;
                while (n16 < n8) {
                    n13 = nArray[n16];
                    double d4 = n16 == 0 || d3 == 0.0 ? 0.0 : (double)(fArray5[0][n16] - fArray5[0][0]) / d3;
                    Data data2 = ((Field)data).getSample(n13);
                    if (data2 instanceof Real) {
                        if (blArray[0]) {
                            realType = (RealType)data2.getType();
                            data2 = new Real(realType, dArray[0] + d4 * (this.lastD[0] - dArray[0]), realType.getDefaultUnit(), null);
                        }
                    } else {
                        int n17 = 0;
                        while (n17 < n11) {
                            Real real3 = (Real)((RealTuple)data2).getComponent(n17);
                            if (blArray[n17]) {
                                realType = (RealType)real3.getType();
                                realArray[n17] = new Real(realType, dArray[n17] + d4 * (this.lastD[n17] - dArray[n17]), realType.getDefaultUnit(), null);
                            } else {
                                realArray[n17] = real3;
                            }
                            ++n17;
                        }
                        data2 = new RealTuple(realArray);
                    }
                    ((Field)data).setSample(n13, data2);
                    ++n16;
                }
                if (this.ref instanceof RemoteDataReference && !(data instanceof RemoteData)) {
                    this.ref.setData(data);
                    this.link.clearData();
                }
                this.lastIndex = n10;
                n16 = 0;
                while (n16 < n11) {
                    this.lastD[n16] = dArray[n16];
                    ++n16;
                }
            }
        }
        catch (VisADException visADException) {
            System.out.println("drag_direct " + visADException);
            visADException.printStackTrace();
        }
        catch (RemoteException remoteException) {
            System.out.println("drag_direct " + remoteException);
            remoteException.printStackTrace();
        }
    }

    public void addPoint(float[] fArray) throws VisADException {
    }

    public void checkDirect() throws VisADException, RemoteException {
        this.isDirectManipulation = false;
    }

    public void setIsDirectManipulation(boolean bl) {
        this.isDirectManipulation = bl;
    }

    public boolean getIsDirectManipulation() {
        return this.isDirectManipulation;
    }

    public float findRayManifoldIntersection(boolean bl, double[] dArray, double[] dArray2, DisplayTupleType displayTupleType, int n, float f) throws VisADException {
        this.ray_pos = Float.NaN;
        if (n < 0) {
            return this.ray_pos;
        }
        CoordinateSystem coordinateSystem = null;
        if (displayTupleType != null) {
            coordinateSystem = displayTupleType.getCoordinateSystem();
        }
        if (displayTupleType == null || coordinateSystem == null) {
            this.ray_pos = (float)(((double)f - dArray[n]) / dArray2[n]);
        } else {
            double d = Double.NaN;
            if (Display.DisplaySpatialSphericalTuple.equals(displayTupleType) && n == 1) {
                d = 360.0;
            }
            if (bl) {
                this.ray_pos = Float.NaN;
                float[][] fArray = new float[3][401];
                int n2 = 0;
                while (n2 < 401) {
                    float f2 = (float)(n2 - 200) * 0.1f;
                    fArray[0][n2] = (float)(dArray[0] + (double)f2 * dArray2[0]);
                    fArray[1][n2] = (float)(dArray[1] + (double)f2 * dArray2[1]);
                    fArray[2][n2] = (float)(dArray[2] + (double)f2 * dArray2[2]);
                    if (d == d) {
                        fArray[n][n2] = (float)(((double)f + 0.5 * d + (double)fArray[n][n2]) % d - ((double)f + 0.5 * d));
                    }
                    ++n2;
                }
                fArray = coordinateSystem.fromReference(fArray);
                double d2 = Double.MAX_VALUE;
                float f3 = 0.0f;
                int n3 = 0;
                while (n3 < 401) {
                    float f4 = f - fArray[n][n3];
                    if (n3 > 0 && (f4 < 0.0f && f3 >= 0.0f || f4 >= 0.0f && f3 < 0.0f)) {
                        float f5 = (float)n3 - Math.abs(f4) / (Math.abs(f3) + Math.abs(f4));
                        this.ray_pos = (f5 - 200.0f) * 0.1f;
                        break;
                    }
                    f3 = f4;
                    double d3 = Math.abs(f - fArray[n][n3]);
                    if (d3 < d2) {
                        d2 = d3;
                        this.ray_pos = (float)(n3 - 200) * 0.1f;
                    }
                    ++n3;
                }
            }
            if (this.ray_pos == this.ray_pos) {
                double d4 = 0.001f;
                double d5 = this.ray_pos;
                double d6 = 1.0;
                double[][] dArray3 = new double[3][3];
                int n4 = 0;
                while (n4 < 10 && d5 == d5) {
                    double d7;
                    double d8 = d5 + (double)0.001f;
                    double d9 = d5 - (double)0.001f;
                    dArray3[0][0] = dArray[0] + d8 * dArray2[0];
                    dArray3[1][0] = dArray[1] + d8 * dArray2[1];
                    dArray3[2][0] = dArray[2] + d8 * dArray2[2];
                    dArray3[0][1] = dArray[0] + d5 * dArray2[0];
                    dArray3[1][1] = dArray[1] + d5 * dArray2[1];
                    dArray3[2][1] = dArray[2] + d5 * dArray2[2];
                    dArray3[0][2] = dArray[0] + d9 * dArray2[0];
                    dArray3[1][2] = dArray[1] + d9 * dArray2[1];
                    dArray3[2][2] = dArray[2] + d9 * dArray2[2];
                    dArray3 = coordinateSystem.fromReference(dArray3);
                    if (d == d) {
                        dArray3[n][0] = ((double)f + 0.5 * d + dArray3[n][0]) % d - ((double)f + 0.5 * d);
                        dArray3[n][1] = ((double)f + 0.5 * d + dArray3[n][1]) % d - ((double)f + 0.5 * d);
                        dArray3[n][2] = ((double)f + 0.5 * d + dArray3[n][2]) % d - ((double)f + 0.5 * d);
                    }
                    if ((d6 = Math.abs(d7 = (double)f - dArray3[n][1])) <= (double)0.001f) break;
                    double d10 = (double)f - dArray3[n][0];
                    double d11 = (double)f - dArray3[n][2];
                    double d12 = (d10 - d11) / (double)0.002f;
                    d5 -= d7 / d12;
                    ++n4;
                }
                this.ray_pos = d6 < d4 ? (float)d5 : Float.NaN;
            }
        }
        return this.ray_pos;
    }

    public void removeLink(DataDisplayLink dataDisplayLink) {
        int n = this.Links.length - 1;
        if (n < 0) {
            return;
        }
        DataDisplayLink[] dataDisplayLinkArray = new DataDisplayLink[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 <= n) {
            if (this.Links[n3] != dataDisplayLink) {
                if (n2 == n) {
                    return;
                }
                dataDisplayLinkArray[n2++] = this.Links[n3];
            }
            ++n3;
        }
        if (n2 < n) {
            DataDisplayLink[] dataDisplayLinkArray2 = new DataDisplayLink[n2];
            System.arraycopy(dataDisplayLinkArray, 0, dataDisplayLinkArray2, 0, n2);
            dataDisplayLinkArray = dataDisplayLinkArray2;
        }
        this.Links = dataDisplayLinkArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

