/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataReferenceImpl;
import visad.DataShadow;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayListener;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ShadowRealTupleType;
import visad.ShadowRealType;
import visad.ShadowType;
import visad.ThingImpl;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public abstract class DataImpl
extends ThingImpl
implements Data,
Cloneable {
    private static DisplayImplJ2D rdisplay = null;
    private static Object lock = new Object();
    MathType Type;
    private transient DataImpl parent;

    public DataImpl local() {
        return this;
    }

    void setParent(DataImpl dataImpl) {
        this.parent = dataImpl;
    }

    public MathType getType() {
        return this.Type;
    }

    public void notifyReferences() throws VisADException, RemoteException {
        super.notifyReferences();
        if (this.parent != null) {
            this.parent.notifyReferences();
        }
    }

    public Data binary(Data data, int n, int n2, int n3) throws VisADException, RemoteException {
        MathType mathType = data.getType();
        MathType mathType2 = this.Type.binary(mathType, n, new Vector());
        return this.binary(data, n, mathType2, n2, n3);
    }

    public Data binary(Data data, int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        throw new TypeException("DataImpl.binary");
    }

    public Data add(Data data) throws VisADException, RemoteException {
        return this.binary(data, 1, 100, 202);
    }

    public Data subtract(Data data) throws VisADException, RemoteException {
        return this.binary(data, 2, 100, 202);
    }

    public Data multiply(Data data) throws VisADException, RemoteException {
        return this.binary(data, 4, 100, 202);
    }

    public Data divide(Data data) throws VisADException, RemoteException {
        return this.binary(data, 5, 100, 202);
    }

    public Data pow(Data data) throws VisADException, RemoteException {
        return this.binary(data, 7, 100, 202);
    }

    public Data max(Data data) throws VisADException, RemoteException {
        return this.binary(data, 9, 100, 202);
    }

    public Data min(Data data) throws VisADException, RemoteException {
        return this.binary(data, 10, 100, 202);
    }

    public Data atan2(Data data) throws VisADException, RemoteException {
        return this.binary(data, 11, 100, 202);
    }

    public Data atan2Degrees(Data data) throws VisADException, RemoteException {
        return this.binary(data, 12, 100, 202);
    }

    public Data remainder(Data data) throws VisADException, RemoteException {
        return this.binary(data, 15, 100, 202);
    }

    public Data add(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 1, n, n2);
    }

    public Data subtract(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 2, n, n2);
    }

    public Data multiply(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 4, n, n2);
    }

    public Data divide(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 5, n, n2);
    }

    public Data pow(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 7, n, n2);
    }

    public Data max(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 9, n, n2);
    }

    public Data min(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 10, n, n2);
    }

    public Data atan2(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 11, n, n2);
    }

    public Data atan2Degrees(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 12, n, n2);
    }

    public Data remainder(Data data, int n, int n2) throws VisADException, RemoteException {
        return this.binary(data, 15, n, n2);
    }

    public Data unary(int n, int n2, int n3) throws VisADException, RemoteException {
        MathType mathType = this.Type.unary(n, new Vector());
        return this.unary(n, mathType, n2, n3);
    }

    public Data unary(int n, MathType mathType, int n2, int n3) throws VisADException, RemoteException {
        throw new TypeException("DataImpl: unary");
    }

    public Data changeMathType(MathType mathType) throws VisADException, RemoteException {
        return this.unary(42, mathType, 100, 202);
    }

    public Data abs() throws VisADException, RemoteException {
        return this.unary(21, 100, 202);
    }

    public Data acos() throws VisADException, RemoteException {
        return this.unary(22, 100, 202);
    }

    public Data acosDegrees() throws VisADException, RemoteException {
        return this.unary(23, 100, 202);
    }

    public Data asin() throws VisADException, RemoteException {
        return this.unary(24, 100, 202);
    }

    public Data asinDegrees() throws VisADException, RemoteException {
        return this.unary(25, 100, 202);
    }

    public Data atan() throws VisADException, RemoteException {
        return this.unary(26, 100, 202);
    }

    public Data atanDegrees() throws VisADException, RemoteException {
        return this.unary(27, 100, 202);
    }

    public Data ceil() throws VisADException, RemoteException {
        return this.unary(28, 100, 202);
    }

    public Data cos() throws VisADException, RemoteException {
        return this.unary(29, 100, 202);
    }

    public Data cosDegrees() throws VisADException, RemoteException {
        return this.unary(30, 100, 202);
    }

    public Data exp() throws VisADException, RemoteException {
        return this.unary(31, 100, 202);
    }

    public Data floor() throws VisADException, RemoteException {
        return this.unary(32, 100, 202);
    }

    public Data log() throws VisADException, RemoteException {
        return this.unary(33, 100, 202);
    }

    public Data rint() throws VisADException, RemoteException {
        return this.unary(34, 100, 202);
    }

    public Data round() throws VisADException, RemoteException {
        return this.unary(35, 100, 202);
    }

    public Data sin() throws VisADException, RemoteException {
        return this.unary(36, 100, 202);
    }

    public Data sinDegrees() throws VisADException, RemoteException {
        return this.unary(37, 100, 202);
    }

    public Data sqrt() throws VisADException, RemoteException {
        return this.unary(38, 100, 202);
    }

    public Data tan() throws VisADException, RemoteException {
        return this.unary(39, 100, 202);
    }

    public Data tanDegrees() throws VisADException, RemoteException {
        return this.unary(40, 100, 202);
    }

    public Data negate() throws VisADException, RemoteException {
        return this.unary(41, 100, 202);
    }

    public Data abs(int n, int n2) throws VisADException, RemoteException {
        return this.unary(21, n, n2);
    }

    public Data acos(int n, int n2) throws VisADException, RemoteException {
        return this.unary(22, n, n2);
    }

    public Data acosDegrees(int n, int n2) throws VisADException, RemoteException {
        return this.unary(23, n, n2);
    }

    public Data asin(int n, int n2) throws VisADException, RemoteException {
        return this.unary(24, n, n2);
    }

    public Data asinDegrees(int n, int n2) throws VisADException, RemoteException {
        return this.unary(25, n, n2);
    }

    public Data atan(int n, int n2) throws VisADException, RemoteException {
        return this.unary(26, n, n2);
    }

    public Data atanDegrees(int n, int n2) throws VisADException, RemoteException {
        return this.unary(27, n, n2);
    }

    public Data ceil(int n, int n2) throws VisADException, RemoteException {
        return this.unary(28, n, n2);
    }

    public Data cos(int n, int n2) throws VisADException, RemoteException {
        return this.unary(29, n, n2);
    }

    public Data cosDegrees(int n, int n2) throws VisADException, RemoteException {
        return this.unary(30, n, n2);
    }

    public Data exp(int n, int n2) throws VisADException, RemoteException {
        return this.unary(31, n, n2);
    }

    public Data floor(int n, int n2) throws VisADException, RemoteException {
        return this.unary(32, n, n2);
    }

    public Data log(int n, int n2) throws VisADException, RemoteException {
        return this.unary(33, n, n2);
    }

    public Data rint(int n, int n2) throws VisADException, RemoteException {
        return this.unary(34, n, n2);
    }

    public Data round(int n, int n2) throws VisADException, RemoteException {
        return this.unary(35, n, n2);
    }

    public Data sin(int n, int n2) throws VisADException, RemoteException {
        return this.unary(36, n, n2);
    }

    public Data sinDegrees(int n, int n2) throws VisADException, RemoteException {
        return this.unary(37, n, n2);
    }

    public Data sqrt(int n, int n2) throws VisADException, RemoteException {
        return this.unary(38, n, n2);
    }

    public Data tan(int n, int n2) throws VisADException, RemoteException {
        return this.unary(39, n, n2);
    }

    public Data tanDegrees(int n, int n2) throws VisADException, RemoteException {
        return this.unary(40, n, n2);
    }

    public Data negate(int n, int n2) throws VisADException, RemoteException {
        return this.unary(41, n, n2);
    }

    static int invertOp(int n) throws VisADException {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 6;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 7;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 13;
            }
            case 12: {
                return 14;
            }
            case 13: {
                return 11;
            }
            case 14: {
                return 12;
            }
            case 15: {
                return 16;
            }
            case 16: {
                return 15;
            }
        }
        throw new ArithmeticException("DataImpl.invertOp: illegal operation");
    }

    public double[][] computeRanges(RealType[] realTypeArray) throws VisADException, RemoteException {
        Object object = lock;
        synchronized (object) {
            if (rdisplay == null) {
                rdisplay = new DisplayImplJ2D("dummy", 4, 4);
            }
            if (realTypeArray == null || realTypeArray.length == 0) {
                double[][] dArray = null;
                Object var3_5 = null;
                return dArray;
            }
            int n = realTypeArray.length;
            ScalarMap[] scalarMapArray = new ScalarMap[n];
            int n2 = 0;
            while (n2 < n) {
                scalarMapArray[n2] = new ScalarMap(realTypeArray[n2], Display.Shape);
                rdisplay.addMap(scalarMapArray[n2]);
                ++n2;
            }
            rdisplay.disableAction();
            DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("dummy");
            dataReferenceImpl.setData(this);
            rdisplay.reAutoScale();
            rdisplay.addReference(dataReferenceImpl);
            new Syncher();
            double[][] dArray = new double[n][];
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = scalarMapArray[n3].getRange();
                ++n3;
            }
            rdisplay.removeReference(dataReferenceImpl);
            rdisplay.clearMaps();
            double[][] dArray2 = dArray;
            Object var3_6 = null;
            return dArray2;
        }
    }

    public DataShadow computeRanges(ShadowType shadowType, int n) throws VisADException, RemoteException {
        double[][] dArray = new double[2][n];
        int n2 = 0;
        while (n2 < n) {
            dArray[0][n2] = Double.MAX_VALUE;
            dArray[1][n2] = -1.7976931348623157E308;
            ++n2;
        }
        DataShadow dataShadow = new DataShadow(dArray);
        return this.computeRanges(shadowType, dataShadow);
    }

    DataShadow computeReferenceRanges(ShadowRealTupleType shadowRealTupleType, CoordinateSystem coordinateSystem, Unit[] unitArray, DataShadow dataShadow, ShadowRealTupleType shadowRealTupleType2, double[][] dArray) throws VisADException {
        RealTupleType realTupleType = (RealTupleType)shadowRealTupleType.Type;
        RealTupleType realTupleType2 = (RealTupleType)shadowRealTupleType2.Type;
        int n = dArray[0].length;
        int n2 = 1;
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            n2 = 5 * n2;
            nArray[n3] = 0;
            ++n3;
        }
        double[][] dArray2 = new double[n][n2];
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                switch (nArray[n5]) {
                    case 0: {
                        dArray2[n5][n4] = dArray[0][n5];
                        break;
                    }
                    case 1: {
                        dArray2[n5][n4] = 0.75 * dArray[0][n5] + 0.25 * dArray[1][n5];
                        break;
                    }
                    case 2: {
                        dArray2[n5][n4] = 0.5 * (dArray[0][n5] + dArray[1][n5]);
                        break;
                    }
                    case 3: {
                        dArray2[n5][n4] = 0.25 * dArray[0][n5] + 0.75 * dArray[1][n5];
                        break;
                    }
                    case 4: {
                        dArray2[n5][n4] = dArray[1][n5];
                        break;
                    }
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < n) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + 1;
                if (nArray[n5] != 5) break;
                nArray[n5] = 0;
                ++n5;
            }
            ++n4;
        }
        dArray2 = CoordinateSystem.transformCoordinates(realTupleType2, realTupleType2.getCoordinateSystem(), realTupleType2.getDefaultUnits(), null, realTupleType, coordinateSystem, unitArray, null, dArray2);
        n4 = 0;
        while (n4 < n) {
            double d = Double.MAX_VALUE;
            double d2 = -1.7976931348623157E308;
            int n7 = 0;
            while (n7 < n2) {
                double d3 = dArray2[n4][n7];
                if (d3 == d3) {
                    d = Math.min(d, d3);
                    d2 = Math.max(d2, d3);
                }
                ++n7;
            }
            n7 = ((ShadowRealType)shadowRealTupleType2.getComponent(n4)).getIndex();
            if (n7 >= 0) {
                if (d == d) {
                    dataShadow.ranges[0][n7] = Math.min(dataShadow.ranges[0][n7], d);
                }
                if (d2 == d2) {
                    dataShadow.ranges[1][n7] = Math.max(dataShadow.ranges[1][n7], d2);
                }
            }
            ++n4;
        }
        return dataShadow;
    }

    public Data adjustSamplingError(Data data, int n) throws VisADException, RemoteException {
        return this;
    }

    public Data __add__(Data data) throws VisADException, RemoteException {
        return this.add(data);
    }

    public Data __sub__(Data data) throws VisADException, RemoteException {
        return this.subtract(data);
    }

    public Data __mul__(Data data) throws VisADException, RemoteException {
        return this.multiply(data);
    }

    public Data __div__(Data data) throws VisADException, RemoteException {
        return this.divide(data);
    }

    public Data __pow__(Data data) throws VisADException, RemoteException {
        return this.pow(data);
    }

    public Data __mod__(Data data) throws VisADException, RemoteException {
        return this.remainder(data);
    }

    public Data __neg__() throws VisADException, RemoteException {
        return this.negate();
    }

    public Data __add__(double d) throws VisADException, RemoteException {
        return this.__add__(new Real(d));
    }

    public Data __sub__(double d) throws VisADException, RemoteException {
        return this.__sub__(new Real(d));
    }

    public Data __mul__(double d) throws VisADException, RemoteException {
        return this.__mul__(new Real(d));
    }

    public Data __div__(double d) throws VisADException, RemoteException {
        return this.__div__(new Real(d));
    }

    public Data __pow__(double d) throws VisADException, RemoteException {
        return this.__pow__(new Real(d));
    }

    public Data __mod__(double d) throws VisADException, RemoteException {
        return this.__mod__(new Real(d));
    }

    public Object dataClone() {
        return this.clone();
    }

    public abstract Object clone();

    public String toString() {
        try {
            return this.longString("");
        }
        catch (VisADException visADException) {
            return visADException.toString();
        }
        catch (RemoteException remoteException) {
            return remoteException.toString();
        }
    }

    public String longString() throws VisADException, RemoteException {
        return this.longString("");
    }

    public String longString(String string) throws VisADException, RemoteException {
        throw new TypeException("DataImpl.longString");
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException {
        RealType[] realTypeArray = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Radius};
        RealTupleType realTupleType = new RealTupleType(realTypeArray);
        RealType realType = new RealType("vis_radiance", null, null);
        RealType realType2 = new RealType("ir_radiance", null, null);
        RealType[] realTypeArray2 = new RealType[]{realType, realType2};
        RealTupleType realTupleType2 = new RealTupleType(realTypeArray2);
        FunctionType functionType = new FunctionType(realTupleType, realTupleType2);
        int n = 6;
        float f = 2.5f;
        FlatField flatField = FlatField.makeField(functionType, n, false);
        RealType[] realTypeArray3 = new RealType[]{RealType.Latitude, RealType.Longitude, RealType.Radius, realType, realType2, RealType.Time};
        double[][] dArray = flatField.computeRanges(realTypeArray3);
        int n2 = 0;
        while (n2 < dArray.length) {
            System.out.println(realTypeArray3[n2] + ": " + dArray[n2][0] + " to " + dArray[n2][1]);
            ++n2;
        }
        System.out.println(" ");
        FunctionType functionType2 = new FunctionType(realTupleType2, RealType.Time);
        Integer2DSet integer2DSet = new Integer2DSet(2, 2);
        FlatField flatField2 = new FlatField(functionType2, integer2DSet);
        flatField2.setSamples(new float[][]{{0.0f, -1.0f, 1.0f, 2.0f}});
        dArray = flatField2.computeRanges(realTypeArray3);
        int n3 = 0;
        while (n3 < dArray.length) {
            System.out.println(realTypeArray3[n3] + ": " + dArray[n3][0] + " to " + dArray[n3][1]);
            ++n3;
        }
        System.exit(0);
    }

    public abstract boolean isMissing() throws VisADException, RemoteException;

    public abstract DataShadow computeRanges(ShadowType var1, DataShadow var2) throws VisADException, RemoteException;

    public DataImpl(MathType mathType) {
        this.Type = mathType;
        this.parent = null;
    }

    public class Syncher
    implements DisplayListener {
        public void displayChanged(DisplayEvent displayEvent) throws VisADException, RemoteException {
            if (displayEvent.getId() == 2) {
                Syncher syncher = this;
                synchronized (syncher) {
                    this.notify();
                }
            }
        }

        Syncher() {
            try {
                Syncher syncher = this;
                synchronized (syncher) {
                    rdisplay.addDisplayListener(this);
                    rdisplay.enableAction();
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            rdisplay.removeDisplayListener(this);
        }
    }
}

