/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.BadMappingException;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.GraphicsModeControl;
import visad.MathType;
import visad.ReferenceActionLink;
import visad.ScalarMap;
import visad.ShadowType;
import visad.UnimplementedException;
import visad.VisADException;

public class DataDisplayLink
extends ReferenceActionLink {
    private ShadowType shadow;
    private Data data;
    private Vector ConstantMapVector = new Vector();
    private DataRenderer renderer;
    private Vector SelectedMapVector = new Vector();
    private float[] defaultValues;
    boolean[] isTransform;
    public long start_time;
    public boolean time_flag;

    public DisplayImpl getDisplay() {
        return (DisplayImpl)this.local_action;
    }

    public DataRenderer getRenderer() {
        return this.renderer;
    }

    public Vector getSelectedMapVector() {
        return (Vector)this.SelectedMapVector.clone();
    }

    public void addSelectedMapVector(ScalarMap scalarMap) {
        Vector vector = this.SelectedMapVector;
        synchronized (vector) {
            if (!this.SelectedMapVector.contains(scalarMap)) {
                this.SelectedMapVector.addElement(scalarMap);
            }
        }
    }

    public void clearMaps() throws RemoteException, VisADException {
        Vector vector = this.ConstantMapVector;
        synchronized (vector) {
            Enumeration enumeration = this.ConstantMapVector.elements();
            while (enumeration.hasMoreElements()) {
                ConstantMap constantMap = (ConstantMap)enumeration.nextElement();
                constantMap.nullDisplay();
            }
            this.ConstantMapVector.removeAllElements();
        }
    }

    public boolean prepareData() throws VisADException, RemoteException {
        Object object;
        Enumeration enumeration;
        this.data = ((DataReference)this.ref).getData();
        if (this.data == null) {
            this.renderer.clearExceptions();
            this.renderer.addException(new DisplayException("Data is null"));
            return false;
        }
        MathType mathType = this.data.getType();
        this.SelectedMapVector.removeAllElements();
        int n = ((DisplayImpl)this.local_action).getDisplayScalarCount();
        this.defaultValues = new float[n];
        GraphicsModeControl graphicsModeControl = ((DisplayImpl)this.local_action).getGraphicsModeControl();
        int n2 = 0;
        while (n2 < n) {
            enumeration = ((DisplayImpl)this.local_action).getDisplayScalar(n2);
            this.defaultValues[n2] = (float)((DisplayRealType)((Object)enumeration)).getDefaultValue();
            if (Display.PointSize.equals(enumeration)) {
                this.defaultValues[n2] = graphicsModeControl.getPointSize();
            } else if (Display.LineWidth.equals(enumeration)) {
                this.defaultValues[n2] = graphicsModeControl.getLineWidth();
            }
            ++n2;
        }
        Vector vector = (Vector)((DisplayImpl)this.local_action).getConstantMapVector().clone();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (ConstantMap)enumeration.nextElement();
            this.defaultValues[((ScalarMap)object).getDisplayScalarIndex()] = (float)((ConstantMap)object).getConstant();
        }
        enumeration = ((Vector)this.ConstantMapVector.clone()).elements();
        while (enumeration.hasMoreElements()) {
            object = (ConstantMap)enumeration.nextElement();
            int n3 = ((ScalarMap)object).getDisplayScalarIndex();
            if (n3 < 0) continue;
            this.defaultValues[n3] = (float)((ConstantMap)object).getConstant();
        }
        try {
            this.renderer.clearExceptions();
            object = (DisplayImpl)this.local_action;
            this.shadow = mathType.buildShadowType(this, null);
            ShadowType shadowType = this.shadow.getAdaptedShadowType();
            int[] nArray = ShadowType.zeroIndices(((DisplayImpl)object).getScalarCount());
            int[] nArray2 = ShadowType.zeroIndices(((DisplayImpl)object).getDisplayScalarCount());
            int[] nArray3 = ShadowType.zeroIndices(((DisplayImpl)object).getValueArrayLength());
            int n4 = ((DisplayImpl)object).getNumberOfControls();
            this.isTransform = new boolean[n4];
            int n5 = 0;
            while (n5 < n4) {
                this.isTransform[n5] = false;
                ++n5;
            }
            int n6 = this.shadow.checkIndices(nArray, nArray2, nArray3, this.isTransform, 6);
            if (n6 == 1) {
                n5 = 0;
                while (n5 < n4) {
                    this.isTransform[n5] = true;
                    ++n5;
                }
            }
            this.renderer.checkDirect();
        }
        catch (BadMappingException badMappingException) {
            this.data = null;
            this.renderer.addException(badMappingException);
            return false;
        }
        catch (UnimplementedException unimplementedException) {
            this.data = null;
            this.renderer.addException(unimplementedException);
            return false;
        }
        catch (RemoteException remoteException) {
            this.data = null;
            this.renderer.addException(remoteException);
            return false;
        }
        return true;
    }

    public ShadowType getShadow() {
        return this.shadow;
    }

    public Data getData() throws VisADException, RemoteException {
        Data data = this.data;
        if (data == null) {
            data = ((DataReference)this.ref).getData();
        }
        this.data = data;
        return data;
    }

    public void clearData() {
        this.data = null;
    }

    public MathType getType() throws VisADException, RemoteException {
        Data data = this.getData();
        return data == null ? null : data.getType();
    }

    public float[] getDefaultValues() {
        return this.defaultValues;
    }

    public DataReference getDataReference() {
        return (DataReference)this.getThingReference();
    }

    public Vector getConstantMaps() {
        return this.ConstantMapVector;
    }

    public Vector getScalarMaps() {
        return this.SelectedMapVector;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataDisplayLink)) {
            return false;
        }
        DataDisplayLink dataDisplayLink = (DataDisplayLink)object;
        if (!this.getDataReference().equals(dataDisplayLink.getDataReference())) {
            return false;
        }
        return this.getDisplay().equals(dataDisplayLink.getDisplay());
    }

    public DataDisplayLink(DataReference dataReference, DisplayImpl displayImpl, Display display, ConstantMap[] constantMapArray, DataRenderer dataRenderer, long l) throws VisADException, RemoteException {
        super(dataReference, displayImpl, display, l);
        this.renderer = dataRenderer;
        if (constantMapArray != null) {
            int n = 0;
            while (n < constantMapArray.length) {
                Enumeration enumeration = ((Vector)this.ConstantMapVector.clone()).elements();
                while (enumeration.hasMoreElements()) {
                    ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                    if (!scalarMap.getDisplayScalar().equals(constantMapArray[n].getDisplayScalar())) continue;
                    throw new DisplayException("DataDisplayLink: two ConstantMap-s have the same DisplayScalar");
                }
                if (constantMapArray[n].getDisplay() != null && !ConstantMap.getAllowMultipleUseKludge()) {
                    throw new DisplayException(constantMapArray[n] + " already has a display\n" + "If this Exception breaks an existing app add a call to:\n" + "ConstantMap.setAllowMultipleUseKludge(true) at the " + "start of your app \n  OR you can stop reusing ConstantMaps");
                }
                constantMapArray[n].setDisplay(displayImpl);
                this.ConstantMapVector.addElement(constantMapArray[n]);
                displayImpl.addDisplayScalar(constantMapArray[n]);
                ++n;
            }
        }
    }
}

