/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import visad.CoordinateSystemException;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.RealTupleType;
import visad.Set;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;

public abstract class CoordinateSystem
implements Serializable {
    private final RealTupleType Reference;
    private final int DomainDimension;
    private final Unit[] CoordinateSystemUnits;

    public RealTupleType getReference() {
        return this.Reference;
    }

    public int getDimension() {
        return this.DomainDimension;
    }

    public Unit[] getReferenceUnits() {
        return this.Reference.getDefaultUnits();
    }

    public Unit[] getCoordinateSystemUnits() {
        return Unit.copyUnitsArray(this.CoordinateSystemUnits);
    }

    public abstract double[][] toReference(double[][] var1) throws VisADException;

    public abstract double[][] fromReference(double[][] var1) throws VisADException;

    public float[][] toReference(float[][] fArray) throws VisADException {
        double[][] dArray = Set.floatToDouble(fArray);
        dArray = this.toReference(dArray);
        return Set.doubleToFloat(dArray);
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        double[][] dArray = Set.floatToDouble(fArray);
        dArray = this.fromReference(dArray);
        return Set.doubleToFloat(dArray);
    }

    public static boolean canConvert(RealTupleType realTupleType, CoordinateSystem coordinateSystem, RealTupleType realTupleType2, CoordinateSystem coordinateSystem2) {
        if (realTupleType == null) {
            return realTupleType2 == null;
        }
        if (realTupleType.equals(realTupleType2)) {
            return true;
        }
        RealTupleType realTupleType3 = realTupleType;
        if (coordinateSystem != null) {
            realTupleType3 = coordinateSystem.getReference();
        }
        RealTupleType realTupleType4 = realTupleType2;
        if (coordinateSystem2 != null) {
            realTupleType4 = coordinateSystem2.getReference();
        }
        return realTupleType3.equals(realTupleType4);
    }

    public static double[][] transformCoordinates(RealTupleType realTupleType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, RealTupleType realTupleType2, CoordinateSystem coordinateSystem2, Unit[] unitArray2, ErrorEstimate[] errorEstimateArray2, double[][] dArray) throws VisADException {
        int n = realTupleType.getDimension();
        Unit[] unitArray3 = new Unit[n];
        double[][] dArray2 = dArray;
        if ((dArray = CoordinateSystem.transformCoordinatesFreeUnits(realTupleType, coordinateSystem, unitArray3, errorEstimateArray, realTupleType2, coordinateSystem2, unitArray2, errorEstimateArray2, dArray)) == dArray2) {
            dArray = new double[n][];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = dArray2[n2];
                ++n2;
            }
        }
        ErrorEstimate[] errorEstimateArray3 = new ErrorEstimate[1];
        if (errorEstimateArray == null) {
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = Unit.transformUnits(unitArray[n3], errorEstimateArray3, unitArray3[n3], null, dArray[n3]);
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                dArray[n4] = Unit.transformUnits(unitArray[n4], errorEstimateArray3, unitArray3[n4], errorEstimateArray[n4], dArray[n4]);
                errorEstimateArray[n4] = errorEstimateArray3[0];
                ++n4;
            }
        }
        return dArray;
    }

    public static double[][] transformCoordinatesFreeUnits(RealTupleType realTupleType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, RealTupleType realTupleType2, CoordinateSystem coordinateSystem2, Unit[] unitArray2, ErrorEstimate[] errorEstimateArray2, double[][] dArray) throws VisADException {
        Unit[] unitArray3;
        int n;
        int n2 = realTupleType2.getDimension();
        double[][] dArray2 = new double[1][1];
        boolean bl = false;
        boolean bl2 = false;
        if (errorEstimateArray2 != null && errorEstimateArray != null) {
            bl2 = true;
            n = 0;
            while (n < n2) {
                if (errorEstimateArray2[n] == null) {
                    bl2 = false;
                }
                ++n;
            }
        }
        if (errorEstimateArray != null) {
            if (errorEstimateArray2 != null) {
                n = 0;
                while (n < n2) {
                    errorEstimateArray[n] = errorEstimateArray2[n];
                    ++n;
                }
            } else {
                n = 0;
                while (n < n2) {
                    errorEstimateArray[n] = null;
                    ++n;
                }
            }
        }
        if ((unitArray3 = Unit.copyUnitsArray(unitArray2)) == null) {
            unitArray3 = new Unit[n2];
        }
        Unit[] unitArray4 = Unit.copyUnitsArray(unitArray3);
        if (unitArray != null) {
            int n3 = 0;
            while (n3 < n2) {
                unitArray[n3] = unitArray3[n3];
                ++n3;
            }
        }
        if (coordinateSystem == null) {
            coordinateSystem = realTupleType.getCoordinateSystem();
        }
        if (coordinateSystem2 == null) {
            coordinateSystem2 = realTupleType2.getCoordinateSystem();
        }
        if (realTupleType.equals(realTupleType2)) {
            if (coordinateSystem2 == null && coordinateSystem == null) {
                return dArray;
            }
            if (coordinateSystem2 == null || coordinateSystem == null) {
                throw new CoordinateSystemException("CoordinateSystem.transformCoordinates: inconsistency");
            }
            if (!coordinateSystem2.equals(coordinateSystem)) {
                if (bl2) {
                    if (!bl) {
                        dArray2 = ErrorEstimate.init_error_values(errorEstimateArray2);
                    }
                    bl = true;
                    dArray2 = coordinateSystem2.toReference(dArray2, unitArray4);
                    dArray2 = coordinateSystem.fromReference(dArray2, unitArray4);
                }
                dArray = coordinateSystem2.toReference(dArray, unitArray3);
                dArray = coordinateSystem.fromReference(dArray, unitArray3);
            }
        } else {
            RealTupleType realTupleType3 = realTupleType;
            if (coordinateSystem != null) {
                realTupleType3 = coordinateSystem.getReference();
                if (realTupleType.getCoordinateSystem() == null || !realTupleType.getCoordinateSystem().getReference().equals(realTupleType3)) {
                    throw new CoordinateSystemException("CoordinateSystem.transformCoordinates: out Reference-s don't match");
                }
            }
            RealTupleType realTupleType4 = realTupleType2;
            if (coordinateSystem2 != null) {
                realTupleType4 = coordinateSystem2.getReference();
                if (realTupleType2.getCoordinateSystem() == null || !realTupleType2.getCoordinateSystem().getReference().equals(realTupleType4)) {
                    throw new CoordinateSystemException("CoordinateSystem.transformCoordinates: in Reference-s don't match");
                }
            }
            if (realTupleType3.equals(realTupleType4)) {
                if (!realTupleType2.equals(realTupleType4)) {
                    if (bl2) {
                        if (!bl) {
                            dArray2 = ErrorEstimate.init_error_values(errorEstimateArray2);
                        }
                        bl = true;
                        dArray2 = coordinateSystem2.toReference(dArray2, unitArray4);
                    }
                    dArray = coordinateSystem2.toReference(dArray, unitArray3);
                }
                if (!realTupleType.equals(realTupleType3)) {
                    if (bl2) {
                        if (!bl) {
                            dArray2 = ErrorEstimate.init_error_values(errorEstimateArray2);
                        }
                        bl = true;
                        dArray2 = coordinateSystem.fromReference(dArray2, unitArray4);
                    }
                    dArray = coordinateSystem.fromReference(dArray, unitArray3);
                }
            }
        }
        if (unitArray != null) {
            int n4 = 0;
            while (n4 < n2) {
                unitArray[n4] = unitArray3[n4];
                ++n4;
            }
        }
        if (bl2 && bl) {
            int n5 = 0;
            while (n5 < n2) {
                double d = Math.abs(dArray2[n5][2 * n5 + 1] - dArray2[n5][2 * n5]);
                errorEstimateArray[n5] = new ErrorEstimate(dArray[n5], d, unitArray[n5]);
                ++n5;
            }
        }
        return dArray;
    }

    public static float[][] transformCoordinates(RealTupleType realTupleType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, RealTupleType realTupleType2, CoordinateSystem coordinateSystem2, Unit[] unitArray2, ErrorEstimate[] errorEstimateArray2, float[][] fArray) throws VisADException {
        int n = realTupleType.getDimension();
        Unit[] unitArray3 = new Unit[n];
        fArray = CoordinateSystem.transformCoordinatesFreeUnits(realTupleType, coordinateSystem, unitArray3, errorEstimateArray, realTupleType2, coordinateSystem2, unitArray2, errorEstimateArray2, fArray);
        ErrorEstimate[] errorEstimateArray3 = new ErrorEstimate[1];
        double[][] dArray = Set.floatToDouble(fArray);
        if (errorEstimateArray == null) {
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = Unit.transformUnits(unitArray[n2], errorEstimateArray3, unitArray3[n2], null, dArray[n2]);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = Unit.transformUnits(unitArray[n3], errorEstimateArray3, unitArray3[n3], errorEstimateArray[n3], dArray[n3]);
                errorEstimateArray[n3] = errorEstimateArray3[0];
                ++n3;
            }
        }
        fArray = Set.doubleToFloat(dArray);
        return fArray;
    }

    public static float[][] transformCoordinatesFreeUnits(RealTupleType realTupleType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, RealTupleType realTupleType2, CoordinateSystem coordinateSystem2, Unit[] unitArray2, ErrorEstimate[] errorEstimateArray2, float[][] fArray) throws VisADException {
        return Set.doubleToFloat(CoordinateSystem.transformCoordinatesFreeUnits(realTupleType, coordinateSystem, unitArray, errorEstimateArray, realTupleType2, coordinateSystem2, unitArray2, errorEstimateArray2, Set.floatToDouble(fArray)));
    }

    public double[][] toReference(double[][] dArray, Unit[] unitArray) throws VisADException {
        Unit[] unitArray2;
        int n = dArray.length;
        if (this.CoordinateSystemUnits != null) {
            int n2 = 0;
            while (n2 < n) {
                if (this.CoordinateSystemUnits[n2] != null) {
                    dArray[n2] = this.CoordinateSystemUnits[n2].toThis(dArray[n2], unitArray[n2]);
                }
                ++n2;
            }
        }
        if ((unitArray2 = this.Reference.getDefaultUnits()) != null) {
            int n3 = 0;
            while (n3 < n) {
                unitArray[n3] = unitArray2[n3];
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < n) {
                unitArray[n4] = null;
                ++n4;
            }
        }
        return this.toReference(dArray);
    }

    public double[][] fromReference(double[][] dArray, Unit[] unitArray) throws VisADException {
        int n;
        int n2 = dArray.length;
        Unit[] unitArray2 = this.Reference.getDefaultUnits();
        if (unitArray2 != null) {
            n = 0;
            while (n < n2) {
                if (unitArray2[n] != null) {
                    dArray[n] = unitArray2[n].toThis(dArray[n], unitArray[n]);
                }
                ++n;
            }
        }
        if (this.CoordinateSystemUnits != null) {
            n = 0;
            while (n < n2) {
                unitArray[n] = this.CoordinateSystemUnits[n];
                ++n;
            }
        } else {
            n = 0;
            while (n < n2) {
                unitArray[n] = null;
                ++n;
            }
        }
        return this.fromReference(dArray);
    }

    public boolean checkTable(FlatField flatField) throws VisADException {
        if (flatField == null) {
            throw new CoordinateSystemException("CoordinateSystem.checkTable: table is null");
        }
        return ((FunctionType)flatField.getType()).getDomain().getDimension() != this.DomainDimension || ((RealTupleType)((FunctionType)flatField.getType()).getRange()).getDimension() != this.DomainDimension;
    }

    public abstract boolean equals(Object var1);

    public CoordinateSystem(RealTupleType realTupleType, Unit[] unitArray) throws VisADException {
        if (realTupleType == null) {
            throw new CoordinateSystemException("CoordinateSystem: Reference may not be null");
        }
        if (realTupleType.getCoordinateSystem() != null) {
            throw new CoordinateSystemException("CoordinateSystem: Reference may not have a DefaultCoordinateSystem");
        }
        this.Reference = realTupleType;
        this.DomainDimension = this.Reference.getDimension();
        if (unitArray != null && this.DomainDimension != unitArray.length) {
            throw new UnitException("CoordinateSystem: units dimension does not match");
        }
        this.CoordinateSystemUnits = new Unit[this.DomainDimension];
        if (unitArray != null) {
            int n = 0;
            while (n < this.DomainDimension) {
                this.CoordinateSystemUnits[n] = unitArray[n];
                ++n;
            }
        }
    }

    CoordinateSystem(RealTupleType realTupleType, Unit[] unitArray, boolean bl) {
        this.Reference = realTupleType;
        this.DomainDimension = this.Reference.getDimension();
        this.CoordinateSystemUnits = new Unit[this.DomainDimension];
        if (unitArray != null) {
            int n = 0;
            while (n < this.DomainDimension) {
                this.CoordinateSystemUnits[n] = unitArray[n];
                ++n;
            }
        }
    }
}

