/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.CommonUnit;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.Real;
import visad.RealType;
import visad.ScalarMap;
import visad.Set;
import visad.Unit;
import visad.VisADException;

public abstract class Control
implements Cloneable,
Serializable {
    private long NewTick = -9223372036854775807L;
    private long OldTick;
    private boolean tickFlag = false;
    private boolean isSet = false;
    transient DisplayImpl display;
    transient DisplayRenderer displayRenderer;
    private int Index;
    private int Instance;
    private transient Vector ListenerVector = new Vector();

    public DisplayRenderer getDisplayRenderer() {
        return this.displayRenderer;
    }

    public void changeControl(boolean bl) throws VisADException, RemoteException {
        if (bl) {
            this.incTick();
        }
        if (this.ListenerVector != null) {
            Vector vector = null;
            Vector vector2 = this.ListenerVector;
            synchronized (vector2) {
                vector = (Vector)this.ListenerVector.clone();
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ControlListener controlListener = (ControlListener)enumeration.nextElement();
                controlListener.controlChanged(new ControlEvent(this));
            }
        }
    }

    public void addControlListener(ControlListener controlListener) {
        this.ListenerVector.addElement(controlListener);
    }

    public void removeControlListener(ControlListener controlListener) {
        if (controlListener != null) {
            this.ListenerVector.removeElement(controlListener);
        }
    }

    public void nullControl() {
        this.ListenerVector.removeAllElements();
    }

    public long incTick() {
        ++this.NewTick;
        if (this.NewTick == Long.MAX_VALUE) {
            this.NewTick = -9223372036854775807L;
        }
        if (this.display != null) {
            this.display.controlChanged();
        }
        return this.NewTick;
    }

    public synchronized void setTicks() {
        if (this.isSet) {
            return;
        }
        this.isSet = true;
        this.tickFlag = this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick;
        this.OldTick = this.NewTick;
        this.subSetTicks();
    }

    public synchronized boolean peekTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        return (this.OldTick < this.NewTick || this.NewTick < 0L && 0L < this.OldTick) && dataRenderer.isTransformControl(this, dataDisplayLink) || this.subPeekTicks(dataRenderer, dataDisplayLink);
    }

    public synchronized boolean checkTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        return this.tickFlag && dataRenderer.isTransformControl(this, dataDisplayLink) || this.subCheckTicks(dataRenderer, dataDisplayLink);
    }

    public synchronized void resetTicks() {
        this.tickFlag = false;
        this.subResetTicks();
        this.isSet = false;
    }

    public void subSetTicks() {
    }

    public boolean subCheckTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        return false;
    }

    public boolean subPeekTicks(DataRenderer dataRenderer, DataDisplayLink dataDisplayLink) {
        return false;
    }

    public void subResetTicks() {
    }

    public void animation_string(RealType realType, Set set, double d, int n) throws VisADException {
        Object object;
        Unit[] unitArray = set.getSetUnits();
        Vector vector = this.display.getMapVector();
        Unit unit = null;
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (ScalarMap)vector.elementAt(n2);
            Control control = ((ScalarMap)object).getControl();
            if (this.equals(control)) {
                unit = ((ScalarMap)object).getOverrideUnit();
            }
            ++n2;
        }
        if (!(unit == null || unitArray == null || unit.equals(unitArray[0]) || Unit.canConvert(unitArray[0], CommonUnit.secondsSinceTheEpoch) && !unitArray[0].getAbsoluteUnit().equals(unitArray[0]))) {
            d = unit.toThis(d, unitArray[0]);
            unitArray[0] = unit;
        }
        String string = realType.getName() + " = " + new Real(realType, d, unitArray == null ? null : unitArray[0]).toValueString();
        object = Integer.toString(n + 1) + " of " + Integer.toString(set.getLength());
        this.getDisplayRenderer().setAnimationString(new String[]{string, object});
    }

    void setIndex(int n) {
        this.Index = n;
    }

    int getIndex() {
        return this.Index;
    }

    void setInstanceNumber(int n) {
        this.Instance = n;
    }

    public int getInstanceNumber() {
        return this.Instance;
    }

    public DisplayImpl getDisplay() {
        return this.display;
    }

    public abstract String getSaveString();

    public abstract void setSaveString(String var1) throws VisADException, RemoteException;

    public abstract void syncControl(Control var1) throws VisADException;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().isInstance(object)) {
            return false;
        }
        return this.Instance == ((Control)object).Instance;
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(36);
        if (n2 > n) {
            n = n2;
        }
        n = n == -1 ? 0 : ++n;
        return string.substring(n) + "@" + this.Index + "#" + this.Instance;
    }

    public Control(DisplayImpl displayImpl) {
        this.OldTick = Long.MIN_VALUE;
        this.display = displayImpl;
        this.Instance = -1;
        this.Index = -1;
        if (this.display != null) {
            this.displayRenderer = this.display.getDisplayRenderer();
        }
    }
}

