/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Contour2D;
import visad.Control;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public class ContourControl
extends Control {
    private boolean mainContours = true;
    private float surfaceValue = Float.NaN;
    private float contourInterval = Float.NaN;
    private float lowLimit = Float.NaN;
    private float hiLimit = Float.NaN;
    private float base = Float.NaN;
    private boolean labels = false;
    private boolean arithmeticProgression = true;
    private float[] levels = null;
    private boolean dash = false;
    private boolean horizontalContourSlice = false;
    private boolean verticalContourSlice = false;
    private float horizontalSliceLow = Float.NaN;
    private float horizontalSliceHi = Float.NaN;
    private float horizontalSliceStep = Float.NaN;
    private float verticalSliceLow = Float.NaN;
    private float verticalSliceHi = Float.NaN;
    private float verticalSliceStep = Float.NaN;
    private boolean in = false;

    void setMainContours(boolean[] blArray, float[] fArray) throws VisADException, RemoteException {
        this.setMainContours(blArray, fArray, false, false);
    }

    void setMainContours(boolean[] blArray, float[] fArray, boolean bl) throws VisADException, RemoteException {
        this.setMainContours(blArray, fArray, bl, false);
    }

    void setMainContours(boolean[] blArray, float[] fArray, boolean bl, boolean bl2) throws VisADException, RemoteException {
        if (fArray == null || fArray.length != 5 || blArray == null || blArray.length != 2) {
            throw new DisplayException("ContourControl.setMainContours: bad array length");
        }
        this.mainContours = blArray[0];
        this.labels = blArray[1];
        if (bl2) {
            this.surfaceValue = fArray[0];
            this.contourInterval = fArray[1];
            this.lowLimit = fArray[2];
            this.hiLimit = fArray[3];
            this.base = fArray[4];
        } else {
            if (this.surfaceValue != this.surfaceValue) {
                this.surfaceValue = fArray[0];
            }
            if (this.contourInterval != this.contourInterval) {
                this.contourInterval = fArray[1];
            }
            if (this.lowLimit != this.lowLimit) {
                this.lowLimit = fArray[2];
            }
            if (this.hiLimit != this.hiLimit) {
                this.hiLimit = fArray[3];
            }
            if (this.base != this.base) {
                this.base = fArray[4];
            }
        }
        if (this.arithmeticProgression) {
            if (this.contourInterval == this.contourInterval && this.base == this.base && this.lowLimit == this.lowLimit && this.hiLimit == this.hiLimit) {
                boolean[] blArray2 = new boolean[]{false};
                float[] fArray2 = Contour2D.intervalToLevels(this.contourInterval, this.lowLimit, this.hiLimit, this.base, blArray2);
                this.setLevels(fArray2, this.base, blArray2[0], false);
                this.arithmeticProgression = true;
            } else {
                this.dash = false;
                this.levels = null;
            }
        }
        this.changeControl(!bl);
    }

    public void setSurfaceValue(float f) throws VisADException, RemoteException {
        boolean bl = !Util.isApproximatelyEqual(this.surfaceValue, f);
        this.surfaceValue = f;
        if (bl) {
            this.changeControl(true);
        }
    }

    public void setContourInterval(float f, float f2, float f3, float f4) throws VisADException, RemoteException {
        boolean bl = this.contourInterval != f || this.base != f4 || !Util.isApproximatelyEqual(this.lowLimit, f2) || !Util.isApproximatelyEqual(this.hiLimit, f3);
        this.contourInterval = f;
        this.lowLimit = f2;
        this.hiLimit = f3;
        this.base = f4;
        boolean[] blArray = new boolean[]{false};
        float[] fArray = Contour2D.intervalToLevels(this.contourInterval, this.lowLimit, this.hiLimit, this.base, blArray);
        this.setLevels(fArray, this.base, blArray[0], bl);
        this.arithmeticProgression = true;
        if (bl) {
            this.changeControl(true);
        }
    }

    public void setContourLimits(float f, float f2) throws VisADException, RemoteException {
        if (!this.in) {
            this.in = true;
            boolean bl = !Util.isApproximatelyEqual(this.lowLimit, f) || !Util.isApproximatelyEqual(this.hiLimit, f2);
            this.lowLimit = f;
            this.hiLimit = f2;
            if (this.arithmeticProgression) {
                boolean[] blArray = new boolean[]{false};
                float[] fArray = Contour2D.intervalToLevels(this.contourInterval, this.lowLimit, this.hiLimit, this.base, blArray);
                this.setLevels(fArray, this.base, blArray[0], false);
            } else {
                int n = 0;
                int n2 = 0;
                while (n2 < this.levels.length) {
                    if (this.lowLimit < this.levels[n2] && this.levels[n2] < this.hiLimit) {
                        ++n;
                    }
                    ++n2;
                }
                if (n != this.levels.length) {
                    float[] fArray = new float[n];
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < this.levels.length) {
                        if (this.lowLimit < this.levels[n4] && this.levels[n4] < this.hiLimit) {
                            fArray[n3++] = this.levels[n4];
                        }
                        ++n4;
                    }
                    this.levels = fArray;
                } else {
                    bl = false;
                }
            }
            if (bl) {
                this.changeControl(true);
            }
            this.in = false;
        }
    }

    public void setLevels(float[] fArray, float f, boolean bl) throws VisADException, RemoteException {
        this.setLevels(fArray, f, bl, true);
    }

    private void setLevels(float[] fArray, float f, boolean bl, boolean bl2) throws VisADException, RemoteException {
        if (fArray == null) {
            return;
        }
        this.levels = new float[fArray.length];
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        int n = 0;
        while (n < fArray.length) {
            if (fArray[n] < f2) {
                f2 = fArray[n];
            }
            if (fArray[n] > f3) {
                f3 = fArray[n];
            }
            this.levels[n] = fArray[n];
            ++n;
        }
        this.dash = bl;
        this.base = f;
        if (bl2) {
            this.lowLimit = f2 - Math.abs(0.01f * f2);
            this.hiLimit = f3 + Math.abs(0.01f * f3);
            this.arithmeticProgression = false;
            this.changeControl(true);
        }
    }

    public float[] getLevels(float[] fArray, boolean[] blArray) {
        float[] fArray2 = null;
        if (this.levels != null) {
            fArray2 = new float[this.levels.length];
            System.arraycopy(this.levels, 0, fArray2, 0, this.levels.length);
        }
        fArray[0] = this.lowLimit;
        fArray[1] = this.hiLimit;
        fArray[2] = this.base;
        blArray[0] = this.dash;
        return fArray2;
    }

    public void enableLabels(boolean bl) throws VisADException, RemoteException {
        boolean bl2 = this.labels != bl;
        this.labels = bl;
        if (bl2) {
            this.changeControl(true);
        }
    }

    public void enableContours(boolean bl) throws VisADException, RemoteException {
        boolean bl2 = this.mainContours != bl;
        this.mainContours = bl;
        if (bl2) {
            this.changeControl(true);
        }
    }

    public void getMainContours(boolean[] blArray, float[] fArray) throws VisADException {
        if (fArray == null || fArray.length != 5 || blArray == null || blArray.length != 2) {
            throw new DisplayException("ContourControl.getMainContours: bad array length");
        }
        blArray[0] = this.mainContours;
        blArray[1] = this.labels;
        fArray[0] = this.surfaceValue;
        fArray[1] = this.contourInterval;
        fArray[2] = this.lowLimit;
        fArray[3] = this.hiLimit;
        fArray[4] = this.base;
    }

    public String getSaveString() {
        return this.mainContours + " " + this.labels + " " + this.surfaceValue + " " + this.contourInterval + " " + this.lowLimit + " " + this.hiLimit + " " + this.base;
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        if (string == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 7) {
            throw new VisADException("Invalid save string");
        }
        boolean[] blArray = new boolean[2];
        float[] fArray = new float[5];
        int n = 0;
        while (n < 2) {
            blArray[n] = Convert.getBoolean(stringTokenizer.nextToken());
            ++n;
        }
        n = 0;
        while (n < 5) {
            fArray[n] = Convert.getFloat(stringTokenizer.nextToken());
            ++n;
        }
        this.setMainContours(blArray, fArray, false, true);
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof ContourControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        ContourControl contourControl = (ContourControl)control;
        boolean bl = false;
        if (this.mainContours != contourControl.mainContours) {
            bl = true;
            this.mainContours = contourControl.mainContours;
        }
        if (!Util.isApproximatelyEqual(this.surfaceValue, contourControl.surfaceValue)) {
            bl = true;
            this.surfaceValue = contourControl.surfaceValue;
        }
        if (!Util.isApproximatelyEqual(this.contourInterval, contourControl.contourInterval)) {
            bl = true;
            this.contourInterval = contourControl.contourInterval;
        }
        if (!Util.isApproximatelyEqual(this.lowLimit, contourControl.lowLimit)) {
            bl = true;
            this.lowLimit = contourControl.lowLimit;
        }
        if (!Util.isApproximatelyEqual(this.hiLimit, contourControl.hiLimit)) {
            bl = true;
            this.hiLimit = contourControl.hiLimit;
        }
        if (!Util.isApproximatelyEqual(this.base, contourControl.base)) {
            bl = true;
            this.base = contourControl.base;
        }
        if (this.labels != contourControl.labels) {
            bl = true;
            this.labels = contourControl.labels;
        }
        if (this.arithmeticProgression != contourControl.arithmeticProgression) {
            bl = true;
            this.arithmeticProgression = contourControl.arithmeticProgression;
        }
        if (contourControl.levels == null) {
            if (this.levels != null) {
                bl = true;
                this.levels = null;
            }
        } else {
            int n;
            if (this.levels == null || this.levels.length != contourControl.levels.length) {
                bl = true;
                this.levels = new float[contourControl.levels.length];
                n = 0;
                while (n < this.levels.length) {
                    this.levels[n] = 0.0f;
                    ++n;
                }
            }
            n = 0;
            while (n < this.levels.length) {
                if (!Util.isApproximatelyEqual(this.levels[n], contourControl.levels[n])) {
                    bl = true;
                    this.levels[n] = contourControl.levels[n];
                }
                ++n;
            }
        }
        if (this.dash != contourControl.dash) {
            bl = true;
            this.dash = contourControl.dash;
        }
        if (this.horizontalContourSlice != contourControl.horizontalContourSlice) {
            bl = true;
            this.horizontalContourSlice = contourControl.horizontalContourSlice;
        }
        if (this.verticalContourSlice != contourControl.verticalContourSlice) {
            bl = true;
            this.verticalContourSlice = contourControl.verticalContourSlice;
        }
        if (!Util.isApproximatelyEqual(this.horizontalSliceLow, contourControl.horizontalSliceLow)) {
            bl = true;
            this.horizontalSliceLow = contourControl.horizontalSliceLow;
        }
        if (!Util.isApproximatelyEqual(this.horizontalSliceHi, contourControl.horizontalSliceHi)) {
            bl = true;
            this.horizontalSliceHi = contourControl.horizontalSliceHi;
        }
        if (!Util.isApproximatelyEqual(this.horizontalSliceStep, contourControl.horizontalSliceStep)) {
            bl = true;
            this.horizontalSliceStep = contourControl.horizontalSliceStep;
        }
        if (!Util.isApproximatelyEqual(this.verticalSliceLow, contourControl.verticalSliceLow)) {
            bl = true;
            this.verticalSliceLow = contourControl.verticalSliceLow;
        }
        if (!Util.isApproximatelyEqual(this.verticalSliceHi, contourControl.verticalSliceHi)) {
            bl = true;
            this.verticalSliceHi = contourControl.verticalSliceHi;
        }
        if (!Util.isApproximatelyEqual(this.verticalSliceStep, contourControl.verticalSliceStep)) {
            bl = true;
            this.verticalSliceStep = contourControl.verticalSliceStep;
        }
        if (bl) {
            try {
                this.changeControl(true);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ContourControl contourControl = (ContourControl)object;
        if (this.mainContours != contourControl.mainContours) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.surfaceValue, contourControl.surfaceValue)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.contourInterval, contourControl.contourInterval)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.lowLimit, contourControl.lowLimit)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.hiLimit, contourControl.hiLimit)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.base, contourControl.base)) {
            return false;
        }
        if (this.labels != contourControl.labels) {
            return false;
        }
        if (this.arithmeticProgression != contourControl.arithmeticProgression) {
            return false;
        }
        if (this.levels == null) {
            if (contourControl.levels != null) {
                return false;
            }
        } else {
            if (contourControl.levels == null || this.levels.length != contourControl.levels.length) {
                return false;
            }
            int n = 0;
            while (n < this.levels.length) {
                if (!Util.isApproximatelyEqual(this.levels[n], contourControl.levels[n])) {
                    return false;
                }
                ++n;
            }
        }
        if (this.dash != contourControl.dash) {
            return false;
        }
        if (this.horizontalContourSlice != contourControl.horizontalContourSlice) {
            return false;
        }
        if (this.verticalContourSlice != contourControl.verticalContourSlice) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.horizontalSliceLow, contourControl.horizontalSliceLow)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.horizontalSliceHi, contourControl.horizontalSliceHi)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.horizontalSliceStep, contourControl.horizontalSliceStep)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.verticalSliceLow, contourControl.verticalSliceLow)) {
            return false;
        }
        if (!Util.isApproximatelyEqual(this.verticalSliceHi, contourControl.verticalSliceHi)) {
            return false;
        }
        return Util.isApproximatelyEqual(this.verticalSliceStep, contourControl.verticalSliceStep);
    }

    public Object clone() {
        ContourControl contourControl = (ContourControl)super.clone();
        if (this.levels != null) {
            contourControl.levels = (float[])this.levels.clone();
        }
        return contourControl;
    }

    public ContourControl(DisplayImpl displayImpl) {
        super(displayImpl);
    }
}

