/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import visad.PlotDigits;
import visad.SetException;
import visad.VisADException;

public class Contour2D
extends Applet
implements MouseListener {
    protected Contour2D con;
    protected int whichlabels = 0;
    protected boolean showgrid;
    protected int rows;
    protected int cols;
    protected int scale;
    protected int[] num1;
    protected int[] num2;
    protected int[] num3;
    protected int[] num4;
    protected float[][] vx1;
    protected float[][] vy1;
    protected float[][] vx2;
    protected float[][] vy2;
    protected float[][] vx3;
    protected float[][] vy3;
    protected float[][] vx4;
    protected float[][] vy4;

    public static void contour(float[] fArray, int n, int n2, float f, float f2, float f3, float f4, float[][] fArray2, float[][] fArray3, int n3, int[] nArray, float[][] fArray4, float[][] fArray5, int n4, int[] nArray2, float[][] fArray6, float[][] fArray7, int n5, int[] nArray3, float[][] fArray8, float[][] fArray9, int n6, int[] nArray4, byte[][] byArray, byte[][] byArray2, byte[][] byArray3, byte[][] byArray4, boolean[] blArray) throws VisADException {
        boolean[] blArray2 = new boolean[]{false};
        float[] fArray10 = Contour2D.intervalToLevels(f, f2, f3, f4, blArray2);
        boolean bl = blArray2[0];
        Contour2D.contour(fArray, n, n2, fArray10, f2, f3, f4, bl, fArray2, fArray3, n3, nArray, fArray4, fArray5, n4, nArray2, fArray6, fArray7, n5, nArray3, fArray8, fArray9, n6, nArray4, byArray, byArray2, byArray3, byArray4, blArray);
    }

    public static float[] intervalToLevels(float f, float f2, float f3, float f4, boolean[] blArray) throws VisADException {
        float[] fArray = null;
        if ((double)f == 0.0) {
            throw new VisADException("Contour interval cannot be zero");
        }
        blArray[0] = false;
        if (f < 0.0f) {
            blArray[0] = true;
            f = -f;
        }
        long l = Math.round(Math.ceil((f2 - f4) / Math.abs(f)));
        long l2 = Math.round(Math.floor((f3 - f4) / Math.abs(f)));
        int n = (int)(l2 - l) + 1;
        if (n < 1) {
            return fArray;
        }
        if (n > 1000) {
            throw new VisADException("Contour interval too small");
        }
        try {
            fArray = new float[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new VisADException("Contour interval too small");
        }
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = f4 + (float)(l + (long)n2) * f;
            ++n2;
        }
        return fArray;
    }

    public static void contour(float[] fArray, int n, int n2, float[] fArray2, float f, float f2, float f3, boolean bl, float[][] fArray3, float[][] fArray4, int n3, int[] nArray, float[][] fArray5, float[][] fArray6, int n4, int[] nArray2, float[][] fArray7, float[][] fArray8, int n5, int[] nArray3, float[][] fArray9, float[][] fArray10, int n6, int[] nArray4, byte[][] byArray, byte[][] byArray2, byte[][] byArray3, byte[][] byArray4, boolean[] blArray) throws VisADException {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        PlotDigits plotDigits = new PlotDigits();
        int n12 = n3 + n4;
        float[] fArray11 = new float[n12];
        float[] fArray12 = new float[n12];
        int[] nArray5 = new int[n * n2 + 4];
        float[] fArray13 = null;
        if (fArray2 != null) {
            fArray13 = (float[])fArray2.clone();
            Arrays.sort(fArray13);
        }
        byte[][] byArray5 = null;
        int n13 = n11 = byArray != null ? byArray.length : 0;
        if (n11 > 0) {
            if (byArray2 == null || byArray2.length != n11 || byArray3 == null || byArray3.length != n11 || byArray4 == null || byArray4.length != n11) {
                throw new SetException("Contour2D.contour: auxLevels length doesn't match");
            }
            int n14 = 0;
            while (n14 < n11) {
                if (byArray[n14].length != fArray.length) {
                    throw new SetException("Contour2D.contour: auxValues lengths don't match");
                }
                ++n14;
            }
            byArray5 = new byte[n11][n12];
        } else if (byArray2 != null || byArray3 != null || byArray4 != null) {
            throw new SetException("Contour2D.contour: auxValues null but auxLevels not null");
        }
        nArray[0] = 0;
        nArray2[0] = 0;
        nArray3[0] = 0;
        nArray4[0] = 0;
        if (fArray2 == null) {
            return;
        }
        int n15 = n - 1;
        int n16 = n2 - 1;
        float f4 = ((float)(n - 1) - 0.0f) / ((float)n - 1.0f);
        float f5 = ((float)(n2 - 1) - 0.0f) / ((float)n2 - 1.0f);
        float f6 = f4 - 1.0E-4f;
        float f7 = f5 - 1.0E-4f;
        if (blArray[0]) {
            n10 = 1 + (n - 2) / 10;
            n9 = 1 + (n2 - 2) / 50;
        } else {
            n10 = 1 + (n - 2) / 50;
            n9 = 1 + (n2 - 2) / 10;
        }
        int n17 = n9 / 2;
        int n18 = n10 / 2;
        int n19 = 1 + (n - 2) / 8;
        int n20 = 1 + (n2 - 2) / 8;
        char[] cArray = new char[n * n2];
        int n21 = 0;
        while (n21 < n * n2) {
            cArray[n21] = '\u0000';
            ++n21;
        }
        int n22 = 0;
        while (n22 < n2) {
            n8 = 0;
            while (n8 < n10) {
                cArray[n22 * n + n8] = '\u0001';
                cArray[n22 * n + (n - n8 - 2)] = '\u0001';
                ++n8;
            }
            ++n22;
        }
        n8 = 0;
        while (n8 < n) {
            n22 = 0;
            while (n22 < n9) {
                cArray[n22 * n + n8] = '\u0001';
                cArray[(n2 - n22 - 2) * n + n8] = '\u0001';
                ++n22;
            }
            ++n8;
        }
        int n23 = 0;
        int n24 = 0;
        n8 = 0;
        while (n8 < n15) {
            float f8 = f4 * (float)n8 + 0.0f;
            n22 = 0;
            while (n22 < n16) {
                float f9;
                float f10;
                float f11;
                Object object;
                Object[] objectArray;
                Object[] objectArray2;
                if (n24 + 8 >= n12) {
                    n12 = 2 * n12;
                    objectArray2 = fArray11;
                    objectArray = fArray12;
                    fArray11 = new float[n12];
                    fArray12 = new float[n12];
                    System.arraycopy(objectArray2, 0, fArray11, 0, n24);
                    System.arraycopy(objectArray, 0, fArray12, 0, n24);
                    if (n11 > 0) {
                        object = byArray5;
                        byArray5 = new byte[n11][n12];
                        int n25 = 0;
                        while (n25 < n11) {
                            System.arraycopy(object[n25], 0, byArray5[n25], 0, n24);
                            ++n25;
                        }
                    }
                }
                nArray5[n23++] = n24;
                float f12 = f5 * (float)n22 + 0.0f;
                float f13 = fArray[n22 * n + n8];
                if (f13 == f13 && (f11 = fArray[n22 * n + (n8 + 1)]) == f11 && (f10 = fArray[(n22 + 1) * n + n8]) == f10 && (f9 = fArray[(n22 + 1) * n + (n8 + 1)]) == f9) {
                    int n26;
                    int n27;
                    objectArray2 = null;
                    objectArray = null;
                    object = null;
                    byte[] byArray6 = null;
                    if (n11 > 0) {
                        objectArray2 = new byte[n11];
                        objectArray = new byte[n11];
                        object = new byte[n11];
                        byArray6 = new byte[n11];
                        n27 = 0;
                        while (n27 < n11) {
                            objectArray2[n27] = byArray[n27][n22 * n + n8];
                            objectArray[n27] = byArray[n27][n22 * n + (n8 + 1)];
                            object[n27] = (byte[])byArray[n27][(n22 + 1) * n + n8];
                            byArray6[n27] = byArray[n27][(n22 + 1) * n + (n8 + 1)];
                            ++n27;
                        }
                    }
                    float f14 = (f13 + f11 + f10 + f9) / 4.0f;
                    float f15 = f13 < f11 ? f13 : f11;
                    float f16 = f10 < f9 ? f10 : f9;
                    float f17 = f15 < f16 ? f15 : f16;
                    f15 = f13 > f11 ? f13 : f11;
                    f16 = f10 > f9 ? f10 : f9;
                    float f18 = f15 > f16 ? f15 : f16;
                    int n28 = 0;
                    int n29 = fArray13.length - 1;
                    if (fArray13[n28] > f18 || fArray13[n29] < f17) {
                        n26 = 1;
                    } else {
                        n27 = 0;
                        while (n27 < fArray13.length) {
                            if (n27 == 0 && fArray13[n27] >= f17) {
                                n28 = n27;
                            } else if (fArray13[n27] >= f17 && fArray13[n27 - 1] < f17) {
                                n28 = n27;
                            } else if (fArray13[n27] > f18 && fArray13[n27 - 1] < f17) {
                                n29 = n27;
                            }
                            ++n27;
                        }
                        n26 = n29 - n28 + 1;
                    }
                    float f19 = fArray13[n28];
                    n7 = 0;
                    while (n7 < n26) {
                        f19 = fArray13[n28 + n7];
                        if (n24 + 8 >= n12) {
                            n12 = 2 * n12;
                            float[] fArray14 = fArray11;
                            float[] fArray15 = fArray12;
                            fArray11 = new float[n12];
                            fArray12 = new float[n12];
                            System.arraycopy(fArray14, 0, fArray11, 0, n24);
                            System.arraycopy(fArray15, 0, fArray12, 0, n24);
                            if (n11 > 0) {
                                byte[][] byArray7 = byArray5;
                                byArray5 = new byte[n11][n12];
                                int n30 = 0;
                                while (n30 < n11) {
                                    System.arraycopy(byArray7[n30], 0, byArray5[n30], 0, n24);
                                    ++n30;
                                }
                            }
                        }
                        if (!(f19 < f17)) {
                            if (f19 > f18) break;
                            if (!(f19 < f)) {
                                if (f19 > f2) break;
                                int n31 = 0;
                                if (f19 > f13) {
                                    n31 = 1;
                                }
                                if (f19 > f11) {
                                    n31 += 2;
                                }
                                if (f19 > f10) {
                                    n31 += 4;
                                }
                                if (f19 > f9) {
                                    n31 += 8;
                                }
                                if (n31 > 7) {
                                    n31 = 15 - n31;
                                }
                                if (n31 > 0) {
                                    int n32;
                                    int n33;
                                    if (cArray[n22 * n + n8] == '\u0000') {
                                        float[][] fArray16;
                                        float[][] fArray17;
                                        int n34;
                                        int n35 = n22 - n17 - n20;
                                        int n36 = n8 - n18 - n19;
                                        n33 = n35 + 2 * n20 + n9 - 1;
                                        int n37 = n36 + 2 * n19 + n10 - 1;
                                        n32 = n35;
                                        while (n32 <= n33) {
                                            if (n32 >= 0 && n32 < n2) {
                                                n34 = n36;
                                                while (n34 <= n37) {
                                                    if (n34 >= 0 && n34 < n && cArray[n32 * n + n34] != '\u0002') {
                                                        cArray[n32 * n + n34] = '\u0001';
                                                    }
                                                    ++n34;
                                                }
                                            }
                                            ++n32;
                                        }
                                        n35 = n22 - n17;
                                        n36 = n8 - n18;
                                        n33 = n35 + n9 - 1;
                                        n37 = n36 + n10 - 1;
                                        n32 = n35;
                                        while (n32 <= n33) {
                                            if (n32 >= 0 && n32 < n2) {
                                                n34 = n36;
                                                while (n34 <= n37) {
                                                    if (n34 >= 0 && n34 < n) {
                                                        cArray[n32 * n + n34] = 2;
                                                    }
                                                    ++n34;
                                                }
                                            }
                                            ++n32;
                                        }
                                        float f20 = f4 * (float)n36 + 0.0f;
                                        float f21 = f5 * (float)n35 + 0.0f;
                                        float f22 = f4 * ((float)n37 + 1.0f) + 0.0f;
                                        float f23 = f5 * ((float)n33 + 1.0f) + 0.0f;
                                        float f24 = f19;
                                        if (nArray4[0] + 100 >= n6) {
                                            n6 = 2 * (nArray4[0] + 100);
                                            fArray17 = new float[][]{fArray9[0]};
                                            fArray16 = new float[][]{fArray10[0]};
                                            fArray9[0] = new float[n6];
                                            fArray10[0] = new float[n6];
                                            System.arraycopy(fArray17[0], 0, fArray9[0], 0, nArray4[0]);
                                            System.arraycopy(fArray16[0], 0, fArray10[0], 0, nArray4[0]);
                                        }
                                        if (nArray3[0] + 100 >= n5) {
                                            n5 = 2 * (nArray3[0] + 100);
                                            fArray17 = new float[][]{fArray7[0]};
                                            fArray16 = new float[][]{fArray8[0]};
                                            fArray7[0] = new float[n5];
                                            fArray8[0] = new float[n5];
                                            System.arraycopy(fArray17[0], 0, fArray7[0], 0, nArray3[0]);
                                            System.arraycopy(fArray16[0], 0, fArray8[0], 0, nArray3[0]);
                                            if (n11 > 0) {
                                                byte[][] byArray8 = byArray4;
                                                int n38 = 0;
                                                while (n38 < n11) {
                                                    byte[] byArray9 = byArray4[n38];
                                                    byArray4[n38] = new byte[n5];
                                                    System.arraycopy(byArray9, 0, byArray4[n38], 0, nArray3[0]);
                                                    ++n38;
                                                }
                                            }
                                        }
                                        plotDigits.plotdigits(f24, f20, f21, f22, f23, n12, blArray);
                                        System.arraycopy(plotDigits.Vx, 0, fArray7[0], nArray3[0], plotDigits.NumVerts);
                                        System.arraycopy(plotDigits.Vy, 0, fArray8[0], nArray3[0], plotDigits.NumVerts);
                                        if (n11 > 0) {
                                            int n39 = 0;
                                            while (n39 < n11) {
                                                int n40 = nArray3[0];
                                                while (n40 < nArray3[0] + plotDigits.NumVerts) {
                                                    byArray4[n39][n40] = (byte)objectArray2[n39];
                                                    ++n40;
                                                }
                                                ++n39;
                                            }
                                        }
                                        nArray3[0] = nArray3[0] + plotDigits.NumVerts;
                                        System.arraycopy(plotDigits.VxB, 0, fArray9[0], nArray4[0], plotDigits.NumVerts);
                                        System.arraycopy(plotDigits.VyB, 0, fArray10[0], nArray4[0], plotDigits.NumVerts);
                                        nArray4[0] = nArray4[0] + plotDigits.NumVerts;
                                    }
                                    switch (n31) {
                                        case 1: {
                                            int n41;
                                            float f25 = f11 - f13;
                                            float f26 = f10 - f13;
                                            if (n11 > 0) {
                                                float f27 = (f19 - f13) / f25;
                                                float f28 = (f19 - f13) / f26;
                                                n33 = 0;
                                                while (n33 < n11) {
                                                    n41 = (int)((1.0f - f27) * (objectArray2[n33] < 0 ? (float)objectArray2[n33] + 256.0f : (float)objectArray2[n33]) + f27 * (objectArray[n33] < 0 ? (float)objectArray[n33] + 256.0f : (float)objectArray[n33]));
                                                    byArray5[n33][n24] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    n41 = (int)((1.0f - f28) * (objectArray2[n33] < 0 ? (float)objectArray2[n33] + 256.0f : (float)objectArray2[n33]) + f28 * (object[n33] < 0 ? (float)object[n33] + 256.0f : (float)object[n33]));
                                                    byArray5[n33][n24 + 1] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    ++n33;
                                                }
                                            }
                                            fArray11[n24] = (double)(f25 < 0.0f ? -f25 : f25) < 1.0E-7 ? f8 : f8 + f6 * (f19 - f13) / f25;
                                            fArray12[n24] = f12;
                                            fArray12[++n24] = (double)(f26 < 0.0f ? -f26 : f26) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f13) / f26;
                                            fArray11[n24] = f8;
                                            ++n24;
                                            break;
                                        }
                                        case 2: {
                                            int n41;
                                            float f29 = f11 - f13;
                                            float f30 = f9 - f11;
                                            if (n11 > 0) {
                                                float f31 = (f19 - f13) / f29;
                                                float f32 = (f19 - f11) / f30;
                                                n33 = 0;
                                                while (n33 < n11) {
                                                    n41 = (int)((1.0f - f31) * (objectArray2[n33] < 0 ? (float)objectArray2[n33] + 256.0f : (float)objectArray2[n33]) + f31 * (objectArray[n33] < 0 ? (float)objectArray[n33] + 256.0f : (float)objectArray[n33]));
                                                    byArray5[n33][n24] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    n41 = (int)((1.0f - f32) * (objectArray[n33] < 0 ? (float)objectArray[n33] + 256.0f : (float)objectArray[n33]) + f32 * (byArray6[n33] < 0 ? (float)byArray6[n33] + 256.0f : (float)byArray6[n33]));
                                                    byArray5[n33][n24 + 1] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    ++n33;
                                                }
                                            }
                                            fArray11[n24] = (double)(f29 < 0.0f ? -f29 : f29) < 1.0E-7 ? f8 : f8 + f6 * (f19 - f13) / f29;
                                            fArray12[n24] = f12;
                                            fArray12[++n24] = (double)(f30 < 0.0f ? -f30 : f30) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f11) / f30;
                                            fArray11[n24] = f8 + f6;
                                            ++n24;
                                            break;
                                        }
                                        case 3: {
                                            int n41;
                                            float f33 = f10 - f13;
                                            float f34 = f9 - f11;
                                            if (n11 > 0) {
                                                float f35 = (f19 - f13) / f33;
                                                float f36 = (f19 - f11) / f34;
                                                n33 = 0;
                                                while (n33 < n11) {
                                                    n41 = (int)((1.0f - f35) * (objectArray2[n33] < 0 ? (float)objectArray2[n33] + 256.0f : (float)objectArray2[n33]) + f35 * (object[n33] < 0 ? (float)object[n33] + 256.0f : (float)object[n33]));
                                                    byArray5[n33][n24] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    n41 = (int)((1.0f - f36) * (objectArray[n33] < 0 ? (float)objectArray[n33] + 256.0f : (float)objectArray[n33]) + f36 * (byArray6[n33] < 0 ? (float)byArray6[n33] + 256.0f : (float)byArray6[n33]));
                                                    byArray5[n33][n24 + 1] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    ++n33;
                                                }
                                            }
                                            fArray12[n24] = (double)(f33 < 0.0f ? -f33 : f33) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f13) / f33;
                                            fArray11[n24] = f8;
                                            fArray12[++n24] = (double)(f34 < 0.0f ? -f34 : f34) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f11) / f34;
                                            fArray11[n24] = f8 + f6;
                                            ++n24;
                                            break;
                                        }
                                        case 4: {
                                            int n41;
                                            float f37 = f10 - f13;
                                            float f38 = f9 - f10;
                                            if (n11 > 0) {
                                                float f39 = (f19 - f13) / f37;
                                                float f40 = (f19 - f10) / f38;
                                                n33 = 0;
                                                while (n33 < n11) {
                                                    n41 = (int)((1.0f - f39) * (objectArray2[n33] < 0 ? (float)objectArray2[n33] + 256.0f : (float)objectArray2[n33]) + f39 * (object[n33] < 0 ? (float)object[n33] + 256.0f : (float)object[n33]));
                                                    byArray5[n33][n24] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    n41 = (int)((1.0f - f40) * (object[n33] < 0 ? (float)object[n33] + 256.0f : (float)object[n33]) + f40 * (byArray6[n33] < 0 ? (float)byArray6[n33] + 256.0f : (float)byArray6[n33]));
                                                    byArray5[n33][n24 + 1] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    ++n33;
                                                }
                                            }
                                            fArray12[n24] = (double)(f37 < 0.0f ? -f37 : f37) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f13) / f37;
                                            fArray11[n24] = f8;
                                            fArray11[++n24] = (double)(f38 < 0.0f ? -f38 : f38) < 1.0E-7 ? f8 : f8 + f6 * (f19 - f10) / f38;
                                            fArray12[n24] = f12 + f7;
                                            ++n24;
                                            break;
                                        }
                                        case 5: {
                                            int n41;
                                            float f41 = f11 - f13;
                                            float f42 = f9 - f10;
                                            if (n11 > 0) {
                                                float f43 = (f19 - f13) / f41;
                                                float f44 = (f19 - f10) / f42;
                                                n33 = 0;
                                                while (n33 < n11) {
                                                    n41 = (int)((1.0f - f43) * (objectArray2[n33] < 0 ? (float)objectArray2[n33] + 256.0f : (float)objectArray2[n33]) + f43 * (objectArray[n33] < 0 ? (float)objectArray[n33] + 256.0f : (float)objectArray[n33]));
                                                    byArray5[n33][n24] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    n41 = (int)((1.0f - f44) * (object[n33] < 0 ? (float)object[n33] + 256.0f : (float)object[n33]) + f44 * (byArray6[n33] < 0 ? (float)byArray6[n33] + 256.0f : (float)byArray6[n33]));
                                                    byArray5[n33][n24 + 1] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    ++n33;
                                                }
                                            }
                                            fArray11[n24] = (double)(f41 < 0.0f ? -f41 : f41) < 1.0E-7 ? f8 : f8 + f6 * (f19 - f13) / f41;
                                            fArray12[n24] = f12;
                                            fArray11[++n24] = (double)(f42 < 0.0f ? -f42 : f42) < 1.0E-7 ? f8 : f8 + f6 * (f19 - f10) / f42;
                                            fArray12[n24] = f12 + f7;
                                            ++n24;
                                            break;
                                        }
                                        case 6: {
                                            int n41;
                                            float f45 = f11 - f13;
                                            float f46 = f9 - f10;
                                            float f47 = f10 - f13;
                                            float f48 = f9 - f11;
                                            if (n11 > 0) {
                                                float f49 = (f19 - f13) / f45;
                                                float f50 = (f19 - f10) / f46;
                                                float f51 = (f19 - f13) / f47;
                                                float f52 = (f19 - f11) / f48;
                                                n32 = 0;
                                                while (n32 < n11) {
                                                    n41 = (int)((1.0f - f49) * (objectArray2[n32] < 0 ? (float)objectArray2[n32] + 256.0f : (float)objectArray2[n32]) + f49 * (objectArray[n32] < 0 ? (float)objectArray[n32] + 256.0f : (float)objectArray[n32]));
                                                    byArray5[n32][n24] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    if (f19 > f14 ^ f13 < f11) {
                                                        n41 = (int)((1.0f - f51) * (objectArray2[n32] < 0 ? (float)objectArray2[n32] + 256.0f : (float)objectArray2[n32]) + f51 * (object[n32] < 0 ? (float)object[n32] + 256.0f : (float)object[n32]));
                                                        byArray5[n32][n24 + 1] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                        n41 = (int)((1.0f - f52) * (objectArray[n32] < 0 ? (float)objectArray[n32] + 256.0f : (float)objectArray[n32]) + f52 * (byArray6[n32] < 0 ? (float)byArray6[n32] + 256.0f : (float)byArray6[n32]));
                                                        byArray5[n32][n24 + 2] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    } else {
                                                        n41 = (int)((1.0f - f52) * (objectArray[n32] < 0 ? (float)objectArray[n32] + 256.0f : (float)objectArray[n32]) + f52 * (byArray6[n32] < 0 ? (float)byArray6[n32] + 256.0f : (float)byArray6[n32]));
                                                        byArray5[n32][n24 + 1] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                        n41 = (int)((1.0f - f51) * (objectArray2[n32] < 0 ? (float)objectArray2[n32] + 256.0f : (float)objectArray2[n32]) + f51 * (object[n32] < 0 ? (float)object[n32] + 256.0f : (float)object[n32]));
                                                        byArray5[n32][n24 + 2] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    }
                                                    n41 = (int)((1.0f - f50) * (object[n32] < 0 ? (float)object[n32] + 256.0f : (float)object[n32]) + f50 * (byArray6[n32] < 0 ? (float)byArray6[n32] + 256.0f : (float)byArray6[n32]));
                                                    byArray5[n32][n24 + 3] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    ++n32;
                                                }
                                            }
                                            fArray11[n24] = (double)(f45 < 0.0f ? -f45 : f45) < 1.0E-7 ? f8 : f8 + f6 * (f19 - f13) / f45;
                                            fArray12[n24] = f12;
                                            ++n24;
                                            if (f19 > f14 ^ f13 < f11) {
                                                fArray12[n24] = (double)(f47 < 0.0f ? -f47 : f47) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f13) / f47;
                                                fArray11[n24] = f8;
                                                fArray12[++n24] = (double)(f48 < 0.0f ? -f48 : f48) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f11) / f48;
                                                fArray11[n24] = f8 + f6;
                                                ++n24;
                                            } else {
                                                fArray12[n24] = (double)(f48 < 0.0f ? -f48 : f48) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f11) / f48;
                                                fArray11[n24] = f8 + f6;
                                                fArray12[++n24] = (double)(f47 < 0.0f ? -f47 : f47) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f13) / f47;
                                                fArray11[n24] = f8;
                                                ++n24;
                                            }
                                            fArray11[n24] = (double)(f46 < 0.0f ? -f46 : f46) < 1.0E-7 ? f8 : f8 + f6 * (f19 - f10) / f46;
                                            fArray12[n24] = f12 + f7;
                                            ++n24;
                                            break;
                                        }
                                        case 7: {
                                            int n41;
                                            float f53 = f9 - f11;
                                            float f54 = f9 - f10;
                                            if (n11 > 0) {
                                                float f55 = (f19 - f11) / f53;
                                                float f56 = (f19 - f10) / f54;
                                                n33 = 0;
                                                while (n33 < n11) {
                                                    n41 = (int)((1.0f - f55) * (objectArray[n33] < 0 ? (float)objectArray[n33] + 256.0f : (float)objectArray[n33]) + f55 * (byArray6[n33] < 0 ? (float)byArray6[n33] + 256.0f : (float)byArray6[n33]));
                                                    byArray5[n33][n24] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    n41 = (int)((1.0f - f56) * (object[n33] < 0 ? (float)object[n33] + 256.0f : (float)object[n33]) + f56 * (byArray6[n33] < 0 ? (float)byArray6[n33] + 256.0f : (float)byArray6[n33]));
                                                    byArray5[n33][n24 + 1] = (byte)(n41 < 0 ? 0 : (n41 > 255 ? -1 : (n41 < 128 ? n41 : n41 - 256)));
                                                    ++n33;
                                                }
                                            }
                                            fArray12[n24] = (double)(f53 < 0.0f ? -f53 : f53) < 1.0E-7 ? f12 : f12 + f7 * (f19 - f11) / f53;
                                            fArray11[n24] = f8 + f6;
                                            fArray11[++n24] = (double)(f54 < 0.0f ? -f54 : f54) < 1.0E-7 ? f8 : f8 + f6 * (f19 - f10) / f54;
                                            fArray12[n24] = f12 + f7;
                                            ++n24;
                                            break;
                                        }
                                    }
                                    if (f19 < f3 && bl) {
                                        float f57 = fArray11[n24 - 2];
                                        float f58 = fArray12[n24 - 2];
                                        float f59 = fArray11[n24 - 1];
                                        float f60 = fArray12[n24 - 1];
                                        fArray11[n24 - 2] = (3.0f * f57 + f59) * 0.25f;
                                        fArray12[n24 - 2] = (3.0f * f58 + f60) * 0.25f;
                                        fArray11[n24 - 1] = (f57 + 3.0f * f59) * 0.25f;
                                        fArray12[n24 - 1] = (f58 + 3.0f * f60) * 0.25f;
                                    }
                                }
                            }
                        }
                        ++n7;
                    }
                }
                ++n22;
            }
            ++n8;
        }
        nArray5[n23] = n24;
        int n42 = 0;
        n8 = 0;
        while (n8 < n15 && n42 < nArray5.length - 1) {
            n22 = 0;
            while (n22 < n16 && n42 < nArray5.length - 1) {
                int n43 = nArray5[n42];
                int n44 = nArray5[n42 + 1] - n43;
                if (n44 > 0) {
                    byte[] byArray10;
                    int n45;
                    float[][] fArray18;
                    if (cArray[n22 * n + n8] == '\u0002') {
                        if (nArray2[0] + n44 >= n4) {
                            n4 = 2 * (nArray2[0] + n44);
                            float[][] fArray19 = new float[][]{fArray5[0]};
                            fArray18 = new float[][]{fArray6[0]};
                            fArray5[0] = new float[n4];
                            fArray6[0] = new float[n4];
                            System.arraycopy(fArray19[0], 0, fArray5[0], 0, nArray2[0]);
                            System.arraycopy(fArray18[0], 0, fArray6[0], 0, nArray2[0]);
                            if (n11 > 0) {
                                n45 = 0;
                                while (n45 < n11) {
                                    byArray10 = byArray3[n45];
                                    byArray3[n45] = new byte[n4];
                                    System.arraycopy(byArray10, 0, byArray3[n45], 0, nArray2[0]);
                                    ++n45;
                                }
                            }
                        }
                        n7 = 0;
                        while (n7 < n44) {
                            fArray5[0][nArray2[0] + n7] = fArray11[n43 + n7];
                            fArray6[0][nArray2[0] + n7] = fArray12[n43 + n7];
                            ++n7;
                        }
                        if (n11 > 0) {
                            int n46 = 0;
                            while (n46 < n11) {
                                n7 = 0;
                                while (n7 < n44) {
                                    byArray3[n46][nArray2[0] + n7] = byArray5[n46][n43 + n7];
                                    ++n7;
                                }
                                ++n46;
                            }
                        }
                        nArray2[0] = nArray2[0] + n44;
                    } else {
                        if (nArray[0] + n44 >= n3) {
                            n3 = 2 * (nArray[0] + n44);
                            float[][] fArray20 = new float[][]{fArray3[0]};
                            fArray18 = new float[][]{fArray4[0]};
                            fArray3[0] = new float[n3];
                            fArray4[0] = new float[n3];
                            System.arraycopy(fArray20[0], 0, fArray3[0], 0, nArray[0]);
                            System.arraycopy(fArray18[0], 0, fArray4[0], 0, nArray[0]);
                            if (n11 > 0) {
                                n45 = 0;
                                while (n45 < n11) {
                                    byArray10 = byArray2[n45];
                                    byArray2[n45] = new byte[n3];
                                    System.arraycopy(byArray10, 0, byArray2[n45], 0, nArray[0]);
                                    ++n45;
                                }
                            }
                        }
                        n7 = 0;
                        while (n7 < n44) {
                            fArray3[0][nArray[0] + n7] = fArray11[n43 + n7];
                            fArray4[0][nArray[0] + n7] = fArray12[n43 + n7];
                            ++n7;
                        }
                        if (n11 > 0) {
                            int n47 = 0;
                            while (n47 < n11) {
                                n7 = 0;
                                while (n7 < n44) {
                                    byArray2[n47][nArray[0] + n7] = byArray5[n47][n43 + n7];
                                    ++n7;
                                }
                                ++n47;
                            }
                        }
                        nArray[0] = nArray[0] + n44;
                    }
                }
                ++n42;
                ++n22;
            }
            ++n8;
        }
    }

    public void init() {
        Object object;
        this.addMouseListener(this);
        this.con = new Contour2D();
        this.con.rows = 0;
        this.con.cols = 0;
        this.con.scale = 0;
        float f = 0.0f;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            object = new String("true");
            this.con.showgrid = ((String)object).equalsIgnoreCase(this.getParameter("showgrid"));
            this.con.rows = Integer.parseInt(this.getParameter("rows"));
            this.con.cols = Integer.parseInt(this.getParameter("columns"));
            this.con.scale = Integer.parseInt(this.getParameter("scale"));
            f = Double.valueOf(this.getParameter("interval")).floatValue();
            n = Integer.parseInt(this.getParameter("capacity1"));
            n2 = Integer.parseInt(this.getParameter("capacity2"));
            n3 = Integer.parseInt(this.getParameter("capacity3"));
            n4 = Integer.parseInt(this.getParameter("capacity4"));
        }
        catch (Exception exception) {
            System.out.println("Contour2D.paint: applet parameter error: " + exception);
            System.exit(1);
        }
        object = new float[this.con.rows * this.con.cols];
        float f2 = this.con.rows / 2;
        float f3 = this.con.cols / 2;
        int n5 = 0;
        while (n5 < this.con.rows) {
            int n6 = 0;
            while (n6 < this.con.cols) {
                object[this.con.rows * n6 + n5] = (float)Math.sqrt(((float)n5 - f2) * ((float)n5 - f2) + ((float)n6 - f3) * ((float)n6 - f3));
                ++n6;
            }
            ++n5;
        }
        float f4 = 0.0f;
        float f5 = 100.0f;
        float f6 = 1.0f;
        this.con.num1 = new int[1];
        this.con.num2 = new int[1];
        this.con.num3 = new int[1];
        this.con.num4 = new int[1];
        this.con.vx1 = new float[1][n];
        this.con.vy1 = new float[1][n];
        this.con.vx2 = new float[1][n2];
        this.con.vy2 = new float[1][n2];
        this.con.vx3 = new float[1][n3];
        this.con.vy3 = new float[1][n3];
        this.con.vx4 = new float[1][n4];
        this.con.vy4 = new float[1][n4];
        try {
            boolean[] blArray = new boolean[]{false, false, false};
            float[] fArray = new float[]{0.25f, 0.5f, 1.0f, 2.0f, 2.5f, 5.0f, 10.0f};
            Contour2D.contour((float[])object, this.con.rows, this.con.cols, f, f4, f5, f6, this.con.vx1, this.con.vy1, n, this.con.num1, this.con.vx2, this.con.vy2, n2, this.con.num2, this.con.vx3, this.con.vy3, n3, this.con.num3, this.con.vx4, this.con.vy4, n4, this.con.num4, null, null, null, null, blArray);
        }
        catch (VisADException visADException) {
            System.out.println("Contour2D.init: " + visADException);
            System.exit(1);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.con.whichlabels = (this.con.whichlabels + 1) % 5;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            this.paint(graphics);
            graphics.dispose();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.con.showgrid) {
            graphics.setColor(Color.blue);
            n5 = 0;
            while (n5 < this.con.cols) {
                n4 = 0;
                while (n4 < this.con.rows) {
                    graphics.drawRect(this.con.scale * n5, this.con.scale * n4, 2, 2);
                    ++n4;
                }
                ++n5;
            }
        }
        graphics.setColor(Color.black);
        n5 = 0;
        while (n5 < this.con.num1[0]) {
            n4 = (int)((float)this.con.scale * this.con.vy1[0][n5]);
            n3 = (int)((float)this.con.scale * this.con.vx1[0][n5]);
            n2 = (int)((float)this.con.scale * this.con.vy1[0][(n5 + 1) % this.con.num1[0]]);
            n = (int)((float)this.con.scale * this.con.vx1[0][(n5 + 1) % this.con.num1[0]]);
            graphics.drawLine(n4, n3, n2, n);
            n5 += 2;
        }
        n5 = -1;
        while (n5 < 1) {
            if (n5 < 0) {
                graphics.setColor(Color.white);
            } else {
                graphics.setColor(Color.black);
            }
            switch ((this.con.whichlabels + n5 + 5) % 5) {
                case 0: {
                    int n6;
                    n4 = 0;
                    while (n4 < this.con.num2[0]) {
                        n3 = (int)((float)this.con.scale * this.con.vy2[0][n4]);
                        n2 = (int)((float)this.con.scale * this.con.vx2[0][n4]);
                        n = (int)((float)this.con.scale * this.con.vy2[0][(n4 + 1) % this.con.num2[0]]);
                        n6 = (int)((float)this.con.scale * this.con.vx2[0][(n4 + 1) % this.con.num2[0]]);
                        graphics.drawLine(n3, n2, n, n6);
                        n4 += 2;
                    }
                    break;
                }
                case 1: {
                    int n6;
                    n4 = 0;
                    while (n4 < this.con.num3[0]) {
                        n3 = (int)((float)this.con.scale * this.con.vy3[0][n4]);
                        n2 = (int)((float)this.con.scale * this.con.vx3[0][n4]);
                        n = (int)((float)this.con.scale * this.con.vy3[0][(n4 + 1) % this.con.num3[0]]);
                        n6 = (int)((float)this.con.scale * this.con.vx3[0][(n4 + 1) % this.con.num3[0]]);
                        graphics.drawLine(n3, n2, n, n6);
                        n4 += 2;
                    }
                    break;
                }
                case 2: {
                    int n6;
                    n4 = 0;
                    while (n4 < this.con.num4[0]) {
                        n3 = (int)((float)this.con.scale * this.con.vy4[0][n4]);
                        n2 = (int)((float)this.con.scale * this.con.vx3[0][n4]);
                        n = (int)((float)this.con.scale * this.con.vy4[0][(n4 + 1) % this.con.num4[0]]);
                        n6 = (int)((float)this.con.scale * this.con.vx3[0][(n4 + 1) % this.con.num3[0]]);
                        graphics.drawLine(n3, n2, n, n6);
                        n4 += 2;
                    }
                    break;
                }
                case 3: {
                    int n6;
                    n4 = 0;
                    while (n4 < this.con.num3[0]) {
                        n3 = (int)((float)this.con.scale * this.con.vy3[0][n4]);
                        n2 = (int)((float)this.con.scale * this.con.vx4[0][n4]);
                        n = (int)((float)this.con.scale * this.con.vy3[0][(n4 + 1) % this.con.num3[0]]);
                        n6 = (int)((float)this.con.scale * this.con.vx4[0][(n4 + 1) % this.con.num4[0]]);
                        graphics.drawLine(n3, n2, n, n6);
                        n4 += 2;
                    }
                    break;
                }
                case 4: {
                    int n6;
                    n4 = 0;
                    while (n4 < this.con.num3[0]) {
                        n3 = (int)((float)this.con.scale * this.con.vy4[0][n4]);
                        n2 = (int)((float)this.con.scale * this.con.vx4[0][n4]);
                        n = (int)((float)this.con.scale * this.con.vy4[0][(n4 + 1) % this.con.num4[0]]);
                        n6 = (int)((float)this.con.scale * this.con.vx4[0][(n4 + 1) % this.con.num4[0]]);
                        graphics.drawLine(n3, n2, n, n6);
                        n4 += 2;
                    }
                    break;
                }
            }
            ++n5;
        }
    }
}

