/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.Display;
import visad.DisplayException;
import visad.DisplayRealType;
import visad.Real;
import visad.ScalarMap;
import visad.VisADException;
import visad.util.Util;

public class ConstantMap
extends ScalarMap {
    private static boolean allowMultipleUseKludge = false;
    private double Constant;

    public static void setAllowMultipleUseKludge(boolean bl) {
        allowMultipleUseKludge = bl;
    }

    public static boolean getAllowMultipleUseKludge() {
        return allowMultipleUseKludge;
    }

    void setControl() throws VisADException, RemoteException {
    }

    public double getConstant() {
        return this.Constant;
    }

    public boolean equals(Object object) {
        ConstantMap constantMap;
        boolean bl = !(object instanceof ConstantMap) ? false : this == (constantMap = (ConstantMap)object) || this.compareTo(constantMap) == 0;
        return bl;
    }

    public int compareTo(Object object) {
        return object instanceof ConstantMap ? this.compareTo((ConstantMap)object) : this.compareTo((ScalarMap)object);
    }

    protected int compareTo(ConstantMap constantMap) {
        int n = this.getDisplayScalar().compareTo(constantMap.getDisplayScalar());
        if (n == 0) {
            n = Util.isApproximatelyEqual(this.Constant, constantMap.Constant) ? 0 : (this.Constant - constantMap.Constant < 0.0 ? -1 : 1);
        }
        return n;
    }

    protected int compareTo(ScalarMap scalarMap) {
        return -1;
    }

    public Object clone() {
        try {
            ConstantMap constantMap = new ConstantMap(this.Constant, this.getDisplayScalar());
            this.copy(constantMap);
            return constantMap;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String toString(String string) {
        return string + "ConstantMap: " + this.Constant + " -> " + this.getDisplayScalar().toString() + "\n";
    }

    void setAspectCartesian(double[] dArray) throws VisADException, RemoteException {
    }

    public ConstantMap(double d, DisplayRealType displayRealType) throws VisADException {
        super(null, displayRealType, false);
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new DisplayException("ConstantMap: constant is missing (NaN) or infinity");
        }
        if (displayRealType.equals(Display.Animation) || displayRealType.equals(Display.SelectValue) || displayRealType.equals(Display.SelectRange) || displayRealType.equals(Display.IsoContour) || displayRealType.equals(Display.Text)) {
            throw new DisplayException("ConstantMap: illegal for " + displayRealType);
        }
        if (this.isScaled && !displayRealType.equals(Display.XAxis) && !displayRealType.equals(Display.YAxis) && !displayRealType.equals(Display.ZAxis) && (d < this.displayRange[0] || d > this.displayRange[1])) {
            throw new DisplayException("ConstantMap: constant is out of range");
        }
        this.Constant = d;
    }

    public ConstantMap(Real real, DisplayRealType displayRealType) throws VisADException {
        this(real.getValue(), displayRealType);
    }
}

