/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.util.Vector;
import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;

public class CartesianProductCoordinateSystem
extends CoordinateSystem {
    private CoordinateSystem[] csArray;

    static RealTupleType getProductReference(CoordinateSystem[] coordinateSystemArray) throws VisADException {
        if (coordinateSystemArray == null) {
            throw new VisADException("CoordinateSystem array can't be null");
        }
        if (coordinateSystemArray.length < 2) {
            throw new VisADException("CoordinateSystem array must have more than one element");
        }
        Vector<RealType> vector = new Vector<RealType>();
        int n = 0;
        while (n < coordinateSystemArray.length) {
            CoordinateSystem coordinateSystem = coordinateSystemArray[n];
            if (coordinateSystem == null) {
                throw new VisADException("CoordinateSystem array can't have null members " + n);
            }
            RealType[] realTypeArray = coordinateSystem.getReference().getRealComponents();
            int n2 = 0;
            while (n2 < realTypeArray.length) {
                vector.add(realTypeArray[n2]);
                ++n2;
            }
            ++n;
        }
        return new RealTupleType(vector.toArray(new RealType[vector.size()]));
    }

    static Unit[] getProductUnits(CoordinateSystem[] coordinateSystemArray) throws VisADException {
        if (coordinateSystemArray == null) {
            throw new VisADException("CoordinateSystem array can't be null");
        }
        if (coordinateSystemArray.length < 2) {
            throw new VisADException("CoordinateSystem array must have more than one element");
        }
        Vector<Unit> vector = new Vector<Unit>();
        int n = 0;
        while (n < coordinateSystemArray.length) {
            Unit[] unitArray = coordinateSystemArray[n].getCoordinateSystemUnits();
            int n2 = 0;
            while (n2 < unitArray.length) {
                vector.add(unitArray[n2]);
                ++n2;
            }
            ++n;
        }
        return vector.toArray(new Unit[vector.size()]);
    }

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray.length != this.getDimension() || dArray == null) {
            throw new VisADException("input has wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[this.getDimension()][n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.csArray.length) {
            int n4 = this.csArray[n3].getDimension();
            double[][] dArray3 = new double[n4][n];
            int n5 = 0;
            while (n5 < n4) {
                dArray3[n5] = (double[])dArray[n2 + n5].clone();
                ++n5;
            }
            dArray3 = this.csArray[n3].toReference(dArray3);
            n5 = 0;
            while (n5 < n4) {
                dArray2[n2 + n5] = dArray3[n5];
                ++n5;
            }
            n2 += n4;
            ++n3;
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray.length != this.getDimension() || dArray == null) {
            throw new VisADException("refTuple has wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[this.getDimension()][n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.csArray.length) {
            int n4 = this.csArray[n3].getDimension();
            double[][] dArray3 = new double[n4][n];
            int n5 = 0;
            while (n5 < n4) {
                dArray3[n5] = (double[])dArray[n2 + n5].clone();
                ++n5;
            }
            dArray3 = this.csArray[n3].fromReference(dArray3);
            n5 = 0;
            while (n5 < n4) {
                dArray2[n2 + n5] = dArray3[n5];
                ++n5;
            }
            n2 += n4;
            ++n3;
        }
        return dArray2;
    }

    public float[][] toReference(float[][] fArray) throws VisADException {
        if (fArray.length != this.getDimension() || fArray == null) {
            throw new VisADException("input has wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[this.getDimension()][n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.csArray.length) {
            int n4 = this.csArray[n3].getDimension();
            float[][] fArray3 = new float[n4][n];
            int n5 = 0;
            while (n5 < n4) {
                fArray3[n5] = (float[])fArray[n2 + n5].clone();
                ++n5;
            }
            fArray3 = this.csArray[n3].toReference(fArray3);
            n5 = 0;
            while (n5 < n4) {
                fArray2[n2 + n5] = (float[])fArray3[n5].clone();
                ++n5;
            }
            n2 += n4;
            ++n3;
        }
        return fArray2;
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        if (fArray.length != this.getDimension() || fArray == null) {
            throw new VisADException("refTuple has wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[this.getDimension()][n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.csArray.length) {
            int n4 = this.csArray[n3].getDimension();
            float[][] fArray3 = new float[n4][n];
            int n5 = 0;
            while (n5 < n4) {
                fArray3[n5] = (float[])fArray[n2 + n5].clone();
                ++n5;
            }
            fArray3 = this.csArray[n3].fromReference(fArray3);
            n5 = 0;
            while (n5 < n4) {
                fArray2[n2 + n5] = fArray3[n5];
                ++n5;
            }
            n2 += n4;
            ++n3;
        }
        return fArray2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CartesianProductCoordinateSystem) {
            int n = this.csArray.length;
            CoordinateSystem[] coordinateSystemArray = ((CartesianProductCoordinateSystem)object).csArray;
            if (n != coordinateSystemArray.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!this.csArray[n2].equals(coordinateSystemArray[n2])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public CartesianProductCoordinateSystem(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) throws VisADException {
        this(new CoordinateSystem[]{coordinateSystem, coordinateSystem2});
    }

    public CartesianProductCoordinateSystem(CoordinateSystem[] coordinateSystemArray) throws VisADException {
        super(CartesianProductCoordinateSystem.getProductReference(coordinateSystemArray), CartesianProductCoordinateSystem.getProductUnits(coordinateSystemArray));
        this.csArray = coordinateSystemArray;
    }
}

