/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class CMYCoordinateSystem
extends CoordinateSystem {
    private static Unit[] coordinate_system_units = new Unit[]{null, null, null};

    public double[][] toReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[3][n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[0][n2] = 1.0 - dArray[0][n2];
            dArray2[1][n2] = 1.0 - dArray[1][n2];
            dArray2[2][n2] = 1.0 - dArray[2][n2];
            ++n2;
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        if (dArray == null || dArray.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = dArray[0].length;
        double[][] dArray2 = new double[3][n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[0][n2] = 1.0 - dArray[0][n2];
            dArray2[1][n2] = 1.0 - dArray[1][n2];
            dArray2[2][n2] = 1.0 - dArray[2][n2];
            ++n2;
        }
        return dArray2;
    }

    public float[][] toReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.toReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[3][n];
        int n2 = 0;
        while (n2 < n) {
            fArray2[0][n2] = 1.0f - fArray[0][n2];
            fArray2[1][n2] = 1.0f - fArray[1][n2];
            fArray2[2][n2] = 1.0f - fArray[2][n2];
            ++n2;
        }
        return fArray2;
    }

    public float[][] fromReference(float[][] fArray) throws VisADException {
        if (fArray == null || fArray.length != 3) {
            throw new CoordinateSystemException("CMYCoordinateSystem.fromReference: tuples wrong dimension");
        }
        int n = fArray[0].length;
        float[][] fArray2 = new float[3][n];
        int n2 = 0;
        while (n2 < n) {
            fArray2[0][n2] = 1.0f - fArray[0][n2];
            fArray2[1][n2] = 1.0f - fArray[1][n2];
            fArray2[2][n2] = 1.0f - fArray[2][n2];
            ++n2;
        }
        return fArray2;
    }

    public boolean equals(Object object) {
        return object instanceof CMYCoordinateSystem;
    }

    public CMYCoordinateSystem(RealTupleType realTupleType) throws VisADException {
        super(realTupleType, coordinate_system_units);
    }

    CMYCoordinateSystem(RealTupleType realTupleType, boolean bl) {
        super(realTupleType, coordinate_system_units, bl);
    }
}

