/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.util.Vector;
import visad.DerivedUnit;
import visad.Unit;
import visad.UnitException;

public final class BaseUnit
extends Unit
implements Serializable {
    private static final Vector baseUnits = new Vector(9);
    private final String unitName;
    private final String quantityName;
    final DerivedUnit derivedUnit;

    public Unit pow(int n) {
        return this.derivedUnit.pow(n);
    }

    public Unit root(int n) throws IllegalArgumentException {
        return this.derivedUnit.root(n);
    }

    public Unit pow(double d) throws IllegalArgumentException {
        return this.derivedUnit.pow(d);
    }

    public String unitName() {
        return this.unitName;
    }

    public String unitSymbol() {
        return this.getIdentifier();
    }

    public String quantityName() {
        return this.quantityName;
    }

    public static BaseUnit addBaseUnit(String string, String string2) throws UnitException {
        return BaseUnit.addBaseUnit(string, string2, string2);
    }

    public static synchronized BaseUnit addBaseUnit(String string, String string2, String string3) throws UnitException {
        BaseUnit baseUnit = BaseUnit.quantityNameToUnit(string);
        if (baseUnit == null) {
            return new BaseUnit(string2, string3, string);
        }
        if (baseUnit.unitName.equals(string2) && baseUnit.getIdentifier().equals(string3)) {
            return baseUnit;
        }
        throw new UnitException("Attempt to redefine quantity \"" + string + "\" base unit from \"" + baseUnit.unitName + "(" + baseUnit.getIdentifier() + ")" + "\" to \"" + string2 + "(" + string3 + ")" + "\"");
    }

    public static synchronized BaseUnit unitNameToUnit(String string) {
        int n = 0;
        while (n < baseUnits.size()) {
            BaseUnit baseUnit = (BaseUnit)baseUnits.elementAt(n);
            if (baseUnit.unitName.equals(string)) {
                return baseUnit;
            }
            ++n;
        }
        return null;
    }

    public static synchronized BaseUnit quantityNameToUnit(String string) {
        int n = 0;
        while (n < baseUnits.size()) {
            BaseUnit baseUnit = (BaseUnit)baseUnits.elementAt(n);
            if (baseUnit.quantityName.equals(string)) {
                return baseUnit;
            }
            ++n;
        }
        return null;
    }

    public static void main(String[] stringArray) throws UnitException {
        BaseUnit baseUnit = BaseUnit.addBaseUnit("Length", "meter", "m");
        System.out.println("meter=\"" + baseUnit + "\"");
        System.out.println("(Unit)meter=\"" + baseUnit + "\"");
        System.out.println("meter^2=\"" + baseUnit.pow(2) + "\"");
        System.out.println("((Unit)meter)^2=\"" + ((Unit)baseUnit).pow(2) + "\"");
        System.out.println("(meter^2).sqrt()=\"" + baseUnit.pow(2).sqrt() + "\"");
        BaseUnit baseUnit2 = BaseUnit.addBaseUnit("Time", "second", "s");
        System.out.println("meter*second=\"" + baseUnit.multiply(baseUnit2) + "\"");
        System.out.println("meter/(Unit)second=\"" + baseUnit.divide(baseUnit2) + "\"");
        System.out.println("meter.toThis(5,meter)=" + baseUnit.toThis(5.0, (Unit)baseUnit));
        System.out.println("meter.toThat(5,meter)=" + baseUnit.toThat(5.0, (Unit)baseUnit));
        System.out.println("meter.toThis(5,(Unit)meter)=" + baseUnit.toThis(5.0, (Unit)baseUnit));
        System.out.println("meter.toThat(5,(Unit)meter)=" + baseUnit.toThat(5.0, (Unit)baseUnit));
        double[] dArray = baseUnit.toThis(new double[]{1.0, 2.0}, baseUnit);
        System.out.println("meter.toThis({1,2},meter)=" + dArray[0] + "," + dArray[1]);
        dArray = baseUnit.toThat(new double[]{1.0, 2.0}, baseUnit);
        System.out.println("meter.toThat({1,2},meter)=" + dArray[0] + "," + dArray[1]);
        dArray = baseUnit.toThis(new double[]{1.0, 2.0}, (Unit)baseUnit);
        System.out.println("meter.toThis({1,2},(Unit)meter)=" + dArray[0] + "," + dArray[1]);
        dArray = baseUnit.toThat(new double[]{1.0, 2.0}, (Unit)baseUnit);
        System.out.println("meter.toThat({1,2},(Unit)meter)=" + dArray[0] + "," + dArray[1]);
        System.out.println("Checking exceptions:");
        try {
            baseUnit.toThis(5.0, (Unit)baseUnit2);
            System.err.println("ERROR: second -> meter");
            System.exit(1);
        }
        catch (UnitException unitException) {
            System.out.println(unitException.getMessage());
        }
        try {
            baseUnit.toThat(5.0, (Unit)baseUnit2);
            System.err.println("ERROR: meter -> second");
            System.exit(1);
        }
        catch (UnitException unitException) {
            System.out.println(unitException.getMessage());
        }
        try {
            BaseUnit baseUnit3 = BaseUnit.addBaseUnit("Length", "foot", "ft");
            System.err.println("ERROR: \"foot\" added");
            System.exit(1);
        }
        catch (UnitException unitException) {
            System.out.println(unitException.getMessage());
        }
    }

    double[] toThis(double[] dArray, BaseUnit baseUnit) throws UnitException {
        if (this.equals(baseUnit)) {
            double[] dArray2 = new double[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                dArray2[n] = dArray[n];
                ++n;
            }
            return dArray2;
        }
        throw new UnitException("Attempt to convert from unit \"" + baseUnit + "\" to unit \"" + this + "\"");
    }

    float[] toThis(float[] fArray, BaseUnit baseUnit) throws UnitException {
        if (this.equals(baseUnit)) {
            float[] fArray2 = new float[fArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray2[n] = fArray[n];
                ++n;
            }
            return fArray2;
        }
        throw new UnitException("Attempt to convert from unit \"" + baseUnit + "\" to unit \"" + this + "\"");
    }

    public double[] toThis(double[] dArray, Unit unit) throws UnitException {
        return unit.toThat(dArray, (Unit)this.derivedUnit);
    }

    public float[] toThis(float[] fArray, Unit unit) throws UnitException {
        return unit.toThat(fArray, (Unit)this.derivedUnit);
    }

    double[] toThat(double[] dArray, BaseUnit baseUnit) throws UnitException {
        if (this.equals(baseUnit)) {
            double[] dArray2 = new double[dArray.length];
            int n = 0;
            while (n < dArray.length) {
                dArray2[n] = dArray[n];
                ++n;
            }
            return dArray2;
        }
        throw new UnitException("Attempt to convert from unit \"" + this + "\" to unit \"" + baseUnit + "\"");
    }

    float[] toThat(float[] fArray, BaseUnit baseUnit) throws UnitException {
        if (this.equals(baseUnit)) {
            float[] fArray2 = new float[fArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray2[n] = fArray[n];
                ++n;
            }
            return fArray2;
        }
        throw new UnitException("Attempt to convert from unit \"" + this + "\" to unit \"" + baseUnit + "\"");
    }

    public double[] toThat(double[] dArray, Unit unit) throws UnitException {
        return unit.toThis(dArray, (Unit)this.derivedUnit);
    }

    public float[] toThat(float[] fArray, Unit unit) throws UnitException {
        return unit.toThis(fArray, (Unit)this.derivedUnit);
    }

    public String getDefinition() {
        return this.getIdentifier();
    }

    protected Unit protectedClone(String string) throws UnitException {
        throw new UnitException("Base units may not be cloned");
    }

    public boolean equals(Unit unit) {
        return unit instanceof BaseUnit && this.unitName.equals(((BaseUnit)unit).unitName) && this.quantityName.equals(((BaseUnit)unit).quantityName);
    }

    public Unit multiply(Unit unit) throws UnitException {
        return this.derivedUnit.multiply(unit);
    }

    public Unit divide(Unit unit) throws UnitException {
        return this.derivedUnit.divide(unit);
    }

    protected Unit divideInto(Unit unit) throws UnitException {
        return this.derivedUnit.divideInto(unit);
    }

    public boolean isConvertible(Unit unit) {
        return unit == null ? false : this.derivedUnit.isConvertible(unit);
    }

    private BaseUnit(String string, String string2, String string3) throws UnitException {
        super(string2);
        if (string == null || string2 == null || string3 == null) {
            throw new UnitException("Base unit name, abbreviation, or quantity name is null");
        }
        this.unitName = string;
        this.quantityName = string3;
        baseUnits.addElement(this);
        this.derivedUnit = new DerivedUnit(this);
    }
}

