/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import visad.SI;
import visad.VisADException;

public final class BaseQuantity
implements Serializable {
    private static final Map nameDB = new TreeMap();
    private static final Map aliasDB = new TreeMap();
    private static final AbstractList indexDB = new Vector(8);
    private final String name;
    private final int index;

    public static synchronized BaseQuantity add(String string) throws VisADException {
        String string2 = BaseQuantity.key(string);
        if (nameDB.containsKey(string2)) {
            throw new VisADException("Attempt to redefine existing base quantity \"" + string + "\"");
        }
        BaseQuantity baseQuantity = new BaseQuantity(string, indexDB.size());
        nameDB.put(string2, baseQuantity);
        indexDB.add(baseQuantity);
        return baseQuantity;
    }

    public static synchronized BaseQuantity add(String string, String string2) throws VisADException {
        return BaseQuantity.add(string, new String[]{string2});
    }

    public static synchronized BaseQuantity add(String string, String[] stringArray) throws VisADException {
        int n = 0;
        while (n < stringArray.length) {
            if (aliasDB.containsKey(BaseQuantity.key(stringArray[n]))) {
                throw new VisADException("Attempt to redefine existing base quantity alias \"" + stringArray[n] + "\"");
            }
            ++n;
        }
        BaseQuantity baseQuantity = BaseQuantity.add(string);
        int n2 = 0;
        while (n2 < stringArray.length) {
            aliasDB.put(BaseQuantity.key(stringArray[n2]), baseQuantity);
            ++n2;
        }
        return baseQuantity;
    }

    private static String key(String string) {
        return string.toLowerCase();
    }

    public static synchronized int size() {
        return indexDB.size();
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public static synchronized BaseQuantity getByName(String string) {
        return (BaseQuantity)nameDB.get(BaseQuantity.key(string));
    }

    public static synchronized BaseQuantity getByAlias(String string) {
        return (BaseQuantity)aliasDB.get(BaseQuantity.key(string));
    }

    public static synchronized BaseQuantity get(String string) {
        BaseQuantity baseQuantity = BaseQuantity.getByName(string);
        return baseQuantity != null ? baseQuantity : BaseQuantity.getByAlias(string);
    }

    public static BaseQuantity get(int n) {
        return (BaseQuantity)indexDB.get(n);
    }

    private BaseQuantity(String string, int n) {
        this.name = string;
        this.index = n;
    }

    static {
        try {
            BaseQuantity.add("electric current", new String[]{SI.ampere.quantityName(), "current"});
            BaseQuantity.add("luminous intensity", SI.candela.quantityName());
            BaseQuantity.add("thermodynamic temperature", new String[]{SI.kelvin.quantityName(), "temperature"});
            BaseQuantity.add("mass", SI.kilogram.quantityName());
            BaseQuantity.add("length", SI.meter.quantityName());
            BaseQuantity.add("time", SI.second.quantityName());
            BaseQuantity.add("amount of substance", SI.mole.quantityName());
            BaseQuantity.add("plane angle", new String[]{SI.radian.quantityName(), "angle"});
            BaseQuantity.add("solid angle", SI.steradian.quantityName());
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }
}

