/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.StringTokenizer;
import visad.Control;
import visad.CoordinateSystem;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.Field;
import visad.Function;
import visad.FunctionType;
import visad.Linear1DSet;
import visad.List1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.browser.Convert;
import visad.util.Util;

public class BaseColorControl
extends Control {
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;
    public static final int ALPHA = 3;
    public static final int DEFAULT_NUMBER_OF_COLORS = 256;
    private float[][] table;
    private int tableLength;
    private Function function;
    private transient RealTupleType functionDomainType;
    private transient CoordinateSystem functionCoordinateSystem;
    private transient Unit[] functionUnits;
    private transient Object lock = new Object();
    private final int components;

    public static float[][] initTableGreyWedge(float[][] fArray) {
        if (fArray == null || fArray[0] == null) {
            return null;
        }
        boolean bl = fArray.length > 3;
        int n = fArray[0].length;
        float f = 1.0f / (float)(n - 1);
        int n2 = 0;
        while (n2 < n) {
            fArray[0][n2] = f * (float)n2;
            fArray[1][n2] = f * (float)n2;
            fArray[2][n2] = f * (float)n2;
            if (bl) {
                fArray[3][n2] = f * (float)n2;
            }
            ++n2;
        }
        return fArray;
    }

    public void initGreyWedge() {
        BaseColorControl.initTableGreyWedge(this.table);
    }

    public static float[][] initTableVis5D(float[][] fArray) {
        if (fArray == null || fArray[0] == null) {
            return null;
        }
        boolean bl = fArray.length > 3;
        float f = 1.4f;
        float f2 = 1.0f;
        float f3 = 0.5f * f2;
        int n = fArray[0].length;
        int n2 = 0;
        while (n2 < n) {
            float f4 = (float)n2 / (float)(n - 1);
            float f5 = f * (f4 - f3);
            fArray[0][n2] = (float)(0.5 + 0.5 * Math.atan(7.0 * (double)f5) / 1.57);
            fArray[1][n2] = (float)(0.5 + 0.5 * (2.0 * Math.exp(-7.0f * f5 * f5) - 1.0));
            fArray[2][n2] = (float)(0.5 + 0.5 * Math.atan(-7.0 * (double)f5) / 1.57);
            if (bl) {
                fArray[3][n2] = 1.0f;
            }
            ++n2;
        }
        return fArray;
    }

    public void initVis5D() {
        BaseColorControl.initTableVis5D(this.table);
    }

    public static float[][] initTableHSV(float[][] fArray) {
        if (fArray == null || fArray[0] == null) {
            return null;
        }
        boolean bl = fArray.length > 3;
        float f = 1.0f;
        float f2 = 1.0f;
        int n = fArray[0].length;
        int n2 = 0;
        while (n2 < n) {
            float f3 = (float)(n2 * 6) / (float)(n - 1);
            int n3 = (int)Math.floor(f3);
            float f4 = f3 - (float)n3;
            if ((n3 & 1) == 0) {
                f4 = 1.0f - f4;
            }
            float f5 = f2 * (1.0f - f);
            float f6 = f2 * (1.0f - f * f4);
            switch (n3) {
                case 0: 
                case 6: {
                    fArray[0][n2] = f2;
                    fArray[1][n2] = f6;
                    fArray[2][n2] = f5;
                    break;
                }
                case 1: {
                    fArray[0][n2] = f6;
                    fArray[1][n2] = f2;
                    fArray[2][n2] = f5;
                    break;
                }
                case 2: {
                    fArray[0][n2] = f5;
                    fArray[1][n2] = f2;
                    fArray[2][n2] = f6;
                    break;
                }
                case 3: {
                    fArray[0][n2] = f5;
                    fArray[1][n2] = f6;
                    fArray[2][n2] = f2;
                    break;
                }
                case 4: {
                    fArray[0][n2] = f6;
                    fArray[1][n2] = f5;
                    fArray[2][n2] = f2;
                    break;
                }
                case 5: {
                    fArray[0][n2] = f2;
                    fArray[1][n2] = f5;
                    fArray[2][n2] = f6;
                    break;
                }
            }
            if (bl) {
                fArray[3][n2] = 1.0f;
            }
            ++n2;
        }
        return fArray;
    }

    public void initHSV() {
        BaseColorControl.initTableHSV(this.table);
    }

    public int getNumberOfComponents() {
        return this.components;
    }

    public int getNumberOfColors() {
        return this.tableLength;
    }

    public void setFunction(Function function) throws RemoteException, VisADException {
        FunctionType functionType = this.components == 4 ? FunctionType.REAL_1TO4_FUNCTION : FunctionType.REAL_1TO3_FUNCTION;
        if (function == null || !function.getType().equalsExceptName(functionType)) {
            throw new DisplayException("BaseColorControl.setFunction: function must be 1D-to-" + this.components + "D");
        }
        Object object = this.lock;
        synchronized (object) {
            this.function = function;
            this.functionDomainType = ((FunctionType)this.function.getType()).getDomain();
            this.functionCoordinateSystem = this.function.getDomainCoordinateSystem();
            this.functionUnits = this.function.getDomainUnits();
            this.table = null;
        }
        this.changeControl(true);
    }

    public Function getFunction() {
        return this.function;
    }

    public void setTable(float[][] fArray) throws RemoteException, VisADException {
        if (fArray == null || fArray[0] == null) {
            throw new DisplayException(this.getClass().getName() + ".setTable: " + "Null table");
        }
        if (fArray.length != this.components) {
            if (fArray[0].length == this.components) {
                throw new DisplayException(this.getClass().getName() + ".setTable: " + " Table may be inverted");
            }
            throw new DisplayException(this.getClass().getName() + ".setTable: " + "Unusable table [" + fArray.length + "][" + fArray[0].length + "], expected [" + this.components + "][]");
        }
        if (fArray[0] == null || fArray[1] == null || fArray[2] == null || fArray.length > 3 && fArray[3] == null) {
            throw new DisplayException(this.getClass().getName() + ".setTable: " + "One or more component lists is null");
        }
        if (fArray[0].length != fArray[1].length || fArray[0].length != fArray[2].length || this.components > 3 && fArray[0].length != fArray[3].length) {
            throw new DisplayException("BaseColorControl.setTable: Inconsistent table lengths");
        }
        Object object = this.lock;
        synchronized (object) {
            this.tableLength = fArray[0].length;
            this.table = new float[this.components][this.tableLength];
            int n = 0;
            while (n < this.components) {
                System.arraycopy(fArray[n], 0, this.table[n], 0, this.tableLength);
                ++n;
            }
            this.function = null;
        }
        this.changeControl(true);
    }

    public float[][] getTable() {
        if (this.table == null) {
            return null;
        }
        float[][] fArray = new float[this.components][this.tableLength];
        int n = 0;
        while (n < this.components) {
            System.arraycopy(this.table[n], 0, fArray[n], 0, this.tableLength);
            ++n;
        }
        return fArray;
    }

    public String getSaveString() {
        if (this.table == null) {
            return null;
        }
        int n = this.table.length;
        int n2 = this.table[0].length;
        StringBuffer stringBuffer = new StringBuffer(15 * n * n2);
        stringBuffer.append(n);
        stringBuffer.append(" x ");
        stringBuffer.append(n2);
        stringBuffer.append('\n');
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(this.table[0][n3]);
            int n4 = 1;
            while (n4 < n) {
                stringBuffer.append(' ');
                stringBuffer.append(this.table[n4][n3]);
                ++n4;
            }
            stringBuffer.append('\n');
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void setSaveString(String string) throws RemoteException, VisADException {
        if (string == null) {
            throw new VisADException("Invalid save string");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 3) {
            throw new VisADException("Invalid save string");
        }
        int n2 = Convert.getInt(stringTokenizer.nextToken());
        if (n2 < 1) {
            throw new VisADException("First dimension is not positive");
        }
        if (!stringTokenizer.nextToken().equalsIgnoreCase("x")) {
            throw new VisADException("Invalid save string");
        }
        int n3 = Convert.getInt(stringTokenizer.nextToken());
        if (n3 < 1) {
            throw new VisADException("Second dimension is not positive");
        }
        if (n < 3 + n2 * n3) {
            throw new VisADException("Not enough table entries");
        }
        float[][] fArray = new float[n2][n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                fArray[n5][n4] = Convert.getFloat(stringTokenizer.nextToken());
                ++n5;
            }
            ++n4;
        }
        this.setTable(fArray);
    }

    public float[][] lookupValues(float[] fArray) throws RemoteException, VisADException {
        if (fArray == null) {
            return null;
        }
        int n = this.tableLength - 1;
        int n2 = fArray.length;
        float[][] fArray2 = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.table != null) {
                fArray2 = new float[this.components][n2];
                float f = this.tableLength;
                int n3 = 0;
                while (n3 < n2) {
                    if (fArray[n3] != fArray[n3]) {
                        fArray2[0][n3] = Float.NaN;
                        fArray2[1][n3] = Float.NaN;
                        fArray2[2][n3] = Float.NaN;
                        if (this.components > 3) {
                            fArray2[3][n3] = Float.NaN;
                        }
                    } else {
                        int n4 = (int)(f * fArray[n3]);
                        if (n4 < 0) {
                            fArray2[0][n3] = this.table[0][0];
                            fArray2[1][n3] = this.table[1][0];
                            fArray2[2][n3] = this.table[2][0];
                            if (this.components > 3) {
                                fArray2[3][n3] = this.table[3][0];
                            }
                        } else if (this.tableLength <= n4) {
                            fArray2[0][n3] = this.table[0][n];
                            fArray2[1][n3] = this.table[1][n];
                            fArray2[2][n3] = this.table[2][n];
                            if (this.components > 3) {
                                fArray2[3][n3] = this.table[3][n];
                            }
                        } else {
                            fArray2[0][n3] = this.table[0][n4];
                            fArray2[1][n3] = this.table[1][n4];
                            fArray2[2][n3] = this.table[2][n4];
                            if (this.components > 3) {
                                fArray2[3][n3] = this.table[3][n4];
                            }
                        }
                    }
                    ++n3;
                }
            } else if (this.function != null) {
                List1DSet list1DSet = new List1DSet(fArray, this.functionDomainType, this.functionCoordinateSystem, this.functionUnits);
                Field field = this.function.resample(list1DSet, 100, 202);
                fArray2 = Set.doubleToFloat(field.getValues());
            }
        }
        return fArray2;
    }

    public float[][] lookupRange(int n, int n2) throws VisADException, RemoteException {
        if (n < 0 || n2 >= this.tableLength || n > n2) {
            throw new VisADException("Bad left/right value");
        }
        int n3 = this.tableLength - 1;
        int n4 = n2 - n + 1;
        float[][] fArray = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.table != null) {
                fArray = new float[this.components][n4];
                int n5 = 0;
                while (n5 < n4) {
                    fArray[0][n5] = this.table[0][n5 + n];
                    fArray[1][n5] = this.table[1][n5 + n];
                    fArray[2][n5] = this.table[2][n5 + n];
                    if (this.components > 3) {
                        fArray[3][n5] = this.table[3][n5 + n];
                    }
                    ++n5;
                }
            } else if (this.function != null) {
                double d = this.tableLength;
                Linear1DSet linear1DSet = new Linear1DSet((MathType)this.functionDomainType, (double)n / d, (double)n2 / d, n4, this.functionCoordinateSystem, this.functionUnits, null);
                Field field = this.function.resample(linear1DSet, 100, 202);
                fArray = Set.doubleToFloat(field.getValues());
            }
        }
        return fArray;
    }

    public void setRange(int n, int n2, float[][] fArray) throws VisADException, RemoteException {
        if (n < 0 || n2 >= this.tableLength || n > n2) {
            throw new VisADException("Bad left/right value");
        }
        if (fArray == null || fArray.length != this.components || fArray[0] == null || fArray[1] == null || fArray[2] == null || fArray.length > 3 && fArray[3] == null) {
            throw new VisADException("Bad range table!");
        }
        if (this.table == null) {
            throw new VisADException("Cannot set values for function!");
        }
        int n3 = n2 - n + 1;
        if (fArray[0].length != n3 || fArray[1].length != n3 || fArray[2].length != n3 || fArray.length > 3 && fArray[3].length != n3) {
            throw new VisADException("Array does not contain " + n3 + " colors!");
        }
        Object object = this.lock;
        synchronized (object) {
            int n4 = 0;
            while (n4 < n3) {
                this.table[0][n4 + n] = fArray[0][n4];
                this.table[1][n4 + n] = fArray[1][n4];
                this.table[2][n4 + n] = fArray[2][n4];
                if (this.components > 3) {
                    this.table[3][n4 + n] = fArray[3][n4];
                }
                ++n4;
            }
        }
        this.changeControl(true);
    }

    private boolean tableEquals(float[][] fArray) {
        if (this.table == null) {
            if (fArray != null) {
                return false;
            }
        } else {
            if (fArray == null) {
                return false;
            }
            if (this.table != fArray) {
                if (this.table.length != fArray.length) {
                    return false;
                }
                int n = 0;
                while (n < this.table.length) {
                    if (this.table[n].length != fArray[n].length) {
                        return false;
                    }
                    ++n;
                }
                n = 0;
                while (n < this.table.length) {
                    int n2 = 0;
                    while (n2 < this.table[n].length) {
                        if (!Util.isApproximatelyEqual(this.table[n][n2], fArray[n][n2])) {
                            return false;
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
        return true;
    }

    private boolean functionEquals(Function function) {
        if (this.function == null) {
            if (function != null) {
                return false;
            }
        } else {
            if (function == null) {
                return false;
            }
            if (!this.function.equals(function)) {
                return false;
            }
        }
        return true;
    }

    public void syncControl(Control control) throws VisADException {
        boolean bl;
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof BaseColorControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        BaseColorControl baseColorControl = (BaseColorControl)control;
        boolean bl2 = false;
        boolean bl3 = !this.tableEquals(baseColorControl.table);
        boolean bl4 = bl = !this.functionEquals(baseColorControl.function);
        if (bl3) {
            if (baseColorControl.table == null) {
                boolean bl5 = bl ? baseColorControl.function == null : this.function == null;
                if (bl5) {
                    throw new VisADException("BaseColorControl has null Table, but no Function");
                }
                this.table = null;
            } else {
                if (baseColorControl.table.length != this.components) {
                    throw new VisADException("Table must be float[" + this.components + "][], not float[" + baseColorControl.table.length + "][]");
                }
                Object object = this.lock;
                synchronized (object) {
                    this.tableLength = baseColorControl.table[0].length;
                    int n = 0;
                    while (n < this.components) {
                        if (this.table[n].length != baseColorControl.table[n].length) {
                            this.table[n] = new float[baseColorControl.table[n].length];
                        }
                        System.arraycopy(baseColorControl.table[n], 0, this.table[n], 0, baseColorControl.table[n].length);
                        ++n;
                    }
                    this.tableLength = this.table[0].length;
                    this.function = null;
                }
                try {
                    this.changeControl(true);
                }
                catch (RemoteException remoteException) {
                    throw new VisADException("Could not indicate that control changed: " + remoteException.getMessage());
                }
            }
        }
        if (bl) {
            if (baseColorControl.function == null) {
                if (this.table == null) {
                    throw new VisADException("ColorControl has null Function, but no Table");
                }
                this.function = null;
            } else {
                try {
                    this.setFunction(baseColorControl.function);
                }
                catch (RemoteException remoteException) {
                    throw new VisADException("Could not set function: " + remoteException.getMessage());
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        BaseColorControl baseColorControl = (BaseColorControl)object;
        if (this.tableLength != baseColorControl.tableLength) {
            return false;
        }
        if (!this.tableEquals(baseColorControl.table)) {
            return false;
        }
        return this.functionEquals(baseColorControl.function);
    }

    public Object clone() {
        BaseColorControl baseColorControl = (BaseColorControl)super.clone();
        if (this.table != null) {
            baseColorControl.table = new float[this.table.length][];
            int n = this.table.length - 1;
            while (n >= 0) {
                baseColorControl.table[n] = (float[])this.table[n].clone();
                --n;
            }
        }
        return baseColorControl;
    }

    private static char dirChar(int n, int n2, int n3) {
        if (n == 0 || n2 == 0 || n3 == 0) {
            if (n > 0) {
                if (n3 > 0) {
                    if (n > n3) {
                        return 'v';
                    }
                    return '^';
                }
                if (n2 > 0) {
                    return '~';
                }
                return '\\';
            }
            if (n3 > 0) {
                if (n2 > 0) {
                    return '~';
                }
                return '/';
            }
            return '_';
        }
        if (n > n2) {
            if (n > n2 + n3) {
                return '\\';
            }
            if (n3 > n + n2) {
                return '/';
            }
            if (n3 > n2) {
                return '^';
            }
        }
        if (n3 > n2) {
            if (n3 > n + n2) {
                return '/';
            }
            if (n > n2 + n3) {
                return '\\';
            }
        }
        if (n2 > n + n3) {
            return '-';
        }
        return '~';
    }

    public String toString() {
        int n = this.tableLength;
        int n2 = 1;
        while (n > 32) {
            n >>= 1;
            n2 <<= 1;
        }
        String string = this.getClass().getName();
        int n3 = string.lastIndexOf(46);
        if (n3 >= 0) {
            string = string.substring(n3 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('[');
        String string2 = "RGBA";
        int n4 = 0;
        while (n4 < this.components) {
            if (n4 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(string2.charAt(n4));
            stringBuffer.append('=');
            float f = this.table[n4][0];
            int n5 = 0;
            while (n5 < this.tableLength) {
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                while (n9 < n2) {
                    float f2 = this.table[n4][n5 + n9];
                    if ((double)Math.abs(f2 - f) <= 1.0E-4) {
                        ++n7;
                    } else if (f2 < f) {
                        ++n8;
                    } else {
                        ++n6;
                    }
                    f = f2;
                    ++n9;
                }
                stringBuffer.append(BaseColorControl.dirChar(n8, n7, n6));
                n5 += n2;
            }
            ++n4;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public BaseColorControl(DisplayImpl displayImpl, int n) {
        super(displayImpl);
        if (n < 3) {
            n = 3;
        } else if (n > 4) {
            n = 4;
        }
        this.components = n;
        this.tableLength = 256;
        this.table = BaseColorControl.initTableVis5D(new float[n][this.tableLength]);
    }
}

