/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import visad.CommonUnit;
import visad.Display;
import visad.DisplayException;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayRenderer;
import visad.PlotText;
import visad.ProjectionControl;
import visad.Real;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.ShadowType;
import visad.TextControl;
import visad.Unit;
import visad.VisADException;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.util.HersheyFont;

public class AxisScale
implements Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int Z_AXIS = 2;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    private static final double TICKSIZE = 0.5;
    private boolean screenBased = false;
    private VisADLineArray scaleArray;
    private VisADTriangleArray labelArray;
    private ScalarMap scalarMap;
    private Color myColor = Color.white;
    private double[] dataRange = new double[2];
    private int myAxis = -1;
    private int axisOrdinal = -1;
    private String myTitle;
    private Hashtable labelTable;
    private double majorTickSpacing = 0.0;
    private double minorTickSpacing = 0.0;
    private double tickBase = 0.0;
    private boolean autoComputeTicks = true;
    private boolean baseLineVisible = true;
    private boolean snapToBox = false;
    private boolean userLabels = false;
    private boolean visibility = true;
    private Object labelFont = null;
    private int labelSize = 12;
    private int axisSide = 0;
    private int tickOrient = 0;
    private NumberFormat labelFormat = null;

    public int getAxisOrdinal() {
        return this.axisOrdinal;
    }

    void setAxisOrdinal(int n) {
        this.axisOrdinal = n;
    }

    public void setLabel(String string) {
        this.setTitle(string);
    }

    public String getLabel() {
        return this.getTitle();
    }

    public void setTitle(String string) {
        String string2 = this.myTitle;
        this.myTitle = string;
        if (!this.myTitle.equals(string2)) {
            try {
                if (!this.myTitle.equals(this.scalarMap.getScalarName())) {
                    this.scalarMap.setScalarName(this.myTitle);
                }
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public String getTitle() {
        return this.myTitle;
    }

    public int getAxis() {
        return this.myAxis;
    }

    public VisADLineArray getScaleArray() {
        return this.scaleArray;
    }

    public VisADTriangleArray getLabelArray() {
        return this.labelArray;
    }

    public void setScreenBased(boolean bl) {
        this.screenBased = bl;
    }

    public boolean getScreenBased() {
        return this.screenBased;
    }

    public boolean makeScreenBasedScale(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) throws VisADException {
        DisplayImpl displayImpl = this.scalarMap.getDisplay();
        if (displayImpl == null) {
            return false;
        }
        DisplayRenderer displayRenderer = displayImpl.getDisplayRenderer();
        if (displayRenderer == null) {
            return false;
        }
        if (this.axisOrdinal < 0) {
            return false;
        }
        this.dataRange = this.scalarMap.getRange();
        if (!displayRenderer.getMode2D()) {
            return false;
        }
        boolean bl = true;
        ProjectionControl projectionControl = displayImpl.getProjectionControl();
        double[] dArray = projectionControl.getAspectCartesian();
        double d9 = 1.0;
        double d10 = -1.0;
        double d11 = 1.0;
        double d12 = -1.0;
        if (this.myAxis == 0) {
            d9 = dArray[0];
            d10 = -dArray[0];
            d11 = d7;
            d12 = d5;
        } else if (this.myAxis == 1) {
            d9 = dArray[1];
            d10 = -dArray[1];
            d11 = d8;
            d12 = d6;
        }
        double d13 = (this.dataRange[1] - this.dataRange[0]) / (d9 - d10);
        double d14 = (d11 - d10) * d13 + this.dataRange[0];
        double d15 = (d12 - d10) * d13 + this.dataRange[0];
        double[] dArray2 = new double[]{d15, d14};
        double d16 = 0.0;
        double d17 = -d16;
        double d18 = (double)this.labelSize / 200.0;
        double d19 = 1.05;
        d18 *= 0.8;
        int n = 0;
        int n2 = 0;
        if (this.snapToBox) {
            d19 = 1.0;
        } else {
            Enumeration enumeration = displayImpl.getMapVector().elements();
            while (enumeration.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                if (!scalarMap.getDisplayScalar().equals(this.scalarMap.getDisplayScalar()) || this.getSide() != scalarMap.getAxisScale().getSide()) continue;
                if (scalarMap.equals(this.scalarMap)) {
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        double d20 = 4.0 * (double)n2 * d18;
        return this.makeScale(bl, d, d2, d16, d3, d4, d17, d18, d19, d20, dArray2);
    }

    public boolean makeScale() throws VisADException {
        DisplayImpl displayImpl = this.scalarMap.getDisplay();
        if (displayImpl == null) {
            return false;
        }
        DisplayRenderer displayRenderer = displayImpl.getDisplayRenderer();
        if (displayRenderer == null) {
            return false;
        }
        if (this.axisOrdinal < 0) {
            this.axisOrdinal = displayRenderer.getAxisOrdinal(this.myAxis);
        }
        this.dataRange = this.scalarMap.getRange();
        boolean bl = displayRenderer.getMode2D();
        ProjectionControl projectionControl = displayImpl.getProjectionControl();
        double[] dArray = projectionControl.getAspectCartesian();
        double d = -dArray[0];
        double d2 = -dArray[1];
        double d3 = -dArray[2];
        double d4 = -d;
        double d5 = -d2;
        double d6 = -d3;
        double d7 = (double)this.labelSize / 200.0;
        double d8 = 1.05;
        int n = 0;
        int n2 = 0;
        if (this.snapToBox) {
            d8 = 1.0;
        } else {
            Enumeration enumeration = displayImpl.getMapVector().elements();
            while (enumeration.hasMoreElements()) {
                ScalarMap scalarMap = (ScalarMap)enumeration.nextElement();
                if (!scalarMap.getDisplayScalar().equals(this.scalarMap.getDisplayScalar()) || this.getSide() != scalarMap.getAxisScale().getSide()) continue;
                if (scalarMap.equals(this.scalarMap)) {
                    n2 = n;
                    break;
                }
                ++n;
            }
        }
        double d9 = 4.0 * (double)n2 * d7;
        return this.makeScale(bl, d, d2, d3, d4, d5, d6, d7, d8, d9, this.dataRange);
    }

    /*
     * Unable to fully structure code
     */
    public boolean makeScale(boolean var1_2, double var2_3, double var4_5, double var6_7, double var8_8, double var10_9, double var12_10, double var14_11, double var16_1, double var18_4, double[] var20_6) throws VisADException {
        block61: {
            var21_12 = null;
            var22_13 = null;
            var23_14 = null;
            var24_15 = null;
            var25_16 = new Vector<VisADLineArray>(4);
            var26_17 = new Vector<VisADTriangleArray>();
            var27_18 = 1.0;
            if (var20_6[0] > var20_6[1]) {
                var27_18 = -1.0;
            }
            if (this.myAxis == 0) {
                if (this.getSide() == 0) {
                    var21_12 = new double[]{var14_11, 0.0, 0.0};
                    var22_13 = new double[]{0.0, var14_11, var14_11};
                    var24_15 = new double[]{var27_18 * var8_8, var4_5 - (var16_1 - 1.0 + var18_4), var6_7 - (var16_1 - 1.0 + var18_4)};
                    var23_14 = new double[]{var27_18 * var2_3, var4_5 - (var16_1 - 1.0 + var18_4), var6_7 - (var16_1 - 1.0 + var18_4)};
                } else {
                    var21_12 = new double[]{-var14_11, 0.0, 0.0};
                    var22_13 = new double[]{0.0, -var14_11, var14_11};
                    var24_15 = new double[]{var27_18 * var8_8, var10_9 + (var16_1 - 1.0 + var18_4), var6_7 - (var16_1 - 1.0 + var18_4)};
                    var23_14 = new double[]{var27_18 * var2_3, var10_9 + (var16_1 - 1.0 + var18_4), var6_7 - (var16_1 - 1.0 + var18_4)};
                }
            } else if (this.myAxis == 1) {
                if (this.getSide() == 0) {
                    var21_12 = new double[]{0.0, -var14_11, 0.0};
                    var22_13 = new double[]{var14_11, 0.0, var14_11};
                    var24_15 = new double[]{var2_3 - (var16_1 - 1.0 + var18_4), var27_18 * var10_9, var6_7 - (var16_1 - 1.0 + var18_4)};
                    var23_14 = new double[]{var2_3 - (var16_1 - 1.0 + var18_4), var27_18 * var4_5, var6_7 - (var16_1 - 1.0 + var18_4)};
                } else {
                    var21_12 = new double[]{0.0, var14_11, 0.0};
                    var22_13 = new double[]{-var14_11, 0.0, var14_11};
                    var24_15 = new double[]{var8_8 + (var16_1 - 1.0 + var18_4), var27_18 * var10_9, var6_7 - (var16_1 - 1.0 + var18_4)};
                    var23_14 = new double[]{var8_8 + (var16_1 - 1.0 + var18_4), var27_18 * var4_5, var6_7 - (var16_1 - 1.0 + var18_4)};
                }
            } else if (this.myAxis == 2) {
                if (this.getSide() == 0) {
                    var21_12 = new double[]{0.0, 0.0, -var14_11};
                    var22_13 = new double[]{var14_11, var14_11, 0.0};
                    var24_15 = new double[]{var2_3 - (var16_1 - 1.0 + var18_4), var4_5 - (var16_1 - 1.0 + var18_4), var27_18 * var12_10};
                    var23_14 = new double[]{var2_3 - (var16_1 - 1.0 + var18_4), var4_5 - (var16_1 - 1.0 + var18_4), var27_18 * var6_7};
                } else {
                    var21_12 = new double[]{0.0, 0.0, var14_11};
                    var22_13 = new double[]{-var14_11, var14_11, 0.0};
                    var24_15 = new double[]{var8_8 + (var16_1 - 1.0 + var18_4), var4_5 - (var16_1 - 1.0 + var18_4), var27_18 * var12_10};
                    var23_14 = new double[]{var8_8 + (var16_1 - 1.0 + var18_4), var4_5 - (var16_1 - 1.0 + var18_4), var27_18 * var6_7};
                }
            }
            if (var1_2) {
                if (this.myAxis == 2) {
                    return false;
                }
                var21_12[2] = 0.0;
                var22_13[2] = 0.0;
                var23_14[2] = 0.0;
                var24_15[2] = 0.0;
            }
            if (this.baseLineVisible) {
                var29_19 = new VisADLineArray();
                var30_21 = new float[6];
                var31_22 = 0;
                while (var31_22 < 3) {
                    var30_21[var31_22] = (float)var23_14[var31_22];
                    var30_21[3 + var31_22] = (float)var24_15[var31_22];
                    ++var31_22;
                }
                var29_19.vertexCount = 2;
                var29_19.coordinates = var30_21;
                var25_16.add(var29_19);
            }
            var29_20 = Math.abs(var20_6[1] - var20_6[0]);
            var31_23 = Math.min(var20_6[0], var20_6[1]);
            var33_24 = Math.max(var20_6[0], var20_6[1]);
            var35_25 = 1.0;
            if (!(var29_20 < var35_25)) ** GOTO lbl76
            var35_25 /= 10.0;
            while (var29_20 < var35_25) {
                var35_25 /= 10.0;
            }
            break block61;
lbl-1000:
            // 1 sources

            {
                var35_25 *= 10.0;
lbl76:
                // 2 sources

                ** while (10.0 * var35_25 <= var29_20)
            }
        }
        if (this.autoComputeTicks || this.majorTickSpacing <= 0.0) {
            var37_26 = var29_20 / var35_25;
            if (var37_26 < 2.0) {
                var35_25 /= 5.0;
            } else if (var37_26 < 4.0) {
                var35_25 /= 2.0;
            }
            this.majorTickSpacing = var35_25;
        }
        var37_27 = this.computeTicks(var33_24, var31_23, this.tickBase, this.majorTickSpacing);
        var38_28 = var37_27[0];
        var40_29 = var37_27[0];
        var42_30 = var37_27[var37_27.length - 1];
        var44_31 = new VisADLineArray();
        var45_32 = (int)((var42_30 - var40_29) / this.majorTickSpacing) + 1;
        var46_33 = new float[6 * var45_32];
        var47_34 = var22_13;
        if (this.getTickOrientation() != 0) {
            if (this.myAxis == 0) {
                var47_34 = new double[]{var22_13[0], -var22_13[1], -var22_13[2]};
            } else if (this.myAxis == 1) {
                var47_34 = new double[]{-var22_13[0], var22_13[1], -var22_13[2]};
            } else if (this.myAxis == 2) {
                var47_34 = new double[]{-var22_13[0], -var22_13[1], var22_13[2]};
            }
        }
        var48_35 = 0;
        var49_36 = 0;
        while (var49_36 < var45_32) {
            var50_39 = var38_28 + (double)var49_36 * this.majorTickSpacing;
            var52_42 = (var50_39 - var31_23) / (var33_24 - var31_23);
            var54_43 = 0;
            while (var54_43 < 3) {
                if (var48_35 + 3 + var54_43 < var46_33.length) {
                    var46_33[var48_35 + var54_43] = (float)((1.0 - var52_42) * var23_14[var54_43] + var52_42 * var24_15[var54_43]);
                    var46_33[var48_35 + 3 + var54_43] = (float)((double)var46_33[var48_35 + var54_43] - 0.5 * var47_34[var54_43]);
                }
                ++var54_43;
            }
            var48_35 += 6;
            ++var49_36;
        }
        var44_31.vertexCount = 2 * var45_32;
        var44_31.coordinates = var46_33;
        var25_16.add(var44_31);
        if (this.getMinorTickSpacing() > 0.0) {
            var37_27 = this.computeTicks(var33_24, var31_23, this.tickBase, this.minorTickSpacing);
            var49_37 = new VisADLineArray();
            var45_32 = (int)((var37_27[var37_27.length - 1] - var37_27[0]) / this.minorTickSpacing) + 1;
            var50_40 = new float[6 * var45_32];
            var48_35 = 0;
            var51_47 = 0;
            while (var51_47 < var45_32) {
                var52_42 = var37_27[0] + (double)var51_47 * this.minorTickSpacing;
                var54_45 = (var52_42 - var31_23) / (var33_24 - var31_23);
                var56_49 = 0;
                while (var56_49 < 3) {
                    if (var48_35 + 3 + var56_49 < var50_40.length) {
                        var50_40[var48_35 + var56_49] = (float)((1.0 - var54_45) * var23_14[var56_49] + var54_45 * var24_15[var56_49]);
                        var50_40[var48_35 + 3 + var56_49] = (float)((double)var50_40[var48_35 + var56_49] - 0.25 * var47_34[var56_49]);
                    }
                    ++var56_49;
                }
                var48_35 += 6;
                ++var51_47;
            }
            var49_37.vertexCount = 2 * var45_32;
            var49_37.coordinates = var50_40;
            var25_16.add(var49_37);
        }
        var49_38 = TextControl.Justification.CENTER;
        var50_41 = new double[3];
        var51_48 = 2.5;
        if (var1_2) {
            if (this.myAxis == 0) {
                var21_12 = new double[]{var14_11, 0.0, 0.0};
                var22_13 = new double[]{0.0, var14_11, 0.0};
                var51_48 = this.getSide() == 0 ? 3.0 : -1.95;
            } else if (this.myAxis == 1) {
                var21_12 = new double[]{0.0, var14_11, 0.0};
                var22_13 = new double[]{-var14_11, 0.0, 0.0};
                var51_48 = this.getSide() == 0 ? -2.0 : 2.95;
            }
        }
        var53_54 = 0;
        while (var53_54 < 3) {
            var50_41[var53_54] = 0.5 * (var23_14[var53_54] + var24_15[var53_54]) - var51_48 * var22_13[var53_54];
            ++var53_54;
        }
        if (this.labelFont == null) {
            var53_55 = PlotText.render_label(this.myTitle, var50_41, var21_12, var22_13, var49_38);
            var25_16.add(var53_55);
        } else if (this.labelFont instanceof Font) {
            var53_56 = PlotText.render_font(this.myTitle, (Font)this.labelFont, var50_41, var21_12, var22_13, var49_38);
            var26_17.add(var53_56);
        } else if (this.labelFont instanceof HersheyFont) {
            var53_57 = PlotText.render_font(this.myTitle, (HersheyFont)this.labelFont, var50_41, var21_12, var22_13, var49_38);
            var25_16.add(var53_57);
        }
        if (!this.userLabels) {
            this.createStandardLabels(var42_30, var40_29, var40_29, var42_30 - var40_29, false);
        }
        var51_48 = 1.5;
        if (!var1_2) {
            v0 = var22_13;
        } else {
            v1 = new double[3];
            v1[0] = 0.0;
            v1[1] = var14_11;
            v0 = v1;
            v1[2] = 0.0;
        }
        var53_58 = v0;
        if (var1_2) {
            var21_12 = new double[]{var14_11, 0.0, 0.0};
            if (this.myAxis == 0) {
                var51_48 = this.getSide() == 0 ? 1.65 : -0.65;
            } else if (this.myAxis == 1) {
                var51_48 = this.getSide() == 0 ? -0.65 : 0.65;
                var49_38 = this.getSide() == 0 ? TextControl.Justification.RIGHT : TextControl.Justification.LEFT;
            }
        }
        var54_46 = this.labelTable.keys();
        while (var54_46.hasMoreElements()) {
            try {
                var55_59 = (VisADTriangleArray[])var54_46.nextElement();
            }
            catch (ClassCastException var56_51) {
                throw new VisADException("Invalid keys in label hashtable");
            }
            var56_52 = var55_59.doubleValue();
            if (var56_52 > var33_24 || var56_52 < var31_23) continue;
            var58_60 = (var56_52 - var31_23) / (var33_24 - var31_23);
            if (this.myAxis == 1 && var1_2) {
                var58_60 -= 0.2 * var14_11;
            }
            var60_62 = new double[3];
            var61_64 = 0;
            while (var61_64 < 3) {
                var60_62[var61_64] = (1.0 - var58_60) * var23_14[var61_64] + var58_60 * var24_15[var61_64] - var51_48 * var22_13[var61_64];
                ++var61_64;
            }
            if (this.labelFont == null) {
                var61_65 = PlotText.render_label((String)this.labelTable.get(var55_59), var60_62, var21_12, var53_58, var49_38);
                var25_16.add(var61_65);
                continue;
            }
            if (this.labelFont instanceof Font) {
                var61_66 = PlotText.render_font((String)this.labelTable.get(var55_59), (Font)this.labelFont, var60_62, var21_12, var53_58, var49_38);
                var26_17.add(var61_66);
                continue;
            }
            if (!(this.labelFont instanceof HersheyFont)) continue;
            var61_67 = PlotText.render_font((String)this.labelTable.get(var55_59), (HersheyFont)this.labelFont, var60_62, var21_12, var53_58, var49_38);
            var25_16.add(var61_67);
        }
        var54_46 = var25_16.toArray(new VisADLineArray[var25_16.size()]);
        this.scaleArray = VisADLineArray.merge(var54_46);
        if (!var26_17.isEmpty()) {
            var55_59 = var26_17.toArray(new VisADTriangleArray[var26_17.size()]);
            this.labelArray = VisADTriangleArray.merge(var55_59);
            var56_53 = this.myColor.getColorComponents(null);
            var57_69 = ShadowType.floatToByte(var56_53[0]);
            var58_61 = ShadowType.floatToByte(var56_53[1]);
            var59_70 = ShadowType.floatToByte(var56_53[2]);
            var60_63 = 3 * this.labelArray.vertexCount;
            var61_68 = new byte[var60_63];
            var62_71 = 0;
            while (var62_71 < var60_63) {
                var61_68[var62_71] = var57_69;
                var61_68[var62_71 + 1] = var58_61;
                var61_68[var62_71 + 2] = var59_70;
                var62_71 += 3;
            }
            this.labelArray.colors = var61_68;
        }
        return true;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setColor(Color color) {
        Color color2 = this.myColor;
        this.myColor = color;
        if (this.myColor != null && !this.myColor.equals(color2)) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setColor(float[] fArray) {
        this.setColor(new Color(fArray[0], fArray[1], fArray[2]));
    }

    AxisScale clone(ScalarMap scalarMap) throws VisADException {
        AxisScale axisScale = new AxisScale(scalarMap);
        if (!scalarMap.getDisplayScalar().equals(this.scalarMap.getDisplayScalar())) {
            throw new VisADException("AxisScale: DisplayScalar for map is not" + this.scalarMap.getDisplayScalar());
        }
        axisScale.myColor = this.myColor;
        axisScale.axisOrdinal = this.axisOrdinal;
        axisScale.myAxis = this.myAxis;
        axisScale.myTitle = this.myTitle;
        axisScale.labelTable = (Hashtable)this.labelTable.clone();
        axisScale.majorTickSpacing = this.majorTickSpacing;
        axisScale.minorTickSpacing = this.minorTickSpacing;
        axisScale.autoComputeTicks = this.autoComputeTicks;
        axisScale.baseLineVisible = this.baseLineVisible;
        axisScale.snapToBox = this.snapToBox;
        axisScale.labelFont = this.labelFont;
        axisScale.labelSize = this.labelSize;
        axisScale.axisSide = this.axisSide;
        axisScale.tickOrient = this.tickOrient;
        axisScale.userLabels = this.userLabels;
        return axisScale;
    }

    public void setMajorTickSpacing(double d) {
        double d2 = this.majorTickSpacing;
        this.majorTickSpacing = Math.abs(d);
        this.autoComputeTicks = false;
        if (this.majorTickSpacing != d2) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public double getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMinorTickSpacing(double d) {
        double d2 = this.minorTickSpacing;
        this.minorTickSpacing = Math.abs(d);
        if (this.minorTickSpacing != d2) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public double getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setAutoComputeTicks(boolean bl) {
        boolean bl2 = this.autoComputeTicks;
        this.autoComputeTicks = bl;
        if (this.autoComputeTicks != bl2) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void createStandardLabels(double d, double d2, double d3, double d4) {
        if (d2 > d) {
            throw new IllegalArgumentException("max must be greater than min");
        }
        if (d4 > d - d2) {
            throw new IllegalArgumentException("increment must be less than or equal to range (max-min)");
        }
        this.createStandardLabels(d, d2, d3, d4, true);
    }

    private void createStandardLabels(double d, double d2, double d3, double d4, boolean bl) {
        this.labelTable.clear();
        double[] dArray = this.computeTicks(d, d2, d3, d4);
        if (dArray != null) {
            int n = 0;
            while (n < dArray.length) {
                this.labelTable.put(new Double(dArray[n]), this.createLabelString(dArray[n]));
                ++n;
            }
        }
        if (bl) {
            try {
                this.userLabels = true;
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setLabelTable(Hashtable hashtable) throws VisADException {
        Hashtable hashtable2 = this.labelTable;
        this.labelTable = hashtable;
        if (hashtable != hashtable2) {
            this.userLabels = true;
            this.scalarMap.makeScale();
        }
    }

    public Hashtable getLabelTable() {
        return this.labelTable;
    }

    public void setFont(Font font) {
        Object object = this.labelFont;
        this.labelFont = font;
        if (this.labelFont != null && !this.labelFont.equals(object)) {
            if (this.labelFont instanceof Font) {
                this.labelSize = ((Font)this.labelFont).getSize();
            }
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setFont(HersheyFont hersheyFont) {
        Object object = this.labelFont;
        this.labelFont = hersheyFont;
        if (this.labelFont != null && !this.labelFont.equals(object)) {
            this.labelSize = 12;
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public Font getFont() {
        return this.labelFont instanceof Font ? (Font)this.labelFont : null;
    }

    public void setBaseLineVisible(boolean bl) {
        boolean bl2 = this.baseLineVisible;
        this.baseLineVisible = bl;
        if (this.baseLineVisible != bl2) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean getBaseLineVisible() {
        return this.baseLineVisible;
    }

    public void setSnapToBox(boolean bl) {
        boolean bl2 = this.snapToBox;
        this.snapToBox = bl;
        if (this.snapToBox != bl2) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean getSnapToBox() {
        return this.snapToBox;
    }

    public void setLabelSize(int n) {
        int n2 = this.labelSize;
        this.labelSize = n;
        if (this.labelSize != n2) {
            if (this.labelFont != null && this.labelFont instanceof Font) {
                this.labelFont = new Font(((Font)this.labelFont).getName(), ((Font)this.labelFont).getStyle(), this.labelSize);
            }
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public int getLabelSize() {
        return this.labelSize;
    }

    public void setTickBase(double d) {
        double d2 = this.tickBase;
        this.tickBase = d;
        if (this.tickBase != d2) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setSide(int n) {
        double d = this.axisSide;
        int n2 = this.axisSide = n == 1 ? 1 : 0;
        if ((double)this.axisSide != d) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public int getSide() {
        return this.axisSide;
    }

    public void setTickOrientation(int n) {
        double d = this.tickOrient;
        int n2 = this.tickOrient = n == 1 ? 1 : 0;
        if ((double)this.tickOrient != d) {
            try {
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public int getTickOrientation() {
        return this.tickOrient;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.labelFormat = numberFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.labelFormat;
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.visibility;
        this.visibility = bl;
        if (bl2 != this.visibility) {
            try {
                if (bl != this.scalarMap.getScaleEnable()) {
                    this.scalarMap.setScaleEnable(bl);
                }
                this.scalarMap.makeScale();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public boolean isVisible() {
        return this.scalarMap.getScaleEnable();
    }

    private double[] computeTicks(double d, double d2, double d3, double d4) {
        double[] dArray = null;
        long l = Math.round(Math.ceil((d2 - d3) / Math.abs(d4)));
        long l2 = Math.round(Math.floor((d - d3) / Math.abs(d4)));
        int n = (int)(l2 - l) + 1;
        if (n < 1) {
            return dArray;
        }
        dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = d3 + (double)(l + (long)n2) * d4;
            ++n2;
        }
        return dArray;
    }

    private String createLabelString(double d) {
        RealType realType;
        Unit unit;
        String string = null;
        ScalarType scalarType = this.scalarMap.getScalar();
        string = scalarType instanceof RealType ? (Unit.canConvert(CommonUnit.secondsSinceTheEpoch, unit = (realType = (RealType)scalarType).getDefaultUnit()) && !unit.getAbsoluteUnit().equals(unit) ? new Real(realType, d).toValueString() : (this.labelFormat != null ? this.labelFormat.format(d) : PlotText.shortString(d))) : (this.labelFormat != null ? this.labelFormat.format(d) : PlotText.shortString(d));
        return string;
    }

    public AxisScale(ScalarMap scalarMap) throws VisADException {
        DisplayRenderer displayRenderer;
        this.scalarMap = scalarMap;
        DisplayRealType displayRealType = this.scalarMap.getDisplayScalar();
        if (!(displayRealType.equals(Display.XAxis) || displayRealType.equals(Display.YAxis) || displayRealType.equals(Display.ZAxis))) {
            throw new DisplayException("AxisSale: DisplayScalar must be XAxis, YAxis or ZAxis");
        }
        this.myAxis = displayRealType.equals(Display.XAxis) ? 0 : (displayRealType.equals(Display.YAxis) ? 1 : 2);
        this.myTitle = this.scalarMap.getScalarName();
        this.visibility = this.scalarMap.getScaleEnable();
        this.labelTable = new Hashtable();
        DisplayImpl displayImpl = this.scalarMap.getDisplay();
        if (displayImpl != null && (displayRenderer = displayImpl.getDisplayRenderer()) != null) {
            float[] fArray = displayRenderer.getRendererControl().getForegroundColor();
            this.myColor = new Color(fArray[0], fArray[1], fArray[2]);
            boolean bl = this.makeScale();
        }
    }
}

