/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import visad.AnimationControl;
import visad.Control;
import visad.DisplayImpl;
import visad.Set;
import visad.UnimplementedException;
import visad.VisADException;

public class AnimationSetControl
extends Control {
    private Set set;
    private transient AnimationControl parent;

    public Set getSet() {
        return this.set;
    }

    public int clipCurrent(int n) throws VisADException {
        if (this.set == null || n >= this.set.getLength()) {
            n = 0;
        } else if (n < 0) {
            n = this.set.getLength() - 1;
        }
        return n;
    }

    public double getValue(int n) throws VisADException {
        int[] nArray = new int[]{this.clipCurrent(n)};
        if (this.set == null) {
            return Double.NaN;
        }
        double[][] dArray = this.set.indexToDouble(nArray);
        return dArray[0][0];
    }

    public int getIndex(double d) throws VisADException {
        if (this.set == null) {
            return 0;
        }
        double[][] dArray = new double[][]{{d}};
        int[] nArray = this.set.doubleToIndex(dArray);
        return nArray[0] < 0 ? 0 : nArray[0];
    }

    public void setSet(Set set) throws VisADException, RemoteException {
        this.setSet(set, false);
    }

    public void setSet(Set set, boolean bl) throws VisADException, RemoteException {
        this.set = set;
        if (this.parent != null) {
            this.parent.setCurrent(this.clipCurrent(this.parent.getCurrent()));
        }
        this.changeControl(!bl);
    }

    public String getSaveString() {
        return null;
    }

    public void setSaveString(String string) throws VisADException, RemoteException {
        throw new UnimplementedException("Cannot setSaveString on this type of control");
    }

    public void syncControl(Control control) throws VisADException {
        if (control == null) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with null Control object");
        }
        if (!(control instanceof AnimationSetControl)) {
            throw new VisADException("Cannot synchronize " + this.getClass().getName() + " with " + control.getClass().getName());
        }
        AnimationSetControl animationSetControl = (AnimationSetControl)control;
        boolean bl = false;
        if (this.set == null) {
            if (animationSetControl.set != null) {
                bl = true;
            }
        } else if (animationSetControl.set == null) {
            bl = true;
        } else if (!this.set.equals(animationSetControl.set)) {
            bl = true;
        }
        if (bl) {
            try {
                this.setSet(animationSetControl.set);
            }
            catch (RemoteException remoteException) {
                throw new VisADException("Could not set Set: " + remoteException.getMessage());
            }
        }
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        AnimationSetControl animationSetControl = (AnimationSetControl)object;
        if (this.set == null) {
            if (animationSetControl.set != null) {
                return false;
            }
        } else {
            if (animationSetControl.set == null) {
                return false;
            }
            if (!this.set.equals(animationSetControl.set)) {
                return false;
            }
        }
        return true;
    }

    public AnimationSetControl(DisplayImpl displayImpl, AnimationControl animationControl) {
        super(displayImpl);
        this.parent = animationControl;
        this.set = null;
    }
}

