/*
 * Decompiled with CFR 0.152.
 */
package visad;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.Action;
import visad.ReferenceActionLink;
import visad.ReferenceException;
import visad.RemoteThingReference;
import visad.RemoteVisADException;
import visad.ThingChangedEvent;
import visad.ThingReference;
import visad.ThingReferenceImpl;
import visad.VisADError;
import visad.VisADException;
import visad.collab.CollabUtil;
import visad.util.ThreadPool;

public abstract class ActionImpl
implements Action,
Runnable {
    private static transient ThreadPool pool = null;
    private static Object poolLock = new Object();
    private boolean enabled = true;
    private Object lockEnabled = new Object();
    private Thread currentActionThread = null;
    String Name;
    private transient Vector LinkVector = new Vector();
    private long link_id;
    private boolean requeue = false;
    Enumeration run_links = null;

    private static void startThreadPool() {
        Object object = poolLock;
        synchronized (object) {
            if (pool == null) {
                try {
                    pool = new ThreadPool("ActionThread");
                }
                catch (Exception exception) {
                    System.err.println(exception.getClass().getName() + ": " + exception.getMessage());
                    System.exit(1);
                }
            }
        }
    }

    public static void stopThreadPool() {
        if (pool != null) {
            pool.stopThreads();
            pool = null;
        }
    }

    public static void setThreadPoolMaximum(int n) throws Exception {
        if (pool == null) {
            ActionImpl.startThreadPool();
        }
        pool.setThreadMaximum(n);
    }

    public void stop() {
        if (this.LinkVector == null) {
            return;
        }
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration enumeration = this.LinkVector.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceActionLink referenceActionLink = (ReferenceActionLink)enumeration.nextElement();
                try {
                    referenceActionLink.getThingReference().removeThingChangedListener(referenceActionLink.getAction());
                }
                catch (RemoteException remoteException) {
                }
                catch (VisADException visADException) {
                    // empty catch block
                }
            }
            this.LinkVector.removeAllElements();
        }
        if (pool != null) {
            pool.queue(this);
        }
        this.run_links = null;
    }

    synchronized long getLinkId() {
        long l = this.link_id++;
        return l;
    }

    private void setTicks() {
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration enumeration = this.LinkVector.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceActionLink referenceActionLink = (ReferenceActionLink)enumeration.nextElement();
                referenceActionLink.setTicks();
            }
        }
    }

    public boolean checkTicks() {
        boolean bl = false;
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration enumeration = this.LinkVector.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceActionLink referenceActionLink = (ReferenceActionLink)enumeration.nextElement();
                bl |= referenceActionLink.checkTicks();
            }
        }
        return bl;
    }

    private void resetTicks() {
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration enumeration = this.LinkVector.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceActionLink referenceActionLink = (ReferenceActionLink)enumeration.nextElement();
                referenceActionLink.resetTicks();
            }
        }
    }

    public void enableAction() {
        this.enabled = true;
        this.notifyAction();
    }

    public void disableAction() {
        this.enabled = false;
        Object object = this.lockEnabled;
        synchronized (object) {
            this.enabled = false;
        }
    }

    public boolean setEnabled(boolean bl) {
        boolean bl2;
        Object object = this.lockEnabled;
        synchronized (object) {
            bl2 = this.enabled;
            if (bl && !bl2) {
                this.enableAction();
            } else if (!bl && bl2) {
                this.disableAction();
            }
        }
        return bl2;
    }

    public Thread getCurrentActionThread() {
        return this.currentActionThread;
    }

    void handleRunDisconnectException(ReferenceActionLink referenceActionLink) {
        this.LinkVector.removeElement(referenceActionLink);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        this.currentActionThread = Thread.currentThread();
        var1_1 = this.lockEnabled;
        synchronized (var1_1) {
            block16: {
                if (!this.enabled) break block16;
                try {
                    this.setTicks();
                    if (this.checkTicks()) {
                        this.doAction();
                    }
                    var3_2 = this.LinkVector;
                    synchronized (var3_2) {
                        this.run_links = ((Vector)this.LinkVector.clone()).elements();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4, 5] lbl14 : MonitorExitStatement: MONITOREXIT : var3_2
                        if (true) ** GOTO lbl31
                    }
                    do {
                        var5_5 = (ReferenceActionLink)this.run_links.nextElement();
                        try {
                            var6_6 = var5_5.getThingChangedEvent();
                        }
                        catch (RemoteException var7_7) {
                            if (!CollabUtil.isDisconnectException(var7_7)) {
                                throw var7_7;
                            }
                            this.handleRunDisconnectException(var5_5);
                            var6_6 = null;
                        }
                        if (var6_6 == null) continue;
                        this.thingChanged(var6_6);
lbl31:
                        // 3 sources

                    } while (this.run_links.hasMoreElements());
                    this.run_links = null;
                    this.resetTicks();
                }
                catch (VisADException var3_3) {
                    var3_3.printStackTrace();
                    throw new VisADError("Action.run: " + var3_3.toString());
                }
                catch (RemoteException var3_4) {
                    var3_4.printStackTrace();
                    throw new VisADError("Action.run: " + var3_4.toString());
                }
            }
            if (this.requeue) {
                if (ActionImpl.pool != null) {
                    ActionImpl.pool.queue(this);
                }
                this.requeue = false;
            }
        }
        this.currentActionThread = null;
    }

    public abstract void doAction() throws VisADException, RemoteException;

    public boolean thingChanged(ThingChangedEvent thingChangedEvent) throws VisADException, RemoteException {
        long l = thingChangedEvent.getId();
        ReferenceActionLink referenceActionLink = this.findLink(l);
        boolean bl = true;
        if (referenceActionLink != null) {
            referenceActionLink.acknowledgeThingChangedEvent(thingChangedEvent.getTick());
            this.notifyAction();
            bl = false;
        }
        return bl;
    }

    void addLink(ReferenceActionLink referenceActionLink) throws VisADException, RemoteException {
        ThingReference thingReference = referenceActionLink.getThingReference();
        if (this.findReference(thingReference) != null) {
            throw new ReferenceException("Action.addLink: link to ThingReference already exists");
        }
        thingReference.addThingChangedListener(referenceActionLink.getAction(), referenceActionLink.getId());
        if (this.LinkVector == null) {
            this.LinkVector = new Vector();
        }
        Vector vector = this.LinkVector;
        synchronized (vector) {
            this.LinkVector.addElement(referenceActionLink);
        }
    }

    void notifyAction() {
        this.requeue = true;
        if (pool == null) {
            ActionImpl.startThreadPool();
        }
        pool.queue(this);
    }

    public void waitForTasks() {
        if (pool != null) {
            pool.waitForTasks();
        }
    }

    public void addReference(ThingReference thingReference) throws VisADException, RemoteException {
        if (!(thingReference instanceof ThingReferenceImpl)) {
            throw new RemoteVisADException("ActionImpl.addReference: requires ThingReferenceImpl");
        }
        if (this.findReference(thingReference) != null) {
            throw new ReferenceException("ActionImpl.addReference: link already exists");
        }
        this.addLink(new ReferenceActionLink(thingReference, this, this, this.getLinkId()));
        this.notifyAction();
    }

    void adaptedAddReference(RemoteThingReference remoteThingReference, Action action) throws VisADException, RemoteException {
        if (this.findReference(remoteThingReference) != null) {
            throw new ReferenceException("ActionImpl.adaptedAddReference: link already exists");
        }
        this.addLink(new ReferenceActionLink(remoteThingReference, this, action, this.getLinkId()));
        this.notifyAction();
    }

    public void removeReference(ThingReference thingReference) throws VisADException, RemoteException {
        ReferenceActionLink referenceActionLink = null;
        if (!(thingReference instanceof ThingReferenceImpl)) {
            throw new RemoteVisADException("ActionImpl.removeReference: requires ThingReferenceImpl");
        }
        if (this.LinkVector != null) {
            Vector vector = this.LinkVector;
            synchronized (vector) {
                referenceActionLink = this.findReference(thingReference);
                if (referenceActionLink == null) {
                    throw new ReferenceException("ActionImpl.removeReference: ThingReference not linked");
                }
                this.LinkVector.removeElement(referenceActionLink);
            }
        }
        if (referenceActionLink != null) {
            thingReference.removeThingChangedListener(referenceActionLink.getAction());
        }
        this.notifyAction();
    }

    void adaptedRemoveReference(RemoteThingReference remoteThingReference) throws VisADException, RemoteException {
        ReferenceActionLink referenceActionLink = null;
        if (this.LinkVector != null) {
            Vector vector = this.LinkVector;
            synchronized (vector) {
                referenceActionLink = this.findReference(remoteThingReference);
                if (referenceActionLink == null) {
                    throw new ReferenceException("ActionImpl.adaptedRemoveReference: ThingReference not linked");
                }
                this.LinkVector.removeElement(referenceActionLink);
            }
        }
        if (referenceActionLink != null) {
            remoteThingReference.removeThingChangedListener(referenceActionLink.getAction());
        }
        this.notifyAction();
    }

    public void removeAllReferences() throws VisADException, RemoteException {
        Object object;
        Vector vector = null;
        if (this.LinkVector != null) {
            object = this.LinkVector;
            synchronized (object) {
                vector = (Vector)this.LinkVector.clone();
                this.LinkVector.removeAllElements();
            }
        }
        if (vector != null) {
            object = vector.elements();
            while (object.hasMoreElements()) {
                ReferenceActionLink referenceActionLink = (ReferenceActionLink)object.nextElement();
                ThingReference thingReference = referenceActionLink.getThingReference();
                thingReference.removeThingChangedListener(referenceActionLink.getAction());
            }
        }
        this.notifyAction();
    }

    void removeLinks(ReferenceActionLink[] referenceActionLinkArray) throws VisADException, RemoteException {
        if (this.LinkVector != null) {
            Vector vector = this.LinkVector;
            synchronized (vector) {
                int n = 0;
                while (n < referenceActionLinkArray.length) {
                    if (!this.LinkVector.removeElement(referenceActionLinkArray[n])) {
                        referenceActionLinkArray[n] = null;
                    }
                    ++n;
                }
            }
        }
        int n = 0;
        while (n < referenceActionLinkArray.length) {
            block10: {
                if (referenceActionLinkArray[n] != null) {
                    ThingReference thingReference = referenceActionLinkArray[n].getThingReference();
                    try {
                        thingReference.removeThingChangedListener(referenceActionLinkArray[n].getAction());
                    }
                    catch (RemoteException remoteException) {
                        if (CollabUtil.isDisconnectException(remoteException)) break block10;
                        throw remoteException;
                    }
                }
            }
            ++n;
        }
        this.notifyAction();
    }

    ReferenceActionLink findLink(long l) throws VisADException {
        if (this.LinkVector == null) {
            return null;
        }
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration enumeration = this.LinkVector.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceActionLink referenceActionLink = (ReferenceActionLink)enumeration.nextElement();
                if (l != referenceActionLink.getId()) continue;
                ReferenceActionLink referenceActionLink2 = referenceActionLink;
                Object var4_6 = null;
                return referenceActionLink2;
            }
        }
        return null;
    }

    public ReferenceActionLink findReference(ThingReference thingReference) throws VisADException {
        if (thingReference == null) {
            throw new ReferenceException("ActionImpl.findReference: ThingReference cannot be null");
        }
        if (this.LinkVector == null) {
            return null;
        }
        Vector vector = this.LinkVector;
        synchronized (vector) {
            Enumeration enumeration = this.LinkVector.elements();
            while (enumeration.hasMoreElements()) {
                ReferenceActionLink referenceActionLink = (ReferenceActionLink)enumeration.nextElement();
                if (!thingReference.equals(referenceActionLink.getThingReference())) continue;
                ReferenceActionLink referenceActionLink2 = referenceActionLink;
                Object var3_6 = null;
                return referenceActionLink2;
            }
        }
        return null;
    }

    public Vector getLinks() {
        return (Vector)this.LinkVector.clone();
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String string) {
        this.Name = string;
    }

    public ActionImpl(String string) {
        if (pool == null) {
            ActionImpl.startThreadPool();
        }
        this.Name = string;
        this.link_id = 0L;
    }
}

